/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.system_info_builder;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalSystemInterpreterInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.ModulesFoundStructure;
import org.python.pydev.editor.codecompletion.revisited.ModulesKeyTreeMap;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.SystemModulesManager;
import org.python.pydev.logging.DebugSettings;
import org.python.pydev.ui.pythonpathconf.IInterpreterInfoBuilder;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public class InterpreterInfoBuilder
implements IInterpreterInfoBuilder {
    private InterpreterInfo info;
    private boolean disposed;
    private static final InterpreterBuilderJob builderJob = new InterpreterBuilderJob();

    boolean isDisposed() {
        return this.disposed;
    }

    public void dispose() {
        this.disposed = true;
    }

    public void setInfo(InterpreterInfo info) {
        this.setInfo(info, 20000);
    }

    public void setInfo(InterpreterInfo info, int schedule) {
        this.info = info;
        builderJob.buildersToCheck.add(this);
        builderJob.schedule(schedule);
    }

    static class InterpreterBuilderJob
    extends Job {
        private volatile Set<InterpreterInfoBuilder> buildersToCheck = new HashSet<InterpreterInfoBuilder>();

        public InterpreterBuilderJob() {
            super("InterpreterBuilderJob");
            this.setPriority(40);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                Log.toLogFile((Object)((Object)this), (String)"--- Start run");
            }
            Set<InterpreterInfoBuilder> builders = this.buildersToCheck;
            this.buildersToCheck = new HashSet<InterpreterInfoBuilder>();
            for (InterpreterInfoBuilder builder : builders) {
                IStatus ret = this.checkEarlyReturn(monitor, builder);
                if (ret != null) continue;
                PythonPathHelper pythonPathHelper = new PythonPathHelper();
                pythonPathHelper.setPythonPath(((InterpreterInfoBuilder)builder).info.libs);
                ModulesFoundStructure modulesFound = pythonPathHelper.getModulesFoundStructure(monitor);
                ret = this.checkEarlyReturn(monitor, builder);
                if (ret != null) continue;
                SystemModulesManager modulesManager = (SystemModulesManager)builder.info.getModulesManager();
                ModulesKeyTreeMap keysFound = modulesManager.buildKeysFromModulesFound(monitor, modulesFound);
                if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                    Log.toLogFile((Object)((Object)this), (String)StringUtils.format((String)"Found: %s modules", (Object[])new Object[]{keysFound.size()}));
                }
                if ((ret = this.checkEarlyReturn(monitor, builder)) != null) continue;
                Tuple diffModules = modulesManager.diffModules(keysFound);
                if (((List)diffModules.o1).size() <= 0 && ((List)diffModules.o2).size() <= 0) continue;
                if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                    Log.toLogFile((Object)((Object)this), (String)StringUtils.format((String)"Diff modules. Added: %s Removed: %s", (Object[])new Object[]{diffModules.o1, diffModules.o2}));
                }
                modulesManager.updateKeysAndSave(keysFound);
                IInterpreterManager manager = builder.info.getModulesManager().getInterpreterManager();
                try {
                    AbstractAdditionalDependencyInfo additionalSystemInfo = AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, builder.info.getExecutableOrJar());
                    additionalSystemInfo.updateKeysIfNeededAndSave((ModulesKeyTreeMap<ModulesKey, ModulesKey>)keysFound);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                Log.toLogFile((Object)((Object)this), (String)"--- End Run");
            }
            return Status.OK_STATUS;
        }

        public IStatus checkEarlyReturn(IProgressMonitor monitor, InterpreterInfoBuilder builder) {
            if (builder.isDisposed()) {
                if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                    Log.toLogFile((Object)((Object)this), (String)"Disposed");
                }
                return Status.OK_STATUS;
            }
            if (monitor.isCanceled()) {
                if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                    Log.toLogFile((Object)((Object)this), (String)"Cancelled");
                }
                return Status.OK_STATUS;
            }
            if (!builder.info.getLoadFinished()) {
                if (DebugSettings.DEBUG_INTERPRETER_AUTO_UPDATE) {
                    Log.toLogFile((Object)((Object)this), (String)"Load not finished (rescheduling)");
                }
                this.buildersToCheck.add(builder);
                builderJob.schedule(20000L);
                return Status.OK_STATUS;
            }
            return null;
        }
    }
}

