/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AttrInfo;
import com.python.pydev.analysis.additionalinfo.ClassInfo;
import com.python.pydev.analysis.additionalinfo.FuncInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.analysis.additionalinfo.NameInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.python.pydev.core.ObjectsPool;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoStrFactory {
    public static String infoToString(List<IInfo> iInfo) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        FastStringBuffer infos = new FastStringBuffer();
        int next = 0;
        map.put(null, next);
        ++next;
        for (IInfo info : iInfo) {
            infos.append("&&");
            infos.append(info.getType());
            String name = info.getName();
            String declaringModuleName = info.getDeclaringModuleName();
            String path = info.getPath();
            next = InfoStrFactory.add(map, infos, next, name);
            next = InfoStrFactory.add(map, infos, next, declaringModuleName);
            next = InfoStrFactory.add(map, infos, next, path);
        }
        FastStringBuffer header = new FastStringBuffer("INFOS:", map.size() * 30);
        Set entrySet = map.entrySet();
        header.append(infos);
        header.append('\n');
        map.remove(null);
        for (Map.Entry entry : entrySet) {
            header.append((String)entry.getKey());
            header.append("=");
            header.append(((Integer)entry.getValue()).intValue());
            header.append("\n");
        }
        return header.toString();
    }

    private static int add(HashMap<String, Integer> map, FastStringBuffer infos, int next, String d) {
        Integer v = map.get(d);
        if (v == null) {
            v = next;
            map.put(d, next);
            ++next;
        }
        infos.append("|");
        infos.append(v.intValue());
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IInfo> strToInfo(String s) {
        if (!s.startsWith("INFOS:")) {
            return null;
        }
        Iterable iterLines = StringUtils.iterLines((String)(s = s.substring(6)));
        Iterator linesIt = iterLines.iterator();
        if (!linesIt.hasNext()) {
            return null;
        }
        String firstLine = ((String)linesIt.next()).trim();
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(0, null);
        Object object = ObjectsPool.lock;
        synchronized (object) {
            while (linesIt.hasNext()) {
                String line = ((String)linesIt.next()).trim();
                int i = StringUtils.rFind((String)line, (char)'=');
                if (i <= 0) continue;
                String token = line.substring(0, i);
                String value = line.substring(i + 1);
                map.put(Integer.parseInt(value), ObjectsPool.internUnsynched((String)token));
            }
        }
        ArrayList<IInfo> ret = new ArrayList<IInfo>();
        List split = StringUtils.split((String)firstLine, (String)"&&");
        for (String string : split) {
            List parts = StringUtils.split((String)string, (char)'|');
            int type = Integer.parseInt((String)parts.get(0));
            int name = Integer.parseInt((String)parts.get(1));
            int declaringModuleName = Integer.parseInt((String)parts.get(2));
            int path = Integer.parseInt((String)parts.get(3));
            switch (type) {
                case 4: {
                    ret.add(new NameInfo((String)map.get(name), (String)map.get(declaringModuleName), (String)map.get(path), true));
                    break;
                }
                case 3: {
                    ret.add(new AttrInfo((String)map.get(name), (String)map.get(declaringModuleName), (String)map.get(path), true));
                    break;
                }
                case 2: {
                    ret.add(new FuncInfo((String)map.get(name), (String)map.get(declaringModuleName), (String)map.get(path), true));
                    break;
                }
                case 1: {
                    ret.add(new ClassInfo((String)map.get(name), (String)map.get(declaringModuleName), (String)map.get(path), true));
                }
            }
        }
        return ret;
    }
}

