/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.analysis.additionalinfo.InfoStrFactory;
import java.io.File;
import java.util.List;
import org.python.pydev.core.DeltaSaver;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.parser.jython.SimpleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAdditionalInfoWithBuild
extends AbstractAdditionalDependencyInfo
implements IDeltaProcessor<Object> {
    public static final int MAXIMUN_NUMBER_OF_DELTAS = 50;
    protected DeltaSaver<Object> deltaSaver;

    public AbstractAdditionalInfoWithBuild(boolean callInit) throws MisconfigurationException {
        super(callInit);
    }

    @Override
    protected void init() throws MisconfigurationException {
        super.init();
        this.deltaSaver = this.createDeltaSaver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDeltaSize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.deltaSaver.availableDeltas() > 50) {
                this.save();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInfoFromModule(String moduleName, boolean generateDelta) {
        Object object = this.lock;
        synchronized (object) {
            super.removeInfoFromModule(moduleName, generateDelta);
            if (generateDelta) {
                this.deltaSaver.addDeleteCommand((Object)moduleName);
                this.checkDeltaSize();
            }
        }
    }

    @Override
    public List<IInfo> addAstInfo(SimpleNode node, ModulesKey key, boolean generateDelta) {
        List<IInfo> addAstInfo = super.addAstInfo(node, key, generateDelta);
        if (generateDelta && addAstInfo.size() > 0) {
            this.deltaSaver.addInsertCommand((Object)new Tuple((Object)key, addAstInfo));
            this.checkDeltaSize();
        }
        return addAstInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void restoreSavedInfo(Object o) throws MisconfigurationException {
        Object object = this.lock;
        synchronized (object) {
            super.restoreSavedInfo(o);
            if (this.deltaSaver.availableDeltas() > 0) {
                this.deltaSaver.processDeltas((IDeltaProcessor)this);
            }
        }
    }

    protected DeltaSaver<Object> createDeltaSaver() {
        return new DeltaSaver(this.getPersistingFolder(), "v1_projectinfodelta", (ICallback)new ICallback<Object, String>(){

            public Object call(String arg) {
                if (arg.startsWith("STR")) {
                    return arg.substring(3);
                }
                if (arg.startsWith("TUP")) {
                    String tup = arg.substring(3);
                    int i = tup.indexOf(10);
                    int j = tup.indexOf(10, i + 1);
                    String modName = new String(tup.substring(0, i));
                    File file = new File(tup.substring(i + 1, j));
                    return new Tuple((Object)new ModulesKey(modName, file), InfoStrFactory.strToInfo(tup.substring(j + 1)));
                }
                if (arg.startsWith("LST")) {
                    return InfoStrFactory.strToInfo(arg.substring(3));
                }
                throw new AssertionError((Object)"Expecting string starting with STR or LST");
            }
        }, (ICallback)new ICallback<String, Object>(){

            public String call(Object arg) {
                if (arg instanceof String) {
                    return "STR" + (String)arg;
                }
                if (arg instanceof Tuple) {
                    Tuple tuple = (Tuple)arg;
                    if (tuple.o1 instanceof ModulesKey && tuple.o2 instanceof List) {
                        ModulesKey modName = (ModulesKey)tuple.o1;
                        List l = (List)tuple.o2;
                        String infoToString = InfoStrFactory.infoToString(l);
                        String fileStr = modName.file.toString();
                        FastStringBuffer buf = new FastStringBuffer("TUP", modName.name.length() + fileStr.length() + infoToString.length() + 3);
                        buf.append(modName.name);
                        buf.append('\n');
                        buf.append(fileStr);
                        buf.append('\n');
                        buf.append(infoToString);
                        return buf.toString();
                    }
                }
                throw new AssertionError((Object)("Expecting Tuple<String, List<IInfo>> or String. Found: " + arg));
            }
        });
    }

    public void processUpdate(Object data) {
        throw new RuntimeException("There is no update generation, only add.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDelete(Object data) {
        Object object = this.lock;
        synchronized (object) {
            this.removeInfoFromModule((String)data, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInsert(Object data) {
        Object object = this.lock;
        synchronized (object) {
            if (data instanceof Tuple) {
                this.addInfoToModuleOnRestoreInsertCommand((Tuple<ModulesKey, List<IInfo>>)((Tuple)data));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endProcessing() {
        Object object = this.lock;
        synchronized (object) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        Object object = this.lock;
        synchronized (object) {
            super.save();
            this.deltaSaver.clearAll();
        }
    }
}

