#include <jni.h>
#include "net_sourceforge_dvb_projectx_video_IDCTFast.h"
#include "idct.h"
#include <stdio.h>

/*
 * Class:     IDCTFast
 * Method:    referenceIDCT
 * Signature: ([S)V
 */
JNIEXPORT void JNICALL Java_net_sourceforge_dvb_projectx_video_IDCTFast_referenceIDCT
  (JNIEnv *env, jobject obj, jshortArray arr)
{
	short *localArrayCopy;
	
	localArrayCopy =(short *)(*env)->GetShortArrayElements(env, arr, JNI_FALSE);
	IDCT_reference(localArrayCopy);
	(*env)->ReleaseShortArrayElements(env, arr, localArrayCopy, 0);
}

JNIEXPORT void JNICALL Java_net_sourceforge_dvb_projectx_video_IDCTFast_init
  (JNIEnv *env, jobject obj)
{
  IDCT_init();
}
