/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.xinput;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.xinput.ftp.XInputFileImpl;

public class XInputStream
extends FilterInputStream {
    private boolean debug = false;
    private byte[] buffer = new byte[1];
    private XInputFileImpl xInputFile = null;

    public XInputStream(InputStream inputStream) {
        super(Common.getSettings().getBooleanProperty(Keys.KEY_additionalInputBuffer) ? new BufferedInputStream(inputStream, 0x100000) : inputStream);
    }

    public final void close() throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputStream.close()");
        }
        if (this.xInputFile != null) {
            this.xInputFile.randomAccessClose();
            this.xInputFile = null;
        }
        super.close();
        if (this.debug) {
            System.out.println("Leave XInputStream.close()");
        }
    }

    public final int read() throws IOException {
        if (this.read(this.buffer, 0, 1) == 1) {
            return this.buffer[0];
        }
        return -1;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        long l;
        block11: {
            int n4;
            block10: {
                if (this.debug) {
                    System.out.println("Enter XInputStream.read(" + byArray + ", " + n + ", " + n2 + ")");
                }
                int n5 = 0;
                long l2 = 0L;
                l = 0L;
                long l3 = n2;
                long l4 = 0L;
                try {
                    do {
                        l2 = super.read(byArray, (int)((long)n + l), (int)l3);
                        if (this.debug) {
                            System.out.println("    Bytes read in this cycle: " + l2);
                        }
                        if (l2 > 0L) {
                            l += l2;
                            l3 -= l2;
                        }
                        if (l2 == 0L) {
                            ++l4;
                            continue;
                        }
                        l4 = 0L;
                    } while (l3 > 0L && l2 != -1L && l4 <= 100L);
                    n5 = (int)((long)n2 - l3);
                    if (l2 == -1L && n5 == 0) {
                        if (this.debug) {
                            System.out.println("Leave XInputStream.read(aBuffer,off,len) returning -1");
                        }
                        n4 = -1;
                        Object var15_11 = null;
                        if (!this.debug) return n4;
                        break block10;
                    }
                    if (this.debug) {
                        System.out.println("Leave XInputStream.read(aBuffer,off,len) returning " + n5);
                    }
                    n3 = n5;
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var15_13 = null;
                    if (!this.debug) throw throwable;
                    if (l == (long)n2) throw throwable;
                    System.out.println("********** ATTENTION! Bytes to read: " + n2 + ", Read: " + l + ", Difference: " + ((long)n2 - l) + "**********");
                    throw throwable;
                }
            }
            if (l == (long)n2) return n4;
            System.out.println("********** ATTENTION! Bytes to read: " + n2 + ", Read: " + l + ", Difference: " + ((long)n2 - l) + "**********");
            return n4;
        }
        Object var15_12 = null;
        if (!this.debug) return n3;
        if (l == (long)n2) return n3;
        System.out.println("********** ATTENTION! Bytes to read: " + n2 + ", Read: " + l + ", Difference: " + ((long)n2 - l) + "**********");
        return n3;
    }

    public void setFtpFile(XInputFileImpl xInputFileImpl) {
        this.xInputFile = xInputFileImpl;
    }

    public final long skip(long l) throws IOException {
        if (this.debug) {
            System.out.println("Enter XInputStream.skip(" + l + ")");
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = l;
        try {
            do {
                l3 = super.skip(l5);
                if (this.debug) {
                    System.out.println("    Bytes skiped in this cycle: " + l3);
                }
                l4 += l3;
                l5 -= l3;
                if (l3 == 0L) {
                    ++l2;
                    continue;
                }
                l2 = 0L;
            } while (l5 > 0L && l2 <= 100L);
            if (this.debug) {
                System.out.println("Leave XInputStream.skip(" + l + ") returning " + l4);
            }
            long l6 = l4;
            Object var14_7 = null;
            if (this.debug && l4 != l) {
                System.out.println("********** ATTENTION! Bytes to skip: " + l + ", Skiped: " + l4 + ", Difference: " + (l - l4) + "**********");
            }
            return l6;
        }
        catch (Throwable throwable) {
            block8: {
                Object var14_8 = null;
                if (!this.debug || l4 == l) break block8;
                System.out.println("********** ATTENTION! Bytes to skip: " + l + ", Skiped: " + l4 + ", Difference: " + (l - l4) + "**********");
            }
            throw throwable;
        }
    }
}

