/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.subtitle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.subtitle.CharSet;

public class Teletext {
    private Hashtable page_modifications = new Hashtable();
    private boolean use = false;
    private int display_row = 0;
    private int display_column = 0;
    private short[] active_set;
    private short[] active_national_set;
    private final String[] ssaHeader = new String[]{"[Script Info]", "; This is a Sub Station Alpha v4 script.", "; For Sub Station Alpha info and downloads,", "; go to http://www.eswat.demon.co.uk/", "; or email kotus@eswat.demon.co.uk", "; to burn-in these subtitles into an AVI, just install subtitler2.3 PlugIn for VirtualDub, see doom9.org", "Title: Subtitles taken from TV teletext", "Original Script: by their respective owner", "ScriptType: v4.00", "Collisions: Normal", "PlayResY: 240", "PlayDepth: 0", "Timer: 100.0000", "[V4 Styles]", "Format: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, TertiaryColour, BackColour, Bold, Italic, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, AlphaLevel, Encoding", "Style: MainB,Arial,14,&H00FFFF,&H00FFFF,&H00FFFF,0,0,-1,1,2,4,1,16,16,16,0,0", "Style: MainT,Arial,14,&HFFFFFF,&HFFFFFF,&HFFFFFF,0,1,0,1,2,4,1,16,16,16,0,0", "Style: MainI,Arial,14,&HFFFFFF,&HFFFFFF,&HFFFFFF,0,1,1,1,2,4,1,16,16,16,0,0", "Style: MainC,Courier New,14,&HFFFFFF,&HFFFFFF,&HFFFFFF,0,1,0,1,2,4,1,16,16,16,0,0", "[Events]", "Format: Marked, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text", "Comment: Marked=0,0:00:00.00,0:00:00.01,MainB,,0000,0000,0000,!Effect,This script was created by decoding a tv teletext stream to build coloured subtitles"};
    private final String[] ssaLine = new String[]{"Dialogue: Marked=0,", ",MainT,,0000,0000,0000,!Effect,{\\q2\\a2}"};
    private final String[] stlHeader = new String[]{"", "//Font select and font size", "$FontName   = Arial", "$FontSize   = 30", "//Character attributes (global)", "$Bold    = FALSE", "$UnderLined = FALSE", "$Italic  = FALSE", "//Position Control", "$HorzAlign = Center", "$VertAlign = Bottom", "$XOffset   = 10", "$YOffset   = 10", "//Contrast Control", "$TextContrast        = 15", "$Outline1Contrast    = 8", "$Outline2Contrast    = 15", "$BackgroundContrast  = 0", "//Effects Control", "$ForceDisplay = FALSE", "$FadeIn   = 0", "$FadeOut  = 0", "//Other Controls", "$TapeOffset = FALSE", "//Colors", "$ColorIndex1 = 0", "$ColorIndex2 = 1", "$ColorIndex3 = 2", "$ColorIndex4 = 3", "//Subtitles"};
    private final String[] sonHeader = new String[]{"st_format\t2", "Display_Start\tnon_forced", "TV_Type\t\tPAL", "Tape_Type\tNON_DROP", "Pixel_Area\t(0 575)", "Directory\t", "", "SP_NUMBER\tSTART\t\tEND\t\tFILE_NAME"};
    private final String[] colors = new String[]{"{\\c&HC0C0C0&}", "{\\c&H4040FF&}", "{\\c&H00FF00&}", "{\\c&H00FFFF&}", "{\\c&HFF409B&}", "{\\c&HFF00FF&}", "{\\c&HFFFF00&}", "{\\c&HFFFFFF&}"};
    private byte[] hamming_8_4_values = new byte[]{-88, 11, 38, -123, -110, 49, 28, -65, 64, -29, -50, 109, 122, -39, -12, 87};
    private byte[] TTX_TS_Packet;
    private byte[][][] TTX_Row;
    private byte[] TTX_Heading150Row;
    private byte[] TTX_PaddingRow;
    private Hashtable mapping_table;

    public Teletext() {
        byte[] byArray = new byte[188];
        byArray[0] = 71;
        byArray[1] = 64;
        byArray[2] = -97;
        byArray[3] = 16;
        byArray[6] = 1;
        byArray[7] = -67;
        byArray[9] = -78;
        byArray[10] = -124;
        byArray[11] = -128;
        byArray[12] = 36;
        byArray[13] = -1;
        byArray[14] = -1;
        byArray[15] = -1;
        byArray[16] = -1;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = -1;
        byArray[20] = -1;
        byArray[21] = -1;
        byArray[22] = -1;
        byArray[23] = -1;
        byArray[24] = -1;
        byArray[25] = -1;
        byArray[26] = -1;
        byArray[27] = -1;
        byArray[28] = -1;
        byArray[29] = -1;
        byArray[30] = -1;
        byArray[31] = -1;
        byArray[32] = -1;
        byArray[33] = -1;
        byArray[34] = -1;
        byArray[35] = -1;
        byArray[36] = -1;
        byArray[37] = -1;
        byArray[38] = -1;
        byArray[39] = -1;
        byArray[40] = -1;
        byArray[41] = -1;
        byArray[42] = -1;
        byArray[43] = -1;
        byArray[44] = -1;
        byArray[45] = -1;
        byArray[46] = -1;
        byArray[47] = -1;
        byArray[48] = -1;
        byArray[49] = 16;
        byArray[50] = 2;
        byArray[51] = 44;
        byArray[52] = -25;
        byArray[53] = -28;
        byArray[54] = 64;
        byArray[55] = -88;
        byArray[56] = -88;
        byArray[57] = -88;
        byArray[58] = -88;
        byArray[59] = 11;
        byArray[60] = -88;
        byArray[61] = -88;
        byArray[62] = -88;
        byArray[63] = 64;
        byArray[64] = 4;
        byArray[65] = 4;
        byArray[66] = 4;
        byArray[67] = 4;
        byArray[68] = 4;
        byArray[69] = 4;
        byArray[70] = 4;
        byArray[71] = 4;
        byArray[72] = 4;
        byArray[73] = 4;
        byArray[74] = 4;
        byArray[75] = 4;
        byArray[76] = 4;
        byArray[77] = 4;
        byArray[78] = 4;
        byArray[79] = 4;
        byArray[80] = 4;
        byArray[81] = 4;
        byArray[82] = 4;
        byArray[83] = 4;
        byArray[84] = 4;
        byArray[85] = 4;
        byArray[86] = 4;
        byArray[87] = 4;
        byArray[88] = 4;
        byArray[89] = 4;
        byArray[90] = 4;
        byArray[91] = 4;
        byArray[92] = 4;
        byArray[93] = 4;
        byArray[94] = 4;
        byArray[95] = 4;
        byArray[96] = 2;
        byArray[97] = 44;
        byArray[98] = -24;
        byArray[99] = -28;
        byArray[100] = 64;
        byArray[101] = -88;
        byArray[102] = -88;
        byArray[103] = -88;
        byArray[104] = -88;
        byArray[105] = 11;
        byArray[106] = -88;
        byArray[107] = -88;
        byArray[108] = -88;
        byArray[109] = 64;
        byArray[110] = 4;
        byArray[111] = 4;
        byArray[112] = 4;
        byArray[113] = 4;
        byArray[114] = 4;
        byArray[115] = 4;
        byArray[116] = 4;
        byArray[117] = 4;
        byArray[118] = 4;
        byArray[119] = 4;
        byArray[120] = 4;
        byArray[121] = 4;
        byArray[122] = 4;
        byArray[123] = 4;
        byArray[124] = 4;
        byArray[125] = 4;
        byArray[126] = 4;
        byArray[127] = 4;
        byArray[128] = 4;
        byArray[129] = 4;
        byArray[130] = 4;
        byArray[131] = 4;
        byArray[132] = 4;
        byArray[133] = 4;
        byArray[134] = 4;
        byArray[135] = 4;
        byArray[136] = 4;
        byArray[137] = 4;
        byArray[138] = 4;
        byArray[139] = 4;
        byArray[140] = 4;
        byArray[141] = 4;
        byArray[142] = 2;
        byArray[143] = 44;
        byArray[144] = -23;
        byArray[145] = -28;
        byArray[146] = 64;
        byArray[147] = -88;
        byArray[148] = -88;
        byArray[149] = -88;
        byArray[150] = -88;
        byArray[151] = 11;
        byArray[152] = -88;
        byArray[153] = -88;
        byArray[154] = -88;
        byArray[155] = 64;
        byArray[156] = 4;
        byArray[157] = 4;
        byArray[158] = 4;
        byArray[159] = 4;
        byArray[160] = 4;
        byArray[161] = 4;
        byArray[162] = 4;
        byArray[163] = 4;
        byArray[164] = 4;
        byArray[165] = 4;
        byArray[166] = 4;
        byArray[167] = 4;
        byArray[168] = 4;
        byArray[169] = 4;
        byArray[170] = 4;
        byArray[171] = 4;
        byArray[172] = 4;
        byArray[173] = 4;
        byArray[174] = 4;
        byArray[175] = 4;
        byArray[176] = 4;
        byArray[177] = 4;
        byArray[178] = 4;
        byArray[179] = 4;
        byArray[180] = 4;
        byArray[181] = 4;
        byArray[182] = 4;
        byArray[183] = 4;
        byArray[184] = 4;
        byArray[185] = 4;
        byArray[186] = 4;
        byArray[187] = 4;
        this.TTX_TS_Packet = byArray;
        this.TTX_Row = new byte[][][]{new byte[][]{{3, 44, -24, -28, 64, 49, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {3, 44, -23, -28, -29, 49, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {3, 44, -22, -28, 64, -39, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {3, 44, -21, -28, -29, -39, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}}, new byte[][]{{3, 44, -24, -28, 64, 11, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {3, 44, -23, -28, 64, -29, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {3, 44, -22, -28, 64, 49, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}, {3, 44, -21, -28, 64, -39, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4}}};
        this.TTX_Heading150Row = new byte[]{3, 44, -25, -28, 64, -88, -88, -50, -88, 11, -88, 11, 122, 64, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
        this.TTX_PaddingRow = new byte[]{-1, 44, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        this.mapping_table = new Hashtable();
    }

    public String SMPTE(String string, long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(string.substring(0, 8)) + ":00");
        String string2 = String.valueOf(Integer.parseInt(string.substring(9, 12)) / ((int)l / 90));
        stringBuffer.replace(string2.length() == 1 ? 10 : 9, 11, string2);
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public int[] buildCharArray(byte[] var1_1, int var2_2, int var3_3, int var4_4, int var5_5, boolean var6_6, boolean var7_7, boolean var8_8) {
        var9_9 = true;
        var10_10 = false;
        var11_11 = false;
        var12_12 = new int[var3_3];
        var13_13 = 7;
        var14_14 = 0;
        var15_15 = new int[]{-1, -1};
        var16_16 = Common.getSettings().getIntProperty(Keys.KEY_TtxLanguagePair) - 1;
        var17_17 = var16_16 < 0 ? 0 : var16_16;
        var18_18 = var5_5;
        var19_19 = 0;
        var20_20 = 0;
        if (this.page_modifications.containsKey("primary_set")) {
            var19_19 = var17_17 = Integer.parseInt(this.page_modifications.get("primary_set").toString());
        }
        if (this.page_modifications.containsKey("primary_national_set")) {
            var20_20 = var18_18 = Integer.parseInt(this.page_modifications.get("primary_national_set").toString());
        }
        if (this.page_modifications.containsKey("secondary_set")) {
            var19_19 = Integer.parseInt(this.page_modifications.get("secondary_set").toString());
            var20_20 = Integer.parseInt(this.page_modifications.get("secondary_national_set").toString());
        }
        this.active_set = CharSet.getActive_G0_Set(var17_17, var18_18, var4_4);
        this.active_national_set = CharSet.getActiveNationalSubset(var17_17, var18_18, var4_4);
        var21_21 = var2_2;
        var23_22 = 0;
        while (var23_22 < var3_3) {
            block42: {
                block49: {
                    block48: {
                        block47: {
                            block46: {
                                block45: {
                                    block44: {
                                        block43: {
                                            block41: {
                                                var22_23 = var4_4 << 16 | var23_22;
                                                if (!this.page_modifications.containsKey(String.valueOf(var22_23))) break block41;
                                                var12_12[var23_22] = var13_13 | this.page_modifications.get(String.valueOf(var22_23)).toString().charAt(0) << 8;
                                                break block42;
                                            }
                                            if (var6_6 && !this.cparity(var1_1[var21_21])) {
                                                ++var14_14;
                                                var1_1[var23_22] = 8;
                                            }
                                            if ((var24_24 = 127 & this.bytereverse(var1_1[var21_21])) >>> 3 != 0) break block43;
                                            var9_9 = true;
                                            var10_10 = false;
                                            var12_12[var23_22] = this.active_set[32] << 8 | var13_13;
                                            var13_13 = 240 & var13_13 | var24_24;
                                            break block42;
                                        }
                                        if (var24_24 >>> 4 != 0) break block44;
                                        if (var24_24 == 11) {
                                            var15_15[0] = var23_22;
                                        } else if (var24_24 == 10 && var15_15[1] <= var15_15[0]) {
                                            var15_15[1] = var23_22;
                                        }
                                        var12_12[var23_22] = this.active_set[32] << 8 | var13_13;
                                        break block42;
                                    }
                                    if (var24_24 >= 24) break block45;
                                    var9_9 = false;
                                    var10_10 = true;
                                    var12_12[var23_22] = this.active_set[32] << 8 | var13_13;
                                    break block42;
                                }
                                if (var24_24 >= 27) break block46;
                                var12_12[var23_22] = this.active_set[32] << 8 | var13_13;
                                break block42;
                            }
                            if (var24_24 >= 32) break block47;
                            switch (var24_24) {
                                case 27: {
                                    if (var11_11) {
                                        this.active_set = CharSet.getActive_G0_Set(var17_17, var18_18, var4_4);
                                        this.active_national_set = CharSet.getActiveNationalSubset(var17_17, var18_18, var4_4);
                                    } else {
                                        this.active_set = CharSet.getActive_G0_Set(var19_19, var20_20, var4_4);
                                        this.active_national_set = CharSet.getActiveNationalSubset(var19_19, var20_20, var4_4);
                                    }
                                    var11_11 ^= true;
                                    break;
                                }
                                case 28: {
                                    var13_13 &= 15;
                                    if (var9_9 || var10_10) break;
                                    var9_9 = true;
                                    break;
                                }
                                case 29: {
                                    var9_9 = false;
                                    var13_13 = var13_13 & 15 | (15 & var13_13) << 4;
                                }
                            }
                            var12_12[var23_22] = this.active_set[32] << 8 | var13_13;
                            break block42;
                        }
                        if (var24_24 != 127) break block48;
                        var12_12[var23_22] = this.active_set[32] << 8 | var13_13;
                        break block42;
                    }
                    if (var9_9) break block49;
                    var12_12[var23_22] = this.active_set[32] << 8 | var13_13;
                    break block42;
                }
                if (this.active_national_set == null) ** GOTO lbl-1000
                switch (var24_24) {
                    case 35: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[0] << 8;
                        break;
                    }
                    case 36: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[1] << 8;
                        break;
                    }
                    case 64: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[2] << 8;
                        break;
                    }
                    case 91: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[3] << 8;
                        break;
                    }
                    case 92: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[4] << 8;
                        break;
                    }
                    case 93: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[5] << 8;
                        break;
                    }
                    case 94: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[6] << 8;
                        break;
                    }
                    case 95: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[7] << 8;
                        break;
                    }
                    case 96: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[8] << 8;
                        break;
                    }
                    case 123: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[9] << 8;
                        break;
                    }
                    case 124: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[10] << 8;
                        break;
                    }
                    case 125: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[11] << 8;
                        break;
                    }
                    case 126: {
                        var12_12[var23_22] = var13_13 | this.active_national_set[12] << 8;
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var12_12[var23_22] = var13_13 | this.active_set[var24_24] << 8;
                    }
                }
            }
            ++var21_21;
            ++var23_22;
        }
        if (var7_7) {
            if (var15_15[0] >= 0) {
                var24_24 = 0;
                while (var24_24 < var15_15[0] && var24_24 < var12_12.length) {
                    var12_12[var24_24] = this.active_set[32] << 8 | 7;
                    ++var24_24;
                }
                var25_26 = var15_15[1];
                while (var25_26 > var15_15[0] && var25_26 < var12_12.length) {
                    var12_12[var25_26] = this.active_set[32] << 8 | 7;
                    ++var25_26;
                }
            } else {
                Arrays.fill(var12_12, this.active_set[32] << 8 | 7);
            }
        }
        var24_25 = "";
        var25_26 = 0;
        while (var25_26 < var12_12.length) {
            var24_25 = String.valueOf(var24_25) + (char)(var12_12[var25_26] >>> 8);
            ++var25_26;
        }
        if (var6_6 && var14_14 > 0) {
            var26_27 = "!> line " + var4_4 + ", parity check failed at " + var14_14 + " of " + var3_3 + " characters: '" + var24_25 + "'";
            if (var14_14 > Common.getSettings().getIntProperty(Keys.KEY_SubtitlePanel_MaxParityErrors)) {
                var24_25 = "";
                var26_27 = String.valueOf(var26_27) + ", line dropped..";
            }
            Common.setMessage(var26_27);
        }
        if ((var26_28 = var24_25.trim().length()) == 0) {
            return null;
        }
        if (var26_28 < 40 && var8_8) {
            var27_29 = 0;
            var28_30 = 0;
            while (var24_25.startsWith(" ", var27_29)) {
                ++var27_29;
            }
            var28_30 = (var12_12.length - var26_28) / 2;
            System.arraycopy(var12_12, var27_29, var12_12, var28_30, var26_28);
            Arrays.fill(var12_12, 0, var28_30, this.active_set[32] << 8 | 7);
            Arrays.fill(var12_12, var28_30 + var26_28, var12_12.length, this.active_set[32] << 8 | 7);
        }
        return var12_12;
    }

    public String buildString(byte[] byArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        return this.buildString(byArray, n, n2, n3, n4, n5, bl, false);
    }

    /*
     * Unable to fully structure code
     */
    public String buildString(byte[] var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, boolean var7_7, boolean var8_8) {
        var9_9 = true;
        var10_10 = false;
        var11_11 = false;
        var12_12 = new StringBuffer();
        var14_13 = new ArrayList<ColorIndex>();
        var15_14 = 0;
        var16_15 = new int[]{-1, -1};
        var17_16 = Common.getSettings().getIntProperty(Keys.KEY_TtxLanguagePair) - 1;
        var18_17 = var17_16 < 0 ? 0 : var17_16;
        var19_18 = var5_5;
        var20_19 = 0;
        var21_20 = 0;
        if (this.page_modifications.containsKey("primary_set")) {
            var20_19 = var18_17 = Integer.parseInt(this.page_modifications.get("primary_set").toString());
        }
        if (this.page_modifications.containsKey("primary_national_set")) {
            var21_20 = var19_18 = Integer.parseInt(this.page_modifications.get("primary_national_set").toString());
        }
        if (this.page_modifications.containsKey("secondary_set")) {
            var20_19 = Integer.parseInt(this.page_modifications.get("secondary_set").toString());
            var21_20 = Integer.parseInt(this.page_modifications.get("secondary_national_set").toString());
        }
        this.active_set = CharSet.getActive_G0_Set(var18_17, var19_18, var4_4);
        this.active_national_set = CharSet.getActiveNationalSubset(var18_17, var19_18, var4_4);
        var22_21 = var2_2;
        var24_22 = 0;
        while (var24_22 < var3_3) {
            block40: {
                block47: {
                    block46: {
                        block45: {
                            block44: {
                                block43: {
                                    block42: {
                                        block41: {
                                            block39: {
                                                var23_23 = var4_4 << 16 | var24_22;
                                                if (!this.page_modifications.containsKey(String.valueOf(var23_23))) break block39;
                                                var12_12.append(this.page_modifications.get(String.valueOf(var23_23)));
                                                break block40;
                                            }
                                            if (var7_7 && !this.cparity(var1_1[var22_21])) {
                                                ++var15_14;
                                                var1_1[var22_21] = 8;
                                            }
                                            if ((var25_24 = 127 & this.bytereverse(var1_1[var22_21])) >>> 3 != 0) break block41;
                                            var9_9 = true;
                                            var10_10 = false;
                                            if (var6_6 == 1) {
                                                var14_13.add(new ColorIndex(var24_22, var25_24));
                                            }
                                            var12_12.append((char)this.active_set[32]);
                                            break block40;
                                        }
                                        if (var25_24 >>> 4 != 0) break block42;
                                        if (var25_24 == 11) {
                                            var16_15[0] = var24_22;
                                        } else if (var25_24 == 10 && var16_15[1] <= var16_15[0]) {
                                            var16_15[1] = var24_22;
                                        }
                                        var12_12.append((char)this.active_set[32]);
                                        break block40;
                                    }
                                    if (var25_24 >= 24) break block43;
                                    var9_9 = false;
                                    var10_10 = true;
                                    var12_12.append((char)this.active_set[32]);
                                    break block40;
                                }
                                if (var25_24 >= 27) break block44;
                                var12_12.append((char)this.active_set[32]);
                                break block40;
                            }
                            if (var25_24 >= 32) break block45;
                            if (var25_24 == 27) {
                                if (var11_11) {
                                    this.active_set = CharSet.getActive_G0_Set(var18_17, var19_18, var4_4);
                                    this.active_national_set = CharSet.getActiveNationalSubset(var18_17, var19_18, var4_4);
                                } else {
                                    this.active_set = CharSet.getActive_G0_Set(var20_19, var21_20, var4_4);
                                    this.active_national_set = CharSet.getActiveNationalSubset(var20_19, var21_20, var4_4);
                                }
                                var11_11 ^= true;
                            }
                            if (var25_24 == 28 && !var9_9 && !var10_10) {
                                var9_9 = true;
                            }
                            if (var25_24 == 29) {
                                var9_9 = false;
                            }
                            var12_12.append((char)this.active_set[32]);
                            break block40;
                        }
                        if (var25_24 != 127) break block46;
                        var12_12.append((char)this.active_set[32]);
                        break block40;
                    }
                    if (var9_9) break block47;
                    var12_12.append((char)this.active_set[32]);
                    break block40;
                }
                if (this.active_national_set == null) ** GOTO lbl-1000
                switch (var25_24) {
                    case 35: {
                        var12_12.append((char)this.active_national_set[0]);
                        break;
                    }
                    case 36: {
                        var12_12.append((char)this.active_national_set[1]);
                        break;
                    }
                    case 64: {
                        var12_12.append((char)this.active_national_set[2]);
                        break;
                    }
                    case 91: {
                        var12_12.append((char)this.active_national_set[3]);
                        break;
                    }
                    case 92: {
                        var12_12.append((char)this.active_national_set[4]);
                        break;
                    }
                    case 93: {
                        var12_12.append((char)this.active_national_set[5]);
                        break;
                    }
                    case 94: {
                        var12_12.append((char)this.active_national_set[6]);
                        break;
                    }
                    case 95: {
                        var12_12.append((char)this.active_national_set[7]);
                        break;
                    }
                    case 96: {
                        var12_12.append((char)this.active_national_set[8]);
                        break;
                    }
                    case 123: {
                        var12_12.append((char)this.active_national_set[9]);
                        break;
                    }
                    case 124: {
                        var12_12.append((char)this.active_national_set[10]);
                        break;
                    }
                    case 125: {
                        var12_12.append((char)this.active_national_set[11]);
                        break;
                    }
                    case 126: {
                        var12_12.append((char)this.active_national_set[12]);
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        var12_12.append((char)this.active_set[var25_24]);
                    }
                }
            }
            ++var22_21;
            ++var24_22;
        }
        if (var7_7 && var15_14 > 0) {
            var25_25 = "!> line " + var4_4 + ", parity check failed at " + var15_14 + " of " + var3_3 + " characters: '" + var12_12.toString() + "'";
            if (var15_14 > Common.getSettings().getIntProperty(Keys.KEY_SubtitlePanel_MaxParityErrors)) {
                var12_12.setLength(0);
                var6_6 = 0;
                var25_25 = String.valueOf(var25_25) + ", line dropped..";
            }
            Common.setMessage(var25_25);
        }
        if (var8_8) {
            if (var16_15[0] >= 0 && var12_12.length() > 0) {
                var25_24 = 0;
                while (var25_24 < var16_15[0]) {
                    var12_12.setCharAt(var25_24, (char)this.active_set[32]);
                    ++var25_24;
                }
                var26_28 = var16_15[1];
                while (var26_28 > var16_15[0] && var26_28 < var12_12.length()) {
                    var12_12.setCharAt(var26_28, (char)this.active_set[32]);
                    ++var26_28;
                }
            } else {
                var12_12.setLength(0);
            }
        }
        if (var6_6 == 1 && var12_12.length() > 0) {
            var26_28 = var14_13.size() - 1;
            while (var26_28 >= 0) {
                var25_26 = (ColorIndex)var14_13.get(var26_28);
                var12_12.insert(var25_26.getIndex(), this.colors[var25_26.getColor()]);
                --var26_28;
            }
        }
        var25_27 = var12_12.toString();
        if (var6_6 == 1 && (var25_27 = var25_27.trim()).length() > 0) {
            var25_27 = String.valueOf(this.colors[7]) + var25_27;
        }
        return var25_27;
    }

    public byte bytereverse(byte by) {
        by = (byte)(by >> 1 & 0x55 | by << 1 & 0xAA);
        by = (byte)(by >> 2 & 0x33 | by << 2 & 0xCC);
        by = (byte)(by >> 4 & 0xF | by << 4 & 0xF0);
        return by;
    }

    public byte bytereverse(int n) {
        return this.bytereverse((byte)n);
    }

    private byte[] centerString(byte[] byArray, int n) {
        int n2 = 40;
        byte[] byArray2 = new byte[n2];
        int n3 = byArray.length;
        if (n3 > n2 - n) {
            n3 = n2 - n;
        }
        int n4 = n + (byArray2.length - n3) / 2;
        int n5 = n2 - n3 - n4;
        Arrays.fill(byArray2, (byte)32);
        if (n == 1) {
            byArray2[0] = 13;
        }
        while (n4 - n < 2) {
            --n5;
            if (++n4 + n3 <= 40) continue;
            --n3;
        }
        System.arraycopy(byArray, 0, byArray2, n4, n3);
        byArray2[n4 - 2] = 11;
        byArray2[n4 - 1] = 11;
        int n6 = n4 + n3;
        int n7 = 0;
        while (n6 < n2 && n7 < 2) {
            byArray2[n4 + n3] = 10;
            ++n6;
            ++n7;
        }
        return byArray2;
    }

    public void clearEnhancements() {
        this.page_modifications.clear();
        this.use = false;
        this.display_row = 0;
        this.display_column = 0;
        this.active_set = CharSet.getActive_G0_Set(0, 0, 0);
        this.active_national_set = CharSet.getActiveNationalSubset(0, 0, 0);
    }

    public boolean cparity(byte by) {
        boolean bl = true;
        if (by == 0) {
            return true;
        }
        int n = 0;
        while (n < 7) {
            if ((by >>> n & 1) == 1) {
                bl ^= true;
            }
            ++n;
        }
        if (bl && (1 & by >>> 7) == 1) {
            return true;
        }
        return !bl && (1 & by >>> 7) == 0;
    }

    public String[] getSONHead(String string, long l) {
        if (l != 3600L) {
            this.sonHeader[2] = "TV_Type\t\tNTSC";
            this.sonHeader[3] = "Tape_Type\tDROP";
        } else {
            this.sonHeader[2] = "TV_Type\t\tPAL";
            this.sonHeader[3] = "Tape_Type\tNON_DROP";
        }
        this.sonHeader[5] = "Directory\t" + string;
        return this.sonHeader;
    }

    public String[] getSSAHead() {
        return this.ssaHeader;
    }

    public String[] getSSALine() {
        return this.ssaLine;
    }

    public String[] getSTLHead(String string) {
        this.stlHeader[0] = "//Generated by " + string;
        return this.stlHeader;
    }

    public byte[] getTTXPadding_TSPacket(int n, byte[] byArray) {
        byte[] byArray2 = new byte[this.TTX_TS_Packet.length * 2];
        System.arraycopy(this.TTX_TS_Packet, 0, byArray2, 0, this.TTX_TS_Packet.length);
        System.arraycopy(this.TTX_TS_Packet, 0, byArray2, this.TTX_TS_Packet.length, this.TTX_TS_Packet.length);
        byArray2[3] = (byte)(0x10 | 0xF & n);
        byArray2[191] = (byte)(0x10 | 0xF & n + 1);
        System.arraycopy(byArray, 0, byArray2, 13, 5);
        System.arraycopy(byArray, 0, byArray2, 201, 5);
        int[] nArray = new int[]{50, 96, 142, 238, 284, 330};
        int n2 = 1;
        while (n2 < 6) {
            System.arraycopy(this.TTX_PaddingRow, 0, byArray2, nArray[n2], this.TTX_PaddingRow.length);
            ++n2;
        }
        return byArray2;
    }

    public byte[] getTTX_TSPacket(ArrayList arrayList, int n, byte[] byArray) {
        int n2;
        byte[] byArray2 = new byte[this.TTX_TS_Packet.length * 2];
        System.arraycopy(this.TTX_TS_Packet, 0, byArray2, 0, this.TTX_TS_Packet.length);
        System.arraycopy(this.TTX_TS_Packet, 0, byArray2, this.TTX_TS_Packet.length, this.TTX_TS_Packet.length);
        byArray2[3] = (byte)(0x10 | 0xF & n);
        byArray2[191] = (byte)(0x10 | 0xF & n + 1);
        System.arraycopy(byArray, 0, byArray2, 13, 5);
        System.arraycopy(byArray, 0, byArray2, 201, 5);
        int[] nArray = new int[]{50, 96, 142, 238, 284, 330};
        int n3 = 1;
        System.arraycopy(this.TTX_Heading150Row, 0, byArray2, nArray[0], this.TTX_Heading150Row.length);
        int n4 = (Integer)this.mapping_table.get("subset") << 1;
        byArray2[nArray[0] + 13] = this.hamming_8_4_values[(0xFF & this.bytereverse(n4 |= 1)) >> 4];
        int n5 = 0;
        int n6 = arrayList.size();
        while (n5 < n6) {
            byte[] byArray3 = this.setCharacterMapping(arrayList.get(n5).toString());
            byArray3 = this.centerString(byArray3, n3);
            n2 = 0;
            while (n2 < byArray3.length) {
                byArray3[n2] = this.bytereverse(this.parity(byArray3[n2]));
                ++n2;
            }
            System.arraycopy(this.TTX_Row[n3][this.TTX_Row[n3].length - n6 + n5], 0, byArray2, nArray[n5 + 1], this.TTX_Row[n3][this.TTX_Row[n3].length - n6 + n5].length);
            System.arraycopy(byArray3, 0, byArray2, nArray[n5 + 1] + 6, byArray3.length);
            ++n5;
        }
        n2 = 0;
        int n7 = 231;
        while (n2 < nArray.length) {
            byArray2[nArray[n2] + 2] = (byte)n7;
            ++n2;
            ++n7;
        }
        return byArray2;
    }

    public int hamming_24_18(byte[] byArray, int n) {
        int n2 = 0;
        n2 |= (0xFE & byArray[n + 2]) >>> 1;
        n2 |= (0xFE & byArray[n + 1]) << 6;
        n2 |= (0xE & byArray[n]) << 13;
        return n2 |= (0x20 & byArray[n]) << 12;
    }

    public int hamming_8_4(byte by) {
        switch (0xFF & by) {
            case 11: {
                return 1;
            }
            case 28: {
                return 6;
            }
            case 38: {
                return 2;
            }
            case 49: {
                return 5;
            }
            case 64: {
                return 8;
            }
            case 87: {
                return 15;
            }
            case 109: {
                return 11;
            }
            case 122: {
                return 12;
            }
            case 133: {
                return 3;
            }
            case 146: {
                return 4;
            }
            case 168: {
                return 0;
            }
            case 191: {
                return 7;
            }
            case 206: {
                return 10;
            }
            case 217: {
                return 13;
            }
            case 227: {
                return 9;
            }
            case 244: {
                return 14;
            }
        }
        return -1;
    }

    public byte parity(byte by) {
        boolean bl = true;
        if (by == 0) {
            return by;
        }
        int n = 0;
        while (n < 8) {
            if ((by >>> n & 1) == 1) {
                bl ^= true;
            }
            ++n;
        }
        if (bl) {
            return (byte)(0x80 | by);
        }
        return by;
    }

    private byte[] setCharacterMapping(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            String string2 = String.valueOf((short)cArray[n]);
            byArray[n] = this.mapping_table.containsKey(string2) ? ((Integer)this.mapping_table.get(string2)).byteValue() : (byte)cArray[n];
            ++n;
        }
        return byArray;
    }

    public void setEnhancements(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = 0;
        byte by = this.bytereverse((byte)((0xF & this.hamming_8_4(byArray[6])) << 4));
        if (n == 29 && by == 0 || n == 29 && by == 4 || n == 28 && by == 4) {
            n3 = this.hamming_24_18(byArray, 7);
            int n5 = n3 << 3;
            if (n == 28 && by == 0 && (0x3F800 & n3) != 0) {
                return;
            }
            n3 = this.hamming_24_18(byArray, 10);
            int n6 = 0xFE & this.bytereverse((byte)(0x7F & (n5 |= 7 & n3 >> 15) >> 7));
            this.page_modifications.put("primary_set", String.valueOf(0xF & n6 >> 4));
            if (n != 29) {
                this.page_modifications.put("primary_national_set", String.valueOf(n2));
            }
            n6 = 0xFE & this.bytereverse((byte)(0x7F & n5));
            this.page_modifications.put("secondary_set", String.valueOf(0xF & n6 >> 4));
            this.page_modifications.put("secondary_national_set", String.valueOf(7 & n6 >> 1));
        }
        if (n != 26) {
            return;
        }
        int n7 = 7;
        while (n7 < 46) {
            block11: {
                String string;
                block13: {
                    byte by2;
                    byte by3;
                    block14: {
                        block12: {
                            byte by4;
                            block10: {
                                n3 = this.hamming_24_18(byArray, n7);
                                by4 = this.bytereverse((byte)(0xFC & n3 >> 10));
                                by3 = this.bytereverse((byte)(0xF8 & n3 >> 4));
                                by2 = this.bytereverse((byte)(0xFE & n3 << 1));
                                if (by4 < 40) break block10;
                                if (by4 == 63 && by3 == 31) break;
                                if (by3 != 4 && by3 != 1) {
                                    this.use = false;
                                } else {
                                    this.display_row = by4 == 40 ? 0 : by4 - 40;
                                    this.display_column = by3 == 1 ? (byte)0 : by2;
                                    this.use = true;
                                }
                                break block11;
                            }
                            if (!this.use) break block11;
                            this.display_column = by4;
                            string = "";
                            if (by3 != 15) break block12;
                            string = String.valueOf(string) + (char)CharSet.getActive_G2_Set(0, n2, this.display_row)[by2];
                            break block13;
                        }
                        if (by3 != 16) break block14;
                        string = String.valueOf(string) + (char)CharSet.getActive_G0_Set(0, n2, this.display_row)[by2];
                        break block13;
                    }
                    if (by3 <= 16) break block11;
                    string = String.valueOf(string) + (char)CharSet.getCombinedCharacter(by2, by3 & 0xF);
                }
                n4 = this.display_row << 16 | this.display_column;
                this.page_modifications.put(String.valueOf(n4), string);
            }
            n7 += 3;
        }
    }

    public void setMappingTable() {
        this.mapping_table.clear();
        int n = Common.getSettings().getIntProperty(Keys.KEY_TtxLanguagePair) - 1;
        n = n < 0 ? 0 : n;
        int n2 = n == 0 ? 4 : 0;
        this.mapping_table.put("mapping", new Integer(n));
        this.mapping_table.put("subset", new Integer(n2));
        this.active_set = CharSet.getActive_G0_Set(n, n2, 0);
        this.active_national_set = CharSet.getActiveNationalSubset(n, n2, 0);
        int n3 = 32;
        int n4 = this.active_set.length - 1;
        while (n3 < n4) {
            this.mapping_table.put(String.valueOf(this.active_set[n3]), new Integer(n3));
            ++n3;
        }
        int[] nArray = new int[]{35, 36, 64, 91, 92, 93, 94, 95, 96, 123, 124, 125, 126};
        int n5 = 0;
        int n6 = this.active_national_set.length;
        while (n2 >= 0 && n5 < n6) {
            this.mapping_table.put(String.valueOf(this.active_national_set[n5]), new Integer(nArray[n5]));
            ++n5;
        }
    }

    private class ColorIndex {
        private int index;
        private int color;

        public ColorIndex(int n, int n2) {
            this.index = n;
            this.color = n2;
        }

        public int getColor() {
            return this.color;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

