/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PushbackInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StripMedion {
    private boolean debug = Common.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
    private int aux_number = 1;
    private String stripped = "[stripped]";
    private String parent = "";
    private Hashtable out_streams = new Hashtable();
    private BufferedOutputStream out;
    private MedionStreamObject mso;

    private void addNewOutput(int n) {
        this.addNewOutput(String.valueOf(n));
    }

    private void addNewOutput(String string) {
        if (this.out_streams.containsKey(string)) {
            return;
        }
        String string2 = this.parent;
        string2 = string.equals("0") ? String.valueOf(this.parent) + this.stripped + ".vpes" : (string.equals("1") ? String.valueOf(this.parent) + this.stripped + ".apes" : String.valueOf(this.parent) + this.stripped + ".aux" + String.valueOf(this.aux_number++));
        this.out_streams.put(string, new MedionStreamObject(string2));
    }

    private void closeOutput() {
        Enumeration enumeration = this.out_streams.keys();
        while (enumeration.hasMoreElements()) {
            this.mso = this.getOutput(enumeration.nextElement().toString());
            this.mso.closeStream();
        }
    }

    private MedionStreamObject getOutput(int n) {
        return this.getOutput(String.valueOf(n));
    }

    private MedionStreamObject getOutput(String string) {
        if (!this.out_streams.containsKey(string)) {
            this.addNewOutput(string);
        }
        return (MedionStreamObject)this.out_streams.get(string);
    }

    public XInputFile[] process(XInputFile xInputFile, String string) {
        int n;
        if (string.startsWith("[res]")) {
            string = xInputFile.getParent();
        }
        this.parent = String.valueOf(string) + System.getProperty("file.separator") + xInputFile.getName();
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(xInputFile.getInputStream());
            int n2 = 0;
            int n3 = 65536;
            int n4 = 8192;
            n = 7;
            long l = 0L;
            long l2 = xInputFile.length();
            byte[] byArray = new byte[n3];
            while (l < l2) {
                int n5 = pushbackInputStream.read(byArray);
                if (n5 < byArray.length) {
                    pushbackInputStream.read(byArray, n5, byArray.length - n5);
                }
                int n6 = 0;
                int n7 = n4;
                while (n6 < n) {
                    if (this.debug) {
                        System.out.println("med pos + " + l + " /i " + n6 + " /v " + byArray[n6]);
                    }
                    this.mso = this.getOutput(0xFF & byArray[n6]);
                    this.mso.write(byArray, n7, n4);
                    ++n6;
                    n7 += n4;
                }
                ++n2;
                l += (long)n3;
            }
            this.closeOutput();
            pushbackInputStream.close();
        }
        catch (Exception exception) {
            Common.setExceptionMessage(exception);
            return null;
        }
        int n8 = 0;
        Enumeration enumeration = this.out_streams.keys();
        while (enumeration.hasMoreElements()) {
            this.mso = this.getOutput(enumeration.nextElement().toString());
            if (this.mso.isEmpty()) continue;
            ++n8;
        }
        XInputFile[] xInputFileArray = new XInputFile[n8];
        n = 0;
        int n9 = 0;
        while (n < 256) {
            String string2 = String.valueOf(n);
            if (this.out_streams.containsKey(string2)) {
                this.mso = (MedionStreamObject)this.out_streams.get(string2);
                xInputFileArray[n9++] = new XInputFile(this.mso.getFile());
            }
            ++n;
        }
        return xInputFileArray;
    }

    private class MedionStreamObject {
        private boolean isEmpty = true;
        private String name = "";
        private BufferedOutputStream stream;
        private File file;

        public MedionStreamObject(String string) {
            this.name = string;
            this.setStream();
        }

        public void closeStream() {
            try {
                this.stream.flush();
                this.stream.close();
                this.file = new File(this.name);
                if (StripMedion.this.debug) {
                    System.out.println("rl file '" + this.name + "' /l " + this.file.length());
                }
                if (this.isEmpty = this.file.length() < 100L) {
                    this.file.delete();
                }
            }
            catch (Exception exception) {
                Common.setExceptionMessage(exception);
            }
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        private void setStream() {
            try {
                this.stream = new BufferedOutputStream(new FileOutputStream(this.name), 2048000);
            }
            catch (Exception exception) {
                Common.setExceptionMessage(exception);
            }
        }

        public void write(byte[] byArray, int n, int n2) {
            try {
                this.stream.write(byArray, n, n2);
            }
            catch (Exception exception) {
                Common.setExceptionMessage(exception);
            }
        }
    }
}

