/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.gui.ColumnLayout;
import net.sourceforge.dvb.projectx.gui.CommonGui;
import net.sourceforge.dvb.projectx.gui.UISwitchListener;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class HexViewer
extends JFrame {
    private XInputFile xinputFile;
    private JTextArea HexArea;
    private JTextField Field;
    private JTextField Field1;
    private JTextField from;
    private JTextField fsize;
    private JScrollPane scroll;
    private JViewport viewport;
    private JLabel flen;
    private JLabel hexn;
    private JLabel decn;
    private JSlider slider;
    private JFileChooser chooser;
    private boolean textonly = false;

    public HexViewer() {
        this.init();
    }

    static /* synthetic */ boolean access$10(HexViewer hexViewer) {
        return hexViewer.textonly;
    }

    protected JMenu buildFileMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.File");
        JMenuItem jMenuItem = new JMenuItem();
        CommonGui.localize(jMenuItem, "Common.SaveAs");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem();
        CommonGui.localize(jMenuItem2, "Common.Close");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(88, 8));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HexViewer.this.close();
            }
        });
        jMenu.add(jMenuItem2);
        return jMenu;
    }

    protected void buildMenu() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.buildFileMenu());
        jMenuBar.add(this.buildOptionMenu());
        this.setJMenuBar(jMenuBar);
    }

    protected JMenu buildOptionMenu() {
        JMenu jMenu = new JMenu();
        CommonGui.localize(jMenu, "Common.Options");
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Resource.getString("hexviewer.textmode"));
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HexViewer.this.textonly = ((JCheckBoxMenuItem)actionEvent.getSource()).getState();
            }
        });
        jMenu.add(jCheckBoxMenuItem);
        return jMenu;
    }

    protected void centerDialog() {
        ((Component)this).setLocation(150, 150);
        ((Component)this).setSize(620, 530);
    }

    private void close() {
        this.dispose();
    }

    protected void init() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HexViewer.this.close();
            }
        });
        this.buildMenu();
        this.setTitle(Resource.getString("hexviewer.title"));
        this.chooser = new JFileChooser();
        this.scroll = new JScrollPane();
        this.HexArea = new JTextArea();
        this.HexArea.setFont(new Font("Courier New", 0, 12));
        this.HexArea.setEditable(false);
        this.HexArea.setRows(24);
        this.HexArea.setTabSize(12);
        this.scroll.setViewportView(this.HexArea);
        this.viewport = this.scroll.getViewport();
        this.slider = new JSlider(1, 0, 15, 0);
        this.slider.setInverted(true);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HexViewer.this.readfile(16L * (long)HexViewer.this.slider.getValue());
            }
        });
        this.Field = new JTextField("0");
        this.Field.setToolTipText(Resource.getString("hexviewer.jumpto_tip"));
        this.Field.setPreferredSize(new Dimension(100, 25));
        this.Field.setMaximumSize(new Dimension(100, 25));
        this.Field.setEditable(true);
        this.hexn = new JLabel("= hex: ");
        this.hexn.setPreferredSize(new Dimension(120, 25));
        this.hexn.setMaximumSize(new Dimension(120, 25));
        this.Field1 = new JTextField("0");
        this.Field1.setToolTipText(Resource.getString("hexviewer.jumpto_tip"));
        this.Field1.setPreferredSize(new Dimension(100, 25));
        this.Field1.setMaximumSize(new Dimension(100, 25));
        this.Field1.setEditable(true);
        this.decn = new JLabel("= dec: ");
        this.decn.setPreferredSize(new Dimension(120, 25));
        this.decn.setMaximumSize(new Dimension(120, 25));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setToolTipText(Resource.getString("hexviewer.jumpto_tip"));
        jPanel2.add(new JLabel(Resource.getString("hexviewer.jumptodec")));
        jPanel2.add(this.Field);
        jPanel2.add(this.hexn);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setToolTipText(Resource.getString("hexviewer.jumpto_tip"));
        jPanel3.add(new JLabel(Resource.getString("hexviewer.jumptohex")));
        jPanel3.add(this.Field1);
        jPanel3.add(this.decn);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new ColumnLayout());
        this.flen = new JLabel(Resource.getString("hexviewer.filesize"));
        jPanel4.add(this.flen);
        jPanel4.add(jPanel2);
        jPanel4.add(jPanel3);
        this.Field.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!HexViewer.this.Field.getText().equals("")) {
                        HexViewer.this.hexn.setText("= hex: " + Long.toHexString(Long.parseLong(HexViewer.this.Field.getText())).toUpperCase());
                        HexViewer.this.slider.setValue((int)(Long.parseLong(HexViewer.this.Field.getText()) / 16L));
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.Field1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!HexViewer.this.Field1.getText().equals("")) {
                        HexViewer.this.decn.setText("= dec: " + Long.parseLong(HexViewer.this.Field1.getText(), 16));
                        HexViewer.this.slider.setValue((int)(Long.parseLong(HexViewer.this.Field1.getText(), 16) / 16L));
                    }
                }
                catch (Exception exception) {}
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 1));
        jPanel5.add(this.scroll);
        this.from = new JTextField("0");
        this.from.setPreferredSize(new Dimension(100, 25));
        this.from.setMaximumSize(new Dimension(100, 25));
        this.from.setEditable(true);
        this.fsize = new JTextField("100000");
        this.fsize.setPreferredSize(new Dimension(100, 25));
        this.fsize.setMaximumSize(new Dimension(100, 25));
        this.fsize.setEditable(true);
        JButton jButton = new JButton(Resource.getString("hexviewer.extractfrom"));
        jButton.setToolTipText(Resource.getString("hexviewer.extractfrom_tip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (!HexViewer.this.from.getText().equals("") && !HexViewer.this.fsize.getText().equals("")) {
                        long l = Long.parseLong(HexViewer.this.from.getText(), 16);
                        long l2 = Long.parseLong(HexViewer.this.fsize.getText(), 16) - l;
                        HexViewer.this.savefile(l, l2);
                    }
                }
                catch (Exception exception) {}
            }
        });
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        jPanel6.setToolTipText(Resource.getString("hexviewer.extract_tip"));
        jPanel6.add(jButton);
        jPanel6.add(this.from);
        jPanel6.add(new JLabel(String.valueOf(Resource.getString("hexviewer.to")) + ": (hex.)"));
        jPanel6.add(this.fsize);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new ColumnLayout());
        jPanel7.add(jPanel4);
        jPanel7.add(jPanel6);
        jPanel.add((Component)this.slider, "East");
        jPanel.add(jPanel5);
        jPanel.add((Component)jPanel7, "South");
        this.getContentPane().add(jPanel);
        this.centerDialog();
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    private void print(byte[] byArray, long l) {
        String string = "0000000000";
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("  Offset   :  0  1  2  3  4  5  6  7- 8  9  A  B  C  D  E  F  :    Ascii        \n");
        stringBuffer.append("-----------|--------------------------------------------------|-----------------\n");
        StringBuffer stringBuffer2 = new StringBuffer("");
        int n = 0;
        while (n < byArray.length) {
            String string2 = Long.toHexString(l + (long)n).toUpperCase();
            stringBuffer.append(String.valueOf(string.substring(0, 10 - string2.length())) + string2 + " : ");
            int n2 = 0;
            stringBuffer2.setLength(0);
            stringBuffer2.append(" : ");
            String string3 = "   ";
            while (n2 < 16 && n + n2 < byArray.length) {
                String string4 = Integer.toHexString(0xFF & byArray[n + n2]).toUpperCase();
                stringBuffer.append(String.valueOf(string.substring(0, 2 - string4.length())) + string4 + (n2 == 7 ? "-" : " "));
                stringBuffer2.append((0xFF & byArray[n + n2]) > 31 && (0xFF & byArray[n + n2]) < 127 ? String.valueOf((char)byArray[n + n2]) : ".");
                ++n2;
            }
            while (n2 < 16) {
                stringBuffer.append(string3);
                ++n2;
            }
            stringBuffer.append(String.valueOf(stringBuffer2.toString()) + "\n");
            n += 16;
        }
        this.HexArea.setText(stringBuffer.toString());
    }

    private void readfile(long l) {
        try {
            this.xinputFile.randomAccessOpen("r");
            long l2 = this.xinputFile.length();
            if (l < l2) {
                if (this.textonly) {
                    this.xinputFile.randomAccessSeek(l);
                    String string = "";
                    String string2 = null;
                    if (l != 0L) {
                        this.xinputFile.randomAccessReadLine();
                    }
                    int n = 0;
                    while (n < 24 && (string2 = this.xinputFile.randomAccessReadLine()) != null) {
                        string = String.valueOf(string) + string2 + "\n";
                        ++n;
                    }
                    this.HexArea.setText(string);
                } else {
                    int n = (int)(l2 - l >= 384L ? 384L : l2 - l);
                    byte[] byArray = new byte[n];
                    this.xinputFile.randomAccessSeek(l);
                    this.xinputFile.randomAccessRead(byArray);
                    this.print(byArray, l);
                }
            }
            this.xinputFile.randomAccessClose();
        }
        catch (IOException iOException) {
            this.HexArea.setText(String.valueOf(Resource.getString("hexviewer.error")) + ": " + this.xinputFile);
        }
    }

    private void savefile(long l, long l2) {
        long l3 = this.xinputFile.length();
        long l4 = l2 = l + l2 > l3 ? l3 - l : l2;
        if (l >= l3 || l < 0L || l2 < 1L) {
            return;
        }
        String string = String.valueOf(String.valueOf(this.xinputFile)) + "(0x" + Long.toHexString(l) + " to 0x" + Long.toHexString(l + l2) + ").bin";
        this.chooser.setSelectedFile(new File(string));
        this.chooser.rescanCurrentDirectory();
        int n = this.chooser.showSaveDialog(this);
        if (n == 0) {
            File file = this.chooser.getSelectedFile();
            if (file != null && !file.isDirectory()) {
                string = file.getAbsolutePath();
            }
        } else {
            return;
        }
        this.setTitle(String.valueOf(Resource.getString("hexviewer.save")) + ": " + string);
        try {
            int n2 = 0x2EE000;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(this.xinputFile.getInputStream(), n2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string), n2);
            long l5 = 0L;
            long l6 = l + l2;
            while (l5 < l) {
                l5 += bufferedInputStream.skip(l - l5);
            }
            while (l5 < l6) {
                int n3 = l6 - l5 < (long)n2 ? (int)(l6 - l5) : n2;
                byte[] byArray = new byte[n3];
                n3 = bufferedInputStream.read(byArray);
                bufferedOutputStream.write(byArray, 0, n3);
                l5 += (long)n3;
            }
            bufferedInputStream.close();
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            this.HexArea.setText(String.valueOf(Resource.getString("hexviewer.error")) + ": " + this.xinputFile);
        }
        this.setTitle(String.valueOf(Resource.getString("hexviewer.file")) + ": " + this.xinputFile);
    }

    public void view(XInputFile xInputFile) {
        long l = xInputFile.length();
        if (this.xinputFile == null || !this.xinputFile.equals(xInputFile)) {
            this.xinputFile = xInputFile;
            this.HexArea.setText("");
            this.slider.setMaximum((int)(l / 16L));
            if (this.slider.getValue() == 0) {
                this.readfile(0L);
            } else {
                this.slider.setValue(0);
            }
        }
        this.setTitle(String.valueOf(Resource.getString("hexviewer.file")) + ": " + this.xinputFile);
        this.flen.setText(String.valueOf(Resource.getString("hexviewer.filesize")) + ":  " + Common.formatNumber(l) + " bytes");
        this.show();
    }
}

