<?php
/**
 * Norwegian texts
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * # $Id: help_text.no.php 4857 2009-01-21 03:25:25Z canajun2eh $
 *
 * @translator Geir Håkon Eikland
 * @translator Thomas Rindal
 * @package PhpGedView
 * @subpackage Languages
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

##$pgv_lang["help_treenav.php"]		= "~#pgv_lang[interactive_tree]#~<br />Use the #pgv_lang[interactive_tree]# to view the entire family tree of a person in both directions.  This view is similar to the Hourglass view in that it shows both ancestors and descendants of a given root person.  This chart gives you a more compact view by showing boxes for couples or families instead of just individuals.<br /><ul><li><b>Scrolling</b><br />Whenever your mouse cursor changes to a Move icon, you can click and drag the tree to view other portions of the tree.  As you drag the tree future generations will automatically expand until there are no more generations left to view in that direction.<br /></li><li><b>Zoom</b><br />You can use the icons on the left of the tree to zoom in and out.  Zooming out will allow you to see more of the tree on the screen at a time.  As you zoom out the text can become difficult to read; when your mouse hovers over a box you will get an enlarged view of what is inside it.<br /></li><li><b>Expanding Details</b><br />Clicking on any box will expand the box and display a more detailed view.  While in expanded mode, clicking on a person's name will open their #pgv_lang[indi_info]# page.  Clicking <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> will redraw the tree with that person as the new root.  Clicking <img src='#GLOBALS[PGV_IMAGE_DIR]#/buttons/family.gif' alt='' /> will take you to that family's detail page.<br /></li><li><b>Toggle Spouses</b><br />The <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/sfamily.gif' width='15px' height='15px' alt='' /> icon directly under the Zoom buttons will toggle the display of all spouses on or off on the descendancy side.  When the display is set to show spouses, all of a person's spouses will appear in the box with them.  All of the person's children will be shown as well.  When the option to show spouses is off, only the person's last spouse and children with that spouse will be shown.<br /></li><li><b>Large Tree</b><br />The #pgv_lang[interactive_tree]# is available from many different pages including the Tree tab on the #pgv_lang[indi_info]# page and the Charts block on the Welcome page.  When viewing the tree from one of these other pages, you will also have a Tree icon under the Zoom icons.  If you click <img src='#GLOBALS[PGV_IMAGE_DIR]#/small/gedcom.gif' width='15px' height='15px' alt='' /> you will be taken to the #pgv_lang[interactive_tree]# page.</li></ul><br />";

##$pgv_lang["move_mediadirs_help"]	= "~#pgv_lang[move_mediadirs]#~<br />When the Media Firewall is enabled, Multi-Media files can be stored in a server directory that is not accessible from the Internet.<br /><br />These buttons allow you to easily move an entire Media directory structure between the protected (not web-addressable) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> and the normal <b>#GLOBALS[MEDIA_DIRECTORY]#</b> directories.<br /><br />";
##$pgv_lang["setperms_help"]			= "~#pgv_lang[setperms]#~<br />Recursively set the permissions on the protected (not web-addressable) <b>#GLOBALS[MEDIA_FIREWALL_ROOTDIR]##GLOBALS[MEDIA_DIRECTORY]#</b> and the normal <b>#GLOBALS[MEDIA_DIRECTORY]#</b> directories to either world-writable or read-only.<br /><br />";
##$pgv_lang["no_update_CHAN_help"] 	= "~#pgv_lang[no_update_CHAN]#~<br />Administrators sometimes need to clean up and correct the data submitted by users.  For example, they might need to correct the PLAC location to include the country.  When Administrators make such corrections, information about the original change is normally replaced.  This may not be desirable.<br /><br />When this option is selected, PhpGedView will retain the original Change information instead of replacing it with that of the current session.  With this option selected, Administrators also have the ability to modify or delete the information associated with the original CHAN tag.<br /><br />";
##$pgv_lang["edit_SOUR_EVEN_help"]	= "~#pgv_lang[source_events]#~<br /><br />Each source records specific events, generally for a given date range and for a place jurisdiction.  For example a Census records census events and church records record birth, marriage, and death events.<br /><br />Select the events that are recorded by this source from the list of events provided. The date should be specified in a range format such as <i>FROM 1900 TO 1910</i>. The place jurisdiction is the name of the lowest jurisdiction that encompasses all lower-level places named in this source. For example, \"Oneida, Idaho, USA\" would be used as a source jurisdiction place for events occurring in the various towns within Oneida County. \"Idaho, USA\" would be the source jurisdiction place if the events recorded took place not only in Oneida County but also in other counties in Idaho.<br /><br />";
##$pgv_lang["cache_life_help"]		= "~#pgv_lang[cache_life]#~<br /><br />To improve performance, this PhpGedCom Welcome Page block is saved as a cache file.  You can control how often this block's cache file is refreshed.<br /><br /><ul><li><b>-1</b> means that the cache file is never refreshed automatically.  To get a fresh copy, you need to delete all cache files.  You can do this on the Customize Welcome Page page.</li><li><b>0</b> (Zero) means that this block is never cached, and every time the block is displayed on the PhpGedView Welcome page, you see a fresh copy.  This setting is used automatically for blocks that change frequently, such as the #pgv_lang[logged_in_users_block]# and the #pgv_lang[random_media_block]# blocks.</li><li><b>1</b> (One) means that a fresh copy of this block's cache file is created daily, <b>2</b> means that a fresh copy is created every two days, <b>7</b> means that a fresh copy is created weekly, etc.</li></ul><br /><br />";
##$pgv_lang["clear_cache_help"]		= "~#pgv_lang[clear_cache]#~<br /><br />In order to improve performance, several of the blocks on the PhpGedView Welcome page are saved as cache files in the index directory.  The cache files for most blocks are refreshed once each day, but there may be times when you want to refresh them manually.<br /><br />This button allows you to refresh the cache files when necessary.";
$pgv_lang["import_options_help"] 	= "Du kan velge alternative måter å importere slektsfilen (ged) din.";
$pgv_lang["verify_gedcom_help"]		= "Her kan du velge om du skal hente og importere denne slektsfilen eller om du vil avbryte prosessen.";
$pgv_lang["add_gedcom_instructions"]	= "Tast inn et filnavn for denne nye slektsfilen (GEDCOM). Den blir opprettet i mappen index:";
##$pgv_lang["random_media_start_slide_help"]			= "~#pgv_lang[random_media_start_slide]#~<br /><br />Should the slideshow start automatically when the page is loaded.<br /><br />The slideshow changes the contents of the block without preloading information from the server and without reloading the entire page.<br /><br />";
##$pgv_lang["random_media_ajax_controls_help"]	= "~#pgv_lang[random_media_ajax_controls]#~<br /><br />You can use this setting to show or hide the slideshow controls of the Random Media block.<br /><br />These controls allow the user to jump to another random object or to play through randomly selected media like a slideshow. The slideshow changes the contents of the block without preloading information from the server and without reloading the entire page.<br /><br />";
##$pgv_lang["edit_add_unlinked_source_help"]	= "~#pgv_lang[add_unlinked_source]#~<br /><br />Use this link to add a new source to your database without linking the source to a source citation in another record.  The new source will appear in the source list, but will not appear on any charts or anywhere else in the program until it is linked up to a source citation.";
##$pgv_lang["link_person_id_help"]	= "~#pgv_lang[label_local_id]#~<br /><br />In this field you enter the ID of the person you are linking to (e.g. I100).";
##$pgv_lang["link_gedcom_id_help"]	= "~#pgv_lang[label_gedcom_id]#~<br /><br />Use this section to select the alternate database identifier that contains the the person you are linking to.";
##$pgv_lang["link_remote_site_help"]	= "~#pgv_lang[label_site]#~<br /><br />In this section you specify the parameters that are required to connect to the remote site hosting the data you are linking to. You have the option of choosing from a list of known sites that you have used before, or entering the #pgv_lang[label_site_url2]# and #pgv_lang[label_gedcom_id]# for a new one.<br /><br />In the <b>#pgv_lang[label_site_url2]#</b> field, you enter the URL to access the web services description file (WDSL) which tells PhpGedView how to access the data on the remote site.  For a remote PhpGedView website, the URL to the WSDL file will look like this: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />The <b>#pgv_lang[label_gedcom_id]#</b> field is used to enter an optional database identifier for remote sites that require one.  For PhpGedView sites, this is the name of the GEDCOM file. <br /><br />The <b>#pgv_lang[label_username_id]#</b> and the <b>#pgv_lang[label_password_id]#</b> fields are necessary if the database requires it.<br /><br /><i>Note: Remote PhpGedView sites must be running version 4.0 or later; earlier versions do not have this capability.</i>";
##$pgv_lang["link_remote_location_help"]	= "~#pgv_lang[label_location]#~<br /><br />This option allows you to choose whether data for the person you are linking to is on the same site but in a different genealogical database set, or whether the data is on a different site accessible through the Internet.<br /><br />If the person is on the same site, you will be asked to select the dataset identifier and enter the person's ID.<br /><br />For a remote site, you will be asked to enter its URL, a database identifier, and the person's remote ID.";
##$pgv_lang["link_remote_rel_help"]	= "~#pgv_lang[label_rel_to_current]#~<br /><br />Use this option to select the relationship the remote person has to the person you are linking them with on your site.  For example, selecting <i>Father</i> would mean that the person on the remote site is the father of the person you are linking them to locally.";
##$pgv_lang["link_remote_help"]       = "~#pgv_lang[link_remote]#~<br /><br />Use this form to link people to other people either from another site or another genealogical database accessible to your copy of PhpGedView.<br /><br />To add such a link, you must first select the relationship type, then choose a site already known to PhpGedView or define a new site, and then enter that site's ID of the person you want to link to.  PhpGedView will then automatically download information from the remote site as necessary.  The downloaded information does <u>not</u> become part of your genealogical database; it remains on the original site but is incorporated into the various pages where this remotely linked person is displayed.<br /><br />Refer to the Help link next to each element on the page for more information about that element.  You can also check the online English tutorial for more information: <a href=\"#PGV_PHPGEDVIEW_WIKI#/en/index.php?title=How_To:Remote_Link_Individuals_Across_Websites_And_Databases\" target=\"_blank\">#PGV_PHPGEDVIEW_WIKI#</a>.";

//-- Edit Interface
##$pgv_lang["edit_ABBR_help"]			= "~ABBREVIATED TITLE~<br /><br />Use this field for storing an abbreviated version of a title.  This field is used in conjunction with the title field on sources.  By default PGV will first use the title and then the abbreviated title.<br /><br />According to the GEDCOM 5.5 specification, \"this entry is to provide a short title used for sorting, filing, and retrieving source records (pg 62).\"<br /><br />In PhpGedView the abbreviated title is optional, but in other genealogical programs it is required.";
##$pgv_lang["edit_ROMN_help"]			= "~ROMANIZED NAME~<br /><br />In many cultures it is customary to have a traditional name spelled in the traditional characters and also a romanized version of the name as it would be spelled or pronounced in languages based on the Latin alphabet, such as English.<br /><br />If you prefer to use a non-Latin alphabet such as Hebrew, Greek, Russian, Chinese, or Arabic to enter the name in the standard name fields, then you can use this field to enter the same name using the Latin alphabet.  Both versions of the name will appear in lists and charts.<br /><br />Although this field is labelled \"Romanized\", it is not restricted to containing only characters based on the Latin alphabet.  This might be of use with Japanese names, where three different alphabets may occur.";
##$pgv_lang["edit_ROMN_GIVN_help"]	= "#pgv_lang[edit_ROMN_help]#<br /><br />In this field you should enter the given names for the person.  As an example, in the name \"John Robert Finlay\", the given names that should be entered here are \"John Robert\"<br /><br />";
##$pgv_lang["edit_ROMN_SURN_help"]	= "#pgv_lang[edit_ROMN_help]#<br /><br />In this field you should enter the surname for the person.  As an example, in the name \"John Robert Finlay\", the surname that should be entered here is \"Finlay\"<br /><br />Individuals with multiple surnames, common in Spain and Portugal, should separate the surnames with a comma.  This indicates that the person is to be listed under each of the names.  For example, the surname \"Cortes,Vega\" will be listed under both <b>C</b> and <b>V</b>, whereas the surname \"Cortes Vega\" will only be listed under <b>C</b>.<br /><br />";
##$pgv_lang["edit__HEB_help"]			= "~HEBREW NAME~<br /><br />In many cultures it is customary to have a traditional name spelled in the traditional characters and also a romanized version of the name as it would be spelled or pronounced in languages based on the Latin alphabet, such as English.<br /><br />If you prefer to use the Latin alphabet to enter the name in the standard name fields, then you can use this field to enter the same name in the non-Latin alphabet such as Greek, Hebrew, Russian, Arabic, or Chinese.  Both versions of the name will appear in lists and charts.<br /><br />Although this field is labelled \"Hebrew\", it is not restricted to containing only Hebrew characters.";
##$pgv_lang["edit__HEB_GIVN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br />In this field you should enter the given names for the person.  As an example, in the name \"John Robert Finlay\", the given names that should be entered here are \"John Robert\"<br /><br />";
##$pgv_lang["edit__HEB_SURN_help"]	= "#pgv_lang[edit__HEB_help]#<br /><br />In this field you should enter the surname for the person.  As an example, in the name \"John Robert Finlay\", the surname that should be entered here is \"Finlay\"<br /><br />Individuals with multiple surnames, common in Spain and Portugal, should separate the surnames with a comma.  This indicates that the person is to be listed under each of the names.  For example, the surname \"Cortes,Vega\" will be listed under both <b>C</b> and <b>V</b>, whereas the surname \"Cortes Vega\" will only be listed under <b>C</b>.<br /><br />";
$pgv_lang["edit_SEX_help"]			= "#pgv_lang[edit_sex_help]#";
$pgv_lang["edit_NAME_help"]			= "#pgv_lang[edit_name_help]#";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Bruk dette skjemaet for å legge til en person som ikke er knyttet til en familie.<br /><br />Når du legger til en \"frittstående\" person i slektsbasen din, vil personen ikke bli knyttet til noen andre personer før du oppgir slektskapet/familebåndet.  Du kan når som helst knytte personer sammen ved å benytte valget for dette under arkfanen #pgv_lang[relatives]# på siden for #pgv_lang[indi_info]#.";
$pgv_lang["edit_URL_help"]			= "Angi internettadressen (URL) inkludert http:// først.<br /><br />Et eksempel på en internettadresse er: <b>http://www.phpgedview.net/</b> <br />La dette feltet være tomt dersom du ikke ønsker å oppgi en adresse (URL).";
$pgv_lang["edit_EMAIL_help"]		= "Angi en epost-adresse.<br /><br />Et eksempel på epost-adresse er: <b>navn@hotmail.com</b> <br />La dette feltet være tomt dersom du ikke ønsker å oppgi en epost-adresse.";
$pgv_lang["edit_FAX_help"]			= "Angi et FAKS-nummer, inkludert landskode og eventuelt retningsnummer.<br /><br />Eksempler:<ul><li>Norge: +47 35 00 00 01</li><li>Tyskland: +49 25859 56 76 89</li><li>USA: +1 888 555-1212</li></ul>La dette feltet være tomt dersom du ikke ønsker å oppgi et faksnummer.";
$pgv_lang["edit_PHON_help"]			= "Angi et telefonnummer, inlkudert landskode og eventuelt retningsnummer.<br /><br />Eksempel:<ul><li>Norge: +47 35 00 00 00</li><li>Tyskland: +49 25859 56 76 89</li><li>USA: +1 888 555-1212.</li></ul>La dette feltet være tomt dersom du ikke ønsker å oppgi et telefonnummer.";
$pgv_lang["edit_ADDR_help"]			= "Angi en postadresse i feltet på samme måte som du ville gjort på en konvolutt.<br /><br />La dette feltet være tom dersom du ikke ønsker å oppgi en postadresse.";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]			= "~Prefiks til etternavn~<br /><br />Angi eller velg fra listen ord som er en del av etternavnet.  Eksempler på slike ord er <b>von</b> Braun, <b>van der</b> Kloot, <b>de</b> Graaf, mm.";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit__MARNM_help"]		= "~#factarray[_MARNM]#~<br /><br />Angi etternavn som gift, for denne personen (bruk <a href=\"?help=edit_name_help\">standard formatering for navn</a>).<br />Dette feltet er valgfritt.<br /><br />For eksempel, hvis Kari Anne Sørgard gifter seg med Ola Normann, kan du skrive navnet som<ul><li><b>Kari Anne Sørgard /Normann/</b> - dersom hun beholder pikenavnet</li><li><b>Kari Anne /Normann/</b> - dersom hun <u>ikke</u> beholder pikenavnet</li></ul><dl><dt><b>PS 1!</b></dt><dd>Etternavnet kan ikke bli \"Søgard-Normann\" da dette vil bli et helt nytt etternavn ulikt etternavnet til ektemannen (om da ikke begge søker om å få bytte etternavn til Sørgard-Normann) - Noen ganger hender det at ektemannen tar etternavnet til ektefellen.</dd><dt><b>PS 2!</b></dt><dd>Det har blitt mer og mer vanlig å beholde pikenavnet som gift. Da må du ikke fylle ut dette feltet.</dd></dl>";
##$pgv_lang["edit_PEDI_help"]			= "~#factarray[PEDI]#~<br /><br />This field describes the relationship of the child to its family.  The possibilities are:<ul><li><b>#pgv_lang[unknown]#</b>&nbsp;&nbsp;&nbsp;The child's relationship to its family cannot be determined.  When this option is selected, the #factarray[PEDI]# field will not be copied into the database.<br /><br /></li><li><b>#factarray[BIRT]#</b>&nbsp;&nbsp;&nbsp;This option indicates that the child is related to its family by birth.<br /><br /></li><li><b>#pgv_lang[adopted]#</b>&nbsp;&nbsp;&nbsp;This option indicates that the child was adopted by its family.  This does <i>not</i> indicate that there is no blood relationship between the child and its family; it shows that the child was adopted by the family in question sometime after the child's birth.<br /><br /></li><li><b>#pgv_lang[foster]#</b>&nbsp;&nbsp;&nbsp;This option indicates that the child is a foster child of the family.  Usually, there is no blood relationship between the child and its family.<br /><br /></li><li><b>#pgv_lang[sealing]#</b>&nbsp;&nbsp;&nbsp;The child was sealed to its family in an LDS <i>sealing</i> ceremony.  A child sealing is performed when the parents were sealed to each other after the birth of the child.  Children born after the parents' sealing are automatically sealed to the family.<br /><br /></li></ul>";
##$pgv_lang["edit_AGNC_help"]			= "~#factarray[AGNC]#~<br /><br />The organization, institution, corporation, person, or other entity that has authority.<br /><br />For example, an employer of a person, or a church that administered rites or events, or an organization responsible for creating and/or archiving records.";

$pgv_lang["context_help"]			= "Mer hjelp er tilgjengelig ved å klikke på <b>?</b> du kan finne etter ulike valg på siden.";

$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Hver person i slektsbasen på dette nettstedet har et unikt ID-nummer.  Dersom du kan ditt eget ID-nummer, kan du oppgi det her.  Hvis du ikke husker ID-nummeret eller ikke kan finne det på grunn av personvern-innstillinger, vær vennlig å oppgi nok informasjon i kommentar-feltet slik at administratoren for nettstedet kan gjenkjenne for å kunne gi deg ID-nummeret ditt.<br /><br />";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Bruk dette feltet for å fortelle administratoren til nettstedet<ul><li>Hvem du er som ønsker en konto</li><li>Hvem du er i familie med og som er vist på dette nettstedet.</li></ul>Du kan også bruke dette feltet for å gi administratoren andre kommentarer.<br /><br />";
$pgv_lang["utf8_ansi_help"]			= "~Konvertere fra UTF-8 til ANSI~<br /><br />For at slektsdataene skal vises på den beste måten på Internett, så bruker PhpGedView UTF-8 tegnsett.  Noen programmer, som for eksempel Family Tree Maker, støtter ikke import av slektsfiler (i <a href=\"?help=def_gedcom_help\">GEDCOM-format</a>) som bruker UTF-8 tegnsett.  Ved å merke denne boksen, så vil slektsfilen bli konvertert fra <b>UTF-8</b> til <b>ANSI</b>. <br /><br />Hvilket tegnsett du velger for slektsfilen som skal laste ned (download), avhenger av programmet du skal importere til. Dersom du ikke er sikker på hvilket tegnsett det støtter, bør du sjekke brukerveiledningen til programmet.<br /><br />NB! Vær oppmerksom på at spesielt særnasjonale tegn/bokstaver kan forsvinne/vises feil ved konvertering. Det er derfor alltid sikrest bevare dataene i UTF-8 og la ditt eget program bruke sin egen metode for import og konvertering av slektsfilen.  Dersom du får problemer, bør du kontakte selgeren eller utvikleren av programmet ditt.<br /><br />";
$pgv_lang["remove_tags_help"]		= "~#pgv_lang[remove_custom_tags]#~<br /><br />Ved å merke av dette valget så vil alle fakta-koder lagt til av PhpGedView bli fjernet.<br /><br />Fakta-koder som PhpGedView bruker er blant annet <b>_PGVU</b> som gjenkjenner brukere som har endret data online og <b>_THUM</b> som forteller PhpGedView at bildet bør brukes som et miniatyrbilde.<br /><br />Egendefinerte koder kan forårsake feil ved import til andre slektsprogram.<br /><br />";
$pgv_lang["download_zipped_help"]	= "~#pgv_lang[download_zipped]#~<br /><br />Når du merker av dette valget, vil en kopi av slektsfilen bli komprimert med ZIP-format før nedlastingen starter. Dette vil redusere størrelsen på filen med ca. 75%. \"Ulempen\" er at du må bruke et programmet <a href=\"http://www.7-zip.org\" alt=\"Last ned 7-Zip gratis\" title=\"Last ned 7-Zip gratis\" target=_blank>7-Zip</a>, WinZip eller lignende for å kunne pakke ut slektsfilen før du kan bruke den.<br /><br />Dette er spesielt et nyttig valg når du har store slektsfiler.  En annen side er makstiden PHP tillater for en handling skal bli ferdig, med den følge at nedlastingen blir avbrutt før den er ferdig.<br /><br />";
$pgv_lang["remember_me_help"]		= "~#pgv_lang[remember_me]#~<br /><br />Ved å merke denne boksen når du logger deg inn, vil gjøre at PhpGedView husker deg neste gang du besøker nettstedet slik at du ikke behøver å logge deg inn igjen.<br /><br /><b>NB!</b> Du bør ikke merke av denne boksen dersom du <i>logger deg inn fra en datamaskin på et offentlig sted eller en datamaskin som du deler med andre</i>; Da kan andre brukere av datamaskinen gå til PhpGedView-nettstedet ditt som om de var deg.<br /><br />Dersom PGV husker deg igjen, vil du kunne se privat informasjon og brukersider direkte. - Men dersom du ønsker å endre eller administrere nettstedet, vil du bedt om å oppgi brukernavnet og passordet ditt igjen.<br /><br />Dette valget vil lagre en \"cookie\" på harddisken din som PhpGedView vil spørre nettleseren om finnes neste gang du besøker nettstedet.";
$pgv_lang["edit_NCHI_help"]			= "~#factarray[NCHI]#~<br /><br />Angi antall barn som person eller familien har. Dette er et valgfritt felt.<br /><br />";
$pgv_lang["edit_TIME_help"]			= "~#factarray[TIME]#~<br /><br />Angi klokkeslettet for denne hendelsen. Bruk tidsformat med 24 timer:<ul><li>Midnatt: 00:00</li><li>04:50</li><li>13:00</li><li>20:30</li></ul>";
$pgv_lang["edit_NOTE_help"]			= "~#factarray[NOTE]#~<br /><br />Noter er tekst med fri form og vil vises i faktafeltene og under arkfanen Noter.<br /><br />";
$pgv_lang["edit_CEME_help"]			= "~#factarray[CEME]#~<br /><br />Angi navnet på kirkegården eller annet bisettelsessted der personen er stedt til hvile.<br /><br />";
$pgv_lang["edit_ASSO_help"]			= "~#factarray[ASSO]#~<br /><br />Angi tilhørende slektsbaseID.<br /><br />";
$pgv_lang["edit_RELA_help"]			= "~#factarray[RELA]#~<br /><br />Velg en benevnelse fra listen. Dersom du velger <b>Gudfar</b>, så betyr det: <i>Denne personen er Gudfar til den viste personen</i>.<br /><br />";
$pgv_lang["show_spouse_help"]		= "~#pgv_lang[show_spouses]#~<br /><br />Som standard vises ikke ektefeller til etterkommere fordi det gjør diagrammet vanskeligere å lese og/eller forstå.<br /> - Ved å marke av dette valget, vil diagrammet også vise ektefeller.<br /><br />";
$pgv_lang["reorder_families_help"]	= "~#pgv_lang[reorder_families]#~<br /><br />Familier på arkfanen #pgv_lang[relatives]# blir vist i den rekkefølgen som de er lagret i slektsbasen.  Familiene er ikke sortert på datoen for giftemål fordi denne datoen ofte er ukjent til forskjell fra rekkefølgen til giftemål.<br /><br />Dette valget gir deg muligheten til å endre rekkefølgen for hvordan de skal vises på denne siden for #pgv_lang[relatives]#.  Dersom du ønsker å sortere familiene i henhold til dato for giftemål, kan du klikke på knappen for automatisk sortering.<br /><br />";
##$pgv_lang["autoContinue_help"]			= "~#pgv_lang[autoContinue]#~<br /><br />When PhpGedView detects that the GEDCOM Import requires more time than is permitted by the time limit, it will display a <b>#pgv_lang[del_proceed]#</b> button that you must press to continue the Import.<br /><br />When this option is set to <b>#pgv_lang[yes]#</b>, PhpGedView will automatically press the <b>#pgv_lang[del_proceed]#</b> button for you.  This should relieve the tedium of having to press the button repeatedly for lengthy Imports.<br /><br />";
##$pgv_lang["firstname_i_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />The surname you have chosen has more than #GLOBALS[SUBLIST_TRIGGER_I]# individuals.<br /><br />To help you find the person you want, the list has been broken into smaller lists according to the first letter of the person's given name.  This alphabetical sub-index works the same as the alphabetical index for surnames.<br /><ul><li>Click a letter to see all of the first names which start with that letter.</li><li>Choose <b>#pgv_lang[NN]#</b> to list all of the persons with unknown first names.</li><li>Choosing <b>#pgv_lang[all]#</b> will display a list of all persons with the previously chosen surname.</li></ul>Because there are many names, it may take a long time for this list to appear on your screen.<br /><br />";
##$pgv_lang["firstname_f_help"]		= "~#pgv_lang[firstname_alpha_index]#~<br /><br />The family name you have chosen has more than #GLOBALS[SUBLIST_TRIGGER_F]# individuals.<br /><br />To help you find the family you want, the list has been broken into smaller lists according to the first letter of the person's given name.  This alphabetical sub-index works the same as the alphabetical index for names.<br /><ul><li>Click a letter to see all of the first names which start with that letter.</li><li>Choose <b>#pgv_lang[NN]#</b> to list all of the people with unknown first names.</li><li>Choosing <b>#pgv_lang[all]#</b> will display a list of all families with the previously chosen surname.</li></ul>Because there are many names, it may take a long time for this list to appear on your screen.<br /><br />";
##$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#~<br /><br />The #factarray[TYPE]# field is used to enter additional information about the item.  In most cases, the field is completely free-form, and you can enter anything you want.<br /><br />";
$pgv_lang["edit_TYPE_help"]			= "~#factarray[TYPE]#~<br /><br />Feltet #factarray[TYPE]# gir deg mulighet til å angi en bruker-definert hendelse.  Feltet er har ikke bundet format slik at du står fritt til hva innholdet skal være.<br /><br />";
$pgv_lang["edit_TEMP_help"]			= "~#factarray[TEMP]#~<br /><br />I dette feltet kan du legge inn hvor LDS (Mormoner) ordineringer fant sted.<br /><br />";
$pgv_lang["edit_STAT_help"]			= "~#factarray[STAT]#~<br /><br />Dette feltet er et valgfritt statusfelt og er for det meste brukt for hvor langt personen er kommet i LDS (Mormoner) TempleReady ordineringsprogrammet.<br /><br />";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Bruk dette feltet for å angi at denne mediafilen er hovedfilen for personen det er knyttet til.  Hovedbildet er det som blir brukt i diagram og på faktasiden til personen.<br /><br />";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Dette er et felt spesielt for PhpGedView som gir deg mulighet til å angi at det er hoved-miniatyrbildet som skal brukes i diagram der det ikke finnes et miniatyrbilde for originalbilde.<br /><br />";
$pgv_lang["edit_TITL_help"]			= "~#factarray[TITL]#~<br /><br />Angi en tittel for mediafilen du redigerer.  Dersom tittelen er for en multimediafil, angir du en beskrivende tittel som vil også vil vises for besøkende på nettstedet.<br /><br />";
$pgv_lang["edit_FILE_help"]			= "~#factarray[FILE]#~<br /><br />Dette er det viktigste feltet for multimediafilen!  Det viser hvilken fil som skal brukes.<br />Som et minimum, så må du angi navnet på filen.  Avhengig av hvilke innstillinger du har gjort i PhpGedView, så må du kanskje angi mer informasjon om plasseringen til filen.<br /><br />Du kan bruke valget <b>#pgv_lang[find_media]#</b> som en hjelp for å lokalisere de mediafilene du allerede ligger på nettstedet.<br /><br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]			= "~#factarray[FORM]#~<br /><br />Dette er et valgfritt felt som kan brukes for å angi formatet til multimedia-filen.  Noen slektsprogram sjekker dette feltet for å bestemme hvordan de skal håndtere filen.  På en annen side, så er ikke dette veldig viktig fordi multimediafiler overføres forholdsvis dårlig mellom ulike datamaskin-plattformer.<br /><br />";
$pgv_lang["generate_thumb_help"]	= "~Lage miniatyrbilde(r)~<br /><br />Vi har funnet ut at serveren din har mulighet til automatisk å lage miniatyrbilde(r) fra bestemte typer/formater av bilder.  Det kan være støtte for filformatene JPG, GIF og PNG.  Formatene som serveren din støtter er vist ved siden av avmerkingsboksen.<br /><br />Ved å merke av denne boksen, så forteller du til systemet at laster opp bilder med ett eller flere av disse formatene og at du ønsker at det skal genereres miniatyrbilde(r) for dem.  Dersom du ikke merker av boksen, så må du eventuelt lage miniatyrbilde(r)ene selv.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />Denne delen gir deg mulighet til å legge til en ny note for faktopplysninger som du redigerer.  Noter er tekst i fritt format og vil vises i detaljer for fakta på ulike sider.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />Denne delen gir deg mulighet til å legge til en ny kildehenvisning til den faktopplysningen du redigerer.<br /><br />I kildefeltet angir du IDen til kilden.  Dersom du må opprette en ny kilde, kan du klikke på valget <b>#pgv_lang[create_source]#</b>.  I feltet for henvisnings-detaljer kan du angi sidenummer eller annen informasjon som kan hjelpe noen til finne fram til opplysningene i kilden.  I tekstfeltet kan du også skrive inn direkte tekstutdrag fra kilden.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# gir deg mulighet til å knytte en faktaopplysning med en tilhørende person i slektsbasen.  Dette er den eneste måten du koble en person som forlover, gudfar og lignende til en annen person.<br /><br />";
$pgv_lang["edit_QUAY_help"]			= "~#factarray[QUAY]#~<br /><br />Du kan bruke dette feltet for å angi kvaliteten eller pålitligheten av opplysningene i denne kilden.  Mange slektsprogram bruker et nummer i feltet.<ul><li><b>1</b> kan bety at opplysningene er en førsthåndskilde</li><li><b>2</b> kan bety at opplysningene stammer fra annenhåndskilde</li><li><b>3</b> kan bety at opplysningene ikke kan dokumenteres eller er høyst usikre.</li></ul><br />";
$pgv_lang["edit_PAGE_help"]			= "~#factarray[PAGE]#~<br /><br />I feltet for detaljer for henvisninger kan du angi sidenummer eller annen informasjon som kan hjelpe noen til finne fram til opplysningene i kilden.<br /><br />";
$pgv_lang["edit_TEXT_help"]			= "~#factarray[TEXT]#~<br /><br />I dette feltet kan du angi en tekst for henvisningen for denne kilden.  Eksempler på opplysninger kan være et utdrag av kildeteksten eller en beskrivelse av hva som i henvisningen.<br /><br />";
$pgv_lang["edit_SOUR_help"]			= "~#factarray[SOUR]#~<br /><br />Dette feltet gir deg mulighet til å angi hvilken kilde som denne faktaopplysningen er knyttet til.  Dette feltet skal KUN inneholde en kilde-ID.  Ved siden av feltet er den nåværende tittelen vist for gjeldende kilde-ID.  Bruk valget <b>#pgv_lang[find_id]#</b> for å søke etter ID-nummeret til kilden.  For å fjerne hele kildehenvisningen, så la dette feltet være tomt.<br /><br />";
$pgv_lang["edit_edit_raw_help"]		= "~#pgv_lang[edit_raw]#~<br /><br />Denne siden gir deg mulighet til å redigere opplysninger direkte i slektsfilen.  Du bør bruke denne side med forsiktighet og omtanke; Det krever at du kjenner og forstår standarden <a href=\"?help=gedcom_info_help\">GEDCOM 5.5.1.</a><br /><br />PhpGedView gir deg flere muligheter til redigere informasjon på, men det kan være situasjoner der du ønsker å gjøre endringene direkte i slektsfilen.  Dersom det er mulig, bør du benytte de tilbudte skjemaene for å legge til informasjon. MEN dersom det ikke er mulig, kan du bruke dette \"skjemaet\".  Når du sender det ferdig redigerte \"skjemaet\", vil informasjonen bli sjekket i henhold til noen basis-regler i henhold til standarden og posten CHAN (endret av og når) blir oppdatert.<br /><br />";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView gir deg mulighet til å kopiere faktaopplysninger til utklippsmappen.  Du kan kopiere opptil 5 faktaopplysninger og lagre dem i utklippsmappen.  Fra menyen Legg til faktaopplysning kan du velge å lime inn en av faktaopplysningene fra utklippsmappen til en annen person.  Dette kan være nyttig når du legger til like faktaopplysninger, slik som for eksempel folketellingsopplysninger for mange personer.<br /><br />";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Steder bør legges inn i henhold til standarden for slektsfiler (<a href=\"?help=def_gedcom_help\">GEDCOM 5.1.1.</a>).  I slektsbaser skal et sted legges inn med det mest detaljerte stedsnavnet først (der hendelsen skjedde) og videre større og større områdenavn, skilt med komma for å angi de geografike nivåene.  Startstedet du bruker for kilder bør være navnet på offentlig register eller kirke der de vitale opplysningene er oppbevart/arkivert.<br /><br />For eksempel, et sted som Skien bør legges inn som \"Langesund, Bamble, Telemark, Norge\".<br /><br />La oss se nærmere på hvert stedsnavn.  Første sted, \"Langesund\" er stedet eller byen der hendelsen skjedde.  I noen byer kan det være bydeler eller områder innen en by som er viktig å få med.  I de tilfellene bør de plasseres før navnet på byen.  Det neste stedet, \"Bamble\" er kommunenavnet.  \"Telemark\" er navnet på fylket, og \"Norge\" er navnet på landet.  Det er viktig å være oppmerksom på at offentlige myndigheter på alle stedsnivå, nevnt i eksemplet, kan ha register som inneholder slektsopplysninger.<br /><br />Dersom du ikke kjenner navnet på et nivå, bør du la nivået være tomt ved å legge inn et mellomrom mellom de to kommaene.<br />- Tenk deg at, i nevnte eksempel, at du ikke kjente navnet på kommunen Langesund ligger i.  Da bør stedene skrives slik for de ulike nivåene: \"Langesund, , Telemark, Norge\".<br />- Tenk deg at du bare vet at en person var født i Telemark.  Da bør du skrive stedsinformasjon slik som dette: \", , Telemark, Norge\".<br /><br />Du kan bruke valget <b>#pgv_lang[find_place]#</b> for å hjelpe deg med å finne steder som allerede finnes i slektsbasen.<br /><br />";
$pgv_lang["edit_add_parent_help"]	= "~Legg til ny mor eller far~<br /><br />På denne siden kan du legge til en ny mor eller far for den valgte personen.  Fyll ut navnet til den nye personen, samt informasjon om fødselsdato og dødsdato dersom dette er kjent.  Har du ikke nok informasjon til å fylle ut alle felt, så går det greit å la noen være tomme.<br /><br />For å legge til andre faktaopplysninger, så må du først lagre de over nevnte opplysningene.  Så kan du gå til den oppdaterte familiesiden og klikke på navnet til personen. Da vil du få fram faktasiden til personen der du kan legge til flere faktaopplysninger.<br /><br />";
$pgv_lang["edit_add_spouse_help"]	= "~Legg til ny ektemann eller hustru~<br /><br />På denne siden kan du legge til en ny ektemann eller hustru til den valgte personen.  Fyll ut navnet til den nye personen, samt informasjon om fødselsdato og dødsdato dersom dette er kjent.  Har du ikke nok informasjon til å fylle ut alle felt, så går det greit å la noen være tomme.<br /><br />For å legge til andre faktaopplysninger, så må du først lagre de over nevnte opplysningene.  Så kan du gå til den oppdaterte familiesiden og klikke på navnet til personen. Da vil du få fram faktasiden til personen der du kan legge til flere faktaopplysninger.<br /><br />";
$pgv_lang["edit_death_help"] 		= "~#pgv_lang[death]#~<br /><br />Dette området gir deg mulighet til å legge inn informasjon om personens død.<br /><br />Angi først datoen da personen døde i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slektsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for å få hjelp med å velge en dato.<br /><br />Deretter angir du stedet der personen døde i <a href=\"?help=edit_PLAC_help\">standard stedsformat</a> for slektsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for å velge et sted som allerede finnes i slektsbasen.<br /><br />";
$pgv_lang["edit_birth_help"] 		= "~#pgv_lang[birth]#~<br /><br />Dette området gir deg mulighet til å legge inn informasjon om personens fødsel.<br /><br />Angi først datoen da personen ble født i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slektsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for å få hjelp med å velge en dato.<br /><br />Deretter angir du stedet der personen ble født i <a href=\"?help=edit_PLAC_help\">standard stedsformat</a> for slektsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for å velge et sted som allerede finnes i slektsbasen.<br /><br />";
$pgv_lang["edit_sex_help"]			= "~#pgv_lang[sex]#~<br /><br />Bruk dette feltet for å angi om personen er<ul> </li><li>#pgv_lang[male]#</li> </li><li>#pgv_lang[female]#</li><li>#pgv_lang[unknown]# - <i>Brukes <u>kun</u> når du ikke er sikker.</i></li></ul>";
$pgv_lang["edit_name_help"]			= "~#pgv_lang[name]#~<br /><br />Dette er det viktigste feltet for en person i slektsbasen.  Dette feltet skulle i utgangspunktet vært fyllt ut automatisk, men det er åpent slik at du kan endre informasjonen i henhold til dine personlige preferanser.  Navnet i dette feltet bør skrives inn i henhold til standarden for slektsfiler (<a href=\"?help=def_gedcom_help\">GEDCOM 5.5.1</a>) med etternavnet omgitt av skråstreker \"/\".<br /><br />Eksempel: \"Jon Ola Normann dy.\" skrives som <b>Jon Ola /Normann/ dy.</b><br />Dersom personen til vanlig bare bruker ett av fornavnene (her Ola),<br />kan navnet skrives inn som: <b>Jon \"Ola\" /Normann/ dy.</b><br />Dersom navnet er \"Ola von Bustenskiold de.\"<br /> skrives det som: <b>Ola /von Bustenskiold/ de.</b><br /><br />";
$pgv_lang["edit_suffix_help"]		= "~#pgv_lang[suffix]#~<br /><br />I dette valgfrie feltet kan du legge inn postfiks til navnet til personen.  Eksempler på postfiks til navn kan være \"de.\", \"dy.\",\"Sr.\", \"Jr.\" og \"III\".<br /><br />";
$pgv_lang["edit_surname_help"]		= "~#pgv_lang[surname]#~<br /><br />I dette feltet kan du legge inn etternavnet til personen.  Som et eksempel, i navnet \"Ola Normann\", vil etternavnet være \"Normann\".<br /><br />";
$pgv_lang["edit_NICK_help"]			= "~#factarray[NICK]#~<br /><br />I dette valgfrie feltet kan du legge inn kalle-/klengenavn på personen.<br />Dette feltet kan også benyttes der en person er kjent under et alias navn (også kjent som). Eksempel på dette kan være kunsternavn.<br /><br />Metoder for å legge til et #factarray[NICK]# ved å velge:<ul><li><b>#pgv_lang[edit_name]#</b></li><li><b>#pgv_lang[add_name]#</b></li><li><b>#pgv_lang[edit_raw]#</b> - her må du legge til linjen [2&nbsp;NICK] <i>Kallenavn</i> - rett under linjen der det står [1&nbsp;NAME]</li></ul>";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />I dette feltet kan du legge inn fornavnet til personen.  Som et eksempel, i navnet \"Ola Normann\", vil fornavnet være \"Ola\".<br /><br />";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NAME]# #factarray[NPFX]#~<br /><br />Dette valgfrie feltet gir deg mulighet til å legge til en prefiks til navnet slik som for eksempel \"Dr.\" eller \"Lt.\"<br /><br />";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />På denne siden kan du legge til et barn til den valgte familien.  Fyll ut navnet til barnet, samt informasjon om fødselsdato og dødsdato dersom dette er kjent.  Har du ikke nok informasjon til å fylle ut alle felt, så går det greit å la noen være tomme.<br /><br />For å legge til andre faktaopplysninger, så må du først lagre de over nevnte opplysningene.  Så kan du gå til den oppdaterte familiesiden og klikke på navnet til barnet. Da vil du få fram faktasiden til barnet der du kan legge til flere faktaopplysninger.<br /><br />";

$pgv_lang["review_changes_help"]	= "~Ikke godkjente endringer~<br /><br />Denne rammen vil vise alle endringer som er gjort i slektsbasen online og som trenger å bli sjekket og godkjent for at de skal kunne vises i diagram, lister og andre faktasider.<br /><br />";
$pgv_lang["quick_update_name_help"] = "~#pgv_lang[update_name]#~<br /><br />Bruk disse feltene for å endre navnet til den valgte personen.<ul><li>I feltet for fornavn angir du fornavnet til personen og eventuelle mellomnavn.</li><li>I feltet for etternavn angir du etternavnet til personen.</li></ul>Eksempel: Dersom personen heter \"Ola Normann\", så angir du<ul><li>Fornavn: \"Ola\"</li><li>Etternavn: \"Normann\"</li></ul><b>NB!</b> Ved å fylle ut disse feltene, så vil du <u>endre</u> navnet til personen; - ikke legge til et nytt navn!<br /><br /><b>PS!</b> <i>Du bør <u>ikke</u> bruke denne metoden for å endre etternavn på grunn av giftemål!<br />- Bruk i stede valget under for å legge til en ny ektemann/hustru.</i><br /><br />";
$pgv_lang["quick_update_fact_help"] = "~#pgv_lang[update_fact]#~<br /><br />Bruk disse feltene for å legge til en ny eller endre en eksisterende faktaopplysning for personen.<ol></li><li>Velg type faktaopplysning</li><li>Angi datoen da hendelsen skjedde i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slektsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for å få hjelp med å velge en dato.</li><li>Angi stedet der hendelsen fant sted i <a href=\"?help=edit_PLAC_help\">standard stedsformat</a> for slektsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for å velge et sted som allerede finnes i slektsbasen.</li></ol>Som i alle de andre feltene i dette skjemaet, så vil opplysningene du oppgir enten erstatte eksisterende innhold eller så vil det bli opprettet en ny faktaopplysning alt ettersom det som er valgt.<br /><br />";
$pgv_lang["quick_update_photo_help"]	= "~#pgv_lang[update_photo]#~<br /><br />Bruk dette feltet for å hente (upload) et bilde for denne person.<br />I feltet for tittel kan du gi en beskrivende tittel til bildet, slik som \"Ola Normann 2004\".<br />Deretter klikker du på knappen <b>Bla gjennom</b> for å finne bildet på datamaskinen din.<br /><br />Dersom det finnes et bilde fra før til denne personen, så vil du også få en avmerkingsboks for om du vil legge til dette bilde eller om du vil erstatte det bildet som finnes fra før.<br /><br />";
$pgv_lang["quick_update_address_help"]	= "~#pgv_lang[update_address]#~<br /><br />Bruk disse feltene for å endre adressen, telefon-nummeret eller epost-adressen til denne personen.<br /><br />Som i alle de andre feltene i dette skjemaet, så vil opplysningene du oppgir enten erstatte eksisterende innhold eller så vil det bli opprettet en ny faktaopplysning alt ettersom det som er valgt.<br /><br />";
$pgv_lang["quick_update_spouse_help"] 	= "~Legg til en ny ektemann/hustru~<br /><br />Bruk disse feltene dersom du ønsker å legge til en ny ektemann/hustru til denne personen.<ol></li><li>Skriv inn navnet til den nye ektefellen</li><li>Angi datoen da ekteskapet ble inngått i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slektsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for å få hjelp med å velge en dato.</li><li>Angi stedet der ekteskapspakten ble inngått i <a href=\"?help=edit_PLAC_help\">standard stedsformat</a> for slektsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for å velge et sted som allerede finnes i slektsbasen.</li></ol><b>NB!</b> Disse feltene vil <b>bare</b> legge til en <i>ny</i> partner; de vil <b>ikke</b> oppdatere informasjon om et allerede registrert ekteskap.  For å endre opplysninger om et ekteskap som er registrert fra før, må du gå til arkfanen #pgv_lang[relatives]# på faktasiden til personen og velge ønsket ektemann/hustru. Deretter kan du gjøre de endringene du ønsker for denne personen.<br /><br />";
$pgv_lang["quick_update_marriage_help"] = "~Oppdatere ekteskap~<br /><br />Du kan bruke disse feltene sammen med feltene for å legge til en ny ektemann/hustru dersom du ønsker å legge til et nytt ekteskap.<br /><br />Dersom du <u>bare</u> legger inn opplysninger i feltene for ekteskap, vil endringene bli \"bokført\" det siste registrerte ekteskapet til personen.<ol></li><li>Angi datoen da ekteskapet ble inngått i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slektsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for å få hjelp med å velge en dato.</li><li>Angi stedet der ekteskapspakten ble inngått i <a href=\"?help=edit_PLAC_help\">standard stedsformat</a> for slektsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for å velge et sted som allerede finnes i slektsbasen.</li></ol>";
$pgv_lang["quick_update_child_help"] 	= "~#pgv_lang[add_new_chil]#~<br /><br />Bruk disse feltene for å legge til et nytt barn for denne personen.<ol></li><li>Skriv inn navnet til det nye barnet</li><li>Angi kjønnet til barnet</li><li>Angi datoen da barnet ble født i <a href=\"?help=def_gedcom_date_help\">standard datoformat</a> for slektsforskning (1 OCT 2004).  Du kan klikke på ikonet for <b>Kalender</b> for å få hjelp med å velge en dato.</li><li>Angi stedet der barnet ble født i <a href=\"?help=edit_PLAC_help\">standard stedsformat</a> for slektsforskning.  Du kan klikke på ikonet for <b>#pgv_lang[find_place]#</b> for å velge et sted som allerede finnes i slektsbasen.</li></ol>Disse feltene vil <b>bare</b> legge til et <u>nytt</u> barn.  De vil <b>ikke</b> oppdatere opplysninger til et barn som er registert fra før.  For å endre opplysninger om et ekteskap som er registrert fra før, må du gå til arkfanen #pgv_lang[relatives]# på faktasiden til personen og velge ønsket barn. Deretter kan du gjøre de endringene du ønsker for denne personen.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]	= "~Rammen: Vist flest ganger~<br /><br />Denne rammen vil vise de 10 mest viste personene, familiene eller kildene på nettstedet.  For å kunne vise denne rammen, må administratoren for nettstedet ha aktivert telleren.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]	= "~Standardinnstilling for arkfane~<br /><br />Dette valget gir deg mulighet til å angi hvilken arkfane som skal åpnes automatisk når siden #pgv_lang[indi_info]# blir vist.  Dersom en bruker kan endre kontoen sin, kan de ulike brukerne velge sin egen standard-arkfane.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]	= "~Brukerinnstilling for standard arkfane~<br /><br />Dette valget gir deg som bruker mulighet til å angi hvilken arkfane som skal åpnes automatisk når siden #pgv_lang[indi_info]# blir vist.<br /><br />";
$pgv_lang["reorder_children_help"]		= "~Bytt rekkefølge på barn~<br /><br />Barna er vist i den rekkefølgen de ble lagt inn i slektsbasen.  Barn blir ikke vist i forhold til fødselsdato fordi denne datoen ofte er ukjent til forskjell fra rekkefølgen på barna.<br /><br />Dette valget gir deg muligheten til å endre rekkefølgen for hvordan de skal vises på denne siden for #pgv_lang[relatives]# og siden for familier.  Dersom du ønsker å sortere barna i henhold til fødselsdato, kan du klikke på knappen for automatisk sortering.<br /><br />";
$pgv_lang["rss_feed_help"]				= "~Innstillinger for RSS-visning~<br /><br />RSS-visningen som er tilgjengelig i PhpGedView gir deg mulighet til å se hovedinnholdet fra hovedsiden i din favoritt-samling for RSS-visning uten at du besøker nettstedet. De fleste RSS-innsamlere vil vise et \"sprett-opp\"-vindu for å gjøre deg oppmerksom på at noen har blitt endret på hovedsiden. Dette gjør at du kan følge med på endringer på et PhpGedView nettsted uten at du jevnlig besøker det. Ved hjelp av rammen for RSSinnstillinger, så kan du bestemme hvilke lenker som skal samles inn, velge spesielle innsamlings-metoder (de fleste nettleserne kan håndtere de fleste metodene, så dette kan vanligvis være satt til standard) og hvilke rammer du ønsker å samle inn endringer fra. Språket brukt i innsamlingen vil være basert på det språket som var aktivt i PhpGedView da du aktiverte RSS-innsamlingen. Innsamlingsmetodene som kan bli generert, inkluderer RSS 0.92, RSS 1.0, RSS 2.0, ATOM, HTML og JavaScript. De 4 første er for ren RSS-innsamling, mens JavaScript og HTML støttes for å etablere koblinger av RSS-innsamlinger på andre internettsider.<br /><br />Vær oppmerksom på at de ulike RSS-versjonsnummerene indikerer forskjellige stiler og ikke ulike versjoner.<br /><br />";

##$pgv_lang["upload_media_folder_help"]	= "~#pgv_lang[folder]#~<br /><br />Your GEDCOM configuration allows up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# directory levels beyond the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b> where uploaded media files are normally stored. This lets you organize your media files, and you don't need to be as concerned about maintaining unique names for each media file.<br /><br />In this field you specify the destination directory on your server where the uploaded media file is to be stored.  Be sure to pay attention to the case (upper or lower case) of what you enter or select here, since file and directory names are case sensitive.<br /><br />If the directory name you enter here does not exist, it will be created automatically. If you enter more than the additional #GLOBALS[MEDIA_DIRECTORY_LEVELS]# directory levels permitted by your GEDCOM configuration, your input will be truncated accordingly.<br /><br />Thumbnails will be uploaded or created in an identical directory structure, starting with <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />";
##$pgv_lang["upload_media_file_help"]		= "~#pgv_lang[media_file]#~<br /><br />In this field you specify the location and name, on your local computer, of the media file you wish to upload to the server.  You can use the <b>Browse</b> button to search your local computer for the desired file.<br /><br />The uploaded file will have the same name on the server, and it will be uploaded to the directory specified in the <b>#pgv_lang[folder]#</b> field.<br /><br />If you do not see the <b>#pgv_lang[folder]#</b> field or cannot change it, you do not have sufficient permissions or your GEDCOM configuration has been set to allow no directory levels beyond the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  In this case, the media file will be uploaded to the directory <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.<br /><br />";
##$pgv_lang["upload_thumbnail_file_help"]	= "~#pgv_lang[thumbnail]#~<br /><br />In this field you specify the location and name, on your local computer, of the thumbnail file you wish to upload to the server.  You can use the <b>Browse</b> button to search your local computer for the desired file.  When this field is filled in, the <b>#pgv_lang[auto_thumbnail]#</b> checkbox is ignored.<br /><br />If the <b>#pgv_lang[media_file]#</b> field has been filled in, your uploaded thumbnail file will be named according to the contents of that field, regardless of what it is called on your local computer.  If that field is empty, the uploaded thumbnail file will be copied to two places on the server, once into the server directory mentioned in the <b>#pgv_lang[folder]#</b> field, and then again into an identical directory structure starting with <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />If you do not see the <b>#pgv_lang[folder]#</b> field or cannot change it, you do not have sufficient permissions or your GEDCOM configuration has been set to allow no directory levels beyond the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b> where uploaded media files are normally stored.<br /><br />";


//-- GENERAL
$pgv_lang["help_header"]				= "Hjelp / informasjon om:"; //Header text of the popup
$pgv_lang["privacy_error_help"]			= "<b>~Private opplysninger~</b><br />Det er flere mulige årsaker for denne meldingen:<b><dl><dt>1. Informasjon om levende personer er satt til \"Privat\"</b></dt><dd>Besøkende og registerte brukere som ikke er logget inn, kan bare se informasjon for døde personer! Dersom administrator har åpnet for det, kan du registere deg ved å klikke på 'Logg inn', og deretter på  #pgv_lang[requestpassword]#.</dd><dt><b>2. Du er en registret bruker med brukernavn og passord</b></dt><dd>Men du har glemt å logge deg inn eller at du ikke har vært aktiv på en stund og blitt logget ut automatisk.</dd><dt><b>3. Av hensyn til personvern</b></dt><dd>Personen ønsker at faktaopplysninger om seg selv skal være \"Privat\" eller at personen ikke ønsker å bli vist i det hele tatt (skjult).<br />Personvernet kan settes til:<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#</dd><dt><b>4. Ut fra \"Grad av slektskap\"</b></dt><dd>Selv om du er en vanlig bruker <i>og</i> logget inn, så kan det fremdeles hende at du vil se denne meldingen hvis personen som du prøver å se på ikke er i <b>nær</b> slekt med deg. Slektskap er definert som et visst antall steg og er bestemt av administratoren til denne slektssiden.<br /><br /><b>Eksempler:</b><br />- Når steglengden for slektskap er satt til <b>1</b>, så kan du bare se detaljene til din egen familie, far, mor, bror og søster (men ikke ektefellene og barn til broren eller søsteren din)<br />- Når steglengden for slektsskap er satt til <b>2</b>, så kan du i tillegg se detaljene til dine søkenes ektefeller og deres barn (men ikke ektefeller til deres barn).<br />- Jo høyere steglengden for slektsskap er satt, jo flere detaljer for fjernere slektninger kan du se.</dd></dl>Dersom du mener deg kvalisert til å se visse detaljer, vennligst kontakt administratoren ved å bruke kontaktlinken nederst på sidene.";
$pgv_lang["more_help"]					= "<br />Dersom du ønsker mer (detaljert) hjelp, kan du klikke på <b>#pgv_lang[qm]#</b> bak ulike valg, rammer m.m. på skjermen.<br />PS. Sjekk at <b>#pgv_lang[show_context_help]#</b> (under Hjelp i menyen) er aktiv!<br />";
$pgv_lang["more_config_help"]			= "<br /><b>Mer hjelp</b><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["start_admin_help"]			= "<b>+++ <i>Start ekstra info for Admin</i> +++</b>";
$pgv_lang["end_admin_help"]				= "<b>--- <i>Slutt ekstra info for Admin</i> ---</b>";
$pgv_lang["multiple_help"]				= "<center>--- Dette er en generell hjelpetekst for flere sider ---</center>";
$pgv_lang["header_general_help"]		= "<a name=\"#header_general#\"></a><div class=\"name_head\"><center><b>Generell informasjon</b></center></div><br />";
$pgv_lang["best_display_help"]			= "~Skjermen din~<br />PhpGedView tar seg best ut med skjermoppløsning på 1024x768.<br />Med denne oppløsningen vil du kunne se alle deler på en gang.<br />Dersom du har valgt en lavere oppløsningen (for eksempel 800x600), vil du til en viss grad bli tvunget til å bruke den horisontale rullefunksjonen for å se all informasjon.<br />";
$pgv_lang["preview_help"]				= "~Utskrift~<br />Ved å klikke på linken \"#pgv_lang[print_preview]#\", vil du få fram en side som vil se penere ut som utskrift (fjernet: menyen, \"valg-felt\", ekstra \"linker\" m.m.).<br /><br />Nederst på den \"utskrift-vennlige\" siden vil du se linken \"#pgv_lang[print]#\". Ved å klikke på den får du opp et dialogvindu for å skrive ut. Etter at siden er sendt til skriveren, kan du trykke på linken \"#pgv_lang[cancel_preview]#\".<br /><br /><b>NB:</b><i> - Selv om det er fjernet mange linker i den \"#pgv_lang[print_preview]#n\", kan du fremdeles klikke på de linkene som fortsatt finnes der.</i><br />";
$pgv_lang["readme_help"]				= "<center>Se i filen <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> for mer informasjon.</center>";
$pgv_lang["is_user_help"]				= "<b>PS!<ul><li>Denne hjelpeteksten er den samme som brukere (eller besøkende) vil få.</li><li>For å spare plass, så er det ikke egen tekst for administratorer her.</b></li></ul>";
$pgv_lang["edit_raw_gedcom_help"]		= "~#pgv_lang[edit_raw]#~<br /><br />Dersom du klikker her, vil du få fram et nytt vindu med kildedata i slektsfilen knyttet til opplysninger på denne siden.<br /><br /><b>PS! Du må <i>bare</i> endre / legge til opplysninger i henhold til standard for slektsfiler (<a href=\"?help=def_gedcom_help\">GEDCOM 5.5</a>), fordi endringene vil <i>ikke</i> bli kvalitetssikret!</b><br />Endringene og/eller tilleggene vil bli vist i PhpGedView som Endringer, og må bli godkjent av en bruker med rettighet til å godkjenne endringer før de blir vist som ordinære data.";
$pgv_lang["RESN_help"]				= "~Innstillings-begrensninger for faktaopplysninger~<br /><br />Med unntak av generelle personvern-innstillinger, har PhpGedView muligheten til å angi begrensninger for visning og endring av faktaopplysninger for personer og familier. Begrensningene kan angis av alle som har rett til å endre informasjon, med unntak der personvern eller tidligere innstillinger forbyr dette.<br /><br />Følgende verdier kan brukes:<br /><ul><li><b>#pgv_lang[none]#</b><br/>Administratorer av nettstedet, administratorer av slektsbasen og brukere som har rett til å endre, kan endre informasjon.<br />Faktaopplysninger kan vises i henhold til innstillinger for personvern lagt inn av administratoren.</li><li><b>#pgv_lang[locked]#</b><br />Denne innstillingen har ingen innvirkning på visningen av faktaopplysninger. Den begrenser retten til å endre for administratorer av nettstedet og administratorer av slektsbasen. Dersom opplysningene gjelder brukeren selv, kan han også se og endre disse dersom han har rett til å endre.</li><li><b>#pgv_lang[privacy]#</b><br />Administratorer av nettstedet og administratorer av slektsbasen kan se og endre opplysningene. Dersom opplysningene gjelder brukeren selv, kan han også se og endre disse dersom han har rett til å endre. Opplysningene vil være skjult for alle andre brukere uavhengig av status som bruker.</li><li><b>#pgv_lang[confidential]#</b><br />Bare Administratorer av nettstedet og administratorer av slektsbasen kan se og endre opplysningene. Opplysningene vil være skjult for alle andre brukere uavhengig av status som bruker.</li></ul><br /><table><tr><th></th><th colspan=2>Admin</th><th colspan=2>Eier</th><th colspan=2>Andre</th></tr><tr><th></th><th>L</th><th>S</th><th>L</th><th>S</th><th>L</th><th>S</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\"/> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\"/> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\"/> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\" /></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\"/> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr></table><ul><li>L : kan lese</li><li>S : kan endre</li><li><img src=\"images/checked_qm.gif\"/> : avhengig av globale personvern-innstillinger</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]					= "~Velkomstsiden~<br />Hovedsiden ønsker deg velkommen til denne slektsbasen (i <a href=\"#def_gedcom\">GEDCOM-format</a>). Du kan når som helst gå til siden ved å velge <i>#pgv_lang[welcome_page]#</i> i hovedmenyen. Dersom det er flere slektsbaser på dette nettstedet, vil du også få opp en undermeny der du kan velge ønsket slektsbase.<br /><b>Du kan her få informasjon om:</b> (siden dette er hjelp til hovedsiden i PhpGedView)<ul><li><a href=\"#index_portal\">#pgv_lang[welcome_page]#</a></li><li><a href=\"#header\">#pgv_lang[header]#</a></li><li><a href=\"#menu\">#pgv_lang[menu]#</a></li><li><a href=\"#header_general\">Generell informasjon</a></li><li><a href=\"#def\">Definisjoner</a></li></ul><br /><a href=\"#def_pgv\"><b>PhpGedView #VERSION#</b></a> har fått en ny og forhåpentligsvis bedre formgiving.<br />Den har fått en ny meny, helt ny hovedside, egne brukersider (Min GedView) og flere funksjoner er forbedret og/eller fornyet.<br /><br />";

//-- Index-page Header
$pgv_lang["header_help"]				= "<div class=\"name_head\"><center><b>Toppfeltet på siden</b></center></div><br />Den øverste delen av sidene (toppfeltet) blir vist på hver side.<br />Her finner du noen nyttige valg / linker som du kan bruke på alle sider.<br />Siden PhpGedView kan ha forskjellig utseende, ved å velge forskjellige <a href=\"#def_theme\">stiler</a>, vil toppfeltet kunne inneholde forskjellige linker / valg.<br /><br /><b>Valg / linker som du kan finne er:</b><ul><li><a href=\"#header_search\">Søke-felt</a></li><li><a href=\"#header_lang_select\">Velg språk</a></li><li><a href=\"#header_user_links\">Logg inn/ut</a></li><li><a href=\"#header_favorites\">#pgv_lang[my_favorites]#</a></li><li><a href=\"#header_theme\">#pgv_lang[change_theme]#</a></li></ul>";
$pgv_lang["header_search_help"]			= "~Toppfeltet: Søke-felt~<br />Dette søkefeltet er lite, men kraftig.<br />Du kan skrive inn og søke på nesten hva som helst som du tror du vil kunne finne i slektsbasen. Når du klikker på knappen \" <b>&gt;</b> \" eller \"Søk\", så vil du bli få opp en hovedsiden for søk der du vil se resultatet av forespørselen din.<br />Du vil finne ytterligere hjelp om dette på hovedsiden for å søke.<br />";
$pgv_lang["header_lang_select_help"]	= "~Toppfeltet: Velg språk~<br />En av de fine funksjonene i dette programmet, er at det automatisk vil velge det språket som du bruker på sin datamaskin (dersom det er støttet).<br />- Det kan hende at dette likevel ikke virker som forventet (f.eks. fordi nettleseren din ikke har rett innstilling for \"Foretrukket språk\").<br />Du kan likevel bytte språk ved å benytte feltet <b>Velg språk</b>.<br /><br /><b>Velg språk</b> kan bli vist på to forskjellige måter:<ul><li>Det klassiske valgfeltet med en \"dropp-ned\"-liste.</li><li>Et fargerikt område med nasjonalflaggene til de ulike språkene.</li></ul><br /><b>PS!</b> Det kan hende at du finner dette feltet nederst på siden...<br />";
$pgv_lang["header_user_links_help"]		= "~Toppfeltet: Logg inn/ut~<br />Dette er først og fremst for deg som er registrert som bruker på dette nettstedet.<br /> PS. Dersom du ikke er en registert bruker, så kan du søke om å bli det ved å klikke på:<dl><dt><b>Logg inn</b></dt><dd>Denne linken vil du se dersom du ikke er logget inn som bruker.</dd><dt><b>Logget inn som (brukernavnet ditt)</b><dt><dd>Denne linken vil du bare se dersom du er logget inn. Ved å klikke på denne linken vil du få opp siden med \"Min konto\".</dd><dt><b>Logg ut</b></dt><dd> Denne linken er vel opplagt: Du mister brukerrettighetene dine og blir en vanlig besøkende.</dd><dt><b>Admin</b></dt><dd>Dersom du har rettigheter som administrator, så vil du også se denne linken når du er logget inn. Ved å klikke på denne vil du få opp hovedsiden for Administrasjon.</dd></dl>";
$pgv_lang["header_favorites_help"]		= "~Toppfeltet: Mine favoritter~<br />Denne \"slipp-ned\"-listen vil vise deg Favoritter i slektsbasen, valgt av administratoren til nettstedet. Dersom du er en registert bruker og har logget inn, vil du se Dine favoritter som du har/kunne ha valgt deg på din personlige hovedside.<br />Ved å klikke på en av favorittene, så vil du få opp siden med \"Fakta om personen\" for den valgte favoritt-personen.<br />Mer hjelp om å legge til \"Dine favoritter\" er tilgjengelig på din personlige side (Min GedView).<br />";
$pgv_lang["header_theme_help"]			= "~Toppfeltet: Bytt stil (layout)~<br />Når dette valget er aktivert av administratoren til nettstedet, vil du kunne velge den innrammingen av slektssidene som du liker best.  Ved å velge en ny stil vil du bruke dette utseende så lenge du besøker nettstedet.  Dersom du er logget inn, vil dette også endre ditt eget standard-stil slik at det nye vil vises også neste gang du logger deg inn.<br />";

//-- Index-page Menu
$pgv_lang["menu_help"]					= "<div class=\"name_head\"><center><b>Menyen</b></center></div><br />På toppen av hver side finner du menyen med tilhørende undermenyer.<br />Beveger du muse-pilen over meny-ikonene, vil du på de fleste også få opp en undermeny.<br />- Klikker du direkte på et av ikonene i menyen, vil du få opp den siden som er det første valget i undermenyen.<br /><br /><b>Du kan få disse valgene i menyen:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a></li><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a></li><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a></li><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a></li><li><a href=\"#menu_reports\"><a href=\"?help=help_reportengine.php\">#pgv_lang[reports]#</a></a></li><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a></li><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a></li><li><a href=\"#menu_search\">#pgv_lang[search]#</a></li><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a></li></ul><br />";
$pgv_lang["menu_famtree_help"]			= "~Menyvalget: Hovedside~<br />PhpGedView kan håndtere flere slektsfiler. Dersom det er lagt inn flere, vil alle tilgjengelige slektsbaser bli vist i en undermeny.<br />Hver slektsbase vil ha sin egen hovedside som vil kunne vise forskjellige rammer og innhold.<br />";
$pgv_lang["menu_myged_help"]			= "~Menyvalget: #pgv_lang[mygedview]#~<br />Brukere som er logget inn, kan her finne linker for å tilpasse personlige data og for å endre konto-oppsettet ditt.<dl><dt>Min side</dt><dd>Sender deg til din egen \"Start-side\".</dd><dt>#pgv_lang[myuserdata]#</dt><dd>Her kan du endre ditt personlige oppsett.</dd><dt><br />- <i>Dersom du finnes i slektsbasen og admin har angitt dette i brukerkontoen din,<br />vil du også kunne se:</i><br /><br />#pgv_lang[my_pedigree]#</dt><dd>Dette vil sende deg til diagrammet med dine aner/forfedre, der du har valgt din egen hovedperson.</dd><dt>#pgv_lang[my_indi]#</dt><dd>Dette vil vise deg din egen side, der alle opplysninger om deg selv og din familie blir vist.</dd><dt><br />- <i>Dersom du har rettigheter som administrator, vil du også kunne se:</i><br /><br />Admin</dt><dd>Viser deg hovedsiden for å administrere PhpGedView.</dd><dt>Administrere #pgv_lang[manage_gedcoms]#</dt></dl>";
$pgv_lang["menu_charts_help"]			= "~Menyvalget: #pgv_lang[charts]#~<br />I dette menyvalget kan du velge mellom ulike diagram:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Dette valget vil vise deg til hoved-slekstreet for denne slektsbasen. Slektstreet vil starte med en forhåndsdefinert startperson (proband). Dersom du er logget inn, kan startpersonen (proband) være deg eller en annen som du har bestemt.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Dette valget er på en måte et \"speilvendt\" <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.<br />Der slektstreet viser alle aner/forfedre til en startperson, viser dette diagrammet deg alle etterkommere (barn, barnebarn, oldebarn, osv) til start-personen.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Her kan du se hendelser knyttet til en eller flere personer langs en tidslinje.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Her kan du sjekke hvordan slektskapet eller familiebåndet er mellom to personer.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Dette valget er veldig likt <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men med flere opplysninger og mulighet for alternativ <a href=\"?help=chart_style_help\">utforming</a>.</dd><dt><a href=\"?help=help_hourglass.php\">#pgv_lang[hourglass_chart]#</a></dt><dd>Dette valget er en kombinasjon av diagrammene <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> og <a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a> samlet i et diagram.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Dette valget er også veldig likt <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men viser det på en mer grafisk måte.<br /><b>PS.</b> <i>Dersom nettstedet ikke støtter grafisk visning, vil du ikke få dette valget!</i></dd></dl>";
$pgv_lang["menu_lists_help"]			= "~Menyvalget: #pgv_lang[lists]#~<br />I dette menyvalget kan du velge mellom ulike lister: <dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dd>Denne listen viser deg en liste med registrerte etternavn / personer som begynner på den bokstaven du har valgt.</dd><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>Denne listen viser deg en liste med registrerte familieetternavn / familier som begynner på den bokstaven du har valgt.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Her vil du få en oversikt over alle kildene som er registert i slektsbasen.</dd><dt><a href=\"?help=help_repolist.php\">#pgv_lang[repo_list]#</a></dt><dd>Her vil du få en oversikt over alle steder der kilder er lagret eller personer som har bidratt til opplysninger til slektsbasen.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Her kan du se etter personer og familier som er knyttet til ulike steder.  Funnene vil bli listet i en tabell. Dersom det er både enkeltpersoner og familier knyttet til stedet, vil personene blir vist til venstre og familier til høyre.</dd><dt><a href=\"?help=help_alive_in_year.php\">#pgv_lang[alive_in_year]#</a></dt><dd>Her vil du se personer som burde leve i det året du velger.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Her vil du kunne se linker til alle multimedia-filer som er brukt i slektsbasen.<br />Du vil bare kunne se dette menyvalget hvis nettstedets administrator har gjort dette aktivt for deg.</dd></dl>";
$pgv_lang["menu_annical_help"]			= "~Menyvalget: #pgv_lang[anniversary_calendar]#~<br />Kalenderen viser alle personer og/eller familier som er knyttet til en valgt dag, måned eller et år <br />Dersom du ikke finner en forventet person eller familie, kan det være på grunn av hensyn til personvern. (Disse vil bli vist som <b>#pgv_lang[private]#</b>)<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Her vil du kunne se personer eller familier som er knyttet til hendelser på en valgt dato i året.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Her vil du bli vist en kalender med personer og familier knyttet til hendelser i denne måneden.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Her vil du kunne se personer eller familier som er knyttet til hendelser et valgt år eller et valgt antall år.</dd></dl>";
$pgv_lang["menu_clip_help"]				= "~Menyvalget: Utklippsmappe~<br />Du vil bare kunne se dette menyvalget hvis administrator til nettstedet har aktivert dette valget.<br />Utklippsmappen gir deg mulighet til å \"kopier\" deler av slektsbasen inn i mappen, slik at du senere kan hente dem ned i en ny slektsfil til din egen datamaskin (i <a href=\"?help=def_gedcom_help\">GEDCOM filformat</a>).<br /><br />";
$pgv_lang["menu_search_help"]			= "~Menyvalget: Søke~<br />Ved å klikke på dette valget vil du få opp en egen side for å søke. Der vil du få mulighet til å kunne gjøre enda flere type søk i slektsbasen enn i søkelinken du finner øverst i toppfeltet på siden.<br /><br />";
$pgv_lang["menu_help_help"]				= "~Menyvalget: Hjelp~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>Hovedsiden</b></center></div><br />";
$pgv_lang["index_portal_help"]			= "\"Hovedsiden\" ønsker deg velkommen til programmet.<br />Hovedsiden er bygd opp av flere enkeltrammer som kan tilpasses etter behov. Derfor kan det være at du kan se flere forskjellige hovedsider på dette nettstedet (så fremt det er tilgjengelig flere enn en slektsbase).<br /><br /><b>Du vil kunne se følgende rammer på denne siden:</b><ul><li><a href=\"#index_welcome\">#pgv_lang[welcome]#</a></li><li><a href=\"#index_login\">#pgv_lang[login]#</a></li><li><a href=\"#index_events\">#pgv_lang[upcoming_events]#</a></li><li><a href=\"#index_onthisday\">#pgv_lang[on_this_day]#</a></li><li><a href=\"#index_favorites\">#pgv_lang[gedcom_favorites]#</a></li><li><a href=\"#index_stats\">#pgv_lang[gedcom_stats]#</a></li><li><a href=\"#index_common_surnames\">#pgv_lang[common_surnames]#</a></li><li><a href=\"#index_media\">#pgv_lang[random_picture]#</a></li><li><a href=\"#index_loggedin\">#pgv_lang[users_logged_in]#</a></li><li><a href=\"#recent_changes\">#pgv_lang[recent_changes]#</a></li></ul>";
$pgv_lang["index_welcome_help"]			= "~Rammen: #pgv_lang[welcome]#~<br />Tittel-rammen gir deg informasjon om:<br /><ul><li>Aktiv slektsbase og dato og tid.<br /></li><li>Vise <b>#pgv_lang[hit_count]#</b> dersom administrator har aktivert det.</li></ul><i>Telleren som viser hvor mange ganger siden er besøkt, vil du også kunne finne på sider med fakta om enkeltpersoner.  - Telleren sjekker ikke URLen (datamaskinens ID-kode) til besøkende, så hvis siden blir besøkt flere ganger, vil dette bli registert som et nytt besøk eller treff.</i><br />";
$pgv_lang["index_login_help"]			= "~Rammen: #pgv_lang[login]#~<br />Selv om du kan logge deg inn på nesten alle sider i dette programmet, vil du sikkert til vanlig gjøre dette via åpningssiden fordi det er bare når du er logget inn at du vil kunne få adgang til beskyttet informasjon.<br />Du kan logge deg inn ved å oppgi <b>brukernavnet</b> og <b>passordet</b> ditt og klikke på knappen \"Logg inn\".<br /><br />#pgv_lang[new_user_help]#<br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]			= "~Rammen: #pgv_lang[upcoming_events]#~<br />Denne rammen vil vise deg kommende hendelser i slektsbasen fra og med i morgen og en måned fram i tid.<br /><br />Administratoren bestemmer hvor mange dager fram i tid som vil bli vist.  Det er også mulig å begrense hvilke hendelser som skal vises.<br /><br />";
##$pgv_lang["todo_help"] = "~&quot;TO DO&quot; BLOCK~<br />This block helps you keep track of <b>_TODO</b> tasks in the database.<br /><br />To add &quot;To Do&quot; tasks to your records, you may first need amend the GEDCOM configuration so that the <b>_TODO</b> fact is in the list of facts that can be added to the records of individuals, families, sources, and repositories.  Each of these lists, which you will find in the Edit Options section of the GEDCOM configuration, is independent.  The order of the list entries is not important; you can add the new entries at the beginning of each list.<br /><br />";
##$pgv_lang["todo_show_other_help"]     = "Show &quot;To Do&quot; tasks assigned to other users";
##$pgv_lang["todo_show_unassigned_help"]= "Show &quot;To Do&quot; tasks that are not assigned to any user";
##$pgv_lang["todo_show_future_help"]= "Show &quot;To Do&quot; tasks that have a date in the future.  Otherwise only items with a date in the past are shown.";
##$pgv_lang["yahrzeit_help"]			="~YAHRZEITEN BLOCK~<br />This block shows you Yahrzeiten that are coming up in the near future.<br /><br />Yahrzeiten (singular: Yahrzeit) are anniversaries of a person's death.  These anniversaries are observed in the Jewish tradition; they are no longer in common use in other traditions.  «Yahrzeit» can also be spelled «Jahrzeit» or «Yartzeit».<br /><br />The Administrator determines how far ahead the block will look.  You can further refine the block's display of upcoming Yahrzeiten through configuration options.<br /><br />";
$pgv_lang["days_to_show_help"]			= "~#pgv_lang[days_to_show]#~<br /><br />Angi antall dager som skal vises.  Dette tallet kan ikke være større enn <b>#DAYS_TO_SHOW_LIMIT#</b>.  Dersom du angir et tall, så vil #DAYS_TO_SHOW_LIMIT# bli brukt.<br /><br />Denne verdien er bestemt av administratoren til nettstedet.";
##$pgv_lang["random_media_persons_or_all_help"] = "~#pgv_lang[random_media_persons_or_all]#~<br /><br />This option lets you determine the type of media to show.<br /><br />When you select <b>#pgv_lang[random_media_persons]#</b>, only media associated with persons will be shown.  Usually, this would be a person's photograph.  When you select <b>#pgv_lang[random_media_events]#</b>, only media associated with facts or events will be shown.  This might be an image of a certificate.  When you select <b>#pgv_lang[all]#</b>, this block will show all types of media.";
##$pgv_lang["random_media_filter_help"] = "~#pgv_lang[filter]#~<br /><br />You can restrict what the Random Media block is permitted to show according to the format and type of media item.  When a given checkbox is checked, the Random Media block is allowed to display media items of that format or type.<br /><br />Format or Type codes that exist in your database but are not in these checkbox lists are assumed to have the corresponding checkbox checked.  For example, if your database contains Media objects of format <b><i>pdf</i></b>, the Random Media block is always permitted to display them.  Similarly, if your database contains Media objects of type <b><i>special</i></b>, the Random Media block is always permitted to display them.";
$pgv_lang["basic_or_all_help"]			= "~#pgv_lang[basic_or_all]#~<br /><br />Dette valget gir deg mulighet til å ignorere visse hendelser.  For eksempel, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, mm.<br /><br />Når du velger <b>Ja</b> her, vil bare #factarray[BIRT]#, #factarray[DEAT]# og #factarray[MARR]# bli vist. Velger du derimot <b>Nei</b>, vil <u>alle</u> hendelser som har en dato, bli vist.";
##$pgv_lang["style_help"]					= "~#pgv_lang[style]#~<br /><br />This option controls how the information is presented.<br /><br />When you select <b>#pgv_lang[style1]#</b>, the information is shown in text form, similar to what you see in the various Chart boxes.  This format is well suited to blocks that print on the right side of the page.<br /><br />When you select <b>#pgv_lang[style2]#</b>, the information is shown in tabular format, and is more suited to the larger blocks that print on the left side of the page.";
##$pgv_lang["cal_dowload_help"]			= "~#pgv_lang[cal_download]#~<br /><br />This option controls whether the button for downloading calendar events is shown to logged-in users. The downloaded calendar file can be imported into compatible programs such as Microsoft Outlook to, for example, generate automatic e-mail reminders of anniversaries.<br /><br />When set to <b>#pgv_lang[no]#</b>, the logged-in user will not be able to download the calendar file.  When set to <b>#pgv_lang[yes]#</b>, the Download button will be shown.  This button is never shown when the user is not logged in.";
##$pgv_lang["index_charts_help"]		= "~#pgv_lang[charts_block]#~<br />This block allows a pedigree, descendancy, or hourglass chart to appear on the Welcome or the MyGedView page.  Because of space limitations, the charts should be placed only on the left side of the page.<br /><br />When this block appears on the Welcome page, the root person and the type of chart to be displayed are determined by the administrator.  When this block appears on the user's personalized MyGedView page, these options are determined by the user.<br /><br />The behavior of these charts is identical to their behavior when they are called up from the menus.  Click on the box of a person to see more details about them.<br /><br />";
$pgv_lang["index_onthisday_help"]		= "~Rammen: #pgv_lang[on_this_day]#~<br />Denne rammen viser deg \"dagens\" hendelser i slektsbasen (med samme dato i året som i dag).<br />";
$pgv_lang["index_favorites_help"]		= "~Rammen: Favoritter~<br />\"#pgv_lang[gedcom_favorites]#\" er tilsvarende \"#pgv_lang[my_favorites]#\" som finnes på sidene til registerte brukere. - Forskjellen er at her er det bare administrator(er) til nettstedet som kan legge til, slette eller endre Favoritter.<br />Hensikten med denne favoritter er å skape oppmerksomhet rundt personen(e) eller fordi personen(e) er viktig i slekten.<br /><br />For å spare plass, innholder feltet begrenset informasjon.<br />På høyre side i navneboksen vil du se en meny og et forstørrelsesglass. Den øverste kan ta deg til ulike sider for mer informasjon om personen, mens den nederste viser deg litt mer informasjon med en gang.<br /><br />\"#pgv_lang[gedcom_favorites]#\" er tilgjengelig på toppen av alle sider.<br />";
$pgv_lang["index_add_favorites_help"]	= "~Legg til en favoritt~<br />Her kan du legg til en ny favoritt i listen over favoritter i slektsbase.  Du må enten angi IDen til en:<ul><li>Person</li><li>Familie</li><li>Kilde</li></ul>eller<ul><li>Internettadresse (URL) og en tittel</li></ul>I notefeltet, som er valgfritt, kan du gi en beskrivelse av favoritten.  Denne vil i tilfelle bli vist rett etter favoritten i rammen for favoritter.<br /><br />";
$pgv_lang["index_stats_help"]			= "~Rammen: Statistikk for slektsbasen~<br />I denne rammen vil du se noen statistiske opplysninger om den aktive slektsbasen.<br />Dersom du ønsker mer informasjon, kan du imidlertid sende en forespørsel til kontaktpersonen som du finner nederst på siden.<br />";
$pgv_lang["index_common_names_help"]	= "~<i>Mest brukte etternavn</i>~<br />Nederst i rammen for statistikk, kan du finner du en oversikt over de etternavnene som er mest brukt i den aktive slektsbasen. - Et etternavn må finnes flere ganger enn #COMMON_NAMES_THRESHOLD# for å vises. Det er administratoren til nettstedet som betemmer dette.<br /><br />Ved å klikke på et av navn, vil du bli sendt videre til en liste med personer som har dette etternavnet. Der vil du igjen kunne få flere opplysninger om de ulike personene som har dette navnet.<br />";
##$pgv_lang["index_common_given_names_help"]		= "~MOST COMMON GIVEN NAMES~<br />This block displays a list of frequently occurring given names from this database. You can configure how many given names should appear in the list.<br /><br />";
$pgv_lang["index_media_help"]			= "~Rammen: Tilfeldig utvalgt bilde / medie~<br />Hver gang du besøker denne siden vil rammen vise deg et tilfeldig valgt bilde eller annen mediafil.<br /><br />Ved å klikke på bildet, eller på navnet til det, vil du få se bildet eller annen mediafil i et nytt vindu.<br />Under bildet er det en link til personen, familien eller kilden, som det er knyttet til.<br />Ved å klikke på den nederste linken, vil du få opp siden med fakta om personen, familien eller kilden.<br />";
$pgv_lang["index_loggedin_help"]		= "~Rammen: Brukere logget inn~<br />Denne rammen vil vise deg antall og/eller hvilke brukere som er logget på det gjeldende tidspunktet.<br />Under hver bruker vil du kunne finne en link for å sende en beskjed til brukeren.<br />";
$pgv_lang["index_gedcom_news_help"]		= "~Rammen: Nyheter~<br />Nyhetsrammen er på en måte en oppslagstavle for denne slektsbasen.<br />Administratoren til nettstedet kan her legge inn viktige kunngjøringer eller interessante nyhetsmeldinger.<br /><br />Dersom du har noe interessant å meddele andre brukere og besøkende, vennligst kontakt administratoren til nettstedet via linken nederst på siden.";
$pgv_lang["recent_changes_help"]		= "~Rammen: Siste endringer~<br />Denne rammen viser deg de aller siste endringer som er gjort i slektsfilen. Dette er knyttet til faktakoden CHAN.<br />";
##$pgv_lang["gedcom_news_limit_help"]		= "You can limit the number of News articles displayed, thereby reducing the height of the GEDCOM News block.<br /><br />This option determines whether any limits should be applied or whether the limit should be according to the age of the article or according to the number of articles.<br /><br />";
##$pgv_lang["gedcom_news_flag_help"]		= "Enter the limiting value here.<br /><br />If you have opted to limit the News article display according to age, any article older than the number of days entered here will be hidden from view.  If you have opted to limit the News article display by number, only the specified number of recent articles, ordered by age, will be shown.  The remaining articles will be hidden from view.<br /><br />Zeros entered here will disable the limit, causing all News articles to be shown.<br /><br />";
##$pgv_lang["gedcom_news_archive_help"]	= "To reduce the height of the News block, the administrator has hidden some articles.  You can reveal these hidden articles by clicking the <b>#pgv_lang[gedcom_news_archive]#</b> link.<br /><br />";
##$pgv_lang["index_htmlplus_help"]		= "~#pgv_lang[htmlplus_block_name]#~<br />This block lets the administrator add information to the Index or Portal page.  Its purpose is similar to the #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, and #pgv_lang[gedcom_stats_block]# blocks, but the administrator has more control over its appearance.<br /><br />";
##$pgv_lang["index_htmlplus_title_help"]	= "~#factarray[TITL]#~<br />This text should be blank or very brief.  When blank, the Advanced HTML block will show on the Index or Portal page as a plain block, just like the HTML block does.  When there is text, the Advanced HTML block will show like all the other blocks, complete with a block title bar containing the text you enter here.<br /><br />";
##$pgv_lang["index_htmlplus_template_help"]	= "~#pgv_lang[htmlplus_block_templates]#~<br />To assist you in getting started with this block, we have created several standard templates.  When you select one of these templates, the text area will contain a copy that you can then alter to suit your site's requirements.<br /><br />";
##$pgv_lang["index_htmlplus_content_help"]	= "~#pgv_lang[htmlplus_block_content]#~<br />Unlike the #pgv_lang[html_block_name]#, #pgv_lang[gedcom_news_block]#, and #pgv_lang[gedcom_stats_block]# blocks, you have full control over the appearance of your block.  You can use HTML tags, and the block uses the CSS style sheets from the currently active theme.  References to information from the currently active genealogical database can be included in the text.<br /><br />Database references are signalled in the text by enclosing keywords within paired <b>&#35;</b> symbols.  For example, <b>&#35;totalFamilies&#35;</b> represents the number of families in the database.  On occasion, you may wish to use a database reference as text instead of its true meaning.  To do so, you need to replace the <b>&#35;</b> symbols enclosing the keyword by their symbolic equivalent.  For example, if your text contains <b>&amp;&#35;35;totalFamilies&amp;&#35;35;</b> it will print as <b>&#35;totalFamilies&#35;</b> instead of becoming a database reference.<br /><br />For a full example of the use of this block, please examine the &quot;#pgv_lang[gedcom_stats_block]#&quot; template found in the blocks/ directory, it uses most of the styles of tags, including language and help text links.<br /><br />The <b>#pgv_lang[htmlplus_block_keyword]#</b> template contains a full list of all supported keywords.<br /><br />";
##$pgv_lang["index_htmlplus_compat_help"]	= "~#pgv_lang[htmlplus_block_compat]#~<br />Enable compatibility with older versions of this block.  When checked, both old and new keywords will be recognized and acted upon.<br /><br />For example, the text <b>&#35;TOTAL_FAM&#35;</b> will be recognized as being equivalent to <b>&#35;totalFamilies&#35;</b>, <b>&#35;FIRST_DEATH_PLACE&#35;</b> to <b>&#35;firstDeathPlace&#35;</b>, <b>&#35;TOP10_BIGFAM&#35;</b> to <b>&#35;topTenLargestFamily&#35;</b>, etc.<br /><br />Unless absolutely necessary, you should not use Compatibility mode.<br /><br />";
##$pgv_lang["index_htmlplus_gedcom_help"] = "~#pgv_lang[htmlplus_block_gedcom]#~<br />Select the database to which the keywords apply.<br /><br />Your site supports several databases.  Keywords such as <b>&#35;totalFamilies&#35;</b> can only refer to one database.  You can identify the database that is to be consulted for all such keywords.  Each #pgv_lang[htmlplus_block_name]# block can only access one database.<br /><br />";
##$pgv_lang["showUnknown_help"]	= "~#pgv_lang[showUnknown]#~<br />Hide or show the list of given names of persons of unknown gender.<br /><br />The #pgv_lang[block_givn_top10]# block always hides the list of given names when no persons of that gender exist in your database.  This option lets you hide the list of persons of unknown gender even when there are such persons in your database.<br /><br />";

//-- Index-Page Help
$pgv_lang["help_help"]					= "Det ville selvsagt vært optimalt å lage et program som var så enkelt å bruke, at det ikke trengte noen forklaringer i det hele tatt.<br />Det skulle vært så enkelt som å lese en bok (som om det er enkelt for alle...).<br />Selv om det er et omfattende program som ligger bak sidene, så merker ikke du det som bruker, med unntak kanskje av at enkelte sider kan føles litt treige å få fram.<br />Men siden vi har mange besøkende og brukere som kan føle seg som nybegynnere i forhold til datamaskiner og slektsforskning, så tilbyr vi deg litt hjelp på visse steder.<br />I menyen under hjelp, vil du finne følgende menyvalg:<br />";
$pgv_lang["help_page_help"]				= "<dl><dt><b>#pgv_lang[help_for_this_page]#</b></dt><dd>For alle sider er det tilgjengelig en kortfattet \"sidehjelp\".<br />Når du er på en side, kan du klikke på dette menyvalget. Da vil du få \"hjelp for denne siden\", som vil fortelle deg om de ulike elementene som du kan finne på den gjeldende siden.<br />Dersom du ønsker mer hjelp, eller info om spesielle elementer på siden, da må du bruke spørsmålstegnene som du kan finne bak ulike valg. Sjekk for øvrig at det tredje menyvalgte på Hjelp: \"Hjelp (?) for tekst\" er aktivert.</dd></dl>";
$pgv_lang["help_content_help"]			= "<dl><dt><b>#pgv_lang[help_contents]#</b></dt><dd>Ved å klikke på dette menyvalget så vil du få opp et hjelpevindu, som viser en oversikt med de fleste emner du kan få hjelp med.</dd></dl>";
##$pgv_lang["help_faq_help"]			= "<dl><dt><b>FAQ List</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
##$pgv_lang["help_HS_help"]			= "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]				= "<dl><dt><b>Skjul / #pgv_lang[show_context_help]#</b></dt><dd>Dette menyvalget er kanskje det mest nyttige for deg. Ved å klikke på dette valget vil enten \"Hjelp til tekst\" vises eller skjules.<br /><br />Hva er så \"Hjelp til tekst\" ?<br />Når den vises, vil du kunne finne et spørsmålstegn til høyre for de fleste titteler, linker, valg og knapper. Ved å klikke på dette <b>?</b>, vil det komme fram et vindu med hjelp / informasjon om dette objektet.<br /><br />Og motsatt, dersom du velger \"#pgv_lang[hide_context_help]#\", vil det ikke bli vist noen spørsmålstegn på sidene lengre.</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]					= "<div class=\"name_head\"><center><b>Definisjoner</b></center></div><br />Her er forklaring på noen ord som er brukt i denne hjelpeteksten:<ul><li><a href=\"#def_gedcom\">GEDCOM (slektsfil)</a></li><li><a href=\"#def_gedcom_date\">Datoer</a></li><li><a href=\"#def_pgv\">PhpGedView</a></li><li><a href=\"#def_portal\">Velkomstside</a></li><li><a href=\"#def_theme\">Stil</a></li></ul>";
$pgv_lang["def_portal_help"]			= "~<i>Velkomstside</i>~<br />Dette er hovedinngangen til slektsbasen. Det er her de fleste kommer når de besøker slektsidene. Her kan du finne viktig informasjon som forklaringer, beskjeder osv.<br />Men, - selvsagt er det også mulig å gå inn en eller flere \"kjøkkenveier\" ...<br />";
$pgv_lang["def_gedcom_help"]			= "~<i>GEDCOM (slektsfil)</i>~<br />En GEDCOM-fil er en data-fil der all informasjon lagres om en slekt. Det finnes også slektsfiler med innhold fra kirkebøker eller hele kommuner.<br />Alle personer, familier, fakta, datoer, hendelser, kildehenvisninger osv. kan lagres lagres i en slektsfil.<br />For å lage en slektsfil (noe de fleste slektsprogram har eksport-valg for), må en følge klare regler. Dette gjør at det er mulig å utveksle data mellom ulike slektsprogram, datamaskintyper og/eller systemer.<br /><br /><b>PS 1.</b> Bilder og andre mediefiler lagres ikke i slektsfilen, bare henvisning der disse er plassert som f.eks. på harddisken og/eller internett (URL)!<br /><br /><b>PS 2.</b> Når slektsfilen er lest inn i PhpGedView blir den som oftes omtalt som slektsbasen.<br /><br /><div class=\"list_value_wrap\"><b>Historikk</b>:<br />GEDCOM ble definert av \"Familiehistorisk avdeling til Jesu Kristi kirke av de siste dages hellige\" (LDS kirken/ Mormonerne) for å få en fleksibel, ensartet standard for utveksling av slektsopplysninger lagret i dataprogram.<br />GEDCOM er et akronym for <i><b>GE</b></i>nologisk <i><b>D</b></i>ata <i><b>Com</b></i>munikasjon.&nbsp; Hovedhensikten var og er å hjelpe til med utveksling av genealogisk informasjon og utvikling av et spekter av inter-operasjonelle programvare-produkter til hjelp for slektsforskere, historikere og andre forskere.</div><br />Du kan få mer informasjon ved å ta en kikk på <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank>GEDCOM 5.5.1 standarden</a> (PDF-filtype og på engelsk), som PhpGedView er tuftet på.<br /><br />";
$pgv_lang["def_gedcom_date_help"]		= "~<i>Datoer i en slektsfil</i>~<br />Fordi formatet til slektsfiler må følge internasjonale regler (<a href=\"?help=def_gedcom_help\">GEDCOM</a>), gjelder dette også til en viss grad også for datoer.<br /><br />Selv om dato-feltet i en slektsfil er et åpent felt (betyr at du også kan skrive inn bare tekst), så bør en likevel følge visse standarder:<dl><dt><b>Fullstendig dato</b></dt><dd>Skrives som \"DD MMM YYYY\":<br />01 Mar 1801 eller 14 Dec 1950</dd><dt><b>Ufullstendig dato</b></dt><dd>Skrives som om den var fullstendig:<br />(Du kjenner f.eks. ikke dagen eller året)<br />Mar 1801 eller 14 Dec<br />Dersom du ikke er sikker eller at datoen er ubekreftet, kan du skrive:<br />abt Mar 1801 (abt = about = omtrent)<br />bef 20 Dec 1950 (bef = before = før)<br />aft 1949 (aft = after = etter)</dd></dl>Datoer og forkortelser bør/må skrives på engelsk, fordi da kan slektsfilen utveksles med andre program. Slektsprogrammene vil oversette alle datoer og forkortelser til ønsket språk.<br />Programmene gjør også ulike beregninger med datoene og for at resultatet skal bli riktig, må dato-formatet følge en gitt standard.<br />";
##$pgv_lang["def_gramps_help"]		= "~GRAMPS XML Database file~<br />A quote from GRAMPS Project: <div class=\"list_value_wrap\">GRAMPS helps you track your family tree. It allows you to store, edit, and research genealogical data. GRAMPS attempts to provide all of the common capabilities of other genealogical programs, but, more importantly, to provide an additional capability of integration not common to these programs. This is the ability to input any bits and pieces of information directly into GRAMPS and rearrange/manipulate any/all data events in the entire data base (in any order or sequence) to assist the user in doing research, analysis and correlation with the potential of filling relationship gaps.</div><br />A copy of the GRAMPS XML format v1.1.0 <a href=\"http://www.gramps-project.org/xml/1.1.0/\" target=\"_blank\">can be found here</a> in both RELAX NG Schema format and DTD format.<br /><br />For more information about the GRAMPS Project visit <a href=\"http://gramps-project.org/\" target=\"_blank\">http://gramps-project.org/</a>";
$pgv_lang["def_pgv_help"]				= "~<i>PhpGedView</i>~<br />PhpGedView #VERSION# (eller PGV) er et program, formgitt av John Finlay, for å kunne se på slektsopplysninger på nettet.<br />John startet utviklingen av dette programmet, men etter hvert har det kommet til et stort, internasjonalt team med utviklere og oversettere som jobber sammen for å utvikle og forbedre programmet.<br />- Som du kanskje har sett, så viser ikke dette programmet statiske sider, men er dynamisk og kan tilpasses den enkelte bruker.<br />I tillegg til at besøkende kan velge ut hva de vil se på i slektsbasen(e), kan registerte brukere få rettigheter til å legge til og endre personer, hendelser mm. direkte på nettet.<br />";
$pgv_lang["def_theme_help"]				= "~<i>Stil</i>~<br />Dette nettstedet kan ha flere forskjellige \"ansikter\", kallt Stiler.<br />Administratoren til nettstedet kan velge et standard-stil.<br />Alle som går inn på dette nettstedet vil da få den samme layouten (Stil). Dersom administratoren til nettstedet godkjenner brukere av sidene, kan disse velge sin egen stil som de fortrekker for seg selv.<br />Dersom en bruker har valgt en annen stil, vil han/hun få dette utseende så snart de har logget seg inn.<br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~Siden: Min GedView~<br />Dette er din personlige #pgv_lang[mgv]#-side.<br />Her kan du finne hurtig-linker til dine personlige data, som <b>#pgv_lang[editowndata]#, #pgv_lang[my_indi]#</b> (dette er siden der dine personlige data vises) og <b>#pgv_lang[my_pedigree]#</b>.<br />I tillegg kan du ha en ramme med <b>Beskjeder</b>, en <b>Notatblokk</b> (som en oppslagstavle) og flere andre.<br /><br />Denne siden har det samme utseende som Hovedsiden.<br />Mens rammene på Hovedsiden er valgt av adminstratoren til nettstedet, kan du velge deg dine egne rammer på denne siden (med visse begrensninger selvsagt...).<br /><br />I velkomstrammen på siden din, vil du finne linken for å endre denne siden.<br /><br />Du kan velge blant følgende rammer:<ul><li><a href=\"#mygedview_welcome\">Velkommen</a></li><li><a href=\"#mygedview_customize\">Tilpass din GedView-side</a></li><li><a href=\"#mygedview_message\">Beskjeder</a></li><li><a href=\"#mygedview_events\">Kommende begivenheter</a></li><li><a href=\"#mygedview_onthisday\">Årsdag for hendelser i slekten</a></li><li><a href=\"#mygedview_favorites\">Mine favoritter</a></li><li><a href=\"#mygedview_stats\">#pgv_lang[gedcom_stats]#</a></li><li><a href=\"#mygedview_myjournal\">#pgv_lang[my_journal]#</a></li><li><a href=\"#mygedview_media\">Tilfeldig utvalgt bilde / medie</a></li><li><a href=\"#mygedview_loggedin\">Brukere logg inn</a></li><li><a href=\"#mygedview_recent_changes\">#pgv_lang[recent_changes]#</a></li></ul><br />";
$pgv_lang["mygedview_customize_help"]	= "~Tilpass din GedView-side~<br />Når du kom inn på denne siden første gang, hadde du allerede noen rammer på siden.<br />Dersom du ønsker det, kan du tilpasse denne siden etter dine egne ønsker/behov.<br />Ved å klikke på denne linken, vil du få opp et nytt vindu med et skjema, der du kan legge til, slette eller flytte på rammer.<br />Mer forklaring er tilgjengelig i det skjemaet.<br />";
$pgv_lang["mygedview_message_help"]		= "~Rammen: Beskjeder~<br />I denne rammen vil du finne beskjedene, sendt til deg av andre brukere, eller fra Admin.<br />Selvsagt kan du også sende dine egne beskjeder til andre brukere eller admin.<br />Postsystemet i PhpGedView er laget med tanke for å ta vare på ditt eget personvern. Du behøver ikke oppgi epost-adressen din her og andre vil ikke kunne se epost-adressen din heller.<br /><br />For å gjøre tillegg i en beskjed kan du klikke på overskriften til beskjeden eller på \"<b>+</b>\" tegnet ved siden av den.  Du kan slette flere beskjeder ved å merke boksen ved siden av beskjedene som du ønsker å slette og deretter klikke på knappen \"Slett valgte beskjeder\".<br />";
$pgv_lang["mygedview_favorites_help"]	= "~Rammen: Mine favoritter~<br />Mine favoritter virker på samme måten som å sette inn bokmerker i slektsbasen.<br />Tenk deg at du har noen i slekten, som har opplysninger du ønsker å sjekke regelmessig.<br />Da går du til siden med fakta om personen, og klikke på linken \"Legg til i Mine favoritter\". Denne personen har nå fått et bokmerke og blitt lagt inn i listen med Favoritter.<br />Nå vil du finne denne favoritten ved å klikke på feltet \"Mine favoritter\" på toppen av den siden du er på.<br /><br />Ved å klikke på navnet, vil du bli sendt til siden med fakta om personen.<br />";
$pgv_lang["mygedview_myjournal_help"]	= "~Rammen: Min notatblokk~<br />Du kan bruke denne notatblokken til å skrive kommentarer (eller huskelapper) for eget bruk.<br />Selvsagt vil notatet også være der neste gang du besøker siden.<br /><br />Disse notatene vil ikke være synlige for andre.<br />";
$pgv_lang["mygedview_welcome_help"]		= "~Rammen: Velkommen~<dt>Denne velkomstrammen viser deg:</dt><dd>- Den aktive slektsbasen</dd><dd>- Dato og klokkeslett</dd><dd>- Linker til:</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (se PS under)</dd><dd>- - #pgv_lang[my_indi]# (se PS under)</dd><dd>- - #pgv_lang[customize_page]#</dd><br /><b>PS !</b>  Du vil bare kunne se linkene til \"#pgv_lang[my_indi]#\" og \"#pgv_lang[my_pedigree]#\" dersom du er registrert i den aktive slektsbasen.<br />Derfor vil du kunne se disse linkene i noen slektsbaser, mens i andre der du ikke er registert, vil du ikke se disse linkene...<br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~Siden: Anetre~<br /><br />Et slektstre er en opptelling av alle forfedre/-mødre til start-/hovedpersonen.<br />Når du åpner siden, er startpersonen valgt av administratoren til nettstedet vist til venstre. Dersom du har logget deg inn som en bruker, kan du ha valgt din egen start-/hovedperson.<br /><br />\"Alle forfedre\" betyr som sagt far og mor, og deres foreldre osv.<br />På denne siden er slektstreet vist grafisk.  Du behøver ikke lete på flere sider med tekst for å finne ut hvor forfedrene dine er.<br />Alle personene blir vist i egne bokser med linjer mellom som viser tilhørigheten.<dl><dt><b>Navneboksene på slektstreet</b></dt><dd>Dersom slektstreet er satt opp til å vise detaljer, vil du se navnet til personen og datoene for fødsel og eventuelt død.<br />Du kan klikke på navnet til personen, og da vil du bli vist en side med fakta om denne personen.</dd><dt><b>Ikoner inni navneboksen</b></dt><dd>Når valget \"Vis detaljer\" er merket, er det også to ikoner inne i hver navneboks. Avhengig av oppsettet for nettstedet må du enten bevege musen over ikonet, eller klikke på det.<br />Når du klikker, eller beveger deg over dette ikonet, så vil det komme fram en ny undermeny.<br />Valgene \"#pgv_lang[index_header]#\" og \"#pgv_lang[descend_chart]#\" er tilsvarende dem du finner i hovedmenyen, men forskjellen er at start-personen nå er personen i den valgte boksen.<br />Du vil også se \"#pgv_lang[fam_spouse]#\". Under der ser du navnet på ektefellen/parneren, fulgt av eventuelle barn.<br />Du kan klikke på alle navn.</dd><dt><b>Forstørrelsesglass inni navneboksen</b></dt><dd>Dette ikonet er også påvirket av oppsettet for siden. Du må enten bevege musen over det, eller klikke på det.<br />Dette gjør navneboksen større slik at det blir vist flere opplysninger om personen.<br />Du vil se flere hendelser og tilhørende datoer. Også her kan du klikke på eventuelle navn.</dd><dt><b>Pilene</b></dt><dd>Til venstre og høyre for de ytterste navneboksen(e) til venstre og høyre på skjermen vil du kunne se piler.<br />Disse gir deg mulighet, ved å klikke på dem, til å forskyve slektstreet et slektsledd ned eller opp.</dd></dl><br />#pgv_lang[context_help]#<br/ ><br />";
$pgv_lang["show_full_help"]				= "~Vis eller skjul detaljer~<br /><br />Med dette valget kan du enten vise alle detaljer i navnboksene, eller skjule detaljer.<br />Dersom detaljene er skjult, vil du kunne vise flere bokser på et skjermbilde.<br /><br />Velger du å skjule detaljer, kan du likevel få se dem ved å bruke forstørrelsesglasset. Det avhenger imidlertid av om administratoren til nettstedet har aktivert det.<br /><br />Når detaljene vises og Zoom-fuksjonen er tilgjengelig, kan du få fram enda flere opplysninger om personen.<br />Hvis du til vanlig kan klikke på forstørrelsesglasset for å zoom inn, så vil du også kunne få fram flere opplysninger ved å klikke på den enkelte navnboksen.<br />Dersom du kan zoome inn bare ved å bevege musa over forstørrelsesglasset, så vil det virke på samme måte når du beveger deg over hver boks.<br /><br />Dersom du har klikket for å få fram flere opplysninger, kan du gå tilbake til normal visning igjen ved å klikke på nytt på Zoom-ikonet.  Tilsvarende vil skje dersom bare trengte å beveget musa over Zoom-ikonet, så er det bare flytte musa vekk fra ikonet for å få noral visning igjen.<br /><br />";
$pgv_lang["talloffset_help"]			= "~Diagram-oppsett~<br /><br />Med dette valget kan du bestemme hvordan diagrammet skal bli vist.<br />Dette kan være nyttig dersom du vil skrive ut diagrammet eller<br />hvis du vil tilpasse skjermbildet i forhold til oppløsningen på skjermen din.<dl><dt><b>Stående</b></dt><dd>Ved å velge dette vil gjøre diagrammet høyere slik at 4 slektsledd burde passe inn på ett A4-ark med stående utskrift.</dd><dt><b>Liggende</b></dt><dd>Ved å velge dette vil gjøre diagrammet bredere slik at 4 slektsledd burde passe inn på ett A4-ark med liggende utskrift.</dd></dl>";
$pgv_lang["rootid_help"]				= "~Ny startperson / Finn ID~<br /><br />Dersom du ønsker å vise et diagram med en ny startperson, så kan du i denne boksen angi IDen til personen.<br />Dersom du ikke kjenner ID-nummeret til personen, kan du bruke linken <b>Finn ID</b>.<dl><dt><b>NB!</b></dt><dd><i>ID-nummer som brukes i PhpGedView er ikke det samme som personnummeret til en person!<br />Nummeret brukes bare i slektsfiler, og er tildelt av det slektsprogrammet som lagde slektsfilen og som PhpGedView etterpå importerte!</i></dd></dl>";
$pgv_lang["PEDIGREE_GENERATIONS_help"]	= "~Antall slektsledd~<br /><br />Her kan du angi antall slektsledd som skal vises på denne siden.<br />Hva som er best for deg avhenger av størrelsen på skjermen din og om du viser detaljer eller ikke. Tiden det tar å vise siden har også sammenheng med antall slektsledd som vises.<br /><br />";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~Siden: Logg inn~<br /><br />På denne siden kan du logge deg inn, be om et nytt passord eller be om en ny brukerkonto.<br />";
$pgv_lang["username_help"]				= "~Brukernavn~<br /><br />I denne boksen skriver du inn brukernavnet ditt.<br />Brukernavnet må skrives nøyaktig slik det ble opprettet (små og/eller store bokstaver)";
$pgv_lang["password_help"]				= "~Passord~<br /><br />I denne boksen skriver du inn passordet ditt.<br />Passordet må skrives nøyaktig slik det ble opprettet (små og/eller store bokstaver)";
$pgv_lang["login_buttons_help"]			= "~Logg inn - knapper~<br /><br />Her ser du to knapper for å logge deg inn på systemet.<br />Det er avhengig av den knappen du velger for hvor du blir sendt videre etter å ha oppgitt brukernavn og passord.<dl><dt><b>#pgv_lang[login]#</b></dt><dd>Hvis du klikker på den venstre knappen, vil du komme tilbake til den siden du kom fra.<br />Så, dersom du klikket \"#pgv_lang[login]#\" da du var på siden med slektstre, vil du komme tilbake til denne siden.<br />Dersom du klikket på <b>#pgv_lang[mygedview]#</b> i menyen, vil du gå direkte til din personlige side, der du kan endre oppsettet ditt, legge til eller endre favoritter, sende og lese beskjeder og så videre.</dd><dt><b>#pgv_lang[admin]#</b></dt><dd>Dersom du har rettigheter som administrator, kan du klikke på knappen til høyre og gå direkte til siden for å administrere nettstedet.</dd></dl>";
$pgv_lang["login_buttons_aut_help"]		= "~Bruker-godkjenning~<br /><br />Her ser du to knapper for å logge deg inn i systemet.<dl><dt><b>#pgv_lang[login]#</b></dt><dd>Vanlige brukere benytter bare denne knappen etter at de har oppgitt brukernavn og passord. Da vil de bli sendt til sin egen Min GedView-side, hvor de kan sende og lese beskjeder, endre oppsettet sitt, legge til eller endre favoritter osv.</dd><dt><b>#pgv_lang[admin]#</b></dt><dd>Denne virker bare for brukere som har administrajon rettigheter. Ved å klikke på denne knappen vil siden for administrasjon av nettstedet bli vist.</dd></dl>";
$pgv_lang["new_password_help"]			= "~<i>Be om nytt passord</i>~<br />Dersom du har mistet passordet ditt, kan du klikke på denne linken for å be om et nytt passord.  - Du vil da få opp siden \"Forespørsel om nytt passord\".";
$pgv_lang["new_user_help"]				= "~<i>Søke om en brukerkonto</i>~<br />Dersom du er en gjest på dette nettstedet og ønsker å få en brukerkonto, kan du klikke på denne linken.  - Du vil da få opp siden med \"Søknad\".<br /><br />";
$pgv_lang["mygedview_login_help"]		= "<center><b>Siden <i>Min GedView</i> er bare tilgjengelig for <i>registerte brukere</i>.</b><br /><br />I <b><i>Min GedView</i></b> kan du lage dine egne snarveier til favoritt-personer,<br />notere i notatblokken din, sende meldinger, se loggen til andre brukere<br />eller skreddersy ditt eget oppsett av PhpGedView.<br /><br />Dersom du har brukernavn og passord, så logg deg inn i feltene under.</center />";
$pgv_lang["new_user_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I dette feltet må du oppgi fornavnet ditt.<br /><br />Vi trenger både fornavn og etternavn for å finne ut om du kan få en konto på dette nettstedet, og hvilke rettigheter du skal få.  Heløe navnet vil også bli vist til andre innloggede familiemedlemmer og brukere.<br /><br />";
$pgv_lang["new_user_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I dette feltet må du oppgi etternavnet ditt.<br /><br />Vi trenger både fornavn og etternavn for å finne ut om du kan få en konto på dette nettstedet, og hvilke rettigheter du skal få.  Heløe navnet vil også bli vist til andre innloggede familiemedlemmer og brukere.<br /><br />";
$pgv_lang["register_info_01"]	= "~Søke om å få en brukerkonto~<br /><br />Opplysninger som kan vise offentlig på dette nettstedet, kan være begrenset i henhold til lov om personvern.<br />Mange personer vil heller ikke at deres personlige data ligger åpent på internett.<br />Disse kan bli misbrukt til spam eller av identitetstyver.<br /><br />For å få tilgang til dette nettstedet, må du be om å få en brukerkonto.<br />Etter at kontoen din er blitt godkjent, vil du kunne logge deg inn.<br /><br />Dersom personvern for slektskap er aktivert, vil du etter å ha logget deg inn, bare få tilgang til private opplysninger til de nærmeste slektningene dine.<br />Administrator kan også gi deg tilgang til å gjøre endringer eller legge til informasjon i slektsbasen.<br /><br />Hvis du trenger mer opplysninger, kan du bruke linken under til å kontakte ansvarlig for nettstedet.<br /><br />";
$pgv_lang["register_info_02"]	= "~Søke om å få en brukerkonto~<br /><br />Opplysninger som kan vise offentlig på dette nettstedet, kan være begrenset i henhold til lov om personvern.<br />Mange personer vil heller ikke at deres personlige data ligger åpent på internett.<br />Disse kan bli misbrukt til spam eller av identitetstyver.<br /><br />For å få tilgang til dette nettstedet, må du be om å få en brukerkonto.<br />Dersom kontoen din blir godkjent, vil du kunne logge deg inn og se private data.<br /><br />Dersom personvern for slektskap er aktivert, vil du etter å ha logget deg inn, bare få tilgang til private opplysninger til de nærmeste slektningene dine.<br />Administrator kan også gi deg tilgang til å gjøre endringer eller legge til informasjon i slektsbasen.<br /><br />Hvis du trenger mer opplysninger, kan du bruke linken under til å kontakte ansvarlig for nettstedet.<br /><br />";
$pgv_lang["register_info_03"]	= "~Søke om å få en brukerkonto~<br /><br />Opplysninger som kan vise offentlig på dette nettstedet, kan være begrenset i henhold til lov om personvern.<br />Mange personer vil heller ikke at deres personlige data ligger åpent på internett.<br />Disse kan bli misbrukt til spam eller av identitetstyver.<br /><br />Det er <u>bare familimedlemmer</u> som har eller kan få tilgang til dette nettstedet! Har du ikke konto, må du søke.<br />Dersom kontoen din blir godkjent, vil du kunne logge deg inn og se private data.<br /><br />Dersom personvern for slektskap er aktivert, vil du etter å ha logget deg inn, bare få tilgang til private opplysninger til de nærmeste slektningene dine.<br />Administrator kan også gi deg tilgang til å gjøre endringer eller legge til informasjon i slektsbasen.<br /><br />Hvis du trenger mer opplysninger, kan du bruke linken under til å kontakte ansvarlig for nettstedet.<br /><br />";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~Siden: Etterkommere~<br /><br />Denne siden vil vise etterkommere til personen.<br />Du kan velge en hovedperson for denne etterkommer-oversikten, eller så kan du bli overført til denne siden ved å klikke på linken \"#pgv_lang[descend_chart]#\" på en annen side.<br />Ved å klikk på en pil, vil hovedpersonen bli byttet ut med foreldrene til den personen pilen stod ved siden av.  Klikker du på ikonet øverst til høyre i personboksen vil du få fram en ny meny med nære slektninger til denne personen.";
$pgv_lang["desc_rootid_help"]			= "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]		= "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
##$pgv_lang["help_lifespan.php"]			= "~LIFESPAN CHART~<br /><br />On this chart you can display one or more persons along a horizontal timeline.  This chart allows you to see how the lives of different people overlapped.<br /><br />You can add people to the chart individually or by family groups by their IDs.  The previous list will be remembered as you add more people to the chart.  You can clear the chart at any time with the <b>Clear Chart</b> button.<br /><br />You can also add people to the chart by searching for them by date range or locality.<br /><br />";
##$pgv_lang["lifespan_add_person_help"]			= "#pgv_lang[add_person_help]#~Include Immediate Family CheckBox~<br/>Include Immediate Family is checked by default.  Leave checked to view the father, mother, spouse, siblings, and children of the individual being added to the timeline.  Uncheck if you wish to omit the immediate family.<br/><br/>";
$pgv_lang["help_timeline.php"]			= "~Siden: Tidslinje~<br /><br />På denne siden kan du vise en eller flere person(er) langs en tidslinje.<br />Du kan for eksempel vise statusen til to eller flere personer på et gitt tidspunkt.<br /><ul><li>Dersom du klikker på en Tidslinje-link på en faktaside til en person eller familie, vil denne personen / partnere vises som første person(er) på tidslinjen.</li></ul><ul><li>Dersom du klikker på Tidslinje i toppmenyen, så starter du med en \"blank\" side uten at det er valgt noen person(er).</li></ul>";
$pgv_lang["add_person_help"]			= "~Legge til en person på tidslinjen~<br /><br />Du kan ha flere personer på tidslinjen.<br />Bruk denne boksen til å skrive inn IDen til personen i slektsbasen.<br />Dersom du ikke kjenner IDen til personen, kan du klikke på linken <b>Finn ID</b> bak boksen.";
$pgv_lang["remove_person_help"]			= "~Fjerne en person fra tidslinjen~<br /><br />Klikk på denne linken for å fjerne personen fra tidslinjen.";
$pgv_lang["show_age_marker_help"]		= "~Vis aldersmarkør~<br /><br />Dersom du merker av denne boksen, vil du se en aldersmarkør, som du kan flytte opp eller ned langs tidlinjen.<br />Denne beveglige aldersmarkøren er en fin funksjon for å sjekke alderen til en person på bestemte begivenheter.<br />Du kan vise eller fjerne aldersmarkøren for hver person på tidslinjen.";
##$pgv_lang["timeline_control_help"] = "~LIFESPAN CONTROLS~<br/><br/>~SPEED~<br/>Click the drop down menu to change the speed at which the timeline scrolls.<br/><br/>~Begin Year~<br/>Enter the starting year of the range.<br/><br/>~End Year~<br/>Enter the ending year of the range.<br/><br/>~Search~<br/>Click the Search button to begin searching for events that occurred within the range identified by the Begin Year and End Year fields.<br/><br/>";

//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~Siden: Slektsskap~<br /><br />På denne siden kan du vise familietilhørigheten mellom to personer.<br />Det er ikke sikkert at disse personene har et direkte slektskap (blodslinje).<br />Enhver tilhørighet vil bli funnet!";
$pgv_lang["relationship_id_help"]		= "~ID til Person 1 og 2~<br /><br />Dersom du ble overført til denne siden fra en annen side (for eksempel: ved å ha klikket på linken \"Slektskap til deg\"), så vil du her se slektskapet mellom de to personene.<br />Ellers må du skrive inn IDene til de personene som du ønsker å få vite slektsskapet mellom.<br />Dersom du ikke kjenner IDene til personene, kan du klikke på linken <b>Finn ID</b>";
$pgv_lang["next_path_help"]				= "~Finn neste slektslinje~<br /><br />Du kan klikke på denne knappen for å se om det er flere slektslinjer mellom de to personene.<br />De andre slektslinjene kan vises på nytt ved å klikke på nummeret til slektslinjen.";
$pgv_lang["follow_spouse_help"]			= "~Sjekk slektslinjer via ekteskap (merkeboks)~<br /><br />Når denne boksen <b>ikke</b> er merket, blir slektslinjer bare sjekket mellom de som er i direkte slekt.<br />Dersom boksen er avmerket, vil også slektslinjer mellom gifte bli sjekket.  Du vil sannsynligvis finne flest slektslinjer dersom dette valget er merket.";
$pgv_lang["line_up_generations_help"]	= "~Vis like slektsledd på linje (merkeboks)~<br /><br />Når denne boksen er merket, vil diagrammet bli vist med like genersjoner på samme vannrette linje på skjermen.  Dersom boksen ikke er merket, vil hvert slektsledd bli vist nedover på siden uavhengig av slektskapet mellom f.eks. barn og foreldre.";
$pgv_lang["oldest_top_help"]			= "~Vis eldste øverst (merkeboks)~<br /><br />Når denne boksen er merket, vil diagrammet vise de(n) eldste person(ene) øverst.<br />Dersom boksen ikke er merket, vil de(n) yngste person(ene) bli vist øverst.<br /><br />NB : Dette valget virker bare dersom <i>#pgv_lang[line_up_generations]#</i> også er valgt.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]			= "~Siden: #pgv_lang[ancestry_chart]#~<br /><br />Denne siden er veldig lik <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men har flere opplysninger og mulighet for alternativ <a href=\"?help=chart_style_help\">utforming</a>.<br /><br /><b>Nummerering:</b><br />Hver person i alle slektsledd (generasjoner) er tildelt et unikt nummer, beregnet ut fra <a href=\"#system\">systemet lagd av <i>Sosa</i> og <i>Stradonitz</i></a>:<ul><li>Partall for menn</li><li>Oddetall for kvinner (ektemann+1)</li><li> Eksempel:<ol></li><li>Startpersonen (proband), uavhengig av kjønn</li><li>Far</li><li>Mor (2+1)</li><li>Farfar</li><li>Farmor (4+1)</li><li>Morfar</li><li>Mormor (6+1)</li></ol><br /></li><li>Hvert slektsledd begynner med et tall som også angir hvor mange aner det er i dette slektsleddet (f.eks. starter generasjonen med oldeforeldre på 8 (farfars far) - og vi har dermed 8 oldeforeldre).</li></ul><br /><a name=\"system\"></a><div class=\"list_value_wrap\">Historikk om systemet:<br />Det var den tyske genealogen Stephan Kekule von Stradonitz (1863-1933) som i 1898 tok i bruk dette systemet. Han fant ut at det tidligere hadde vært brukt av den spanske genealog Hieronymus de Sosa på 1600-tallet. Systemet ble allerede i 1590 brukt av tyskeren Michael Eizinger, og det er så logisk at det sikkert har vært brukt av andre før det ble \"gjenoppdaget\" av von Stradonitz.</div>";
$pgv_lang["box_width_help"]				= "~Boksbredde: #pgv_lang[ancestry_chart]# / slekts-hefte~</b><br /><br />Her kan du endre bredden til boksen fra 50% til 300%.<br />Standard verdi er 100%: Bredden på hver boks er da omtrent 270 punkter.";
$pgv_lang["chart_style_help"]			= "~Type diagram~<br /><dl><dt><b>#pgv_lang[chart_list]#</b></dt><dd>Vertikalt tre med mulighet for å skjule / vis (utvide) familier.</dd><dt><b>#pgv_lang[chart_booklet]#</b></dt><dd>En familie pr side, med foreldre, besteforeldre og alle registrerte barn.<br />Dette diagrammet gir pene utskrifter for å gi bort til andre slektninger eller interesserte.</dd></dl>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]			= "~Siden: #pgv_lang[fan_chart]#~<br /><br />Dette valget er veldig likt <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, men viser det på en mer grafisk måte.<ul><li>Start-personen (proband) blir vist i midten, foreldrene i den første ringen, besteforeldrene i den andre ringen, osv...</li><li>Dersom årene for fødsel og død er kjent, vil disse bli vist under navnet.</li><li>Ved å klikke på et navn i diagrammet, vil du få opp et nytt diagram med denne personen som start-person (proband).</li><li>Under navnet til start-personen (proband) er det en pil og ved å klikke på denne, vil du få fram et vindu der du kan velge barn eller søsken til start-personen.</li></ul><b>PS.</b> <i>Dersom nettstedet ikke støtter grafisk visning, vil du ikke få dette valget!</i>";
$pgv_lang["fan_width_help"]				= "~Bredden til #pgv_lang[fan_chart]#~</b><br /><br />Her kan du endre bredden på hjulet fra 50% til 300%.<br />Standard verdi er 100%: Bredden på bildet er da omtrent 640 punkter.";
$pgv_lang["fan_style_help"]				= "~Type #pgv_lang[fan_chart]#~<br /><dl><dt>1/2</dt><dd>Halv sirkel (180 grader) hjul / vifte</dd><dt>3/4</dt><dd>Tre-kvart (270 grader) hjul /vifte eller 'Engle-vinge'</dd><dt>4/4</dt><dd>Hel sirkel (360 grader) hjul</dd></dl>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]		= "~#pgv_lang[hourglass_chart]#~<br /><br />Diagrammet Timeglass vil vise forfedre og etterkommere til valgt person i samme diagram.  Dette diagrammet er en miks mellom diagrammene <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> og <a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a>.<br /><br />Hovedpersonen er sentrert i midten av siden med etterkommere vist til venstre og forfedre til høyre.  I dette diagrammet er hvert slektsledd vist slik at det yngste starter til venstre og ender med det eldste til høyre.<br /><br />";

//-- Family Book chart-page
##$pgv_lang["help_familybook.php"]	= "~#pgv_lang[familybook_chart]#~<br /><br />This chart is very similar to the Hourglass chart.  It will show the ancestors and descendants of the selected root person on the same chart.  It will also show the descendants of the root person in the same Hourglass format.<br /><br />The root person is centered in the middle of the page with his descendants listed to the left and his ancestors listed to the right.  In this view, each generation is lined up across the page starting with the earliest generation and ending with the latest.<br /><br />Each descendant of the root person will become the root person of an additional hourglass chart, printed on the same page.  This process repeats until the specified number of descendant generations have been printed.";
##$pgv_lang["fambook_descent_help"]	= "~#pgv_lang[descent_steps]#~<br /><br />This value determines the number of descendant generations of the root person that will be printed in Hourglass format.<br /><br />";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~Siden: Personliste~<br /><br />På denne siden kan du få en liste med enkeltpersoner.<br /><br />Navnene vil bli vist med etternavnene først og sortert i alfabetisk rekkefølge.<br />Hvordan navnelista blir vist avhenger av:<ol></li><li>Bokstaven du klikket på i alfabet-indeksen.</li><li>Du klikket på Vis \"utvidet liste\" eller \"kun etternavn\".</li></ol>#pgv_lang[context_help]#<br /><br />";
$pgv_lang["alpha_help"]					= "~Alfabetisk indeks~<br /><br />Ved å klikk på en bokstav i alfabet-rekken vil du få fram en liste med navn som starter med den bokstaven du valgte.<br /><br />Som den nest siste i rekken vil du kunne se <b>#pgv_lang[NN]#</b> <br />Denne vises dersom det er personer uten etternavn i slektsbasen eller har et etternavn som begynner med en bokstav som ikke finnes i språkets alfabet.  Ukjente etternavn er ofte registert som <b>?</b>, og da vil de bli vist under <b>#pgv_lang[NN]#</b>.  Dette er også tilfelle dersom personen er ukjent.<dl><dt><b>NB!</b></dt><dd><i>Dersom en person har et <b>etternavn</b> i slektsbasen som for eksempel: Nn, NN, Ukjent eller N.N., vil navnet til denne personen <b>ikke</b> bli vist ved å klikke på <b>#pgv_lang[NN]#</b>. Disse personene vil du finne under \"<b>N</b>\" eller \"<b>U</b>\" i alfabet-rekken (se eksemplene foran).<br />Det er fordi programmet bare søker etter personer <u>uten</u> en oppføring i feltet <b>etternavn</b> i slektsbasen.</i> </dd></dl>Til sist i alfabet-rekken vil du se \"<b>ALLE</b>\". Her vil du få fram en liste med alle etternavn i slektsbasen.<dl><dt><b>Manglende bokstaver?</b></dt><dd><i>Det kan være at enkelte bokstaver i alfabetet <b>ikke</b> blir vist.<br />Det er fordi det ikke er noen personer registert med etternavn som starter med den \"manglende\" bokstaven.</i></dd></dl>";
$pgv_lang["name_list_help"]				= "~Navneliste~<br /><br />Denne tabellen vil enten vise en liste med etternavn eller en utvidet navneliste.<br />I begge tilfeller vil alle etternavnene start med den samme bokstaven som du klikket på i den alfabetiske indeksen. Selvsagt gjelder ikke det dersom du klikket på \"ALLE\"<br /><br />Om ser en liste med kun etternavn eller en utvidet liste, avhenger om du har klikket på linken under boksen.";
$pgv_lang["skip_sublist_help"]			= "~Vis: Kun etternavn / Utvidet liste~<br /><br />Til vanlig vil du få en liste med bare etternavn. Dersom du klikker på denne linken, vil du da få en utvidet liste (med mer informasjon) med personer / familier som har etternavn som starter på samme valgte bokstav.<br />Hvis du har en utvidet liste, vil du få tilbake listen med kun etternavn.<br /><br />Dersom du klikker på et navn i listen med kun etternavn, vil du også få en utvidet liste, men da med personer / familier med bare dette etternavnet.";
##$pgv_lang["show_marnms_help"]			= "~INCLUDE/EXCLUDE MARRIED NAMES~<br /><br />The individual and family list pages can either include or exclude married names.  This option can be helpful when searching for individuals or families where you only know the married name.  Married names can only be included if they already exist in the database.<br /><br />On the family list, this value defaults to exclude.  On the individual list, the default value is set in the GEDCOM Configuration page.<br /><br />When you change this option, your selection will be remembered until you log off or your session ends.<br /><br />";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~Siden: Familieliste~<br /><br />På denne siden kan du få en liste over familier.<br /><br />Navnene vil bli vist med etternavnene først og sortert i alfabetisk rekkefølge.<br />Hvordan navnelista blir vist avhenger av:</dt><ol></li><li>Bokstaven du klikket på i alfabet-indeksen.</li><li>Du klikket på Vis \"utvidet liste\" eller \"kun etternavn\".</li></ol>Du kan søke etter etternavnet til både ektemannen og hustruen. Begge finnes i listen.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["help_family.php"]			= "~Siden: Familie-opplysninger~<br /><br />Denne siden vil vise en oversikt over valgt familie.<br /><br />På venstre side fra toppen ser du følgende bokser:<ul><li>Ektemannen og hans foreldre</li><li>Hustruen og hennes foreldre</li><li>Barna</li></ul>- Utseende og innholdet til boksene er lik den du finner for <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a> og <a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a>.<br />- Klikker du på pilen til høyre for navneboksene til foreldrene, vil du siden med familiesiden til disse forfedrene/-mødrene (dersom disse  i slektsbasen).<br />- <i>Inne</i> i navnerammen til høyre, vil du kunne se et forstørrelsesglass for å vise litt mer informasjon om personen. Ved å klikke på navnet, vil du få opp siden med faktopplysninger om personen.<br /><br />På høyre side fra toppen ser du:<ul><li>Menyen \"#pgv_lang[fams_charts]#\" som inneholder:<dl><dt><b>#pgv_lang[charts]#</b></dt><dd>Her vil du flere varianter av diagrammet #pgv_lang[timeline_chart]# der personer fra denne side er forhåndsvalgt.</dd><dt><b>#pgv_lang[reports]#</b></dt><dd>Her finner du noen rapporter som er relatert til familien. Her vil også denne familien være forhåndsvalgt.</dd><dt><b>#pgv_lang[edit]#</b></dt><dd>Dersom du har de nødvendige rettigheter, vil du her få ulike valg for å legge til, endre eller slette opplysninger for familien.</dd><dt><b>#pgv_lang[other]#</b></dt><dd>Her kan det være at du vil få valget om å legge denne familien i Utklippsmappen og vise opplysningene om denne familien slik de er lagret i slektsfilen.</dd></dl></li><li>#pgv_lang[family_group_info]#<br />Viser alle kjente faktaopplysninger om familien, slik som ekteskap, multimediafiler og noter. Du kan klikke på stedsnavn, datoer, mulimediafiler, kilder mm, og da vil du få opp sider med andre personer som er knytter til de samme faktaene.<br />Dersom du har de nødvendige rettigheter, så kan du endre, slette og legge til fakta også.</li></ul>Under boksene til barna kan du finne du en link for å \"#pgv_lang[add_child_to_family]#\".<br />";
$pgv_lang["add_child_help"]				= "~Legge til et barn til denne familien~<br /><br />Ved å klikke på denne linken, kan du legge til et barn til denne familien ved å fyll ut feltene i det vinduet som kommer fram.<br />";
$pgv_lang["show_fam_gedcom_help"]		= "~#pgv_lang[view_gedcom]#~<br /><br />Ved å klikke på denne linken, vil informasjon om kilden, slik den er lagret i slektsfilen, bli vist i et eget vindu.";
$pgv_lang["add_fam_clip_help"]			= "~Kopier familie til Utklippsmappen~<br /><br />Ved å klikke på denne linken kan du kopiere data om familien, slik den er lagret i slektsfilen, til Utklippesmappen din. På den neste siden som vil bli vist, kan du velge hvilke data som du ønsker å kopiere; Bare (ekte)paret alene, eller med foreldrene og/eller barna deres og/eller alle etterkommere.";
$pgv_lang["show_fam_timeline_help"]		= "~Vis ektepar/partnere på en tidsline~<br /><br />Ved å klikke på denne linken, vil du få fram siden med Tidslinjen. Her vil alle hendelser knyttet til ektefellene bli vist på en grafisk tidslinje.";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]		= "~Siden: Liste med kilder~<br /><br />På denne siden vises en liste over kilder.<br />Det er vanskelig å finne en meningsfull sorterings-rekkefølge for alle type kilder, fordi kilder kan være personer med fornavn og etternavn, eller det kan være offentlige databaser, kirkebøker osv. Derfor vises det ikke noen alfabetisk indeks på toppen.<br /> For å ha en viss sortering, brukes kildenavnene.<br /><br /><b>Om kilder</b><br />Vi er avhengige av kilder for å kunne lage en slektsbase, fordi all informasjon i databasen er fra en eller flere kilder. Det kan være en slektning til en person, en institusjon, offentlig database, kirkebok osv.<br />En kilde kan være koblet til mange personer. For å si det på en annen måte, kan en person også være koblet til mange kilder. Du kan ha flere kilder for hver begivenhet, om det er fødselsdag, yrke, ekteskap, barn, osv.<br /><br />";
$pgv_lang["sourcelist_listbox_help"]	= "~Listen med kilder~<br /><br />I denne listen kan du se navn på kildene, slik de er lagret i slektsfilen.<br />Navnene vises i alfabetisk rekkefølge.<br /><br />Dersom du klikker på en kilde, vil du få fram siden med detaljer om kilden der det vises personer og/eller familier som er knyttet til denne kilden.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~Siden: Detaljer om kilder~<br /><br />På denne siden vises opplysninger om kildene. Kilder er veldig viktig for slektsforskere og vil hjelpe deg til å følge sporene andre forskere brukte for å finne informasjonen.<br /><br />Her vil du kunne se informasjon om tittel på kilden, forfatter, publikasjon og hvor stedet kilden ble funnet.  Fordi det er så mange forskjellige typer kilder, kan noen kilder ha mer informasjon enn andre.<ul><li>Dersom et multimedia-objekt er knyttet til kilden (slik som et skannet dokument), kan du se objektet i et eget vindu ved enten å klikke på objektet eller filnavnet ved siden av.</li><li>Etter detaljopplysningen om kilden, vil du se en liste med alle personer og/eller familier som er knyttet til kilden.  Dette gjør at du kan se all informasjon som ble funnet i en bestemt data-kilde.</li><li>Du vil kunne se en eller to meny-ikoner på siden dersom administratoren av nettstedet har aktivisert dem:<ul><li><i>#pgv_lang[view_gedcom]#</i>, som viser informasjonen i slektsfilen.</li><li><i></i>, som gjør at du kan lagre denne informasjonen i #pgv_lang[clip_cart]# din. Derfra kan du laste ned (download) informasjonen og importere den til ditt eget slektsprogram.</li></ul></li></ul>#pgv_lang[context_help]#";
$pgv_lang["sources_listbox_help"]		= "~Navn knyttet til denne kilden~<br /><br />I denne listen ser du navn på personer og/eller familier som er knyttet til kilden.<br />Navnene vises i alfabetisk rekkefølge.<br />Dersom du klikker på et navn i tabellen, vil du gå til siden med fakta om den enkelt person eller familie.";
$pgv_lang["show_source_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Ved å klikke på denne linken, vil informasjon om kilden, slik den er lagret i slektsfilen, bli vist i et eget vindu.";
$pgv_lang["add_source_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Ved å klikke på denne linken kan du kopiere kilden, slik den er lagret i slektsfilen, til #pgv_lang[clip_cart]# din.";
$pgv_lang["delete_source_help"]			= "~Slett kilde fra slektsbasen~<br /><br />Ved å klikke på dette valget vil du merke denne kilden for å bli slettet fra slektsbasen.<br />Hva betyr dette?<br />La oss anta at du har en god grunn til å fjerne denne kilden fra slektsbasen. Når du klikker på linken, vil du få opp en et lite vindu der du blir spurt om du er er sikker eller om du vil avbryte.<br /><br />Dersom du fortsette og fjerner kilden, så må du vente litt, før du etter hvert får opp et vindu med en beskjed om at kilden er fjernet.<br /><br />Når du så fortsetter å bruke phpGedView, vil du legge merke til at kilden fortsatt er synlig (og ikke slettet?). Den kan faktisk fortsatt brukes akkurat som før...!<br /><br />Dette er <b>ikke</b> en feil!<br />Administratoren for siden vil få en beskjed om at det er gjort en endring i slektsbasen, og at det var du som fjernet kilden.<br />Administratoren må godkjenne (eller avslå) endringen din. Dersom endringen blir godkjent, er den endelig og kan ikke gjøres om.<br />Dersom administratoren er i tvil, vil han/hun kontakte deg.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~Stedsnavn~<br />(eller personer fra sted)<br /><br />På denne siden kan du se hvilke personer eller familier som koblet til ulike steder vist som nivåer eller en utvidet liste med alle stedsnavn.<br /><br />Dersom det er en kobling mellom en person eller familie og en begivenhet på et bestemt sted, vil programmet finne det for deg.<br /><br />Resultatet blir vist i en todelt liste:<br />En for personer og en for familier.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~Rekkefølge av stedsnavnene~<br /><br /><b>Standard rekkefølge</b><br />Dette betyr at det ikke er angitt noe kode for hvordan stedene i slektsbasen skal vises.<br />Derfor er standard rekkefølge brukt, som vist på denne siden (#pgv_lang[default_form]#).<br /><br />Dersom det er angitt en annen rekkefølge i slektsfilen, vil dette bli vist mellom (...) på slutten av linjen.";
$pgv_lang["ppp_match_one_help"]			= "~Rekkefølge av stedsnavn~<br /><br />Angitt rekkefølge<br />Stedene blir vist i den rekkefølge som ble angitt i slektsbasen.<br />Dette overstyrer standard oppsett, som blir brukt dersom ikke annet er bestemt i slektsfilen";
$pgv_lang["ppp_numfound_help"]			= "~Koblinger til stedsnavn funnet~<br /><br />Her vises antall koblinger til personer som er funnet til nå.<br />Dersom du fortsatt ser listen med steder, betyr det at du ikke har nådd det laveste stedsnivået enda.<br />Du kan allerede nå velge et navn fra <b>Listen med personer/familier</b> eller så kan du gå ned enda et stedsnivå ved å klikke på et annet <b>stedsnavn</b> i listen over.";
$pgv_lang["ppp_levels_help"]			= "~Geografisk nivå for stedsnavn~<br /><br />Her vises den geografiske avgrensning (nivået) som er valgt til nå.<br />Listen som vises under, er navn på steder innenfor dette geografiske området.<br />- Dette avhenger selvsagt av hvordan steder er angitt i slektsbasen (om standard er brukt)!<br /><br /><i><b>Eksempel</b></i>:<br />(Standard) nivåer er: #pgv_lang[default_form]#<ul><li>Dersom nåværende geografisk nivå er \"#pgv_lang[top_level]#\", så bør tabellen vise alle landene som er representert i slektsbasen.</li><li>Hvis nåværende geografisk nivå viser: \"Norge, Landsnivå (topp)\", så bør tabellen vise alle fylkene i Norge</li><li>Osv.</li></ul><br />Du kan klikke på et nivå for å gå ett eller flere nivåer tilbake.";
$pgv_lang["ppp_placelist_help"]			= "~List med stedsnavn (nivå)~<br /><br />I denne listen kan du se stedene som er funnet på det geografisk nivået du har valgt.<br />Du kan klikke på et stedsnavn i listen, og da gjør du en begrensning til et mindre geografisk område. Med andre ord så vil det ta deg ned ett stedsnivå.<br />Det er bare når du er på det \"laveste\" nivået at navnelisten blir vist. På alle andre nivå vil du få en liste med registrerte steder innenfor geografiske området.";
$pgv_lang["ppp_placelist_help2"]		= "~Listen med stedsnavn (alle)~<br /><br />I denne listen kan du se <b>alle</b> stedene som finnes i slektsbasen.<br />Du kan klikke på en stedsnavn i listen, vil du få en liste med personer og/eller familier som er knyttet til dette stedet.";
$pgv_lang["ppp_view_records_help"]		= "~#pgv_lang[view_records_in_place]#~<br /><br />Ved å klikke på stedet som er vist under, så vil du få se en liste med alle personer og familier som hendelser knyttet til dette geografiske nivået.<br /><br />Når du er kommet til slutten av rekken med geografiske stedsnivåer slik som et sted eller en by, vil listen med person- / familienavn bli vist automatisk.";
$pgv_lang["ppp_name_list_help"]			= "~Listen med navn~<br /><br />Denne listen viser deg alle navn på personer og/eller familier som er knyttet (på en eller annen måte) til dette stedet.<br /><br />Dersom du klikker på et navn, vil det ta deg til en side med fakta om personen eller familien.<br /><br />Du kan også velge å endre utvalget i listen ved å klikke på et geografisk \"høyere\" stedsnavn over denne listen.";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]			= "~Siden: Bilder eller andre medier~<br /><br />Denne listen viser alle MultiMedia-filer (MM) som er lagret i denne slektsbasen eller med kobling til en anne Internett-adresse (URL).<ul><li>For hvert MM kan du finne en tittel eller filnavn, navn på personer eller familier som er knyttet til MM, og eventuelle noter.</li><li>Ved å klikke på navnet eller direkte på bildet, så vil filen/URLen, avhengig av formatet (eks.: *.gif, *.jpg), åpnes i den interne bildefremviseren eller i nettleseren din.</li><li>Ved å klikke på linjen med \"Vis person/famile/kilde\" under navnet, så vil du få opp siden med fakta om personen, familien eller kilden.</li><li>Ved å høyreklikke på et MM, vil du få fram de valgene som nettleseren din gir deg. Som for eksempel, lagre et bilde, bruke det som bakgrunn, få en utskrift, osv.</li></ul>";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~Hente (upload) Medie-filer~<br /><br />Å laste opp (upload) filer er enkelt, så her er litt tilleggsinfomasjon:<br /><br /><b>#pgv_lang[thumbnail]</b><br />Disse små bildene bør ha en bredde på rundt 100px.<br />Filnavnet <b>må</b> være det samme som originalen.<br /><br /><b>Overføre (upload)</b> <br />Filene vil bli overført og lagret i mappen ../media for de store bildene og ../media/thumbs/ for de små bildene. <br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~Siden: #pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\">Generell informasjon</a></li><li><a href=\"#calendar_day\">#pgv_lang[day]#</a></li><li><a href=\"#calendar_month\">#pgv_lang[month]#</a></li><li><a href=\"#calendar_year\">#pgv_lang[year]#</a></li><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a></li><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a></li><li><a href=\"#calendar_event\">Hendelse</a></li><li><a href=\"#calendar_button\">Type visning</a></li><li><a href=\"#calendar_tip\">Tips</a></li></ul><br /><a name=\"calendar_general\"></a>Den Historisk kalenderen viser personer og familier som er knyttet til en hendelse på en bestemt dag og/eller måned eller i en bestemt tidsperiode. Kalenderen har flere avanserte metoder for å vise deg de rette hendelsene.<dl><dt><b>Vis <a href=\"#calendar_day\">dag</a></b></dt><dd>Her vises hendelsene som er knyttet til en bestemt dag, uavhengig av valgt år. Du vil se en <i>liste</i> med navn på personer eller familier, eller en tospaltet liste med personer i den første og familier i den andre.</dd><dt><b>Vis <a href=\"#calendar_month\">måned</a></b></dt><dd>Her får du en <i>kalender</i> med navn på personer og/eller familier fordelt på de enkelte dagene i den valgte måneden. Kalenderen blir vist i henhold til det året som er valgt i feltet for år. Det er kun hendelser <i>fram til den valgte måneden og året</i> som vil bli vist.<br />I kombinasjon med valget \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" vil den gi en autentisk visning slik forfedrene dine ville ha sett den.</dd><dt><b>Vis <a href=\"#calendar_year\">år</a></b></dt><dd>Her vises hendelsene som er knyttet til et bestemt år, eller flere år. Du vil se en <i>liste</i> med navn på personer eller familier, eller en tospaltet liste med personer i den første og familier i den andre.</dd></dl>Valgt dag og måned blir vist i en annen farge i menyen til kalenderen.<br /><br />De navnene du finner i listen for dag eller år eller i kalenderen, kan du klikke på. Da vil du kunne se opplysninger om disse personene eller familiene. Klikker du på en dato, vil du hoppe til \"Vis dag\" visning (eller år) med hendelser knyttet til den datoen du klikket på.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]	= "~Valg av dag i måneden~<br />Den øverste raden i \"datovalg\" er <i>valg av dag</i>.<br />Resultatet av å klikke på en bestemt dag, avhenger av om du tidligere har valgt \"#pgv_lang[viewday]#\" eller \"#pgv_lang[viewmonth]#\".<br />Alle andre valg slik som måned, år og hendelser vil forbli uendret.<dl><dt><b>#pgv_lang[viewday]#</b> utgaven:</dt><dd>Etter å ha klikket på en valgt dag, vil personer som er knyttet til hendelser på denne datoen vises.<br />- Dersom det ikke er noen personer knyttet til denne dagen, vil meldingen \"#pgv_lang[no_results]#\" bli vist.</dd><dt><b>#pgv_lang[viewmonth]#</b> utgaven:</dt><dd>Å bytte dag vil <b>ikke</b> endre på innholdet av kalenderen...!<br />Grunnen er at dagen finnes fra før i kalenderen.<br />Klikker du derimot på knappen <b>#pgv_lang[viewday]#</b>, vil den valgte dagen bli vist.</b>.</dd></dl>Til høyre på raden for dag, kan du se en <b>\"Hurtig-link\"</b> som viser dagens dato.<br />Dersom du klikker på denne, vil du automatisk bli vist <b>kun</b> denne dagen, uavhengig om du få forhånd hadde valgt \"#pgv_lang[viewmonth]#\"!<br />";
$pgv_lang["annivers_month_select_help"]	= "~Valg av måned i året~<br />Den midterste raden i \"datovalg\" er <i>valg av måned</i>.<br />Resultatet av å klikke på en bestemt måned, avhenger av om du tidligere har valgt \"#pgv_lang[viewday]#\" eller \"#pgv_lang[viewmonth]#\".<br />Alle andre valg slik som dag, år og hendelser vil forbli uendret.<dl><dt><b>#pgv_lang[viewday]#</b> utgaven:</dt><dd>Etter å ha klikket på en valgt måned, vil personer som er knyttet til hendelser på denne datoen i den nye måneden vises.<br />- Dersom det ikke er noen personer knyttet til denne dagen, vil meldingen \"#pgv_lang[no_results]#\" bli vist.</dd><dt><b>#pgv_lang[viewmonth]#</b> utgaven:</dt><dd>Etter å ha klikket på en valgt måned, vil personer som er knyttet til hendelser på denne måneden vises i en månedkalender.</dd></dl>Til høyre på raden for måned, kan du se en <b>\"Hurtig-link\"</b> som viser nåværende måned.<br />Dersom du klikker på denne, vil du automatisk bli vist denne måneden, uavhengig om du på forhånd hadde valgt \"#pgv_lang[viewday]#\"!<br />";
$pgv_lang["annivers_year_select_help"]	= "~Bytte år~<br />I dette feltet kan du forandre årstallet for kalenderen i \"Måned\" eller listen \"År\".<br />For \"Dag\" vil ikke årstallet ha noe å si.<dl><dt><b>Avanserte tillegg</b> for <b>#pgv_lang[viewyear]#:<br />Flere år</b></dt><dd>Det kan vise flere år ved å skrive inn følgende i feltet år:<br />- Eks. 1: <b>1992-5</b> for alle hendelser fra og med 1992 til og med 1995.<br />- Eks. 2: <b>1970-89</b> for alle hendelser f.o.m 1970 t.o.m 1989.<br />- Eks. 3: <b>1600-799</b> for alle hendelser f.o.m 1600 t.o.m 1799.<br />- Eks. 4: <b>1880-1905</b> for alle hendelser f.o.m 1880 t.o.m 1905.<br />- Eks. 5: <b>880-1105</b> for alle hendelser f.o.m 880 t.o.m 1105.<br /><br />Du kan også bare angi begynnelsen på årstallet og få alle hendelser som begynner med disse sifrene.<br />- Eks.: <b>197</b> for alle hendelser f.o.m 1970 t.o.m 1979.</dd><dt><br /><b>Omtrentlig dato</b></dt><dd>Noen ganger er en ikke sikker på når en hendelse egentlig hendte. I disse tilfellene kan en bruke betegnelser som \"etter\", \"før\" og \"omkring\" foran datoen. Datoene blir lagret i slektsbasen sammen med disse forklaringene. Når du velger År, kan du også utføre søk med disse tilleggene, med eller uten den tilhørende datoen. Her er noen eksempler på disse uttrykkene:<br /><b>abt</b> 1800 (abt = about = omtrent)<br /><b>bet</b> 1950-1959 (bet = between = mellom) skriv: bet 1950 eller bare: 1950-59<br /><b>bef</b> 1950 (bef = before = før)<br /><b>aft</b> 1900 (aft = after = etter)<br /><br /><b>NB!</b> PhpGedView vil søke etter registeringer nøyaktig slik du oppgir i feltet for år. Når du søker etter \"abt 1850\", og datoen er lagret slik i basen \"abt oct 1850\", så vil denne <u>ikke</u> bli inkludert i resultatet på skjermen. - Du kan angi bare forkortelsen uten noe årstall, for å vise alle hendelser med datoer som inneholder denne forkortelsen.</dd></dl><b>NB!</b> For å se resultatet av å ha forandret årstallet, må du etterpå enten klikke på en av knappene \"<b>#pgv_lang[viewday]#</b>\", \"<b>#pgv_lang[viewmonth]#</b>\" eller \"<b>#pgv_lang[viewyear]#</b>\", - eller et av de andre valgene.<br />";
$pgv_lang["annivers_show_help"]			= "~Vis hendelser for...~<br />Her har du minst to valg:<dl><dt><b>Alle personer</b></dt><dd>Her vil du se alle personer og familier som har hendelser knyttet til den valgte dagen/måneden.</dd><dt><b>#pgv_lang[recent_events]#</b></dt><dd>Her vil du også se personer og familier som har hendelser knyttet til den valgte dagen/måneden, men ikke lengre tilbake enn de siste 100 årene.</dd></dl>Det er også et tredje valg. - Men for å kunne se dette, må du enten være logget inn eller så må administratoren ha slått av personvernet for nålevende personer, slik at faktaopplysninger kan bli vist til alle:<dl><dt><b>Nålevende personer</b></dt><dd>Her vil du bare se personer og familiemedlemmer som lever nå, og som har hendelser knyttet til den valgte dagen/måneden.</dd></dl>De andre valgene for dag, måned, år og type visning vil ikke bli forandret.<br />";
$pgv_lang["annivers_sex_help"]			= "~Velge kjønn~<br />Når du er logget inn (eller dersom administratoren ikke har aktivert valget for personvern) så vil du her få tre valg:<dl><dt><b>1. Ikonet Alle</b> (standard)</dt><dd>Her vil du se alle hendelser til personer og/eller familier.</dd><dt><b>2. Ikonet Mann</b></dt><dd>Her vil bare hendelser til personer av hankjønn bli vist. I tillegg vil menn (ektemenn) i familier bli vist med tilhørende familiehendelse(r).</dd><dt><b>3. Ikonet Kvinne</b></dt><dd>Her vil bare hendelser til personer av hunkjønn bli vist. I tillegg vil kvinner (hustruer) i familier bli vist med tilhørende familiehendelse(r).</dd></dl>Når du klikker på et av valgene, vil skjermbildet bli oppdatert og i forhold til det valg du har gjort.<br />Andre valg som dag, måned og år, og hendelser og type visning vil ikke bli forandret.<br />";
$pgv_lang["annivers_event_help"]		= "~Velge hendelse~<br />Her kan du velge om du vil se alle hendelser for personer og familier<br />eller bare den hendelsen du velger.<br /><br />Når du klikker på et av valgene, vil skjermbildet bli oppdatert og i forhold til det valg du har gjort.<br />Andre valg som dag, måned og år, og hendelser og type visning vil ikke bli forandret.<br />";
$pgv_lang["annivers_tip_help"]			= "~<i>Tips</i>~<br />Juster dato-feltene til en dato i \"gamledager\" (f. eks. 25. januar 1875).<br />Klikker du på en av knappene \"Vis dag/måned\", vil du se en liste eller kalender for denne datoen.<br /><br />Det <i>spesielle</i> skjer dersom du velger måned; - Da vil alle årsdager blir beregnet på nytt og vist i henhold til den datoen du har angitt i dato-feltene.<br />Derfor vil du nå faktisk se den samme kalenderen som dine slektninger ville ha sett i det angitte året.<br />";
$pgv_lang["day_month_help"]				= "~Knappene - Vis dag / Vis måned / Vis år~<dl><dt><b>#pgv_lang[viewday]#</b></dt><dd>Her vil du se personer som er knyttet til hendelser på den valgte datoen.<br />Det blir søkt i alle år, så du trenger <u>ikke</u> å forandre årstallet.<br />Du kan begrense resultatet ved å velge \"#pgv_lang[recent_events]#\" eller, hvis tilgjengelig, \"#pgv_lang[living_only]#\".</dd><dt><br /><b>#pgv_lang[viewmonth]#</b></dt><dd>Her vil du få opp en kalender for den valgte måneden.<br />Personer som er knyttet til hendelser i denne måneden vil bli vist på de respektive dagene i kalenderen.<br />Er det hendelser som er registrert uten angitt dag, vil disse bli vist i en egen ramme med overskriften \"#pgv_lang[day_not_set]#\" i begynnelsen eller slutten av kalenderen.<br />Her kan du også begrense resultatet ved å velge \"#pgv_lang[living_only]#\" eller \"#pgv_lang[recent_events]#\".<br /><br /><b>PS</b> - Ved å angi et år i fortiden, så vil du få se kalenderen slik den var for den valgte måned i dette året. Alle aldre vil også bli vist i forhold til angitt år.</dd><dt><br /><b>#pgv_lang[viewyear]#</b></dt><dd>Her vil du se personer som er knyttet til hendelser i det valgte året.<br />Det blir søkt for alle dager i valgt(e) år, så du trenger <u>ikke</u> å forandre dag eller måned.<br />Også her kan du begrense resultatet ved å velge \"#pgv_lang[living_only]#\" dersom den er tilgjengelig.<br /><br />En fin tilleggsfunksjon er muligheten til å vise flere enn ett år.<br />Se eksempler på dette i hjelpetektsen for <a href=\"#calendar_year\">valg av <b>#pgv_lang[year]#</b></a><br /><br /><b>PS</b> - Dersom du har forandret årstallet, så <b>må</b> du bruke denne eller en av de andre knappene/valgene for å se resultatet.</dd></dl>De andre valgene vil ikke forandre seg når du bruker knappene.<br />";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]			="~Siden: Utklippsmappe~<br />Denne siden gir deg mulighet til å hente utdrag (\"utklipp\") fra denne slektsbasen og samle dem i ny fil som du kan laste ned til PCen din og deretter importere inn i ditt eget slektsprogram.<br />Filen blir lagd i standardformatet for slektsfiler (<a href=\"?help=def_gedcom_help\">GEDCOM</a>).<dl><dt><b>Hvordan klippe ut?</b></dt><dd>Dette er veldig enkelt. Alle steder der du kan se et navn du kan klikke på (enkeltperson, familie eller kilde),<br />kan du gå til en side med fakta om dette navnet. På den nye siden vil du se et valg som sier \"Legg i utklippsmappen\".<br />Dersom du klikker på denne, så vil du få opp en ny side der du blir gitt flere valg for å legge personen og familien<br />i utklippsmappen.<br /></dd><dt><br /><b>Hvordan laste ned (download)?</b></dt><dd>Når du lagt person(er)/familier i mappen din, kan du laste dem ned ved bare å klikke på linken \"Last ned (download) nå\".<br />Følg så de neste instruksjonene og linkene.</dd></dl>";
$pgv_lang["clip_download_help"]			="~Last ned nå (download)~<br />Ved å klikke på knappen vil du få opp en ny side der du blir fortalt hvordan du laster ned filen.<br />Dersom det er flere valg om hva du kan laste ned, vil de bli vist på denne siden.<br />Følg bare de viste instruksjonene.";
$pgv_lang["empty_cart_help"]			="~Tøm alt i utklippsmappen~<br />Ved å klikke på knappen vil du tømme utklippsmappen din helt.<br /><br />Dersom du ikke ønsker å fjerne alle personer, familier, osv. fra utklippsmappen, kan du fjerne enkeltvis ved å klikke på valget \"Fjern\" i navne-tabellen.<br /><br /><b>PS</b> - Det er <u>ikke</u> noen mulighet til å angre dersom du klikker på disse knappene; Utklippsmappen blir tømt med en gang.<br /><br />";
##$pgv_lang["add_by_id_help"]				= "~CLIPPINGS CART ADD BY ID~<br /><br />This input box lets you enter an individual's ID number so he can be added to the Clippings Cart.  Once added you'll be offered options to link that individual's relations to your Clippings Cart.<br /><br />If you do not know an individual's ID number, you can perform a search by name by pressing the Person icon next to the Add button.<br /><br />";
##$pgv_lang["zip_help"]					= "~ZIP CLIPPINGS~<br /><br />Select this option as to save your clippings in a ZIP file.  For more information about ZIP files, please visit <a href=\"http://www.winzip.com\" target=\"_blank\">http://www.winzip.com</a>.<br /><br />";
##$pgv_lang["include_media_help"]			= "~INCLUDE MEDIA~<br /><br />Select this option to include the media files associated with the records in your clippings cart.  Choosing this option will automatically zip the files during download.<br /><br />";
##$pgv_lang["clip_cart_help"]				= "~CLIPPINGS CART~<br /><br />This box shows the contents of your Clippings Cart.  The <i>Types</i> column indicates the type of each entry, which can be Individual (INDI), Family (FAM), Source (SOUR), Repository (REPO), Note (NOTE), and Media (OBJE);  each is represented by its own icon.  The <i>ID</i> column shows the ID number for each item of that particular type.  The <i>Name / Description</i> column gives either the name of the family or individual, or a description of the item.  The Remove button will remove that record from the Clippings Cart.  <b>Confirmation to remove is NOT asked for.</b><br /><br />";

//-- GEDCOM Edit Utility
$pgv_lang["show_changes_help"]			="~#pgv_lang[review_changes]#~<br />Når du ser denne beskjeden, kan det bety to ting:<dl><dt>1. Noen har gjort endringer i slektsbasen</dt><dd>Oppføringer kan ha blitt lagt til, slettet eller endret.</dd><dt>2. Endringene er ikke blitt godkjent av administratoren enda.</dt><dd>Når endringene er blitt godkjent (eller avslått), vil du ikke se denne beskjeden lengre.</dd></dl>Ved å klikke på linken, kan du se hvilke endringer som er gjort.<br />Dersom du mener at en endring ikke er korrekt, vennligst gi beskjed til administratoren til nettstedet.";

//-- Search-page
$pgv_lang["help_search.php"]			="~Siden: Søke~<br />Selv om denne siden ser ut til å være veldig enkel, så er det forholdsvis kraftig søkemuligheter som tilbys.<br />- Til forskjell fra andre nettsteder som viser slektsopplysninger der du kan søke på (etter)navn, så kan PhpGedView praktisk talt søke etter alt mulig som finnes i slektsbasen!<dl><dt><b>Søkefeltet på venstre side av skjermen</b><br />(er det samme som søkefeltet på toppen av siden.)</dt><dd>- Dersom du leter etter personer knyttet til et bestemt år, kan du bare skrive inn året. Programmet vil finne alle forbindelse for deg.</dd><br /><dd>- Lete etter et navn, eller et sted?<br />Skriv bare inn navnet eller stedet, hele eller bare deler av det, og programmet gjør resten.</dd><dt><b>Søkefeltet på høyre side av skjermen</b><br />Fonetisk søk.</dt><dd>Her kan du søke etter navn dersom du ikke er helt sikker på hvordan det staves.</dd><dt>#pgv_lang[more_help]#</dt></dl>";
$pgv_lang["search_enter_terms_help"]	="~Skrive inn søke-uttrykk~<br />I dette søkefeltet kan du skrive inn søkeord som datoer, fornavn, etternavn, steder, multimedia, osv.<dl><dt><b>Navn</b></dt><dd>Jokertegn (som * eller ?) vil <u>ikke virke</u>, men programmet bruker disse skjult i søket.<br /><b>Hva betyr det?</b><br />Tenk deg at du skriver inn \"<b>Tor</b>\" i søkefeltet.<br />- Resultatet vil bli (gitt at disse navnene finnes i databasen):<br />-- <u>Tor</u> Hansen<br />-- <u>Tor</u>e Johnsen<br />-- Jon <u>Tor</u>sen<br />-- Person som er født i <u>Tor</u>shavn<br />-- osv.<br /></dd><dt><b>Årstall</b></dt><dd>Å skrive et årstall vil gi deg navn på alle personer som er knyttet til dette året.<br />- Dersom du skriver <b>1950</b>, så vil resultatet bli personene som er født, gift, døde eller andre hendelser som er knyttet til 1950.<br /><br />Du kan også bruke søkeuttrykk i PHP dersom du er kjent med dem;<br />For eksempel hvis du ønsker å finne alle personer som har datoer på 1900-tallet (20 århundre), så kan du søke etter:<br /> <b>19[0-9][0-9]</b> og da vil du få alle personer med datoer fra 1900 til 1999.<br /><b>19[5-9][0-9]</b> vil vise alle personer som har datoer fra 1950 til 1999.</dd><dt><b>Datoer</dt><dd><i>PS!</b> Programmet søker etter data slik de er lagret i slektsbasen.</i><br />Så hvis du ønsker å søke etter en hendelse på datoen 14. desember, bør du skrive inn måneden på engelsk: <b>14 dec</b>.<br />- Dersom du skriver <b>4 dec</b> så vil alle personer knyttet til en hendelse den 4. desember, uansett årstall, bli vist.<br />I tillegg vil også personer knyttet til en hendelse den 14. og/eller 24. desember bli vist.<br />- Men skriver du \"<b>dec 14</b>\", vil resultatet bli personer knyttet til hendelser på f.eks. 8 <u>dec</u>ember 18<u>14</u>.</dd></dl>Dersom du trenger mer hjelp om søke-mulighetene, så sendt oss en beskjed slik at vi kan forbedre denne hjelpeteksten enda mer...";
##$pgv_lang["search_replace_help"]		= "~#pgv_lang[search_replace]#~<br /><br />Here, you can search for a misspelling or other inaccurate information and replace it with correct information.<br /><br /><b>Searching</b><br />This feature performs searching just like a <a href=\"help_text.php?help=search_enter_terms_help\">normal search</a>.<br /><br /><b>Replacing</b><br />All instances of the search term that are found are replaced by the replacement term in the database.<br /><br /><b>For Example...</b><br />Suppose you accidentally misspell your great-grandpa Michael's name.  You accidentally entered 'Micheal.' <br /><br />You would type <b>Micheal</b> in the Search box, and <b>Michael</b> in the Replace box.<br />Every instance of \"Micheal\" would then be replaced by \"Michael\"<br /><br /><b>Search for...</b><br />Select the scope of the search.  You can limit the search to names or places, or apply no limit (search everything).  The <i>#pgv_lang[search_place_word]#</i> option will only search for your term in the place field as a whole word.  This means that searching for <i>UT</i> would only match <b>UT</b> and not <i>UT</i> in the other words such as Connectic<b>ut</b>.<br /><br />Don't worry if you accidentally replace something where you don't want to.  Just click the \"Accept/Reject Changes\" link at the bottom of the page to accept the changes you want, and reject the changes you don't want.<br /><br />If you need more help with this searching system, please let us know, so that we can improve this Help file as well.<br /><br />";
$pgv_lang["soundex_search_help"]		="~Søke slik du tror navnet er skrevet~<br />Fonetisk søk (<a href=\"#soundex\">soundex-metoden</a>) er en forholdsvis kraftig søkemetode.<br />Det samler sammen navn som uttales likt men som staves forskjellig.<dl><dt><b><i>Hva betyr dette for deg:</i></b></dt><dd>Dersom du søker etter \"Smith\", vil du kunne få følgende resultat:<br />Smith, Smid, Smit, Smitt, Schmidt, Smyth, Smithe, Smithee, Schmitt, Smead,  Sneed, Smoote m.fl.</dd><dd>- Bare skriv navnet slik du tror det skrives.</dd><dt><b>Fornuftig når:</b></dt><dd></li><li>Du kjenner navnet, men er ikke sikker på stavemåten.</li><li>Jeg husker ikke navnet, men det var noe med...!</li><li>Det kan også hende at et navn er skrevet inn feil i slektsbasen.</dd><dt><b>Hvordan søke:</b></dt><dd></li><li>I disse søkefeltene, er det tilstrekkelig å starte med <u>ett</u> navn (fornavn, etternavn eller sted) for å søke.</li><li>Du kan fylle ut flere felt for å begrense antall treff.</li><li>År kan være ett år eller en periode av år (eks. 19[5-7][0-9] for 1950-1979)</li><li>Søkefeltet År kan <u>ikke</u> brukes alene.</li></dd></dl><b>Tips</b>: For å bli kjent med bruken av fonetisk søk, kan du prøve å finn et bestemt navn ved å skrive det på forskjellige måter.<br /><br /><a name=\"soundex\"> </a><div class=\"list_value_wrap\"><b>Soundex metoden:</b><br />Et fonetisk søk starter med å sorterer ord som lyder likt uavhengig av stavemåte. Metoden som blir brukt, er at den første bokstaven i søkeordet blir sjekket, fulgt av en tre-sifferet kode som representerer de tre neste ordinære konsonantene i ordet.<br />Tallverdien til de enkelte konsonantene avhenger av hvordan de uttales på engelsk (men beklagligvis ikke norsk...)!  For eksempel vil <b>c</b>, <b>k</b>, <b>q</b>, og <b>x</b> ha samme verdi fordi de uttales forholdsvis likt.  Tilsvarende vil <b>b</b> og <b>p</b> ha samme verdi og <b>c</b>, <b>s</b> og <b>z</b>.<br /> Nuller vil bli lagt til i søkeord som ikke har nok bokstaver for å bli kodet.<br /></div><br />";
##$pgv_lang["search_exclude_tags_help"]	= "~#pgv_lang[search_tagfilter]#~<br /><br />The <b>#pgv_lang[search_tagfon]#</b> choice will cause the Search function to ignore the following GEDCOM tags:<div style=\"padding-left:30px;\"><b>_PGVU</b> - Last change by<br /><b>CHAN</b> - Last change date<br /><b>FILE</b> - #factarray[FILE]#<br /><b>FORM</b> - #factarray[FORM]#<br /><b>TYPE</b> - #factarray[TYPE]#<br /><b>SUBM</b> - #factarray[SUBM]#<br /><b>REFN</b> - #factarray[REFN]#</div><br />In addition to these optionally excluded tags, the Search function always excludes these tags:<div style=\"padding-left:30px;\"><b>_UID</b> - #factarray[_UID]#<br /><b>RESN</b> - #factarray[RESN]#</div><br /><br />";
##$pgv_lang["search_include_ASSO_help"]	= "~#pgv_lang[search_asso_label]#~<br /><br />This option causes PhpGedView to show all individuals who are recorded as having an association relationship to the person or family that was found as a direct result of the search.  The inverse, where all persons or families are shown when a person found as a direct result of the search has an association relationship to these other persons or families, is not possible.<br /><br />Example:  Suppose person <b>A</b> is godparent to person <b>B</b>.  This relationship is recorded in the GEDCOM record of person <b>B</b> by means of an ASSO tag.  No corresponding tag exists in the GEDCOM record of person <b>A</b>.<br /><br />When this option is set to <b>#pgv_lang[yes]#</b> and the Search results list includes <b>B</b>, <b>A</b> will be included automatically because of the ASSO tag in the GEDCOM record of <b>B</b>.  However, if the Search results list includes <b>A</b>, <b>B</b> will not be included automatically since there is no matching ASSO tag in the GEDCOM record of person <b>A</b>.<br /><br />";

//-- Individual Information-page
$pgv_lang["help_individual.php"]		= "~Siden: #pgv_lang[indi_info]#~<br />Denne siden vil vise alle opplysninger om personen.<br /><br />Dersom det er et bilde tilgjengelig, så vil du se det øverst til venstre.<br />Ved siden av bildet (hvis det er der) vil du se detaljer om navnet til personen.<br />Dersom noen av navnene har noter eller kilder knyttet til seg, vil du se dem opplistet under de tilhørende navnene.<br />En person kan også ha et alias (kjent under et annet navn) og da vil dette også bli vist.<br /><br />På denne siden vil du se egne ark med tilhørende \"faner\", der du vil finne all informasjon som er lagret i slektsbasen om denne personen:<dl><dt><b>#pgv_lang[personal_facts]#</b></dt><dd>Dette arket vil vise deg alle faktaopplysninger om denne personen og eventelle ekteskap.<br />- Klikker du på en dato så vil du få opp #pgv_lang[anniversary_calendar]#, slik at du kan se alle hendelser i slektsbasen som hendte på denne dagen.<br />- Klikker du på et sted, vil du få opp siden med stednavn, slik at du kan se alle hendelser i slektsbasen som hendte på det samme stedet.  For ekteskap og andre hendelser knyttet til familien, vil navnet til ektefellen også vises slik at du kan se på denne og og en link til familen.</dd><dt><b>#pgv_lang[notes]#</b></dt><dd>Dette arket vil vise deg eventuelle notater som er gjort om denne personen.</dd><dt><b>#pgv_lang[ssourcess]#</b></dt><dd>Dette arket vil vise deg alle kilder som er knyttet til denne personen.  Klikker du på tittelen til kilden, så vil du få opp siden med kilder i slektsbasen slik at du kan se andre personer som er knyttet til den samme kilden.</dd><dt><b>#pgv_lang[media]#</b></dt><dd>Dette arket vil vise deg alle bilder og andre medieobjekt som er knyttet til personen.  Klikke du på et minibilde, vil du få se bilde i full størrelse.</dd><dt><b>#pgv_lang[relatives]#</b></dt><dd>Dette arket viser deg foreldre og søsken til personen, i tillegg til alle ektefeller og barn denne personen har eller har hatt.  Personene vil bli vist i bokser tilsvarende de du også vil kunne se i diagram.</dd></dl>Øverst til høyre på siden, vil du se en meny med <b>#pgv_lang[indis_charts]#</b>.<dl><dt><b>#pgv_lang[charts]#</b></dt><dd>De fleste er like med dem du finner i hovedmenyen, men forskjellen er at her vil personen på siden bli startpersonen (proband) i diagrammene i steden for den vanlige startpersonen i slektsbasen.<br />Dersom du er logget inn og er knyttet til slektsbasen, vil du også få valget <i>#pgv_lang[relationship_to_me]#</i>.</dd><dt><b>#pgv_lang[reports]#</b></dt><dd>Her finner du noen rapporter som er relatert til personer. Her vil også personen på siden bli startperson.</dd><dt><b>#pgv_lang[edit]#</b></dt><dd>Dersom du har de nødvendige rettigheter, vil du her få ulike valg for å legge til, endre eller slette opplysninger for personen.</dd><dt><b>#pgv_lang[other]#</b></dt><dd>Her kan det være at du vil få valget om å legge denne personen i Utklippsmappen og vise opplysningene om denne personen slik de er lagret i slektsfilen.</dd></dl>Mer hjelp er tilgjengelig for siden ved å klikke på <b>?</b> ved linkene eller boksene.";
$pgv_lang["delete_person_help"]			= "~Slette person fra slektsbasen~<br />Ved å klikke på dette valget vil du MERKE denne PERSONEN for å bli slettet fra slektsbasen.<br /><br />Hva betyr dette?<br />Tenk deg at du har en god grunn for å fjerne denne personen fra slektsbasen. Du klikker på linken, og da vil du få opp et nytt vindu der du blir bedt om å bekrefte slettingen eller ønsker å avbryte.<br /><br />Dersom du bekrefter slettingen, vil dette bli lagret, før du etter en lite stund får et nytt vindu med en beskjed om at slettingen er utført.<br /><br />Dersom du sjekker om personen er slettet ved å prøve å vise personen på nytt, vil du se at personen fremdeles er like synlig som før slettingen.<br /><br />Dette er <b>ikke</b> en feil!<br />Av hensyn til kvaliteten på slektsbasen, så vil administratoren for nettstedet motta en beskjed at det er gjort endringer, og at det er deg som fjernet personen.<br />Administratoren MÅ godkjenne (eller forkaste) endringen din.<br />Dersom det er tvil, vil administratoren kontakte deg om endringen.";
$pgv_lang["delete_name_help"]			= "~Endre eller slette navn fra slektsbasen~<br /><br /><b>Endre navn</b><br />Ved å klikke på denne linken, vil du åpne et nytt vindu der du kan endre navnet til personen.<br />Det er veldig enkelt: Bare skriv inn endringen, klikk på knappen \"Lagre\" og lukk vinduet.<br /><br /><b>Slette navn</b><br />Ved å klikke på dette valget vil du merke dette navnet for sletting.<br />Husk på at å slette et navn er noe helt annet enn å slette en person.<br />Å slette navnet, fjerner du bare navne-feltet til personen. Selve personen vil ikke bli slettet.<br />Dersom det bare er et alias (også kjent som) du ønsker å slette, har personen fortsatt hovednavn sitt inntakt.<br />Dersom du sletter det eneste navnet en person har, vil personen fortsatt ikke bli slettet, men fortsette som \"Ukjent\".<br />Personen vil heller ikke miste eventuelle koblinger til slektninger, kilder, noter, osv.<br /><br /><i>Hva betyr dette?</i><br />Tenk deg at du har en god grunn for å fjerne dette navnet til personen fra slektsbasen. Du klikker på linken, og da vil du få opp et nytt vindu der du blir bedt om å bekrefte slettingen eller ønsker å avbryte.<br /><br />Dersom du bekrefter slettingen, vil dette bli lagret, før du etter en lite stund får et nytt vindu med en beskjed om at slettingen er utført.<br /><br />Dersom du sjekker om navnet er slettet ved å prøve å vise personen på nytt, vil du se at navnet fremdeles er like synlig som før slettingen.<br /><br />Dette er <b>ikke</b> en feil!<br />Av hensyn til kvaliteten på slektsbasen, så vil administrator for nettstedet motta en beskjed at det er gjort endringer, og at det er deg som fjernet navnet.<br />Administratoren MÅ godkjenne (eller forkaste) endringen din.<br />Dersom det er tvil, vil administratoren kontakte deg om endringen.";
$pgv_lang["add_name_help"]				= "~Legge til nytt navn~<br /><br />Dette valget gir deg mulighet til å legge til et nytt navn til denne personen.  Noen ganger hender det at personer er bedre kjent med andre navn og/eller alias'.  Dette valget gjør at du kan gi en person et nytt navn uten å endre det gamle/egentlige navnet.";
$pgv_lang["add_sibling_help"]			= "~Legge til en bror eller søster~<br />Ved å klikke på denne linken, kan du legge til et barn til denne familien.<br />\"Denne familien\", er i dette tilfelle, faren og moren til hovedpersonen på denne siden.<br />Så, vær oppmerksom på at du legger til en bror eller søster til denne personen.<br />Å legge til en bror eller søster er enkelt: Bare klikk på linken, og fyll ut navnet i vinduet som kommer fram.<br /><br />Dersom du skal legge til en sønn eller datter til hovedpersonen, rull litt ned på skjermen og klikk på linken i \"#pgv_lang[as_spouse]#\".";
$pgv_lang["add_son_daughter_help"]		= "~Legge til en sønn eller datter~<br />Ved å klikke på denne linken, kan du legge til et barn til denne familien.<br />\"Denne familien\", er i dette tilfelle, hovedpersonen på denne siden og hans/henne foreldre.<br />Så, vær oppmerksom på at du legger til en sønn eller datter til denne personen.<br />Å legge til en sønn eller datter er enkelt: Bare klikk på linken, og fyll ut navnet i vinduet som kommer fram.<br /><br />Dersom du skal legge til en bror eller søster  til hovedpersonen, rull litt ned på skjermen og klikk på linken i \"#pgv_lang[as_child]#\".";
$pgv_lang["link_child_help"]			= "~Knytt denne personen til en eksisterende familie som barn~<br />Ved å klikke på på denne linken, kan du knytte denne personen som et barn i en eksisterende familie.<br /><br />Tenk deg at foreldrene til personen var ukjente, og du fant ut at de (foreldrene) har en post i denne slektsbasen.<br /><br />Ved bare å klikke på linken, angi IDen til familien (hvis du ikke kjenner IDen, kan du søke etter den), og du har fullført koblingen.";
$pgv_lang["link_husband_help"]			= "~#pgv_lang[link_as]# #pgv_lang[husband]#~<br /><br />Dette valget gir deg mulighet til å knytte personen til en eksisterende familie som en ny ektemann. Familien vil nå få koblet denne personen som familiefar der det tidligere ble vist Ukjent. Alle registerte hendelser, informasjon om ekteskapet og barn vil forbli uendret.<br /><br />Dette er et avansert endringsvalg som bare bør brukes dersom familien du ønsker å lage en kobling til allerede eksisterer.  Dersom du bare ønsker å legge til en <u>ny</u> familie, bruker du valget <b>#pgv_lang[add_new_wife]#</b>.";
$pgv_lang["add_husband_help"]			= "~Legge til en ny ektemann~<br />Her kan du legge til en <u>ny</u> mann og knytte denne personen til hovedpersonen som en ny ektefelle/partner.<br /><br />Bare klikk på linken, så vil du få opp et vindu for å legge til den nye personen.<br />Fyll ut så mange felt som mulig...<br /><br />";
$pgv_lang["link_new_husb_help"]			= "~#pgv_lang[link_new_husb]#~<br />Her kan knytte en annen mann som allerede er registrert i slektsbasen, som en ny ektemann til denne personen.  Det vil da bli lagd en ny familie med den ektemannen som du velger.  Du vil også ha muligheten å angi opplysninger om vielsen for den nye familien.<br /><br />";
##$pgv_lang["add_opf_child_help"]			= "~#pgv_lang[add_opf_child]#~<br /><br />By clicking this link, you can add a <u>new</u> child to this person, creating a one-parent family.<br /><br />Just click the link, and you will get a pop up window to add the new person.  Fill out as many boxes as you can and click the <b>Save</b> button.<br /><br />That's all.<br /><br />";
$pgv_lang["link_wife_help"]				= "~#pgv_lang[link_as]# #pgv_lang[wife]#~<br />Dette valget gjør at det mulig å knytte denne personen som en hustru / partner til en familie som allerede finnes i slektsbasen.  Dette er et avansert valg som bare bør brukes dersom familien du ønsker å lage en kobling til finnes fra før.  Derrsom du bare ønsker å legge til en ny familie, må du bruke valget <b>#pgv_lang[add_new_husb]#</b>.";
$pgv_lang["add_wife_help"]				= "~#pgv_lang[add_new_wife]#~<br />Ved å klikke på denne linken, kan du legge til en <u>ny</u> kvinne og knytte denne personen til hovedpersonen som en ny ektefelle/partner.<br /><br />Bare klikk på linken, så vil du få opp et vindu for å legge til den nye personen.<br />Fyll ut så mange felt som mulig...<br /><br />";
$pgv_lang["link_new_wife_help"]			= "~#pgv_lang[link_new_wife]#~<br />Her kan knytte en annen kvinne som allerede er registrert i slektsbasen, som en ny hustru til denne personen.  Det vil da bli lagd en ny familie med den hustruen som du velger.  Du vil også ha muligheten å angi opplysninger om vielsen for den nye familien.<br /><br />";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~Legge til en ny far eller mor~<br /><br />Det er selvagt mange personer i slektsbasen som ikke har registrert med sin far og/eller mor.<br /><br />Dersom du ønsker å legge til en av disse kan du gjøre dette på siden for <b>Fakta om personen</b> under fane-arket <b>#pgv_lang[relatives]#</b>. Under listen <b>Familie med foreldre</b>, vil du finne linken(e) for å legge til en <u>ny</u> far og/eller mor til personen.<br /><br /><b>NB:</b><br />Vær oppmerksom på at disse linkene er for å legge til en <u>ny</u> far og/eller mor!<br />Dersom faren eller moren finnes fra før i slektsbasen, så må du bruke linken: <b>#pgv_lang[link_as]##pgv_lang[child]#</b>, som du også finner på denne siden under den nederste tabellen.";
##$pgv_lang["show_fact_sources_help"]		= "~#pgv_lang[show_fact_sources]#~<br />~#pgv_lang[show_fact_notes]#~<br />When this option is checked, you can see all Source or Note records for this person.  When this option is unchecked, Source or Note records that are associated with other facts for this person will not be shown.<br /><br />";
##$pgv_lang["age_differences_help"]	= "~#pgv_lang[age_differences]#~<br />When this option box is checked, the «#pgv_lang[relatives]#» tab will show date differences as follows:<br /><ul><li>birth dates of partners.<br />A negative value indicates that the second partner is older than the first.<br /><br /></li><li>marriage date and birth date of the first child.<br />A negative value here indicates that the child was born before the marriage date or that either the birth date or the marriage date is wrong.<br /><br /></li><li>birth dates of siblings.<br />A negative value here indicates that either the order of the children is wrong or that one of the birth dates is wrong.</li></ul><br /><br />";

//-- Add Facts
$pgv_lang["add_facts_help"]				= "~Legge til nye fakta~<br />Her kan du legge til fakta for en eller flere personer.<br /><br />Velg første en faktaopplysning fra \"slipp-ned listen\" og klikk så på knappen \"Legg til\". <br />I \"slipp-ned listen\" finner du alle tilgjengelige faktaopplysninger for slektsbasen.<br />";
$pgv_lang["add_custom_facts_help"]		= "~Legge til egne fakta~<br />Dersom du ikke finner den faktaopplysninger som du ønsker å legge til i faktalisten, kan du skrive inn en <b>Egen fakta</b>.<br />Forskjellen fra å legge til fra en forhåndsdefinert faktaopplysning, er at du må gi den nye faktaopplysningen et navn. Du gjør det i det øverste feltet: <b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"]				= "#pgv_lang[multiple_help]#<br />~Legge til ny note~<br /><br />Dersom du har en note/forklaring som du ønsker å legge til for denne personen, så er dette stedet å gjøre det.<br />Måten er enkel: Klikk på linken, og et et vindu vil komme fram der du kan skrive inn noten din.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~Legge til ny kildehenvisning~<br /><br />Dersom du ønsker å legge til en <b>kildehenvisning</b> for denne personen, kan du klikke på linken.<br />Du vil da få opp et nytt vindu der du blir bedt om å velge en kilde fra en liste (Finn ID) og legge til \"henvisningen\".<br /><br />Å legge til kilder er en av de viktigste delene av slektsforskning, fordi det gir andre mulighet til å sjekke eller jobbe videre med kilden.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]				= "~#pgv_lang[add_media]#~<br />Å legge til multimedia-filer (MM) til slektsbasen er en veldig enkel og fin funksjon.<br />Selv om dette programmet ser pent ut i seg selv, vil det se enda bedre ut dersom du legger til bilder eller andre MM-filer til dine slektninger.<dl><dt><b>Hva bør du vite om MM ?</b></dt><dd>Som du sikkert vet, så finnes det mange filtyper for MM. Selv om PhpGedView kan håndtere de fleste av dem, så er det visse ting som du bør ta i betraktning.</dd><dt><b>Filtyper</b></dt><dd>Bilder kan endres og lagres i mange forskjellige format.<br />F.eks. .jpg, .png, .bmp, .gif osv.<br />Bilder som av utseende er like store, kan ha vidt forskjellige filstørrelser.  Generelt er bildetypen .jpg betraktet å være den beste i forhold til filstørrelse.</dd><dt><b>Bildestørrelse</b></dt><dd>Jo større det originale bilde er, jo større vil filstørrelsen også bli. Bildet bør passe til skjermen uten at det er nødvendig å rulle på skjermbildet; maks bredde eller høyde bør med andre ord ikke være større enn bredden og høyden til skjermen. PhpGedView er utformet for skjermer med 1024x768 punkter, men hele denne plassen er ikke tilgjengelig for å vise bilder; derfor er 800x600 punkter en bedre størrelse.  En tommelfinger-regel er at jo mindre filstørrelsen er, jo bedre...</dd><dt><b>Oppløsning</b></dt><dd>Oppløsningen til et bilde har betegnelsen \"dpi\" (på norsk ppi = (utskrifts)punkter per tomme), men dette her bare betydning for utskrift. For visning på skjerm må du se på antall punkter totalt. Ved utskrift bør bilde ha en oppløsning på 150 - 300 dpi eller mer, avhengig av skriveren du bruker. Skjermbilder blir sjelden bedre ved høyere oppløsning enn 50 ppi (her: (lys)punkter per tomme), med unntak om du forstørrer bildet. Dersom bildet ikke skal skrives ut eller forstørres, kan du trygt bruke så liten oppløsning som mulig med hensyn til kvaliteten på bildet (som fører til mindre størrelse på filen).</dd><dt><b>Fargedybde</b></dt><dd>Den annen måte å begrense størrelsen på filer, er å redusere antall farger som du bruker i bildet.<br />Antall farger kan variere fra rent svart og hvitt (2 farger) til millioner av farger.<br />Igjen er det antall farger som bestemmer hvor stor filen skal bli.</dd><dt><b>Hvorfor er det viktig å ha så små filer som mulig ?</b></dt><dd><ul><li>Først og fremst: Din plass på nettstedet er begrenset.<br />Jo større filer, jo større plass trenger du på nettjeneren/serveren. Med andre ord et kostnadsspørsmål...!</li><li>Båndbredde. Jo mer data nettjeneren din må sende til din PC for å vise en skjermside, jo mer må du betale (dersom du ikke har fast båndbredde, f.eks ADSL).  Kostnaden avhenger av mengde data som sendes og mottas, men kan også øke ved stor trafikk (ventetid) på nettet.</li><li>Nedlastningstid. Dersom du har store filer, vil besøkende (du også) måtte vente lengre på at sidene skal vises deg.<br />Ikke alle er velsignet med kabel-tilkobling, bredbånd eller DSL.</li></ul></dd><dt><b>Hvordan laste opp (upload) MM-filene dine ?</b></dt><dd>Det er to måter å laste opp mediafiler til nettstedet ditt.<br />- Du kan bruke valget \"Last opp mediafiler\" i menyen #pgv_lang[mgv]#, dersom administratoren for nettstedet har aktivert dette valget.<br />- Dersom du har mange mediafiler, bør du kontakte administratoren til nettstedet for å bli enige om den beste måten å gjøre det på.</dd></dl>";
##$pgv_lang["gen_missing_thumbs_help"]	= "~#pgv_lang[gen_missing_thumbs]#~<br />This option will generate thumbnails for all files in the current directory which don't already have a thumbnail.  This is much more convenient than clicking the <b>#pgv_lang[gen_thumb]#</b> link for each such file.<br /><br />If you wish to retain control over which files should have corresponding thumbnails, you should not use this option.  Instead, click the appropriate <b>#pgv_lang[gen_thumb]#</b> links.<br /><br />";
$pgv_lang["add_facts_general_help"]		= "~Generell info om å legge til~<br />Når du har lagt til en fakta, note, kilde eller multimedia-fil for en eller flere personer, må disse bli godkjent av en bruker som har fått de nødvendige rettigheter av administrator til nettstedet.<br />I mellomtiden vil endringene være synlige på siden for brukere som kan endre, men merket med en fargekodet rammen. For andre vil de ikke være synlige. Når tilleggene har blitt godkjent, vil rammen forsvinne og datene vises til alle.<br /><br />";

//-- Edit user
$pgv_lang["edituser_my_account_help"]	="På denne siden kan du endre oppsettet og valgene dine.<br /><br />Du kan endre ditt brukernavn, fulle navn, passord, språk, epost-adresse, utseende (stil) på siden, og ønsket kontaktmetode.<br /><br />Du kan imidlertid ikke endre valget for henvisning til din egen ID i slektsbasen på egenhånd.<br />";
$pgv_lang["edituser_username_help"]		="~#pgv_lang[username]#~<br /><br />I dette feltet kan du endre brukernavnet ditt.<br />Dersom du ikke liker brukernavnet ditt lengre, eller har en annen grunn til å endre det, kan du gjøre det ved hjelp av dette feltet.<br /><br />Brukernavnet er <b>følsomt for bokstavtyper</b>. Det betyr at \"Jon\" ikke er det samme som \"jon\" eller \"JON\".<br /><br />Du bør <u>bare</u> bruke bokstaver fra alfabetet (små og/eller STORE), tall, bindestrek (-) og understrek (_).<br /><br /><u>Ikke</u> bruk skilletegn, mellomrom eller andre tegn utenom det vanlige alfabetet/tallrekken.";
$pgv_lang["edituser_firstname_help"]		= "~#pgv_lang[firstname]#~<br /><br />I dette feltet kan du endre fornavnet ditt.<br /><br />Selv om det er opp til deg om du vil endre navn ditt, er lurt også å sende en beskjed til de andre brukerne om endringen (i hvert fall Admin).<br />Som du vet, kan alle brukere som er logget inn, også se navnet ditt.<br />Så, hvis de plutselig ser en ukjent person, vil de muligens lure på hvem som har kommet inn på nettstedet...<br /><br />";
$pgv_lang["edituser_lastname_help"]		= "~#pgv_lang[lastname]#~<br /><br />I dette feltet kan du endre etternavnet ditt.<br /><br />Selv om det er opp til deg om du vil endre navn ditt, er lurt også å sende en beskjed til de andre brukerne om endringen (i hvert fall Admin).<br />Som du vet, kan alle brukere som er logget inn, også se navnet ditt.<br />Så, hvis de plutselig ser en ukjent person, vil de muligens lure på hvem som har kommet inn på nettstedet...<br /><br />";
$pgv_lang["edituser_gedcomid_help"]		="~#pgv_lang[gedcomid]#~<br /><br />Dette er et intert nummer (slektsbaseID) som knytter deg til dine egne data i slektsbasen.<br /><br />Du kan ikke endre denne IDen. Denne er lagt inn av adminstratoren til nettstedet.<br />Dersom du tror at denne IDen ikke er korrekt, bør du kontakte admin for å få klarert dette.<br />";
$pgv_lang["edituser_rootid_help"]		="~#pgv_lang[rootid]#~<br /><br />Dette er <i>hovedpersonen</i> for de diagrammene og noen rapporter du velger fra hovedmenyen.<br />Dersom du f.eks. velger å se på diagrammet \"Anetre\", så vil se at hovedpersonen er i boksen helt til venstre.<br />Hovedpersonen må selvsagt ikke være deg selv, men kan være hvem som helst (med unntak av personer som ikke vises på grunn av hensynet til personvern.<br />I mange diagram kan du bytte hovedperson, men denne vil ikke bli brukt dersom du velger andre diagram.<br /><br />Velger å se et diagram fra en side med detaljer for en person, vil denne personen bli \"midlertidig\" hovedperson.<br />";
$pgv_lang["edituser_password_help"]		="~#pgv_lang[password]#~<br /><br />Det er en god vane å bytte passordet ditt regelmessig.<br />Du bør huske på at alle som kjenner brukernavnet og passordet ditt, vil ha tilgang til dataene dine.<br />Lag et passord med minst 6 tegn. - Jo lengre, jo bedre!  Lag en kombinasjon av STORE og små bokstaver, tall og andre tegn du kan finne på tastaturet ditt.<br />- Men, ikke lag det så vanskelig at du må skrive det ned for å huske det. En lapp kan andre finne...<br />Brukernavnet er <b>følsomt for bokstavtyper</b>. Dette betyr at \"Jon5\" ikke er det samme som \"jon5\" eller \"JON5\".<br /><br /><b>PS!</b> Det er imidlertid lurt å <b>ikke</b> bruke \" (anførselstegn) eller ' (enkelt anførselstegn). Det kan hende at det vil fungere å bruke disse, men vi kan ikke garantere det.<br /><br />";
$pgv_lang["edituser_conf_password_help"]	="~#pgv_lang[confirm]#~<br /><br />Dersom du har endret passordet ditt, må du bekrefte det også.<br />Dette er bare for sikre deg selv mot at du ikke skrev feil i passord-feltet.<br />Dersom de ikke er like, vil du få en feilmelding.<br />Både passord- og bekreftelses-feltet vil bli tømt og du må skrive det nye passordet på nytt i begge felt.<br />";
$pgv_lang["edituser_change_lang_help"]	="~#pgv_lang[change_lang]#~<br /><br />Her kan du angi det språket som er ditt standardspråk for denne siden.<br />Programmet er i stand til å gjenkjenne det språkvalget du har gjort i nettleseren din, så i de fleste tilfeller er det ikke noen grunn til å endre innstillingen her.<br />Imidlertid kan det f. eks. være at nettleseren din har Engelsk som foretrukket språk, men at du ønsker at <b>språket på dette nettstedet</b> skal være norsk, så kan du endre det her.<br /><br /><br />Administrator har kontroll med hvilke språk som kan velges.  Dersom ditt ønske ikke vises, må du kontakte administratoren.<br />";
$pgv_lang["edituser_email_help"]		="~#pgv_lang[emailadress]#~<br /><br />Din korrekte Epost-addresse er, selvsagt, viktig for oss for å holde kontakten.<br />Dersom du har fått en ny epost-adresse, vær vennlig ikke glem å endre adressen her også.<br />Det kan også være at du har flere epost-adresser og ønsker å motta beskjeder fra oss på en annen epost-adresse.<br />";
$pgv_lang["edituser_user_theme_help"]	="~#pgv_lang[user_theme]#~<br /><br />På dette nettstedet har vi flere stil du kan velge mellom.<br />Du kan også kalle det <i>utseende, skinn, ham eller påkledning</i>. I hver stil vil du se de samme opplysningene, bare med en annen layout.<br />Det er som å sette et bilde i en annen ramme eller henge bilde i et annet rom. Bildet er det samme, men det kan likevel fremstå helt annerledes.<br />Bare prøv de ulike stilene og finn det som du liker best. Du vil ikke kunne gjøre noe galt...<br />Hver gang du logger deg inn, vil du få din <u>egen</u> stil.<br />";
$pgv_lang["edituser_contact_meth_help"]	="~#pgv_lang[user_contact_method]#~<br />PhpGedView har flere måter brukere kan kontaktes på.<br />Alle brukere kan velge sin egen metode for hvordan de vil bli kontaktet.<br />Avhengig av oppsettet for nettstedet, kan det være at noen av metodene ikke er tilgjengelig for deg.";
$pgv_lang["mail_option1_help"]			="Ved å bruke dette valget, vil det interne beskjedsystemet i PhpGedView bli brukt og det vil ikke bli sendt noen epost.<br /><br />Du vil <u>bare</u> motta <u>interne beskjeder</u> fra andre brukere.<br />Når andre brukere sender deg en beskjed, vil beskjeden bli plassert i din beskjed-ramme på din egen side ; #pgv_lang[mygedview]#. Dersom du har fjernet denne rammen fra siden din, vil du ikke se noen beskjeder. De vil imidlertid bli vist dersom du velger å aktivere den igjen.<br />";
$pgv_lang["mail_option2_help"]			="Dette valget er som #pgv_lang[messaging]#, med ett tillegg.<br />Her vil en kopi av beskjeden også bli sendt til epost-adressen din, som du har oppgitt i Min konto.<br />Denne kontaktmetoden er standard valg.<br />";
$pgv_lang["mail_option3_help"]			="Her vil beskjeder <b>bare</b> bli sendt til epost-adressen din.<br />Det interne besjedsystemet i PhpGedView vil ikke bli brukt.<br />";
$pgv_lang["mail_option4_help"]			="Med dette valget vil du ikke motta noen beskjeder i det hele tatt! - Heller ikke administrator kan nå deg...<br />";

//-- Admin
$pgv_lang["admin_help"]					="På denne siden vil du blant annet finne alle valg for konfigurasjon, administrasjon, dokumentasjon og log-filer.<dl><dt><b>Systemtid</b></dt><dd>Rett under overskriften på siden, vises dato og tid som blir hentet fra vertsmaskinen til nettstedet ditt. Dette betyr at klokkeslettet kan være der vertsmaskinen er plassert (f.eks. England). Klokkeslettet er statisk fordi den kun viser tidspunktet da du åpnet denne siden (eller oppfrisket den).</dd></dl><dl><dt><b>ADVARSEL:</b></dt><dd><i>Dersom du ser en melding under systemtiden, så betyr det at filen <b>config.php</b> fortsatt er <b>skrivbar!</b><br />Etter at du har konfigurert programmet ditt, bør du av <b>hensyn til sikkerheten</b> til nettstedet ditt, sette rettighetene til denne filen tilbake til kun lesbar (read-only).<br />Du må gjøre dette <b>manuelt</b>, siden PhpGedView ikke kan gjøre dette for deg (i denne versjonen).</i></dd></dl>";

//-- User Admin
$pgv_lang["useradmin_help"]				="~#pgv_lang[user_admin]#~<br /><br />På denne siden kan du administrere aktiverte og nye brukere.<br /><br /><b>#pgv_lang[current_users]#</b><br />I denne tabellen vises aktiverte brukere med deres status og rettigheter.<br />Du kan <b>slette</b> eller <b>endre</b> kontoen til brukere.<br /><br /><b>#pgv_lang[add_user]#</b><br />Dette skjemaet er nesten tilsvarende de du vil finne under <b>#pgv_lang[editowndata]#</b>.<br />For flere felt er det ikke laget noen egen hjelpetekst for administratorer. For disse vil du se følgende melding:";
$pgv_lang["useradmin_gedcomid_help"]	="~#pgv_lang[gedcomid]#~<br /><br />Denne #pgv_lang[gedcomid]# vil identifisere brukeren i slektsbasen og kan bare angis av administratoren.<br />Dette vil også gi brukeren tilgang til valgene <b>#pgv_lang[my_indi]#</b> og <b>#pgv_lang[my_pedigree]#</b> for han/henne.<br /><br />For hver slektsbase du bruker i dette programmet, kan du angi brukerID til brukeren i basen.<br />Dersom en bruker ikke er registert i slektsbasen, kan du la feltet være tomt.";
$pgv_lang["useradmin_rootid_help"]		="~#pgv_lang[rootid]#~<br /><br />For hver slektsbase i programmet, kan du angi en <b>hovedperson</b> for hver bruker.<br />Det er mest vanlig at brukeren vil ønske å starte programmet med seg selv, men dette er opp til brukeren selv.<br /><br />Alle brukere som har rett til å endre egen konto, kan bytte denne innstillingen selv.";
$pgv_lang["useradmin_can_admin_help"]	="~#pgv_lang[can_admin]#~<br /><br />Dersom denne sjekk-boksen er avmerket, vil brukeren ha de samme rettigheter i programmet som du har som administrator.<dl><dt>Brukeren kan da:</dt><dd>Legge til / Fjerne / Endre brukere.</dd><dd>Sende beskjeder til alle brukere på en gang.</dd><dd>Endre beskjeder på hovedsiden.</dd><dd>Endre og sette opp språk-filer.</dd><dt>I tillegg:</dt><dd>Oppgradere programmet.</dd><dd>Endre program-innstillinger.</dd><dd>Administere slektsfiler.</dd><dd>Endre personvern-innstillinger.</dd></dl>- Og andre ting som ikke er nevnt her...<br /><br />Brukeren <u>kan ikke</u> endre oppsettet for nettstedet ditt som befinner seg \"utenfor\" PhpGedView! ";
$pgv_lang["useradmin_sync_gedcom_help"]		= "~#pgv_lang[sync_gedcom]#~<br /><br />Dersom denne sjekk-boksen er avmerket og brukeren har en ID knyttet til seg i slektsbasen, vil innstillingene i brukerkontoen deres automatisk bli synkronisert med dataene i slektsbasen.<br />Dette betyr at dersom opplysningene til brukeren blir endret i slektsbasen, vil noen av disse, som f.eks. navn og epostadresse, bli kopiert til kontoen til brukeren.<br />Tilsvarende vil endring av enkelte opplysninger i kontoen til brukeren, bli kopiert til slektsbasen.";
$pgv_lang["useradmin_can_edit_help"]	="~#pgv_lang[can_edit]#~<br /><br />For hver slektsfil som er installert, kan brukere få ulike rettigheter for innsyn og til å endre data.<dl><dt>Du kan gjøre følgende valg:<br /><b>#pgv_lang[none]#</b></dt><dd>Brukeren kan ikke se private opplysninger i denne slektsbasen.</dd><dt><b>#pgv_lang[access]#</b></dt><dd>Brukeren kan se private opplysninger, men kan ikke gjøre endringer.</dd><dt><b>#pgv_lang[edit]#</b></dt><dd>Brukeren kan gjøre endringer, men en annen bruker med rettighet til å <b>#pgv_lang[accept]#</b> må gå god for endringen før de blir lagt til slektsfilen slik at alle brukere kan se endringene.</dd><dt><b>#pgv_lang[accept]#</b></dt><dd>Brukeren kan både endre og godkjenne egne og andre brukeres endinger.</dd><dt><b>#pgv_lang[admin_gedcom]#</b></dt><dd>Brukeren får rettighetet til å endre konfigurasjon og personverninnstillinger for denne slektsbasen.</dd></dl>System-administratorer får automatisk rettighet til å <b>#pgv_lang[admin_gedcom]#</b>.";
$pgv_lang["useradmin_verified_help"]	="~#pgv_lang[verified]#~<br /><br /><b>Bekreftelse</b><br />Dette betyr at en bruker har søket om å få en ny konto ved hjelp av siden for å <b>Søke om brukerkonto</b>.<br />Her vil brukeren ha mottatt en epost-melding med en link for å bekrefte søknaden.<br />Dersom brukeren gjort dette, vil du se at sjekk-boksen er avmerket, og du kan da gå til neste felt: <b>#pgv_lang[verified_by_admin]#</b>.<br />Dersom søkeren ikke har bekreftet søknaden bør du vente med godkjenningen.<br /><br /><b>Legg til bruker manuelt</b><br />Dersom du bruker dette skjemaet til å legge til en bruker manuelt, vil du se at sjekk-boksen allerede er avmerket.";
$pgv_lang["useradmin_verbyadmin_help"]	="~#pgv_lang[verified_by_admin]#~<br /><br />Dersom en bruker har brukt skjemaet \"Søke om brukerkonto\" og bekreftet søknaden, må du godkjenne brukeren før kontoen blir aktivert.<br /><br />Etter at du har godkjent at brukeren får en konto, vil den nye brukeren motta en epost-melding med beskjed om kontoen er aktivert og at brukeren nå kan logge inn ved hjelp av brukernavnet og passordet som ble angitt på siden der du søkte om konto.";
$pgv_lang["useradmin_edit_user_help"]	="~ENDRE KONTO TIL BRUKER~<br /><br />Dette skjemaet blir brukt av administratoren for å endre kontoen til en bruker.<br /><br />Skjemaet er tilsvarende skjemaene <b>#pgv_lang[add_user]#</b> og <b>#pgv_lang[update_myaccount]#</b>.";
$pgv_lang["useradmin_visibleonline_help"]	= "~VIS PÅLOGGEDE BRUKERE~<br /><br />Dersom dette valget er merket, vil brukere som er pålogget, se om du og/eller andre brukere er også er pålogget.  Ved å ikke merke dette valget, vil andre ikke kunne se om du er pålogget, og du vil heller ikke se om andre brukere er pålogget.";
$pgv_lang["useradmin_editaccount_help"]			= "~ENDRE BRUKER-KONTO~<br /><br />Dersom dette valget er merket, vil brukeren ha rettighet til å endre sin egen brukerkonto.<br /><br />Hvis valget ikke er avmerket, vil brukeren ikke kunne endre sine egne brukervalg.  Dette gir deg muligheten til å lage et felles brukernavn og passord for flere brukere og hindre dem i å endre den felles brukerkontoen.";
$pgv_lang["useradmin_relation_priv_help"]		= "~#pgv_lang[user_relationship_priv]#~<br /><br />Dersom dette valget er merket, vil brukeren bare få tilgang til levende personer som de er i slekt med.  De vil kunne se alle som er innenfor antall ledd for slektskap som er bestemt i innstillingen <i>#pgv_lang[user_path_length]#</i>.  Du kan be om personvern av slektinger for alle brukerne dine ved å aktivere valget global i seksjonen for Personverninnstillinger.<br /><br />Denne innstillingen krever at brukeren er registrert i slektsbasen før de kan se levende personer.<br /><br />";
$pgv_lang["useradmin_path_length_help"]			= "~#pgv_lang[user_path_length]#~<br /><br />Dersom <i>#pgv_lang[user_relationship_priv]#</i> er aktivert, vil denne brukeren bare kunne få se eller endre levende personer som er innenfor dette antallet av ledd av slektskap.<br /><br />";
##$pgv_lang["useradmin_auto_accept_help"]			= "~#pgv_lang[user_auto_accept]#~<br /><br />By checking this box you are allowing the system to automatically accept any edit changes made by this user.  The user must also have accept privileges on the GEDCOM in order for this setting to take effect.<br /><br />";

//-- Manage Sites
##$pgv_lang["help_managesites"] 			= "~MANAGE SITES~<br /><br />On this page you can add remote sites and ban IP addresses.<br /><br />Remote sites can be added by providing the site title, URL, database id(optional), username, and password for the remote web service.<br /><br />IP address banning is accomplished by supplying any valid IP address range. For example, 212.10.*.*  Remote sites within the IP address ranges in the Banned list will not be able to access your web service.  You can ban specific IP addresses too.";
//-- Adding Remote Links
##$pgv_lang["help_remotesites"]			= "~Adding Remote Sites~<br /><br />To add a remote site, provide the site title, URL of the remote web service, database id(optional), and username and password. Click the Add button to complete the process.  If the remote server allows anonymous authentication, you should leave the username and password blank.";
//-- IP Address Banning
##$pgv_lang["help_banning"]				= "~IP Address Banning~<br /><br />To ban remote sites from accessing your web service, provide a specific IP address or a valid IP address range, for example, 212.10.*.* and click the Submit button.";
##$pgv_lang["help_manual_search_engines"]				= "~Manual Search Engine Spider Marking~<br /><br />PhpGedView automatically provides search engines with smaller data files with fewer links.  The data is limited to the individual and immediate family, without adding information about grand parents or grand children.  Many reports and server-intensive pages like the calendar are off limits to the spiders.<br /><br />If a search engine is not automatically recognized and you wish to provide it data to index, you can list it here.  If you do not want to provide it data, you list it below in the banned IP section.<br /><br />If you wish to see what data is provided to search engines to index, list your own IP address here.  <font color=\"red\">WARNING:</font> This will lock you out of the admin interface, and you must remove the IP by logging in from a different machine or manually editing the <i>/index/search_engines.php</i> file.<br /><br />To manually mark a remote site as a search engine spider, provide a specific IP address or a valid IP address range, for example, 212.10.*.* and click the Submit button.  Many popular search engines like Google and Yahoo will be detected automatically.";

//-- Search_engines.php
##$pgv_lang["search_engine_landing_page"]		= "~Search Engine Detected~<br /><br />PhpGedView automatically provides search engines with smaller data files with fewer links.  The data is limited to the individual and immediate family, without adding information about grand parents or grand children.  Many reports and server-intensive pages like the calendar are off limits to the spiders.<br /><br />Attempts by the spiders to go to those pages result in showing this page.  If you are seeing this text, the software believes you are a search engine spider.  Below is the list of pages that are allowed to be spidered and will provide the abbreviated data.<br /><br />Real users who follow search engine links into this site will see the full pages and data, and not this page.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]		="~LEGGE TIL kontra HENTE (UPLOAD) GEDCOM~<dl><dt>Hente (upload) GEDCOM-fil(er)</dt><dd>Å hente (upload) filer kan gjøres online, dersom du ikke har et ftp-program tilgjengelig.</dd><dt>Legge til en GEDCOMfil</dt><dd>Dersom en fil fortsatt finnes i katalogen der du lagrer GEDCOMfilene dine, kan du bruke den igjen uten å hente den på nytt.<br />Noen ganger må en bruke Legge til i stede for å Hente (upload) på grunn av filstørrelsen eller begrensninger i forhold til opplasting.</dd></dl>Både prosedyren \"Legg til\" og \"Hente\" kan utføres med 4 enkle skritt.<br />Det er bare skritt 1 som er forskjellig i prosedyrene.<br />";
$pgv_lang["gedcom_configfile_help"]		="~KONFIGURASJONSFIL TIL SLEKTSFILEN~<br /><br />Dette er filen hvor alle basis-innstillinger til slektsbasen er lagret.<br /><br />I kolonnen \"Konfigurasjonsfil\" på siden for Aktive slektsfiler, vises stien og navnet til konfigurasjonsfilen(e).";
$pgv_lang["default_gedcom_help"]		="~STANDARD SLEKTSBASE/-FIL~<br /><br />Dersom du har flere enn en slektsbase i programmet, kan du her angi hvilken som skal være <b>standard</b> slektsbase.<br /><br />Denne vil bli vist til besøkende og brukere som ikke er logget inn.<br /><br />Brukere kan overstyre denne innstillingen dette standardvalget ved at de gjør et annet valg i egen konto.<br />";
$pgv_lang["delete_gedcom_help"]			="~SLETTE SLEKTSFIL~<br /><br />PhpGedView importerer poster fra slekts-/GEDCOMfilen. Dersom du klikk på <b>Slett</b>, vil programmet slette disse postene som ble importert fra GEDCOMfilen.<br />Den originale GEDCOM-filen vil ikke bli slettet/rørt.<br /><br />Dersom du senere ønsker å bruke / jobbe med denne GEDCOM-filen igjen, kan du bare bruke valget <b>Legg til en GEDCOMfil</b>.<br /><br />Etter at du klikket på \"Slett\", må du <b>bekrefte</b> valget ditt.";
$pgv_lang["add_gedcom_help"]			="~LEGGE TIL SLEKTSBASE~<br /><br />Når du bruker linken \"Legg til GEDCOMfil\", er det forutsatt at du allerede har overført GEDCOMfilen til serveren din <i>ved hjelp av et eksternt program</i>, for eksempel med <b>ftp</b>- eller <b>nettverks</b>-tilkobling.<br />Dersom GEDCOMfilen ikke er på serveren din enda, <b>må</b> du gjøre dette først før du kan bruke \"Legg til...\".<br /><br />Du blir veiledet skritt for skritt gjennom hele prosedyren.<br />";
$pgv_lang["add_new_gedcom_help"]		="~LAG EN NY SLEKTSBASE~<br /><br />Du har muligheten til å lage en ny slektsbase fra \"scratch\" (dvs. uten noen personer).<br /><br /><dl><dt>Skritt 1: Gi den nye GEDCOMen et navn</dt><dd>Skriv navnet til den nye slektsfilen <b>uten</b> etternavnet '.ged'. Den nye filen vil bli opprettet/lagret i katalogen som nevnt i teksten over feltet der du skriver inn filnavnet.<br />Klikk på <b>Legg til</b>.</dd><dt>Skritt 2: Konfigurasjon-siden.</dt><dd>Dette er siden der du angir innstillingene for slektsbasen.</dd><dt>Skritt 3: Gyldighet</dt><dd>Den nye basen er sjekket og vil være godkjent.</dd><dt>Skritt 4: Importere poster</dt><dd>Siden det ikke er noen poster å importere, vil dette være veldig fort gjort...</dd><dt>Ferdig...</dt><dd>Nå kan du gå til Anetreet for å se den \"første\" personen i den nye slektsbasen. Klikk på navnet til personen og start deretter å endre denne. Deretter kan begynne å legge til nye personer knyttet til den første personen.</dd></dl>";
$pgv_lang["download_gedcom_help"]		="~LAST NED (DOWNLOAD) GEDCOM~<br /><br />Du har mulighet til å laste ned (download) en GEDCOMfil fra nettstedet ditt.<br /><br />På siden for å \"Last ned (download) GEDCOM\" får du valget om å konvertere filen fra <b>UTF-8</b> til <b>ANSI (ISO-8859-1)</b> tegnsett.<br />Hvilket format du trenger, avhenger av programmet du ønsker å bruke for å arbeide med den nedlastede GEDCOMfilen.<br />Sjekk dokumentasjonen til programmet dersom du ikke er sikker.";
$pgv_lang["edit_gedcoms_help"]			="~ADMINISTRASJON AV SLEKTSFIL(ER)~<br /><br />Siden for administrasjon av slektsfil(er) er kontroll-senteret for å adminstrere de <b>aktive</b> og <b>nye</b> slektsfiler.<br /><dl><b>AKTIVE SLEKTSFILER (GED)</b><br /><dt>I tabellen med <b>Aktive slektsfiler</b> har du følgende valg:</dt><dd>Slette slektsfil</dd><dd>Endre slektsfil</dd><dl><dt>Endre personvernfilen</dt><dd>Hver slektsfil har sine egne personvern-innstillinger. Å endre innstillinger her vil bare ha innvirkning på den slektsfilen den er knyttet til.</dd></dl><dd>Angi Standard slektsbase</dd><dd>Importer GEDCOM</dd><dd>Last ned (download)</dd><dt>Det er også 3 kolonner med følgende informasjon:</dt><dd>GEDCOMfil</dd><dd>Tittel til slektsbasen</dd><dd>Konfigurasjonsfil</dd></dl><dl><b>NYE GEDCOMFILER</b><dt>På denne siden har du følgende valg for å legge til <b>ny</b> og/eller <b>eksisterende</b> GEDCOMfiler til programmet.</dt><dd>Legg til en GEDCOMfil</dd><dd>Hente (upload) GEDCOMfil</dd><dd>Lage en ny GEDCOMfil</dd></dl>#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]	="~KONFIGURERE SLEKTSBASE~<br /><br />Hver slektsbase som du bruker i dette programmet har sin egen <b>Konfigurasjonsfil</b>.<br /><br />På dette skjemaet kan du angi basis-innstillinger slik som f.eks, språk, kalenderformat, epost-valg, osv., osv.<br />";
$pgv_lang["import_gedcom_help"]			="~IMPORTERE GEDCOM~<br /><br />I de fleste tilfeller er import av en GEDCOM en del av en større prosedyre som for eksempel å legge til, lage en ny eller hente (upload).<br /><br />Disse delene som er i en logisk og nødvendig rekkefølge, må gjennomføres helt for at importen skal skje riktig.<br />Dersom du ikke fullførte alle delene, som beskrevet over, vil du få en <b>advarsel</b> om at slektsbasen ikke er blitt importert enda. Da bør du klikke på linken igjen for å importere GEDCOM-filen på nytt.<br /><br /><b>Importere</b><br /><br />Innstillingene til slektsbasen vil ikke bli endret når du importerer en GEDCOM-fil på nytt.<br />Bare eksisterende slektsdata vil bli overskrevet.";
$pgv_lang["upload_gedcom_help"]			="~HENT (UPLOAD) GEDCOM~<br /><br />Til forskjell fra valget \"Legg til GEDCOMfil\", trenger du ikke å ha lagret GEDCOMfilen på serveren fra før.<br /><br />Du starter med å velge en GEDCOMfil fra din lokale datamaskin. Angi både stien og filnavnet i tekstfeltet eller bruk knappen <b>Bla gjennom</b> ved siden av tekstfeltet.<br /><br />Du vil kunne finne mer hjelp på andre sider i løpet av installasjonen.<br />";
$pgv_lang["validate_gedcom_help"]		="~SJEKK GYLDIGHET TIL GEDCOM~<br /><br />Å sjekke gyldigheten til GEDCOMfilen under installasjonen, er i del 3 i prosedyren for å legge inn dataene i programmet.<br /><br />Filen blir sjekket for korrekt føring av: Datoformat, steder, tegnsett m.m.<br />Noen av avvikene som programmet finner, vil bli rettet automatisk. Eksempler kan være MacIntosh linje-slutt-koding og ugyldig bruk av format på steder.<br />Dersom programmet finner disse vil du få en beskjed om at programmet har endret dataene.<br />For andre avvik vil du få en advarsel-melding med et forslag til løsning.<br /><br /><b>Tilleggs-verktøy</b><br />I denne versjonen av PhpGedView har du disse:<br /><b>Endre person-ID til...</b> og <b>Legg til bilder / andre medier</b>.<br />Dette verktøyet er bare tilgjengelig når du bruker <b>database</b>. For <b>Index</b> vil dette valget være skjult.<br /><br /><b>Mer hjelp</b> er tilgjengelig i skjemaet. #pgv_lang[more_help]#<br />";
$pgv_lang["convert_ansi2utf_help"]		="~KONVERTER ANSI TIL UTF-8~<br /><br />For å være sikker på at programmet håndterer GEDCOMfilene dine korrekt, bør filene være kodet i UTF-8 format.<br /><br />De fleste Slektsprogram har et valg for å kunne eksportere GEDCOMfiler med tegnsettet UTF-8.<br />Dersom programmet som du bruker ikke gir deg dette valget, kan PhpGedView konvertere filen for deg.<br /><br />Når PhpGedview sjekker kvaliteten ved henting (upload) eller Legg til fil, så vil programmet oppdage om filen har ANSI tegnsett.";
$pgv_lang["detected_ansi2utf_help"]		="~ANSI TEGNSETT OPPDAGET~<br /><br />GEDCOMfilen som nå er blitt sjekket gyldigheten til, har ANSI tegnsett.<br />Det anbefales på sterkeste at filen konverteres til UTF-8 tegnsett (ellers vil sær-nasjonale tegn (f.eks. ÆØÅ) bli vist feil).<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			="~FEIL DATO-FORMAT OPPDAGET:<br />DATO-FORMAT VIL BLI ENDRET~<br /><br />Dato-formatet som er standard i PhpGedview og definert i <b>GEDCOM 5.5.1 standarden</b>, er: DD MMM YYYY (eks. 01 JAN 2004)<br /><br />Dersom du får opp en melding om at feil dato-format er oppdaget, så vil programmet konvertere datoene til standardformat.<br /><br />Du får imidlertid et valg om enten \"<b>dag</b> før måned\" (DD MMM YYYY), eller \"<b>måned</b> før dag\" (MMM DD YYYY).<br />Vi anbefaler at du bruker den foreslåtte innstillingen (DD MMM).";
$pgv_lang["change_indi2id_help"]		= "~BYTT PERSON-ID TIL ....~<br /><br />Dette verktøyet ble lagd for brukere av slektsprogram som lagde forskjellige ID for personene hver gang disse eksporter til en GEDCOMfil. For eksempel så gav programmet ved første eksport til en GEDCOM, en person ID I100, mens neste gang ID I234 til samme person.  Disse byttingene av ID gjør det vanskelig å administere PhpGedView fordi IDen brukes til å identifisere personer.<br /><br />De fleste slektsprogram bruker også RIN- eller REFN-kodene (tag) for å gi hver person en unik identifikasjon som kan brukes til å gjenkjenne personen. Dette verktøyet vil erstatte alle IDer til til personer i GEDCOMfilen med verdien til et annet felt som du angir.  Du kan velge RIN- eller REFN-feltet som kilde for å IDen til personene i slektsfilen.<br /><br />";
$pgv_lang["edit_privacy_help"]			="På denne siden kan du opprette dine egne personvern-innstillinger for den valgte slektbasen din (valgte - hvis du har flere enn en).<br />Du kan sjekke under tittelen på siden om det er den rette personvern-filen.<br />Den er vist slik: (path/navnet_til_din_gedcom_priv.php)<br /><br />Dersom du trenger flere innstillinger, så kan du \"manuelt\" gjøre endringer i personvern-filen. Du kan lese mer om dette på nettstedet til PhpGedView.<br />";
##$pgv_lang["BOM_detected_help"]			= "~Byte Order Mark (BOM) detected~<br /><br />The GEDCOM file you are importing has a special 3-byte code at the beginning.  This special code is used by some programs to indicate that the file has been recorded in the UTF-8 character set.<br /><br />Although this special code is not really an error, PhpGedView will not work properly when the input file contains the code.  You should let PhpGedView remove the code.<br /><br />";
$pgv_lang["invalid_header_help"]		= "~UGYLDIG START I GEDCOM-FIL~<br />En GEDCOM-fil må ha som første linje: 0 HEAD.  PhpGedView oppdaget at GEDCOM-filen din har en annen start.  Etter at du har klikket på knappen Rydd, vil alle linjer før linjen med 0 HEAD bli fjernet i GEDCOM-filen din.<br /><br />Denne feilen betyr vanligvis at programmet du brukte for å lage GEDCOM-filen din ikke lagde en gyldig file eller at filen ikke er en GEDCOM-fil.  Du bør sjekke at du lastet opp (uploaded) den rette GEDCOM-filen, og at den starter med linjen 0 HEAD og slutter med linjen 0 TRLR.";
$pgv_lang["macfile_detected_help"]		= "~OPPDAGET MACINSTOSH-FIL~<br />PhpGedView oppdaget at GEDCOM-filen din ble lagd på på en Macintosh datamaskin.  Macintosh-filer bruker andre koder for linjeslutt (\r) enn Unix (\n) og DOS/Windows (\r\n).  PHP-funksjoner brukt av PhpGedView krever at GEDCOM-filene må være Unix- eller DOS-filer.  Når du klikker på knappen Rydd, vil filen din bli konvertert til en DOS-fil.<br />";
$pgv_lang["cleanup_places_help"]		= "~RYDD STEDSKODER~<br />PhpGedView oppdaget at GEDCOM-filen din bruker koden stedskoden (2 PLAC) på feil steder.  Mange slektsprogrammer, som f.eks Family Tree Maker, lager GEDCOM-filer med denne feilen.  PhpGedView vil i utgangspunktet godta disse GEDCOM-filene, men ugyldige stedskoder vil \"snike\" seg inn blant gyldige stedskoder.  <br /><br />For eksempel kan GEDCOM-filen din ha følgende koding:<br />1 SSN<br />2 PLAC 123-45-6789<br />I henhold til gjeldende GEDCOM-spesifikasjon skulle dette ha blitt kodet slik:<br />1 SSN 123-45-6789<br />Dersom du velger Ja, vil PhpGedView lete og rydde opp i disse kode-feilene.<br />";
$pgv_lang["empty_lines_detected_help"]	= "~OPPDAGET TOMME LINJER~<br />PhpGedView oppdaget at det er tomme linjer i GEDCOM-filen din.  Disse linjene kan føre til feil og vil bli fjernet fra GEDCOM-filen før den blir importert.<br />";

//-- Edit Config
$pgv_lang["help_editconfig.php"]		="~Oppsett av PhpGedView~<br /><br />På denne siden har du feltene for de globale innstillingene som du må fylles ut før PhpGedView-programmet kan kjøres på din nettserver.<br />#pgv_lang[review_readme]#<br /><br />Siden disse innstillingene er <b>globale</b>, gjelder de for selve programmet og for alle slektsfiler du bruker i programmet.<br />For hver slektsbase kan du ha forskjellige innstillinger.<br />Her på Konfigurasjon-siden kan du også klikke på linken til Redigere GEDCOMfiler rett over skjemaet eller gå til den samme siden fra menyvalget \"Min GedView\".";

//-- merge records
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Denne siden gir deg mulighet til å flette (føye sammen) 2 GEDCOM-poster i slektsbasen.  Dette er en nyttig funksjon dersom du har importert en annen slektsbase (GEDCOM) inn i din egen og du har fått dobbelt opp av flere personer, familier og/eller kilder.<br /><br />Denne siden innholder 3 steg.<br /><ol></li><li>Du angir to IDer i slektsbasen.  IDene må være av samme slag (type).  (dvs. at du ikke kan flette en person og en familie, eller en familie og en kilde).  I feltet <b>#pgv_lang[merge_to]#</b> angir du IDen til posten (personen) som du ønsker skal bli den den nye posten etter at flettingen er fullført.  I feltet <b>#pgv_lang[merge_from]#</b> angir du IDen til posten som skal flettes inn i den første og deretter vil bli slettet.</li><li>Du velger hvilke opplysninger som du vil beholde fra de to postene etter at de flettet sammen til en post.  Du klikke bare på sjekkfeltet ved siden av de(n) du ønsker å beholde.</li><li>Viser deg resultatet av flettingen.</li></ol>For at endringen skal være gyldig og bli vist andre, må du sjekke resultatet og godkjenne den først.<br />";

//-- report engine
$pgv_lang["help_reportengine.php"]		= "~Rapporter~<br /><br />Valgene i menyen vil gi deg rapporter i formatet <a href=\"?help=def_pdf_format_help\">PDF</a> (som betyr at du må ha et program som kan vise/skrive ut dette formatet, for eksempel <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" alt=\"Hent det gratis her\" title=\"Hent det gratis her\" >Adobe Reader</a>).<br />Etter å ha valgt ønsket rapport, må du gjøre ulike valg i forhold til hva som skal vises;<br />- I rapporten for person kan du blant annet velge om du vil vise kilder, noter og bilder.<br />Du kan enten velge <b><i>#pgv_lang[run_report]#</i></b> for å se på rapporten (ikke tilgjengelig...) eller <b><i>#pgv_lang[download_report]#</i></b> for å lagre den på datamaskinen din. <br /><br />Noen av de tilgjengelige rapportene er:<ul><li><a href=\"#report_ahnen\">#pgv_lang[ahnentafel_report]#</a></li><li><a href=\"#report_birth\">#pgv_lang[birth_report]#</a></li><li>#pgv_lang[individual_report]#</li><li>#pgv_lang[family_group_report]#</li><li>#pgv_lang[index_header]#</li><li><a href=\"#report_rela\">#pgv_lang[relatives_report]#</a><br /><br /></li><li><a href=\"#report_report\">Lage rapporter</a></li></ul><br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"report_ahnen\"> </a>#pgv_lang[help_ahnentafel.xml]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"report_birth\"> </a>#pgv_lang[help_birthlist.xml]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"report_rela\"> </a>#pgv_lang[help_relativelist.xml]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"report_report\"> </a>#pgv_lang[help_xml_reports]#<br />";
$pgv_lang["def_pdf_format_help"]	= "~PDF filformat~<br />PhpGedView lager rapportene sine i formatet <i>Adobe&reg; PDF</i>.<br /> Spesifikasjonen <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank>GEDCOM 5.5.1 Standard</a> kan også hentes i en PDF-fil.<br />PDF er et akronym for <b>P</b>ortabel <b>D</b>okument <b>F</b>ormat.<br /><br />PDF-filer kan ikke vises uten at du har program som støtter denne filtypen.  Du har kanskje allerede programmet <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=_blank alt=\"Hent det gratis her\" title=\"Hent det gratis her\"><b>Adobe Reader</b></a> tilgjengelig på datamaskinen (det installeres ofte sammen med andre program). Har du Acrobat Reader, så er det en tidligere versjon som også fungerer greit.<br /><br />Dersom du ikke har Adobe Reader, kan det hentes gratis fra hjemmesidene til <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=_blank><b>Adobe Systems Inc.</b></a>.  Du kan finne kopier av \"Adobe Reader\" tilgjengelig for nedlasting fra andre nettsteder, men vi anbefaler at du <u>bare</u> stoler på nettstedet til Adobe Systems Inc.<br /><br />Adobe Reader er tilgjengelig for de fleste operativsystemer, inkludert Microsoft&reg; Windows og Apple&reg; Macintosh, på mange forskjellige språk.  Dersom du bruker Windows 95, bør du ikke bruke nyere versjon enn 5.0.5 av Acrobat Reader.<br /><br />";
$pgv_lang["help_ahnentafel.xml"]	= "~#pgv_lang[ahnentafel_report]#~<br />Dette er en rapport som viser den valgte personen og tilhørende forfedre vist som et hefte.  Den starter med personen og fortsetter med foreldrene, besteforeldrene osv.<br /><br />";
$pgv_lang["help_birthlist.xml"]		= "~#pgv_lang[birth_report]#~<br />Dette er en rapport som kan vise alle personer som er født på et bestemt tidspunkt eller sted.<br /><br />";
$pgv_lang["help_relativelist.xml"]	= "~#pgv_lang[relatives_report]#~<br />Dette er en rapport som viser alle slektninger til den valgte personen.  Du kan velge hvilke slektninger i tillegg til valgt person:<ul><li><b>#pgv_lang[child-family]#</b> vil vise foreldre og søsken.</li><li><b>#pgv_lang[spouse-family]#</b> vil vise ektefelle og felles barn.</li><li><b>#pgv_lang[direct-ancestors]#</b> vil vise foreldre, besteforeldre, oldeforeldre, ... til det ikke finnes flere registrerte foreldre i slektslinjen til personen.</li><li><b>#pgv_lang[ancestors]#</b> vil vise alle personer i rapporten #pgv_lang[direct-ancestors]# og i tillegg tanter og onkler, søsken til besteforeldre osv.  Den vil ikke vise søskenbarn.</li><li><b>#pgv_lang[descendants]#</b> vil vise etterkommere (barn, barnebarn, osv).</li><li><b>#pgv_lang[all]#</b> vil vise en kombinasjon av rapportene #pgv_lang[descendants]# og #pgv_lang[ancestors]#.</li></ul><br /><br />";
$pgv_lang["help_xml_reports"]	= "~Lage rapporter~<br />PhpGedView lager rapporter ved hjelp av malfiler i kodespråket XML (avansert utgave av HTML). Formatet på rapportene er <a href=\"?help=def_pdf_format_help\">PDF</a>.<br /><br />De viste rapportene er et resultat av XML-filer funnet i mappen \"reports\".  Du kan lage dine egne rapporter ved å kopiere en av de eksisterende malene og endre innholdet.<br />Nye rapporter i mappen \"reports\" vil automatisk bli oppdaget og vist i menyvalget \"Rapporter\".<br /><br />";

//-- Help Contents
$pgv_lang["help_contents_head_help"]		= "<b>Emner i hjelp</b><br />";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM / slektsfil";
$pgv_lang["help_contents_gedcom_places"]	= "Steder i slektsbasen (Ged)";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	="<b>Emner i hjelp<br /><br />Emner for Administrator</b> lagt til i begynnelsen av listen.<br /><br />";
$pgv_lang["ah1_help"]					="_Oppgradere";
//$pgv_lang["ah2_help"]					="_PhpGedView-innstillinger";
$pgv_lang["ah3_help"]					="_GEDCOM: Legg til kontra Hente (upload)";
$pgv_lang["ah4_help"]					="_GEDCOM: Konfigurasjonsfil";
$pgv_lang["ah5_help"]					="_GEDCOM: Standard";
$pgv_lang["ah6_help"]					="_GEDCOM: Slette";
$pgv_lang["ah7_help"]					="_GEDCOM: Legg til";
$pgv_lang["ah8_help"]					="_GEDCOM: Lage ny";
$pgv_lang["ah9_help"]					="_GEDCOM: Laste ned (download)";
$pgv_lang["ah10_help"]					="_GEDCOM: Siden Administrasjon";
$pgv_lang["ah11_help"]					="_GEDCOM: Konfigurere";
$pgv_lang["ah12_help"]					="_GEDCOM: Importere";
$pgv_lang["ah13_help"]					="_GEDCOM: Hente (upload)";
$pgv_lang["ah14_help"]					="_GEDCOM: Sjekke gyldighet";
$pgv_lang["ah15_help"]					="_GEDCOM: Konvertere ANSI til UTF-8";
$pgv_lang["ah16_help"]					="_GEDCOM: Personvern-innstillinger";
$pgv_lang["ah17_help"]					="_Brukere og rettigheter";
$pgv_lang["ah18_help"]					="_Administrasjon";
$pgv_lang["ah19_help"]					="_GEDCOM: MediaVerktøy";
$pgv_lang["ah20_help"]					="_GEDCOM: Endre ID til person(er) til ...";
$pgv_lang["ah21_help"]					= "_Språk-filer";
//           22 is in the help_text_vars.php
$pgv_lang["ah23_help"]				= "_Oppsett for støttede språk";
$pgv_lang["ah24_help"]				= "_Konvertering (SQL <<-->> Index)";
$pgv_lang["ah25_help"]				= "_PhpGedView sikkerhetskopi";
##$pgv_lang["ah26_help"]				= "_FAQ List: Edit";

//--Statistics Help
##$pgv_lang["help_statisticsplot.php"] = "~Statistics Plot~<br /><br />This is the result page, showing the graphical plot of the statistics from your database as defined by the inputs on the previous page.<br /><br />";
##$pgv_lang["help_statistics.php"] = "~Statistics Plot~<br /><br />This page lets you determine the criteria for producing a graphical display of various statistics from your database.<br /><br />";
##$pgv_lang["stat_help"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />A number of different plots of statistics from your database can be produced.<br /><br />Select the chart, then adjust the options from the drop-down boxes.<br /><br />The numbers included in each plot depend on the data available. For example, individuals without a month of birth (e.g. just '1856') cannot be included in a plot of births by month.<br /><br />";
##$pgv_lang["stat_help_x"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~X AXIS~<br />The following options are available for the X axis (horizontal). Each will then be presented according to options set for the Y and Z axes.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_11_mb]#</b>&nbsp;&nbsp;individuals born in each month.<br /><b>#pgv_lang[stat_12_md]#</b>&nbsp;&nbsp;individuals who died in each month.<br /><b>#pgv_lang[stat_13_mm]#</b>&nbsp;&nbsp;marriages that occurred in each month.<br /><b>#pgv_lang[stat_14_mb1]#</b>&nbsp;&nbsp;the number of first-borns for each family by month.<br /><b>#pgv_lang[stat_15_mm1]#</b>&nbsp;&nbsp;the number of first marriages per month.<br /><b>#pgv_lang[stat_16_mmb]#</b>&nbsp;&nbsp;the number of months between marriage and birth of first child to that couple.<br /><b>#pgv_lang[stat_17_arb]#</b>&nbsp;&nbsp;age at death, related to the time period that includes each person's birth year.<br /><b>#pgv_lang[stat_18_ard]#</b>&nbsp;&nbsp;age at death, related to the time period that includes each person's year of death.<br /><b>#pgv_lang[stat_19_arm]#</b>&nbsp;&nbsp;the average age of individuals at the time of their marriages.<br /><b>#pgv_lang[stat_20_arm1]#</b>&nbsp;&nbsp;the average age of individuals at the time of their first marriage.<br /><b>#pgv_lang[stat_21_nok]#</b>&nbsp;&nbsp;average family sizes.<br /><b>#pgv_lang[stat_1_map]#</b>&nbsp;&nbsp;placement of all persons or persons with the specified name, by country.<br /><b>#pgv_lang[stat_2_map]#</b>&nbsp;&nbsp;country of birth.<br /><b>#pgv_lang[stat_4_map]#</b>&nbsp;&nbsp;country of marriage.<br /><b>#pgv_lang[stat_3_map]#</b>&nbsp;&nbsp;country of death.<br /><b>#pgv_lang[stat_9_indi]#</b>&nbsp;&nbsp;pie chart of individuals with sources.<br /><b>#pgv_lang[stat_8_fam]#</b>&nbsp;&nbsp;pie chart of families with sources.</p><br /><br />";
##$pgv_lang["stat_help_y"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~Y AXIS~<br />The following options are available for the Y axis (vertical). These options alter the way the items presented on the X axis are displayed.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_201_num]#</b>&nbsp;&nbsp;displays the number of individuals in each category defined by the X axis.<br /><b>#pgv_lang[stat_202_perc]#</b>&nbsp;&nbsp;calculates and diplays the proportion of each item in the X axis categories.</p><br /><br />";
##$pgv_lang["stat_help_z"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~Z AXIS~<br />The following options are available for the Z axis. These options provide a sub-division of the categories selected for the X axis.<p style=\"padding-left: 25px\"><b>#pgv_lang[stat_300_none]#</b>&nbsp;&nbsp;displays the items as a single column for each X axis category.<br /><b>#pgv_lang[stat_301_mf]#</b>&nbsp;&nbsp;displays the items in 2 columns (male and female) for each X axis category.<br /><b>#pgv_lang[stat_302_cgp]#</b>&nbsp;&nbsp;displays the items in a number of columns related to the time periods set in the next section, for each X axis category.</p><br /><br />";
##$pgv_lang["stat_help_gwx"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired age interval.<br /><br />For example, <b>#pgv_lang[aft_marr]#</b> describes the following set of month ranges:<div style=\"padding-left:30px;\">before the marriage<br />from the marriage to 8 months after<br />from 8 to 12<br />from 12 to 15<br />from 15 to 18<br />from 18 to 24<br />from 24 to 48<br />over 48 months after the marriage</div><br /><br />When you want to show quarters you have to choose: <b>quarters</b>.<br /><br />";
##$pgv_lang["stat_help_gax"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired age interval.<br /><br />For example, <b>interval 10 years</b> describes the following set of age ranges:<div style=\"padding-left:30px;\">younger than one year<br />one year to 5 years<br />6 to 10<br />11 to 20<br />21 to 30<br />31 to 40<br />41 to 50<br />51 to 60<br />61 to 70<br />71 to 80<br />81 to 90<br />91 to 100<br />older than 100 years</div><br /><br />";
##$pgv_lang["stat_help_gbx"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired age interval.<br /><br />For example, <b>interval 2 years</b> describes the following set of age ranges:<div style=\"padding-left:30px;\">younger than 16 years<br />16 to 18<br />19 to 20<br />21 to 22<br />23 to 24<br />25 to 26<br />27 to 28<br />29 to 30<br />31 to 32<br />33 to 35<br />36 to 40<br />41 to 50<br />older than 50 years</div><br /><br />";
##$pgv_lang["stat_help_gcx"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for X axis~<br />Select the desired count interval.<br /><br />For example, <b>interval one child</b> describes the following set of child count ranges:<div style=\"padding-left:30px;\">without children<br />one child<br />two children<br />3, 4, 5, 6, 7, 8, 9, 10 children<br />more than 10 children</div><br /><br />";
##$pgv_lang["stat_help_gwz"]		= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />~boundaries for Z axis~<br />Select the desired starting year and interval<br /><br />For example, <b>from 1700 interval 50 years</b> describes the following set of date ranges:<div style=\"padding-left:30px;\">before 1700<br />1700 to 1749<br />1750 to 1799<br />1800 to 1849<br />1850 to 1899<br />1900 to 1949<br />1950 to 1999<br />2000 or later</div><br /><br />";
##$pgv_lang["chart_type_help"]	= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />Select what you want to see on the map chart. You can choose:<p style=\"padding-left: 25px\"><b>#pgv_lang[indi_distribution_chart]#</b>&nbsp;&nbsp;shows the countries in which persons from this database occur.<br /><b>#pgv_lang[surname_distribution_chart]#</b>&nbsp;&nbsp;shows the countries in which the specified surname occurs.</p><br /><br />";
##$pgv_lang["google_chart_surname_help"]	= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />The number of occurrences of the specified name will be shown on the map. If you leave this field empty, the most common surname will be used.<br /><br />";
##$pgv_lang["chart_area_help"]	= "~OPTIONS FOR STATISTICS PLOTS~<br /><br />Select the geographical area that you want to see on the map. You can choose:<p style=\"padding-left: 25px\"><b>#pgv_lang[world_chart]#</b>&nbsp;&nbsp;shows all continents.<br /><b>#pgv_lang[europe_chart]#</b>&nbsp;&nbsp;shows Europe.<br /><b>#pgv_lang[s_america_chart]#</b>&nbsp;&nbsp;shows South America.<br /><b>#pgv_lang[asia_chart]#</b>&nbsp;&nbsp;shows Asia.<br /><b>#pgv_lang[middle_east_chart]#</b>&nbsp;&nbsp;shows the Middle East.<br /><b>#pgv_lang[africa_chart]#</b>&nbsp;&nbsp;shows Africa.</p><br /><br />";

//-- Find Media Help
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />Dette er del to i forberedelsene for opplasting (uploaded) av media-filer. Her må du sjekke at du har riktige undermapper til standard mediamappe (katalog).<br /><br />Som administrator kan du opprette den mappestrukturen du trenger for å ha orden på media-filene dine. Ved å lage mapper fra denne siden, sikrer at det blir lagd undermapper for miniatyrbilde(r) og at opprettet tilhørende index.php i hver mappe.<br /><br />Du kan flytte filer opp og ned i mappe-strukturen ved å bruke valget <b>#pgv_lang[move_to]#</b>.  Miniatyrbilde(ne) blir også flyttet slik at mappestrukturen holdes inntakt.<br /><br />Dersom du ikke lastet opp (upload) miniatyrbilde-filer, glemte å merke valget <b>#pgv_lang[gen_thumb]#</b> under opplastingen eller om et miniatyrbilde ikke er funnet (sjekk valget <b>#pgv_lang[show_thumbnail]#</b>), har du også her mulighet til å lage miniatyrbilder ved å klikke på valget <b>#pgv_lang[gen_thumb]#</b>.<br /><br />";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Enkelt søkefilter basert på bokstavene/tegnene som er skrevet inn.  Ingen jokere (?*) er tillatt.<br /><br />";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />miniatyrbilde(r) vil vises dersom du merker av dette valget.<br /><br />";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />Som en administrator kan du opprette den mappestrukturen du trenger for å ha orden på media-filene dine. Ved å lage mapper fra denne siden, sikrer at det blir lagd undermapper for miniatyrbilder og at opprettet tilhørende index.php i hver mappe.<br /><br />Klikk på dette valget for å angi navnet på den mappen som du ønsker å lage.<br /><br />";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />Her har du muligheten til å søke i mappestrukturen for å finne media-filen som du ønsker å gjøre en kobling til.<br /><br />";

//-- Add / Edit Media Help
##$pgv_lang["add_media_linkid"]		= "~Link ID~<br /><br />Each media item should be associated with one or more person, family, or source records in your database.<br /><br />To establish such a link, you can enter or search for the ID of the person, family, or source at the same time as you create the media item.  You can also establish the link later through editing options on the Manage Media page, or by adding media items through the Add Media link available on the Individual, Family, or Source Details pages.<br /><br />";
##$pgv_lang["upload_server_file_help"] = "~#pgv_lang[server_file]#~<br /><br />The media file you are uploading can be, and probably should be, named differently on the server than it is on your local computer.  This is so because often the local file name has meaning to you but is much less meaningful to others visiting this site.  Consider also the possibility that you and someone else both try to upload different files called \"granny.jpg\".<br /><br />In this field, you specify the new name of the file you are uploading.  The name you enter here will also be used to name the thumbnail, which can be uploaded separately or generated automatically.  You do not need to enter the file name extension (jpg, gif, pdf, doc, etc.)<br /><br />Leave this field blank to keep the original name of the file you have uploaded from your local computer.<br /><br />";
##$pgv_lang["upload_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />The administrator has enabled up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# folder levels below the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  This helps to organize the media files and reduces the possibility of name collisions.<br /><br />In this field, you specify the destination folder where the uploaded media file should be stored.  The matching thumbnail file, either uploaded separately or generated automatically, will be stored in a similar folder structure starting at <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> instead of <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  You do not need to enter the <b>#GLOBALS[MEDIA_DIRECTORY]#</b> part of the destination folder name.<br /><br />If you are not sure about what to enter here, you should contact your site administrator for advice.<br /><br />";
##$pgv_lang["view_server_folder_help"] = "~#pgv_lang[server_folder]#~<br /><br />The administrator has enabled up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# folder levels below the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  This helps to organize the media files and reduces the possibility of name collisions.<br /><br />In this field, you select the media folder whose contents you wish to view.  When you select <b>#pgv_lang[all]#</b>, all media files will be shown without regard to the folder in which they are stored.  This can produce a very long list of media items.<br /><br />";

//--Repository Help
$pgv_lang["help_repolist.php"]		= "~#pgv_lang[repo_list]#~<br /><br />En liste med oppbevaringssteder eller arkivat blir vist på denne siden.<br />Navnene er vist i alfabetisk rekkefølge.<br /><br /><b>Oppbevaringssted</b><br />Uten oppbevaringssteder for kilder kan kan vi ikke lage slektsbasen vår. Det er en kilde for all informasjon lagret her, og kildene oppbevares på et oppbevaringssted. Oppbevaringssteder kan være en person, arkivet til en person, en institusjon, en offentlig database, et offentlig eller kirkelig arkiv, en Internett-kilde, osv. For å få tilgang til en kilde så ønsker vi å vite hvor og på hvilket sted den befinner seg. All nødvendig informasjon for å finne en kilde bør lagres i en liste over oppbevaringssteder.<br /><br />Et oppbevaringssted kan knyttes mot mange kilder.<br /><br />";
$pgv_lang["help_repo.php"]			= "~#pgv_lang[repo_info]#~<br /><br />Detaljer om oppbevaringsstedet blir vist her. Sammen med kilder, er informasjon om oppbevaringsstedene veldig viktig for slektsforskere.  Ved å ha nøyaktig informasjon om kilder og oppbevaringsteder, kan du følge sporene andre slektsforskere brukte for å finne informasjonen.  Du bør kunne finne den samme informasjonen igjen.<br /><br />På denne siden vil du forhåpentligvis kunne se informasjon om navnet på oppbevaringsstedet, adresse, epost og internettside.<br /><br />Etter informasjonen om oppbevaringsstedet, vil du se en liste med alle kilder som er knyttet til dette oppbevaringsstedet. Det gir deg muligheten til å se all informasjon som er funnet på dette bestemte oppbevaringsstedet.<br /><br />Du vil også ha to eller flere meny-valg på denne siden dersom administratoren til nettstedet har aktivert dette:<br /><b>#pgv_lang[view_gedcom]#</b>, som viser informasjonen i GEDCOM-format.<br /><b>#pgv_lang[add_to_cart]#</b>, som gjør det mulig å kopiere informasjonen til #pgv_lang[clip_cart]# ditt. Herfra kan du hente ned (download) informasjonen i GEDCOM fil-format og import den inn i slektsprogrammet ditt på din lokale maskin.<br /><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["delete_repo_help"]			= "~#pgv_lang[delete_repo]#~<br /><br />Når du klikke på dette valget, så merker du dette oppbevaringsstedet for å bli slettet i slektsbasen.<br /><br />Hva betyr dette?<br />Tenk deg at du har en god grunn for å fjerne dette oppbevaringsstedet fra slektsbasen. Du klikke på valget for å slette.  Du vil nå bli spurt om du virkelig ønsker å slette den.  Dersom du velger å fortsette, så kan det ta litt tid før du kan se beskjeden at oppbevaringsstedet er slettet.<br /><br />Dersom du viser listen med oppbevaringssteder på nytt, vil du se at oppbevaringsstedet fortsatt blir vist og kan bli brukt som om den ikke var slettet.<br /><br /><b>Dette er <u>ikke</u> en feil.</b>  Administratoren til nettstedet vil få en beskjed om at en endring er blitt gjort i slektsbasen, og at det var du som fjernet informasjonen om oppbevaringsstedet.<br />Administratoren kan godkjenne eller forkaste endringen din. Bare etter at administratoren har godkjent endringen din, vil sletting bli utført og <u>kan ikke angres</u>.  Dersom det er tvil med hensyn til endringen, vil administratoren kontakte deg.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]	= "~#pgv_lang[view_gedcom]#~<br /><br />Når du klikke på dette valget,vil informasjon om oppbevaringsstedet, slik det er lagret i slektsbasen, bli vist i et eget vindu.<br /><br />";
$pgv_lang["add_repository_clip_help"]		= "~#pgv_lang[add_to_cart]#~<br /><br />Når du klikke på dette valget kan du kopiere informasjonen om oppbevaringsstedet, slik det er lagret i slektsbasen, til #pgv_lang[clip_cart]# ditt.<br /><br />";
$pgv_lang["repolist_listbox_help"]		= "~#pgv_lang[repo_list]#~<br /><br />I denne listen kan du se navnene på oppbevaringsstedene slik de er lagret i slektsbasen.<br />Navnene vises i alfabetisk rekkefølge.<br /><br />Dersom du klikke på et navn i listen, vil du gå til siden #pgv_lang[repo_info]# der du vil se en ny liste med kilder som er knyttet til oppbevaringsstedet.<br /><br />";
$pgv_lang["repos_listbox_help"]		= "~#pgv_lang[other_repo_records]#~<br /><br />I denne listen kan du se navnene på de kildene som er knyttet til oppbevaringsstedet.<br />Navnene er vist i alfabetisk rekkefølge.<br /><br />Når du klikke på et navn i listen, vil du gå til siden med detaljer for den valgte kilden.<br /><br />";

// Index-Edit
$pgv_lang["block_move_up_help"]		= "~Flytte rammer~<br /><br />Bruk disse knappene for å endre rekkefølgen på valgte rammer.  Rammene vil bli vist i den rekkefølgen som er vist her.<br /><br />Marker den rammen du ønsker å flytte og klikk på en knapp for å flytte rammen opp eller ned.<br /><br />";
$pgv_lang["block_move_right_help"]	= "~Flytte rammer~<br /><br />Bruk disse knappene for å flytte rammer over til den andre listen.<br /><br />Merk den rammen du ønsker å flytte og klikk på en knapp med ønsket retning:<dl><dt> <b>&raquo;</b> og <b>&laquo;</b></dt><dd> Flytte mellom listene med aktive rammer.</dd><dt><b>&gt;</b> og <b>&lt;</b></dt><dd>Flytte mellom listene med  #pgv_lang[available_blocks]#.<br /><br />Innholdet i listen med #pgv_lang[available_blocks]# forandres ikke uansett hva du gjør med knappene #pgv_lang[move_right]# og #pgv_lang[move_left]#, fordi en ramme kan brukes flere ganger på samme side.  Rammen HTML er et eksempel på dette.</dd></dl>";
$pgv_lang["block_default_index"]	= "~Standard rammer for #pgv_lang[welcome]#~<br /><br />Dersom du fjerner alle rammene fra listene #pgv_lang[main_section]# og #pgv_lang[right_section]# eller klikke på knappen <b>#pgv_lang[reset_default_blocks]#</b>, vil standard oppsett bli brukt:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["block_default_portal"]	= "~Standard rammer for #pgv_lang[mygedview]# page~<br /><br />Dersom du fjerner alle rammene fra listene #pgv_lang[main_section]# og #pgv_lang[right_section]# eller klikke på knappen <b>#pgv_lang[reset_default_blocks]#</b>, vil standard oppsett bli brukt:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";

// accesskey help
$pgv_lang["accesskey_viewing_advice_help"]	= "~#pgv_lang[accesskeys]#~<br />Hurtigtaster er ment som en hjelp for brukere som har problemer med pekeutstyr som f.eks mus.  Disse kan variere alt etter hvilken nettleser du bruker:<ul><li>Internet Explorer 5+: Hold nede tasten ALT samtidig som du trykker på ønsket bokstav, og så trykk på Enter (retur).</li><li>Firefox og Netscape 6+: Hold nede tasten ALT samtidig som du trykker på ønsket bokstav. (<u>Ikke</u> trykk på Enter etterpå)</li><li>Opera: Hold nede tastene SHIFT og ESC samtidig som du trykker på ønsket bokstav. (<u>Ikke</u> trykk på Enter etterpå) </li><li>Internet Explorer 5+ for Mac / Safari 1.2+: Hold nede tasten CTRL samtidig som du trykker på ønsket bokstav. (<u>Ikke</u> trykk på Enter etterpå)</li></ul><br />Følgende hurtigtaster er tilgjengelig: <ul><li>Alle sider<ul><li><b>0 (null)</b> - Informasjon om hurtigtastene</li><li><b>1</b> - #pgv_lang[welcome_page]#</li><li><b>#pgv_lang[accesskey_help_content]#</b> - #pgv_lang[help_contents]#</li><li><b>#pgv_lang[accesskey_help_current_page]#</b> - #pgv_lang[help_for_this_page]#</li><li><b>#pgv_lang[accesskey_contact]#</b> - Kontakt </li><li><b>#pgv_lang[accesskey_skip_to_content]#</b> - Gå til Emner i hjelp</li><li><b>#pgv_lang[accesskey_search]#</b> - #pgv_lang[search]# </li></ul></li><li>#pgv_lang[indi_info]#<ul><li><b>#pgv_lang[accesskey_individual_details]#</b> - #pgv_lang[show]# #pgv_lang[personal_facts]# tab</li><li><b>#pgv_lang[accesskey_individual_notes]#</b> - #pgv_lang[show]# #pgv_lang[notes]# tab</li><li><b>#pgv_lang[accesskey_individual_sources]#</b> - #pgv_lang[show]# #pgv_lang[ssourcess]# tab</li><li><b>#pgv_lang[accesskey_individual_media]#</b> - #pgv_lang[show]# #pgv_lang[media]# tab</li><li><b>#pgv_lang[accesskey_individual_relatives]#</b> - #pgv_lang[show]# #pgv_lang[relatives]# tab</li><li><b>#pgv_lang[accesskey_individual_research_log]#</b> - #pgv_lang[show]# #pgv_lang[research_assistant]# tab</li><li><b>#pgv_lang[accesskey_individual_pedigree]#</b> - #pgv_lang[show]# #pgv_lang[pedigree_chart]# #pgv_lang[to]# #pgv_lang[individual]#</li><li><b>#pgv_lang[accesskey_individual_descendancy]#</b> - #pgv_lang[show]# #pgv_lang[descend_chart]# #pgv_lang[to]# #pgv_lang[individual]#</li><li><b>#pgv_lang[accesskey_individual_timeline]#</b> - #pgv_lang[show]# #pgv_lang[timeline_chart]# #pgv_lang[to]# #pgv_lang[individual]#</li><li><b>#pgv_lang[accesskey_individual_relation_to_me]#</b> - #pgv_lang[show]# diagrammet #pgv_lang[relationship_to_me]# #pgv_lang[to]# #pgv_lang[individual]# </li><li><b>#pgv_lang[accesskey_individual_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li></ul><br />";

// FAQ page
##$pgv_lang["help_faq.php"] = "~Frequently Asked Questions~<br />#pgv_lang[text_faq_help]#<br />";
##$pgv_lang["text_faq_help"] = "The FAQ (Frequently Asked Questions) page can contain an overview or a list of questions and answers on the use of this genealogy site.<br /><br />The use to which the FAQ page is put is entirely up to the site administrator. The site administrator controls the content of each item and also the order in which the items are shown on the page.";

// Help search
##$pgv_lang["hs_title_help"] 			= "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
##$pgv_lang["hs_intro"]				= "You can search PhpGedView's Help system.  The #pgv_lang[hs_title]# feature gives you a high degree of control over the way the search functions; you should be able to find what you are looking for easily.";
##$pgv_lang["hs_keyword_advice"] 		= "~#pgv_lang[hs_keyword]#~<br />You enter the words or the phrase you wish to find.<br /><br />The search does not pay attention to the case (upper or lower) of the search terms or the text being examined.  This means that if you search for <b>Individual</b>, you will find text containing <b>Individual</b>, <b>individual</b>, or <b>INDIVIDUAL</b>.  You will also find text containing <b>individuals</b>, etc. since the search is looking for sequences of characters rather than words.<br /><br />You can have the search look for several words at once.  Enter all of the words, separating each of them by a space, like this: <b>individual&nbsp;family&nbsp;child</b>.  When more than one word is entered, the meaning of what you have typed is clarified in the #pgv_lang[hs_searchhow]# field.<br />";
##$pgv_lang["hs_searchin_advice"]		= "~#pgv_lang[hs_searchin]#~<br />You determine the scope of the search here.<br /><br />Administrators have the choice of searching User Help or Configuration Help or both.  Users do not have this choice; because they do not have access to any configuration features, they can only search the User Help file.<br /><br />The Help files contain not only Help text but also certain text strings used to build input forms and other material.  This option lets you control whether the entire Help file should be examined or whether only the Help text should be looked at.<br />";
##$pgv_lang["hs_searchhow_advice"]	= "~#pgv_lang[hs_searchhow]#~<br />You clarify the meaning of what you have entered into the #pgv_lang[hs_keyword]# field by selecting among the possibilities presented here.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>If you have entered <b>individual&nbsp;family&nbsp;child</b>, this option will find Help text that contains one of the words listed.  The order of the words doesn't matter.  The meaning of the search is: \"Find Help text containing <b>individual</b> <u>or</u> <b>family</b> <u>or</u> <b>child</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>If you have entered <b>individual&nbsp;family&nbsp;child</b>, this option will find Help text that contains all of the words listed.  The order of the words doesn't matter.  The meaning of the search is: \"Find Help text containing <b>individual</b> <u>and</u> <b>family</b> <u>and</u> <b>child</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>If you have entered <b>individual&nbsp;family&nbsp;child</b>, this option will find Help text that contains all of the words listed in the order given.  The meaning of the search is: \"Find Help text containing the words <b>individual&nbsp;family&nbsp;child</b> in exactly that order with no other words or characters between\".  You probably won't find this particular phrase in any Help text.<br /><br />There are a few limitations on this type of search.  Certain special characters such as <b>&quot; &lt; &gt;</b> etc. are contained within the Help text in symbolic form and won't be found if they form part of the text you enter.  Some Help text contains a special kind of Space character represented by <b>&amp;nbsp;</b> and you won't find phrases containing this character.</dd></dl>";

// Directory cleanup tool
##$pgv_lang["help_dir_editor.php"]	= "~#pgv_lang[index_dir_cleanup]#~<br /><br />This tool can help site administrators clean up files in the Index directory.<br /><br />Over time, files such as log files, old GEDCOM files, and old backup files can build up in the Index directory.  Since many of these files are created by the program, they may be owned by the web server user.  If they are owned by the web server user, you might not be able to delete them. This tool lets you delete these files even when they are owned by the web server user account.<br /><br />#pgv_lang[index_dir_cleanup_inst]#";
?>
