<?php
/**
 * Dutch Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2008  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Eduard Wustenveld
 * @author Erik Bent
 * @author Boudewijn Sjouke
 * @version $Id: help_text.nl.php 4194 2008-10-30 10:45:46Z fisharebest $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- GENERAL
$pgv_lang["help_header"]			= "Informatie over:";
$pgv_lang["privacy_error_help"]			= "<b>GEGEVENS ZIJN VERBORGEN</b><br /><br />Als deze boodschap verschijnt kan dit een aantal oorzaken hebben:<br /><br /><b>1. Informatie van levende personen is verborgen voor bezoekers.</b><br />Onder Bezoeker wordt iemand verstaan die op deze website niet is aangemeld met een gebruikersnaam.<br />Alle gegevens van nog levende personen zijn verborgen voor Bezoekers.<br />Gegevens van overleden personen zijn wel publiekelijk toegankelijk, en kunnen dus door een Bezoeker worden ingezien.<br />U kunt een gebruikersnaam als volgt aanvragen: klik op de koppeling \"Aanmelden\" boven aan het scherm en daarna op de koppeling #pgv_lang[requestaccount]#.<br /><br /><b>2. U beschikt over een gebruikersnaam en een wachtwoord......</b><br />Maar u heeft zich nog niet aangemeld, of bent voor langere tijd inactief geweest, waardoor u automatisch bent afgemeld.<br />Als u zich (opnieuw) aanmeldt dan is het probleem opgelost.<br /><br /><b>3. Gegevens van deze persoon zijn verborgen.</b><br />De persoon, wiens gegevens u wilde zien, heeft aan de beheerder gevraagd om de gegevens als privé aan te merken of geheel te verbergen.<br />In dat geval kunnen de gegevens alleen worden ingezien door gebruikers, die hiertoe voldoende rechten hebben.<br />Privacy kan worden ingesteld op::<br />a) #pgv_lang[PRIV_USER]#<br />b) #pgv_lang[PRIV_NONE]#<br />c) #pgv_lang[PRIV_HIDE]#<br /><br /><b>4. Gegevens buiten \"relatiepad\"</b><br />Ook als u beschikt over een gebruikersnaam <b>en</b> aangemeld bent, kan het voorkomen dat deze boodschap verschijnt.<br />De beheerder heeft dan in de instellingen aangegeven, dat het relatiepad beperkt is.<br />Hiermee wordt aangegeven, dat u alleen de gegevens van personen kunt zien, die een beperkt aantal stappen in de stamboom van u verwijderd zijn.<br />Als de lengte van het relatiepad de waarde \"1\" heeft, kunt u alleen de details zien van uw eigen familie: ouders, broers en zussen en kinderen (maar niet de partners en kinderen van uw broers en zussen).<br /><br />Bij een waarde \"2\" kunt u  ook de details zien van de vrouw van uw broer en van diens kinderen (maar niet van de partners van die kinderen).<br />Hoe hoger de waarde van het relatiepad is, hoe verder weg de personen van u af liggen, waarvan u de details kunt zien.<br /><br />Als u van mening bent, dat u van te weinig personen details kunt zien, neemt u dan contact op met de beheerder via de koppeling onder in het scherm.";
$pgv_lang["more_help"]				= "<br />Als u meer specifieke helpinformatie wilt hebben, zorg er dan voor dat de <b>#pgv_lang[show_context_help]#</b> (in het Help-menu) aan staat, en klik op een <b>?</b> bij een onderwerp.<br />";
$pgv_lang["more_config_help"]			= "<br /><b>Meer Help</b><br />Op deze pagina is meer helpinformatie beschikbaar. Klik daarvoor op de <b>?</b> achter de vakken en teksten.<br />";
$pgv_lang["start_admin_help"]			= "+++ Start extra informatie voor de beheerder +++";
$pgv_lang["end_admin_help"]			= "+++ Einde extra informatie voor de beheerder +++";
$pgv_lang["multiple_help"]			= "<center>--- Dit is een algemene helptekst voor meerdere pagina's ---</center>";
$pgv_lang["header_general_help"]		= "<div class=\"name_head\"><center><b>ALGEMENE INFORMATIE</b></center></div><br />";
$pgv_lang["best_display_help"]			= "~UW BEELDSCHERM~<br />PhpGedView is ontworpen voor een beeldschermresolutie van 1024x768.<br />Als u uw PC op minimaal deze waarde heeft ingesteld, wordt alles correct op het scherm getoond.<br />Als u de resolutie op een lagere waarde instelt, zoals 800x600, passen de pagina's niet meer geheel op uw beeldscherm en moet u de horizontale schuifbalk van uw Internet verkenner gebruiken.<br /><br />";
$pgv_lang["preview_help"]			= "~PRINTERVRIENDELIJKE VERSIE~<br />PhpGedView biedt u de mogelijkheid om de informatie op het scherm af te drukken op papier.<br />Op iedere pagina is onder aan een koppeling \"Printervriendelijke versie\" opgenomen. Als u daarop klikt, verandert de opmaak van de pagina, zodat menu's, invoervakken, vraagtekens voor helpinformatie, etc. van het scherm zijn verdwenen.<br />Onder aan deze af te drukken pagina is de koppeling \"Afdrukken\" zichtbaar. Klikt u daarop, dan krijgt u het menuvenster van uw printer te zien, waarmee u de afdruk kunt maken.<br />Als u in dat venster op \"Print\" of \"Afbreken\" heeft geklikt, komt u terug in PhpGedView. Onder aan de pagina is dan de koppeling \"Terug\" te zien, waarmee u terugkeert naar de normale weergave.<br /><br />Let op: Hoewel op de printervriendelijke versie de overbodige koppelingen zijn verdwenen werken andere koppelingen, zoals namen, nog wel.<br /><br /><br />";
$pgv_lang["readme_help"]			= "<center>Zie het bestand <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> voor meer informatie over dit onderwerp.</center>";
$pgv_lang["is_user_help"]			= "--- Deze helptekst is dezelfde als aan gebruikers en bezoekers wordt getoond. ---<br />--- Om ruimte te besparen, is geen aparte tekst voor beheerders beschikbaar. ---";
$pgv_lang["edit_raw_gedcom_help"]	= "~WIJZIG GEDCOM-GEGEVENS~<br /><br />Als u op deze koppeling klikt, worden in een nieuw venster de GEDCOM-regels weergegeven die de bron zijn voor de gegevens op deze pagina.<br />U kunt deze gegevens wijzigen. Let er echter wel op, dat u geldige GEDCOM 5.5 regels invoert. PhpGedView voert geen controle uit op de geldigheid ervan.<br />De gewijzigde en/of toegevoegde gegevens worden aan de PhpGedView bestanden toegevoegd als wijzigingen en moeten door een daarvoor geautoriseerde gebruiker worden geaccepteerd.";
$pgv_lang["RESN_help"]				= "~BEPERKING TOEGANG TOT FEITEN~<br /><br />Naast de normale privacy-instellingen, kunnen in PhpGedView eveneens beperkingen worden aangebracht op het tonen en wijzigen van feiten bij personen en gezinnen. De beperkingen kunnen worden aangebracht door iedereen die de informatie mag wijzigen, tenzij privacy-instellingen of eerder aangebrachte beperkingen dit verhinderen.<br />De volgende waarden kunnen worden toegekend:<br /><br /><b>#pgv_lang[none]#</b><br/>Site-beheerders, GEDCOM-beheerder en gebruikers met rechten om te wijzigen, kunnen de informatie wijzigen. De informatie is zichtbaar voor zover de door de beheerder ingestelde privacy-instellingen dit toelaten.<br /><br /><b>#pgv_lang[confidential]#</b><br />Alleen Site-beheerders en GEDCOM-beheerders kunnen de informatie zien en wijzigen. Het is verborgen voor alle andere (al dan niet aangemelde) gebruikers.<br /><br /><b>#pgv_lang[private]#</b><br />Site-beheerders en GEDCOM-beheerders kunnen de informatie zien en wijzigen. Als de informatie betrekking heeft op de gebruiker zelf, kan hij deze zien en, aangenomen dat hij wijzig-rechten heeft, ook aanpassen. De informatie blijft verborgen voor alle andere (al dan niet aangemelde) gebruikers.<br /><br /><b>#pgv_lang[locked]#</b><br />Deze instelling heeft geen effect op de zichtbaarheid van de informatie, maar beperkt wijzig-rechten tot Site- en GEDCOM-beheerders. Als de informatie betrekking heeft op de gebruiker zelf, kan hij deze zien en, aangenomen dat hij wijzig-rechten heeft, ook aanpassen.<br /><br />";

//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]				= "~DE WELKOMSTPAGINA~<br /><br />Deze pagina is de startpagina van de geselecteerde genealogie. U kunt hier altijd terugkeren, door te klikken op de knop \"Welkomstpagina\" in de menubalk.<br />Als er op deze site meerdere genealogieën beschikbaar zijn, kunt u er een uit het submenu van de knop \"Welkomstpagina\" kiezen.<br /><br />In deze HELP-informatie treft u, naast een toelichting op deze pagina, ook algemene informatie aan over deze website en het gebruik ervan.<br />Aan de orde komen:)<ul><li><a href=\"#index_portal\">#pgv_lang[welcome_page]#</a><li><a href=\"#header\">Menubalk</a><li><a href=\"#menu\">Menu's</a><li><a href=\"#header_general\">Algemene informatie</a><li><a href=\"#def\">Definities</a></ul><br />Op alle andere pagina's is de help (<b>Help bij deze pagina</b> in het Help-menu) beperkt tot informatie over de desbetreffende pagina.<br /><br />";

//-- Index-page Header 
$pgv_lang["header_help"]			= "<div class=\"name_head\"><center><b>DE MENUBALK</b></center></div><br /><br />De menubalk wordt gebruikt om de functies van PhpGedView te benaderen. Afhankelijk van het gekozen website-thema is de menubalk altijd aan de bovenzijde of linkerzijde van het scherm te zien, en kan de knopindeling afwijken van de standaard indeling.<br /><br />In de menubalk vindt u de volgende knoppen/functies:<ul><li><a href=\"#header_search\">#pgv_lang[search]#</a><li><a href=\"#header_lang_select\">#pgv_lang[change_lang]#</a><li><a href=\"#header_user_links\">Gebruikerskoppelingen</a><li><a href=\"#header_favorites\">#pgv_lang[my_favorites]#</a></ul>";
$pgv_lang["header_lang_select_help"]		= "~MENUBALK: WIJZIG TAAL~<br />een van de eigenschappen van PhpGedView is, dat het zich automatisch aanpast aan de taal van de Internet Verkenner van de gebruiker.<br />Wanneer de taal niet door PhpGedView wordt ondersteund, of de gebruiker wil een andere taal selecteren, dan kan dit door de taal in de keuzelijst te selecteren, of, afhankelijk van het weergaventhema, op de vlag van het desbetreffende land te klikken.<br /><br />";
$pgv_lang["header_user_links_help"]		= "~MENUBALK: GEBRUIKERSKOPPELINGEN~<br />Dit groepje koppelingen is steeds op dezelfde plaats te vinden.<br />Als u zich nog niet heeft aangemeld, is alleen de koppeling \"Aanmelden\" zichtbaar.<br />Als u zich heeft aangemeld, ziet u de koppeling \"Aangemeld als ......\". Klikt u daarop, dan kunt u uw gebruikersgegevens wijzigen.<br />Met de koppeling \"Afmelden\" meldt u zich af bij de site.<br />Wanneer u over beheerderrechten beschikt, is ook de koppeling \"Beheren\" zichtbaar. Hiermee gaat u rechtstreeks naar het Menu Beheer.<br /><br />";
$pgv_lang["header_favorites_help"]		= "~MENUBALK: MIJN FAVORIETEN~<br />In deze keuzelijst zijn de personen zichtbaar, die u als favorieten heeft geselecteerd.<br />Zodra u uit deze keuzelijst een van de aanwezige favorieten kiest, krijgt u de details van deze persoon te zien.<br /><br />U kunt favorieten toevoegen op uw persoonlijke MyGedView pagina of, op de pagina \"Detailgegevens persoon\", door in de keuzelijst \"Mijn Favorieten\" te kiezen voor \"Toevoegen aan mijn favorieten\".<br /><br />Meer helpinformatie over Favorieten is beschikbaar op uw persoonlijke MyGedView pagina.<br /><br />";
$pgv_lang["header_theme_help"]		= "~MENUBALK: WIJZIG OPMAAK~<br />Als de site-beheerder dit heeft toegestaan, kunt u de opmaak van deze website wijzigen. Vorm en opmaak van deze site zijn vastgelegd in zogenaamde thema's.<br />In de keuzelijst \"Wijzig site-opmaak\" kunt u een nieuw thema selecteren. Als u bent aangemeld als gebruiker, dan wordt bij uw gegevens het gekozen thema vastgelegd.<br /> ";
$pgv_lang["header_search_help"]			= "~MENUBALK: ZOEKEN~<br />Met deze functie kunt u bijna op alles in de genealogie zoeken. Ook is een functie opgenomen om namen te zoeken, waarvan u de schrijfwijze niet precies weet.<br />Als u op de \">\" klikt, komt u op de Zoekpagina terecht, waar u verdere hulp kunt krijgen.<br /><br />";

//-- Index-page Menu
$pgv_lang["menu_help"]				= "<div class=\"name_head\"><center><b>MENU'S</b></center></div><br />In de menubalk bevinden zich, onder de menuknoppen, submenu's. Als u met uw muisaanwijzer over de menuknoppen gaat, krijgt u het submenu te zien.<br />Als u op een menuknop klikt, kiest u automatisch de eerste menukeuze van het submenu.<br />U vindt u in de menubalk de volgende menu's en koppelingen:</b><ul><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">Mygedview Portal</a><br /><li><a href=\"#menu_charts\">Charts</a><br /><li><a href=\"#menu_lists\">Lists</a><br /><li><a href=\"#menu_annical\">Anniversary Calendar</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">Search</a><br /><li><a href=\"#menu_help\">Help</a></ul><br />";
$pgv_lang["menu_famtree_help"]			= "~MENU \"WELKOMSTPAGINA\"~<br />Het programma is in staat om meerdere genealogieën te bevatten. Met behulp van dit menu kiest u een genealogie, die u wilt raadplegen of wijzigen.<br />u komt dan terecht op de welkomstpagina van de desbetreffende genealogie.<br /><br />Als er slechts een genealogie in PhpGedView is opgenomen, wordt het submenu niet getoond.<br /><br />";
$pgv_lang["menu_myged_help"]			= "~MENU \"MYGEDVIEW\"~<br />In dit menu vindt u, als u bent aangemeld als gebruiker, alle aan u gerelateerde onderwerpen terug. U kunt naar uw persoonlijke MyGedView pagina toegaan, uw gebruikersgegevens aanpassen, of direct naar uw kwartierstaat of detailgegevens toegaan.<br />Als u beschikt over beheerderrechten, kunt u naar het hoofdmenu Beheer of naar het menu \"Beheer GEDCOM-bestanden en privacy-instellingen\".<br /><br /><br />";
$pgv_lang["menu_charts_help"]			= "~MENU \"OVERZICHTEN\"~<br />In dit menu zijn de volgende overzichten beschikbaar:<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>In dit overzicht worden de voorouders van de startpersoon van de kwartierstaat getoond. Als u bent aangemeld als gebruiker, kunt u de startpersoon zelf instellen, of bent u in sommige gevallen de startpersoon zelf al.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Dit overzicht toont de nakomelingen van de startpersoon. Voor de startpersoon geldt hier hetzelfde als bij het item <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Met deze functie kunt u een of meer personen aan een tijdlijn toevoegen, waarna de gebeurtenissen van deze personen op een tijdlijn worden getoond..</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Hiermee kunt u de verwantschap tussen een persoon en uzelf, of een ander persoon, vaststellen.</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Deze lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont meer details en kan bekeken worden in een verschillende <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Deze lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont de gegevens in een meer grafische vorm.</dd></dl>";
$pgv_lang["menu_lists_help"]			= "~MENU \"DETAILGEGEVENS\"~<br />De volgende soorten detailgegevens zijn beschikbaar in dit menu:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dd>Vanuit een selectie-overzicht kunt u de gewenste persoon selecteren.</dd><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>Vanuit een selectie-overzicht kunt u de gewenste persoon respectievelijk het gewenste gezin selecteren.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Dit geeft een lijst van alle gebruikte bronnen in deze genealogie.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Hier kunt u personen en gezinnen zoeken, waarvan een gebeurtenis is gekoppeld aan een bepaalde plaats. De getoonde lijst is gesplitst in links de personen en rechts de gezinnen.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Deze optie ziet u alleen als dit door de beheerder is ingeschakeld.<br />Getoond worden alle koppelingen naar multimedia-items in deze genealogie.</dd></dl>";
$pgv_lang["menu_annical_help"]			= "~MENU \"GEBEURTENISKALENDER\"~<br />Met deze functie kunt u zien, welke gebeurtenissen er op een bepaalde dag of in een bepaalde maand of jaar in het verleden hebben plaatsgevonden..<dl><dt><a href=\"?help=day_month_help\">#pgv_lang[viewday]#</a></dt><dd>Deze optie geeft een overzicht van alle gebeurtenissen die op de huidige dag in een jaar hebben plaatsgevonden.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewmonth]#</a></dt><dd>Hiermee wordt de maandkalender getoond, met alle gebeurtenissen uit het verleden, in de huidige maand.</dd><dt><a href=\"?help=day_month_help\">#pgv_lang[viewyear]#</a></dt><dd>Deze brengt u naar de jaarkalender, waarop alle gebeurtenissen uit het huidige jaar worden getoond.</dd></dl>";
$pgv_lang["menu_clip_help"]			= "~MENU \"STAMBOOMKNIPSELS\"~<br />Als deze optie zichtbaar is in de menubalk, is deze door de sitebeheerder ingeschakeld.<br />Met de knipselbak kunt u stukjes uit de genealogie verzamelen in uw knipselbak en ze daarna, in GEDCOM 5.5 formaat, naar uw eigen computer downloaden.<br />Daar kunt u ze verder importeren in uw eigen genealogieprogramma.<br /><br />";
$pgv_lang["menu_search_help"]			= "~MENU \"ZOEKEN\"~<br />Dit menu heeft geen keuzes, maar brengt u meteen naar de zoekpagina van PhpGedView. Dit is dezelfde pagina, als die vanuit het \"Zoeken\"-veld elders op de pagina wordt gebruikt.<br /><br />";
$pgv_lang["menu_help_help"]			= "~MENU \"HELP\"~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]		= "<div class=\"name_head\"><center><b>WELKOMSTPAGINA</b></center></div><br />";
$pgv_lang["index_portal_help"]			= "Deze Welkomstpagina geeft informatie over de gekozen genealogie en bestaat, net als de persoonlijke MyGedView-pagina, uit verschillende vakken. Per genealogie is er een aparte Welkomstpagina, die door de beheerder wordt vervaardigd.<br /><br />De volgende vakken kunnen zichtbaar zijn:<ul><li><a href=\"#index_welcome\">#pgv_lang[welcome]#</a><li><a href=\"#index_login\">#pgv_lang[login]#</a><li><a href=\"#index_events\">#pgv_lang[upcoming_events]#</a><li><a href=\"#index_onthisday\">#pgv_lang[on_this_day]#</a><li><a href=\"#index_favorites\">#pgv_lang[gedcom_favorites]#</a><li><a href=\"#index_stats\">#pgv_lang[gedcom_stats]#</a><li><a href=\"#index_media\">#pgv_lang[random_picture]#</a><li><a href=\"#index_loggedin\">#pgv_lang[users_logged_in]#</a><li><a href=\"#recent_changes\">#pgv_lang[recent_changes]#</a></ul>";
$pgv_lang["index_welcome_help"]			= "~WELKOM ......~<br />In dit vak treft u het volgende aan:<br />- De omschrijving van de actieve genealogie<br />- De datum en tijd<br />- Een bezoekteller, die het aantal bezoeken aan deze pagina weergeeft<br />- Een koppeling voor het wijzigen van de infopagina, indien u beschikt over beheerderrechten.<br /><br />";
$pgv_lang["index_login_help"]			= "~AANMELDEN~<br />In het vak \"Aanmelden\" kunt u zich vanaf deze pagina direct aanmelden met uw gebruikersnaam en wachtwoord. Indien u nog niet over een gebruikersnaam en wachtwoord beschikt, kunt u eveneens op \"Aanmelden\" klikken. U komt dan terecht op de pagina Aanmelden, waar u met de koppeling onder aan die pagina een gebruikersnaam kunt aanvragen.<br /><br /><br />#pgv_lang[new_password_help]#<br />";
$pgv_lang["index_events_help"]			= "~BINNENKORT....~<br />Dit vak toont een lijst met gebeurtenissen, die op deze dag en tot 30 dagen daarna in het verleden hebben plaatsgevonden.<br /><br />";
$pgv_lang["index_onthisday_help"]		= "~OP DEZE DAG, IN HET VERLEDEN....~<br />Dit vak toont een lijst met gebeurtenissen, die op deze dag in het verleden hebben plaatsgevonden. De gebeurtenissen hebben betrekking op personen uit de actieve genealogie.<br />Op de Welkomstpagina worden alle gebeurtenissen getoond, op de MyGedView pagina zijn ze beperkt tot die van levende personen.<br /><br />";
$pgv_lang["index_favorites_help"]		= "~FAVORIETEN IN DEZE GENEALOGIE~<br />In het vak \"Favorieten in deze genealogie\" kan de site-beheerder personen uit de genealogie plaatsen, zodat gebruikers deze makkelijk kunnen vinden.<br />Door op de namen van de personen te klikken, kunt u direct de details van de persoon inzien. Met behulp van de twee miniaturen rechts in het vak kunt u op deze plaats al wat meer gegevens zien, of naar een andere functie toe gaan.<br /><br />Zowel deze favorieten als uw eigen favorieten (zie de informatie op uw persoonlijke MyGedView pagina) zijn altijd beschikbaar in het keuzemenu boven aan het scherm.<br /><br />";
$pgv_lang["index_stats_help"]			= "~STATISTIEKEN VAN DEZE GENEALOGIE~<br />Het vak \"Statistieken van deze genealogie\" toont enkele gegevens over het dit bestand, zoals het aantal erin aanwezige personen en de datum waarop het is aangemaakt.<br />Voor meer informatie kunt u contact opnemen met de contactpersoon van deze genealogie (zie onder aan deze pagina).<br /><br />";
$pgv_lang["index_common_names_help"]		= "~MEEST VOORKOMENDE ACHTERNAMEN~<br />Hier worden de achternamen getoond, die het meest in deze genealogie voorkomen.<br />Het aantal malen dat een naam moet voorkomen, is ingesteld door de beheerder en bedraagt #COMMON_NAMES_THRESHOLD#. Ook kan de beheerder handmatig namen hebben toegevoegd of verwijderd.<br />De namen worden in alfabetische volgorde getoond.<br />Als u op een achternaam klikt, gaat u naar de #pgv_lang[individual_list]#, waar u meer informatie over de desbetreffende personen kunt zien.<br /><br />";
$pgv_lang["index_media_help"]			= "~WILLEKEURIGE AFBEELDING~<br />In dit blok wordt, telkens wanneer u deze pagina bezoekt, een willekeurig multimedia-item (foto, afbeelding van een document) weergegeven.<br />Door op de afbeelding te klikken krijgt u een vergrote weergave te zien.<br />Als u op de tekst onder de afbeelding klikt, kunt u direct naar de detailgegevens daarvan springen.<br /><br />";
$pgv_lang["index_loggedin_help"]		= "~AANGEMELDE GEBRUIKERS~<br />Dit vak toont een lijst met gebruikers die op dat moment zijn aangemeld.<br /><br />";
$pgv_lang["index_gedcom_news_help"]		= "~GENEALOGIE PRIKBORD~<br />Dit vak is het prikbord van deze genealogie. De beheerder kan daarop belangrijke mededelingen, weetjes en koppelingen naar andere websites plaatsen.<br /><br />Als u zelf een bericht wilt plaatsen, kunt u hiervoor contact opnemen met de beheerder.";
$pgv_lang["index_gedcom_news_adm_help"]		= "Op dit Genealogie prikbord kunt u gebruik maken van <b>HTML tags</b>. Let er goed op dat u zowel de start- als de end-tags gebruikt.<br />ook kunt u gebruik maken van de stylesheets (CSS) van PhpGedView. Ieder thema heeft zijn eigen stylesheet, waarvan u de classes kunt gebruiken.<br />Op de website van PhpGedView kunt u voorbeelden vinden van het gebruik van tags op uw eigen prikbord.<br />";
$pgv_lang["recent_changes_help"]			= "~RECENTE WIJZIGINGEN~<br />In dit vak worden de recente wijzigingen in deze genealogie getoond. Hiervoor wordt de datum van laatste wijziging in de persoons- en gezinsinformatie gebruikt.";

//-- Index-Page Help
$pgv_lang["help_help"]				= "De bouwers van PhpGedView besteden veel aandacht aan de begrijpelijkheid en het bedieningsgemak van het programma.<br />Het uitgangspunt is, dat iedere gebruiker zonder voorkennis in staat moet zijn, zijn weg in PhpGedView te vinden.<br />Helaas lukt dat niet altijd, soms zijn bewerkingen nu eenmaal niet op een eenvoudiger manier uit te voeren.<br />Ook omdat veel gebruikers nauwelijks bekend zijn met Internet en computers, is aan PhpGedView een grote hoeveelheid helpinformatie toegevoegd.<br />Mocht u desondanks nog vragen hebben, dan kunt u zich altijd tot de beheerder van de site wenden. Deze zal u graag van dienst zijn.<br /><br />Op dit moment zijn verschillende soorten helpinformatie voorhanden:<br />";
$pgv_lang["help_page_help"]			= "<i>Help per pagina</i><br />Op iedere pagina is algemene helpinformatie beschikbaar.<br />U krijgt deze in een apart venster te zien, als u op \"Help\" klikt in de menubalk. of in het keuzemenu Help kiest voor \"Help bij deze pagina\".<br /><br />Daarnaast is in veel gevallen detailinformatie voorhanden, die u door middel van de contextuele help kunt opvragen.<br />Hiervoor kunt u op de diverse vraagtekens op de pagina klikken.<br />Zijn deze niet zichtbaar, dan staat waarschijnlijk de contextuele help uitgeschakeld. U kunt deze activeren door in het helpmenu te kiezen voor \"Toon contextuele help\".<br />";
$pgv_lang["help_content_help"]			= "<i>Inhoudsopgave</i><br />Als u hierop klikt, verschijnt een nieuw venster met daarin de belangrijkste helponderwerpen.<br />";
$pgv_lang["help_qm_help"]			= "<i>Toon/verberg contextuele help</i><br />Deze optie zorgt ervoor, dat aan de rechterkant van de meeste koppelingen, keuzemenu's, vakken en invoervelden, een vraagteken zichtbaar wordt. Als u op het \"?\" klikt, krijgt u een extra venster met specifieke informatie over die optie of functie.<br /><br />U kunt deze optie in- en uitschakelen door op deze menuoptie te klikken.<br />";

//-- Index-page Definitions
$pgv_lang["def_help"]				= "<div class=\"name_head\"><center><b>BEGRIPPENLIJST</b></center></div><br /><br />Hier volgt een beschrijving van enkele begrippen, die op deze website worden gebruikt:<ul><li><a href=\"#def_gedcom\">GEDCOM-bestand</a><br /><li><a href=\"#def_gedcom_date\">Datumgebruik</a><li><a href=\"#def_pgv\">#pgv_lang[inc_phpgedview]#</a><li><a href=\"#def_portal\">Portaal</a><li><a href=\"#def_theme\">Thema's</a></ul>";
$pgv_lang["def_portal_help"]			= "~PORTAAL~<br />Op een website is het portaal het centrale toegangspunt tot de website. Hier treft u in het algemeen de menu's aan voor toegang tot de informatie op de site, maar ook zaken als een prikbord, algemene mededelingen, etc.<br />";
$pgv_lang["def_gedcom_help"]			= "~GEDCOM-BESTAND~<br />Een GEDCOM-bestand is een bestand, dat genealogische informatie bevat. Deze informatie wordt in het bestand opgeslagen volgens het GEDCOM-formaat. Dit is een algemeen aanvaarde standaard voor het uitwisselen van genealogische informatie en stelt de gebruikers in staat om informatie tussen genealogiepakketten uit te wisselen.<br />Een citaat uit de inleiding van de GEDCOM 5.5 standaard:<div class=\"list_value_wrap\">De GEDCOM-standaard is ontwikkeld door de kerk van Jezus Christus, Heilige der laatste dagen, om een flexibel en uniform formaat vast te stellen om elektronisch vastgelegde genealogische gegevens uit te wisselen.&nbsp; GEDCOM is een acroniem voor <i><b>GE</b></i>nealogical <i><b>D</b></i>atabase <i><b>C</b></i>ommunication.&nbsp; Het doel is om het delen van genealogische informatie te ondersteunen en daarmee de ontwikkeling van een groot aantal softwareproducten voor genealogen, historici en andere onderzoekers.</div><br />Een exemplaar van de GEDCOM 5.5.1 standaard, waarop PhpGedView is gebaseerd, kunt u in PDF-formaat downloaden van: :&nbsp; <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank>GEDCOM 5.5.1 Standard</a><br /><br />Een GEDCOM-bestand bevat alle informatie over personen en gezinnen, zoals feiten, data, gebeurtenissen, etc. Aan de vastlegging van de informatie worden regels gesteld, waardoor de uitwisselbaarheid van de informatie tussen systemen wordt bevorderd.<br />";
$pgv_lang["def_gedcom_date_help"]		= "~DATUMS IN EEN GEDCOM-BESTAND~<br />Hoewel in datumvelden van een GEDCOM-bestand in principe iedere tekst kan worden opgeslagen, geeft de GEDCOM-standaard toch een aantal voorschriften voor het vastleggen van datums en tijdsperiodes.<br />Dit zorgt ervoor, dat ook datuminformatie uitwisselbaar blijft, doordat het steeds op een eenduidige wijze wordt vastgelegd.<br />Hier volgt een aantal voorbeelden van uniform datumgebruik:<br />Een volledige datum wordt genoteerd als 'dd Mmm yyyy', waar Mmm staat voor de Engelse drieletterige afkorting van de maand. Dus: 01 May 2004 en 31 Mar 1800.<br />Soms is maar een deel van de datum bekend en kan worden volstaan met Mar 1800 of alleen 1800.<br />Ook kan bij een datum iets worden aangegeven over de mate van zekerheid. Er worden dan de voorvoegsels 'ABT' (ongeveer), 'EST' (geschat aan de hand van andere gebeurtenissen) en 'CAL' (berekend aan de hand van  bijvoorbeeld iemands leeftijd).<br />Een tijdperiode wordt aangegeven door de voorvoegsels 'BEF' (voor) en 'AFT' (na).<br />Let erop dat u de maanden in de datum en de voorvoegsels in het Engels gebruikt. Wijkt u hiervan af, dan zullen genealogieprogramma's niet in staat zijn om de datum als zodanig te herkennen en ermee te rekenen.<br />";
$pgv_lang["def_pgv_help"]			= "~PHPGEDVIEW~<br />PhpGedView (afgekort PGV) is een programma, ontworpen door John Finlay, waarmee genealogische bestanden via webpagina's kunnen worden bekeken.<br />Op den duur moet het groeien naar een platform, waarop verschillende gebruikers met elkaar samenwerken om te werken aan een genealogie.<br />PhpGedView is uitgegroeid tot een product, dat op vele manieren is in te stellen, zodanig, dat het in een specifieke behoefte voorziet.<br />Inmiddels werkt een uitgebreid internationaal team aan de verdere ontwikkeling van PhpGedView.<br />";
$pgv_lang["def_theme_help"]			= "~THEMA'S~<br />Deze site kan veranderen van uiterlijk. Hoe de site er in een uiterlijk uitziet, wordt vastgelegd in een \"thema\". De beheerder bepaalt in principe het thema dat wordt toegepast, maar kan ook aangeven dat de aangemelde gebruikers dit zelf kunnen wijzigen.<br />U kunt dan zelf uitproberen welk thema het beste bevalt.<br />Het gekozen thema wordt actief zodra u zich als gebruiker heeft aangemeld.<br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]		= "~#pgv_lang[upper_mygedview]#~<br />Dit is uw persoonlijke MyGedView-pagina.<br />Op deze pagina treft u een aantal vakken aan met informatie uit de stamboom, uw berichten, uw favorieten en koppelingen naar uw eigen gegevens. U kunt zelf bepalen hoe u deze pagina indeelt en welke vakken erop zichtbaar zijn. Om de indeling te wijzigen kunt u klikken op de koppeling \"MyGedView indelen\" in het vak \"Welkom .....\".<br /><br />De volgende vakken zijn beschikbaar:<ul><li><a  href=\"#mygedview_welcome\">Welkom</a><li><a href=\"#mygedview_customize\">#pgv_lang[customize_page]#</a><li><a href=\"#mygedview_message\">#pgv_lang[my_messages]#</a><li><a href=\"#mygedview_events\">#pgv_lang[upcoming_events]#</a><li><a href=\"#mygedview_onthisday\">#pgv_lang[on_this_day]#</a><li><a href=\"#mygedview_favorites\">#pgv_lang[my_favorites]#</a><li><a href=\"#mygedview_stats\">#pgv_lang[gedcom_stats]#</a><li><a href=\"#mygedview_myjournal\">#pgv_lang[my_journal]#</a><li><a href=\"#mygedview_media\">#pgv_lang[random_picture]#</a><li><a href=\"#mygedview_loggedin\">#pgv_lang[users_logged_in]#</a></ul>";
$pgv_lang["mygedview_customize_help"]		= "~DE FUNCTIE \"#pgv_lang[upper_mygedview]# INDELEN\"~<br />U heeft de mogelijkheid, om deze pagina naar eigen believen in de delen. U kunt vakken verwijderen en toevoegen, en bepalen waar deze op het scherm komen te staan.<br />Door op de koppeling \"MyGedView indelen\" te klikken, in het \"Welkom.....\" vak, wordt een venster geopend waarmee u de veranderingen kunt aanbrengen.<br />Ook treft u daar meer hulp over deze functie aan.<br /><br />";
$pgv_lang["mygedview_message_help"]		= "~MIJN BERICHTEN~<br />In dit vak vindt u de berichten, die u door de sitebeheerder of door andere gebruikers zijn toegestuurd.<br />U kunt ook zelf aan andere gebruikers een bericht sturen. Selecteer daarvoor de geadresseerde en klik op \"Verzenden\". In het nieuwe venster kunt u uw bericht intikken en verzenden.<br /><br />Om in de lijst een bericht volledig weer te geven, kunt u op het onderwerp klikken of op de \"+\" ernaast. U kunt meerdere berichten tegelijk verwijderen door ze aan te vinken in de vakjes ernaast en te klikken op \"Verwijder geselecteerde berichten.<br />";
$pgv_lang["mygedview_favorites_help"]		= "~MIJN FAVORIETEN~<br />Aan dit lijstje kunt u zelf personen toevoegen, waarvan u de gegevens regelmatig wilt zien.<br />U kunt ze op deze plaats toevoegen, maar ook elders in het programma heeft u die mogelijkheid. U kunt vanuit het lijstje met favorieten in de menubalk kiezen voor \"- Toevoegen aan mijn favorieten -\", tenminste, als u op een pagina staat waar dit relevant is.<br />In dit keuzemenu in de menubalk zijn eveneens de reeds gekozen favorieten zichtbaar. Als u daar een persoon kiest, of hier vanuit het vak op de naam van de persoon klikt, gaat u direct naar de details van die persoon toe.<br /> Met behulp van het vergrootglas kunt u op deze plaats al wat meer details zien. Ook kunt u direct naar de overzichten gaan vanuit het menuutje aan de rechterkant van het vak.<br /><br />";
$pgv_lang["mygedview_myjournal_help"]		= "~MIJN NOTITIEBLOK~<br />Voor uw eigen gebruik kunt u notities maken op uw notitieblok. Als u een volgende keer de site bezoekt, kunt u de notities weer bekijken, aanpassen of verwijderen.<br /><br />De notities zijn alleen voor u zelf zichtbaar.<br /><br />";
$pgv_lang["mygedview_welcome_help"]		= "<dl>~WELKOM ......~<dt>In dit vak treft u het volgende aan:</dt><dd>- De omschrijving van de actieve genealogie</dd><dd>- De datum en tijd</dd><dd>- De volgende koppelingen</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd> - - #pgv_lang[my_pedigree]#</dd><dd> - - #pgv_lang[my_indi]#</dd><dd> - - #pgv_lang[customize_page]#</dd></dl><b>Opmerking:</b><br /> de koppelingen naar #pgv_lang[my_pedigree]# en #pgv_lang[my_indi]# worden alleen weergegeven, als u in de genealogie voorkomt.<br /><br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]			= "~DE KWARTIERSTAAT~<br /><br />De Kwartierstaat Pagina is de eerste pagina van dit programma.<br /><br /><i>MEER HELP</i><br />Aan de rechterkant van sommige velden en koppelingen is een vraagteken zichtbaar. Als u hierop klikt, verschijnt een schermpje met mee informatie over het desbetreffende onderwerp.<br /><br /><i>AANMELDEN</i><br />Hoewel men zich op elke pagina kunt aanmelden, doet men dit meestal toch op de eerste pagina, omdat men pas dan over alle toegestane informatie kan beschikken.<br />U meldt u aan, door op de betreffende koppeling aan de bovenzijde van de pagina te klikken.<br />Bezoekers die een gebruikersnaam en wachtwoord willen aanvragen, klikken ook op de koppeling \"Aanmelden\"<br /><br /><i>DE KWARTIERSTAAT</i><br />De meeste bezoekers en gebruikers zullen weten wat een kwartierstaat is, maar toch nog een, bescheiden uitleg van deze Kwartierstaat:<br />Een kwartierstaat is in feite een opsomming van alle voorouders van de startpersoon, de \"probant\". Deze wordt als eerste weergegeven, dan diens ouders, de grootouders, de overgrootouders, enzovoort. De probant is generatie I, diens ouders generatie II, enz.<br /><br /><i>PERSOONSVAKKEN IN DE KWARTIERSTAAT</i><br />Per persoon wordt een aantal gegevens getoond, zoals namen, geboorte- en overlijdensdatum en -plaats. Door op de persoonsnaam te klikken, komt u op het detailscherm van de persoon. Tevens zijn twee speciale knoppen zichtbaar (mits de optie \"Toon details\" aan staat):<br /><br /><i>KNOP \"KWARTIERSTAAT\" IN PERSOONSVAK</i><br />Afhankelijk van de instelling van de website, kunt u deze knop activeren door erop te klikken of er met de muis overheen te gaan. Er verschijnt dan een schermpje, waarin u kunt klikken op: de kwartierstaat van deze persoon, zijn/haar afstammelingen, zijn/haar gezin en de persoonsschermen van eega en kinderen.<br /><br /><i>VERGROOTGLAS IN PERSOONSVAK</i><br />Afhankelijk van de instelling van de website, kunt u deze knop activeren door erop te klikken of er met de muis overheen te gaan. Er verschijnt dan een schermpje, waarin extra informatie over de persoon wordt gegeven. Dit betreft onder andere de voorhanden zijnde feiten zoals beroepen, verhuizingen, enz.<br /><br /><i>DE PIJLEN LINKS EN RECHTS VAN DE VAKKEN</i><br />Door op de pijlen (links van het meest linkse vak en rechts van het meest rechtse vak) te klikken, kunt u het scherm \"verschuiven\", naar links naar de kinderen van de probant, naar rechts naar een generatie verder terug.<br /><br />";
$pgv_lang["show_full_help"]			= "~LAAT DETAILS ZIEN of VERBERG DETAILS~<br /><br />Met deze optie kunt u alle details in de naamvakken laten zien, of de details juist verbergen.<br />Als de details zijn verborgen, kunt u wat meer naamvakken op het scherm laten tonen.<br />Details kunt u, ook als deze in de vakken niet zichtbaar zijn, altijd bekijken door op het vergrootglas in de box te klikken (of er met de muisaanwijzer overheen te gaan, afhankelijk van de instelling van de website).";
$pgv_lang["talloffset_help"]			= "~SCHERM ORIËNTATIE~<br /><br />Met deze optie bepaalt u de oriëntatie van het scherm: staand of liggend.<br /> Het veranderen van deze instelling kan handig zijn als u een ander schermtype heeft, of in sommige gevallen kunt u dit wijzigen als het beter uitkomt op een schermafdruk.<br />Staand maakt het overzicht smaller, zodat 4 generaties op een pagina passen. Liggend maakt de afbeelding breder zodat de afdruk beter past op een liggende pagina.";
$pgv_lang["rootid_help"]			= "~STARTPERSOON KWARTIERSTAAT~<br /><br />Als u de kwartierstaat wilt beginnen met een andere startpersoon, vul dan in het vakje het ID van de nieuwe persoon in.<br /> Als u het ID van de persoon niet weet, gebruik dan de koppeling \"Zoek ID\". Aan de hand van (een deel van) de naam kunt u dan de persoon opzoeken en selecteren.";
$pgv_lang["PEDIGREE_GENERATIONS_help"]		= "~AANTAL GENERATIES PER SCHERM~<br /><br />Hier kunt u instellen hoeveel generaties op het scherm worden getoond.<br />Wat juist is voor u is afhankelijk van de afmetingen van uw scherm en of u de details van de naamvakken wel of niet laat zien.";

//-- LOGIN-page
$pgv_lang["login_page_help"]			= "~DE PAGINA \"AANMELDEN\"~<br /><br />Op deze pagina kunt u zich aanmelden als bestaande gebruiker, een nieuwe gebruikersnaam aanvragen of, als u uw wachtwoord hebt vergeten, deze opnieuw aanvragen.<br />";
$pgv_lang["username_help"]			= "~GEBRUIKERSNAAM~<br /><br />In dit veld vult u uw gebruikersnaam in. De gebruikersnaam is hoofdlettergevoelig.<br /><br />Als u nog niet beschikt over een gebruikersnaam, kunt u die aanvragen door te klikken op de onderstaande koppeling \"Vraag gebruikersnaam aan\".";
$pgv_lang["password_help"]			= "~WACHTWOORD~<br /><br />In dit veld vult u uw wachtwoord in.<br />het wachtwoord is hoofdlettergevoelig.<br /><br />Als u uw wachtwoord kwijt bent, kunt u klikken op de koppeling \"Vraag nieuw wachtwoord aan\".";
$pgv_lang["login_buttons_help"]			= "~TOEGANGSKNOPPEN~<br /><br />Hier ziet u twee knoppen om toegang te krijgen tot het systeem.<br />Afhankelijk van de gekozen knop gaat u naar:<br /><br />* De <b> #pgv_lang[login]# </b> knop<br />Hier zijn twee mogelijkheden:<br /><br />Als u op \"#pgv_lang[login]#\" klikte,vanaf een ander scherm in PhpGedView, keert u na het aanmelden terug naar waar u oorspronkelijk vandaan kwam.<br />Als u dus op deze knop klikte vanaf de kwartierstaat-pagina, keert u daar weer naar terug.<br /><br />Als dit het eerste scherm is, dat u in PhpGedView te zien krijgt, wordt u aangemeld en gaat u direct naar uw persoonlijke MyGedView pagina. Hier kunt u uw eigen instellingen en favorieten aanpassen, e-mails ontvangen en versturen, enz.<br /><br />* De <b>#pgv_lang[admin]#</b> knop<br />Als u over beheerderrechten beschikt, kunt u deze knop gebruiken om direct naar de beheerpagina te gaan.";
$pgv_lang["login_buttons_aut_help"]		= "~TOEGANGSKNOPPEN~<br /><br />Hier ziet u twee knoppen om toegang te krijgen tot het systeem, nadat u uw gebruikersnaam en wachtwoord heeft ingetypt.<br />Afhankelijk van de gekozen knop gaat u naar:<br /><br />* De <b>#pgv_lang[login]#</b> knop <br />Als u op deze linker knop klikt, wordt u aangemeld en gaat u direct naar uw persoonlijke MyGedView pagina. Hier kunt u uw eigen instellingen en favorieten aanpassen, e-mails ontvangen en versturen, enz.<br /><br />* De <b>#pgv_lang[admin]#</b> knop<br />Als u over beheerderrechten beschikt, kunt u deze knop gebruiken om direct naar de beheerpagina te gaan.";
$pgv_lang["new_password_help"]			= "~NIEUW WACHTWOORD AANVRAGEN~<br />Als u uw wachtwoord kwijt bent, kunt u via deze koppeling een nieuw wachtwoord aanvragen. U komt dan terecht op de pagina \"Verzoek om een nieuw wachtwoord\".<br />Let op: dit geldt alleen voor gebruikers die op deze site al over een gebruikersnaam beschikken!";
$pgv_lang["new_user_help"]			= "~NIEUWE GEBRUIKERSNAAM AANVRAGEN~<br /><br />Als u een gebruikersnaam voor deze website wilt aanvragen, kunt u op deze koppeling klikken. U komt dan terecht op de pagina \"Vraag gebruikersnaam aan\".<br />Let op: dit geldt voor gebruikers die nog niet over een gebruikersnaam voor deze site beschikken, of langer dan 7 dagen geleden een gebruikersnaam hebben aangevraagd en deze niet hebben geverifieerd.";
$pgv_lang["mygedview_login_help"]		= "Om toegang te verkrijgen tot uw persoonlijke MyGedView pagina, moet u beschikken over een gebruikernaam.<br /><br />Op deze persoonlijke pagina kunt u uw favoriete personen vastleggen, notities maken, boodschappen versturen. zien wie er verder nog aangelogd zijn en uw persoonlijke pagina naar believen indelen met nog meer informatievakken.<br /><br />Type, om naar uw persoonlijke MyGedView pagina te gaan, uw gebruikersnaam en wachtwoord in de vakjes in en klik op \"Aanmelden\".";
$pgv_lang["new_user_fullname_help"]		= "~#pgv_lang[fullname]#~<br /><br />Voer in dit vakje uw volledige naam in.<br /><br />Dit is tevens de naam die zichtbaar wordt aan andere aangemelde familieleden en gebruikers.<br /><br />Ook de sitebeheerder moet in staat zijn u aan uw volledige naam te herkennen bij het goedkeuren van uw aanvraag voor een gebruikersnaam.";

//-- Descendancy-page
$pgv_lang["help_descendancy.php"]		= "~NAKOMELINGEN~<br /><br />Op deze pagina worden de nakomelingen van de geselecteerde persoon getoond, maximaal het aantal generaties dat in het veld \"generaties\" is weergegeven. Indien u een ander persoon als startpersoon wilt kiezen, kunt u direct diens ID intikken in het veld \"Startpersoon\". Als u het ID niet kent, kunt u de persoon opzoeken door de koppeling \"Zoek persoon\" aan te klikken en dan op (deel van) de naam te zoeken.<br /><br /><i>PERSOONSVAKKEN IN DE KWARTIERSTAAT</i><br />Per persoon wordt een aantal gegevens getoond, zoals namen, geboorte- en overlijdensdatum en -plaats. Door op de persoonsnaam te klikken, komt u op het detailscherm van de persoon. Tevens zijn twee speciale knoppen zichtbaar (mits de optie \"Toon details\" aan staat):<br /><br /><i>KNOP \"KWARTIERSTAAT\" IN PERSOONSVAK</i><br />Afhankelijk van de instelling van de website, kunt u deze knop activeren door erop te klikken of er met de muis overheen te gaan. Er verschijnt dan een schermpje, waarin u kunt klikken op: de kwartierstaat van deze persoon, zijn/haar afstammelingen, zijn/haar gezin en de persoonsschermen van eega en kinderen.<br /><br /><i>VERGROOTGLAS IN PERSOONSVAK</i><br />Afhankelijk van de instelling van de website, kunt u deze knop activeren door erop te klikken of er met de muis overheen te gaan. Er verschijnt dan een schermpje, waarin extra informatie over de persoon wordt gegeven. Dit betreft onder andere de voorhanden zijnde feiten zoals beroepen, verhuizingen, enz..<br /><br /><i>DE PIJLEN LINKS VAN DE VAKKEN</i><br />Door op de pijlen (te klikken, kunt u het scherm \"verschuiven\", de ouders van de persoon waarvan u de pijl aanklikt, worden dan de startpersonen.<br /><br />";
$pgv_lang["desc_rootid_help"]			= "~STARTPERSOON  NAKOMELINGEN~<br /><br />Als u het overzicht NAKOMELINGEN wilt beginnen met een ander startpersoon, vul dan in het vakje het ID van de nieuwe persoon in.<br />Als u het ID van de persoon niet weet, gebruik dan de koppeling \"Zoek_ID\". Aan de hand van (een deel van) de naam kunt u dan de persoon opzoeken en selecteren.";
$pgv_lang["desc_generations_help"]		= "~AANTAL GENERATIES~<br /><br />Stel hier het aantal generaties in, dat op het scherm wordt weergegeven. Welke weergave voor u het beste is, is afhankelijk van de grootte van uw scherm en van het al dan niet tonen van details.";
//-- show_full is used from pedigree

//-- Time line-page
$pgv_lang["help_timeline.php"]			= "~TIJDLIJN~<br /><br />Op deze pagina kunt u de gebeurtenissen en feiten van een of meerdere personen langs een tijdlijn zichtbaar maken.<br />Op die manier kunt u bijvoorbeeld de status van twee of meer personen op een bepaald moment tonen.<br /><br />Als u vanaf een andere pagina op de tijdlijn-koppeling klikt, wordt de desbetreffende persoon automatisch op de tijdlijn getoond.<br />Als u de tijdlijn heeft gekozen vanaf het menu, kunt u de persoon aangeven door middel van een ID. Ook kunt u met behulp van \"Zoek ID\" de gewenste persoon opzoeken.";
$pgv_lang["add_person_help"]			= "~PERSOON TOEVOEGEN AAN DE TIJDLIJN~<br /><br />Op de tijdlijn kunt u de gebeurtenissen van meerdere personen weergeven.<br />Gebruik het veld in het vak om personen toe te voegen. U kunt direct het ID van de persoon intikken.<br />Als u het ID niet kent, kunt u de persoon opzoeken door de koppeling \"Zoek ID\" aan te klikken en dan op (deel van) de naam te zoeken.";
$pgv_lang["remove_person_help"]			= "~PERSOON VAN DE TIJDLIJN VERWIJDEREN~<br /><br />Klik op deze koppeling om de persoon en diens gebeurtenissen van de tijdlijn te verwijderen.";
$pgv_lang["show_age_marker_help"]		= "~TOON LEEFTIJDS-INDICATOR~<br /><br />Als u deze optie aanvinkt, verschijnt er een leeftijdsindicator van deze persoon op de tijdlijn.<br />Met behulp van uw linker muisknop kunt u deze indicator naar beneden en naar boven schuiven langs de tijdlijn. De indicator geeft, op het aangegeven punt op de tijdlijn, het jaartal aan en de leeftijd van de desbetreffende persoon op dat moment.<br />Voor elke persoon op de tijdlijn kunt u de leeftijdsindicator aan- of uitzetten.";
 
//-- Relationship-page
$pgv_lang["help_relationship.php"]		= "~VERWANTSCHAP~<br /><br />Op deze pagina kunt u de verwantschap tussen twee personen vaststellen.<br />Het is hierbij niet noodzakelijk, dat de twee personen ook bloedverwanten van elkaar zijn, de relatie kan ook bestaan door middel van een huwelijk in de lijn, die de twee personen verbindt (zie \"Controleer verwantschap door huwelijk\").";
$pgv_lang["relationship_id_help"]		= "~ID'S VAN PERSOON 1 EN 2~<br /><br />Als u vanaf een andere pagina op deze pagina terecht bent gekomen (bijvoorbeeld door op de koppeling \"relatie met mij\" te klikken) wordt hier direct de relatie getoond tussen de twee personen.<br /><br />In het andere geval dient u eerst de ID's van de twee personen in de velden in te vullen, of deze door middel van de koppelingen \"Zoek ID\" op te zoeken.";
$pgv_lang["next_path_help"]			= "~VOLGEND PAD~<br /><br />Twee personen kunnen een relatie met elkaar hebben via verschillende personen in de stamboom. U kunt deze knop gebruiken om het programma een volgend pad te laten zoeken. De verschillende gevonden paden blijven bewaard en kunnen door middel van de aangegeven koppelingen (\"Toon pad ...\") opgeroepen worden.";
$pgv_lang["follow_spouse_help"]			= "~CONTROLEER VERWANTSCHAP DOOR HUWELIJK~<br /><br />Zonder deze optie worden alleen relaties tussen personen gevonden, die een bloedband hebben.<br />Is deze optie ingeschakeld, dan zoekt het programma ook naar relaties door huwelijk. Hiermee zult u waarschijnlijk meer relatiepaden vinden.";
$pgv_lang["line_up_generations_help"]	= "~UITLIJNEN GELIJKE GENERATIES~~<br /><br />Als u deze optie aanzet, worden alle zelfde generaties in het overzicht op dezelfde hoogte op de pagina afgedrukt.<br /><br />Staat deze optie uit, dan wordt het overzicht van boven naar beneden afgedrukt, ongeacht of de relatie nu kind-ouder of ouder-kind betreft.";
$pgv_lang["oldest_top_help"]          = "~TOON OUDSTE BOVENAAN~<br /><br />Met deze optie kunt u de oudste personen in het overzicht bovenaan laten afdrukken.<br />In het andere geval worden de jongste personen bovenaan getoond.<br /><br />Let op: Deze optie werkt alleen als <i>#pgv_lang[line_up_generations]#</i> is aangevinkt.";
$pgv_lang["help_ancestry.php"]		= "~#pgv_lang[ancestry_chart]#~<br /><br />De pagina Voorouders lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont meer details en heeft een keuze in <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />Elke voorouder heeft een uniek nummer volgens het <i>Sosa-Stradonitz</i> systeem :<br /> - even nummers voor mannen (nummer kind * 2)<br /> - oneven nummers voor vrouwen (nummer partner + 1), behalve uiteraard voor nummer <big>1</big><br /><br />Voorbeeld: <big>7</big> is de partner van <big>6</big>, de moeder van <big>3</big>, de dochter van <big>14</big> en <big>15</big>.";
$pgv_lang["box_width_help"]		= "~#pgv_lang[ancestry_chart]# vakbreedte~</b><br /><br />Hiermee kun u de breedte van de vakken met persoonsgegevens instellen, van 50% tot 300%.<br />Standaard is 100% hetgeen overeenkomt met een vakbreedte van 270 pixels.";
$pgv_lang["chart_style_help"]			= "~#pgv_lang[ancestry_chart]# indeling overzicht~<br /><br /><dl><dt>#pgv_lang[ancestry_list]#</dt><dd>Verticale boomstructuur, met door +/- in- en uitklapbare delen van de boom.</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>Een gezin per pagina met ouders, grootouders en alle kinderen.<br />Dit geeft een goed overzicht van een gezin met nabije familie en is gemakkelijk af te drukken, bijvoorbeeld om aan uw familie te geven.</dd></dl>";
$pgv_lang["help_fanchart.php"]		= "~#pgv_lang[fan_chart]#~<br /><br />Het cirkeldiagram lijkt veel op de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, maar toont de informatie grafisch op een andere wijze.<br /><br />De startpersoon staat in het centrum van het diagram, de ouders in de eerste cirkel, de grootouders in de tweede, enz.<br /><br />Het geboorte- en overlijdensjaar worden, indien bekend, onder de naam van de persoon afgedrukt.<br /><br />Als u op de naam van een persoon klikt, wordt deze de startpersoon in het cirkeldiagram en verschuift daarmee naar het centrum.<br />In het centrum ziet u tevens een pijl, waarmee u een van de kinderen of broers en zusters van de huidige startpersoon, de nieuwe startpersoon kunt maken. Dit werkt hetzelfde als in de <a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.";
$pgv_lang["fan_width_help"]		= "~#pgv_lang[fan_chart]# omvang~</b><br /><br />De omvang van het cirkeldiagram kunt u instellen van 50% tot 300%.<br />De standaard waarde is 100%, de afbeelding is hiermee ongeveer 640 beeldpunten in breedte.";
$pgv_lang["fan_style_help"]			= "~#pgv_lang[fan_chart]# stijl~<br /><br /><dl><dt>1/2</dt><dd>Cirkeldiagram in halve cirkel (180 graden)</dd><dt>3/4</dt><dd>Driekwart (270 graden) cirkeldiagram</dd><dt>4/4</dt><dd>Cirkeldiagram in volledige cirkel (360 graden)</dd></dl>";

//-- Indilist-page
$pgv_lang["help_indilist.php"]			= "~PERSONEN~<br /><br />PERSOON OPZOEKEN<br />Via deze pagina kunt u de detailgegevens van personen opzoeken. Kies hiervoor de beginletter van de achternaam in de alfabetische index. Daarna wordt een lijst met achternamen getoond, waaruit u wederom een keus kunt maken. Hierna worden de personen met de desbetreffende achternaam getoond. Door een van deze personen aan te klikken kunt u de details bekijken.<br />De lijst met achternamen kan worden overgeslagen, door op de koppeling \"Sla achternamenlijst over\" te klikken.<br />Als u meer informatie wilt hebben, kunt u op het vraagteken achter een koppeling of veld klikken.";
$pgv_lang["alpha_help"]				= "~ALFABETISCHE INDEX~<br /><br />Deze index werkt eenvoudig: <br />Klik op een letter in het alfabet en een lijst met achternamen, beginnend met deze letter, verschijnt.<br /><br />Aan de rechterkant van de rij ziet u (mogelijk) \"Onbekend\". Als u hierop klikt, selecteert u de personen zonder of met een onbekende achternaam. In het originele bestand waren dit personen waarbij geen achternaam is opgegeven. Als de achternaam van personen is aangeduid met N.N. (Nominum nescio, latijn voor naam onbekend) staan deze onder de letter 'N' vermeld.<br /><br />Geheel rechts in de rij ziet u \"ALLE\" staan. Door deze aan te klikken, krijgt u direct een totaaloverzicht van alle personen in de database.<br /><br />Ontbrekende letters?<br />Het kan voorkomen, dat in de rij met letters er enkele ontbreken.<br />Dit is geen fout, maar het gevolg van het feit dat er geen personen voorkomen, waarvan de achternaam met de desbetreffende letter begint.";
$pgv_lang["name_list_help"]			= "~NAMENLIJST~<br /><br />In dit vak ziet u ofwel een achternamenlijst, ofwel een complete namenlijst. In beide gevallen beginnen de namen met de letter, die u in de alfabetische index heeft aangeklikt, met twee uitzonderingen:<br /><br />Als u op \"ALLE\" heeft geklikt in de alfabetische index, ziet u een lijst met alle achternamen in de database.<br /><br />Als u op \"Onbekend\" heeft geklikt in de alfabetische index, ziet u een lijst met personen zonder achternaam.<br /><br />Of u de achternamenlijst ziet of de lijst met personen/gezinnen, is afhankelijk van de status van de koppeling (Toon/verberg achternamenlijst) onder het vak.";
$pgv_lang["skip_sublist_help"]			= "~SLA ACHTERNAMENLIJST OVER~<br /><br />Standaard krijgt u na het kiezen van een letter uit de alfabetische index eerst een lijst van bijbehorende achternamen te zien. Daarna worden pas de specifieke personen/gezinnen getoond.<br /><br />Als u deze optie aanklikt, wordt de achternamenlijst overgeslagen, en krijgt u direct alle personen/gezinnen te zien, waarvan de achternaam met de gekozen letter begint.";

//-- Families-page
$pgv_lang["help_famlist.php"]			= "~GEZINNEN~<br /><br />Via deze pagina kunt u de detailgegevens van een gezin opzoeken. Kies hiervoor de beginletter van de achternaam van een van de partners in de alfabetische index. Daarna wordt een lijst met achternamen getoond, waaruit u wederom een keus kunt maken. Als laatste krijgt u een lijst met partners (in huwelijken) te zien, waaruit u een keus kunt maken. Hierna worden de gezinsleden in het desbetreffende huwelijk getoond.<br /><br />Als u klikt op \"Sla achternamenlijst over\", dan wordt de lijst met verschillende achternamen niet getoond, maar krijgt u direct alle partners in huwelijken te zien waarvan de achternaam met de gekozen letter begint.<br /><br />U kunt zoeken op de achternaam van zowel de ene als van de andere partner.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["help_family.php"]			= "~DETAILS GEZINNEN~<br /><br />Deze pagina geeft de detailgegevens van het gezin, dat u op de vorige pagina heeft gekozen.<br /><br />Van boven naar beneden worden de volgende vakken getoond:<br /><br />De eerste partner en ouders.<br />De tweede partner en ouders.<br />De kinderen.<br /><br />De vorm en inhoud van de vakken zijn dezelfde als die u al aantrof in de kwartierstaat- en nakomelingen-pagina's.<br /><br />Aan de rechterkant van de vakken van de ouders ziet u een pijl. Als u daarop klikt, gaat u naar de details van het gezin van die ouders.<br /><br />Onder de vakken van de kinderen ziet u, als dit door de sitebeheerder is ingesteld, de koppeling \"Kind toevoegen aan dit gezin\".<br />Ook ziet u dan in het vak \"Gezinsinformatie\" een aantal koppelingen, waarmee u nieuwe feiten, notities, bronvermeldingen en koppelingen met multimedia-items kunt aanbrengen.<br /><br />Aan de rechterzijde van het scherm staan de koppelingen:<br /><br /><i>Laat partners zien op de tijdlijn</i><br />Hiermee kunt u direct doorspringen naar de Tijdlijn, waarop dan al de gegevens van beide partners worden getoond.<br /><br /><i>Toon GEDCOM-gegevens</i><br />Hiermee kunt u de brongegevens van dit gezin uit het GEDCOM-bestand inzien.<br /><br /><i>Toevoegen aan knipselbak</i><br />Hiermee kunt u de gegevens van dit gezin in uw knipselbak opslaan om ze later naar uw PC te downloaden. U kunt ze dan importeren in uw eigen genealogieprogramma.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]			= "~KIND TOEVOEGEN AAN DIT GEZIN~<br /><br />Met deze functie kunt u een nieuw persoon als kind toevoegen aan dit gezin.<br /><br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen. ";
$pgv_lang["show_fam_gedcom_help"]	= "~TOON GEDCOM-GEGEVENS~<br /><br />Als u op deze koppeling klikt, krijgt u in een nieuw venster de gegevens van dit gezin in GEDCOM-formaat te zien.";
$pgv_lang["add_fam_clip_help"]		= "~FAMILIE TOEVOEGEN AAN KNIPSELBAK~<br /><br />Met deze koppeling kunt u de GEDCOM-gegevens van deze familie aan uw knipselbak toevoegen. Op de pagina die dan wordt weergegeven, kunt u kiezen om alleen de ouders, tevens hun ouders, hun kinderen en/of alle nakomelingen toe te voegen.";
$pgv_lang["show_fam_timeline_help"]	= "~TOON PARTNERS OP DE TIJDLIJN~<br /><br />Deze koppeling brengt u op de tijdlijn-pagina, waar de tijdlijn direct met de gegevens van de partners wordt weergegeven.";
//-- same variable as individuals page

//-- Sourcelist-page
$pgv_lang["help_sourcelist.php"]		= "~BRONNEN~<br /><br />Op deze pagina treft u een overzicht van alle bronnen aan.<br />Anders dan bij Personen en Gezinnen zijn de bronnen niet via een alfabetische index te benaderen. De reden hiervan is, dat een bron een persoon kan zijn met een voor- en achternaam, maar ook een organisatie of zelfs een website.<br />Het is daarom niet mogelijk om een eenduidige sorteervolgorde te hanteren, ze worden daarom alfabetisch op titel weergegeven.<br /><br />GEBRUIK VAN BRONNEN<br />Zonder bronnen kunnen we niet op een verantwoorde manier een genealogisch bestand opbouwen. Alle informatie dient herleidbaar, reproduceerbaar en controleerbaar te zijn. Aan alle personen, gezinnen en feiten moeten daarom bronnen worden gekoppeld. de bron kan een persoon zijn, die informatie heeft verstrekt, een bepaald document (aktes e.d.) of een ander bestand (denk aan Genlias). Als informatie uit meerdere bronnen afkomstig is, worden alle bronnen genoemd. Tevens kan een bron over meerdere zaken informatie geven, en daarom aan meerdere feiten (huwelijk, geboorte, beroep, etc.) gekoppeld zijn.<br /><br />";
$pgv_lang["sourcelist_listbox_help"]		= "~VAK BRONNENLIJST~<br /><br />In dit vak ziet u de titels van alle bronnen, die in het bestand zijn opgenomen.<br />De lijst is op alfabetische volgorde van titel gesorteerd.<br /><br />Door op de titel van een bron te klikken, gaat u naar de detailgegevens toe. Daar ziet u (indien van toepassing) de notities, bewaarplaats en een koppeling naar een afbeelding van de bron (bijvoorbeeld een ingescande akte).<br />Tevens kunt u zien, vanuit welke persoons- en gezinsinformatie naar de bron wordt verwezen. Door op een persoon of gezin te klikken, kunt u naar de desbetreffende informatie doorspringen.";

//-- Sources-page
$pgv_lang["help_source.php"]			= "~DETAILS BRON~<br /><br />Bronnen zijn belangrijk in genealogisch onderzoek, omdat ze informatie in een stamboom controleerbaar en reproduceerbaar maken. Op die manier kunnen andere onderzoekers op een verantwoorde manier van de gegevens gebruik maken.<br /><br />Op deze pagina ziet u de detailgegevens van de bron.<br />Omdat er veel verschillende soorten bronnen zijn, hebben sommige bronnen hier meer informatie dan anderen.<br />Indien voorhanden, worden onder meer notities, de bewaarplaats en een koppeling naar de afbeelding van de bron weergegeven. De afbeelding is bijvoorbeeld een scan van een akte.<br />Als u op de afbeelding of de bestandsnaam daarnaast klikt, wordt deze in een apart venster vergroot weergegeven.<br />Onder de details van de bron wordt een lijst met personen en gezinnen getoond, waarvan een feit of gebeurtenis naar de bron verwijst.<br /><br />Als de beheerder van de site dit mogelijk heeft gemaakt, ziet u aan de rechterzijde van het scherm nog twee koppelingen: <br />\"Toon GEDCOM-gegevens\", waarmee u in een apart venster de gegevens van de bron in GEDCOM-formaat kunt zien, en <br />\"Toevoegen aan knipselbak\", waarmee u de GEDCOM-gegevens van de bron in uw knipselbak kunt opslaan. Later kunt u ze downloaden naar uw eigen machine en ze daar importeren in uw genealogiepakket.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["sources_listbox_help"]		= "~VAK PERSONEN/GEZINNEN VAN BRON~<br /><br />In dit kader ziet u de namen van personen en/of gezinnen, waarvan een feit of gebeurtenis verwijst naar de bron.<br />Als u op de persoon of het gezin klikt, gaat u naar de detailgegevens van die persoon of dat gezin.";
$pgv_lang["show_source_gedcom_help"]		= "~TOON GEDCOM-GEGEVENS~<br /><br />Als u op deze koppeling klikt, krijgt u in een nieuw venster de gegevens over de bron te zien, zoals ze in het GEDCOM-bestand zijn opgenomen.";
$pgv_lang["add_source_clip_help"]		= "~TOEVOEGEN AAN KNIPSELBAK~<br /><br />Door op deze koppeling te klikken, kunt u de gegevens van de bron, zoals ze in het GEDCOM-bestand voorkomen, aan uw knipselbak toevoegen.";
$pgv_lang["delete_source_help"]			= "~VERWIJDER BRON~<br /><br />Door deze optie aan te klikken, markeert u een bron voor verwijdering uit de genealogie.<br /><br />Wat betekent dat nu?<br />Laten we aannemen dat u een goede reden heeft om deze bron uit de genealogie te verwijderen. U klikt op de koppeling. Daarna verschijnt er een venster, waarin u wordt gevraagd of u er zeker van bent, of dat u de bewerking wilt annuleren.<br /><br />Als u doorgaat, verschijnt na enige tijd opnieuw een scherm, waarin wordt gemeld dat de bron uit de genealogie is verwijderd.<br />De bron zal echter nog steeds zichtbaar en raadpleegbaar zijn. <br /><br />Dit is <b>geen</b> fout. De beheerder heeft een e-mail gekregen, waarin wordt vermeld dat er een wijziging op de genealogie is aangebracht en dat u de bron heeft verwijderd. De beheerder kan de wijziging accepteren of ongedaan maken. Pas als de beheerder de wijziging heeft geaccepteerd, is de bron definitief verwijderd.<br />Bij twijfel zal de beheerder contact met u opnemen.";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]			= "~PERSONEN PER LOCATIE~<br /><br />Via dit scherm kunt u personen en gezinnen opzoeken, die een verband hebben met een bepaalde locatie.<br /><br />Wanneer een locatie wordt genoemd in een feit of gebeurtenis van een persoon of gezin, vindt het programma deze voor u.<br />Zo kunt u bijvoorbeeld opzoeken, wie iets te maken heeft gehad met een bepaald land, stad of zelfs een bepaalde straat.<br /><br />De resultaten worden getoond in een venster met twee kolommen:<br />Een voor personen en een voor gezinnen.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]		= "~ORDENING VAN LOCATIES - STANDAARD~<br /><br />Binnen locaties komen verschillende niveaus van omschrijving voor.<br /> Zo kan een landaanduiding worden genoemd, maar ook een plaatsnaam of zelfs straat. In het bestand wordt de opbouw aangehouden, die hier wordt genoemd. Deze opbouw is standaard bepaald, omdat in het geïmporteerde GEDCOM-bestand geen aanduiding voor een afwijkende opbouw is gevonden.<br /><br />In het geval dat deze afwijkend was geweest, was deze aan het einde van de regel tussen haakjes getoond.";
$pgv_lang["ppp_match_one_help"]			= "~ORDENING VAN LOCATIES - VOLGENS GEDCOM~<br /><br />Binnen locaties komen verschillende niveaus van omschrijving voor.<br /> Zo kan een landaanduiding worden genoemd, maar ook een plaatsnaam of zelfs straat. In het bestand wordt de opbouw aangehouden, die hier wordt genoemd. Deze opbouw is gedefinieerd in het geïmporteerde GEDCOM-bestand.";
$pgv_lang["ppp_numfound_help"]			= "~LOCATIEVERBINDINGEN GEVONDEN~<br /><br />Hier wordt het aantal locatieverbindingen getoond dat is gevonden.<br />Als nog steeds een lijst met locaties zichtbaar is, betekent dit dat het laagste niveau nog niet is bereikt.<br />U kunt de bij deze locatie bijbehorende gezinnen en personen zien, door op deze koppeling te klikken. Ook kunt u de zoekopdracht verder verfijnen, door op een locatie te klikken in de lijst.";
$pgv_lang["ppp_levels_help"]			= "~LOCATIENIVEAUS~<br /><br />Dit laat het aantal niveaus binnen de locatie zien, dat nu wordt getoond.<br />De lijst in het vak is in feite een deellijst van het bovenliggende niveau.<br /><br />VOORBEELD:<br />De (standaard) volgorde is: #pgv_lang[default_form]#<br />Als het huidige niveau het \"Hoogste niveau\"  is, dan laat het vak alle landen in het bestand zien. <br />Als het huidige niveau is: \"Leiden, Hoogste niveau\", dan worden alle straten in Leiden getoond, die in het bestand voorkomen.<br />etc.<br /><br />U kunt op een niveau klikken, om een of meer stappen terug te gaan.";
$pgv_lang["ppp_placelist_help"]			= "~LOCATIES~<br /><br />In deze lijst worden de locaties getoond, die zijn gevonden onder de locatie die u heeft gekozen. Heeft u nog geen locatie gekozen, dan ziet u een lijst met alle locaties op het hoogste niveau.<br />De namen van de locaties in de lijst kunt u aanklikken.<br />Klikken op een locatie werkt als een filter, het brengt u naar een lager niveau.";
$pgv_lang["ppp_placelist_help2"]		= "~LOCATIELIJST~<br /><br />In deze lijst ziet u de locaties die zijn gevonden.<br />U kunt op de locatienamen klikken, dit brengt u een niveau dieper.<br />Op ieder niveau behalve het hoogste krijgt u een lijst met personen en gezinnen te zien, waarvan een gebeurtenis aan de desbetreffende locatie is gekoppeld.";
$pgv_lang["ppp_view_records_help"]		= "~ALLE PERSONEN/GEZINNEN OP DEZE LOCATIE~<br /><br />Door op deze koppeling te klikken, gaat u direct naar het overzicht van personen en gezinnen, waarvan een gebeurtenis op deze locatie heeft plaatsgevonden.<br />Als u in het locatieoverzicht op het laagste niveau bent gekomen, krijgt u dit overzicht automatisch te zien.";
$pgv_lang["ppp_name_list_help"]			= "~LOCATIES - NAMENLIJST~<br /><br />In dit vak vindt u een complete lijst van personen en gezinnen, waarvan een feit of gebeurtenis naar deze locatie verwijst.<br /><br />Door op een naam in de lijst klikken, worden de details van de persoon of het gezin getoond.<br /><br />U kunt ook opnieuw zoeken, door op de koppeling naar een hogerliggend niveau (b.v. de plaats of \"hoogste niveau\") te klikken. In dat geval wordt weer de lijst met locaties getoond.";

//-- Mulitmedia-page
$pgv_lang["help_medialist.php"]			= "~MULTIMEDIALIJST~<br /><br />In deze lijst worden alle multimedia-items vermeld, die in het bestand voorkomen. De lijst is op volgorde van bestandsnaam gesorteerd.<br />U kunt direct het multimedia-item bekijken, door op de bestandsnaam of de miniatuurafbeelding te klikken. Afhankelijk van het bestandstype wordt het item getoond in PhpGedView of in het programma dat is gekoppeld aan het bestandstype.<br />Als u met de rechter muisknop op het item klikt, kun u alle mogelijkheden die uw verkenner biedt, benutten, zoals opslaan als....., afdrukken, etc.<br />Onder de bestandsnaam zijn (indien aanwezig) de koppelingen naar personen, gezinnen en bronnen vermeld, waaraan het item is gekoppeld. Als u op deze \"Bekijk....\"-koppelingen klikt, gaat u direct naar de pagina met de details van persoon, gezin of bron.<br />";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]		= "~UPLOADEN MEDIABESTANDEN~<br /><br />Met deze functie kunt u mediabestanden uploaden naar PhpGedView. In de invoervakken vult u resp. de bestandsnaam van het mediabestand en van de miniatuurweergave in. Deze bestanden worden dan geplaatst in de mappen, die bij de instellingen van de huidige, actieve genealogie zijn opgegeven.<br />Het mediabestand wordt dan bijvoorbeeld geplaatst in ./media, de miniatuurweergave in ./media/thumbs.<br /><br /><b>Miniatuurweergaven</b><br />Miniatuurweergaven kunnen het beste een afmeting hebben van 100 x 100 en moeten dezelfde naam hebben als het bijbehorende mediabestand.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
$pgv_lang["help_calendar.php"]			= "~GEBEURTENISKALENDER~<br /><br /><ul><li><a href=\"#calendar_general\">Algemene informatie</a><li><a href=\"#calendar_day\">#pgv_lang[day]#</a><li><a href=\"#calendar_month\">#pgv_lang[month]#</a><li><a href=\"#calendar_year\">#pgv_lang[year]#</a><li><a href=\"#calendar_show\">#pgv_lang[show]# / #pgv_lang[showcal]#</a><li><a href=\"#calendar_sex\">#pgv_lang[sex]#</a><li><a href=\"#calendar_event\">Event</a><li><a href=\"#calendar_button\">\"Toon\"-knoppen </a><li><a href=\"#calendar_tip\">Tip</a></ul><br /><a name=\"calendar_general\"></a>De gebeurteniskalender toont de gezinnen en personen die zijn gekoppeld aan een gebeurtenis op een bepaalde dag of maand, of in een bepaalde periode. De kalender is dermate geavanceerd, dat de juiste datum of periode met de gewenste gebeurtenissen worden getoond.<dl><dt><b>Toon <a href=\"#calendar_day\">dag</a></b></dt><dd>Dit toont de gebeurtenissen op een bepaalde dag, onafhankelijk van maand en jaar. Er verschijnt een lijst met de namen van gezinnen of personen, of een lijst met in de linkerkolom de personen en in de rechter de gezinnen.</dd><dt><b>Toon <a href=\"#calendar_month\">maand</a></b></dt><dd>In de <b>Kalender</b> zijn zowel de namen van personen als van gezinnen zichtbaar in de dagvakken. De kalender wordt getoond zoals deze was in het jaar dat u in het jaarvak heeft ingevoerd. Alle gebeurtenissen in en voor dat jaar zijn zichtbaar.<br />In combinatie met de optie \"<a href=\"#calendar_show\">#pgv_lang[recent_events]#</a>\" geeft het een realistisch beeld van de maandkalender, zoals deze bij uw voorouders in dat jaar aan de muur hing.</dd><dt><b>Toon <a href=\"#calendar_year\">jaar</a></b></dt><dd>Dit toont de gebeurtenissen in een jaar of een reeks van jaren. Er verschijnt een lijst met de namen van gezinnen of personen, of een lijst met in de linkerkolom de personen en in de rechter de gezinnen.</dd></dl>De datum en maand die op dit moment worden getoond, zijn vetgedrukt in de kalenderbalken.<br /><br />U kunt klikken op de namen en datums die in de lijst staan.<br />Hiermee springt u of naar de detailpagina van het gezin of de persoon, of naar de \"Toon dag\" of \"Toon jaar\" functie van de kalender, waarmee alle gebeurtenissen van de desbetreffende dag of het jaar worden getoond.<br /><br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#GLOBALS[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]		= "~DATUMKEUZE~</b><br /><br />U kunt de datum kiezen door in de dag- en maandvelden de gewenste waarden te kiezen en in het jaarveld het gewenste jaar in te typen.<br />Als u op deze pagina terechtkomt, is standaard de datum van vandaag ingevuld.<br /><br />Wanneer u op de knop \"Toon dag\" klikt, worden alle personen getoond, waaraan een gebeurtenis is gekoppeld op de gekozen dag en maand.<br /><br />Klikt u op de knop \"Toon maand\", dan ziet u een maandkalender van de gekozen maand, waarin per dag de personen worden getoond, waaraan een gebeurtenis is gekoppeld die op die dag in de gekozen maand heeft plaatsgevonden.<br /><br /><b>TIP</b><br />Stel dat u een familielid heeft, dat op 25 januari 1875 is geboren.<br />Als u op een van de \"Toon\" knoppen klikt, ziet u een lijst met personen of een kalender van die datum.<br />Alle verjaardagen, leeftijden, etc. zijn herberekend en tellen terug vanaf de datum die u heeft ingevoerd in de keuzevelden en het jaarveld.<br />In feite ziet u dan een verjaardagskalender, zoals uw familielid deze ook heeft gezien, lang geleden.<br />";
$pgv_lang["annivers_month_select_help"]		= "~MAAND SELECTIE~<br /><br />Op de middelste rij van het selectievak kunt u de maand selecteren. Dit werkt hetzelfde als selectie van de dag: door op een maand te klikken wordt deze aan de gewenste datum toegekend.<br /><br />Heeft u voor \"Toon dag\" gekozen en klikt u op een nieuwe maand, dan zullen op het scherm de gebeurtenissen worden getoond op de eerder gekozen dag en jaar, in combinatie met de nieuw gekozen maand.<br /><br />Heeft u voor \"Toon maand\" gekozen, dan worden de gebeurtenissen getoond van het eerder gekozen jaar en de nu gekozen maand.<br /><br />Rechts in de maandbalk ziet u een snelkoppeling naar de huidige maand. Als u hierop klikt, wordt het maandoverzicht van de huidige maand getoond.<br /><br />Rechts in de dagbalk ziet u de huidige datum staan. Als u hierop klikt, verschijnt het overzicht op de huidige datum.<br />";
$pgv_lang["annivers_year_select_help"]		= "~JAAR INVOERVAK~<br /><br />In dit vak kunt u het jaartal typen, waarvan u het maandoverzicht of jaaroverzicht wilt zien.<br />In het dagoverzicht heeft het jaartal geen functie, omdat alle gebeurtenissen uit alle jaren worden getoond.<dl><dt><b>Geavanceerde mogelijkheden</b> voor <b>#pgv_lang[viewyear]#:<br /><br />Meer dan een jaar</b></dt><dd>U kunt de gebeurtenissen van meer dan een jaar tonen door de jaartallen als volgt in het jaarvak in te vullen:<br />- Voorbeeld 1: <b>1992-5</b> voor alle gebeurtenissen van 1992 tot en met 1995.<br />- Voorbeeld 2: <b>1972-89</b> voor alle gebeurtenissen van 1972 tot en met 1989.<br />- Voorbeeld 3: <b>1610-759</b> voor alle gebeurtenissen van 1610 tot 1759.<br />- Voorbeeld 4: <b>1880-1905</b> voor alle gebeurtenissen van 1880 tot 1905<br />- Voorbeeld 5: <b>880-1105</b> alle gebeurtenissen van 880 tot 1105.<br /><br />In alle gevallen kunt u de twee jaartallen volledig invoeren met een liggend streepje ertussen, zie de voorbeelden 4 en 5.<br /><br /></dd><dt><b>Afkortingen</b></dt><dd>Soms is niet precies bekend, wanneer een gebeurtenis heeft plaatsgevonden. In dat geval kunnen er aan de datum termen worden toegevoegd als \"voor\", \"na\", \"ongeveer\", etc. De datums worden dan in het bestand opgeslagen met de Engelse afkorting ervan. Deze afkortingen kunt u gebruiken in het jaarvak:<br /><b>abt</b> 1800 (abt=about, ongeveer)<br /><b>bet</b> 1950-1959 (bet=between, tussen), type dit als: bet 1950-59<br /><b>bef</b> 1950 (bef=before, voor)<br /><b>aft</b> 1910 (aft=after, na)<br /><br />Let op: PhpGedView zoekt in het bestand op de exacte term die u heeft ingevoerd. Met de term \"abt 1800\" wordt een datum \"abt oct 1800\" dus <b>niet</b> gevonden.<br />U kunt ook alleen de afkortingen gebruiken, alle gebeurtenissen met een jaartal met deze afkorting worden dan gevonden.<br /><br /></dd></dl>Nadat u het jaar heeft ingevuld, moet u op de <b>#pgv_lang[viewmonth]#</b> of <b>#pgv_lang[viewyear]#</b> knop klikken om het nieuwe overzicht op het scherm te tonen.<br />";
$pgv_lang["annivers_show_help"]			= "~TOON GEBEURTENISSEN VAN ....~<br /><br />Als u niet op de site bent aangemeld, heeft u de keuze uit:<br /><br /><i>Alle personen</i><br />U krijgt alle personen en families te zien.<br /><br /><i>Recente gebeurtenissen (<100 jaar)</i><br />Toont alleen de personen en gezinnen, waaraan een gebeurtenis is gekoppeld die op de desbetreffende dag, minder dan 100 jaar geleden, heeft plaatsgevonden.<br /><br />Heeft u zich wel aangemeld, dan heeft u tevens de optie:<br /><br /><i>Levende personen</i><br />Toont alleen de levende personen, waaraan een gebeurtenis is gekoppeld die op de desbetreffende dag heeft plaatsgevonden<br /><br />Bij ieder van deze keuzes blijft de gekozen datum en dag/maand selectie gehandhaafd.<br />";
$pgv_lang["annivers_sex_help"]			= "~SELECTIE GESLACHT~<br /><br />Als u als gebruiker bent aangemeld (of als de beheerder de privacybeperkingen heeft uitgeschakeld) kunt u kiezen uit drie mogelijkheden:<dl><dt><b>1. Alle</b></dt><dd>Met deze optie worden de gebeurtenissen van alle personen en gezinnen getoond.</dd><dt><b>2. Mannelijk</b></dt><dd>Hier worden alleen de gebeurtenissen van mannelijke personen getoond, alsmede de gezinsgebeurtenissen van mannelijke gezinsleden.</dd><dt><b>3. Vrouwelijk</b></dt><dd>Hier worden alleen de gebeurtenissen van vrouwelijke personen getoond, alsmede de gezinsgebeurtenissen van vrouwelijke gezinsleden.</dd></dl>Als u een optie heeft aangeklikt wordt het scherm ververst en krijgt u de nieuwe gegevens te zien. Andere keuzes zoals jaar, maand en dag blijven zoals ze waren.<br />";
$pgv_lang["annivers_event_help"]		= "~SELECTIE GEBEURTENIS~<br /><br />U kunt hier aangeven of u voor de personen en gezinnen alle gebeurtenissen wilt weergegeven, of alleen een specifieke gebeurtenis.<br /><br />Als u de keuze heeft gemaakt, ververst het scherm en wordt getoond wat u heeft gekozen.<br />Andere keuzes zoals jaar, maand en dag blijven zoals ze waren.<br />";
$pgv_lang["annivers_tip_help"]			= "~TIP~<br /><br />Stel dat u een familielid heeft, geboren op 25 januari 1875.<br />Stel nu de datum hierop in.<br />Wanneer u nu op de \"Toon dag\" of \"Toon maand\" knop klikt, krijgt u een kalender voor die datum.<br />Alle leeftijden, verjaardagen, etc. zijn herberekend aan de hand van de datum die u heeft ingevoerd.<br />In feite ziet u nu dus een kalender, die uw familielid lang geleden op die datum zou hebben gezien.<br />";
$pgv_lang["day_month_help"]			= "~TOON DAG / TOON MAAND / TOON JAAR~<br /><br />Met de <b>\"Toon dag\"</b> knop worden de personen weergegeven waaraan een gebeurtenis is gekoppeld, die op die dag en maand in een willekeurig jaar heeft plaatsgevonden. Het wijzigen van het jaar in het jaarveld heeft dus geen effect. Leeftijden worden berekend ten opzichte van het huidige jaar.<br /><br />De <b>\"Toon maand\"</b> knop laat een kalender zien, met de gebeurtenissen die op iedere dag van die maand hebben plaatsgevonden, met de bijbehorende personen. Met het jaarvak kunt u instellen, tot welk jaar de gebeurtenissen worden geselecteerd. Bij 1800 worden alle gebeurtenissen tot en met het jaar 1800, in de gekozen maand, getoond. In combinatie met \"Recent verleden\" krijgt u een realistische indruk van hoe de kalender aan de muur van uw voorouders er moet hebben uitgezien in het gekozen jaar.<br /><br />Met de <b>\"Toon jaar\"</b> knop krijg u een overzicht van personen en families, waarvan een gebeurtenis aan het desbetreffende jaar is gekoppeld. De gebeurtenissen worden getoond en het overzicht is gesorteerd op naam.<br />Ook kunt u hier een periodes van jaren selecteren. Voor 1990 tot en met 1995 typt u: 1990-5. Voor 1900 tot en met 1930: 1900-30. Tevens kunt u een periode van 10 jaar selecteren, door in het jaarveld alleen de eerste drie cijfers van het jaartal in te geven. 190 selecteert dus de periode 1900-1909.<br />In alle gevallen is het mogelijk de periode aan te geven door de gehele jaartallen in te voeren, met een minteken ertussen: 1764-1823.<br /><br />Bij al deze keuzes kunt u de gebeurtenissen limiteren door \"Levende personen\" of \"Recent verleden\" te kiezen.<br /><br />Let op: zodra u een nieuw jaartal heeft ingevoerd in het jaarvak, moet u op een van de drie knoppen klikken om dit te activeren.<br />";

//-- Clipping Cart-page
$pgv_lang["help_clippings.php"]			="~STAMBOOMKNIPSELS~<br /><br />Met deze functie kunt u gegevens uit de stamboom in GEDCOM-formaat verzamelen. Uiteindelijk kunt u de verzamelde GEDCOM-regels downloaden naar uw eigen PC.<br /><br />Hoe verzamelt u de gegevens?<br />Dit is eenvoudig. Als ergens op een pagina u een naam ziet, waarop u kunt klikken (familie, persoon of bron), gaat u naar de detailpagina hiervan. Daar ziet u een optie \"Toevoegen aan knipselbak\".<br />Als u daarop klikt, krijgt u een nieuw scherm, waarop u kunt kiezen uit een aantal mogelijkheden voor het toevoegen.<br /><br />Hoe download u gegevens?<br />Zodra u gegevens in uw knipselbak heeft, kunt u deze downloaden. Klik hiervoor op de koppeling \"Nu downloaden\" en volg de instructies.";
$pgv_lang["clip_download_help"]			="~DOWNLOAD KNIPSELBAK~<br /><br />Als u op deze koppeling klikt, komt u op een nieuwe pagina terecht.<br />Mogelijk staan daarop meerdere opties om te downloaden.<br />Volg dan de instructies die daarbij worden vermeld.";
$pgv_lang["empty_cart_help"]			="~KNIPSELBAK LEEGMAKEN~<br /><br />Door op deze koppeling te klikken, wordt uw knipselbak geheel leeg gemaakt.<br /><br />Als u niet alle personen, gezinnen, etc. uit uw knipselbak wilt verwijderen, kunt u dit selectief doen door op de koppeling \"Verwijderen\" in het desbetreffende vak te klikken.";

//-- GEDCOM Edit Utillity
$pgv_lang["show_changes_help"]			="~TOON GEDCOM-WIJZIGINGEN~<br /><br />Als u deze koppeling ziet, betekent dit dat:<br /><br />1. Iemand wijzigingen heeft aangebracht aan het GEDCOM-bestand.<br />Gegevens kunnen zijn gewijzigd, verwijderd of toegevoegd.<br /><br />2. De wijzigingen zijn door de beheerder nog niet geaccepteerd.<br />Zodra de beheerder de wijzigingen heeft geaccepteerd of verworpen, verschijnt deze koppeling niet meer.<br /><br />Door op deze koppeling te klikken, kunt u zien welke wijzigingen zijn aangebracht.<br /><br />Mocht u vinden, dat een wijziging niet correct is, neem dan contact op met de beheerder.";

//-- Search-page
$pgv_lang["help_search.php"]			="~ZOEKEN~<br /><br />Hoewel deze pagina er eenvoudig uitziet, bevindt zich achter de zoekfunctie een uiterst krachtige zoekmachine. U kunt op deze pagina:<br /><br />* DOORZOEK GENEALOGIE(EN)<br />Met behulp van deze zoekfunctie kunt u het gehele bestand doorzoeken op willekeurig welk zoekcriterium.<br /> U kunt hier een jaartal ingeven of een (gedeelte van) de naam van een persoon of plaats.<br /><br />* ZOEK GELIJKENDE PERSOONS- of PLAATSNAMEN (SOUNDEX)<br />Met behulp van Soundex kunt u zoeken naar gelijkende namen. U kunt dit gebruiken, als u de schrijfwijze van de achternaam niet precies weet. Het programma vindt alle namen die enigszins overeen komen met degene die u heeft ingegeven.<br /><br />Ale er meer dan een genealogie op deze website aanwezig is EN de beheerder heeft het wisselen van genealogie toegestaan, zoekt deze functie door alle genealogieën heen.<br /><br />Meer informatie vindt u door op de Help-koppelingen te klikken bij de zoekvakken.<br /><br />";
$pgv_lang["search_enter_terms_help"]		="~ZOEKCRITERIA~<br /><br />In dit vak kunt u een zoekcriterium invoeren, waarop in de stamboom zal worden gezocht.<br />Omdat de zoekmachine het gehele bestand doorzoekt, kunt u op elk willekeurig gegeven zoeken.<br />Zo kunt u een achternaam invoeren, maar ook een beroep, een plaatsnaam of een jaartal. Wanneer deze in het bestand voorkomt, zullen de bijbehorende personen en gezinnen in een resultatenvak worden getoond.<br /><br /><b>Jokertekens</b><br />De zoekmachine kent geen jokertekens zoals \"*\" of \"?\", binnen alle gegevens wordt gezocht naar het voorkomen van de letterreeks die u heeft ingevoerd. De jokertekens worden impliciet toegepast.<br />Stel dat u zoekt op <b>Peter</b>. Dit kan de volgende resultaten opleveren:<br /><b>Peter</b> Kleinsma<br /><b>Peter</b>-Jan de Groot<br />Klaas Pietersen, geboren te St. <b>Peter</b>sburg<br />etc. etc.<br /><br /><b>Datums</b><br />U kunt in principe ook zoeken op datums. Als u bijvoorbeeld zoekt op <b>1950</b>, dan worden alle personen getoond, waar in de gegevens 1950 voorkomt. Dit kan in een huwelijk zijn, maar ook in een geboorte, datum bij een beroep of welke gebeurtenis dan ook.<br /><br />Als u zoekt op <b>4 dec</b>, krijgt u als resultaat alle personen met een gebeurtenis op 4 december, maar ook op 14 december en 24 december. Ook hier voegt het programma automatisch de jokertekens toe.<br />De volgorde van dag en maand is eveneens van belang: <b>14 dec</b> selecteert alle personen met 14 december in de gegevens, <b>dec 14</b> alle personen met bijvoorbeeld <b>dec</b> 18<b>14</b><br /><br />U kunt ook zoekuitdrukkingen gebruiken. Als u bijvoorbeeld personen zoekt die een datum hebben in de 20e eeuw, dan kunt u dit als volgt invoeren: <b>19[0-9][0-9]</b>, waarmee u alle datums van 1900 tot en met 1999 selecteert.<br /><br />Heeft u meer hulp nodig bij het werken met dit zoeksysteem, meldt dit dan aan de makers van PhpGedView, zodat de Help-informatie kan worden uitgebreid.";
$pgv_lang["soundex_search_help"]		="~ZOEK GELIJKENDE PERSOONS- OF PLAATSNAMEN (SOUNDEX)~<br /><br />Type, om met behulp van Soundex te zoeken, minimaal een achternaam, voornaam of plaatsnaam in, eventueel in combinatie met een jaartal of periode. Om het aantal zoekresultaten te beperken, kunt u aanvullende criteria opgeven in de overige velden.<br /><br />Soundex wordt gebruikt om namen te vinden die weliswaar hetzelfde worden uitgesproken, maar verschillend worden geschreven. Denk aan \"Smit\", \"Smid\" en \"Smidt\".<br />In een Soundex-index wordt aan deze drie namen een zelfde code toegekend, waardoor ze bij een zoekactie alle drie worden getoond.<br />Een nadeel is, dat de eerste letter altijd wel overeen moet komen, \"Ferwerda\" en \"Verwerda\" worden dus als verschillende namen in de Soundex-index opgenomen.<br />Een voordeel is, dat namen worden gevonden, ook al kent u de precieze schrijfwijze niet.<br /><br />Deze zoekmethode werkt voor alle soorten namen, dus ook voor voornamen en plaatsnamen.<br />Als u meerdere velden invult, werkt dit als een \"EN\" functie, waardoor de zoekresultaten worden beperkt.<br />Ook kunt u een jaartal of periode toevoegen, waardoor de resultaten verder worden beperkt tot alle personen met een gebeurtenis in dat jaar of die periode.<br />Voorbeelden van mogelijkheden voor jaartal zijn: 1950 of 19[5][0]-19[6][9]. Dit laatste voorbeeld selecteert op de periode 1950-1969.";

//-- Individuals-page
$pgv_lang["help_individual.php"]		= "~DETAILGEGEVENS PERSOON~<br /><br />Op deze pagina worden alle details van de geselecteerde persoon weergegeven, voor zover deze aanwezig zijn en mogen worden weergegeven vanwege privacy-instellingen. Een uitleg van de mogelijkheden wordt hieronder gegeven.<br />Let op: sommige functies (zoals wijzigen) kunnen door de beheerder zijn uitgeschakeld.<br /><br /><i>NAAMGEDEELTE</i><br />Links op het scherm zijn de namen en het geslacht van de persoon vermeld. Indien aanwezig, eveneens diens bijnamen (\"ook bekend als\"). Aan de namen kunnen bronvermeldingen zijn gekoppeld evenals notities. Deze zijn, indien aanwezig, bij de desbetreffende naam vermeld.<br />Als een afbeelding van de persoon beschikbaar is, wordt deze eveneens getoond.<br />Tevens kunt u de namen van de persoon wijzigen of verwijderen of zelfs de gehele persoon verwijderen, mits u daartoe rechten heeft.<br /><br /><i>EXTRA FUNCTIES</i><br />Rechts op het scherm ziet u een vak, waarin de functies staan die u vanaf dit scherm kunt uitvoeren, mits de beheerder deze beschikbaar heeft gemaakt: <br /><br /><i>Kwartierstaat</i><br />Ga naar de kwartierstaat van deze persoon.<br /><br /><i>Tijdlijn</i><br />Ga naar de tijdlijn en plaats deze persoon erop.<br /><br /><i>Nakomelingen</i><br />Toon nakomelingen van deze persoon.<br /><br /><i>Toon GEDCOM-gegevens</i><br />Toont in een apart venster de gegevens van deze persoon in GEDCOM-formaat.<br /><br /><i>Toevoegen aan knipselbak</i><br />Voegt de GEDCOM-gegevens van deze persoon toe aan uw knipselbak. Hierin kunt u vanaf diverse plaatsen GEDCOM-gegevens verzamelen en deze vervolgens downloaden. Daarna kunt u ze importeren in uw eigen genealogieprogramma.<br /><br /><i>Relatie met mij</i><br />Toont de verwantschap tussen deze persoon en uzelf.<br /><br /><i>HET TABBLAD \"PERSOONLIJKE FEITEN EN DETAILS\"</i><br />Hierop worden alle bekende gegevens van de persoon en zijn/haar huwelijk(en) getoond. Per feit of detail worden tevens de bronnen getoond, waarin naar het feit wordt verwezen (klik op de + tekens om eventueel aanvullende tekst te zien).<br />Op elke datum en plaats op dit tabblad kunt u klikken. Een datum brengt u naar de jaarkalender, waar alle personen en gezinnen worden getoond waarvan een feit op die dag en maand plaatsvond. Een plaats geeft u een overzicht van alle personen en gezinnen, waarvan een gebeurtenis is verbonden met deze plaats.<br />Bij iedere huwelijksgerelateerde gebeurtenis wordt tevens de partner genoemd. Als u op de naam daarvan klikt, krijgt u de persoonlijke details van de partner te zijn. Klikt u op de koppeling \"Bekijk gezin\", dan gaat u naar de gezinsinformatie van dit gezin.<br />Tevens kunt u nieuwe feiten toevoegen aan deze persoon, en bestaande feiten wijzigen of verwijderen.<br /><br /><i>HET TABBLAD \"NOTITIES\"</i><br />Hier vindt u alle notities, die bij de persoon zijn gemaakt.<br />Ook kunt u bestaande notities wijzigen of verwijderen en nieuwe notities toevoegen.<br /><br /><i>HET TABBLAD \"BRONNEN\"</i><br />Hier vindt u alle bronnen, die direct aan de persoon zijn gekoppeld. Let op: dit zijn verwijzingen naar bronnen, die de persoon noemen of niet direct aan een feit zijn gerelateerd.<br />Door op de omschrijving van de bron te klikken, kunt u nadere gegevens over de bron inzien. Tevens wordt een lijst getoond van personen en gezinnen, die eveneens een verwijzing naar deze bron hebben.<br />Ook kunt u bestaande notities wijzigen of verwijderen en nieuwe notities toevoegen.<br /><br /><i>HET TABBLAD \"MULTIMEDIA\"</i><br />Op dit blad treft u alle koppelingen aan van de persoon met multimedia-items. U kunt ze in het groot bekijken, door op de miniatuurweergave te klikken.<br />Eveneens kunt u bestaande multimediakoppelingen wijzigen of verwijderen en nieuwe koppelingen toevoegen.<br /><br /><i>HET TABBLAD \"VERWANTEN\"</i><br />Op dit scherm vindt u de detailgegevens van het gezin met ouders en van de gezinnen van de persoon zelf. Door op de namen van de gezinsleden te klikken kunt u de detailgegevens van de persoon bekijken.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["delete_person_help"]			= "~VERWIJDER DEZE PERSOON~<br /><br />Door middel van deze functie kunt u een persoon markeren voor verwijdering.<br />Als u op deze koppeling klikt, dient u eerst te bevestigen dat u deze persoon daadwerkelijk wilt verwijderen. Na bevestiging zal de persoon worden gemarkeerd voor verwijdering.<br />De daadwerkelijke verwijdering zal eerst plaatsvinden, als de beheerder van de genealogie dit heeft goedgekeurd. Pas dan is de verwijdering definitief en is de persoon niet meer zichtbaar.<br />Tot die tijd kunt u de gegevens van de persoon nog bekijken en kunnen deze zelfs nog worden bewerkt.<br /><br />Met het verwijderen van een persoon worden ook alle feiten van de persoon, de deelname in gezinnen, bronvermeldingen, notities en koppelingen met multimedia-items verwijderd.";
$pgv_lang["delete_name_help"]			= "~WIJZIG NAAM | VERWIJDER NAAM~<br /><br />Met deze functie kunt u de naam van een persoon bewerken. De persoon zelf en de bijbehorende feiten, notities en koppelingen met bronnen en multimedia worden NIET verwijderd.<br />Ook geldt, dat wijzigingen en verwijdering zichtbaar blijven en zelfs weer kunnen worden aangepast, totdat deze door de beheerder van de genealogie zijn goedgekeurd. Pas dan worden ze definitief doorgevoerd.<br /><br /><i>WIJZIG NAAM</i><br />Als u op deze koppeling klikt, kunt u in het nieuwe venster de naam van de persoon wijzigen, een roepnaam toevoegen, etc.<br /><br /><i>VERWIJDER NAAM</i><br />Met deze functie kunt u de naam van de persoon wissen. Alle gegevens van de persoon blijven ongewijzigd, behalve dat de persoon met naam \"Onbekend\" voorkomt.";
$pgv_lang["add_name_help"]				= "~NAAM TOEVOEGEN~<br /><br />Hiermee kunt u extra namen toevoegen aan deze persoon. Als een persoon onder meerdere namen bekend is of bijnamen had, kunt u deze toevoegen zonder de oude naamsgegevens te wijzigen.";
$pgv_lang["add_sibling_help"]			= "~VOEG BROER OF ZUS TOE~<br /><br />Met deze functie kunt u een nieuw persoon als broer of zus toevoegen aan dit gezin.<br />Let op: hiermee wordt een kind toegevoegd aan het gezin van de ouders van de persoon bovenin het scherm.<br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen.<br /><br />Voor het toevoegen van een kind aan het gezin van de gekozen persoon, dient u naar de detailpagina voor het gezin te gaan. Klik hiervoor op de koppeling \"Bekijk gezin\" bij :Gezin met partner\".";
$pgv_lang["add_son_daughter_help"]		= "~VOEG ZOON OF DOCHTER TOE~<br /><br />Met deze functie kunt u een nieuw persoon als kind toevoegen aan dit gezin.<br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen.<br /><br />Als u een broer of zus wilt toevoegen aan de partner, dient u dit vanaf de pagina met persoonsinformatie te doen. Klik hiervoor op de naam van de persoon, aan wie een broer/zuster toegevoegd moet worden.";
$pgv_lang["link_child_help"]			= "~KOPPEL DEZE PERSOON AAN EEN BESTAAND GEZIN ALS: KIND~<br /><br />Met deze functie kunt u de persoon aan een reeds bestaand gezin toevoegen, als kind. Dit kan voorkomen, als tot op heden de ouders van de persoon onbekend waren, en u nu ontdekt heeft, dat deze in uw bestand reeds voorkwamen.<br /><br />Als u op de koppeling klikt, verschijnt een scherm waarin u de ID van het desbetreffende gezin dient op te geven. Met de zoekfunctie kunt u deze gemakkelijk selecteren.";
$pgv_lang["link_husband_help"]			= "~KOPPEL DEZE PERSOON AAN EEN BESTAAND GEZIN ALS: PARTNER~<br /><br />Met deze functie kunt u de huidige persoon toevoegen als partner in een <i>bestaand</i> gezin.<br />Binnen dit gezin is dan bijvoorbeeld de partner onbekend, doch er zijn al wel een ouder en kinderen die gezamenlijk een gezin vormen.<br />Let op: De huidige persoon zal in dat gezin de plaats innemen van een eventueel bestaande partner. Alle bestaande koppelingen in het gezin met huwelijksgegevens, kinderen, etc. blijven behouden.<br />Als u op deze koppeling heeft geklikt, kunt u in een nieuw venster de ID van het gezin opgeven of deze met de zoekfunctie selecteren.<br /><br />Wilt u een <i>nieuw</i> gezin vormen, kies dan: \"Nieuwe partner toevoegen\".";
$pgv_lang["add_husband_help"]			= "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Hiermee kunt u een nieuwe persoon toevoegen als partner voor de persoon bovenaan het scherm. U vormt hierdoor een nieuw gezin<br /><br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen. ";
$pgv_lang["link_wife_help"]			= "~KOPPEL DEZE PERSOON AAN EEN BESTAAND GEZIN ALS: PARTNER~<br /><br />Met deze functie kunt u de huidige persoon toevoegen als partner in een <i>bestaand</i> gezin.<br />Binnen dit gezin is dan bijvoorbeeld de partner onbekend, doch er zijn al wel een ouder en kinderen die gezamenlijk een gezin vormen.<br />Let op: De huidige persoon zal in dat gezin de plaats innemen van een eventueel bestaande partner. Alle bestaande koppelingen in het gezin met huwelijksgegevens, kinderen, etc. blijven behouden.<br />Als u op deze koppeling heeft geklikt, kunt u in een nieuw venster de ID van het gezin opgeven of deze met de zoekfunctie selecteren.<br /><br />Wilt u een <i>nieuw</i> gezin vormen, kies dan: \"Nieuwe partner toevoegen\".";
$pgv_lang["add_wife_help"]			= "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Hiermee kunt u een nieuwe persoon toevoegen als partner voor de persoon bovenaan het scherm. U vormt hierdoor een nieuw gezin<br /><br />Als u op de koppeling heeft geklikt, krijgt u een nieuw scherm, waarop u zoveel mogelijk gegevens van de persoon dient in te vullen. ";
$pgv_lang["add_new_parent_help"]		= "#pgv_lang[multiple_help]#<br />~VADER OF MOEDER TOEVOEGEN~<br /><br />In iedere genealogie zullen vele personen voorkomen zonder gegevens over de ouders. In dat geval vindt u, op het detailscherm personen om alsnog ouders toe te voegen. U vindt deze koppelingen op de tab \"Verwanten\", waar u kunt kiezen om een vader of een moeder toe te voegen.<br /><br />Let op: Hiermee kunt u alleen <b>nieuwe</b> personen als vader of moeder toevoegen. Als u een <b>bestaande</b> persoon wilt toevoegen als vader of moeder, moet u de koppelingen <b>#pgv_lang[link_as]##pgv_lang[child]#</b> gebruiken, die u onderaan dezelfde pagina aantreft.";

//-- Add Facts
$pgv_lang["add_facts_help"]			= "~NIEUW FEIT TOEVOEGEN~<br /><br />Naast de naam kunnen van een persoon meerdere gegevens bekend zijn, zoals geboortedatum en -plaats, beroepen, woonplaatsen, etc. Met deze functie kunt u die aan de persoon toevoegen.<br />Als u het feit heeft geselecteerd in het selectievenster en op \"Toevoegen\" heeft geklikt, kunt u de nadere gegevens verder invullen.<br />";
$pgv_lang["add_custom_facts_help"]		= "~SPECIAAL FEIT TOEVOEGEN~<br /><br />Als het feit, dat u wilt toevoegen, niet in het standaard lijstje met feiten voorkomt, kunt u zelf een feit definiëren.<br />Dit gaat op dezelfde wijze als het toevoegen van een standaardfeit, zij het dat u de aanduiding van het feit eveneens moet invoeren. Dit doet u in het bovenste vakje: <b>#pgv_lang[type]#</b><br />";
$pgv_lang["add_note_help"]			= "#pgv_lang[multiple_help]#<br />~VOEG NOTITIE TOE~<br /><br />Hiermee kunt u een notitie toevoegen aan de persoon. Als u op de knop klikt, verschijnt een venster waarin u de tekst van de notitie kunt intypen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_source_help"]			= "#pgv_lang[multiple_help]#<br />~VOEG BRONVERMELDING TOE~<br /><br />Door middel van deze koppeling kunt u een bron koppelen aan deze persoon. Zo'n koppeling heet een bronvermelding. Zodra u op deze knop heeft geklikt, verschijnt een venster, waarin u de bron kunt selecteren en zonodig informatie aan de vermelding kunt toevoegen. Let op: de bron zelf dient al op de website aanwezig te zijn!<br /><br />Als u een nieuwe bron wilt toevoegen, kunt u (per e-mail) contact opnemen met de beheerder van deze stamboom. Zodra deze de bron (al dan niet met afbeelding) heeft toegevoegd, kunt u de koppeling met deze persoon aanbrengen.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]			= "~VOEG KOPPELING MET MULTIMEDIA TOE~<br /><br />Door middel van deze functie kunt u een bestaand multimedia-item koppelen aan een persoon. Als u op deze knop klikt, verschijnt een volgend scherm, waarop u het desbetreffende multimedia-item kunt selecteren. Dit dient dus al op de website aanwezig te zijn!<br /><br />Als u een NIEUW multimedia-item wilt toevoegen, dient u dit eerst (per mail) toe te sturen naar de beheerder van deze stamboom (zie onderaan het scherm). Zodra het item op de website is geplaatst, kunt u het koppelen aan de gewenste persoon.";
$pgv_lang["add_facts_general_help"]		= "~Algemene informatie over toevoegen~<br />Als u een feit, notitie, bronvermelding of koppeling met een multimedia bestand heeft toegevoegd aan een of meerdere persoon, moet deze toevoeging nog worden goedgekeurd door een gebruiker, die acceptatierechten heeft gekregen van de beheerder van de website.<br />In de tussentijd is de wijziging door een gekleurde rand herkenbaar, zichtbaar voor gebruikers met wijzigrechten, maar niet zichtbaar voor gewone gebruikers.<br />Zodra de toevoeging is geaccepteerd verdwijnt de gekleurde rand en zijn de gegevens normaal zichtbaar.";

//--Edit User
$pgv_lang["edituser_my_account_help"]		="Op deze pagina kunt u uw instellingen en voorkeuren aanpassen.<br /><br />U kunt uw gebruikersnaam, wachtwoord, voorkeurstaal en e-mailadres aanpassen, alsmede de site-opmaak (thema) en de gewenste verzendwijze van berichten.<br /><br />Uw ID in de genealogie geeft aan, aan welke persoon u in de genealogie bent gekoppeld en wordt gebruikt voor beveiligingsdoeleinden. Om deze reden kunt u de instelling niet aanpassen.<br /><br />";
$pgv_lang["edituser_username_help"]		="~#pgv_lang[username]#~<br /><br />In dit vak kunt u uw gebruikersnaam aanpassen.<br /><br />In de gebruikersnaam kunt u de volgende tekens gebruiken: hoofdletters, kleine letters, verbindingsstreepje (-), liggend streepje (_) en cijfers. Gebruik <b>geen</b> spaties, punten en andere tekens.<br /><br />De gebruikersnaam is hoofdlettergevoelig. De gebruikersnaam \"Piet\" is dus een andere dan \"piet\".<br /><br />Let op: dit is de naam waarmee u zich aanmeldt bij PhpGedView, vergeet dus de volgende keer niet om de nieuwe naam te gebruiken.<br />";
$pgv_lang["edituser_fullname_help"]		="~#pgv_lang[fullname]#~<br /><br />In dit vak kunt u uw volledige naam aanpassen.<br />Let op: dit is de naam die andere gebruikers van deze site zien in ondermeer de gebruikerslijst voor berichten. Zorg er dus voor, dat u aan uw volledige naam herkenbaar bent voor anderen.<br />";
$pgv_lang["edituser_gedcomid_help"]		="~#pgv_lang[gedcomid]#~<br /><br />Dit koppelt u aan een persoon in de genealogie en wordt ondermeer gebruikt voor beveiligingsdoeleinden.<br />U kunt deze waarde niet veranderen, omdat hij is ingesteld door de beheerder.<br />Als u denkt dat u aan de verkeerde persoon in de genealogie bent gekoppeld, neemt u dan contact op met de beheerder.<br />";
$pgv_lang["edituser_rootid_help"]		="~#pgv_lang[rootid]#~<br /><br />Dit is de startpersoon van al uw overzichten.<br />Als u bijvoorbeeld klikt op \"Kwartierstaat\", krijgt u standaard de startpersoon geheel links op het scherm te zien. U kunt uiteraard op de kwartierstaat pagina daarna zelf een andere startpersoon selecteren.<br />In principe kunt u iedere persoon uit de genealogie als startpersoon kiezen, mits u daarvoor de rechten heeft.<br />";
$pgv_lang["edituser_password_help"]		="~#pgv_lang[password]#~<br /><br />Het is een goede gewoonte om uw wachtwoord periodiek te veranderen. Op die manier wordt de kans verkleind dat niet geautoriseerde personen van uw gebruikersnaam en wachtwoord gebruik maken.<br />Kies hier een wachtwoord van minimaal 6 karakters, liefst bestaand uit hoofdletters, cijfers, kleine letters en leestekens.<br /><b>Opmerking:</b><br />Het wordt aangeraden om de leestekens ( \" en ' ) niet te gebruiken. Er is geen garantie voor goede werking bij het gebruik van deze leestekens.<br />Een langer wachtwoord dan 6 karakters mag natuurlijk ook worden gekozen.<br /><br />Let er wel op, dat het wachtwoord, evenals de gebruikersnaam, hoofdlettergevoelig is.<br /><br />Als u, als bestaande gebruiker, een van de andere instellingen wijzigt, is het niet nodig om opnieuw uw wachtwoord in te typen.<br />";
$pgv_lang["edituser_conf_password_help"]	="~#pgv_lang[confirm]#~<br /><br />Als u een wachtwoord heeft ingetypt, moet u deze hier nogmaals intypen.<br />Dit zorgt ervoor, dat er niet per ongeluk typefouten in het wachtwoord voorkomen, waardoor u niet meer kunt aanmelden.<br />Als de twee ingetypte wachtwoorden verschillen, krijg u een foutboodschap.<br />Als u, als bestaande gebruiker, een van de andere instellingen wijzigt, is het niet nodig om opnieuw uw wachtwoord in te typen.<br />";
$pgv_lang["edituser_change_lang_help"]		="~#pgv_lang[change_lang]#~<br /><br />PhpGedView kan deze website in meerdere talen weergeven. Op deze plaats kunt u de door u gewenste taal instellen.<br />";
$pgv_lang["edituser_email_help"]		="~#pgv_lang[emailadress]#~<br /><br />Het e-mailadres dat u hier invult, wordt gebruikt om berichten van PhpGedView heen te sturen, inclusief een eventueel nieuw wachtwoord, als u dit hebt vergeten. Het is dus belangrijk om uw e-mailadres hier correct in te vullen en het bij wijziging aan te passen.<br />";
$pgv_lang["edituser_user_theme_help"]		="~#pgv_lang[user_theme]#~<br /><br />Deze PhpGedView website kunt u verschillende uiterlijken geven. Zo'n uiterlijk is vastgelegd in een thema. In het thema zijn bijvoorbeeld de schermkleuren en -indeling, lettertypes etc. bepaald.<br />U kunt de verschillende beschikbare thema's uitproberen en degene die u het meeste aanstaat, hier instellen.<br />Iedere keer, dat u zich opnieuw aanmeldt, wordt de website in het door u gekozen thema weergegeven.<br />";
$pgv_lang["edituser_contact_meth_help"]		="~#pgv_lang[user_contact_method]#~<br />Via het berichtensysteem van PhpGedView kunnen berichten op verschillende manieren worden getransporteerd.<br />Hoe berichten worden <b>verzonden</b> wordt ingesteld door de beheerder.<br />De wijze waarop u berichten <b>ontvangt</b> wordt door u zelf ingesteld.<br />U heeft keuze uit de volgende mogelijkheden.";
$pgv_lang["mail_option1_help"]			="Het interne PhpGedView berichtensysteem wordt gebruikt en er worden geen e-mailberichten verzonden.<br />U ontvangt uitsluitend interne berichten van andere gebruikers.<br />De berichten kunt u bekijken in het berichtenvak van uw persoonlijke MyGedView pagina<br />";
$pgv_lang["mail_option2_help"]			="Dit werkt zoals #pgv_lang[messaging]#, met een toevoeging: een kopie van de berichten wordt eveneens verzonden naar uw e-mailadres. Dit is het adres dat u in uw gebruikersgegevens heeft opgegeven.<br />Deze verzendwijze wordt standaard gehanteerd.<br />";
$pgv_lang["mail_option3_help"]			="U ontvangt uitsluitend berichten op uw e-mailadres.<br />Andere gebruikers kunnen u geen berichten sturen via het interne berichtensysteem.<br />";
$pgv_lang["mail_option4_help"]			="Met deze optie ontvangt u op geen enkele wijze een bericht.<br />";

//-- Add User
//

//-- Admin
$pgv_lang["admin_help"]				="Op deze pagina bevinden zich de beheerfuncties. Hiermee kunt u informatie krijgen over het functioneren van de website, documentatie inzien of wijzigingen aanbrengen in de configuratie van PhpGedView.<br /><br />In de balk boven het menu zijn de versie van PhpGedView en de datum/tijd van de webserver zichtbaar<br />Tevens is mogelijk een melding zichtbaar, dat gebruikers schrijfrechten hebben op uw config.php bestand. Als u klaar bent met de functie \"instellingen\", dient u de bestanden op uw website op alleen-lezen in te stellen, behalve de index-map. Daar dienen gebruikers ook schrijfrechten te hebben.<br />Het wijzigen van rechten moet u met de hand uitvoeren, omdat hiervoor in PhpGedView geen voorziening is.<br /><br />De volgende functies zijn in dit menu voorhanden:<br /><br /><i>README DOCUMENTATIE</i><br />Dit is een koppeling naar het Readme.txt bestand van PhpGedView. Hierin treft u de voor de instellingen benodigde informatie aan.<br /><br /><i>PHPGEDVIEW GEBRUIKERSHANDBOEK</i><br />Dit handboek beschrijft stapsgewijs, hoe u PhpGedView kunt installeren. Tevens wordt ingegaan op de diverse configuratie-instellingen.<br /><br /><i>INSTELLINGEN</i><br />Met deze optie stelt u de basiswaarden van PhpGedView in, zoals de te gebruiken database. Het maken van deze instellingen is de eerste stap in het installatieproces.<br /><br/ >BEHEER GEDCOM-BESTANDEN EN PRIVACY-INSTELLINGEN</i><br />Met deze functie kunt u de inhoud van PhpGedView beheren: de genealogieën. U kunt GEDCOM-bestanden importeren, exporteren of zelfs een nieuw bestand aanmaken, om dit met behulp van PhpGedView te vullen.<br />Ook stelt u hier de privacy-instellingen in.<br /><br /><i>UPLOADEN MEDIABESTANDEN</i><br />Hiermee kunt u mediabestanden en de bijbehorende miniatuurweergaven van uw lokale PC naar de webserver transporteren.<br /><br /><i>BEHEER GEBRUIKERS</i><br />Deze site heeft minimaal één gebruiker: de beheerder. Of u meer gebruikers heeft, hangt af van het gebruik van de website. Zodra u toegang gaat verlenen op groeps- of persoonsniveau, heeft u meer gebruikers nodig. Personen kunnen zo'n gebruikersnaam zelf aanvragen, of u kunt ze handmatig aanmaken. In alle gevallen dient de beheerder een aantal aanvullende gegevens in te voeren, alvorens er met een gebruiker gewerkt kan worden.<br /><br /><i>MIGREREN GEBRUIKERSINFORMATIE</i><br />Met deze functie kunt u alle gebruikersgegevens overzetten van SQL- naar indexmodus en vice versa.<br /><br /><i>BEWERK EN CONFIGUREER DE TAALBESTANDEN</i><br />PhpGedView ondersteunt verschillende talen. Alle tekst in PhpGedView is daarom in taalbestanden vastgelegd.<br />Met deze functie kunt u vertalingen aanpassen en zelfs nieuwe talen toevoegen.<br /><br /><i>GEGEVENS SAMENVOEGEN</i><br />Hiermee kunt u de gegevens van twee gezinnen, personen of bronnen samenvoegen, wanneer deze blijken een en dezelfde te zijn.<br /><br /><i>TOON PHP-INFO</i><br />Deze functie toont technische informatie over PHP op uw webserver, en kan gebruikt worden voor foutonderzoek.<br /><br /><i>BEKIJK LOG-BESTANDEN</i><br />PhpGedView legt belangrijke bewerkingen, zoals aanmelden, toevoegen van gebruikers, etc. vast in een log-bestand. Met deze functie kunt u de inhoud daarvan bekijken.<br />";

//-- User Admin
$pgv_lang["useradmin_help"]			="~BEHEER GEBRUIKERS~<br /><br />Op deze pagina kunt u gebruikers verwijderen, wijzigen en aanmaken.<br />Gebruikers dienen om de toegang tot uw site te regelen, er privacy-instellingen aan te relateren en het voor personen mogelijk te maken om de site op henzelf afgestemd te laten functioneren. Denk bij dit laatste aan de MyGedView pagina en de standaard-startpersoon voor overzichten.<br /><br />Door op de vraagtekens achter de verschillende onderwerpen te klikken, kunt u per onderwerp nadere informatie krijgen.<br />Als de vraagtekens niet zichtbaar zijn, controleer dan in het menu Help of de contextuele help is ingeschakeld.<br /><br />In een aantal gevallen is geen aparte helpinformatie voor de beheerder beschikbaar. U ziet dan de melding:";
$pgv_lang["useradmin_gedcomid_help"]		="~GEDCOM INDI RECORD ID~<br /><br />Dit is het individual-ID, waarmee de desbetreffende gebruiker in de genealogie voorkomt. Het is van belang bijvoorbeeld voor privacy-instellingen, waarbij een gebruiker alleen de gegevens van directe familie mag zien. Ook is het de startpersoon voor \"Mijn kwartierstaat\" en \"Mijn persoon\" op de persoonlijke MyGedView pagina van de gebruiker.<br /><br />Voor iedere genealogie kunt u het ID voor de gebruiker instellen.<br />Als de gebruiker niet in de genealogie voorkomt, kunt u het veld leeg laten.";
$pgv_lang["useradmin_rootid_help"]		="~STARTPERSOON VAN DE KWARTIERSTAAT~<br /><br />Voor iedere genealogie kunt u een <b>startpersoon</b> opgeven voor een gebruiker.<br />Deze startpersoon wordt dan de persoon, die standaard bij de kwartierstaat en de nakomelingen wordt getoond.<br /><br />Als dit veld leeg wordt gelaten, wordt het ID gebruikt, wat bij de GEDCOM-configuratie is opgegeven.<br /><br />De gebruiker kan de startpersoon zelf altijd aanpassen.";
$pgv_lang["useradmin_can_admin_help"]		="~GEBRUIKER MAG BEHEREN~<br /><br />Als deze optie wordt ingeschakeld, krijgt de gebruiker alle beheerderrechten binnen PhpGedView.<br />Hij/zij kan daarmee alle instellingen veranderen, wijzigingen doorvoeren, etc.<br />Doorsnee gebruikers zullen daarom deze rechten nooit toebedeeld krijgen.<br /><br />Het toekennen van beheerderrechten geldt alleen binnen PhpGedView. Met deze optie worden geen rechten toegekend op niveau van de webserver, databases, etc.";
$pgv_lang["useradmin_can_edit_help"]		="~GEBRUIKER MAG WIJZIGEN~<br /><br />Aan iedere gebruiker op deze website kunnen rechten worden toegekend om wijzigingen aan te brengen in een bepaalde genealogie. Per genealogie kunt u de volgende waarden voor deze gebruiker instellen:<br /><br /><b>Geen</b> beperkt de rechten van de gebruiker tot het alleen raadplegen van de gegevens waarvoor geen privacybeperkingen gelden.<br /><br /><b>Toegang</b> geeft de gebruiker de mogelijkheid om privacybeschermde gegevens te zien. De gebruiker mag niets wijzigen.<br /><br /><b>Wijzig</b> geeft aan dat deze gebruiker weliswaar wijzigingen mag aanbrengen en toevoegingen mag doen op deze genealogie, maar dat deze moeten worden goedgekeurd door een (andere) gebruiker, die over <b>Accepteer</b> rechten beschikt.<br /><br /><b>Accepteren</b> geeft de gebruiker het recht om zowel wijzigingen als toevoegingen aan te brengen, als om deze (van zichzelf en van anderen) voor deze genealogie goed te keuren.<br /><br /><b>Beheren</b> geeft gebruikers beheerrechten, waardoor zij de instellingen en privacy voor deze genealogie mogen wijzigen.<br /><br />Aan beheerders worden automatisch <b>Beheren</b> rechten toegekend.";
$pgv_lang["useradmin_verified_help"]		="~REGISTRATIE BEVESTIGD~<br /><br />Deze optie heeft betrekking op het aanvragen en aanmaken van een nieuwe gebruikersnaam. Hiervoor zijn twee mogelijkheden:<br /><br />De gebruiker vraagt via PhpGedView een gebruikersnaam aan.<br />Dit gaat in drie stappen:<br />1. De gebruiker vraagt een gebruikersnaam aan. De gebruikersnaam wordt geregistreerd in PhpGedView, en de gebruiker krijgt een e-mail met een verificatiecode.<br />2. De gebruiker verifieert zijn aanvraag door deze met behulp van de code te bevestigen. In Gebruikersbeheer wordt bij zijn gebruikersnaam het vinkje \"Bevestigd door gebruiker\" aangezet.<br />3. Na een e-mailbericht keurt de beheerder de aanvraag goed, door de optie \"Goedgekeurd door beheerder\" aan te vinken.<br />Hierna kan de gebruiker zich aanmelden.<br /><br />De beheerder maakt de gebruikersnaam aan. De desbetreffende opties zijn dan al automatisch aangevinkt.";
$pgv_lang["useradmin_verbyadmin_help"]		="~REGISTRATIE GOEDGEKEURD~<br /><br /><br />Als de gebruiker via PhpGedView een gebruikersnaam heeft aangevraagd, is de goedkeuring door de beheerder de laatste stap in dit proces.<br /><br />Zodra u de aanmelding heeft goedgekeurd, ontvangt de gebruiker een e-mailbericht, dat de aanvraag is goedgekeurd en hij/zij zich kan aanmelden met de gekozen gebruikersnaam en wachtwoord.";
$pgv_lang["useradmin_edit_user_help"]		="~GEBRUIKER WIJZIGEN~<br /><br />Deze optie wordt door de beheerder gebruikt om de gegevens van een gebruiker te wijzigen. De pagina komt grotendeels overeen met die voor het toevoegen van een gebruiker, en met de pagina die de gebruiker zelf krijgt voor het wijzigen van zijn gegevens.";
$pgv_lang["useradmin_visibleonline_help"]		= "~ZICHTBAAR VOOR ANDEREN ALS AANGEMELD~<br /><br />Als deze optie is ingeschakeld, kan de desbetreffende gebruiker zien welke andere gebruikers zijn aangemeld. Ook is hij zichtbaar voor anderen. Als dit ongewenst is, kunt u de optie uitschakelen, maar andere gebruikers zijn voor u dan ook niet meer zichtbaar.";
$pgv_lang["useradmin_editaccount_help"]			= "~STA GEBRUIKER TOE OM GEBRUIKERSGEGEVENS TE WIJZIGEN~<br /><br />Als deze optie is ingeschakeld, is de desbetreffende gebruiker in staat om de eigen informatie aan te passen. Met de optie uitgeschakeld is dit niet het geval.<br />Dit stelt u in staat om gebruikers voor algemeen gebruik te definiëren, zonder dat een van de gebruikers de gegevens (zoals wachtwoord) kan aanpassen.";

//-- Upgrade Utility
$pgv_lang["how_upgrade_help"]			= "~DE OPWAARDEERMODULE~<br /><br />De opwaardeermodule zorgt voor het aanpassen van uw huidige versie van PhpGedView met de programma's uit de nieuwe versie die u heeft gedownload.<br /><br /><b>Nieuwe versie downloaden</b><br />Een nieuwe versie kan direct worden verkregen via http://sourceforge.net/projects/phpgedview/. Ook kunt het opwaardeerprogramma laten controleren of een nieuwe versie voorhanden is. Als dat het geval is, worden de beschikbare versies getoond. Dit zijn dan of zip- of gz-bestanden, of beide.<br /><br /><b>Wat wordt opgewaardeerd</b><br /><br /><i>PhpGedView</i><br />Dit waardeert alle basisprogramma's op van PhpGedView, exclusief config.php, privacy.php en authenticate.php. Dit past indien nodig eveneens de images-map aan.<br /><br /><i>Indexbestanden</i><br />Dit past de map /index aan. Let op: bestaande bestanden worden overschreven!<br /><br /><i>Talen</i><br />Dit past de /languages map aan.<br /><br /><i>Thema's</i><br />Dit past de /themes map aan. Let op: alle aanpassingen die u zelf aan de thema's heeft gemaakt, worden overschreven.<br /><br /><i>Configuratiebestand</i><br />Dit controleert uw huidige configuratiebestand en past het aan met wijzigingen die in het nieuwe configuratiebestand worden gevonden. Dit zorgt ervoor, dat u over de laatste versie van het configuratiebestand beschikt, maar uw eigen instellingen behoudt.<br /><br /><i>Privacybestand</i><br />Dit controleert uw huidige privacybestand(en) en past ze aan met wijzigingen die in het nieuwe privacybestand worden gevonden. Dit zorgt ervoor, dat u over de laatste versie van het privacybestand beschikt, maar uw eigen instellingen behoudt.<br /><br /><i>Handleidingen</i><br />Dit past de /doc map aan.<br /><br /><i>Backup maken</i><br />Dit maakt een backup van de oude bestanden in de /backup map.<br /><br /><b>Hoe opwaarderen</b><br /><br />1. Selecteer de onderdelen die u wilt opwaarderen.<br /><br />2. Klik op Opslaan<br /><br />De voortgang wordt op het scherm weergegeven.";

//--             G E D C O M
$pgv_lang["add_upload_gedcom_help"]		="~UPLOADEN EN TOEVOEGEN GEDCOM-BESTAND~<br /><br />Om een GEDCOM-bestand in PhpGedView op te nemen, dient het bestand op de website aanwezig te zijn. Dit kunt u op twee manieren doen:<br />Met behulp van een FTP programma en <br />met de functie \"Uploaden GEDCOM-bestand\".<br /><br />De functie \"Toevoegen GEDCOM-bestand\" ligt in het verlengde hiervan: hiermee start u het daadwerkelijk proces om het bestand in PhpGedView op te nemen.<br />Als het GEDCOM-bestand al op de PhpGedView website aanwezig is, kunt u de upload-stap dus achterwege laten.<br />";
$pgv_lang["gedcom_configfile_help"]		="~INSTELLINGENBESTAND~<br /><br />Dit zijn de map- en bestandsnaam van het bestand, waarin alle instellingen van de desbetreffende genealogie staan.<br />";
$pgv_lang["default_gedcom_help"]		="~STANDAARD GEDCOM~<br /><br />Als u een of meer GEDCOM-bestanden in PhpGedView heeft opgenomen, kunt u hier instellen welke genealogie <b>standaard</b> wordt getoond aan gebruikers, die zich niet hebben aangemeld.<br />Aangemelde gebruikers kunnen zelf kiezen, welke genealogie zij standaard te zien krijgen.<br />";
$pgv_lang["delete_gedcom_help"]			="~VERWIJDER GEDCOM-BESTAND~<br /><br />Dit verwijdert alle records uit de PhpGedView-bestanden, die uit dit GEDCOM-bestand afkomstig zijn. NIET verwijderd worden het GEDCOM-bestand zelf (xxxx.ged) en het bijbehorende bestand met GEDCOM-instellingen voor PhpGedView.<br /><br />Als u later dit GEDCOM-bestand toch weer wilt toevoegen, kunt u direct de optie \"GEDCOM-bestand toevoegen\" kiezen, het GEDCOM-bestand bevindt zich dan nog steeds in de map waar u het eerder heeft geplaatst en hoeft dus niet meer ge-upload te worden.";
//
$pgv_lang["add_gedcom_help"]			="~GEDCOM-BESTAND TOEVOEGEN~<br /><br />In deze stap van het proces geeft u op, welk GEDCOM-bestand moet worden geïmporteerd en welke naam het krijgt in PhpGedView.<br />Het GEDCOM-bestand moet al op de server staan, is dit nog niet zo, dan kunt u het met behulp van de functie \"Upload GEDCOM-bestand\" eerst op de juiste plaats neerzetten.<br />Als u de velden heeft ingevuld, kunt u op \"Toevoegen\" klikken om naar de volgende stap te gaan.<br />";
$pgv_lang["add_new_gedcom_help"]		="~NIEUW GEDCOM-BESTAND MAKEN~<br /><br />Geef hier aan, onder welke naam het nieuwe GEDCOM-bestand moet worden opgeslagen. De extensie (.ged) mag weggelaten worden. Zodra u op \"Toevoegen\" heeft geklikt, gaat u naar de volgende stap van het proces, waarbij u een aantal gegevens over het nieuwe bestand moet invullen.<br />";
$pgv_lang["download_gedcom_help"]		="~DOWNLOAD GEDCOM-BESTAND~<br /><br />U kunt een genealogiebestand in PhpGedView als GEDCOM-bestand downloaden naar uw PC.<br />Allereerst dient u te kiezen, welk formaat het GEDCOM-bestand dient te zijn. Standaard is dit UTF-8, maar het formaat ANSI (ISO-8859-1)is ook mogelijk. Raadpleeg hiervoor de documentatie van uw genealogiepakket.<br /><br />Hierna krijgt u het gebruikelijke download-venster van uw Internetverkenner, om aan te geven of en waar u het GEDCOM-bestand wilt opslaan.<br />Als het downloaden gereed is, kunt u met de \"Vorig\" knop in uw Internetverkenner terug naar het GEDCOM-menu.<br />";
$pgv_lang["edit_gedcoms_help"]			="~BEHEER GEDCOM-BESTANDEN~<br /><br />Op dit scherm bevinden zich alle functies om de verschillende genealogieën en bijbehorende GEDCOM-bestanden te beheren.<br />De volgende opties zijn beschikbaar:<br /><br /><i>ONDERHOUD HUIDIGE GEDCOM-BESTANDEN</i><br />In het vak, waar de GEDCOM-bestanden worden vermeld, kunt u kiezen uit een aantal functies. Voor helpinformatie hierover kunt u klikken op de vraagtekens achter de kolomtitels.<br /><br /><i>GEDCOM TOEVOEGEN</i><br />Hiermee kunt u een GEDCOM-bestand, dat al op de website aanwezig is, toevoegen aan PhpGedView. Na het instellen en importeren van dit bestand wordt de genealogie beschikbaar in PhpGedView.<br /><br /><i>UPLOAD GEDCOM-BESTAND</i><br />Met deze functie kunt u een GEDCOM-bestand van uw eigen PC uploaden naar de webserver.<br /><br /><i>NIEUW GEDCOM-BESTAND MAKEN</i><br />Als u een geheel nieuwe genealogie wilt beginnen, kiest u voor deze optie. Er wordt dan een leeg GEDCOM-bestand aangemaakt, waarna u de normale procedure voor het toevoegen van een GEDCOM-bestand doorloopt.<br />Let op: Vanwege technische redenen wordt er een persoon aan de genealogie toegevoegd. Deze kunt u later weer uit de genealogie verwijderen.<br />#pgv_lang[more_help]#<br />";
$pgv_lang["edit_config_gedcom_help"]		="~INSTELLEN PHPGEDVIEW - GEDCOMGEGEVENS~<br /><br />Per genealogie in PhpGedView moet een aantal gegevens worden ingevoerd en keuzes gemaakt. Op die manier wordt o.a. bepaald, hoe de genealogie aan de gebruiker wordt getoond.<br />Pas als deze gegevens zijn ingevoerd, kan een GEDCOM-bestand daadwerkelijk worden geïmporteerd of aangemaakt.<br />De ingevoerde waarden worden per GEDCOM-bestand opgeslagen in de index-map op de site.<br /><br />Onderaan de pagina kunt u kiezen voor \"Opslaan\", waarmee de waarden worden weggeschreven, of voor \"Reset\". Hiermee worden alle door u gewijzigde instellingen weer teruggezet naar hun oude waarde.<br /><br />Bij ieder onderwerp op deze pagina kunt op het vraagteken klikken om meer helpinformatie te krijgen.<br />";
$pgv_lang["import_gedcom_help"]			="~IMPORTEREN GEDCOM-BESTAND</b>In de meeste gevallen is het importeren van een GEDCOM-bestand een stap in de procedure van toevoegen of uploaden.<br /><br />Deze stappen zijn in een logische volgorde en moeten worden voltooid om met het bestand te kunnen werken.<br />Als u niet de gehele procedure heeft afgewerkt, ziet u een <b>waarschuwing</b>. In dat geval dient u eerst de koppeling aan te klikken om het bestand te importeren.<br /><br />In alle gevallen worden de configuratie-instellingen gehanteerd, die u eerder heeft opgegeven.<br />De huidige informatie uit het GEDCOM-bestand zal, bij her-import, worden overschreven met de nieuwe inhoud.<br />";
$pgv_lang["upload_gedcom_help"]			="~UPLOAD GEDCOM-BESTAND~<br /><br />Selecteer hier een GEDCOM-bestand, dat vanaf uw lokale PC naar de webserver moet worden getransporteerd. Gebruik eventueel de \"Browse\" knop om er op uw lokale schijf naar te zoeken en het te selecteren. Geef hier in ieder geval het gehele pad op en de bestandsnaam inclusief extensie (.ged).<br />Zodra u op \"Upload GEDCOM-bestand\" heeft geklikt, wordt het bestand op de server geplaatst. Daarna gaat u naar de volgende stap van het proces, waarbij u een aantal gegevens over het nieuwe bestand moet invullen.<br /><br />";
$pgv_lang["validate_gedcom_help"]		="~VALIDEREN GEDCOM-BESTAND~<br /><br />In deze stap wordt een aantal controles uitgevoerd op het GEDCOM-bestand. Tevens kunt u zelf aangeven dat een of meer bewerkingen moeten plaatsvinden.<br /><br />Automatische controles zijn:<br /><br /><b>Datumcontrole</b><br />Hierbij wordt gecontroleerd, of de datums voldoen aan het GEDCOM-formaat. Waar mogelijk, vindt automatisch herstel plaats. Het programma kan u vragen om zelf het gebruikte datumformaat aan te geven als twijfel bestaat, bijvoorbeeld bij de keuze YYY-MM-DD of YYY-DD-MM<br /><br /><b>Controle op gebruik plaatsnaam</b><br />Gecontroleerd wordt op onjuist gebruik van de GEDCOM-tag PLAC voor het vastleggen van informatie. Dit komt soms voor bij CAST, DSCR, EDUC, IDNO, NATI, NCHI, NMR, OCCU, PROP, RELI, SSN en TITL tags. Het programma corrigeert dit automatisch. Bijvoorbeeld:<br />n SSN<br />n PLAC 123-45-6789<br />wordt gewijzigd in<br />n SSN 123-45-6789.<br /><br /><b>Mac regeleinden</b><br />De regeleinden van GEDCOM-bestanden, afkomstig van het Macintosh platform, worden automatisch gecorrigeerd.<br /><br /><b>Gebruikte karakterset</b><br />Als het programma een karakterset detecteert waarvoor conversie nodig is naar UTF-8, zal het de conversie automatisch uitvoeren.<br /><br />De handmatige keuzes zijn op het scherm zichtbaar. U kunt op de vraagtekens klikken om daar meer informatie over te krijgen.<br />";
$pgv_lang["convert_ansi2utf_help"]		="~CONVERSIE ANSI NAAR UTF-8~<br /><br />De automatische conversie (zie help bij de pagina) werkt alleen, als in het GEDCOM-bestand de tag CHAR is opgenomen (bijvoorbeeld 1 CHAR ANSI). Is dit niet het geval, dan moet u handmatig aangeven dat conversie noodzakelijk is.<br />";
$pgv_lang["detected_ansi2utf_help"]		="~ANSI CODERING GEVONDEN~<br /><br />Het GEDCOM-bestand dat nu wordt gevalideerd, is gecodeerd in ANSI.<br /><br />Het wordt sterk aanbevolen dat het bestand wordt geconverteerd naar UTF-8 codering.<br /><br />#pgv_lang[convert_ansi2utf_help]#";
$pgv_lang["detected_date_help"]			="~FOUTIEF DATUMFORMAAT GEVONDEN~<br />DATUMFORMAAT WORDT AANGEPAST<br /><br />De GEDCOM 5.5 standaard voor het datumformaat is DD MMM YYYY (bijvoorbeeld 01 JAN 2004). Ook PhpGedView hanteert deze standaard.<br />Als u na de GEDCOM-validatie de bovenstaande melding ziet, kan het programma de datums converteren naar het standaard formaat.<br /><br />U heeft nog de mogelijkheid te kiezen tussen <b>dag voor maand </b> (DD MMM YYYY) en <b>maand voor dag</b> (MMM DD YYYY).<br />Wij raden u aan om voor de standaard (eerste) optie te kiezen.";
$pgv_lang["addmedia_tool_help"]			="~TOEVOEGEN MULTIMEDIA~<br /><br />Hiermee kunt u multimediabestanden koppelen aan personen in een GEDCOM-bestand. Deze functie is met name bedoeld voor gevallen, waarin uw genealogiepakket zelf niet in staat is om koppelingen met multimedia vast te leggen of te exporteren. Een voorbeeld is Family TreeMaker.<br /><br />Door middel van de functie \"Toevoegen multimedia\", kunt u los van uw genealogiepakket koppelingen vastleggen. Ook in PhpGedView worden deze koppelingen apart bewaard, zodat u, als u het GEDCOM-bestand opnieuw importeert, de eerder gemaakte koppelingen weer beschikbaar heeft.<br />Op die manier kunt u uw eigen genealogiepakket blijven gebruiken, terwijl de toevoegingen in PhpGedView steeds blijven bestaan.In het nieuwe venster dient u hiervoor de gegevens in te voeren.<br />De opgeslagen koppelingen blijven bewaard, ook als u het GEDCOM-bestand weer uit PGV verwijdert of opnieuw importeert.<br /><br />Om de functie te gebruiken, kiest u bij stap 3 van het importproces voor \"Toevoegen Multimedia\". Er verschijnt dan een apart invoervenster.<br />Dit vult u, voor iedere nieuwe koppeling, als volgt in:<br /><br /><i>#pgv_lang[gedcomid]#</i> - Dit is het kenmerk van de persoon, waarmee u de koppeling wilt maken, bijvoorbeeld \"I101\".<br /><br /><i>Extern bestand</i> - De bestandsnaam van het multimediabestand. Het bestand dient aanwezig te zijn in de multimediamap.<br /><br /><i>#pgv_lang[extension]#</i> - De extensie (het type) multimediabestand.<br /><br /><i>#pgv_lang[highlighted]#</i> - Hiermee bepaalt u, of deze afbeelding wordt gebruikt in de weergave van bijvoorbeeld de kwartierstaat of de persoonlijke detail, als primaire afbeelding bij de naam van de persoon.<br /><br /><i>#pgv_lang[title]#</i> - De zelf te kiezen naam of omschrijving van de afbeelding in het bestand.<br /><br /><i>#pgv_lang[order]#</i> - Plaats in de volgorde, waarin de multimedia wordt getoond op het tabblad \"Multimedia\" van de details van de persoon.<br /><br /><i>#pgv_lang[gedcom_file]#</i> - De omschrijving van het GEDCOM-bestand, waarin de gekozen persoon voorkomt.<br /><br />Als u klaar bent met invullen, klik dan op #pgv_lang[add_media_button]#. Hiermee worden de wijzigingen toegevoegd aan de lijst boven het invulscherm.<br />Na het invoeren van de laatste koppeling, klikt u op de koppeling \"Klik hier om de bovenstaande media-items toe te voegen aan het GEDCOM-bestand xxxx.ged\". Daarna sluit u het venster en kunt u doorgaan met importeren.<br /><br />Let op: Iedere keer, als u het GEDCOM-bestand opnieuw importeert, moet u de functie \"Toevoegen Multimedia\" kiezen. De lijst met items zal dan echter nog bestaan, zodat u slechts op de bovenstaande koppeling hoeft te klikken om deze toe te voegen aan het GEDCOM-bestand.<br /><br />";
$pgv_lang["change_indi2id_help"]		="~WIJZIG PERSOONS-ID...~<br /><br />PhpGedView koppelt instellingen zoals startpersoon en privacy-instellingen aan INDI-nummers van personen in het bestand. Als het GEDCOM-bestand daarna opnieuw wordt geïmporteerd, moeten de personen daarin dezelfde INDI-nummer toegekend gekregen hebben. Is dit niet het geval, dan verwijzen de instellingen naar verkeerde personen.<br />In zo'n geval moet u een persoonskenmerk kiezen dat wel stabiel is, d.w.z. dat bij export uit uw genealogiepakket steeds dezelfde waarde aan dezelfde persoon wordt toegekend. PhpGedView biedt de mogelijkheid om hiervoor de tags RIN of REFN te kiezen.<br />Kijk in de documentatie van uw genealogiepakket welke hiervoor in aanmerking komt, of probeer het uit door een aantal malen een GEDCOM-bestand te exporteren en in het bestand te kijken, welke tags een stabiele waarde houden.<br /><br />";
$pgv_lang["edit_privacy_help"]			="Op deze pagina bevinden zich alle instellingen, die u ten aanzien van privacy voor deze genealogie kunt maken. Onder de menubalk kunt u zien, van welke genealogie u op dit moment de instellingen kunt wijzigen. De naam van het bijbehorende privacybestand wordt getoond in het formaat 'map/gedcomnaam_priv.php'.<br /><br />Met de beschikbare instellingen is er een grote verscheidenheid aan mogelijkheden om informatie voor gebruikers te verbergen of juist zichtbaar te maken. Het verdient aanbeveling om de beschikbare helpinformatie goed te bestuderen alvorens deze instellingen worden aangepast. Zie hiervoor de PhpGedView website.<br />";
$pgv_lang["invalid_header_help"]		= "~ONGELDIGE GEDCOM KOPREGEL~<br />Een GEDCOM-bestand moet beginnen met regel 0 HEAD. PhpGedView heeft gedetecteerd dat uw GEDCOM-bestand niet met 0 HEAD begint. Als u op \"Opschonen\" heeft geklikt, worden alle regels voor 0 HEAD uit uw GEDCOM-bestand verwijderd.<br /><br />Deze fout betekent meestal dat uw programma geen correct GEDCOM-bestand heeft gemaakt, of dat het bestand geen GEDCOM-bestand is.<br />Controleer of u het juiste bestand heeft ge-upload en of het begint met een 0 HEAD regel en eindigt met een 0 TRLR regel.";
$pgv_lang["macfile_detected_help"]		= "~MACINTOSH-BESTAND GEVONDEN~<br />PhpGedView heeft gedetecteerd dat uw GEDCOM-bestand van een Macintosh computer afkomstig is. Macintosh-bestanden gebruiken andere regeleinden (r) dan Unix- (n) en DOS/Windows-systemen (rn). De PhpGedView-functies zijn gebouwd voor Unix- en DOS/Windows-bestanden.<br />Als u op de \"Opschonen\"-knop klikt, wordt uw bestand geconverteerd naad een DOS/Windows-bestand.<br />";
$pgv_lang["cleanup_places_help"]		= "~OPSCHONEN PLAATSEN~<br />PhpGedView heeft gedetecteerd dat in uw GEDCOM-bestand plaatsnamen voorkomen waar dit niet is toegestaan. Veel genealogieprogramma's, zoals Family Tree Maker, genereren dit soort fouten. PhpGedView kan met deze GEDCOM-bestanden werken, maar in de locatieniveaus worden de plaatsnamen dan niet altijd correct weergegeven.<br /><br />Bijvoorbeeld kunnen in uw bestand de volgende regels voorkomen:<br />1 SSN<br />2 PLAC 123-45-6789<br />Volgens de GEDCOM-standaard zou dit moeten zijn:<br />1 SSN 123-45-6789<br /><br />Als u op \"Ja\" klikt, spoort PhpGedView deze fouten op en corrigeert ze.<br />";
$pgv_lang["empty_lines_detected_help"]	= "~LEGE REGELS GEVONDEN~<br />PhpGedView heeft lege regels gevonden in uw GEDCOM-bestand. Omdat deze regels fouten kunnen veroorzaken worden ze voor import uit het GEDCOM-bestand verwijderd.<br />";
$pgv_lang["skip_cleanup_help"]			= "~OPSCHONEN OVERSLAAN~<br />Het wordt sterk aanbevolen om PhpGedView uw GEDCOM-bestand te laten opschonen bij import, omdat anders bepaalde functies niet goed kunnen werken.<br /><br />Met deze knop kunt u het opschonen overslaan en het GEDCOM-bestand importeren zoals het is.<br />";

//-- Edit config
$pgv_lang["help_editconfig.php"]		="~INSTELLEN PHPGEDVIEW~<br /><br />Deze instellingen vormen de basis voor het functioneren van PhpGedView, en gelden voor de gehele website.<br />Zorg ervoor, dat u schrijfrechten heeft op het config.php bestand, zodat de ingegeven waarden weggeschreven kunnen worden.<br />Zorg er, als u SQL als database gebruikt, tevens voor dat er een lege database bestaat en een databasegebruiker, die over voldoende rechten beschikt.<br /><br />Verdere helpinformatie kunt u krijgen door op het vraagteken achter een onderwerp te klikken.<br />";

//-- GDBI changes
$pgv_lang["help_edit_merge.php"]		= "~#pgv_lang[merge_records]#~<br /><br />Op deze pagina kunt u de gegevens van twee personen, twee families of twee bronnen samenvoegen. Dit kan noodzakelijk zijn als u twee GEDCOM-bestanden heeft samengevoegd, waar dezelfde personen, families of bronnen in voorkomen.<br /><br />Het samenvoegen gaat in drie stappen.<br /><ul><li><b>Stap 1</b> Hier wordt u gevraagd om twee ID's in te voeren. De ID's moeten van dezelfde soort zijn: beide persoons-, gezins- of bron-ID's. Het is niet mogelijk om gegevens naar een ander soort ID over te brengen. In het vak \"Samenvoegen naar ID\" vult u de ID in die behouden of aangevuld moet worden. U kunt van de zoek-koppelingen gebruik maken om het ID op te zoeken. In het vak \"Samenvoegen van\" vult u het ID in waarvan gegevens worden overgenomen en dat daarna wordt verwijderd.</li><li><b>Stap 2</b> Hierin geeft u aan welke informatie van welke ID behouden moet blijven. Deze wordt samengevoegd en in het gekozen \"naar\" ID opgeslagen. Met de vinkjes geeft u aan wat u wilt behouden.</li><li><b>Stap 3</b> Hier wordt getoond wat het resultaat van het samenvoegen is. Net als het geval is met alle wijzigingen, worden ook deze pas definitief wanneer ze door een gebruiker met accepteer-rechten worden bevestigd.</li></ul><br />";

//-- Language Editor
$pgv_lang["lang_edit_help"]			="PhpGedView is een programma, dat onder de vlag van de open-source gemeenschap Sourceforge wordt ontwikkeld. Aan het PhpGedView project werken vele mensen uit verschillende landen mee, ondermeer om ervoor te zorgen, dat PhpGedView in verschillende talen beschikbaar komt.<br />Iedere bijdrage aan het verbeteren van het programma wordt van harte verwelkomd. Specifiek voor vertalingen kunt u in contact komen met het team via het vertalerforum. Als u op de desbetreffende koppeling klikt, komt u vanzelf op het forum terecht.<br /><br />Op deze pagina bevinden zich alle functies om de taalbestanden te bewerken. U kunt kiezen uit:<br /><br />";
$pgv_lang["language_to_edit_help"]		="#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[language_to_edit]#</b><br /><br />Hier kunt u de taal kiezen waarvan u de berichten wilt bewerken.";
$pgv_lang["file_to_edit_help"]			="#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[file_to_edit]#</b><br /><br />Hier kunt u het taalbestand kiezen dat u wilt bewerken. U kunt kiezen uit:<br /><br />lang.xx.php           - Algemeen taalbestand<br /><br />facts.xx.php          - Gebeurtenissenbestand<br /><br />configure_help.xx.php - Bestand met helpinformatie bij configuratie<br /><br />\"xx\" staat voor de taalcode van de door u gekozen taal en wordt automatisch geselecteerd.";
$pgv_lang["hide_translated_help"]		="#pgv_lang[edit_lang_utility]# >> <b>#pgv_lang[hide_translated]#</b><br /><br />Als u hier de waarde \"Ja\" kiest, krijgt u alleen de tekst te zien, die nog niet is vertaald en dus nog niet bestaat in het gekozen taalbestand.<br />Zodra u dan een vertaling heeft toegevoegd, is de boodschap niet meer zichtbaar in de lijst.<br /><br />De waarde \"Nee\" laat de gehele inhoud van het taalbestand zien.";
$pgv_lang["language_to_export_help"]		="#pgv_lang[export_lang_utility]# >> <b>#pgv_lang[language_to_export]#</b><br /><br />Hier kunt u de taal kiezen, waarvan u de berichten wilt exporteren.";
$pgv_lang["new_language_help"]			="#pgv_lang[compare_lang_utility]# >> <b>#pgv_lang[new_language]#</b><br /><br />Kies hier de taal waarmee de berichten van de andere taal worden vergeleken. Deze taal dient als bron voor de vergelijking.<br /><br />Voor het bijwerken van vertalingen moet u er rekening mee houden, dat deze allereerst worden aangebracht in de Engelse taalbestanden.";
$pgv_lang["old_language_help"]			="#pgv_lang[compare_lang_utility]# >> <b>#pgv_lang[old_language]#</b><br /><br />Kies hier de taal waarvan u de berichten wilt vergelijken met de taal in het andere keuzeveld.<br />Nadat u op \"Vergelijk\" heeft geklikt, krijgt u de verschillen te zien.<br /><br />Dit zijn:<br /><br /><b>Toevoegingen</b> die in de eerste taal aanwezig zijn maar niet in de tweede.<br /><br /><b>Verwijderingen</b> die niet meer in de eerste taal aanwezig zijn maar nog wel in de tweede.";
$pgv_lang["add_new_lang_help"]			="<b>#pgv_lang[add_new_language]#</b><br /><br />Met deze optie kunt u een taal aan PhpGedView toevoegen. Daarbij kunt u standaard instellingen geven voor landcodes, taalrichting, startdag van de week, tijdweergave, letters van het alfabet, etc.<br /><br />Als u een taal heeft toegevoegd, kun u deze instellingen met de functie \"wijzig\" aanpassen. Meer help vindt u onder de vraagtekens bij de desbetreffende instellingen.";
$pgv_lang["help_reportengine.php"]	= "~RAPPORTEN~<br />PhpGedView gebruikt XML-sjablonen om automatisch rapporten te genereren in PDF-formaat. De lijst van beschikbare rapporten wordt gemaakt aan de hand van de fysiek aanwezige XML-bestanden in de reports-map.<br />De eerste stap is het selecteren van een rapport. Daarna wordt gevraagd om informatie te geven die voor het vervaardigen van dat rapport noodzakelijk is, bijvoorbeeld een startpersoon of -gezin en of er wel of niet afbeeldingen moeten worden toegevoegd.<br />Als u hiermee klaar bent, kunt u klikken op \"#pgv_lang[view_report]#\" om het rapport op uw beeldscherm te bekijken, of \"#pgv_lang[download_report]#\" om het in PDF-formaat naar uw eigen computer te downloaden.";

//-- Help-contents
$pgv_lang["help_contents_head_help"]		= "<b>HELP INHOUD</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]		= "GEDCOM-informatie";
$pgv_lang["help_contents_gedcom_places"]	= "Locaties in het GEDCOM-bestand";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]	= "<b>INHOUDSOPGAVE HELP<br /><br />HELPONDERWERPEN BEHEERDER</b> toegevoegd aan het begin van de lijst.<br /><br />";
$pgv_lang["ah1_help"]				= "_Opwaarderen";
$pgv_lang["ah2_help"]				= "_Instellen PhpGedView";
$pgv_lang["ah3_help"]				= "_GEDCOM: Toevoegen en uploaden";
$pgv_lang["ah4_help"]				= "_GEDCOM: Instellingenbestand";
$pgv_lang["ah5_help"]				= "_GEDCOM: Standaard";
$pgv_lang["ah6_help"]				= "_GEDCOM: Verwijderen";
$pgv_lang["ah7_help"]				= "_GEDCOM: Toevoegen";
$pgv_lang["ah8_help"]				= "_GEDCOM: Nieuwe maken";
$pgv_lang["ah9_help"]				= "_GEDCOM: Downloaden";
$pgv_lang["ah10_help"]				= "_GEDCOM: Beheerpagina";
$pgv_lang["ah11_help"]				= "_GEDCOM: Instellen";
$pgv_lang["ah12_help"]				= "_GEDCOM: Importeren";
$pgv_lang["ah13_help"]				= "_GEDCOM: Uploaden";
$pgv_lang["ah14_help"]				= "_GEDCOM: Valideren";
$pgv_lang["ah15_help"]				= "_GEDCOM: Converteren van ANSI naar UTF-8";
$pgv_lang["ah16_help"]				= "_GEDCOM: Privacy instellingen";
$pgv_lang["ah17_help"]				= "_Gebruikersbeheer";
$pgv_lang["ah18_help"]				= "_Beheer";
$pgv_lang["ah19_help"]				="_GEDCOM: Toevoegen multimedia";
$pgv_lang["ah20_help"]				="_GEDCOM: Wijzig persoons-ID";
$pgv_lang["ah21_help"]				= "_Taalbestanden";
$pgv_lang["ah23_help"]				= "_Instellen ondersteunde talen";
$pgv_lang["ah24_help"]				= "_Migreren gebruikersinformatie (SQL <<-->> Indexmodus)";
$pgv_lang["ah25_help"]				= "_PhpGedView backup";
$pgv_lang["manage_media_help"]		= "~#pgv_lang[manage_media]#~<br /><br />Dit is de tweede stap in het beheren van multimediabestanden, als u onder de standaard multimediamap niveaus van mappen heeft gedefinieerd<br /><br />Als beheerder kunt u een mapstructuur maken om multimediabestanden in onder te brengen en georganiseerd te houden. Als u vanaf deze pagina mappen aanmaakt, worden eveneens mappen aangemaakt voor de miniweergaves en wordt een index.php bestand in de relevante mappen geplaatst.<br /><br />U kunt bestanden verplaatsen binnen de mappenstructuur met behulp van de koppeling \"Verplaats naar --->\". De miniweergave wordt dan eveneens verplaatst zodat consistentie tussen miniweergave en afbeelding bewaard blijft.<br /><br />Als u tijdens het uploaden geen miniweergave heeft opgegeven, en ook de mogelijkheid om deze aan te maken niet heeft gekozen, dan kunt u de miniweergave hier alsnog maken. Vink eerst het vakje \"Toon miniweergaves\" aan. Alle multimediabestanden waarvan geen miniweergave bestaat, hebben een koppeling \"Genereren miniweergave\". Als u deze aanklikt, wordt de miniweergave alsnog aangemaakt.<br /><br />";
$pgv_lang["simple_filter_help"]		= "~#pgv_lang[filter]#~<br /><br />Eenvoudig zoekfilter op basis van de ingevoerde letters. Jokertekens (* en ?) kunnen niet worden gebruikt.<br /><br />";
$pgv_lang["show_thumb_help"]		= "~#pgv_lang[show_thumbnail]#~<br /><br />Indien deze keuze wordt ingeschakeld, worden miniweergaves bij de bestandsnamen getoond.<br /><br />";
$pgv_lang["new_dir_help"]			= "~#pgv_lang[add_directory]#~<br /><br />Als beheerder kunt u een mappenstructuur aanmaken om uw multimediabestanden ingedeeld en georganiseerd te houden.<br />Als u deze functie gebruikt, worden eveneens mappen aangemaakt voor de miniweergaves en wordt een vereist index.php bestand in de mappen geplaatst.<br /><br />Klik op de koppeling om een nieuwe map te maken en type de mapnaam in het invoervak in.<br /><br />";
$pgv_lang["find_media_help"]		= "~#pgv_lang[find_media]#~<br /><br />Hiermee kunt u door de mappenstructuur zoeken om het multimedia-bestand te vinden waarmee u een koppeling wilt maken.<br /><br />";
$pgv_lang["alive_in_year_help"]		= "~#pgv_lang[alive_in_year]#~<br /><br />Dit toont de personen van wie PhpGedView kan bepalen, dat ze in een bepaald jaar in leven waren.<br /><br />Als voor een persoon datums zijn ingevoerd voor geboorte en overlijden, dan wordt de persoon als levend aangemerkt als het ingevoerde jaar daartussen ligt.<br /><br />Als er onvolledige of geen precieze informatie is, worden de volgende regels toegepast en wordt de persoon aangemerkt als \"misschien\":<br /><br /><ul><li>Bij ontbreken van een overlijdensdatum wordt de persoon geacht overleden te zijn na 120 jaar.</li><li>Als er een geboortedatum bekend is en de persoon als \"overleden na\"<br />- aangemerkt als \"levend\" voor de aangegeven datum.<br />- aangemerkt als \"misschien\" na de aangegeven datum.</li><li>Als een geboortedatum bekend is en de persoon als overleden voor:<br />- aangemerkt als \"overleden\" als het ingevoerde jaar na de aangegeven datum ligt.<br />- anders aangegeven als \"misschien\".</li></ul><br /><br />";
$pgv_lang["year_help"]				= "~#pgv_lang[alive_in_year]#~<br /><br />Vul het jaar in waarvan u wilt zien welke personen toen leefden.<br /><br />";
$pgv_lang["help_repolist.php"]		= "~BEWAARPLAATSEN~<br /><br />Op deze pagina treft u een overzicht van alle bewaarplaatsen aan.<br />De bewaarplaatsen zijn alfabetisch op titel gesorteerd.<br />Als u op een van de bewaarplaatsen klikt, worden de details van de bewaarplaats weergegeven, evenals de bronnen die aan de bewaarplaats zijn gekoppeld.<br /><br />GEBRUIK VAN BEWAARPLAATSEN<br />Zonder bewaarplaatsen kunnen we niet op een verantwoorde manier een genealogisch bestand opbouwen. Alle informatie dient herleidbaar, reproduceerbaar en controleerbaar te zijn. Alle bronnen die in de genealogie zijn opgenomen, moeten zijn gekoppeld aan een bewaarplaats. Op die manier kan de bron altijd fysiek worden teruggevonden.<br />Omdat in een bewaarplaats meerdere bronnen kunnen zijn opgeslagen, worden bewaarplaatsen gekoppeld aan meerdere bronnen.<br /><br />";
$pgv_lang["help_repo.php"]			= "~DETAILS BEWAARPLAATS~<br /><br />Bewaarplaatsen zijn, samen met bronnen, belangrijk in genealogisch onderzoek omdat ze informatie in een stamboom controleerbaar en reproduceerbaar maken. Op die manier kunnen andere onderzoekers op een verantwoorde manier van de gegevens gebruik maken.<br /><br />Op deze pagina ziet u de detailgegevens van de bewaarplaats zoals adres, e-mailadres, internet pagina en telefoonnummer.<br />Onder de details van de bewaarplaats wordt een lijst met bronnen getoond die verwijzen naar deze bewaarplaats.<br /><br />Als de beheerder van de site dit mogelijk heeft gemaakt, ziet u aan de rechterzijde van het scherm nog twee koppelingen: <br />\"Toon GEDCOM-gegevens\", waarmee u in een apart venster de gegevens van de bewaarplaats in GEDCOM-formaat kunt zien, en <br />\"Toevoegen aan knipselbak\", waarmee u de GEDCOM-gegevens van de bron in uw knipselbak kunt opslaan. Later kunt u ze downloaden naar uw eigen machine en ze daar importeren in uw genealogiepakket.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["delete_repo_help"]			= "~VERWIJDER BEWAARPLAATS~<br /><br />Door deze optie aan te klikken, markeert u een bewaarplaats voor verwijdering uit de genealogie.<br /><br />Wat betekent dat nu?<br />Laten we aannemen dat u een goede reden heeft om deze bewaarplaats uit de genealogie te verwijderen. U klikt op de koppeling. Daarna verschijnt er een venster, waarin u wordt gevraagd of u er zeker van bent, of dat u de bewerking wilt annuleren.<br /><br />Als u doorgaat, verschijnt na enige tijd opnieuw een scherm, waarin wordt gemeld dat de bewaarplaats uit de genealogie is verwijderd.<br />De bewaarplaats zal echter nog steeds zichtbaar en raadpleegbaar zijn. <br /><br />Dit is <b>geen</b> fout. De beheerder heeft een e-mail gekregen, waarin wordt vermeld dat er een wijziging op de genealogie is aangebracht en dat u de bewaarplaats heeft verwijderd. De beheerder kan de wijziging accepteren of ongedaan maken. Pas als de beheerder de wijziging heeft geaccepteerd, is de bewaarplaats definitief verwijderd.<br />Bij twijfel zal de beheerder contact met u opnemen.<br /><br />";
$pgv_lang["show_repo_gedcom_help"]	= "~TOON GEDCOM-GEGEVENS~<br /><br />Door op deze koppeling te klikken, krijgt u de informatie over deze bewaarplaats in GEDCOM-formaat te zien.<br /><br />";
$pgv_lang["add_repository_clip_help"]		= "~BEWAARPLAATS TOEVOEGEN AAN KNIPSELBAK~<br /><br />Door op deze koppeling te klikken, worden de gegevens van deze bewaarplaats toegevoegd aan de knipselbak.<br /><br />";
$pgv_lang["repolist_listbox_help"]		= "~LIJST BEWAARPLAATSEN~<br /><br />In dit vak ziet u een overzicht van bewaarplaatsen die voorkomen in deze genealogie.<br />De titels worden weergegeven in alfabetische volgorde.<br /><br />Als u op een bewaarplaats klikt, worden de detailgegevens getoond, evenals een lijst met bronnen die aan de bewaarplaats zijn gekoppeld.<br /><br />";
$pgv_lang["repos_listbox_help"]		= "~AAN DEZE BEWAARPLAATS GEKOPPELDE BRONNEN~<br /><br />In dit vak ziet u alle bronnen, die aan deze bewaarplaats zijn gekoppeld. Als u op een bron klikt, krijgt u de details ervan te zien.<br /><br />";
$pgv_lang["block_move_up_help"]		= "~Wijzig vakvolgorde~<br /><br />Gebruik deze knoppen om de volgorde van de vakken in de lijst aan te passen. De vakken worden weergegeven in de volgorde zoals ze in de lijst staan.<br /><br />klik het vak aan dat u wilt verplaatsen en klik op de op- en neerknoppen om het vak naar boven of naar beneden te verplaatsen.<br /><br />";
$pgv_lang["block_move_right_help"]	= "~Verplaats vakken~<br /><br />Gebruik deze knoppen om een vak van een lijst naar een andere te verplaatsen.<br /><br />Klik op het vak dat u wilt verplaatsen en klik op een pijlknop om het vak in de aangegeven richting te verplaatsen. Gebruik de <b>&raquo;</b> en <b>&laquo;</b> knoppen om het vak van meest links naar meest rechts te verplaatsen en vice versa. Gebruik de <b>></b> en <b><</b> knoppen om het vak tussen de lijst #pgv_lang[available_blocks]# list en de lijsten links en rechts te verplaatsen.<br /><br />De lijst met #pgv_lang[available_blocks]# wijzigt niet, ongeacht wat u met de #pgv_lang[move_right]# en #pgv_lang[move_left]# knoppen doet. Ze blijven beschikbaar omdat ze meerdere malen op dezelfde pagina kunnen verschijnen. Het HTML-vak is hiervan een goed voorbeeld.<br /><br />";
$pgv_lang["block_default_index"]	= "~Standaard vakken op de #pgv_lang[welcome]#~<br /><br />Als u alle vakken uit de #pgv_lang[main_section]# en #pgv_lang[right_section]# verwijdert, of als u klikt op de <b>#pgv_lang[reset_default_blocks]#</b> knop, dan wordt de vakindeling als volgt ingesteld:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["block_default_portal"]	= "~Standaard vakken op de #pgv_lang[mygedview]# pagina~<br /><br />Als u alle vakken uit de #pgv_lang[main_section]# en de #pgv_lang[right_section]# verwijdert, of op de knop <b>#pgv_lang[reset_default_blocks]#</b> klikt, worden de vaklijsten als volgt ingesteld:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
$pgv_lang["help_hourglass.php"]			= "~#pgv_lang[hourglass_chart]#~<br /><br />Het zandloperdiagram toont zowel de voorouders als de nakomelingen van de geselecteerde startpersoon in hetzelfde overzicht. Het is een mengvorm van kwartierstaat en overzicht nakomelingen.<br /><br />De startpersoon wordt weergegeven op het midden van de pagina, zijn nakomelingen links en zijn voorouders rechts. De generaties worden op die manier van links naar rechts weergegeven.<br /><br />";
$pgv_lang["show_spouse_help"]			= "~#pgv_lang[show_spouses]#~<br /><br />Standaard worden in dit overzicht de partners van de personen niet weergegeven, omdat dit het overzicht ingewikkeld maakt. Met deze optie kunt u de partners alsnog laten tonen.<br />";
$pgv_lang["reorder_families_help"]		= "~#pgv_lang[reorder_families]#~<br /><br />De gezinnen op het tabblad \"Verwanten\" worden weergegeven in de volgorde waarin ze in de gegevens van de desbetreffende persoon voorkomen. Dit is van belang, omdat soms niet de huwelijksdata bekend zijn, maar wel de volgorde van huwelijken.<br /><br />Met behulp van deze optie kunt u de volgorde van de gezinnen aanpassen. Daarbij is een speciale knop beschikbaar om de sortering op huwelijksdatum toe te passen, uiteraard indien alle huwelijksdata bekend zijn.<br />";
$pgv_lang["import_marr_names_help"]		= "~#pgv_lang[import_marr_names]#~<br /><br />Als u ervoor kiest om achternamen in huwelijk tijdens import aan te maken, zal PhpGedView van alle vrouwelijke personen in het bestand een huwelijkse achternaam aanmaken. Hierdoor kunt u deze personen bij zoeken zowel terugvinden onder hun meisjesnaam als onder hun huwelijkse naam.<br /><br />Als u eveneens de optie \"<b>#pgv_lang[SHOW_MARRIED_NAMES]#</b>\" in de GEDCOM-configuratie heeft ingeschakeld, worden de huwelijkse namen eveneens in de personenlijst weergegeven.<br /><br />";
$pgv_lang["firstname_alpha_help"]		= "~ALFABETISCHE LIJST VOORNAMEN~<br /><br />Binnen de door u gekozen achternaam zijn meer dan 500 namen aanwezig. Om sneller te zoeken is een alfabetische index op voornaam aangemaakt. Deze index werkt hetzelfde als de index voor achternamen. Het aanklikken van een letter geeft een lijst met namen die beginnen met die letter.<br />Kies <b>Onbekend</b> voor een lijst met personen met onbekende voornaam.<br />kies <b>ALLE</b>voor een lijst met alle personen met deze achternaam. Vanwege het grote aantal personen kan het een poos duren voordat deze lijst op uw scherm wordt getoond.<br/><br />";
$pgv_lang["edit_UPLOAD_FILE_help"]		= "~BESTAND UPLOADEN VANAF UW COMPUTER~<br /><br />Als een multimediabestand niet al bestaat op de website, dan kunt u hier een bestand opgeven om te uploaden naar de multimediamap. Als u dit doet, wordt alle informatie in \"#factarray[FILE]#\" overschreven. Indien de website dit ondersteunt, wordt tevens een miniweergave van JPG, GIF en PNG-afbeeldingen gemaakt.<br /><br />";
$pgv_lang["edit_TYPE_help"]		= "~#factarray[TYPE]#~<br /><br />Het #factarray[TYPE]# invoervak stelt u in staat om een eigen gebeurtenistype in te voeren. U bent vrij om iedere tekst in te vullen, zoals u dat wilt.<br /><br />";
$pgv_lang["edit_TEMP_help"]		= "~#factarray[TEMP]#~<br /><br />Vul hier de tempel in, waar de LDS-plechtigheid heeft plaatsgevonden.<br /><br />";
$pgv_lang["edit_STAT_help"]		= "~#factarray[STAT]#~<br /><br />Dit is een optionele statusaanduiding, die meestal wordt gebruikt voor gegevens over LDS-gebeurtenissen, die door het TempleReady-programma zijn bewerkt.<br /><br />";
$pgv_lang["edit__PRIM_help"]		= "~#factarray[_PRIM]#~<br /><br />Gebruik dit keuzeveld om aan te geven of de afbeelding de geaccentueerde of primaire is, die aan deze persoon is gekoppeld.<br />De geaccentueerde afbeelding wordt gebruikt op overzichten en op de persoonspagina.<br /><br />";
$pgv_lang["edit__THUM_help"]		= "~#factarray[_THUM]#~<br /><br />Dit is een specifieke PhpGedView-optie, waarmee u kunt aangeven dat een geaccentueerde miniweergave moet worden gebruikt in de overzichten, zelfs als deze niet bestaat.<br /><br />";
$pgv_lang["edit_TITL_help"]		= "~#factarray[TITL]#~<br /><br />Voer een titel in voor de gegevens die u nu invoert. Als het een titel betreft voor een multimedia-item zorg dan voor een duidelijke omschrijving, waaruit gebruikers kunnen opmaken waar het om gaat.<br /><br />";
$pgv_lang["edit_FILE_help"]		= "~#factarray[FILE]#~<br /><br />Dit is verreweg het belangrijkste gegeven van het multimedia-object en geeft aan welk bestand gebruikt wordt. Minimaal vult u hier de bestandsnaam in. Afhankelijk van de instellingen is meer informatie over de locatie van het bestand nodig.<br /><br />U kunt de koppeling \"#pgv_lang[find_media]#\" gebruiken om een multimedia-bestand te zoeken, als dat tenminste al is ge-upload naar de website.<br /><br />#pgv_lang[readme_help]#<br /><br /> ";
$pgv_lang["edit_FORM_help"]		= "~#factarray[FORM]#~<br /><br />Hier kunt u invullen welk bestandformaat het multimedia-object heeft, maar het is niet verplicht. Sommige genealogieprogramma's gebruiken het om te bepalen hoe ze met een multimedia-object moeten omgaan.<br />Omdat multimedia-objecten in het algemeen niet gemakkelijk worden overgeheveld tussen computersystemen, is de hier ingevulde waarde van gering belang.<br /><br />";
$pgv_lang["generate_thumb_help"]		= "~GENEREER MINIWEERGAVE~<br /><br />Uw webserver is in staat om automatisch miniweergaves aan te maken van bepaalde soorten afbeeldingen. Dit kunnen ondermeer JPG, GIF en PNG-bestanden zijn. De soorten die door uw webserver worden ondersteund zijn weergegeven in het keuzevak.<br /><br />Door dit te selecteren, geeft u aan dat u afbeeldingen upload en wilt proberen hier automatisch miniweergaves voor aan te maken. Als u zelf miniweergaves wilt aanmaken en in de juiste map plaatsen, selecteert u deze optie niet.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]		= "~#pgv_lang[add_note]#~<br /><br />In deze sectie kunt een notitie toevoegen aan het feit dat u op dit moment aan het wijzigen of toevoegen bent. In notities kunt u een willekeurige tekst plaatsen. De notitie verschijnt bij de detailgegevens van het feit op de pagina.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]		= "~#pgv_lang[add_source]#~<br /><br />In deze sectie kunt u een bronvermelding toevoegen aan het feit dat u op dit moment wijzigt of toevoegt. De code voor de bron moet worden ingevoerd, u kunt ernaar zoeken door op het icoon rechts van het invoervak te klikken.<br /><br />Klik op de #pgv_lang[create_source]#-koppeling als u een nieuwe bron wilt invoeren.<br /><br />Bij \"details citaat\" kunt u aangeven waar in de bron (bijvoorbeeld op welke pagina) de informatie te vinden in.<br />Bij tekst kunt u een transcript (overgenomen informatie) opnemen vanuit de bron.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]		= "~#pgv_lang[add_asso]#~<br /><br />Met #pgv_lang[add_asso]# kunt u een persoon uit uw genealogie relateren aan een feit. Op die manier kunt u bijvoorbeeld aangeven dat een bepaald persoon de peetvader is van een ander persoon.<br /><br />";
$pgv_lang["edit_QUAY_help"]		= "~#factarray[QUAY]#~<br /><br />Deze aanduiding kunt u gebruiken om de betrouwbaarheid van gegevens van deze bron aan te geven.<br />Veel genealogieprogramma's duiden dit aan door middel van een cijfer:<br />1. kan inhouden dat een gegeven uit een directe of primaire bron afkomstig is. Denk aan een geboorteakte of ander officieel document.<br />2. kan inhouden dat de informatie in de bron overgenomen kan zijn uit een andere bron, en daarbij onderhevig aan fouten.<br />3. kan betekenen dat de informatie ronduit onbetrouwbaar is.<br /><br />";
$pgv_lang["edit_PAGE_help"]		= "~#factarray[PAGE]#~<br /><br />In de detailgegevens van het citaat kunt u bijvoorbeeld een paginanummer opgeven of andere informatie, waardoor de bedoelde informatie gemakkelijk in de bron kan worden teruggevonden.<br /><br />";
$pgv_lang["edit_TEXT_help"]		= "~#factarray[TEXT]#~<br /><br />Hier kunt u specifieke informatie invoeren over deze bronverwijzing. Voorbeelden zijn een transcript (letterlijk overgenomen tekst) uit de bron of een samenvatting of beschrijving ervan.<br /><br />";
$pgv_lang["edit_SOUR_help"]		= "~#factarray[SOUR]#~<br /><br />Hier kunt u de verwijzing naar een bron voor dit feit aanpassen. Ingevuld wordt een bron-ID (kenmerk). Daarnaast wordt de titel van de bron weergegeven. Gebruik de \"#pgv_lang[find_id]#\"-koppeling om een nieuwe bron te selecteren. Om de bronverwijzing te verwijderen, maak het vak met de bron-ID leeg.<br /><br />";
$pgv_lang["edit_edit_raw_help"]	= "~#pgv_lang[edit_raw]#~<br /><br />Met behulp van deze functie kunt u de informatie aanpassen, zoals deze in de GEDCOM-informatie voorkomt.<br /><br /><b>Let op:</b> het direct wijzigen van GEDCOM-informatie vereist kennis van de structuur en inhoud ervan.<br /><br />PhpGedView biedt op vele andere manieren via invulschermen de mogelijkheid om de gegevens aan te passen. Aangeraden wordt altijd deze mogelijkheden te gebruiken, en deze functie alleen in uiterste noodzaak toe te passen.<br />Als u de aangepaste informatie heeft opgeslagen, wordt op een aantal punten gecontroleerd op de juistheid ervan. Ook wordt een CHAN-record aangemaakt (laatste wijziging).<br /><br />";
$pgv_lang["add_from_clipboard_help"]	= "~#pgv_lang[add_from_clipboard]#~<br /><br />Met PhpGedView kunt u informatie over feiten kopiëren naar het klembord. Als u dit heeft gedaan, kunt u onder \"Nieuw feit toevoegen\" de gekopieerde informatie toevoegen aan ieder ander persoon. In de keuzelijst is de informatie te vinden onder \"Toevoegen vanaf klembord .....\".<br />Deze mogelijkheid is erg handig als u dezelfde informatie over een feit wilt toevoegen aan meerdere personen.<br /><br />";
$pgv_lang["edit_PLAC_help"]			= "~#factarray[PLAC]#~<br /><br />Locaties moeten worden ingevoerd aan de hand van de standaards in genealogie. Locaties worden ingevoerd met de meest specifieke informatie eerst en dan per niveau steeds minder specifiek. De stappen worden gescheiden door komma's. De niveaus moeten overeenkomen met de niveaus die door (kerkelijke) autoriteiten worden onderscheiden.<br /><br />Een plaats als Leiden wordt ingevoerd als \"Leiden, Zuid-Holland, Nederland\". Hier is Leiden de stad, Zuid-Holland de provincie en Nederland het land.<br />Stadsdelen kunnen worden toegevoegd door deze voor de stad te plaatsen. Er komt dan dus nog een niveau bij.<br /><br />Als een niveau niet bekend is, wordt het vervangen door een spatie. Stel dat we alleen weten dat een persoon in Leiden is geboren en dat Leiden in Nederland ligt, dan wordt de aanduiding als volgt: \"Leiden, , Nederland\".<br /><br />U kunt de koppeling \"#pgv_lang[find_place]#\" gebruiken om locaties te vinden die in deze genealogie al voorkomen.<br /><br />";
$pgv_lang["edit_add_parent_help"]	= "~NIEUWE VADER OF MOEDER TOEVOEGEN~<br /><br />Hiermee kunt u een vader of moeder toevoegen aan de persoon. Vul alle bekende gegevens over naam, geboorte en evt. overlijden in. Nog niet bekende gegevens kunt u later toevoegen.<br /><br />Om andere feiten aan de persoon toe te voegen, dient u eerst de ingevulde gegevens op te slaan. Daarna kunt u op de naam van de persoon klikken en op de persoonspagina, tabblad \"Persoonlijke feiten en details\", nieuwe feiten toevoegen.<br /><br />";
$pgv_lang["edit_add_spouse_help"]	= "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Hiermee kunt u een partner toevoegen aan de geselecteerde persoon. De partner wordt als nieuw persoon in de genealogie opgenomen. Vul de naam, geboortegegevens en eventueel overlijdensgegevens in. Gegevens die nu nog ontbreken kunt u altijd later aanvullen.<br /><br />Om andere feiten aan de persoon toe te voegen, dient u eerst de ingevulde gegevens op te slaan. Daarna kunt u op de naam van de persoon klikken en op de persoonspagina, tabblad \"Persoonlijke feiten en details\", nieuwe feiten toevoegen.<br /><br />";
$pgv_lang["edit_death_help"] = "~#pgv_lang[death]#~<br /><br />In deze sectie kunt u gegevens over het overlijden toevoegen. Voer eerst de datum in waarop het overlijden plaatsvond. Zorg ervoor dat de datum in het standaard genealogisch formaat wordt ingevoerd, bijvoorbeeld 1 JAN 2004 of 16 MAY 1877. U kunt ook de kalender gebruiken om een datum te selecteren: gebruik hiervoor de koppeling naast het datumvak.<br />Voer vervolgens de locatie in waar de persoon is overleden. Gebruik de \"Zoek locatie\" koppeling om een reeds bestaande locatie te selecteren.<br /><br />";
$pgv_lang["edit_birth_help"] = "~#pgv_lang[birth]#~<br /><br />In deze sectie kunt u gegevens over de geboorte toevoegen. Voer eerst de datum in waarop de geboorte plaatsvond. Zorg ervoor dat de datum in het standaard genealogisch formaat wordt ingevoerd, bijvoorbeeld 1 JAN 2004 of 16 MAY 1877. U kunt ook de kalender gebruiken om een datum te selecteren: gebruik hiervoor de koppeling naast het datumvak.<br />Voer vervolgens de locatie in waar de persoon is geboren. Gebruik de \"Zoek locatie\" koppeling om een reeds bestaande locatie te selecteren.<br /><br />";
$pgv_lang["edit_sex_help"]	= "~#pgv_lang[sex]#~<br /><br />Kies het geslacht van de persoon in de keuzelijst. \"Onbekend\" betekent dat het geslacht niet bekend is.<br /><br />";
$pgv_lang["edit_name_help"]	= "~#pgv_lang[name]#<br /><br />Dit is het belangrijkste onderdeel van de persoonsgegevens. In dit vak wordt de complete naam samengesteld uit hetgeen in de andere naamvakken is ingevoerd. Volgens de genealogische standaard wordt hierbij de achternaam omgeven door \"/\"-tekens. \"Piet de Groot jr.\" wordt dan weergegeven als \"Piet/de Groot/jr.\".<br /><br />";
$pgv_lang["edit_suffix_help"]	= "~#pgv_lang[suffix]#~<br /><br />In dit vak kunt u een achtervoegsel van de naam invoeren. Voorbeelden zijn \"sr.\" en \"jr.\". Invullen van dit vak is niet verplicht.<br /><br />";
$pgv_lang["edit_surname_help"]	= "~#pgv_lang[surname]#~<br /><br />In dit vak kunt u de achternaam van de persoon invoeren. Heet de persoon bijvoorbeeld \"Piet de Groot\", dan vult u hier \"de Groot\" in.<br /><br />";
$pgv_lang["edit_NICK_help"]	= "~#factarray[NICK]#~<br /><br />In dit vak kunt u de bij- of roepnaam van een persoon invoeren.<br />Invoer is niet verplicht.<br /><br />Er zijn verschillende manieren om een bij- of roepnaam in te voeren:<ul><li>Selecteer 'Wijzig naam', vul de roep- of bijnaam in en sla het op.</li><li>Selecteer 'Nieuwe voor/achternaam toevoegen', vul zowel voor-, achter-, als roep- of bijnaam in en sla het op. Let op: hierdoor worden voor/achternaam TWEEMAAL in de gegevens opgenomen.<br /></li><li>Selecteer 'Wijzig GEDCOM-gegevens' om meerdere [2 NICK] toe te voegen onder [1 NAME].</li></ul><br /><br />";
$pgv_lang["edit_given_name_help"]	= "~#pgv_lang[given_name]#~<br /><br />In dit vak kunt u de voornamen van de persoon invullen. Heet de persoon \"Piet de Groot\", dan vult u hier \"Piet\" in.<br /><br />";
$pgv_lang["edit_NPFX_help"]			= "~#factarray[NAME]# #factarray[NPFX]#~<br /><br />In dit vak kunt u voorvoegsels voor de naam invoeren, zoals dr, ir en drs. U kunt dit vak leeg laten.<br /><br />";
$pgv_lang["edit_add_child_help"]	= "~#pgv_lang[add_child]#~<br /><br />Hiermee kunt u een nieuw kind toevoegen aan het geselecteerde gezin. Het kind wordt als nieuw persoon in de genealogie opgenomen. Vul de naam, geboortegegevens en eventueel overlijdensgegevens in. Gegevens die nu nog ontbreken kunt u altijd later aanvullen.<br /><br />Om andere feiten aan het kind toe te voegen, dient u eerst de ingevulde gegevens op te slaan. Daarna kunt u op de naam van het kind klikken en op de persoonspagina, tabblad \"Persoonlijke feiten en details\", nieuwe feiten toevoegen.<br /><br />";
$pgv_lang["review_changes_help"]	= "~NOG NIET GEACCEPTEERDE WIJZIGINGEN~<br /><br />In dit vak worden alle wijzigingen getoond die zijn aangebracht, maar nog niet door een bevoegd beheerder zijn beoordeeld en doorgevoerd.<br /><br />";
$pgv_lang["quick_update_name_help"] = "~NAAM BIJWERKEN~<br /><br />Gebruik deze invoervakken om de naam te wijzigen van de persoon op de persoonspagina. Bij \"Voornamen\" vult u de volledige voornamen van de persoon in , bij \"Achternaam\" de achternaam inclusief voorvoegsels. Als u bijvoorbeeld de naam van de persoon wilt wijzigen in \"Piet de Groot\", vult u bij \"Voornaam\" \"Piet\" in en bij \"Achternaam\" \"de Groot\".<br /><br />Let op: Met het intypen van een nieuwe naam voegt u geen nieuwe persoon toe, de naam van de bestaande persoon wordt gewijzigd. Ook wordt geen nieuwe naam toegevoegd, de huidige naam wordt gewijzigd.<br /><br /><i>Let op: Wijzig de naam niet ten gevolge van een huwelijk, gebruik deze pagina dan om een nieuwe partner in te voeren.</i><br /><br />";
$pgv_lang["quick_update_fact_help"] = "~FEIT BIJWERKEN~<br /><br />Gebruik de vakken om nieuwe feiten toe te voegen of bestaande feiten aan te passen. Kies eerst een feit uit de keuzelijst.<br />Voer vervolgens de datum in van wanneer het feit plaatsvond. Zorg ervoor dat de datum in het standaard genealogisch formaat wordt ingevoerd, bijvoorbeeld 1 JAN 2004 of 16 MAY 1877. U kunt ook de kalender gebruiken om een datum te selecteren: gebruik hiervoor de koppeling naast het datumvak.<br />Voer vervolgens de locatie in waar het feit plaatsvond. Gebruik de \"Zoek locatie\" koppeling om een reeds bestaande locatie te selecteren.<br /><br />Als u informatie invoert voor een feit dat al bestaat, dan wordt de oude informatie overschreven met hetgeen u hier invoert. Bestaat het feit nog niet, dan maakt u hiermee een nieuw feit aan.<br /><br />";
$pgv_lang["quick_update_photo_help"] = "~AFBEELDING BIJWERKEN~<br /><br />Gebruik dit om een afbeelding te uploaden van de persoon waar u op dit moment de gegevens van wijzigt. In \"Titel\" vult u een beschrijvende tekst in, bij voorbeeld \"Piet de Groot 2005\".<br />Klik vervolgens op \"Browse\" om het bestand met de afbeelding te zoeken en selecteren.<br />Als deze persoon al een afbeelding heeft in PhpGedView, dan kunt u met behulp van het keuzevak \"Wilt u een bestaande afbeelding vervangen door deze?\" bepalen of de nieuwe afbeelding de oude vervangt of alleen wordt toegevoegd.<br /><br />";
$pgv_lang["quick_update_address_help"] = "~ADRES BIJWERKEN~<br /><br />Gebruik de vakken van \"Adres bijwerken\" om adres, telefoon en e-mailgegevens van de desbetreffende persoon bij te werken.<br /><br />Bestaande adresinformatie wordt hierbij overschreven.<br /><br />";
$pgv_lang["quick_update_spouse_help"] = "~NIEUWE PARTNER TOEVOEGEN~<br /><br />Gebruik deze sectie als u een nieuwe partner wilt toevoegen aan de persoon. Voer de naams- en geboorte-informatie in de vakken in en, indien het om een huwelijk gaat, de huwelijksinformatie eronder.<br /><br />Voer datums in volgens de genealogische indeling (1 JAN 2005 of 16 MAY 1799). U kunt ook de kalender gebruiken om een datum te selecteren, klik hiervoor op de kalenderafbeelding rechts van het invoervak.<br />U kunt \"Zoek locatie\" gebruiken om een reeds eerder in PhpGedView gebruikte locatie te selecteren.<br /><br />Let op: U kunt hiermee alleen een <i>nieuwe</i> partner toevoegen. De informatie van bestaande partner wordt niet aangepast. Om die informatie te bewerken, kunt u dit venster sluiten, op de naam van de desbetreffende partner klikken op het tabblad \"Verwanten\". Kies daarna bij de feiten of bij \"opties voor personen\" voor wat u wilt wijzigen.<br /><br />";
$pgv_lang["quick_update_marriage_help"] = "~HUWELIJK BIJWERKEN~<br /><br />U kunt deze sectie gebruiken in combinatie met \"Nieuwe partner toevoegen\". In dat geval wordt een nieuw huwelijk/gezin toegevoegd.<br />In het andere geval wordt het <b>laatste</b> huwelijk van de persoon aangepast.<br /><br />Voer datums in volgens de genealogische indeling (1 JAN 2005 of 16 MAY 1799). U kunt ook de kalender gebruiken om een datum te selecteren, klik hiervoor op de kalenderafbeelding rechts van het invoervak.<br />U kunt \"Zoek locatie\" gebruiken om een reeds eerder in PhpGedView gebruikte locatie te selecteren.<br /><br />";
$pgv_lang["quick_update_child_help"] = "~NIEUW KIND TOEVOEGEN~<br /><br />Gebruik deze sectie om een nieuw kind toe te voegen aan de persoon. Voer eerst de namen van het kind in en het geslacht, vervolgens de datum en plaats van geboorte.<br />Voer datums in volgens de genealogische indeling (1 JAN 2005 of 16 MAY 1799). U kunt ook de kalender gebruiken om een datum te selecteren, klik hiervoor op de kalenderafbeelding rechts van het invoervak.<br />U kunt \"Zoek locatie\" gebruiken om een reeds eerder in PhpGedView gebruikte locatie te selecteren.<br /><br />Let op: U kunt hiermee alleen een <i>nieuw</i> kind toevoegen. De informatie van een bestaand kind wordt niet aangepast. Om die informatie te bewerken kunt u dit venster sluiten, op de naam van het desbetreffende kind klikken op het tabblad \"Verwanten\". Kies daarna bij de feiten of bij \"opties voor personen\" voor wat u wilt wijzigen.<br /><br />";
$pgv_lang["index_top10_pageviews_help"]		= "~MEEST BEKEKEN GEGEVENS~<br />In dit vak wordt de top 10 weergegeven van meest bekeken personen, gezinnen en bronnen. Dit vak wordt alleen weergegeven als de bezoekersteller is ingeschakeld.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]	= "~STANDAARD TABBLAD VOOR PERSOONSPAGINA~<br /><br />Deze instelling bepaalt welk tabblad standaard wordt getoond als de gebruiker de gegevens van een persoon bekijkt. Als gebruikers hun gebruikersgegevens mogen aanpassen, kunnen ze deze instelling later zelf wijzigen.";
$pgv_lang["edituser_user_default_tab_help"]	= "~STANDAARD TABBLAD VOOR PERSOONSPAGINA~<br /><br />Deze instelling bepaalt welk tabblad standaard wordt getoond als de gebruiker de gegevens van een persoon bekijkt.";
$pgv_lang["reorder_children_help"]	= "~KINDEREN HERSCHIKKEN~<br /><br />Kinderen worden getoond in de volgorde waarin ze in de genealogie voorkomen in het gezin. Hoewel sortering op geboortedatum voor de hand ligt, wordt dit niet gedaan, omdat soms geen geboortedata bekend zijn, maar de volgorde van geboorte daarentegen wel.<br /><br />Met deze functie kunt u de kinderen binnen het gezin herschikken naar de juiste volgorde. Als u ze simpelweg op geboortedatum wilt sorteren, kunt u hiervoor de desbetreffende knop gebruiken. PhpGedView verzorgt de sortering dan automatisch.<br /><br />";
$pgv_lang["rss_feed_help"]	= "~RSS FEED INSTELLINGEN~<br /><br />De RRS feed van PhpGedView stelt u in staat om de belangrijkste onderdelen van de Welkomstpagina te zien op een website die deze feed gebruikt, zonder dat u de PhpGedView-site steeds hoeft te bezoeken. De meeste websites die gebruik maken van RSS feeds maken u op wijzigingen in de feeds attent.<br />Met het RSS feed vak kunt u de koppeling naar de feed instellen voor bepaalde soorten informatie (de meeste websites kunnen hiermee overweg en in principe kunt u de standaardwaarden laten staan) en de specifieke module die u aan de feed wilt toevoegen. De taal van de feed is de taal die actief is op het moment dat u de feed selecteert. De types feed die kunnen worden gegenereerd zijn ondermeer RSS 0.92, RSS 1.0, RSS 2.0, ATOM, HTML en JavaScript. De eerste vier types zijn bedoeld voor feed-verzamelaars, terwijl JavaScript en HTML zijn bedoeld om op te nemen op andere webpagina's.<br /><br />Let erop dat de verschillende versienummers duiden op verschillende types feed en niet op verschillende versies.<br /><br />";
$pgv_lang["reorder_children_help"]	= "~KINDEREN HERSCHIKKEN~<br /><br />Kinderen worden getoond in de volgorde waarin ze in de genealogie voorkomen in het gezin. Hoewel sortering op geboortedatum voor de hand ligt, wordt dit niet gedaan, omdat soms geen geboortedata bekend zijn, maar de volgorde van geboorte daarentegen wel.<br /><br />Met deze functie kunt u de kinderen binnen het gezin herschikken naar de juiste volgorde. Als u ze simpelweg op geboortedatum wilt sorteren, kunt u hiervoor de desbetreffende knop gebruiken. PhpGedView verzorgt de sortering dan automatisch.<br /><br />";
$pgv_lang["edit_TIME_help"]		= "~#factarray[TIME]#~<br /><br />Voer het tijdstip van deze gebeurtenis in. Het geldige formaat is UU:MM. Voorbeelden zijn: 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]		= "~#factarray[NOTE]#~<br /><br />in notities kunt u vrije stukken tekst opslaan. Deze verschijnen bij de details van de feiten en gebeurtenissen op de pagina.<br /><br />";
$pgv_lang["edit_CEME_help"]		= "~#factarray[CEME]#~<br /><br />Voer de naam van de begraafplaats of andere laatste rustplaats in waar de persoon is begraven.<br /><br />";
$pgv_lang["edit_ASSO_help"]		= "~#factarray[ASSO]#~<br /><br />Voer het ID in van de relatie.<br /><br />";
$pgv_lang["edit_RELA_help"]		= "~#factarray[RELA]#~<br /><br />Selecteer een soort relatie uit de lijst. Het selecteren van Peetvader betekent dus dat de relatie de peetvader van de huidige persoon is.<br /><br />";
$pgv_lang["edit_NCHI_help"]		= "~#factarray[NCHI]#~<br /><br />Voer het aantal kinderen voor deze persoon of dit gezin in. Invoeren is niet verplicht.<br /><br /> <br />";
$pgv_lang["remember_me_help"]	= "~ONTHOUDT MIJ OP DEZE COMPUTER~<br /><br />Als u dit aanvinkt worden uw aanmeldgegevens bewaard op deze computer. Wanneer u dan de volgende maal deze site bezoekt, hoeft u zich niet opnieuw aan te melden.<br />Uw Internet Verkenner moet het opslaan van \"cookies\" toestaan, hierin worden de aanmeldgegevens opgeslagen en daar vandaan een volgende keer naar de website toegezonden.<br /><br />Vink deze optie NIET aan als u op een publiek toegankelijke computer werkt, iedereen zal dan in staat zijn deze website te bezoeken met uw gegevens.<br /><br />";
$pgv_lang["utf8_ansi_help"]		= "~CONVERTEER VAN UTF-8 NAAR ANSI~<br /><br />Voor het optimaal tonen van de gegevens op Internet gebruikt PhpGedView de UTF-8 tekenset. Sommige genealogieprogramma's ondersteunen deze tekenset niet, als GEDCOM-bestanden worden geïmporteerd. Als u deze keuze aanzet, wordt het bestand van <b>UTF-8</b> naar <b>ANSI (ISO-8859-1)</b> geconverteerd.<br /><br />Welk formaat u nodig heeft hangt af van het programma waar u het GEDCOM-bestand mee wilt bewerken na het downloaden ervan.<br />Raadpleeg indien nodig de handleiding bij het programma.<br /><br />Let erop dat speciale tekens alleen behouden blijven, als u het bestand in UTF-8 formaat download. Als u het bestand naar andere formaten zoals ANSEL moet converteren, dient u hiervoor een ander programma te gebruiken.<br /><br />";
$pgv_lang["remove_tags_help"]	= "~VERWIJDER SPECIALE PGV-KENMERKEN?~<br /><br />Deze optie zorgt ervoor dat speciale PhpGedView-kenmerken worden verwijderd.<br /><br />Dit betreft kenmerken zoals _PGVU, waarmee wordt aangegeven welke gebruiker het laatst iets aan de gegevens heeft gewijzigd, of _THUM, waarmee wordt aangegeven welke afbeelding moet worden gebruikt als miniweergave.<br /><br />In sommige gevallen kunnen de speciale kenmerken foutmeldingen genereren als ze in een genealogieprogramma worden gemporteerd.<br /><br />";
$pgv_lang["download_zipped_help"]	= "~DOWNLOAD GEDCOM BESTAND ALS ZIP BESTAND~<br /><br />Als u deze optie kiest, wordt een kopie van het GEDCOM-bestand gecomprimeerd in een ZIP-bestand, voordat het downloaden begint. Dit brengt de omvang ervan aanzienlijk terug, maar u heeft op uw PC een UnZIP-programma nodig (zoals WinZip) om het GEDCOM-bestand weer uit te pakken voor gebruik.<br /><br />Deze optie kunt u met name gebruiken voor grote GEDCOM-bestanden. Het risico bestaat dat deze niet geheel gedownload worden, doordat de maximale uitvoeringstijd van het downloadprogramma wordt overschreden. U heeft dan een incompleet GEDCOM-bestand.<br />Deze optie reduceert de downloadtijd met ongeveer 75%.<br /><br />";
$pgv_lang["register_gedcomid_help"]	= "~#pgv_lang[gedcomid]#~<br /><br />Ieder persoon in een genealogie heeft een uniek identificatienummer, een ID. Als u in de genealogie voorkomt en uw ID kent, kunt u dat hier intypen. Als u het niet kent, of u kunt het niet vinden doordat de toegang is afgeschermd door privacy-instellingen, geeft u dan voldoende informatie in het commentaarvak om u herkenbaar te maken voor de beheerder. Deze zal dat uw ID voor u instellen.<br /><br />";
$pgv_lang["register_comments_help"]	= "~#pgv_lang[comments]#~<br /><br />Dit vak kunt u gebruiken om aan de beheerder de reden aan te geven, waarom u een gebruikersnaam aanvraagt. Geeft u daarbij ook aan hoe uw relatie is tot personen in deze genealogie. Verder kunt u hier uw overige opmerkingen kwijt.<br /><br />";
$pgv_lang["edit_SEX_help"]			= "~WIJZIG #factarray[SEX]#~<br /><br />Gebruik deze keuze om aan te geven of de persoon <b>#pgv_lang[male]#</b> of <b>#pgv_lang[female]#</b> is. Kies <b>#pgv_lang[unknown]#</b> alleen als u niet zeker bent van het geslacht van de persoon.";
$pgv_lang["edit_NAME_help"]			= "~WIJZIG #factarray[NAME]#~<br /><br />Namen worden ingegeven met een schuine streep \"/\" voor en achter de achternaam van de persoon.<br /><br />Voorbeelden:<ul><li>Voornaam /Achternaam/</li><li>Voornaam /Achternaam/ Jr.</li><li>Voornaam /van Achternaam/ jr.</li></ul>";
$pgv_lang["edit_add_unlinked_person_help"]	= "~#pgv_lang[add_unlinked_person]#~<br /><br />Gebruik deze functie om een niet-gekoppeld persoon toe te voegen.<br />Deze persoon blijft als losse persoon in de genealogie bestaan en is niet verbonden met partner, ouders of kinderen, totdat u de koppeling aanbrengt. Dit kan via het #pgv_lang[relatives]# tabblad op de #pgv_lang[indi_info]# pagina.";
$pgv_lang["edit_URL_help"]			= "~#factarray[URL]#~<br /><br />Een voorbeeld van een Web-URL ziet er als volgt uit: <b>http://www.phpgedview.net</b>. Laat dit vak leeg als u geen Web-URL wilt toevoegen.<br /><br />";
$pgv_lang["edit_EMAIL_help"]		= "~#factarray[EMAIL]#~<br /><br />Voer een e-mailadres in.<br />Een voorbeeld van een e-mailadres is: <b>naam@hotmail.com</b>.<br />Laat dit vak leeg als u geen e-mailadres wilt invoeren.<br /><br />";
$pgv_lang["edit_FAX_help"]			= "~#factarray[FAX]#~<br /><br />Voer het faxnummer in, inclusief de land- en regiocode.<br />Een voorbeeld van een faxnummer is: +31 71 1234567.<br />Als u geen faxnummer wilt invoeren, laat dit vak dan leeg.<br /><br />";
$pgv_lang["edit_PHON_help"]			= "~#factarray[PHON]#~<br /><br />Voer het telefoonnummer in, inclusief de land- en regiocode.<br />Een voorbeeld van een telefoonnummer is: +31 71 1234567.<br />Als u geen telefoonnummer wilt invoeren, laat dit vak dan leeg.<br /><br />";
$pgv_lang["edit_GIVN_help"]			= "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SURN_help"]			= "#pgv_lang[edit_surname_help]#";
$pgv_lang["edit_NSFX_help"]			= "#pgv_lang[edit_suffix_help]#";
$pgv_lang["edit_ADDR_help"]			= "~#factarray[ADDR]#~<br /><br />Voer het adres in, op dezelfde wijze als u het op een envelop zou schrijven.<br /><br />Laat dit vak leeg als u geen adres wilt invoeren.";
$pgv_lang["context_help"]			= "Meer helpinformatie is beschikbaar, click hiervoor op <b>?</b> naast het desbetreffende onderdeel.";
$pgv_lang["edit_WWW_help"]			= "~#factarray[WWW]#~<br /><br />Een voorbeeld van een Web-URL ziet er als volgt uit: <b>http://www.phpgedview.net</b>.<br />Laat dit vak leeg als u geen Web-URL wilt toevoegen.<br /><br />";
?>
