# Pantera Passive Plugin - Check if page has object or applet tag
#
# FILENAME      : check_for_object.py
# CODER         : Simon Roses Femerling
# DATE          : 07/23/2006
# LAST UPDATE   : 07/23/2006
# ABSTRACT      : Check if page has object or applet tag
#       
# - Roses Labs Innovations (RL+I)
# Roses Labs
# http://www.roseslabs.com
#
# Copyright (c) 2003-2006 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial 
# purposes without Roses Labs written permission. 
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software 
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

'''
@author:       Simon Roses Femerling
@license:      GNU General Public License 2.0 or later
@contact:      pantera.proxy@gmail.com
@organization: OWASP / Roses Labs
'''

from panteraPlugins import PPM
import re

plugin_info =  {'id':"CheckForObject",
                'name':"Object Checker",
                'author':"Simon Roses Femerling",
                'email':"sroses@roseslabs.com",
                'version':"0.1",
                'desc':"Check if page has object or applet tag.",
                'tag':"object"  # defined tags else ignore plugin
                } 

class CheckForObject(PPM):
    '''
    CheckForObject class.
    '''
    
    def InitAnalyzer(self):
        '''
        Init function.
        '''
        PPM.__init__(self)
        self.object = re.compile(r'<object([^>]*)>',re.IGNORECASE)
        self.applet = re.compile(r'<applet([^>]*)>',re.IGNORECASE)
    
    def BeginAnalyzer(self,obj):
        '''
        Begin function.
        '''
        self.page_body = obj.printBody(1) # enable gzip decoding

        r = self.object.findall(self.page_body)
        if r:
            self.SetLevel('info')
            self.SetResult(1,'object')
            t = "Page has Object tag ("
            for i in r:
                t += "%s" % i
            t += ")"
            self.SetResultData(t)
        
        r = self.applet.findall(self.page_body)
        if r:
            self.SetLevel('info')
            self.SetResult(1,'object')
            t = "Page has Applet tag ("
            for i in r:
                t += "%s" % i
            t += ")"
            self.SetResultData(t)
                
# RL+I EOF