# Pantera - Web Pen-Test Proxy
#
# FILENAME      : panteraHTML.py
# CODER         : Simon Roses Femerling
# DATE          : 12/06/2004
# LAST UPDATE   : 07/04/2006
# ABSTRACT      : Used by Pantera Proxy to create HTML Pages.
#                 Heavely base on SpikeProxy.
#
# - Roses Labs Innovations (RL+I)
# Roses Labs
# http://www.roseslabs.com
#
# Copyright (c) 2003-2006 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial 
# purposes without Roses Labs written permission. 
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software 
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

'''
@author:       Simon Roses Femerling
@license:      GNU General Public License 2.0 or later
@contact:      pantera.proxy@gmail.com
@organization: OWASP / Roses Labs
'''

#############################################################################################
# classes
#############################################################################################

#############################################################################################
# FUNC     : class PanteraHTML
# PARAMS   : ...
# RETURN   : ...
# ABSTRACT : Pantera HTML class
class PanteraHTML:
    '''
    
    '''

    #############################################################################################
    # FUNC     : def __init__
    # PARAMS   : ...
    # RETURN   : ...
    # ABSTRACT : Init internal variables
    def __init__(self):
        '''
    
        '''
        """ __init__ func """
        self.cssfilename="pantera.css" # our default css file
        self.index_data_rigth = ""
        self.index_data_left = ""
        self.inside = 0
        self.data_footer = "<center><b><a href=\"http://www.roseslabs.com\">Roses Labs</a> (C) 2003-2006</b></center>"
        self.data_header = []
        self.body_param = {}
        return
    # EOF: def __init__

    #############################################################################################
    # FUNC     : def CreateHeader
    # PARAMS   : string, value
    # RETURN   : string
    # ABSTRACT :Create HTML header
    def CreateHeader(self, title="", i=0):
        '''
    
        '''
        """ CreateHeader func """
        self.inside = i
        strhtml=""
        strhtml += "<html>\r\n"
        strhtml += "<head>\r\n"
        strhtml += "<link rel=\"stylesheet\" type=\"text/css\" href=\"%s\"/>\r\n" % self.cssfilename
        strhtml += "<title>%s</title>\r\n" % title
        strhtml += "<meta http-equiv=\"expires\" CONTENT=\"-1\">\r\n"
        strhtml += "<meta http-equiv=\"cache-control\" content=\"no-cache, must-revalidate\" />\r\n"
        strhtml += "<meta http-equiv=\"pragma\" content=\"no-cache\" />\r\n"
        strhtml += "<script language=\"JavaScript\" src=\"js_menu_1.js\"></script>\r\n"
        if len(self.data_header)>0:
            strhtml += "".join(self.data_header) 
        strhtml += "</head>\r\n"
        return strhtml
    # EOF: def CreateHeader
    
    #############################################################################################
    # FUNC     : def CreateHTMLMenu
    # PARAMS   : ...
    # RETURN   : string
    # ABSTRACT : Create HTML menu
    def CreateHTMLMenu(self):
        '''
    
        '''
        """ CreateHTMLMenu func """
        strhtml = ""

        strhtml += "<ul class=\"topmenu\" id=\"dmenu\">"
        
        if self.inside == 1:
            strhtml += "<li class=\"topmenuli\"><a href=\"http://pantera\" class=\"topmenutitle\">Home</a></li>"
        
        strhtml += "<li class=\"topmenuli\"><a href=\"\" class=\"topmenutitle\">File</a>"
        strhtml += "<ul class=\"submenuul\">"
        strhtml += "<li class=\"submenuli\"><a href=\"config_link\">Configuration</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"project_link\">Project Management</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"close_project_link\">Close Project</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"target_management_link\">Domain Management</a></li>"        
        strhtml += "<li class=\"submenuli\"><a href=\"ppa_management\">PPA Management</a></li>"        
        strhtml += "<li class=\"submenuli\"><a href=\"project_notes\">Project Notes</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"pantera_management_link\">Cleaner</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"error_console_link\">Error Console</a></li>"
        #strhtml += "<li class=\"submenuli\"><a href=\"db_recon_link\">DDBB Reconnect</a></li>"        
        #strhtml += "<li class=\"submenuli\"><a href=\"report_link\">Generate Report</a></li>"
        strhtml += "</ul>"
        strhtml += "</li>"
            
        strhtml += "<li class=\"topmenuli\"><a href=\"\" class=\"topmenutitle\">Tools</a>"
        strhtml += "<ul class=\"submenuul\">"
        strhtml += "<li class=\"submenuli\"><a href=\"history_link\">History</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"statistics_link\">Statistics</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"querier_link\">Data Miner</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"ppa_summary_link\">PPA Analysis Summary</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"snitch_link\">The Snitch</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"interceptor_link\">Interceptor</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"replacer_link\">Replacer</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"supress_header_link\">Supress Header</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"session_trace_link\">Session Trace</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"session_raw_link\">Session Trace (Raw)</a></li>"
        #strhtml += "<li class=\"submenuli\"><a href=\"tree_link\">Site Tree</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"http_editor_link\">HTTP Editor</a></li>"
        #strhtml += "<li class=\"submenuli\"><a href=\"reconstruct_link\">Reconstruct Site</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"utils_link\">Utilities</a></li>"
        strhtml += "</ul>"
        strhtml += "</li>"

        #strhtml += "<li class=\"topmenuli\"><a href=\"\" class=\"topmenutitle\">Modules</a>"
        #strhtml += "<ul class=\"submenuul\">"
        #strhtml += "<li class=\"submenuli\"><a href=\"scan_engine_link\">Scanning Engine Modules</a></li>"
        #strhtml += "<li class=\"submenuli\"><a href=\"analysis_modules_link\">Aplication Analysis Modules</a></li>"
        #strhtml += "</ul>"
        #strhtml += "</li>"
        
        strhtml += "<li class=\"topmenuli\"><a href=\"\" class=\"topmenutitle\">Help</a>"
        strhtml += "<ul class=\"submenuul\">"
        #strhtml += "<li class=\"submenuli\"><a href=\"help_link\">Help</a></li>"
        #strhtml += "<li class=\"submenuli\"><a href=\"tutorial_link\">Tutorial</a></li>"
        #strhtml += "<li class=\"submenuli\"><a href=\"external_doc_link\">External Documentation</a></li>"
        strhtml += "<li class=\"submenuli\"><a href=\"about_pantera_link\">About Pantera</a></li>"
        strhtml += "</ul>"
        strhtml += "</li>"

        strhtml += "</ul>"
        return strhtml
    # EOF: def CreateHTMLMenu

    #############################################################################################
    # FUNC     : def CreateHomePage
    # PARAMS   : string
    # RETURN   : string
    # ABSTRACT : Create home page
    def CreateHomePage(self, title = ""):
        '''
    
        '''
        """ CreateHomePage func """
        strhtml=""
        if len(self.body_param)>0:
            strhtml += "<body "
            for k,v in self.body_param:
                strhtml += "%s=%s " % (k,v)
            strhtml += ">\r\n"
        else:
            strhtml += "<body>\r\n"
        
        strhtml += "<div id=\"wrap_content\">\r\n"
        
        strhtml += "<div id=\"header_content\">\r\n"
        strhtml += "<h3>Pantera Web Assessment Studio (WAS) Project: %s</h3>\r\n" % title
        strhtml += "</div>\r\n"
        
        #strhtml += "<div id=\"navbar_content\">\r\n"
        strhtml += self.CreateHTMLMenu()
        #strhtml += "</div>\r\n"
        
        strhtml += "<div id=\"rigth_content\">\r\n"
        strhtml += self.index_data_rigth
        strhtml += "</div>\r\n"

        strhtml += "<div id=\"left_content\">\r\n"
        strhtml += "<p><img src=\"./img/panther.gif\"/></p>\r\n"
        strhtml += "</div>\r\n"
        
        strhtml += "<div id=\"footer_content\">\r\n"
        strhtml += "%s\r\n" % self.data_footer
        strhtml += "</div>\r\n"

        strhtml += "</div>\r\n"
        strhtml += "</body>\r\n"
        strhtml += "</html>\r\n"        
        return strhtml
    # EOF: def CreateHomePage

    #############################################################################################
    # FUNC     : def SetDataRigth
    # PARAMS   : string
    # RETURN   : ...
    # ABSTRACT : Set data in rigth view
    def SetDataRigth(self,d):
        '''
    
        '''
        """ SetDataRigth func """
        self.index_data_rigth = d
    # EOF: def SetDataRigth

    #############################################################################################
    # FUNC     : def DeleteDataRigth
    # PARAMS   : ...
    # RETURN   : ...
    # ABSTRACT : Delete data in rigth view
    def DeleteDataRigth(self):
        '''
    
        '''
        """ DeleteDataRigth func """
        self.index_data_rigth = ""
    # EOF: def DeleteDataRigth

    #############################################################################################
    # FUNC     : def CreatePage
    # PARAMS   : string, string, string
    # RETURN   : string
    # ABSTRACT : Create HTML page
    def CreatePage(self, title = "",link = "", data = ""):
        '''
    
        '''
        """ CreatePage func """
        strhtml=""
        if len(self.body_param)>0:
            strhtml += "<body "
            for k,v in self.body_param:
                strhtml += "%s=%s " % (k,v)
            strhtml += ">\r\n"
        else:
            strhtml += "<body>\r\n"
        
        strhtml += "<div id=\"wrap_content\">\r\n"
        
        strhtml += "<div id=\"header_content\">\r\n"
        strhtml += "<h3>%s</h3>" % title
        if link:
            strhtml += "<input type=\"text\" value=\"%s\" size=\"140\" />\r\n" % link         
        strhtml += "</div>\r\n"
        
        #strhtml += "<div id=\"navbar_content\">\r\n"
        strhtml += self.CreateHTMLMenu()
        #strhtml += "</div>\r\n"
        
        strhtml += "<div id=\"onebox_content\">\r\n"         
        strhtml += "<p>%s</p>\r\n" % data
        strhtml += "</div>\r\n"
               
        strhtml += "<div id=\"footer_content\">\r\n"
        strhtml += "%s\r\n" % self.data_footer
        strhtml += "</div>\r\n"

        strhtml += "</div>\r\n"
        strhtml += "</body>\r\n"
        strhtml += "</html>\r\n"        
        return strhtml
    # EOF: def CreatePage

    #############################################################################################
    # FUNC     : def SetCSSFile
    # PARAMS   : string
    # RETURN   : ...
    # ABSTRACT : Set CSS file
    def SetCSSFile(self, fil=""):
        '''
    
        '''
        """ SetCSSFile func """
        self.cssfilename = fil
    # EOF: def SetCSSFile

    #############################################################################################
    # FUNC     : def ReturnCSSFile
    # PARAMS   : ...
    # RETURN   : string
    # ABSTRACT : Return CSS file
    def ReturnCSSFile(self):
        '''
    
        '''
        """ ReturnCSSFile func """
        return self.cssfilename
    # EOF: def ReturnCSSFile

    #############################################################################################
    # FUNC     : def ReturnNotImplementedYet
    # PARAMS   : ...
    # RETURN   : string
    # ABSTRACT : Return not implement string
    def ReturnNotImplementedYet(self):
        '''
    
        '''
        """ ReturnNotImplementedYet func """
        return "<html><head><title>Error</title></head><body><h1>Not implemented yet, sorry.</h1></body></html>"
    # EOF: def ReturnNotImplementedYet

    #############################################################################################
    # FUNC     : def SetDataFooter
    # PARAMS   : string
    # RETURN   : ...
    # ABSTRACT : Set footer data
    def SetDataFooter(self, d):
        '''
    
        '''
        """ SetDataFooter func """
        self.data_footer = d
    # EOF: def SetDataFooter
        
    #############################################################################################
    # FUNC     : def ReturnDataFooter
    # PARAMS   : ...
    # RETURN   : string
    # ABSTRACT : Return footer data
    def ReturnDataFooter(self):
        '''
    
        '''
        """ ReturnDataFooter func """
        return self.data_footer
    # EOF: def ReturnDataFooter

    #############################################################################################
    # FUNC     : def SetDataHeader
    # PARAMS   : string
    # RETURN   : ...
    # ABSTRACT : Add HTML header tags
    def SetDataHeader(self, d):
        '''
    
        '''
        """ SetDataHeader func """
        self.data_header.append(d)
    # EOF: def SetDataHeader
        
    #############################################################################################
    # FUNC     : def ReturnDataHeader
    # PARAMS   : ...
    # RETURN   : list
    # ABSTRACT : Return HTML header tags
    def ReturnDataHeader(self):
        '''
    
        '''
        """ ReturnDataHeader func """
        return self.data_header
    # EOF: def ReturnDataHeader

    #############################################################################################
    # FUNC     : def SetBodyParam
    # PARAMS   : string, string
    # RETURN   : ...
    # ABSTRACT : Set body params
    def SetBodyParam(self, key, value):
        '''
    
        '''
        """ SetBodyParam func """
        self.body_param[key] = value
    # EOF: def SetBodyParam

    #############################################################################################
    # FUNC     : def GetBodyParam
    # PARAMS   : ...
    # RETURN   : string
    # ABSTRACT : Get body params
    def GetBodyParam(self):
        '''
    
        '''
        """ GetBodyParam func """
        return self.body_param
    # EOF: def GetBodyParam

    #############################################################################################
    # FUNC     : def ReturnTimerScript
    # PARAMS   : int
    # RETURN   : string
    # ABSTRACT : Get js timer script
    #            Ripped from http://www.mcfedries.com/JavaScript/timer.asp
    def ReturnTimerScript(self, secs=100):
        '''
    
        '''
        """ ReturnTimerScript func """
        s = ""
        
        s += "<script language = \"JavaScript\">\r\n"
        s += "<!--\r\n"
        s += "var secs\r\n"
        s += "var timerID = null\r\n"
        s += "var timerRunning = false\r\n"
        s += "var delay = 1000\r\n"
        s += "function InitializeTimer()\r\n"
        s += "{\r\n"
        s += "// Set the length of the timer, in seconds\r\n"
        s += "secs = %s\r\n" % secs
        s += "StopTheClock()\r\n"
        s += "StartTheTimer()\r\n"
        s += "}\r\n"
        s += "function StopTheClock()\r\n"
        s += "{\r\n"
        s += "if(timerRunning)\r\n"
        s += "clearTimeout(timerID)\r\n"
        s += "timerRunning = false\r\n"
        s += "}\r\n"
        s += "function StartTheTimer()\r\n"
        s += "{\r\n"
        s += "if (secs==0)\r\n"
        s += "{\r\n"
        s += "StopTheClock()\r\n"
        s += "window.location.reload()\r\n" # Reload page!
        s += "}\r\n"
        s += "else\r\n"
        s += "{\r\n"
        s += "self.status = secs\r\n"
        s += "secs = secs - 1\r\n"
        s += "timerRunning = true\r\n"
        s += "timerID = self.setTimeout(\"StartTheTimer()\", delay)\r\n"
        s += "}\r\n"
        s += "}\r\n"
        s += "//-->\r\n"
        s += "</script>\r\n"
    
        return s
    # EOF: def ReturnTimerScript

    #############################################################################################
    # FUNC     : def ReturnTextSearchScript
    # PARAMS   : ...
    # RETURN   : string
    # ABSTRACT : Get js text search script
    #            Ripped from http://www.javascripter.net/faq/searchin.htm
    def ReturnTextSearchScript(self):
        '''
    
        '''
        """ ReturnTextSearchScript func """
        s = ""
        
        s += "<script language=\"JavaScript\">\r\n"
        s += "<!--\r\n"
        s += "var TRange=null\r\n"
        s += "function findString (str) {\r\n"
        s += " if (parseInt(navigator.appVersion)<4) return;\r\n"
        s += "var strFound;\r\n"
        s += "if (navigator.appName==\"Netscape\") {\r\n"
        s += "// NAVIGATOR-SPECIFIC CODE\r\n"
        s += "strFound=self.find(str);\r\n"
        s += "if (!strFound) {\r\n"
        s += "strFound=self.find(str,0,1)\r\n"
        s += "while (self.find(str,0,1)) continue\r\n"
        s += "}\r\n"
        s += "}\r\n"
        s += "if (navigator.appName.indexOf(\"Microsoft\")!=-1) {\r\n"
        s += "// EXPLORER-SPECIFIC CODE\r\n"
        s += "if (TRange!=null) {\r\n"
        s += "TRange.collapse(false)\r\n"
        s += "strFound=TRange.findText(str)\r\n"
        s += "if (strFound) TRange.select()\r\n"
        s += "}\r\n"
        s += "if (TRange==null || strFound==0) {\r\n"
        s += "TRange=self.document.body.createTextRange()\r\n"
        s += "strFound=TRange.findText(str)\r\n"
        s += "if (strFound) TRange.select()\r\n"
        s += "}\r\n"
        s += "}\r\n"
        s += "if (!strFound) alert (\"String '\"+str+\"' not found!\")\r\n"
        s += "}\r\n"
        s += "//-->\r\n"
        s += "</script>\r\n"
        
        return s

# RL+I EOF
