/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.text.rules;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpeclipse.ui.text.rules.FlatNode;
import net.sourceforge.phpeclipse.ui.text.rules.IDocumentView;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;

public class OuterDocumentView
extends AbstractDocument
implements IDocumentView {
    IDocument parent;
    List ranges;

    public OuterDocumentView(IDocument parent, List ranges) {
        this.parent = parent;
        this.ranges = ranges;
        this.setTextStore(new TextStore());
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        int length = this.getLength();
        if (length < 0) {
            length = 0;
        }
        this.getTracker().set(this.getStore().get(0, length));
        this.completeInitialization();
    }

    protected void fireDocumentAboutToBeChanged(DocumentEvent event) {
        super.fireDocumentAboutToBeChanged(event);
    }

    protected void fireDocumentChanged(DocumentEvent event) {
        try {
            this.getTracker().replace(event.getOffset(), event.getLength(), event.getText());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (BadLocationException badLocationException) {}
        super.fireDocumentChanged(event);
    }

    public IDocument getParentDocument() {
        return this.parent;
    }

    public int getParentOffset(int localOffset) {
        int offset = localOffset;
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            FlatNode range = (FlatNode)i.next();
            if (offset < range.offset) break;
            offset += range.length;
        }
        return offset;
    }

    public int getLocalOffset(int parentOffset) {
        int localOffset = parentOffset;
        Iterator i = this.ranges.iterator();
        while (i.hasNext()) {
            FlatNode range = (FlatNode)i.next();
            if (parentOffset <= range.offset) break;
            if (parentOffset <= range.offset + range.length) {
                localOffset -= parentOffset - range.offset;
                break;
            }
            localOffset -= range.length;
        }
        if (localOffset < 0) {
            return 0;
        }
        if (localOffset > this.getLength()) {
            return this.getLength();
        }
        return localOffset;
    }

    class TextStore
    implements ITextStore {
        TextStore() {
        }

        public void set(String txt) {
            try {
                OuterDocumentView.this.parent.replace(0, OuterDocumentView.this.parent.getLength(), txt);
            }
            catch (BadLocationException badLocationException) {}
        }

        public void replace(int offset, int length, String txt) {
            try {
                int start = OuterDocumentView.this.getParentOffset(offset);
                int end = OuterDocumentView.this.getParentOffset(offset + length - 1) + 1;
                OuterDocumentView.this.parent.replace(start, end - start, txt);
            }
            catch (BadLocationException badLocationException) {}
        }

        public int getLength() {
            int length = OuterDocumentView.this.parent.getLength();
            Iterator i = OuterDocumentView.this.ranges.iterator();
            while (i.hasNext()) {
                length -= ((FlatNode)i.next()).length;
            }
            return length;
        }

        public String get(int offset, int length) {
            StringBuffer buf = new StringBuffer(length);
            try {
                FlatNode range = null;
                Iterator i = OuterDocumentView.this.ranges.iterator();
                while (i.hasNext()) {
                    range = (FlatNode)i.next();
                    if (offset < range.offset) break;
                    offset += range.length;
                    range = null;
                }
                int remainder = length - buf.length();
                while (remainder > 0) {
                    if (range == null || offset + remainder < range.offset) {
                        buf.append(OuterDocumentView.this.parent.get(offset, remainder));
                        break;
                    }
                    buf.append(OuterDocumentView.this.parent.get(offset, range.offset - offset));
                    offset = range.offset + range.length;
                    range = i.hasNext() ? (FlatNode)i.next() : null;
                    remainder = length - buf.length();
                }
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
            return buf.toString();
        }

        public char get(int offset) {
            try {
                return OuterDocumentView.this.parent.getChar(OuterDocumentView.this.getParentOffset(offset));
            }
            catch (BadLocationException badLocationException) {
                return '\u0000';
            }
        }
    }
}

