/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.preferences;

import net.sourceforge.phpeclipse.ui.preferences.PreferenceDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class OverlayPreferenceStore
implements IPreferenceStore {
    IPreferenceStore parent;
    IPreferenceStore store;
    private PreferenceDescriptor[] keys;
    private PropertyListener fPropertyListener;

    public OverlayPreferenceStore(IPreferenceStore parent, PreferenceDescriptor[] overlayKeys) {
        this.parent = parent;
        this.keys = overlayKeys;
        this.store = new PreferenceStore();
    }

    PreferenceDescriptor findOverlayKey(String key) {
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].key.equals(key)) {
                return this.keys[i];
            }
            ++i;
        }
        return null;
    }

    private boolean covers(String key) {
        return this.findOverlayKey(key) != null;
    }

    void propagateProperty(IPreferenceStore orgin, PreferenceDescriptor key, IPreferenceStore target) {
        if (orgin.isDefault(key.key)) {
            if (!target.isDefault(key.key)) {
                target.setToDefault(key.key);
            }
            return;
        }
        PreferenceDescriptor.Type d = key.type;
        if (PreferenceDescriptor.BOOLEAN == d) {
            boolean originValue = orgin.getBoolean(key.key);
            boolean targetValue = target.getBoolean(key.key);
            if (targetValue != originValue) {
                target.setValue(key.key, originValue);
            }
        } else if (PreferenceDescriptor.DOUBLE == d) {
            double originValue = orgin.getDouble(key.key);
            double targetValue = target.getDouble(key.key);
            if (targetValue != originValue) {
                target.setValue(key.key, originValue);
            }
        } else if (PreferenceDescriptor.FLOAT == d) {
            float originValue = orgin.getFloat(key.key);
            float targetValue = target.getFloat(key.key);
            if (targetValue != originValue) {
                target.setValue(key.key, originValue);
            }
        } else if (PreferenceDescriptor.INT == d) {
            int originValue = orgin.getInt(key.key);
            int targetValue = target.getInt(key.key);
            if (targetValue != originValue) {
                target.setValue(key.key, originValue);
            }
        } else if (PreferenceDescriptor.LONG == d) {
            long originValue = orgin.getLong(key.key);
            long targetValue = target.getLong(key.key);
            if (targetValue != originValue) {
                target.setValue(key.key, originValue);
            }
        } else if (PreferenceDescriptor.STRING == d) {
            String originValue = orgin.getString(key.key);
            String targetValue = target.getString(key.key);
            if (targetValue != null && originValue != null && !targetValue.equals(originValue)) {
                target.setValue(key.key, originValue);
            }
        }
    }

    public void propagate() {
        int i = 0;
        while (i < this.keys.length) {
            this.propagateProperty(this.store, this.keys[i], this.parent);
            ++i;
        }
    }

    private void loadProperty(IPreferenceStore orgin, PreferenceDescriptor key, IPreferenceStore target, boolean forceInitialization) {
        PreferenceDescriptor.Type d = key.type;
        if (PreferenceDescriptor.BOOLEAN == d) {
            if (forceInitialization) {
                target.setValue(key.key, true);
            }
            target.setValue(key.key, orgin.getBoolean(key.key));
            target.setDefault(key.key, orgin.getDefaultBoolean(key.key));
        } else if (PreferenceDescriptor.DOUBLE == d) {
            if (forceInitialization) {
                target.setValue(key.key, 1.0);
            }
            target.setValue(key.key, orgin.getDouble(key.key));
            target.setDefault(key.key, orgin.getDefaultDouble(key.key));
        } else if (PreferenceDescriptor.FLOAT == d) {
            if (forceInitialization) {
                target.setValue(key.key, 1.0f);
            }
            target.setValue(key.key, orgin.getFloat(key.key));
            target.setDefault(key.key, orgin.getDefaultFloat(key.key));
        } else if (PreferenceDescriptor.INT == d) {
            if (forceInitialization) {
                target.setValue(key.key, 1);
            }
            target.setValue(key.key, orgin.getInt(key.key));
            target.setDefault(key.key, orgin.getDefaultInt(key.key));
        } else if (PreferenceDescriptor.LONG == d) {
            if (forceInitialization) {
                target.setValue(key.key, 1L);
            }
            target.setValue(key.key, orgin.getLong(key.key));
            target.setDefault(key.key, orgin.getDefaultLong(key.key));
        } else if (PreferenceDescriptor.STRING == d) {
            if (forceInitialization) {
                target.setValue(key.key, "1");
            }
            target.setValue(key.key, orgin.getString(key.key));
            target.setDefault(key.key, orgin.getDefaultString(key.key));
        }
    }

    public void load() {
        int i = 0;
        while (i < this.keys.length) {
            this.loadProperty(this.parent, this.keys[i], this.store, true);
            ++i;
        }
    }

    public void loadDefaults() {
        int i = 0;
        while (i < this.keys.length) {
            this.setToDefault(this.keys[i].key);
            ++i;
        }
    }

    public void start() {
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
            this.parent.addPropertyChangeListener((IPropertyChangeListener)this.fPropertyListener);
        }
    }

    public void stop() {
        if (this.fPropertyListener != null) {
            this.parent.removePropertyChangeListener((IPropertyChangeListener)this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.store.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.store.removePropertyChangeListener(listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.store.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public boolean contains(String name) {
        return this.store.contains(name);
    }

    public boolean getBoolean(String name) {
        return this.store.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.store.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.store.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.store.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.store.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.store.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.store.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.store.getDouble(name);
    }

    public float getFloat(String name) {
        return this.store.getFloat(name);
    }

    public int getInt(String name) {
        return this.store.getInt(name);
    }

    public long getLong(String name) {
        return this.store.getLong(name);
    }

    public String getString(String name) {
        return this.store.getString(name);
    }

    public boolean isDefault(String name) {
        return this.store.isDefault(name);
    }

    public boolean needsSaving() {
        return this.store.needsSaving();
    }

    public void putValue(String name, String value) {
        if (this.covers(name)) {
            this.store.putValue(name, value);
        }
    }

    public void setDefault(String name, double value) {
        if (this.covers(name)) {
            this.store.setDefault(name, value);
        }
    }

    public void setDefault(String name, float value) {
        if (this.covers(name)) {
            this.store.setDefault(name, value);
        }
    }

    public void setDefault(String name, int value) {
        if (this.covers(name)) {
            this.store.setDefault(name, value);
        }
    }

    public void setDefault(String name, long value) {
        if (this.covers(name)) {
            this.store.setDefault(name, value);
        }
    }

    public void setDefault(String name, String value) {
        if (this.covers(name)) {
            this.store.setDefault(name, value);
        }
    }

    public void setDefault(String name, boolean value) {
        if (this.covers(name)) {
            this.store.setDefault(name, value);
        }
    }

    public void setToDefault(String name) {
        this.store.setToDefault(name);
    }

    public void setValue(String name, double value) {
        if (this.covers(name)) {
            this.store.setValue(name, value);
        }
    }

    public void setValue(String name, float value) {
        if (this.covers(name)) {
            this.store.setValue(name, value);
        }
    }

    public void setValue(String name, int value) {
        if (this.covers(name)) {
            this.store.setValue(name, value);
        }
    }

    public void setValue(String name, long value) {
        if (this.covers(name)) {
            this.store.setValue(name, value);
        }
    }

    public void setValue(String name, String value) {
        if (this.covers(name)) {
            this.store.setValue(name, value);
        }
    }

    public void setValue(String name, boolean value) {
        if (this.covers(name)) {
            this.store.setValue(name, value);
        }
    }

    private class PropertyListener
    implements IPropertyChangeListener {
        private PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            PreferenceDescriptor key = OverlayPreferenceStore.this.findOverlayKey(event.getProperty());
            if (key != null) {
                OverlayPreferenceStore.this.propagateProperty(OverlayPreferenceStore.this.parent, key, OverlayPreferenceStore.this.store);
            }
        }
    }
}

