/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.editor;

import net.sourceforge.phpeclipse.core.model.ISourceModel;
import net.sourceforge.phpeclipse.core.model.ISourceReference;
import net.sourceforge.phpeclipse.ui.text.IReconcilingParticipant;
import net.sourceforge.phpeclipse.ui.views.outline.ModelBasedOutlinePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class StructuredTextEditor
extends TextEditor
implements IReconcilingParticipant {
    private IContentOutlinePage outlinePage;
    private ISelectionChangedListener outlinePageSelectionListener;
    static /* synthetic */ Class class$0;

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter.equals(clazz)) {
            if (this.outlinePage == null) {
                this.outlinePage = this.createOutlinePage();
                this.outlinePageSelectionListener = new OutlineSelectionChangedListener();
                this.outlinePage.addSelectionChangedListener(this.outlinePageSelectionListener);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        this.highlightElement(this.computeHighlightRangeSourceReference(), false);
        this.synchronizeOutlinePageSelection();
    }

    public void reconciled() {
        Shell shell = this.getSite().getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (StructuredTextEditor.this.outlinePage instanceof IUpdate) {
                        ((IUpdate)StructuredTextEditor.this.outlinePage).update();
                    }
                    StructuredTextEditor.this.synchronizeOutlinePageSelection();
                }
            });
        }
    }

    public ISourceReference computeHighlightRangeSourceReference() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return null;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return null;
        }
        int offset = sourceViewer.getVisibleRegion().getOffset();
        int caret = offset + styledText.getCaretOffset();
        return this.getElementAt(caret);
    }

    public ISourceReference getElementAt(int offset) {
        ISourceReference retVal = null;
        ISourceModel model = this.getSourceModel();
        if (model != null) {
            ISourceReference[] elements = model.getElements();
            retVal = StructuredTextEditor.getElementAt(model, elements, offset);
        }
        return retVal;
    }

    public abstract ISourceModel getSourceModel();

    public void outlinePageClosed() {
        if (this.outlinePage != null) {
            this.outlinePage.removeSelectionChangedListener(this.outlinePageSelectionListener);
            this.outlinePage = null;
            this.resetHighlightRange();
        }
    }

    public void synchronizeOutlinePage(ISourceReference element) {
        if (this.outlinePage != null) {
            this.outlinePage.removeSelectionChangedListener(this.outlinePageSelectionListener);
            if (this.outlinePage instanceof ModelBasedOutlinePage) {
                ((ModelBasedOutlinePage)this.outlinePage).select(element);
            }
            this.outlinePage.addSelectionChangedListener(this.outlinePageSelectionListener);
        }
    }

    public void synchronizeOutlinePage() {
        ISourceReference element = this.computeHighlightRangeSourceReference();
        this.synchronizeOutlinePage(element);
    }

    protected abstract IContentOutlinePage createOutlinePage();

    protected final void highlightElement(ISourceReference element, boolean moveCursor) {
        if (element != null) {
            IRegion highlightRegion = element.getSourceRegion();
            this.setHighlightRange(highlightRegion.getOffset(), highlightRegion.getLength(), moveCursor);
        } else {
            this.resetHighlightRange();
        }
    }

    protected abstract boolean isOutlineLinkedWithEditor();

    private static ISourceReference getElementAt(ISourceModel model, ISourceReference[] elements, int offset) {
        ISourceReference retVal = null;
        int i = 0;
        while (i < elements.length) {
            ISourceReference element = elements[i];
            IRegion region = element.getSourceRegion();
            if (offset > region.getOffset() && offset < region.getOffset() + region.getLength()) {
                ISourceReference[] children = model.getChildren(element);
                if (children.length > 0 && (retVal = StructuredTextEditor.getElementAt(model, children, offset)) != null) break;
                if (retVal == null) {
                    retVal = element;
                }
            }
            ++i;
        }
        return retVal;
    }

    private void synchronizeOutlinePageSelection() {
        boolean linkWithEditor;
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null && (linkWithEditor = this.isOutlineLinkedWithEditor())) {
            this.synchronizeOutlinePage(this.computeHighlightRangeSourceReference());
        }
    }

    private class OutlineSelectionChangedListener
    implements ISelectionChangedListener {
        private OutlineSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                StructuredTextEditor.this.resetHighlightRange();
            } else {
                ISourceReference element = (ISourceReference)selection.getFirstElement();
                StructuredTextEditor.this.highlightElement(element, true);
            }
        }
    }
}

