/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui;

import java.io.IOException;
import java.net.URL;
import net.sourceforge.phpeclipse.ui.IPreferenceConstants;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WebUI
extends AbstractUIPlugin
implements IPreferenceConstants {
    public static final String PLUGIN_ID = "net.sourceforge.phpeclipse.ui";
    private static final String CUSTOM_TEMPLATES_KEY = "net.sourceforge.phpeclipse.ui.templates";
    public static final String ICON_OVERLAY_ERROR = "full/ovr16/error_co.gif";
    public static final String ICON_OVERLAY_WARNING = "full/ovr16/warning_co.gif";
    private static WebUI plugin;
    private ContributionContextTypeRegistry fRegistry;
    private TemplateStore fStore;

    public static IWorkbenchPage getActivePage() {
        return WebUI.getDefault().internalGetActivePage();
    }

    private IWorkbenchPage internalGetActivePage() {
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        return WebUI.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return WebUI.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static WebUI getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public WebUI() {
        plugin = this;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ContributionContextTypeRegistry();
            this.fRegistry.addContextType("xml");
            this.fRegistry.addContextType("html");
            this.fRegistry.addContextType("smarty");
            this.fRegistry.addContextType("javascript");
        }
        return this.fRegistry;
    }

    private ImageDescriptor getImageDescriptor(String key) {
        try {
            URL url = this.getBundle().getEntry("/icons/" + key);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), WebUI.getDefault().getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this.fStore.load();
            }
            catch (IOException e) {
                WebUI.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, "", (Throwable)e));
            }
        }
        return this.fStore;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("_php_localhost", "http://localhost");
        store.setDefault("_php_documentroot", WebUI.getWorkspace().getRoot().getFullPath().toString());
        store.setDefault("_auto_preview", "false");
        store.setDefault("_bring_to_top_preview", "false");
        store.setDefault("_sticky_browser_url", "false");
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(ICON_OVERLAY_ERROR, this.getImageDescriptor(ICON_OVERLAY_ERROR));
        reg.put(ICON_OVERLAY_WARNING, this.getImageDescriptor(ICON_OVERLAY_WARNING));
    }

    public static void log(IStatus status) {
        WebUI.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        WebUI.log((IStatus)new Status(4, PLUGIN_ID, 4, e.getLocalizedMessage(), e));
    }
}

