/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.phpeclipse.xdebug.core.IProxyEventListener;
import net.sourceforge.phpeclipse.xdebug.core.PHPDebugUtils;
import net.sourceforge.phpeclipse.xdebug.core.PathMapItem;
import net.sourceforge.phpeclipse.xdebug.core.XDebugCorePlugin;
import net.sourceforge.phpeclipse.xdebug.core.XDebugProxy;
import net.sourceforge.phpeclipse.xdebug.core.xdebug.ResponseListener;
import net.sourceforge.phpeclipse.xdebug.core.xdebug.XDebugConnection;
import net.sourceforge.phpeclipse.xdebug.core.xdebug.XDebugResponse;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugElement;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugLineBreakpoint;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugThread;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XDebugTarget
extends XDebugElement
implements IDebugTarget,
IDebugEventSetListener,
IProxyEventListener {
    private IProcess fProcess;
    private ILaunch fLaunch;
    private int fDebugPort;
    private boolean fSuspended = false;
    private boolean fTerminated = false;
    private XDebugThread fThread;
    private IThread[] fThreads;
    private XDebugConnection fDebugConnection;
    private ResponseListener fResponseListener;
    private String fIdeKey;

    public XDebugTarget(ILaunch launch, IProcess process, String ideKey) throws CoreException {
        this.fLaunch = launch;
        this.fProcess = process;
        this.fDebugConnection = null;
        this.fThread = null;
        this.fThreads = new IThread[0];
        this.fIdeKey = ideKey;
        this.fDebugPort = XDebugCorePlugin.getDefault().getPreferenceStore().getInt("debugport");
        if (this.fDebugPort == 0) {
            this.fDebugPort = 9000;
        }
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return this.fThreads;
    }

    public boolean hasThreads() throws DebugException {
        return this.fThreads.length > 0;
    }

    public String getName() throws DebugException {
        return "PHP XDebug Client at localhost:" + this.fDebugPort;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals("net.sourceforge.phpeclipse.xdebug.php");
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        if (this.getProcess() != null) {
            return this.getProcess().canTerminate();
        }
        return true;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (this.fTerminated) {
            return;
        }
        if (XDebugCorePlugin.getDefault() != null) {
            XDebugProxy proxy = XDebugCorePlugin.getDefault().getXDebugProxy();
            proxy.removeProxyEventListener(this, this.fIdeKey);
            System.out.println("XDebug.Target: ProxyEventlistener removed");
            this.fTerminated = true;
            this.fSuspended = false;
            XDebugCorePlugin.getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
            this.fireEvent(new DebugEvent((Object)this, 8));
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }
    }

    public boolean canResume() {
        return false;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        if (this.fDebugConnection != null) {
            this.fThread.setBreakpoints(null);
            this.resumed(1);
            this.fDebugConnection.run();
        }
    }

    private void resumed(int detail) {
        this.fSuspended = false;
        this.fThread.fireResumeEvent(detail);
    }

    public void suspended(int detail) {
        this.fSuspended = true;
        this.fThread.fireSuspendEvent(detail);
    }

    public void suspend() throws DebugException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void breakpointAdded(IBreakpoint breakpoint) {
        IMarker marker = breakpoint.getMarker();
        IPath path = marker.getResource().getLocation();
        IPath cp = path.removeLastSegments(1);
        List pathMap = null;
        try {
            pathMap = this.fLaunch.getLaunchConfiguration().getAttribute("net.sourceforge.phpeclipse.xdebug.php.ATTR_PHP_PATHMAP", null);
        }
        catch (CoreException e2) {
            e2.printStackTrace();
        }
        if (this.fDebugConnection == null || this.fDebugConnection.isClosed()) return;
        if (this.fProcess == null) {
            PathMapItem pmi = null;
            int i = 0;
            while (i < pathMap.size()) {
                pmi = new PathMapItem((String)pathMap.get(i));
                IPath local = (IPath)pmi.getLocalPath().clone();
                local = local.makeAbsolute();
                int matchedSegments = local.segmentCount();
                if (local.matchingFirstSegments(cp) == matchedSegments) {
                    IPath newPath = pmi.getRemotePath();
                    newPath = newPath.append(path.removeFirstSegments(matchedSegments));
                    newPath = newPath.makeAbsolute();
                    if (this.supportsBreakpoint(breakpoint)) {
                        try {
                            int id;
                            XDebugResponse dr;
                            String bpid;
                            if (breakpoint.isEnabled() && marker != null && !"".equals(bpid = (dr = this.getResponse(id = this.fDebugConnection.breakpointSet(newPath.toString(), ((ILineBreakpoint)breakpoint).getLineNumber(), marker.getAttribute("net.sourceforge.phpeclipse.xdebug.php.model.hitCount", -1)))).getAttributeValue("id"))) {
                                marker.setAttribute("XDebugLineBreakpointID", Integer.parseInt(bpid));
                            }
                        }
                        catch (DebugException e) {
                            e.printStackTrace();
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
            return;
        }
        if (!this.supportsBreakpoint(breakpoint)) return;
        try {
            int id;
            XDebugResponse dr;
            String bpid;
            if (!breakpoint.isEnabled() || marker == null || "".equals(bpid = (dr = this.getResponse(id = this.fDebugConnection.breakpointSet(path.toString(), ((ILineBreakpoint)breakpoint).getLineNumber(), marker.getAttribute("net.sourceforge.phpeclipse.xdebug.php.model.hitCount", -1)))).getAttributeValue("id"))) return;
            marker.setAttribute("XDebugLineBreakpointID", Integer.parseInt(bpid));
            return;
        }
        catch (DebugException e) {
            e.printStackTrace();
            return;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                int id = ((XDebugLineBreakpoint)breakpoint).getID();
                if (id > 0) {
                    this.fDebugConnection.breakpointRemove(id);
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public void started() throws DebugException {
        int id2;
        XDebugResponse response2;
        this.fThread.setBreakpoints(null);
        this.fThread.setStepping(false);
        int id = this.fDebugConnection.featureGet("detach");
        XDebugResponse response = this.getResponse(id);
        Integer.parseInt(response.getValue());
        System.out.println("in Target.started()");
        int id1 = this.fDebugConnection.featureSet("max_depth", "1024");
        XDebugResponse response1 = this.getResponse(id1);
        if (response1.getAttributeValue("success").equals("1")) {
            System.out.println("Set depth to 1024 (hack)");
        }
        if ((response2 = this.getResponse(id2 = this.fDebugConnection.featureSet("max_children", "1024"))).getAttributeValue("success").equals("1")) {
            System.out.println("Set children to 1024 (hack)");
        }
        this.installDeferredBreakpoints();
        try {
            this.resume();
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    private void installDeferredBreakpoints() {
        IBreakpoint[] breakpoints = XDebugCorePlugin.getBreakpoints();
        int i = 0;
        while (i < breakpoints.length) {
            this.breakpointAdded(breakpoints[i]);
            ++i;
        }
    }

    public XDebugResponse getStackFrames() throws DebugException {
        int id = this.fDebugConnection.stackGet();
        XDebugResponse lastResponse = this.getResponse(id);
        return lastResponse;
    }

    protected void step_over() throws DebugException {
        this.fThread.setStepping(true);
        this.resumed(2);
        this.fDebugConnection.stepOver();
    }

    protected void step_into() throws DebugException {
        this.fThread.setStepping(true);
        this.resumed(1);
        this.fDebugConnection.stepInto();
    }

    protected void step_out() throws DebugException {
        this.fThread.setStepping(true);
        this.resumed(4);
        this.fDebugConnection.stepOut();
    }

    public boolean setVarValue(String name, String value) {
        int id = this.fDebugConnection.setVarValue(name, value);
        XDebugResponse response = this.getResponse(id);
        return response.getAttributeValue("success").equals("1");
    }

    public Node eval(String expression) throws DebugException {
        Node evalProperty = null;
        if (this.fDebugConnection != null) {
            int id = this.fDebugConnection.eval(expression);
            XDebugResponse response = this.getResponse(id);
            Node evalResponse = response.getParentNode();
            evalProperty = evalResponse.getFirstChild();
        } else {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            Document doc = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            doc = builder.newDocument();
            evalProperty = doc.createElement("value");
        }
        return evalProperty;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (this.fResponseListener != null) {
                Object s = null;
                s = event.getSource();
                if (s instanceof ResponseListener && !((Object)((Object)this.fResponseListener)).equals((Object)((ResponseListener)((Object)s)))) {
                    return;
                }
            } else {
                return;
            }
            if (event.getKind() == 32) {
                switch (event.getDetail()) {
                    case 0: {
                        int id = this.fDebugConnection.stackGet();
                        XDebugResponse lastResponse = this.getResponse(id);
                        IBreakpoint breakpoint = this.breakpointHit(lastResponse.getParentNode());
                        if (breakpoint != null) {
                            this.fThread.setBreakpoints(new IBreakpoint[]{breakpoint});
                            this.fThread.incrementStepCounter();
                            this.suspended(16);
                            break;
                        }
                        try {
                            this.resume();
                        }
                        catch (DebugException debugException) {}
                        break;
                    }
                    case 1: {
                        this.fThread.incrementStepCounter();
                        this.suspended(8);
                        break;
                    }
                    case 2: {
                        this.stopped();
                    }
                }
            }
            ++i;
        }
    }

    public void stopped() {
        if (this.fDebugConnection == null) {
            return;
        }
        this.resumed(8);
        this.stopListener();
        this.fDebugConnection.close();
        this.fSuspended = false;
        if (this.fProcess != null) {
            try {
                this.terminate();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        } else {
            this.fDebugConnection = null;
            this.fireEvent(new DebugEvent((Object)this, 16, 512));
        }
        this.fThread.removeEventListeners();
        this.fThread = null;
        this.fThreads = new IThread[0];
    }

    public void handleProxyEvent(XDebugConnection connection) {
        if (this.setDebugConnection(connection)) {
            this.fThread = new XDebugThread(this);
            this.fThreads = new IThread[]{this.fThread};
            this.fireEvent(new DebugEvent((Object)this, 16, 16));
            try {
                this.started();
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean setDebugConnection(XDebugConnection connection) {
        if (connection != null && this.fDebugConnection == null) {
            this.fDebugConnection = connection;
            this.fResponseListener = new ResponseListener(connection);
            this.startListener();
            return true;
        }
        connection.close();
        return false;
    }

    public XDebugConnection getDebugConnection() {
        return this.fDebugConnection;
    }

    public void addProcess(IProcess p) {
        this.fProcess = p;
    }

    public Node getLocalVariables(int level) throws DebugException {
        int id = this.fDebugConnection.contextGet(level, 0);
        XDebugResponse response = this.getResponse(id);
        return response.getParentNode();
    }

    public Node getGlobalVariables(int level) throws DebugException {
        int id = this.fDebugConnection.contextGet(level, 1);
        XDebugResponse response = this.getResponse(id);
        return response.getParentNode();
    }

    public void stop() {
        this.fDebugConnection.stop();
    }

    protected IBreakpoint breakpointHit(Node node) {
        Node child = node.getFirstChild();
        if (child.getNodeName().equals("stack")) {
            int lineNumber = Integer.parseInt(PHPDebugUtils.getAttributeValue(child, "lineno"));
            String filename = PHPDebugUtils.getAttributeValue(child, "filename");
            IBreakpoint[] breakpoints = XDebugCorePlugin.getBreakpoints();
            int i = 0;
            while (i < breakpoints.length) {
                block8: {
                    IBreakpoint breakpoint = breakpoints[i];
                    if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof ILineBreakpoint) {
                        ILineBreakpoint lineBreakpoint = (ILineBreakpoint)breakpoint;
                        try {
                            NamedNodeMap listAttribute;
                            Node attribute;
                            IMarker marker;
                            if (!breakpoint.isEnabled() || (marker = breakpoint.getMarker()) == null) break block8;
                            String endfilename = this.getProcess() == null ? marker.getResource().getLocation().lastSegment() : marker.getResource().getLocation().toOSString();
                            int id = this.fDebugConnection.breakpointGet(marker.getAttribute("XDebugLineBreakpointID", -1));
                            XDebugResponse dr = this.getResponse(id);
                            Node hitCo = dr.getParentNode().getFirstChild();
                            int hitCount = 0;
                            if (hitCo.hasAttributes() && (attribute = (listAttribute = hitCo.getAttributes()).getNamedItem("hit_count")) != null) {
                                hitCount = Integer.parseInt(attribute.getNodeValue());
                            }
                            if (!PHPDebugUtils.unescapeString(filename).endsWith(endfilename) || lineBreakpoint.getLineNumber() != lineNumber) break block8;
                            if (marker.getAttribute("net.sourceforge.phpeclipse.xdebug.php.model.hitCount", 0) > 0) {
                                if (marker.getAttribute("net.sourceforge.phpeclipse.xdebug.php.model.hitCount", 0) == hitCount) {
                                    return breakpoint;
                                }
                                break block8;
                            }
                            return breakpoint;
                        }
                        catch (CoreException coreException) {}
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public void startListener() {
        this.fResponseListener.schedule();
    }

    public void stopListener() {
        this.fResponseListener.cancel();
    }

    public XDebugResponse getResponse(int id) {
        XDebugResponse response = this.fResponseListener.getResponse(id);
        return response;
    }
}

