/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.net.URL;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserManager;
import net.sourceforge.phpeclipse.webbrowser.internal.ExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.internal.Trace;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserPreference;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.IMemento;

public class ExternalWebBrowser
implements IExternalWebBrowser {
    private static final String MEMENTO_NAME = "name";
    private static final String MEMENTO_LOCATION = "location";
    private static final String MEMENTO_PARAMETERS = "parameters";
    protected String name;
    protected String location;
    protected String parameters;

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void delete() {
        BrowserManager.getInstance().removeWebBrowser(this);
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public IExternalWebBrowserWorkingCopy getWorkingCopy() {
        return new ExternalWebBrowserWorkingCopy(this);
    }

    protected void setInternal(IExternalWebBrowser browser) {
        this.name = browser.getName();
        this.location = browser.getLocation();
        this.parameters = browser.getParameters();
    }

    public void openURL(URL url) {
        int urlIndex;
        String urlText = WebBrowserPreference.getHomePageURL();
        if (url != null) {
            urlText = url.toExternalForm();
        } else if (urlText.startsWith("file:") & urlText.length() > 6 && urlText.charAt(5) != '/' && urlText.charAt(5) != '\\') {
            urlText = String.valueOf(urlText.substring(0, 5)) + "/" + urlText.substring(5);
        }
        if (!WebBrowserUtil.isWindows()) {
            int index = urlText.indexOf(" ");
            while (index >= 0) {
                urlText = String.valueOf(urlText.substring(0, index)) + "%20" + urlText.substring(index + 1);
                index = urlText.indexOf(" ");
            }
        }
        Trace.trace(Trace.FINEST, "Launching external Web browser: " + this.location + " - " + this.parameters + " - " + urlText);
        if (this.location == null || this.location.length() == 0) {
            try {
                String extension = null;
                extension = url != null ? url.getFile() : "html";
                int index = extension.indexOf(".");
                if (index >= 0) {
                    extension = extension.substring(index + 1);
                }
                Program program = Program.findProgram((String)extension);
                program.execute(urlText);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error launching default external browser", e);
                WebBrowserUtil.openError(WebBrowserUIPlugin.getResource("%errorCouldNotLaunchWebBrowser", urlText));
            }
            return;
        }
        String params = this.parameters;
        if (params == null) {
            params = "";
        }
        if ((urlIndex = params.indexOf("%URL%")) >= 0) {
            params = String.valueOf(params.substring(0, urlIndex)) + " " + urlText + " " + params.substring(urlIndex + "%URL%".length());
        } else {
            if (!params.endsWith(" ")) {
                params = String.valueOf(params) + " ";
            }
            params = String.valueOf(params) + urlText;
        }
        try {
            Trace.trace(Trace.FINEST, "Launching " + this.location + " " + params);
            Runtime.getRuntime().exec(String.valueOf(this.location) + " " + params);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not launch external browser", e);
            WebBrowserUtil.openError(WebBrowserUIPlugin.getResource("%errorCouldNotLaunchWebBrowser", urlText));
        }
    }

    protected void save(IMemento memento) {
        memento.putString(MEMENTO_NAME, this.name);
        memento.putString(MEMENTO_LOCATION, this.location);
        memento.putString(MEMENTO_PARAMETERS, this.parameters);
    }

    protected void load(IMemento memento) {
        this.name = memento.getString(MEMENTO_NAME);
        this.location = memento.getString(MEMENTO_LOCATION);
        this.parameters = memento.getString(MEMENTO_PARAMETERS);
    }

    public String toString() {
        return "External Web browser: " + this.getName() + " / " + this.getLocation() + " / " + this.getParameters();
    }
}

