/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IInternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.ImageResource;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class BrowserTableLabelProvider
implements ITableLabelProvider {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof IInternalWebBrowser) {
                return ImageResource.getImage("internalBrowser");
            }
            return ImageResource.getImage("externalBrowser");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IWebBrowser browser = (IWebBrowser)element;
        if (browser instanceof IExternalWebBrowser) {
            if (columnIndex == 0) {
                return this.notNull(((IExternalWebBrowser)browser).getName());
            }
            if (columnIndex == 1) {
                return this.notNull(((IExternalWebBrowser)browser).getLocation());
            }
            if (columnIndex == 2) {
                return this.notNull(((IExternalWebBrowser)browser).getParameters());
            }
        } else if (browser instanceof IInternalWebBrowser && columnIndex == 0) {
            return this.notNull(((IInternalWebBrowser)browser).getName());
        }
        return "";
    }

    protected String notNull(String s) {
        if (s != null) {
            return s;
        }
        return "";
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

