/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.webbrowser.internal;

import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IExternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.IInternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.IInternalWebBrowserWorkingCopy;
import net.sourceforge.phpeclipse.webbrowser.IWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserContentProvider;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserManager;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserSearcher;
import net.sourceforge.phpeclipse.webbrowser.internal.BrowserTableLabelProvider;
import net.sourceforge.phpeclipse.webbrowser.internal.ExternalBrowserDialog;
import net.sourceforge.phpeclipse.webbrowser.internal.InternalBrowserDialog;
import net.sourceforge.phpeclipse.webbrowser.internal.InternalWebBrowser;
import net.sourceforge.phpeclipse.webbrowser.internal.SWTUtil;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUIPlugin;
import net.sourceforge.phpeclipse.webbrowser.internal.WebBrowserUtil;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class BrowserTableComposite
extends Composite {
    protected Table table;
    protected CheckboxTableViewer tableViewer;
    protected Button edit;
    protected Button remove;
    protected Button search;
    protected IWebBrowser selection;
    protected Label location;
    protected Label parameters;

    public BrowserTableComposite(Composite parent, int style) {
        super(parent, style);
        this.createWidgets();
    }

    protected void createWidgets() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
        Label label = new Label((Composite)this, 0);
        label.setText(WebBrowserUIPlugin.getResource("%browserList"));
        data = new GridData(772);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.table = new Table((Composite)this, 68388);
        data = new GridData(784);
        data.widthHint = 300;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(false);
        TableLayout tableLayout = new TableLayout();
        new TableColumn(this.table, 0);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new CheckboxTableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new BrowserContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BrowserTableLabelProvider());
        this.tableViewer.setInput((Object)"root");
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                BrowserTableComposite.this.checkNewDefaultBrowser(e.getElement());
                IWebBrowser browser = (IWebBrowser)e.getElement();
                BrowserManager.getInstance().setCurrentWebBrowser(browser);
                Object[] obj = BrowserTableComposite.this.tableViewer.getCheckedElements();
                if (obj.length == 0) {
                    BrowserTableComposite.this.tableViewer.setChecked(e.getElement(), true);
                }
            }
        });
        IWebBrowser browser = BrowserManager.getInstance().getCurrentWebBrowser();
        if (browser != null) {
            this.tableViewer.setChecked((Object)browser, true);
        } else {
            Object obj = this.tableViewer.getElementAt(0);
            if (obj != null) {
                this.tableViewer.setChecked(obj, true);
            }
        }
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = BrowserTableComposite.this.getSelection(event.getSelection());
                if (obj instanceof IInternalWebBrowser) {
                    BrowserTableComposite.this.selection = (IInternalWebBrowser)obj;
                    BrowserTableComposite.this.remove.setEnabled(false);
                    BrowserTableComposite.this.edit.setEnabled(true);
                } else if (obj instanceof IExternalWebBrowser) {
                    BrowserTableComposite.this.selection = (IExternalWebBrowser)obj;
                    BrowserTableComposite.this.remove.setEnabled(true);
                    BrowserTableComposite.this.edit.setEnabled(true);
                } else {
                    BrowserTableComposite.this.selection = null;
                }
                if (BrowserTableComposite.this.selection == null) {
                    BrowserTableComposite.this.edit.setEnabled(false);
                    BrowserTableComposite.this.remove.setEnabled(false);
                }
            }
        });
        Composite buttonComp = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        buttonComp.setLayout((Layout)layout);
        data = new GridData(144);
        buttonComp.setLayoutData((Object)data);
        Button add = SWTUtil.createButton(buttonComp, WebBrowserUIPlugin.getResource("%add"));
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExternalBrowserDialog dialog = new ExternalBrowserDialog(BrowserTableComposite.this.getShell());
                if (dialog.open() == 1) {
                    return;
                }
                BrowserTableComposite.this.tableViewer.refresh();
            }
        });
        this.edit = SWTUtil.createButton(buttonComp, WebBrowserUIPlugin.getResource("%edit"));
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWebBrowser browser2 = BrowserTableComposite.this.getSelectedWebBrowser();
                if (browser2 instanceof IInternalWebBrowser) {
                    IInternalWebBrowserWorkingCopy wc = ((IInternalWebBrowser)browser2).getWorkingCopy();
                    InternalBrowserDialog dialog = new InternalBrowserDialog(BrowserTableComposite.this.getShell(), wc);
                    if (dialog.open() != 1) {
                        try {
                            BrowserTableComposite.this.tableViewer.refresh((Object)wc.save());
                        }
                        catch (Exception exception) {}
                    }
                } else if (browser2 instanceof IExternalWebBrowser) {
                    IExternalWebBrowserWorkingCopy wc = ((IExternalWebBrowser)browser2).getWorkingCopy();
                    ExternalBrowserDialog dialog = new ExternalBrowserDialog(BrowserTableComposite.this.getShell(), wc);
                    if (dialog.open() != 1) {
                        try {
                            BrowserTableComposite.this.tableViewer.refresh((Object)wc.save());
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        });
        this.edit.setEnabled(false);
        this.remove = SWTUtil.createButton(buttonComp, WebBrowserUIPlugin.getResource("%remove"));
        this.remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IWebBrowser browser2 = BrowserTableComposite.this.getSelectedWebBrowser();
                try {
                    if (browser2 instanceof IInternalWebBrowser) {
                        BrowserTableComposite.this.remove.setEnabled(false);
                        return;
                    }
                    if (browser2 instanceof IExternalWebBrowser) {
                        Object obj;
                        BrowserTableComposite.this.remove.setEnabled(true);
                        ((IExternalWebBrowser)browser2).delete();
                        BrowserTableComposite.this.tableViewer.remove((Object)browser2);
                        if ((IExternalWebBrowser)browser2 == BrowserManager.getInstance().getCurrentWebBrowser() && (obj = BrowserTableComposite.this.tableViewer.getElementAt(0)) != null) {
                            BrowserManager.getInstance().setCurrentWebBrowser((InternalWebBrowser)obj);
                            BrowserTableComposite.this.tableViewer.setChecked(obj, true);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.remove.setEnabled(false);
        this.search = SWTUtil.createButton(buttonComp, WebBrowserUIPlugin.getResource("%search"));
        this.search.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List browsersToCreate = BrowserSearcher.search(BrowserTableComposite.this.getShell());
                if (browsersToCreate == null) {
                    return;
                }
                if (browsersToCreate.isEmpty()) {
                    WebBrowserUtil.openMessage(WebBrowserUIPlugin.getResource("%searchingNoneFound"));
                    return;
                }
                Iterator iterator = browsersToCreate.iterator();
                while (iterator.hasNext()) {
                    IExternalWebBrowserWorkingCopy browser2 = (IExternalWebBrowserWorkingCopy)iterator.next();
                    browser2.save();
                }
                BrowserTableComposite.this.tableViewer.refresh();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.search, "net.sourceforge.phpeclipse.webbrowser.wbpr0006");
        this.tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                BrowserTableComposite.this.checkNewDefaultBrowser(e.getElement());
                IWebBrowser browser2 = (IWebBrowser)e.getElement();
                BrowserManager.getInstance().setCurrentWebBrowser(browser2);
            }
        });
        this.search.setEnabled(true);
    }

    public IWebBrowser getSelectedWebBrowser() {
        return this.selection;
    }

    protected Object getSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        return sel.getFirstElement();
    }

    protected void checkNewDefaultBrowser(Object browser) {
        TableItem[] children = this.tableViewer.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (!item.getData().equals(browser)) {
                item.setChecked(false);
            }
            ++i;
        }
    }
}

