/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.wizards.html;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SomeItemInputDialog
extends Dialog {
    String dialogTitle;
    String[] inputMessages;
    IInputValidator[] validators;
    Text[] texts;
    Text error;
    String[] errorMsgs;
    String[] resultValues;

    public SomeItemInputDialog(Shell parentShell, String dialogTitle, String[] inputMessages, IInputValidator[] validators) {
        super(parentShell);
        if (inputMessages.length != validators.length) {
            throw new IllegalArgumentException("Specify validator counts and input message count is not same.");
        }
        this.dialogTitle = dialogTitle;
        this.inputMessages = (String[])inputMessages.clone();
        this.validators = (IInputValidator[])validators.clone();
        this.errorMsgs = new String[validators.length];
        this.setShellStyle(0x10 | this.getShellStyle());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite base = (Composite)super.createDialogArea(parent);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 4;
        gl.marginHeight = 6;
        base.setLayout((Layout)gl);
        this.texts = new Text[this.inputMessages.length];
        int i = 0;
        while (i < this.inputMessages.length) {
            new Label(base, 0).setText(String.valueOf(this.inputMessages[i]) + ":");
            final int index = i;
            Text t = new Text(base, 2048);
            t.setLayoutData((Object)new GridData(768));
            t.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SomeItemInputDialog.this.refreshValidator(index);
                }
            });
            this.texts[i] = t;
            ++i;
        }
        this.error = new Text(base, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.error.setLayoutData((Object)gd);
        return base;
    }

    void refreshValidator(int index) {
        String data = this.texts[index].getText();
        IInputValidator validator = this.validators[index];
        if (validator != null) {
            this.errorMsgs[index] = validator.isValid(data);
        }
        Button okButton = this.getButton(0);
        int i = 0;
        while (i < this.errorMsgs.length) {
            String msg = this.errorMsgs[i];
            if (msg != null) {
                this.error.setText(msg);
                okButton.setEnabled(false);
                return;
            }
            ++i;
        }
        this.error.setText("");
        okButton.setEnabled(true);
    }

    public String[] getValues() {
        return (String[])this.resultValues.clone();
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        return new Point(p.x * 2, (int)((double)p.y * 1.25));
    }

    protected void okPressed() {
        this.resultValues = new String[this.texts.length];
        int i = 0;
        while (i < this.texts.length) {
            this.resultValues[i] = this.texts[i].getText();
            ++i;
        }
        super.okPressed();
    }
}

