/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.wizards.html;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import net.sourceforge.phpeclipse.wizards.html.HTMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementWriter {
    public static final int BEGIN_CHANGELINE = 1;
    public static final int END_CHANGELINE = 2;
    boolean trim = true;
    HashMap expandOptions = new HashMap();
    int defaultExpandOption;
    String indent;

    public ElementWriter() {
        this(0, "  ");
    }

    public ElementWriter(int defaultExpandOption, String indent) {
        this.defaultExpandOption = defaultExpandOption;
        this.indent = indent;
    }

    public void setExpandOption(String elementName, int value) {
        this.expandOptions.put(elementName, new Integer(value));
    }

    public int getExpandOption(String elementName) {
        if (this.expandOptions.containsKey(elementName)) {
            return (Integer)this.expandOptions.get(elementName);
        }
        return this.defaultExpandOption;
    }

    boolean isBeginChangeLine(String elementName) {
        return (this.getExpandOption(elementName) & 1) != 0;
    }

    boolean isEndChangeLine(String elementName) {
        return (this.getExpandOption(elementName) & 2) != 0;
    }

    public String expandTag(Element element) {
        StringBuffer buff = new StringBuffer();
        this.expandTag(element, 0, buff);
        return buff.toString();
    }

    /*
     * Exception decompiling
     */
    public void writeTag(Element element, OutputStream out) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 53->57)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void expandTag(Element element, int level, StringBuffer buff) {
        boolean emptyElem;
        this.expandIndent(level, buff);
        String elementName = element.getNodeName();
        buff.append(String.valueOf('<') + elementName);
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node n = attrs.item(i);
            String v = n.getNodeValue();
            if (v != null) {
                buff.append(String.valueOf(' ') + n.getNodeName() + "=\"" + HTMLUtilities.escape(v) + "\"");
            }
            ++i;
        }
        boolean bl = emptyElem = element.getChildNodes().getLength() == 0;
        if (emptyElem) {
            buff.append(" /");
        }
        buff.append('>');
        if (!emptyElem) {
            NodeList childElements = element.getChildNodes();
            if (this.isBeginChangeLine(elementName)) {
                buff.append('\n');
            }
            int i2 = 0;
            while (i2 < childElements.getLength()) {
                Node node = childElements.item(i2);
                if (node instanceof Element) {
                    this.expandTag((Element)node, level + 1, buff);
                } else if (node instanceof Text) {
                    String text = ((Text)node).getNodeValue();
                    if (!this.trim || (text = text.trim()).length() != 0) {
                        buff.append(text);
                    }
                }
                ++i2;
            }
            this.expandIndent(level, buff);
            buff.append("</" + elementName + '>');
        }
        if (this.isEndChangeLine(elementName)) {
            buff.append('\n');
        }
    }

    void expandIndent(int level, StringBuffer buff) {
        if (this.indent != null) {
            int i = 0;
            while (i < level) {
                buff.append(this.indent);
                ++i;
            }
        }
    }

    public int getDefaultExpandOption() {
        return this.defaultExpandOption;
    }

    public void setDefaultExpandOption(int i) {
        this.defaultExpandOption = i;
    }
}

