/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.preferences.PHPPreferencesMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;

public class PHPProjectLibraryPage {
    protected JavaProject workingProject;

    protected PHPProjectLibraryPage(JavaProject theWorkingProject) {
        this.workingProject = theWorkingProject;
    }

    protected Control getControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Table projectsTable = new Table(composite, 67618);
        projectsTable.setHeaderVisible(false);
        projectsTable.setLinesVisible(false);
        projectsTable.computeSize(-1, -1);
        TableColumn tableColumn = new TableColumn(projectsTable, 0);
        tableColumn.setWidth(200);
        tableColumn.setText(PHPPreferencesMessages.getString("PHPEditorPreferencePageLibraryPage.project"));
        CheckboxTableViewer projectsTableViewer = new CheckboxTableViewer(projectsTable);
        projectsTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PHPProjectLibraryPage.this.projectCheckedUnchecked(event);
            }
        });
        projectsTableViewer.setContentProvider(this.getContentProvider());
        projectsTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        projectsTableViewer.setInput((Object)this.getWorkspaceProjects());
        projectsTableViewer.setCheckedElements(this.workingProject.getReferencedProjects().toArray());
        return composite;
    }

    protected void projectCheckedUnchecked(CheckStateChangedEvent event) {
        IProject checkEventProject = (IProject)event.getElement();
        if (event.getChecked()) {
            this.getWorkingProject().addLoadPathEntry(checkEventProject);
        } else {
            this.getWorkingProject().removeLoadPathEntry(checkEventProject);
        }
    }

    protected JavaProject getWorkingProject() {
        return this.workingProject;
    }

    protected List getWorkspaceProjects() {
        IWorkspaceRoot root = PHPeclipsePlugin.getWorkspace().getRoot();
        return Arrays.asList(root.getProjects());
    }

    protected ITableLabelProvider getLabelProvider() {
        ITableLabelProvider labelProvider = new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                IWorkbench workbench = PHPeclipsePlugin.getDefault().getWorkbench();
                return workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof IProject) {
                    return ((IProject)element).getName();
                }
                return PHPPreferencesMessages.getString("PHPEditorPreferencePageLibraryPage.elementNotIProject");
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
        return labelProvider;
    }

    protected IContentProvider getContentProvider() {
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){
            protected List PHPEditorPreferencePages;

            public Object[] getElements(Object inputElement) {
                return this.PHPEditorPreferencePages.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.PHPEditorPreferencePages = new ArrayList();
                if (!(newInput instanceof List)) {
                    return;
                }
                Iterator workspaceProjectsIterator = ((List)newInput).iterator();
                while (workspaceProjectsIterator.hasNext()) {
                    IProject project;
                    Object anObject = workspaceProjectsIterator.next();
                    if (!(anObject instanceof IProject) || (project = (IProject)anObject).getName() == PHPProjectLibraryPage.this.workingProject.getProject().getName()) continue;
                    try {
                        if (!project.hasNature("net.sourceforge.phpeclipse.phpnature")) continue;
                        this.PHPEditorPreferencePages.add(project);
                    }
                    catch (CoreException coreException) {}
                }
            }
        };
        return contentProvider;
    }
}

