/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.phpdt.internal.ui.util.StreamUtil;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;

public class FileStorage
extends PlatformObject
implements IStorage {
    private boolean forceReadOnly;
    private final IPath path;
    private final File file;

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileStorage)) {
            return false;
        }
        FileStorage other = (FileStorage)((Object)obj);
        return this.path.equals((Object)other.path);
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", 4, e.toString(), (Throwable)e));
        }
    }

    public IPath getFullPath() {
        return this.path;
    }

    public String getName() {
        return this.path.lastSegment();
    }

    public boolean isReadOnly() {
        return this.forceReadOnly || !this.file.canWrite();
    }

    public FileStorage(IPath path) {
        this.path = path;
        this.file = path.toFile();
    }

    public String toString() {
        return this.path.toOSString();
    }

    public void setContents(InputStream stream, boolean overwrite, boolean b, IProgressMonitor monitor) throws CoreException {
        try {
            StreamUtil.transferStreams(stream, new FileOutputStream(this.file));
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", 4, e.toString(), (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", 4, e.toString(), (Throwable)e));
        }
    }

    public void setReadOnly() {
        this.forceReadOnly = true;
    }
}

