/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ui;

import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import net.sourceforge.phpdt.internal.ui.viewsupport.ImageImageDescriptor;
import net.sourceforge.phpdt.ui.JavaElementImageDescriptor;
import net.sourceforge.phpdt.ui.PreferenceConstants;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class OverrideIndicatorLabelDecorator
implements ILabelDecorator,
ILightweightLabelDecorator {
    private ImageDescriptorRegistry fRegistry;
    private boolean fUseNewRegistry = false;

    public OverrideIndicatorLabelDecorator() {
        this(null);
        this.fUseNewRegistry = true;
    }

    public OverrideIndicatorLabelDecorator(ImageDescriptorRegistry registry) {
        this.fRegistry = registry;
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = this.fUseNewRegistry ? new ImageDescriptorRegistry() : PHPeclipsePlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public Image decorateImage(Image image, Object element) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            ImageImageDescriptor baseImage = new ImageImageDescriptor(image);
            Rectangle bounds = image.getBounds();
            return this.getRegistry().get((ImageDescriptor)new JavaElementImageDescriptor(baseImage, adornmentFlags, new Point(bounds.width, bounds.height)));
        }
        return image;
    }

    public int computeAdornmentFlags(Object element) {
        block5: {
            if (element instanceof IMethod) {
                if (!PreferenceConstants.getPreferenceStore().getBoolean("net.sourceforge.phpdt.ui.overrideindicator")) {
                    return 0;
                }
                try {
                    IMethod method = (IMethod)element;
                    int flags = method.getFlags();
                    IType type = method.getDeclaringType();
                    if (type != null && type.isClass() && !method.isConstructor() && !Flags.isPrivate(flags) && !Flags.isStatic(flags)) {
                        return this.getOverrideIndicators(method);
                    }
                }
                catch (JavaModelException e) {
                    if (e.isDoesNotExist()) break block5;
                    PHPeclipsePlugin.log((Throwable)((Object)e));
                }
            }
        }
        return 0;
    }

    protected int getOverrideIndicators(IMethod method) throws JavaModelException {
        method.getDeclaringType();
        return 0;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.fRegistry != null && this.fUseNewRegistry) {
            this.fRegistry.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        int adornmentFlags = this.computeAdornmentFlags(element);
        if (adornmentFlags != 0) {
            decoration.addOverlay(PHPUiImages.DESC_OVR_OVERRIDES);
        }
    }
}

