/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.viewsupport;

import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.IField;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.ui.PHPUIMessages;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import net.sourceforge.phpdt.ui.JavaElementImageDescriptor;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final Point SMALL_SIZE = new Point(16, 16);
    public static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    private static ImageDescriptor DESC_OBJ_FOLDER;
    private ImageDescriptorRegistry fRegistry;
    static /* synthetic */ Class class$0;

    public JavaElementImageProvider() {
        ISharedImages images = PHPeclipsePlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = images.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = images.getImageDescriptor("IMG_OBJ_PROJECT");
        DESC_OBJ_FOLDER = images.getImageDescriptor("IMG_OBJ_FOLDER");
        this.fRegistry = null;
    }

    public Image getImageLabel(Object element, int flags) {
        return this.getImageLabel(this.computeDescriptor(element, flags));
    }

    private Image getImageLabel(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return this.getRegistry().get(descriptor);
    }

    private ImageDescriptorRegistry getRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = PHPeclipsePlugin.getImageDescriptorRegistry();
        }
        return this.fRegistry;
    }

    private ImageDescriptor computeDescriptor(Object element, int flags) {
        if (element instanceof IJavaElement) {
            return this.getJavaImageDescriptor((IJavaElement)element, flags);
        }
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            if ("java".equals(file.getFileExtension())) {
                return this.getCUResourceImageDescriptor(file, flags);
            }
            return this.getWorkbenchImageDescriptor((IAdaptable)file, flags);
        }
        if (element instanceof IAdaptable) {
            return this.getWorkbenchImageDescriptor((IAdaptable)element, flags);
        }
        return null;
    }

    private static boolean showOverlayIcons(int flags) {
        return (flags & 1) != 0;
    }

    private static boolean useSmallSize(int flags) {
        return (flags & 2) != 0;
    }

    private static boolean useLightIcons(int flags) {
        return (flags & 4) != 0;
    }

    public ImageDescriptor getCUResourceImageDescriptor(IFile file, int flags) {
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(PHPUiImages.DESC_OBJS_CUNIT_RESOURCE, 0, size);
    }

    public ImageDescriptor getJavaImageDescriptor(IJavaElement element, int flags) {
        int adornmentFlags = this.computeJavaAdornmentFlags(element, flags);
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(this.getBaseImageDescriptor(element, flags), adornmentFlags, size);
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable adaptable, int flags) {
        IWorkbenchAdapter wbAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((wbAdapter = (IWorkbenchAdapter)adaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        ImageDescriptor descriptor = wbAdapter.getImageDescriptor((Object)adaptable);
        if (descriptor == null) {
            return null;
        }
        Point size = JavaElementImageProvider.useSmallSize(flags) ? SMALL_SIZE : BIG_SIZE;
        return new JavaElementImageDescriptor(descriptor, 0, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageDescriptor getBaseImageDescriptor(IJavaElement element, int renderFlags) {
        IType type = null;
        boolean isInterface = false;
        try {
            switch (element.getElementType()) {
                case 10: {
                    return PHPUiImages.DESC_MISC_PRIVATE;
                }
                case 9: {
                    IMember member = (IMember)element;
                    type = member.getDeclaringType();
                    isInterface = type != null && member.getDeclaringType().isInterface();
                    return JavaElementImageProvider.getMethodImageDescriptor(isInterface, member.getFlags());
                }
                case 8: {
                    IField field = (IField)element;
                    return JavaElementImageProvider.getFieldImageDescriptor(field.getDeclaringType().isInterface(), field.getFlags());
                }
                case 11: {
                    return PHPUiImages.DESC_OBJS_PACKDECL;
                }
                case 13: {
                    return PHPUiImages.DESC_OBJS_IMPDECL;
                }
                case 12: {
                    return PHPUiImages.DESC_OBJS_IMPCONT;
                }
                case 7: {
                    type = (IType)element;
                    isInterface = type.isInterface();
                    if (JavaElementImageProvider.useLightIcons(renderFlags)) {
                        return isInterface ? PHPUiImages.DESC_OBJS_INTERFACEALT : PHPUiImages.DESC_OBJS_CLASSALT;
                    }
                    boolean isInner = type.getDeclaringType() != null;
                    return JavaElementImageProvider.getTypeImageDescriptor(isInterface, isInner, type.getFlags());
                }
                case 3: {
                    IPackageFragmentRoot cfr_ignored_0 = (IPackageFragmentRoot)element;
                    return PHPUiImages.DESC_OBJS_PACKFRAG_ROOT;
                }
                case 4: {
                    return this.getPackageFragmentIcon(element, renderFlags);
                }
                case 5: {
                    return PHPUiImages.DESC_OBJS_CUNIT;
                }
                case 6: {
                    return PHPUiImages.DESC_OBJS_CFILE;
                }
                case 2: {
                    ImageDescriptor result;
                    IWorkbenchAdapter adapter;
                    IJavaProject jp = (IJavaProject)element;
                    if (!jp.getProject().isOpen()) return DESC_OBJ_PROJECT_CLOSED;
                    IProject project = jp.getProject();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = (IWorkbenchAdapter)project.getAdapter((Class)clazz)) == null || (result = adapter.getImageDescriptor((Object)project)) == null) return DESC_OBJ_PROJECT;
                    return result;
                }
                case 1: {
                    return PHPUiImages.DESC_OBJS_JAVA_MODEL;
                }
            }
            Assert.isTrue((boolean)false, (String)PHPUIMessages.getString("JavaImageLabelprovider.assert.wrongImage"));
            return null;
        }
        catch (JavaModelException e) {
            if (e.isDoesNotExist()) {
                return PHPUiImages.DESC_OBJS_UNKNOWN;
            }
            PHPeclipsePlugin.log((Throwable)((Object)e));
            return PHPUiImages.DESC_OBJS_GHOST;
        }
    }

    protected ImageDescriptor getPackageFragmentIcon(IJavaElement element, int renderFlags) throws JavaModelException {
        return PHPUiImages.DESC_OBJS_PACKAGE;
    }

    public void dispose() {
    }

    private int computeJavaAdornmentFlags(IJavaElement element, int renderFlags) {
        int flags = 0;
        if (JavaElementImageProvider.showOverlayIcons(renderFlags) && element instanceof IMember) {
            try {
                int modifiers;
                IMember member = (IMember)element;
                if (element.getElementType() == 9 && ((IMethod)element).isConstructor()) {
                    flags |= 0x200;
                }
                if (Flags.isAbstract(modifiers = member.getFlags()) && JavaElementImageProvider.confirmAbstract(member)) {
                    flags |= 1;
                }
                if (Flags.isFinal(modifiers) || JavaElementImageProvider.isInterfaceField(member)) {
                    flags |= 2;
                }
                if (Flags.isStatic(modifiers) || JavaElementImageProvider.isInterfaceField(member)) {
                    flags |= 8;
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        return flags;
    }

    private static boolean confirmAbstract(IMember element) throws JavaModelException {
        if (element.getElementType() == 7) {
            return ((IType)element).isClass();
        }
        return element.getDeclaringType().isClass();
    }

    private static boolean isInterfaceField(IMember element) throws JavaModelException {
        if (element.getElementType() == 8) {
            return element.getDeclaringType().isInterface();
        }
        return false;
    }

    private static boolean confirmSynchronized(IJavaElement member) {
        return member.getElementType() != 7;
    }

    public static ImageDescriptor getMethodImageDescriptor(boolean isInInterface, int flags) {
        if (Flags.isPublic(flags) || isInInterface) {
            return PHPUiImages.DESC_MISC_PUBLIC;
        }
        if (Flags.isProtected(flags)) {
            return PHPUiImages.DESC_MISC_PROTECTED;
        }
        if (Flags.isPrivate(flags)) {
            return PHPUiImages.DESC_MISC_PRIVATE;
        }
        return PHPUiImages.DESC_MISC_DEFAULT;
    }

    public static ImageDescriptor getFieldImageDescriptor(boolean isInInterface, int flags) {
        if (Flags.isPublic(flags) || isInInterface) {
            return PHPUiImages.DESC_FIELD_PUBLIC;
        }
        if (Flags.isProtected(flags)) {
            return PHPUiImages.DESC_FIELD_PROTECTED;
        }
        if (Flags.isPrivate(flags)) {
            return PHPUiImages.DESC_FIELD_PRIVATE;
        }
        return PHPUiImages.DESC_FIELD_DEFAULT;
    }

    public static ImageDescriptor getTypeImageDescriptor(boolean isInterface, boolean isInner, int flags) {
        if (isInner) {
            if (isInterface) {
                return JavaElementImageProvider.getInnerInterfaceImageDescriptor(flags);
            }
            return JavaElementImageProvider.getInnerClassImageDescriptor(flags);
        }
        if (isInterface) {
            return JavaElementImageProvider.getInterfaceImageDescriptor(flags);
        }
        return JavaElementImageProvider.getClassImageDescriptor(flags);
    }

    private static ImageDescriptor getClassImageDescriptor(int flags) {
        if (Flags.isPublic(flags) || Flags.isProtected(flags) || Flags.isPrivate(flags)) {
            return PHPUiImages.DESC_OBJS_CLASS;
        }
        return PHPUiImages.DESC_OBJS_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInnerClassImageDescriptor(int flags) {
        if (Flags.isPublic(flags)) {
            return PHPUiImages.DESC_OBJS_INNER_CLASS_PUBLIC;
        }
        if (Flags.isPrivate(flags)) {
            return PHPUiImages.DESC_OBJS_INNER_CLASS_PRIVATE;
        }
        if (Flags.isProtected(flags)) {
            return PHPUiImages.DESC_OBJS_INNER_CLASS_PROTECTED;
        }
        return PHPUiImages.DESC_OBJS_INNER_CLASS_DEFAULT;
    }

    private static ImageDescriptor getInterfaceImageDescriptor(int flags) {
        if (Flags.isPublic(flags) || Flags.isProtected(flags) || Flags.isPrivate(flags)) {
            return PHPUiImages.DESC_OBJS_INTERFACE;
        }
        return PHPUiImages.DESC_OBJS_INTERFACE_DEFAULT;
    }

    private static ImageDescriptor getInnerInterfaceImageDescriptor(int flags) {
        if (Flags.isPublic(flags)) {
            return PHPUiImages.DESC_OBJS_INNER_INTERFACE_PUBLIC;
        }
        if (Flags.isPrivate(flags)) {
            return PHPUiImages.DESC_OBJS_INNER_INTERFACE_PRIVATE;
        }
        if (Flags.isProtected(flags)) {
            return PHPUiImages.DESC_OBJS_INNER_INTERFACE_PROTECTED;
        }
        return PHPUiImages.DESC_OBJS_INTERFACE_DEFAULT;
    }
}

