/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.util;

import java.io.File;
import java.util.List;
import net.sourceforge.phpeclipse.ui.overlaypages.ProjectPrefUtil;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class PHPFileUtil {
    public static final String[] SMARTY_EXTENSIONS = new String[]{"tpl"};

    public static boolean isPHPFile(IFile file) {
        return PHPFileUtil.isPHPFileName(file.getFullPath().toString());
    }

    public static final boolean isPHPFileName(String name) {
        File file = new File(name);
        if (file.getName().startsWith(".")) {
            return false;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IEditorDescriptor[] descriptors = registry.getEditors(name);
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getId().equals("net.sourceforge.phpeclipse.PHPUnitEditor")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isValidPHPUnitName(String filename) {
        return PHPFileUtil.isPHPFileName(filename);
    }

    public static IFile createFile(IPath absoluteFilePath, IProject project) {
        if (absoluteFilePath == null || project == null) {
            return null;
        }
        String projectPath = project.getFullPath().toString();
        String filePath = absoluteFilePath.toString().substring(projectPath.length() + 1);
        return project.getFile(filePath);
    }

    public static IPath determineFilePath(String includeNameString, IResource resource, IProject project) {
        IPath documentRootPath = ProjectPrefUtil.getDocumentRoot((IResource)project);
        IPath resourcePath = resource.getProjectRelativePath();
        IPath path = null;
        path = project.getFullPath().append(resourcePath.removeLastSegments(1)).append(includeNameString);
        if (PHPFileUtil.fileExists(path, false)) {
            return path;
        }
        path = project.getFullPath().append(includeNameString);
        if (PHPFileUtil.fileExists(path, false)) {
            return path;
        }
        path = documentRootPath.append(includeNameString);
        if (PHPFileUtil.fileExists(path, true)) {
            return path;
        }
        List includePaths = ProjectPrefUtil.getIncludePaths((IResource)project);
        if (includePaths.size() > 0) {
            int i = 0;
            while (i < includePaths.size()) {
                path = new Path(includePaths.get(i).toString()).append(includeNameString);
                if (PHPFileUtil.fileExists(path, true)) {
                    return path;
                }
                ++i;
            }
        }
        return null;
    }

    private static boolean fileExists(IPath path, boolean absolute) {
        IFile resource;
        IFile ifile;
        File file = path.toFile();
        if (file.exists()) {
            return true;
        }
        return !absolute && (ifile = FileBuffers.getWorkspaceFileAtLocation((IPath)path)) != null && (resource = ifile).exists();
    }
}

