/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template;

import net.sourceforge.phpdt.internal.corext.template.TemplateMessages;
import net.sourceforge.phpdt.internal.ui.text.java.IPHPCompletionProposal;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractProposal
implements IPHPCompletionProposal {
    protected IRegion fSelectedRegion;
    protected final ITextViewer fViewer;
    protected ContextInformation fContextInfo = null;

    public AbstractProposal(ITextViewer viewer) {
        this.fViewer = viewer;
    }

    protected static String textToHTML(String string) {
        StringBuffer buffer = new StringBuffer(string.length());
        buffer.append("<pre>");
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\t': {
                    buffer.append("    ");
                    break;
                }
                case '\n': {
                    buffer.append("<br>");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        buffer.append("</pre>");
        return buffer.toString();
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    protected void handleException(CoreException e) {
        PHPeclipsePlugin.log(e);
    }

    protected void openErrorDialog(BadLocationException e) {
        Shell shell = this.fViewer.getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)TemplateMessages.getString("TemplateEvaluator.error.title"), (String)e.getMessage());
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

