/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.link;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpdt.internal.ui.text.link.ILinkedPositionListener;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionMessages;
import net.sourceforge.phpdt.internal.ui.text.link.ProposalPosition;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class LinkedPositionManager
implements IDocumentListener,
IPositionUpdater,
IAutoEditStrategy {
    private static final String LINKED_POSITION_PREFIX = "LinkedPositionManager.linked.position";
    private static final Comparator fgPositionComparator = new PositionComparator();
    private static final Map fgActiveManagers = new HashMap();
    private static int fgCounter = 0;
    private IDocument fDocument;
    private ILinkedPositionListener fListener;
    private String fPositionCategoryName;
    private boolean fMustLeave;
    private boolean fIsActive = false;

    public LinkedPositionManager(IDocument document, boolean canCoexist) {
        Assert.isNotNull((Object)document);
        this.fDocument = document;
        this.fPositionCategoryName = LINKED_POSITION_PREFIX + fgCounter++;
        this.install(canCoexist);
    }

    public LinkedPositionManager(IDocument document) {
        this(document, false);
    }

    public void setLinkedPositionListener(ILinkedPositionListener listener) {
        this.fListener = listener;
    }

    public void addPosition(int offset, int length) throws BadLocationException {
        String type = this.fDocument.get(offset, length);
        this.addPosition(offset, length, type);
    }

    public void addPosition(int offset, int length, String type) throws BadLocationException {
        String content;
        Position[] positions = this.getPositions(this.fDocument);
        if (positions != null) {
            int i = 0;
            while (i < positions.length) {
                if (LinkedPositionManager.collides(positions[i], offset, length)) {
                    throw new BadLocationException(LinkedPositionMessages.getString("LinkedPositionManager.error.position.collision"));
                }
                ++i;
            }
        }
        if (this.containsLineDelimiters(content = this.fDocument.get(offset, length))) {
            throw new BadLocationException(LinkedPositionMessages.getString("LinkedPositionManager.error.contains.line.delimiters"));
        }
        try {
            this.fDocument.addPosition(this.fPositionCategoryName, (Position)new TypedPosition(offset, length, type));
        }
        catch (BadPositionCategoryException e) {
            PHPeclipsePlugin.log(e);
            Assert.isTrue((boolean)false);
        }
    }

    public void addPosition(int offset, int length, ICompletionProposal[] additionalChoices) throws BadLocationException {
        String type = this.fDocument.get(offset, length);
        this.addPosition(offset, length, type, additionalChoices);
    }

    public void addPosition(int offset, int length, String type, ICompletionProposal[] additionalChoices) throws BadLocationException {
        String content;
        Position[] positions = this.getPositions(this.fDocument);
        if (positions != null) {
            int i = 0;
            while (i < positions.length) {
                if (LinkedPositionManager.collides(positions[i], offset, length)) {
                    throw new BadLocationException(LinkedPositionMessages.getString("LinkedPositionManager.error.position.collision"));
                }
                ++i;
            }
        }
        if (this.containsLineDelimiters(content = this.fDocument.get(offset, length))) {
            throw new BadLocationException(LinkedPositionMessages.getString("LinkedPositionManager.error.contains.line.delimiters"));
        }
        try {
            this.fDocument.addPosition(this.fPositionCategoryName, (Position)new ProposalPosition(offset, length, type, additionalChoices));
        }
        catch (BadPositionCategoryException e) {
            PHPeclipsePlugin.log(e);
            Assert.isTrue((boolean)false);
        }
    }

    public static boolean hasActiveManager(IDocument document) {
        return fgActiveManagers.get(document) != null;
    }

    private void install(boolean canCoexist) {
        LinkedPositionManager manager;
        if (!this.fIsActive) {
            this.fIsActive = true;
        }
        if (!canCoexist && (manager = (LinkedPositionManager)fgActiveManagers.get(this.fDocument)) != null) {
            manager.leave(true);
        }
        fgActiveManagers.put(this.fDocument, this);
        this.fDocument.addPositionCategory(this.fPositionCategoryName);
        this.fDocument.addPositionUpdater((IPositionUpdater)this);
        this.fDocument.addDocumentListener((IDocumentListener)this);
        this.fMustLeave = false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uninstall(boolean success) {
        if (!this.fIsActive) {
            return;
        }
        this.fDocument.removeDocumentListener((IDocumentListener)this);
        try {
            try {
                Position[] positions = this.getPositions(this.fDocument);
                if (!success && positions != null) {
                    int i = 0;
                    while (i != positions.length) {
                        TypedPosition position = (TypedPosition)positions[i];
                        this.fDocument.replace(position.getOffset(), position.getLength(), position.getType());
                        ++i;
                    }
                }
                this.fDocument.removePositionCategory(this.fPositionCategoryName);
                this.fIsActive = false;
            }
            catch (BadLocationException e) {
                PHPeclipsePlugin.log(e);
                Assert.isTrue((boolean)false);
            }
            catch (BadPositionCategoryException e) {
                PHPeclipsePlugin.log(e);
                Assert.isTrue((boolean)false);
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.fDocument.removePositionUpdater((IPositionUpdater)this);
            fgActiveManagers.remove(this.fDocument);
            throw throwable;
        }
        {
            Object var5_9 = null;
        }
        this.fDocument.removePositionUpdater((IPositionUpdater)this);
        fgActiveManagers.remove(this.fDocument);
    }

    public Position getPosition(int offset) {
        Position[] positions = this.getPositions(this.fDocument);
        if (positions == null) {
            return null;
        }
        int i = positions.length - 1;
        while (i >= 0) {
            Position position = positions[i];
            if (offset >= position.getOffset() && offset <= position.getOffset() + position.getLength()) {
                return positions[i];
            }
            --i;
        }
        return null;
    }

    public Position getFirstPosition() {
        return this.getNextPosition(-1);
    }

    public Position getLastPosition() {
        Position[] positions = this.getPositions(this.fDocument);
        int i = positions.length - 1;
        while (i >= 0) {
            String type = ((TypedPosition)positions[i]).getType();
            int j = 0;
            while (j != i) {
                if (((TypedPosition)positions[j]).getType().equals(type)) break;
                ++j;
            }
            if (j == i) {
                return positions[i];
            }
            --i;
        }
        return null;
    }

    public Position getNextPosition(int offset) {
        Position[] positions = this.getPositions(this.fDocument);
        return LinkedPositionManager.findNextPosition(positions, offset);
    }

    private static Position findNextPosition(Position[] positions, int offset) {
        int i = 0;
        while (i != positions.length) {
            if (positions[i].getOffset() > offset) {
                String type = ((TypedPosition)positions[i]).getType();
                int j = 0;
                while (j != i) {
                    if (((TypedPosition)positions[j]).getType().equals(type)) break;
                    ++j;
                }
                if (j == i) {
                    return positions[i];
                }
            }
            ++i;
        }
        return null;
    }

    public Position getPreviousPosition(int offset) {
        Position[] positions = this.getPositions(this.fDocument);
        if (positions == null) {
            return null;
        }
        TypedPosition currentPosition = (TypedPosition)LinkedPositionManager.findCurrentPosition(positions, offset);
        String currentType = currentPosition == null ? null : currentPosition.getType();
        Position lastPosition = null;
        Position position = this.getFirstPosition();
        while (position != null && position.getOffset() < offset) {
            if (!((TypedPosition)position).getType().equals(currentType)) {
                lastPosition = position;
            }
            position = LinkedPositionManager.findNextPosition(positions, position.getOffset());
        }
        return lastPosition;
    }

    private Position[] getPositions(IDocument document) {
        if (!this.fIsActive) {
            // empty if block
        }
        try {
            Position[] positions = document.getPositions(this.fPositionCategoryName);
            Arrays.sort(positions, fgPositionComparator);
            return positions;
        }
        catch (BadPositionCategoryException e) {
            PHPeclipsePlugin.log(e);
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    public static boolean includes(Position position, int offset, int length) {
        return offset >= position.getOffset() && offset + length <= position.getOffset() + position.getLength();
    }

    public static boolean excludes(Position position, int offset, int length) {
        return offset + length <= position.getOffset() || position.getOffset() + position.getLength() <= offset;
    }

    private static boolean collides(Position position, int offset, int length) {
        return offset <= position.getOffset() + position.getLength() && position.getOffset() <= offset + length;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void leave(boolean success) {
        try {
            this.uninstall(success);
            if (this.fListener != null) {
                this.fListener.exit((success ? 2 : 0) | 8);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.fMustLeave = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.fMustLeave = false;
            return;
        }
    }

    private void abort() {
        this.uninstall(true);
        if (this.fListener != null) {
            this.fListener.exit(2);
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        if (this.fMustLeave) {
            event.getDocument().removeDocumentListener((IDocumentListener)this);
            return;
        }
        IDocument document = event.getDocument();
        Position[] positions = this.getPositions(document);
        Position position = LinkedPositionManager.findCurrentPosition(positions, event.getOffset());
        if (position == null) {
            if ((event.getText() == null || event.getText().length() == 0) && LinkedPositionManager.findCurrentPosition(positions, event.getOffset()) != null && LinkedPositionManager.findCurrentPosition(positions, event.getOffset() + event.getLength()) != null) {
                this.leave(true);
            }
        } else if (LinkedPositionManager.includes(position, event.getOffset(), event.getLength())) {
            if (this.containsLineDelimiters(event.getText())) {
                this.leave(true);
            }
        } else {
            this.leave(true);
        }
    }

    public void documentChanged(DocumentEvent event) {
        IDocument document = event.getDocument();
        Position[] positions = this.getPositions(document);
        TypedPosition currentPosition = (TypedPosition)LinkedPositionManager.findCurrentPosition(positions, event.getOffset());
        if (currentPosition == null) {
            return;
        }
        int deltaOffset = event.getOffset() - currentPosition.getOffset();
        if (this.fListener != null) {
            int length = event.getText() == null ? 0 : event.getText().length();
            this.fListener.setCurrentPosition((Position)currentPosition, deltaOffset + length);
        }
        int i = 0;
        while (i != positions.length) {
            TypedPosition p = (TypedPosition)positions[i];
            if (p.getType().equals(currentPosition.getType()) && !p.equals((Object)currentPosition)) {
                Replace replace = new Replace((Position)p, deltaOffset, event.getLength(), event.getText());
                ((IDocumentExtension)document).registerPostNotificationReplace((IDocumentListener)this, (IDocumentExtension.IReplace)replace);
            }
            ++i;
        }
    }

    public void update(DocumentEvent event) {
        int eventOffset = event.getOffset();
        int eventOldLength = event.getLength();
        int eventNewLength = event.getText() == null ? 0 : event.getText().length();
        int deltaLength = eventNewLength - eventOldLength;
        Position[] positions = this.getPositions(event.getDocument());
        int i = 0;
        while (i != positions.length) {
            Position position = positions[i];
            if (!position.isDeleted()) {
                int offset = position.getOffset();
                int length = position.getLength();
                int end = offset + length;
                if (offset > eventOffset + eventOldLength) {
                    position.setOffset(offset + deltaLength);
                } else if (end >= eventOffset) {
                    if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                        position.setLength(length + deltaLength);
                    } else if (offset < eventOffset) {
                        int newEnd = eventOffset + eventNewLength;
                        position.setLength(newEnd - offset);
                    } else if (end > eventOffset + eventOldLength) {
                        int newOffset = eventOffset + eventNewLength;
                        position.setOffset(newOffset);
                        position.setLength(length + deltaLength);
                    } else {
                        position.delete();
                        this.fMustLeave = true;
                    }
                }
            }
            ++i;
        }
        if (this.fMustLeave) {
            this.abort();
        }
    }

    private static Position findCurrentPosition(Position[] positions, int offset) {
        int i = 0;
        while (i != positions.length) {
            if (LinkedPositionManager.includes(positions[i], offset, 0)) {
                return positions[i];
            }
            ++i;
        }
        return null;
    }

    private boolean containsLineDelimiters(String string) {
        if (string == null) {
            return false;
        }
        String[] delimiters = this.fDocument.getLegalLineDelimiters();
        int i = 0;
        while (i != delimiters.length) {
            if (string.indexOf(delimiters[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean anyPositionIncludes(int offset, int length) {
        Position[] positions = this.getPositions(this.fDocument);
        Position position = LinkedPositionManager.findCurrentPosition(positions, offset);
        if (position == null) {
            return false;
        }
        return LinkedPositionManager.includes(position, offset, length);
    }

    public Position getEmbracingPosition(int offset, int length) {
        Position[] positions = this.getPositions(this.fDocument);
        Position position = LinkedPositionManager.findCurrentPosition(positions, offset);
        if (position != null && LinkedPositionManager.includes(position, offset, length)) {
            return position;
        }
        return null;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (this.fMustLeave) {
            this.leave(true);
            return;
        }
        if (command.getCommandCount() != 1) {
            this.leave(true);
            return;
        }
        Position[] positions = this.getPositions(document);
        TypedPosition currentPosition = (TypedPosition)LinkedPositionManager.findCurrentPosition(positions, command.offset);
        if (currentPosition == null) {
            this.leave(true);
            return;
        }
        if (!command.doit) {
            return;
        }
        command.doit = false;
        command.owner = this;
        command.caretOffset = command.offset + command.length;
        int deltaOffset = command.offset - currentPosition.getOffset();
        if (this.fListener != null) {
            this.fListener.setCurrentPosition((Position)currentPosition, deltaOffset + command.text.length());
        }
        int i = 0;
        while (i != positions.length) {
            TypedPosition position = (TypedPosition)positions[i];
            try {
                if (position.getType().equals(currentPosition.getType()) && !position.equals((Object)currentPosition)) {
                    command.addCommand(position.getOffset() + deltaOffset, command.length, command.text, (IDocumentListener)this);
                }
            }
            catch (BadLocationException e) {
                PHPeclipsePlugin.log(e);
            }
            ++i;
        }
    }

    private static class PositionComparator
    implements Comparator {
        private PositionComparator() {
        }

        public int compare(Object object0, Object object1) {
            Position position0 = (Position)object0;
            Position position1 = (Position)object1;
            return position0.getOffset() - position1.getOffset();
        }
    }

    private class Replace
    implements IDocumentExtension.IReplace {
        private Position fReplacePosition;
        private int fReplaceDeltaOffset;
        private int fReplaceLength;
        private String fReplaceText;

        public Replace(Position position, int deltaOffset, int length, String text) {
            this.fReplacePosition = position;
            this.fReplaceDeltaOffset = deltaOffset;
            this.fReplaceLength = length;
            this.fReplaceText = text;
        }

        public void perform(IDocument document, IDocumentListener owner) {
            document.removeDocumentListener(owner);
            try {
                document.replace(this.fReplacePosition.getOffset() + this.fReplaceDeltaOffset, this.fReplaceLength, this.fReplaceText);
            }
            catch (BadLocationException e) {
                PHPeclipsePlugin.log(e);
            }
            document.addDocumentListener(owner);
        }
    }
}

