/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.phpdt.internal.ui.preferences.OverlayPreferenceStore;
import net.sourceforge.phpdt.internal.ui.text.folding.FoldingMessages;
import net.sourceforge.phpdt.ui.text.folding.IJavaFoldingPreferenceBlock;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DefaultJavaFoldingPreferenceBlock
implements IJavaFoldingPreferenceBlock {
    private IPreferenceStore fStore;
    private OverlayPreferenceStore fOverlayStore;
    private OverlayPreferenceStore.OverlayKey[] fKeys;
    private Map fCheckBoxes = new HashMap();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            DefaultJavaFoldingPreferenceBlock.this.fOverlayStore.setValue((String)DefaultJavaFoldingPreferenceBlock.this.fCheckBoxes.get(button), button.getSelection());
        }
    };

    public DefaultJavaFoldingPreferenceBlock() {
        this.fStore = PHPeclipsePlugin.getDefault().getPreferenceStore();
        this.fKeys = this.createKeys();
        this.fOverlayStore = new OverlayPreferenceStore(this.fStore, this.fKeys);
    }

    private OverlayPreferenceStore.OverlayKey[] createKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_javadoc"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_headers"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_innertypes"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "editor_folding_default_methods"));
        return overlayKeys.toArray(new OverlayPreferenceStore.OverlayKey[overlayKeys.size()]);
    }

    public Control createControl(Composite composite) {
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 3;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        Label label = new Label(inner, 16384);
        label.setText(FoldingMessages.getString("DefaultJavaFoldingPreferenceBlock.title"));
        this.addCheckBox(inner, FoldingMessages.getString("DefaultJavaFoldingPreferenceBlock.comments"), "editor_folding_default_javadoc", 0);
        this.addCheckBox(inner, FoldingMessages.getString("DefaultJavaFoldingPreferenceBlock.headers"), "editor_folding_default_headers", 0);
        this.addCheckBox(inner, FoldingMessages.getString("DefaultJavaFoldingPreferenceBlock.innerTypes"), "editor_folding_default_innertypes", 0);
        this.addCheckBox(inner, FoldingMessages.getString("DefaultJavaFoldingPreferenceBlock.methods"), "editor_folding_default_methods", 0);
        return inner;
    }

    private Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 1;
        gd.grabExcessVerticalSpace = false;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    private void initializeFields() {
        Iterator it = this.fCheckBoxes.keySet().iterator();
        while (it.hasNext()) {
            Button b = (Button)it.next();
            String key = (String)this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
    }

    public void performOk() {
        this.fOverlayStore.propagate();
    }

    public void initialize() {
        this.initializeFields();
    }

    public void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
    }

    public void dispose() {
        this.fOverlayStore.stop();
    }
}

