/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.phpdt.internal.ui.preferences.EditTemplateDialog;
import net.sourceforge.phpdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import net.sourceforge.phpdt.internal.ui.preferences.PreferencesMessages;
import net.sourceforge.phpdt.internal.ui.preferences.TemplateEditorSourceViewerConfiguration;
import net.sourceforge.phpdt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import net.sourceforge.phpdt.internal.ui.util.PixelConverter;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.DialogField;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.LayoutUtil;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import net.sourceforge.phpdt.ui.PreferenceConstants;
import net.sourceforge.phpdt.ui.text.IColorManager;
import net.sourceforge.phpdt.ui.text.JavaTextTools;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.phpeditor.JavaSourceViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CodeTemplateBlock {
    private static final int IDX_EDIT = 0;
    private static final int IDX_IMPORT = 2;
    private static final int IDX_EXPORT = 3;
    private static final int IDX_EXPORTALL = 4;
    protected static final Object COMMENT_NODE = PreferencesMessages.getString("CodeTemplateBlock.templates.comment.node");
    protected static final Object CODE_NODE = PreferencesMessages.getString("CodeTemplateBlock.templates.code.node");
    private static final String PREF_JAVADOC_STUBS = "net.sourceforge.phpdt.ui.phpdoc";
    private TreeListDialogField fCodeTemplateTree;
    private SelectionButtonDialogField fCreateJavaDocComments;
    protected TemplateStore fTemplates = PHPeclipsePlugin.getDefault().getCodeTemplateStore();
    private PixelConverter fPixelConverter;
    private SourceViewer fPatternViewer;
    private Control fSWTWidget;
    private TemplateVariableProcessor fTemplateProcessor = new TemplateVariableProcessor();

    public CodeTemplateBlock() {
        CodeTemplateAdapter adapter = new CodeTemplateAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = PreferencesMessages.getString("CodeTemplateBlock.templates.edit.button");
        stringArray[2] = PreferencesMessages.getString("CodeTemplateBlock.templates.import.button");
        stringArray[3] = PreferencesMessages.getString("CodeTemplateBlock.templates.export.button");
        stringArray[4] = PreferencesMessages.getString("CodeTemplateBlock.templates.exportall.button");
        String[] buttonLabels = stringArray;
        this.fCodeTemplateTree = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CodeTemplateLabelProvider());
        this.fCodeTemplateTree.setDialogFieldListener(adapter);
        this.fCodeTemplateTree.setLabelText(PreferencesMessages.getString("CodeTemplateBlock.templates.label"));
        this.fCodeTemplateTree.enableButton(3, false);
        this.fCodeTemplateTree.enableButton(0, false);
        this.fCodeTemplateTree.addElement(COMMENT_NODE);
        this.fCodeTemplateTree.addElement(CODE_NODE);
        this.fCreateJavaDocComments = new SelectionButtonDialogField(96);
        this.fCreateJavaDocComments.setLabelText(PreferencesMessages.getString("CodeTemplateBlock.createcomment.label"));
        this.fCreateJavaDocComments.setSelection(PreferenceConstants.getPreferenceStore().getBoolean(PREF_JAVADOC_STUBS));
        this.fCodeTemplateTree.selectFirstElement();
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fCodeTemplateTree.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fCodeTemplateTree.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fCodeTemplateTree.getTreeControl(null));
        this.fPatternViewer = this.createViewer(composite, 2);
        this.fCreateJavaDocComments.doFillIntoGrid(composite, 2);
        DialogField label = new DialogField();
        label.setLabelText(PreferencesMessages.getString("CodeTemplateBlock.createcomment.description"));
        label.doFillIntoGrid(composite, 2);
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return PHPeclipsePlugin.getActiveWorkbenchShell();
    }

    private SourceViewer createViewer(Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setText(PreferencesMessages.getString("CodeTemplateBlock.preview"));
        GridData data = new GridData();
        data.horizontalSpan = nColumns;
        label.setLayoutData((Object)data);
        Document document = new Document();
        JavaTextTools tools = PHPeclipsePlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___php_partitioning");
        IPreferenceStore store = PHPeclipsePlugin.getDefault().getCombinedPreferenceStore();
        JavaSourceViewer viewer = new JavaSourceViewer(parent, null, null, false, 2816, store);
        TemplateEditorSourceViewerConfiguration configuration = new TemplateEditorSourceViewerConfiguration((IColorManager)tools.getColorManager(), store, null, this.fTemplateProcessor);
        viewer.configure(configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"net.sourceforge.phpdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        data = new GridData(1296);
        data.horizontalSpan = nColumns;
        data.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected TemplatePersistenceData[] getTemplateOfCategory(boolean isComment) {
        ArrayList<TemplatePersistenceData> res = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] templates = this.fTemplates.getTemplateData(false);
        int i = 0;
        while (i < templates.length) {
            TemplatePersistenceData curr = templates[i];
            if (isComment == curr.getTemplate().getName().endsWith("comment")) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new TemplatePersistenceData[res.size()]);
    }

    protected static boolean canEdit(List selected) {
        return selected.size() == 1 && selected.get(0) instanceof TemplatePersistenceData;
    }

    protected void updateSourceViewerInput(List selection) {
        if (this.fPatternViewer == null || this.fPatternViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (selection.size() == 1 && selection.get(0) instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.get(0);
            Template template = data.getTemplate();
            TemplateContextType type = PHPeclipsePlugin.getDefault().getCodeTemplateContextRegistry().getContextType(template.getContextTypeId());
            this.fTemplateProcessor.setContextType(type);
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void doButtonPressed(int buttonIndex, List selected) {
        if (buttonIndex == 0) {
            this.edit((TemplatePersistenceData)selected.get(0));
        } else if (buttonIndex == 3) {
            this.export(selected);
        } else if (buttonIndex == 4) {
            this.exportAll();
        } else if (buttonIndex == 2) {
            this.import_();
        }
    }

    private void edit(TemplatePersistenceData data) {
        Template newTemplate = new Template(data.getTemplate());
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), newTemplate, true, false, PHPeclipsePlugin.getDefault().getCodeTemplateContextRegistry());
        if (dialog.open() == 0) {
            data.setTemplate(newTemplate);
            this.fCodeTemplateTree.refresh(data);
            this.fCodeTemplateTree.selectElements((ISelection)new StructuredSelection((Object)data));
        }
    }

    private void import_() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(PreferencesMessages.getString("CodeTemplateBlock.import.title"));
        dialog.setFilterExtensions(new String[]{PreferencesMessages.getString("CodeTemplateBlock.import.extension")});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            TemplateReaderWriter reader = new TemplateReaderWriter();
            File file = new File(path);
            if (file.exists()) {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                TemplatePersistenceData[] datas = reader.read((InputStream)input, null);
                int i = 0;
                while (i < datas.length) {
                    this.updateTemplate(datas[i]);
                    ++i;
                }
            }
            this.fCodeTemplateTree.refresh();
            this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
        }
        catch (FileNotFoundException e) {
            this.openReadErrorDialog(e);
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void updateTemplate(TemplatePersistenceData data) {
        TemplatePersistenceData[] datas = this.fTemplates.getTemplateData(true);
        int i = 0;
        while (i < datas.length) {
            String id = datas[i].getId();
            if (id != null && id.equals(data.getId())) {
                datas[i].setTemplate(data.getTemplate());
                break;
            }
            ++i;
        }
    }

    private void exportAll() {
        this.export(this.fTemplates.getTemplateData(false));
    }

    private void export(List selected) {
        ArrayList datas = new ArrayList();
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof TemplatePersistenceData) {
                datas.add(curr);
            } else {
                TemplatePersistenceData[] cat = this.getTemplateOfCategory(curr == COMMENT_NODE);
                datas.addAll(Arrays.asList(cat));
            }
            ++i;
        }
        this.export(datas.toArray(new TemplatePersistenceData[datas.size()]));
    }

    private void export(TemplatePersistenceData[] templates) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(PreferencesMessages.getFormattedString("CodeTemplateBlock.export.title", String.valueOf(templates.length)));
        dialog.setFilterExtensions(new String[]{PreferencesMessages.getString("CodeTemplateBlock.export.extension")});
        dialog.setFileName(PreferencesMessages.getString("CodeTemplateBlock.export.filename"));
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            String title = PreferencesMessages.getString("CodeTemplateBlock.export.error.title");
            String message = PreferencesMessages.getFormattedString("CodeTemplateBlock.export.error.hidden", file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = PreferencesMessages.getString("CodeTemplateBlock.export.error.title");
            String message = PreferencesMessages.getFormattedString("CodeTemplateBlock.export.error.canNotWrite", file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            try {
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
                TemplateReaderWriter writer = new TemplateReaderWriter();
                writer.save(templates, (OutputStream)output);
            }
            catch (IOException e) {
                this.openWriteErrorDialog(e);
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferencesMessages.getString("CodeTemplateBlock.export.exists.title"), (String)PreferencesMessages.getFormattedString("CodeTemplateBlock.export.exists.message", file.getAbsolutePath()));
    }

    public void performDefaults() {
        IPreferenceStore prefs = PHPeclipsePlugin.getDefault().getPreferenceStore();
        this.fCreateJavaDocComments.setSelection(prefs.getDefaultBoolean(PREF_JAVADOC_STUBS));
        this.fTemplates.restoreDefaults();
        this.fCodeTemplateTree.refresh();
        this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
    }

    public boolean performOk(boolean enabled) {
        IPreferenceStore prefs = PreferenceConstants.getPreferenceStore();
        prefs.setValue(PREF_JAVADOC_STUBS, this.fCreateJavaDocComments.isSelected());
        PHPeclipsePlugin.getDefault().savePluginPreferences();
        try {
            this.fTemplates.save();
        }
        catch (IOException e) {
            PHPeclipsePlugin.log(e);
            this.openWriteErrorDialog(e);
        }
        return true;
    }

    public void performCancel() {
        try {
            this.fTemplates.load();
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void openReadErrorDialog(Exception e) {
        String title = PreferencesMessages.getString("CodeTemplateBlock.error.read.title");
        String message = e.getLocalizedMessage();
        message = message != null ? PreferencesMessages.getFormattedString("CodeTemplateBlock.error.parse.message", message) : PreferencesMessages.getString("CodeTemplateBlock.error.read.message");
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openWriteErrorDialog(Exception e) {
        String title = PreferencesMessages.getString("CodeTemplateBlock.error.write.title");
        String message = PreferencesMessages.getString("CodeTemplateBlock.error.write.message");
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private class CodeTemplateAdapter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] NO_CHILDREN = new Object[0];

        private CodeTemplateAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            CodeTemplateBlock.this.doButtonPressed(index, field.getSelectedElements());
        }

        public void selectionChanged(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            field.enableButton(0, CodeTemplateBlock.canEdit(selected));
            field.enableButton(3, !selected.isEmpty());
            CodeTemplateBlock.this.updateSourceViewerInput(selected);
        }

        public void doubleClicked(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            if (CodeTemplateBlock.canEdit(selected)) {
                CodeTemplateBlock.this.doButtonPressed(0, selected);
            }
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE) {
                return CodeTemplateBlock.this.getTemplateOfCategory(element == COMMENT_NODE);
            }
            return this.NO_CHILDREN;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof TemplatePersistenceData) {
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                if (data.getTemplate().getName().endsWith("comment")) {
                    return COMMENT_NODE;
                }
                return CODE_NODE;
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element == COMMENT_NODE || element == CODE_NODE;
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }
    }

    private static class CodeTemplateLabelProvider
    extends LabelProvider {
        private CodeTemplateLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE) {
                return (String)element;
            }
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            Template template = data.getTemplate();
            String name = template.getName();
            if ("catchblock".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.catchblock.label");
            }
            if ("methodbody".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.methodstub.label");
            }
            if ("constructorbody".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.constructorstub.label");
            }
            if ("getterbody".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.getterstub.label");
            }
            if ("setterbody".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.setterstub.label");
            }
            if ("newtype".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.newtype.label");
            }
            if ("typecomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.typecomment.label");
            }
            if ("fieldcomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.fieldcomment.label");
            }
            if ("methodcomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.methodcomment.label");
            }
            if ("overridecomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.overridecomment.label");
            }
            if ("constructorcomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.constructorcomment.label");
            }
            if ("gettercomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.gettercomment.label");
            }
            if ("settercomment".equals(name)) {
                return PreferencesMessages.getString("CodeTemplateBlock.settercomment.label");
            }
            return template.getDescription();
        }
    }
}

