/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.codemanipulation;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.IBuffer;
import net.sourceforge.phpdt.core.ICodeFormatter;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.Signature;
import net.sourceforge.phpdt.core.ToolFactory;
import net.sourceforge.phpdt.internal.corext.codemanipulation.CodeGenerationSettings;
import net.sourceforge.phpdt.internal.corext.template.php.CodeTemplateContext;
import net.sourceforge.phpdt.internal.corext.util.JavaModelUtil;
import net.sourceforge.phpdt.internal.corext.util.Strings;
import net.sourceforge.phpdt.internal.ui.PHPUIStatus;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;

public class StubUtility {
    private static final String[] EMPTY = new String[0];
    private static final List BASE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");

    public static String genStub(ICompilationUnit cu, String destTypeName, IMethod method, IType definingType, GenStubSettings settings) throws CoreException {
        int flags;
        String methName = method.getElementName();
        String[] paramNames = StubUtility.suggestArgumentNames(method.getJavaProject(), method.getParameterNames());
        String returnType = method.isConstructor() ? null : method.getReturnType();
        String lineDelimiter = String.valueOf('\n');
        StringBuffer buf = new StringBuffer();
        if (settings.createComments && cu != null) {
            String comment;
            IMethod overridden = null;
            if (settings.methodOverwrites && returnType != null) {
                overridden = JavaModelUtil.findMethod(methName, method.getParameterTypes(), false, definingType.getMethods());
            }
            if ((comment = StubUtility.getMethodComment(cu, destTypeName, methName, paramNames, method.getExceptionTypes(), returnType, overridden, lineDelimiter)) != null) {
                buf.append(comment);
            } else {
                buf.append("/**").append(lineDelimiter);
                buf.append(" *").append(lineDelimiter);
                buf.append(" */").append(lineDelimiter);
            }
            buf.append(lineDelimiter);
        }
        String bodyContent = null;
        if (!settings.noBody) {
            String bodyStatement = StubUtility.getDefaultMethodBodyStatement(methName, paramNames, returnType, settings.callSuper);
            bodyContent = StubUtility.getMethodBodyContent(returnType == null, method.getJavaProject(), destTypeName, methName, bodyStatement, lineDelimiter);
            if (bodyContent == null) {
                bodyContent = "";
            }
        }
        if ((flags = settings.methodModifiers) == -1) {
            flags = method.getFlags();
        }
        StubUtility.genMethodDeclaration(destTypeName, method, flags, bodyContent, buf);
        return buf.toString();
    }

    public static void genMethodDeclaration(String destTypeName, IMethod method, String bodyContent, StringBuffer buf) throws CoreException {
        StubUtility.genMethodDeclaration(destTypeName, method, method.getFlags(), bodyContent, buf);
    }

    public static void genMethodDeclaration(String destTypeName, IMethod method, int flags, String bodyContent, StringBuffer buf) throws CoreException {
        IType parentType = method.getDeclaringType();
        String methodName = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        String[] paramNames = StubUtility.suggestArgumentNames(parentType.getJavaProject(), method.getParameterNames());
        String[] excTypes = method.getExceptionTypes();
        boolean isConstructor = method.isConstructor();
        String retTypeSig = isConstructor ? null : method.getReturnType();
        int lastParam = paramTypes.length - 1;
        if (Flags.isPublic(flags) || parentType.isInterface() && bodyContent != null) {
            buf.append("public ");
        } else if (Flags.isProtected(flags)) {
            buf.append("protected ");
        } else if (Flags.isPrivate(flags)) {
            buf.append("private ");
        }
        if (Flags.isStatic(flags)) {
            buf.append("static ");
        }
        if (isConstructor) {
            buf.append(destTypeName);
        } else {
            String retTypeFrm = !StubUtility.isPrimitiveType(retTypeSig) ? StubUtility.resolveAndAdd(retTypeSig, parentType) : Signature.toString(retTypeSig);
            buf.append(retTypeFrm);
            buf.append(' ');
            buf.append(methodName);
        }
        buf.append('(');
        int i = 0;
        while (i <= lastParam) {
            String paramTypeSig = paramTypes[i];
            String paramTypeFrm = !StubUtility.isPrimitiveType(paramTypeSig) ? StubUtility.resolveAndAdd(paramTypeSig, parentType) : Signature.toString(paramTypeSig);
            buf.append(paramTypeFrm);
            buf.append(' ');
            buf.append(paramNames[i]);
            if (i < lastParam) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append(')');
        int lastExc = excTypes.length - 1;
        if (lastExc >= 0) {
            buf.append(" throws ");
            int i2 = 0;
            while (i2 <= lastExc) {
                String excTypeSig = excTypes[i2];
                String excTypeFrm = StubUtility.resolveAndAdd(excTypeSig, parentType);
                buf.append(excTypeFrm);
                if (i2 < lastExc) {
                    buf.append(", ");
                }
                ++i2;
            }
        }
        if (bodyContent == null) {
            buf.append(";\n\n");
        } else {
            buf.append(" {\n\t");
            if (bodyContent != null && bodyContent.length() > 0) {
                buf.append(bodyContent);
                buf.append('\n');
            }
            buf.append("}\n");
        }
    }

    public static String getDefaultMethodBodyStatement(String methodName, String[] paramNames, String retTypeSig, boolean callSuper) {
        StringBuffer buf = new StringBuffer();
        if (callSuper) {
            if (retTypeSig != null) {
                if (!"V".equals(retTypeSig)) {
                    buf.append("return ");
                }
                buf.append("super.");
                buf.append(methodName);
            } else {
                buf.append("super");
            }
            buf.append('(');
            int i = 0;
            while (i < paramNames.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(paramNames[i]);
                ++i;
            }
            buf.append(");");
        } else if (retTypeSig != null && !retTypeSig.equals("V")) {
            if (!StubUtility.isPrimitiveType(retTypeSig) || Signature.getArrayCount(retTypeSig) > 0) {
                buf.append("return null;");
            } else if (retTypeSig.equals("Z")) {
                buf.append("return false;");
            } else {
                buf.append("return 0;");
            }
        }
        return buf.toString();
    }

    public static String getMethodBodyContent(boolean isConstructor, IJavaProject project, String destTypeName, String methodName, String bodyStatement, String lineDelimiter) throws CoreException {
        String templateName = isConstructor ? "constructorbody" : "methodbody";
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return bodyStatement;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("body_statement", bodyStatement);
        String str = StubUtility.evaluateTemplate(context, template);
        if (str == null && !Strings.containsOnlyWhitespaces(bodyStatement)) {
            return bodyStatement;
        }
        return str;
    }

    public static String getGetterMethodBodyContent(IJavaProject project, String destTypeName, String methodName, String fieldName, String lineDelimiter) throws CoreException {
        String templateName = "getterbody";
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterMethodBodyContent(IJavaProject project, String destTypeName, String methodName, String fieldName, String paramName, String lineDelimiter) throws CoreException {
        String templateName = "setterbody";
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("enclosing_type", destTypeName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCatchBodyContent(ICompilationUnit cu, String exceptionType, String variableName, String lineDelimiter) throws CoreException {
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate("catchblock");
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setVariable("exception_type", exceptionType);
        context.setVariable("exception_var", variableName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getCompilationUnitContent(ICompilationUnit cu, String typeComment, String typeContent, String lineDelimiter) throws CoreException {
        IPackageFragment pack = (IPackageFragment)cu.getParent();
        String packDecl = pack.isDefaultPackage() ? "" : "package " + pack.getElementName() + ';';
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate("newtype");
        if (template == null) {
            return null;
        }
        IJavaProject project = cu.getJavaProject();
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), project, lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("package_declaration", packDecl);
        context.setVariable("typecomment", typeComment != null ? typeComment : "");
        context.setVariable("type_declaration", typeContent);
        context.setVariable("type_name", Signature.getQualifier(cu.getElementName()));
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getTypeComment(ICompilationUnit cu, String typeQualifiedName, String lineDelim) throws CoreException {
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate("typecomment");
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelim);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", Signature.getQualifier(typeQualifiedName));
        context.setVariable("type_name", Signature.getSimpleName(typeQualifiedName));
        return StubUtility.evaluateTemplate(context, template);
    }

    private static String getSeeTag(String declaringClassQualifiedName, String methodName, String[] parameterTypesQualifiedNames) {
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringClassQualifiedName);
        buf.append('#');
        buf.append(methodName);
        buf.append('(');
        int i = 0;
        while (i < parameterTypesQualifiedNames.length) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(parameterTypesQualifiedNames[i]);
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    private static String getSeeTag(IMethod overridden) throws JavaModelException {
        IType declaringType = overridden.getDeclaringType();
        StringBuffer buf = new StringBuffer();
        buf.append("@see ");
        buf.append(declaringType.getFullyQualifiedName('.'));
        buf.append('#');
        buf.append(overridden.getElementName());
        buf.append('(');
        String[] paramTypes = overridden.getParameterTypes();
        int i = 0;
        while (i < paramTypes.length) {
            if (i > 0) {
                buf.append(", ");
            }
            String curr = paramTypes[i];
            buf.append(JavaModelUtil.getResolvedTypeName(curr, declaringType));
            int arrayCount = Signature.getArrayCount(curr);
            while (arrayCount > 0) {
                buf.append("[]");
                --arrayCount;
            }
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public static String getMethodComment(IMethod method, IMethod overridden, String lineDelimiter) throws CoreException {
        String retType = method.isConstructor() ? null : method.getReturnType();
        String[] paramNames = method.getParameterNames();
        return StubUtility.getMethodComment(method.getCompilationUnit(), method.getDeclaringType().getElementName(), method.getElementName(), paramNames, method.getExceptionTypes(), retType, overridden, lineDelimiter);
    }

    public static String getMethodComment(ICompilationUnit cu, String typeName, String methodName, String[] paramNames, String[] excTypeSig, String retTypeSig, IMethod overridden, String lineDelimiter) throws CoreException {
        TemplateBuffer buffer;
        String templateName = "methodcomment";
        if (retTypeSig == null) {
            templateName = "constructorcomment";
        } else if (overridden != null) {
            templateName = "overridecomment";
        }
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        if (retTypeSig != null) {
            context.setVariable("return_type", Signature.toString(retTypeSig));
        }
        if (overridden != null) {
            context.setVariable("see_to_overridden", StubUtility.getSeeTag(overridden));
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        TemplateVariable position = StubUtility.findTagVariable(buffer);
        if (position == null) {
            return str;
        }
        Document textBuffer = new Document(str);
        String[] exceptionNames = new String[excTypeSig.length];
        int i = 0;
        while (i < excTypeSig.length) {
            exceptionNames[i] = Signature.toString(excTypeSig[i]);
            ++i;
        }
        String returnType = retTypeSig != null ? Signature.toString(retTypeSig) : null;
        int[] tagOffsets = position.getOffsets();
        int i2 = tagOffsets.length - 1;
        while (i2 >= 0) {
            try {
                StubUtility.insertTag((IDocument)textBuffer, tagOffsets[i2], position.getLength(), paramNames, exceptionNames, returnType, false, lineDelimiter);
            }
            catch (BadLocationException e) {
                throw new CoreException(PHPUIStatus.createError(4, e));
            }
            --i2;
        }
        return textBuffer.get();
    }

    public static String getFieldComment(ICompilationUnit cu, String typeName, String fieldName, String lineDelimiter) throws CoreException {
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate("fieldcomment");
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("field_type", typeName);
        context.setVariable("field", fieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getSetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String paramName, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "settercomment";
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        context.setVariable("param", paramName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String getGetterComment(ICompilationUnit cu, String typeName, String methodName, String fieldName, String fieldType, String bareFieldName, String lineDelimiter) throws CoreException {
        String templateName = "gettercomment";
        Template template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate(templateName);
        if (template == null) {
            return null;
        }
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), cu.getJavaProject(), lineDelimiter);
        context.setCompilationUnitVariables(cu);
        context.setVariable("enclosing_type", typeName);
        context.setVariable("enclosing_method", methodName);
        context.setVariable("field", fieldName);
        context.setVariable("field_type", fieldType);
        context.setVariable("bare_field_name", bareFieldName);
        return StubUtility.evaluateTemplate(context, template);
    }

    public static String evaluateTemplate(CodeTemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException badLocationException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException templateException) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces(str)) {
            return null;
        }
        return str;
    }

    private static TemplateVariable findTagVariable(TemplateBuffer buffer) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if ("tags".equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void insertTag(IDocument textBuffer, int offset, int length, String[] paramNames, String[] exceptionNames, String returnType, boolean isDeprecated, String lineDelimiter) throws BadLocationException {
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < paramNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter);
                buf.append(lineStart);
            }
            buf.append("@param ");
            buf.append(paramNames[i]);
            ++i;
        }
        if (returnType != null && !returnType.equals("void")) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter);
                buf.append(lineStart);
            }
            buf.append("@return");
        }
        if (exceptionNames != null) {
            i = 0;
            while (i < exceptionNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter);
                    buf.append(lineStart);
                }
                buf.append("@throws ");
                buf.append(exceptionNames[i]);
                ++i;
            }
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter);
                buf.append(lineStart);
            }
            buf.append("@deprecated");
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isPrimitiveType(String typeName) {
        char first = Signature.getElementType(typeName).charAt(0);
        return first != 'L' && first != 'Q';
    }

    private static String resolveAndAdd(String refTypeSig, IType declaringType) throws JavaModelException {
        String resolvedTypeName = JavaModelUtil.getResolvedTypeName(refTypeSig, declaringType);
        if (resolvedTypeName != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(resolvedTypeName);
            int arrayCount = Signature.getArrayCount(refTypeSig);
            int i = 0;
            while (i < arrayCount) {
                buf.append("[]");
                ++i;
            }
            return buf.toString();
        }
        return Signature.toString(refTypeSig);
    }

    private static IMethod findMethod(IMethod method, List allMethods) throws JavaModelException {
        String name = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        boolean isConstructor = method.isConstructor();
        int i = allMethods.size() - 1;
        while (i >= 0) {
            IMethod curr = (IMethod)allMethods.get(i);
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, curr)) {
                return curr;
            }
            --i;
        }
        return null;
    }

    public static String getLineDelimiterUsed(IJavaElement elem) throws JavaModelException {
        ICompilationUnit cu = (ICompilationUnit)elem.getAncestor(5);
        if (cu != null && cu.exists()) {
            IBuffer buf = cu.getBuffer();
            int length = buf.getLength();
            int i = 0;
            while (i < length) {
                char ch = buf.getChar(i);
                if (ch == '\r') {
                    if (i + 1 < length && buf.getChar(i + 1) == '\n') {
                        return "\r\n";
                    }
                    return "\r";
                }
                if (ch == '\n') {
                    return "\n";
                }
                ++i;
            }
        }
        return System.getProperty("line.separator", "\n");
    }

    public static String getLineDelimiterFor(IDocument doc) {
        String lineDelim = null;
        try {
            lineDelim = doc.getLineDelimiter(0);
        }
        catch (BadLocationException badLocationException) {}
        if (lineDelim == null) {
            String systemDelimiter = System.getProperty("line.separator", "\n");
            String[] lineDelims = doc.getLegalLineDelimiters();
            int i = 0;
            while (i < lineDelims.length) {
                if (lineDelims[i].equals(systemDelimiter)) {
                    lineDelim = systemDelimiter;
                    break;
                }
                ++i;
            }
            if (lineDelim == null) {
                lineDelim = lineDelims.length > 0 ? lineDelims[0] : systemDelimiter;
            }
        }
        return lineDelim;
    }

    public static String codeFormat(String sourceString, int initialIndentationLevel, String lineDelim) {
        ICodeFormatter formatter = ToolFactory.createDefaultCodeFormatter(null);
        return formatter.format(sourceString, initialIndentationLevel, null, lineDelim);
    }

    public static String getTodoTaskTag(IJavaProject project) {
        String markers = null;
        markers = project == null ? JavaCore.getOption("net.sourceforge.phpeclipse.compiler.taskTags") : project.getOption("net.sourceforge.phpeclipse.compiler.taskTags", true);
        if (markers != null && markers.length() > 0) {
            int idx = markers.indexOf(44);
            if (idx == -1) {
                return markers;
            }
            return markers.substring(0, idx);
        }
        return null;
    }

    private static String[] sortByLength(String[] proposals) {
        Arrays.sort(proposals, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o2).length() - ((String)o1).length();
            }
        });
        return proposals;
    }

    private static String workaround38111(String baseName) {
        if (BASE_TYPES.contains(baseName)) {
            return baseName;
        }
        return String.valueOf(Character.toUpperCase(baseName.charAt(0))) + baseName.substring(1);
    }

    public static String suggestArgumentName(IJavaProject project, String baseName, String[] excluded) {
        return baseName;
    }

    public static String[] suggestArgumentNames(IJavaProject project, String[] paramNames) {
        String prefixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.argumentPrefixes", true);
        String suffixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.argumentSuffixes", true);
        if (prefixes.length() + suffixes.length() == 0) {
            return paramNames;
        }
        String[] newNames = new String[paramNames.length];
        int i = 0;
        while (i < paramNames.length) {
            String curr = paramNames[i];
            newNames[i] = !StubUtility.hasPrefixOrSuffix(prefixes, suffixes, curr) ? StubUtility.suggestArgumentName(project, paramNames[i], null) : curr;
            ++i;
        }
        return newNames;
    }

    public static boolean hasFieldName(IJavaProject project, String name) {
        String prefixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.fieldPrefixes", true);
        String suffixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.fieldSuffixes", true);
        String staticPrefixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.staticFieldPrefixes", true);
        String staticSuffixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.staticFieldSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name) || StubUtility.hasPrefixOrSuffix(staticPrefixes, staticSuffixes, name);
    }

    public static boolean hasParameterName(IJavaProject project, String name) {
        String prefixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.argumentPrefixes", true);
        String suffixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.argumentSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasLocalVariableName(IJavaProject project, String name) {
        String prefixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.localPrefixes", true);
        String suffixes = project.getOption("net.sourceforge.phpeclipse.codeComplete.localSuffixes", true);
        return StubUtility.hasPrefixOrSuffix(prefixes, suffixes, name);
    }

    public static boolean hasConstantName(String name) {
        return Character.isUpperCase(name.charAt(0));
    }

    private static boolean hasPrefixOrSuffix(String prefixes, String suffixes, String name) {
        String curr;
        StringTokenizer tok = new StringTokenizer(prefixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.startsWith(curr)) continue;
            return true;
        }
        tok = new StringTokenizer(suffixes, ",");
        while (tok.hasMoreTokens()) {
            curr = tok.nextToken();
            if (!name.endsWith(curr)) continue;
            return true;
        }
        return false;
    }

    public static class GenStubSettings
    extends CodeGenerationSettings {
        public boolean callSuper;
        public boolean methodOverwrites;
        public boolean noBody;
        public int methodModifiers;

        public GenStubSettings(CodeGenerationSettings settings) {
            settings.setSettings(this);
            this.methodModifiers = -1;
        }
    }
}

