/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.builder;

import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.env.ICompilationUnit;
import net.sourceforge.phpdt.internal.compiler.problem.AbortCompilation;
import net.sourceforge.phpdt.internal.core.builder.ClasspathMultiDirectory;
import net.sourceforge.phpdt.internal.core.builder.MissingSourceFileException;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class SourceFile
implements ICompilationUnit {
    IFile resource;
    ClasspathMultiDirectory sourceLocation;
    String initialTypeName;
    String encoding;

    public SourceFile(IFile resource, ClasspathMultiDirectory sourceLocation, String encoding) {
        this.resource = resource;
        this.sourceLocation = sourceLocation;
        this.initialTypeName = this.extractTypeName();
        this.encoding = encoding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SourceFile)) {
            return false;
        }
        SourceFile f = (SourceFile)o;
        return this.sourceLocation == f.sourceLocation && this.resource.getFullPath().equals((Object)f.resource.getFullPath());
    }

    String extractTypeName() {
        IPath fullPath = this.resource.getFullPath();
        int resourceSegmentCount = fullPath.segmentCount();
        int sourceFolderSegmentCount = this.sourceLocation.sourceFolder.getFullPath().segmentCount();
        String extension = fullPath.getFileExtension();
        int ext_length = extension == null ? 0 : extension.length() + 1;
        int charCount = resourceSegmentCount - sourceFolderSegmentCount - 1 - ext_length;
        int i = sourceFolderSegmentCount;
        while (i < resourceSegmentCount) {
            charCount += fullPath.segment(i).length();
            ++i;
        }
        char[] result = new char[charCount];
        int offset = 0;
        --resourceSegmentCount;
        int i2 = sourceFolderSegmentCount;
        while (i2 < resourceSegmentCount) {
            String segment = fullPath.segment(i2);
            int size = segment.length();
            segment.getChars(0, size, result, offset);
            offset += size;
            result[offset++] = 47;
            ++i2;
        }
        String segment = fullPath.segment(resourceSegmentCount);
        int size = segment.length() - ext_length;
        segment.getChars(0, size, result, offset);
        return new String(result);
    }

    public char[] getContents() {
        try {
            return Util.getResourceContentsAsCharArray(this.resource, this.encoding);
        }
        catch (CoreException coreException) {
            throw new AbortCompilation(true, new MissingSourceFileException(this.resource.getFullPath().toString()));
        }
    }

    public char[] getFileName() {
        return this.resource.getFullPath().toString().toCharArray();
    }

    public char[] getMainTypeName() {
        char[] typeName = this.initialTypeName.toCharArray();
        int lastIndex = CharOperation.lastIndexOf('/', typeName);
        return CharOperation.subarray(typeName, lastIndex + 1, -1);
    }

    public char[][] getPackageName() {
        char[] typeName = this.initialTypeName.toCharArray();
        int lastIndex = CharOperation.lastIndexOf('/', typeName);
        return CharOperation.splitOn('/', typeName, 0, lastIndex);
    }

    String typeLocator() {
        return this.resource.getProjectRelativePath().toString();
    }

    public String toString() {
        return "SourceFile[" + this.resource.getFullPath() + "]";
    }

    public IResource getResource() {
        return this.resource;
    }
}

