/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaModelStatus;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.compiler.util.ObjectVector;
import net.sourceforge.phpdt.internal.core.JavaElementDelta;
import net.sourceforge.phpdt.internal.core.JavaModel;
import net.sourceforge.phpdt.internal.core.JavaModelManager;
import net.sourceforge.phpdt.internal.core.JavaModelOperation;
import net.sourceforge.phpdt.internal.core.JavaModelStatus;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.PackageFragmentRoot;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class SetClasspathOperation
extends JavaModelOperation {
    IClasspathEntry[] oldResolvedPath;
    IClasspathEntry[] newResolvedPath;
    IClasspathEntry[] newRawPath;
    boolean canChangeResources;
    boolean classpathWasSaved;
    boolean needCycleCheck;
    boolean needValidation;
    boolean needSave;
    IPath newOutputLocation;
    JavaProject project;
    boolean identicalRoots;
    public static final IClasspathEntry[] ReuseClasspath = new IClasspathEntry[0];
    public static final IClasspathEntry[] UpdateClasspath = new IClasspathEntry[0];
    public static final IPath ReuseOutputLocation = new Path("Reuse Existing Output Location");

    public SetClasspathOperation(JavaProject project, IClasspathEntry[] oldResolvedPath, IClasspathEntry[] newRawPath, IPath newOutputLocation, boolean canChangeResource, boolean needValidation, boolean needSave) {
        super(new IJavaElement[]{project});
        this.oldResolvedPath = oldResolvedPath;
        this.newRawPath = newRawPath;
        this.newOutputLocation = newOutputLocation;
        this.canChangeResources = canChangeResource;
        this.needValidation = needValidation;
        this.needSave = needSave;
        this.project = project;
    }

    protected void addClasspathDeltas(IPackageFragmentRoot[] roots, int flag, JavaElementDelta delta) {
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            delta.changed(root, flag);
            if ((flag & 0x80) != 0 || (flag & 0x1000) != 0 || (flag & 0x2000) != 0) {
                try {
                    root.close();
                }
                catch (JavaModelException javaModelException) {}
                ((PackageFragmentRoot)root).setSourceAttachmentProperty(null);
            }
            ++i;
        }
    }

    protected int classpathContains(IClasspathEntry[] list, IClasspathEntry entry) {
        IPath[] exclusionPatterns = entry.getExclusionPatterns();
        int i = 0;
        while (i < list.length) {
            IClasspathEntry other = list[i];
            if (other.getContentKind() == entry.getContentKind() && other.getEntryKind() == entry.getEntryKind() && other.isExported() == entry.isExported() && other.getPath().equals((Object)entry.getPath())) {
                IPath entryOutput = entry.getOutputLocation();
                IPath otherOutput = other.getOutputLocation();
                if (!(entryOutput != null ? !entryOutput.equals((Object)otherOutput) : otherOutput != null)) {
                    IPath[] otherExcludes = other.getExclusionPatterns();
                    if (exclusionPatterns != otherExcludes) {
                        int excludeLength = exclusionPatterns.length;
                        if (otherExcludes.length == excludeLength) {
                            int j = 0;
                            while (j < excludeLength) {
                                if (exclusionPatterns[j].toString().equals(otherExcludes[j].toString())) {
                                    ++j;
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        return i;
                    }
                }
            }
            ++i;
        }
        return -1;
    }

    protected void collectAllSubfolders(IFolder folder, ArrayList collection) throws JavaModelException {
        try {
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource r = members[i];
                if (r.getType() == 2) {
                    collection.add(r);
                    this.collectAllSubfolders((IFolder)r, collection);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeOperation() throws JavaModelException {
        block23: {
            this.updateProjectReferencesIfNecessary();
            this.saveClasspathIfNecessary();
            originalException = null;
            try {
                try {
                    if (this.newRawPath == SetClasspathOperation.UpdateClasspath) {
                        this.newRawPath = this.project.getRawClasspath();
                    }
                    if (this.newRawPath != SetClasspathOperation.ReuseClasspath) {
                        this.updateClasspath();
                        this.project.updatePackageFragmentRoots();
                        JavaModelManager.getJavaModelManager().getDeltaProcessor().addForRefresh(this.project);
                    }
                }
                catch (JavaModelException e) {
                    originalException = e;
                    throw e;
                }
                var3_5 = null;
            }
            catch (Throwable var4_3) {
                var3_4 = null;
                try {
                    try {
                        if (this.newOutputLocation != SetClasspathOperation.ReuseOutputLocation) {
                            this.updateOutputLocation();
                        }
                    }
                    catch (JavaModelException e) {
                        if (originalException == null) throw e;
                        throw originalException;
                    }
                    var6_11 = null;
                    if (this.identicalRoots != false) throw var4_3;
                    if (this.canChangeResources == false) throw var4_3;
                }
                catch (Throwable var7_8) {
                    var6_10 = null;
                    if (this.identicalRoots != false) throw var7_8;
                    if (this.canChangeResources == false) throw var7_8;
                    try {
                        this.project.getProject().touch(this.progressMonitor);
                        throw var7_8;
                    }
                    catch (CoreException e) {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE == false) throw var7_8;
                        Util.verbose("CPContainer INIT - FAILED to touch project: " + this.project.getElementName(), System.err);
                        e.printStackTrace();
                    }
                    throw var7_8;
                }
                ** try [egrp 4[TRYBLOCK] [6 : 134->153)] { 
lbl49:
                // 1 sources

                this.project.getProject().touch(this.progressMonitor);
                throw var4_3;
lbl51:
                // 1 sources

                catch (CoreException e) {
                    if (JavaModelManager.CP_RESOLVE_VERBOSE == false) throw var4_3;
                    Util.verbose("CPContainer INIT - FAILED to touch project: " + this.project.getElementName(), System.err);
                    e.printStackTrace();
                }
                throw var4_3;
            }
            try {}
            catch (Throwable var7_9) {
                var6_12 = null;
                if (this.identicalRoots != false) throw var7_9;
                if (this.canChangeResources == false) throw var7_9;
                ** try [egrp 4[TRYBLOCK] [6 : 134->153)] { 
lbl63:
                // 1 sources

                this.project.getProject().touch(this.progressMonitor);
                throw var7_9;
lbl65:
                // 1 sources

                catch (CoreException e) {
                    if (JavaModelManager.CP_RESOLVE_VERBOSE == false) throw var7_9;
                    Util.verbose("CPContainer INIT - FAILED to touch project: " + this.project.getElementName(), System.err);
                    e.printStackTrace();
                }
                throw var7_9;
            }
            try {}
            catch (JavaModelException e) {
                if (originalException == null) throw e;
                throw originalException;
            }
            if (this.newOutputLocation != SetClasspathOperation.ReuseOutputLocation) {
                this.updateOutputLocation();
            }
            var6_13 = null;
            if (this.identicalRoots || !this.canChangeResources) break block23;
            ** try [egrp 4[TRYBLOCK] [6 : 134->153)] { 
lbl81:
            // 1 sources

            this.project.getProject().touch(this.progressMonitor);
            break block23;
lbl83:
            // 1 sources

            catch (CoreException e) {
                if (!JavaModelManager.CP_RESOLVE_VERBOSE) break block23;
                Util.verbose("CPContainer INIT - FAILED to touch project: " + this.project.getElementName(), System.err);
                e.printStackTrace();
            }
        }
        this.done();
    }

    protected void generateClasspathChangeDeltas() {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        boolean needToUpdateDependents = false;
        JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
        boolean hasDelta = false;
        if (this.classpathWasSaved) {
            delta.changed(this.project, 131072);
            hasDelta = true;
        }
        int oldLength = this.oldResolvedPath.length;
        int newLength = this.newResolvedPath.length;
        HashMap<IPath, IPackageFragmentRoot> oldRoots = null;
        IPackageFragmentRoot[] roots = null;
        if (this.project.isOpen()) {
            try {
                roots = this.project.getPackageFragmentRoots();
            }
            catch (JavaModelException javaModelException) {}
        } else {
            Map allRemovedRoots = manager.getDeltaProcessor().removedRoots;
            if (allRemovedRoots != null) {
                roots = (IPackageFragmentRoot[])allRemovedRoots.get(this.project);
            }
        }
        if (roots != null) {
            oldRoots = new HashMap<IPath, IPackageFragmentRoot>();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                oldRoots.put(root.getPath(), root);
                ++i;
            }
        }
        int i = 0;
        while (i < oldLength) {
            int index = this.classpathContains(this.newResolvedPath, this.oldResolvedPath[i]);
            if (index == -1) {
                if (this.oldResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    IPackageFragmentRoot oldRoot;
                    Object[] pkgFragmentRoots = null;
                    if (oldRoots != null && (oldRoot = (IPackageFragmentRoot)oldRoots.get(this.oldResolvedPath[i].getPath())) != null) {
                        pkgFragmentRoots = new IPackageFragmentRoot[]{oldRoot};
                    }
                    if (pkgFragmentRoots == null) {
                        try {
                            ObjectVector accumulatedRoots = new ObjectVector();
                            HashSet<String> rootIDs = new HashSet<String>(5);
                            rootIDs.add(this.project.rootID());
                            this.project.computePackageFragmentRoots(this.oldResolvedPath[i], accumulatedRoots, rootIDs, true, false, false);
                            pkgFragmentRoots = new IPackageFragmentRoot[accumulatedRoots.size()];
                            accumulatedRoots.copyInto(pkgFragmentRoots);
                        }
                        catch (JavaModelException javaModelException) {
                            pkgFragmentRoots = new IPackageFragmentRoot[]{};
                        }
                    }
                    this.addClasspathDeltas((IPackageFragmentRoot[])pkgFragmentRoots, 128, delta);
                    int changeKind = this.oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3 || this.oldResolvedPath[i].isExported();
                    hasDelta = true;
                }
            } else if (this.oldResolvedPath[i].getEntryKind() == 2) {
                this.needCycleCheck |= this.oldResolvedPath[i].isExported() ^ this.newResolvedPath[index].isExported();
            } else {
                IPath newRootPath;
                IPath oldRootPath;
                int sourceAttachmentRootFlags;
                needToUpdateDependents |= this.oldResolvedPath[i].isExported() ^ this.newResolvedPath[index].isExported();
                if (index != i) {
                    this.addClasspathDeltas(this.project.computePackageFragmentRoots(this.oldResolvedPath[i]), 256, delta);
                    int changeKind = this.oldResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3;
                    hasDelta = true;
                }
                IPath newSourcePath = this.newResolvedPath[index].getSourceAttachmentPath();
                int sourceAttachmentFlags = this.getSourceAttachmentDeltaFlag(this.oldResolvedPath[i].getSourceAttachmentPath(), newSourcePath);
                int flags = sourceAttachmentFlags | (sourceAttachmentRootFlags = this.getSourceAttachmentDeltaFlag(oldRootPath = this.oldResolvedPath[i].getSourceAttachmentRootPath(), newRootPath = this.newResolvedPath[index].getSourceAttachmentRootPath()));
                if (flags != 0) {
                    this.addClasspathDeltas(this.project.computePackageFragmentRoots(this.oldResolvedPath[i]), flags, delta);
                    hasDelta = true;
                } else if (oldRootPath == null && newRootPath == null) {
                    IPackageFragmentRoot[] computedRoots = this.project.computePackageFragmentRoots(this.oldResolvedPath[i]);
                    int j = 0;
                    while (j < computedRoots.length) {
                        IPackageFragmentRoot root = computedRoots[j];
                        try {
                            root.close();
                        }
                        catch (JavaModelException javaModelException) {}
                        ((PackageFragmentRoot)root).setSourceAttachmentProperty(null);
                        ++j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < newLength) {
            int index = this.classpathContains(this.oldResolvedPath, this.newResolvedPath[i]);
            if (index == -1) {
                if (this.newResolvedPath[i].getEntryKind() == 2) {
                    needToUpdateDependents = true;
                    this.needCycleCheck = true;
                } else {
                    this.addClasspathDeltas(this.project.computePackageFragmentRoots(this.newResolvedPath[i]), 64, delta);
                    int changeKind = this.newResolvedPath[i].getEntryKind();
                    needToUpdateDependents |= changeKind == 3 || this.newResolvedPath[i].isExported();
                    hasDelta = true;
                }
            }
            ++i;
        }
        if (hasDelta) {
            this.addDelta(delta);
        } else {
            this.identicalRoots = true;
        }
        if (needToUpdateDependents) {
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
    }

    protected void saveClasspathIfNecessary() throws JavaModelException {
        IPath outputLocationForSave;
        if (!this.canChangeResources || !this.needSave) {
            return;
        }
        IClasspathEntry[] classpathForSave = this.newRawPath == ReuseClasspath || this.newRawPath == UpdateClasspath ? this.project.getRawClasspath() : this.newRawPath;
        if (this.project.saveClasspath(classpathForSave, outputLocationForSave = this.newOutputLocation == ReuseOutputLocation ? this.project.getOutputLocation() : this.newOutputLocation)) {
            this.classpathWasSaved = true;
            this.setAttribute("hasModifiedResource", "true");
        }
    }

    protected JavaProject getProject() {
        return (JavaProject)this.getElementsToProcess()[0];
    }

    private int getSourceAttachmentDeltaFlag(IPath oldPath, IPath newPath, IPath sourcePath) {
        if (oldPath == null) {
            if (newPath != null) {
                return 4096;
            }
            if (sourcePath != null) {
                return 12288;
            }
            return 0;
        }
        if (newPath == null) {
            return 8192;
        }
        if (!oldPath.equals((Object)newPath)) {
            return 12288;
        }
        return 0;
    }

    private int getSourceAttachmentDeltaFlag(IPath oldPath, IPath newPath) {
        if (oldPath == null) {
            if (newPath != null) {
                return 4096;
            }
            return 0;
        }
        if (newPath == null) {
            return 8192;
        }
        if (!oldPath.equals((Object)newPath)) {
            return 12288;
        }
        return 0;
    }

    public boolean isReadOnly() {
        return !this.canChangeResources;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        buffer.append("SetClasspathOperation\n");
        buffer.append(" - classpath : ");
        if (this.newRawPath == ReuseClasspath) {
            buffer.append("<Reuse Existing Classpath>");
        } else {
            buffer.append("{");
            int i = 0;
            while (i < this.newRawPath.length) {
                if (i > 0) {
                    buffer.append(",");
                }
                IClasspathEntry element = this.newRawPath[i];
                buffer.append(" ").append(element.toString());
                ++i;
            }
        }
        buffer.append("\n - output location : ");
        if (this.newOutputLocation == ReuseOutputLocation) {
            buffer.append("<Reuse Existing Output Location>");
        } else {
            buffer.append(this.newOutputLocation.toString());
        }
        return buffer.toString();
    }

    private void updateClasspath() throws JavaModelException {
        this.beginTask(Util.bind("classpath.settingProgress", this.project.getElementName()), 2);
        this.project.getPerProjectInfo().updateClasspathInformation(this.newRawPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = this.project.getResolvedClasspath(true, this.canChangeResources, false);
        }
        if (this.oldResolvedPath != null) {
            this.generateClasspathChangeDeltas();
        } else {
            this.needCycleCheck = true;
            this.updateAffectedProjects(this.project.getProject().getFullPath());
        }
        this.updateCycleMarkersIfNecessary();
    }

    protected void updateAffectedProjects(IPath prerequisiteProjectPath) {
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject originatingProject = this.getProject();
            IJavaProject[] projects = model.getJavaProjects();
            int i = 0;
            int projectCount = projects.length;
            while (i < projectCount) {
                block7: {
                    try {
                        JavaProject project = (JavaProject)projects[i];
                        if (project.equals(originatingProject)) break block7;
                        IClasspathEntry[] classpath = project.getExpandedClasspath(true);
                        int j = 0;
                        int entryCount = classpath.length;
                        while (j < entryCount) {
                            IClasspathEntry entry = classpath[j];
                            if (entry.getEntryKind() == 2 && entry.getPath().equals((Object)prerequisiteProjectPath)) {
                                project.setRawClasspath(UpdateClasspath, ReuseOutputLocation, this.progressMonitor, this.canChangeResources, project.getResolvedClasspath(true), false, false);
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    protected void updateCycleMarkersIfNecessary() {
        if (!this.needCycleCheck) {
            return;
        }
        if (!this.canChangeResources) {
            return;
        }
        if (!this.project.hasCycleMarker() && !this.project.hasClasspathCycle(this.newResolvedPath)) {
            return;
        }
        this.postAction(new JavaModelOperation.IPostAction(){

            public String getID() {
                return "updateCycleMarkers";
            }

            public void run() throws JavaModelException {
                JavaProject.updateAllCycleMarkers();
            }
        }, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOutputLocation() throws JavaModelException {
        JavaModelManager.PerProjectInfo perProjectInfo;
        JavaProject project = (JavaProject)this.getElementsToProcess()[0];
        this.beginTask(Util.bind("classpath.settingOutputLocationProgress", project.getElementName()), 2);
        project.getOutputLocation();
        boolean deltaToFire = false;
        JavaElementDelta delta = this.newJavaElementDelta();
        JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(project.getProject());
        synchronized (perProjectInfo2) {
            perProjectInfo.outputLocation = this.newOutputLocation;
        }
        if (deltaToFire) {
            this.addDelta(delta);
        }
        this.worked(1);
    }

    protected void updateProjectReferencesIfNecessary() throws JavaModelException {
        if (!this.canChangeResources) {
            return;
        }
        if (this.newRawPath == ReuseClasspath || this.newRawPath == UpdateClasspath) {
            return;
        }
        JavaProject jproject = this.getProject();
        String[] oldRequired = jproject.projectPrerequisites(this.oldResolvedPath);
        if (this.newResolvedPath == null) {
            this.newResolvedPath = jproject.getResolvedClasspath(this.newRawPath, null, true, this.needValidation, null);
        }
        String[] newRequired = jproject.projectPrerequisites(this.newResolvedPath);
        try {
            int newSize;
            HashSet newReferences;
            IProjectDescription description;
            IProject project;
            block13: {
                String projectName;
                project = jproject.getProject();
                description = project.getDescription();
                IProject[] projectReferences = description.getReferencedProjects();
                HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                int i = 0;
                while (i < projectReferences.length) {
                    String projectName2 = projectReferences[i].getName();
                    oldReferences.add(projectName2);
                    ++i;
                }
                newReferences = (HashSet)oldReferences.clone();
                int i2 = 0;
                while (i2 < oldRequired.length) {
                    projectName = oldRequired[i2];
                    newReferences.remove(projectName);
                    ++i2;
                }
                i2 = 0;
                while (i2 < newRequired.length) {
                    projectName = newRequired[i2];
                    newReferences.add(projectName);
                    ++i2;
                }
                newSize = newReferences.size();
                if (oldReferences.size() == newSize) {
                    Iterator iter = newReferences.iterator();
                    while (iter.hasNext()) {
                        if (oldReferences.contains(iter.next())) {
                            continue;
                        }
                        break block13;
                    }
                    return;
                }
            }
            String[] requiredProjectNames = new String[newSize];
            int index = 0;
            Iterator iter = newReferences.iterator();
            while (iter.hasNext()) {
                requiredProjectNames[index++] = (String)iter.next();
            }
            Util.sort(requiredProjectNames);
            IProject[] requiredProjectArray = new IProject[newSize];
            IWorkspaceRoot wksRoot = project.getWorkspace().getRoot();
            int i = 0;
            while (i < newSize) {
                requiredProjectArray[i] = wksRoot.getProject(requiredProjectNames[i]);
                ++i;
            }
            description.setReferencedProjects(requiredProjectArray);
            project.setDescription(description, this.progressMonitor);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.needValidation) {
            IPath outputLocation;
            IJavaProject project = (IJavaProject)this.getElementToProcess();
            IClasspathEntry[] entries = this.newRawPath;
            if (entries == ReuseClasspath) {
                try {
                    entries = project.getRawClasspath();
                }
                catch (JavaModelException e) {
                    return e.getJavaModelStatus();
                }
            }
            if ((outputLocation = this.newOutputLocation) == ReuseOutputLocation) {
                try {
                    outputLocation = project.getOutputLocation();
                }
                catch (JavaModelException e) {
                    return e.getJavaModelStatus();
                }
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

