/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.ArrayList;
import java.util.Map;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.WorkingCopyOwner;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.Openable;
import net.sourceforge.phpdt.internal.core.OpenableElementInfo;
import net.sourceforge.phpdt.internal.core.PackageFragment;
import net.sourceforge.phpdt.internal.core.PackageFragmentRootInfo;
import net.sourceforge.phpdt.internal.core.util.MementoTokenizer;
import net.sourceforge.phpdt.internal.core.util.Util;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;

public class PackageFragmentRoot
extends Openable
implements IPackageFragmentRoot {
    protected static final char ATTACHMENT_PROPERTY_DELIMITER = '*';
    protected static final String NO_SOURCE_ATTACHMENT = "";
    protected Object resource;

    protected PackageFragmentRoot(IResource resource, JavaProject project, String name) {
        super(project, name);
        this.resource = resource;
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        if (!this.resourceExists()) {
            throw this.newNotPresentException();
        }
        ((PackageFragmentRootInfo)info).setRootKind(this.determineKind(underlyingResource));
        return this.computeChildren(info, newElements);
    }

    protected int determineKind(IResource underlyingResource) throws JavaModelException {
        return 1;
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws JavaModelException {
        try {
            IResource underlyingResource = this.getResource();
            if (underlyingResource.getType() == 2 || underlyingResource.getType() == 4) {
                IContainer rootFolder;
                ArrayList vChildren = new ArrayList(5);
                char[][] exclusionPatterns = this.fullExclusionPatternChars();
                this.computeFolderChildren(rootFolder, !Util.isExcluded((IResource)(rootFolder = (IContainer)underlyingResource), exclusionPatterns), NO_SOURCE_ATTACHMENT, vChildren, exclusionPatterns);
                IJavaElement[] children = new IJavaElement[vChildren.size()];
                vChildren.toArray(children);
                info.setChildren(children);
            }
        }
        catch (JavaModelException e) {
            info.setChildren(new IJavaElement[0]);
            throw e;
        }
        return true;
    }

    protected void computeFolderChildren(IContainer folder, boolean isIncluded, String prefix, ArrayList vChildren, char[][] exclusionPatterns) throws JavaModelException {
        if (isIncluded) {
            IPackageFragment pkg = this.getPackageFragment(prefix);
            vChildren.add(pkg);
        }
        try {
            JavaProject cfr_ignored_0 = (JavaProject)this.getJavaProject();
            IResource[] members = folder.members();
            boolean hasIncluded = isIncluded;
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                String memberName = member.getName();
                switch (member.getType()) {
                    case 2: {
                        if (!Util.isValidFolderNameForPackage(memberName)) break;
                        Util.isExcluded(member, exclusionPatterns);
                        break;
                    }
                    case 1: {
                        if (hasIncluded || !Util.isValidCompilationUnitName(memberName) || Util.isExcluded(member, exclusionPatterns)) break;
                        hasIncluded = true;
                        IPackageFragment pkg = this.getPackageFragment(prefix);
                        vChildren.add(pkg);
                    }
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new JavaModelException(e, 969);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    protected Object createElementInfo() {
        return new PackageFragmentRootInfo();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageFragmentRoot)) {
            return false;
        }
        PackageFragmentRoot other = (PackageFragmentRoot)o;
        return this.getJavaModel().equals(other.getJavaModel()) && this.resource.equals(other.resource) && this.occurrenceCount == other.occurrenceCount;
    }

    char[][] fullExclusionPatternChars() {
        return null;
    }

    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        return false;
    }

    protected char getHandleMementoDelimiter() {
        return '/';
    }

    public int getElementType() {
        return 3;
    }

    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
            case '<': {
                String pkgName;
                if (memento.hasMoreTokens()) {
                    pkgName = memento.nextToken();
                    char firstChar = pkgName.charAt(0);
                    if (firstChar == '{' || firstChar == '!') {
                        token = pkgName;
                        pkgName = NO_SOURCE_ATTACHMENT;
                    } else {
                        token = null;
                    }
                } else {
                    pkgName = NO_SOURCE_ATTACHMENT;
                    token = null;
                }
                JavaElement pkg = (JavaElement)((Object)this.getPackageFragment(pkgName));
                if (token == null) {
                    return pkg.getHandleFromMemento(memento, owner);
                }
                return pkg.getHandleFromMemento(token, memento, owner);
            }
        }
        return null;
    }

    public String getHandleMemento() {
        IResource underlyingResource = this.getResource();
        IPath path = underlyingResource != null ? (this.getResource().getProject().equals((Object)this.getJavaProject().getProject()) ? underlyingResource.getProjectRelativePath() : underlyingResource.getFullPath()) : this.getPath();
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, path.toString());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
        return buff.toString();
    }

    public int getKind() throws JavaModelException {
        return ((PackageFragmentRootInfo)this.getElementInfo()).getRootKind();
    }

    public IPackageFragment getPackageFragment(String packageName) {
        if (packageName.indexOf(32) != -1) {
            char[][] compoundName = Util.toCompoundChars(packageName);
            StringBuffer buffer = new StringBuffer(packageName.length());
            int i = 0;
            int length = compoundName.length;
            while (i < length) {
                buffer.append(CharOperation.trim(compoundName[i]));
                if (i != length - 1) {
                    buffer.append('.');
                }
                ++i;
            }
            packageName = buffer.toString();
        }
        return new PackageFragment(this, packageName);
    }

    protected String getPackageName(IFolder folder) throws JavaModelException {
        IPath myPath = this.getPath();
        IPath pkgPath = folder.getFullPath();
        int mySegmentCount = myPath.segmentCount();
        int pkgSegmentCount = pkgPath.segmentCount();
        StringBuffer name = new StringBuffer(NO_SOURCE_ATTACHMENT);
        int i = mySegmentCount;
        while (i < pkgSegmentCount) {
            if (i > mySegmentCount) {
                name.append('.');
            }
            name.append(pkgPath.segment(i));
            ++i;
        }
        return name.toString();
    }

    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    public IResource getResource() {
        return (IResource)this.resource;
    }

    protected QualifiedName getSourceAttachmentPropertyName() throws JavaModelException {
        return new QualifiedName("net.sourceforge.phpeclipse", "sourceattachment: " + this.getPath().toOSString());
    }

    public void setSourceAttachmentProperty(String property) {
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(this.getSourceAttachmentPropertyName(), property);
        }
        catch (CoreException coreException) {}
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getResource();
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean isArchive() {
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (this.getElementName().length() == 0) {
            buffer.append("[project root]");
        } else {
            IPath path = this.getPath();
            if (this.getJavaProject().getElementName().equals(path.segment(0))) {
                buffer.append(path.removeFirstSegments(1).makeRelative());
            } else {
                buffer.append(path);
            }
        }
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

