/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.Flags;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IMember;
import net.sourceforge.phpdt.core.IMethod;
import net.sourceforge.phpdt.core.ISourceRange;
import net.sourceforge.phpdt.core.IType;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.Signature;
import net.sourceforge.phpdt.core.jdom.IDOMNode;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.MemberElementInfo;
import net.sourceforge.phpdt.internal.core.SourceRange;
import net.sourceforge.phpdt.internal.core.SourceRefElement;
import net.sourceforge.phpdt.internal.core.SourceType;

public abstract class Member
extends SourceRefElement
implements IMember {
    protected Member(JavaElement parent, String name) {
        super(parent, name);
    }

    protected boolean areSimilarMethods(String name1, String[] params1, String name2, String[] params2, String[] simpleNames1) {
        int params1Length;
        if (name1.equals(name2) && (params1Length = params1.length) == params2.length) {
            int i = 0;
            while (i < params1Length) {
                String simpleName2;
                String simpleName1 = simpleNames1 == null ? Signature.getSimpleName(Signature.toString(params1[i])) : simpleNames1[i];
                if (!simpleName1.equals(simpleName2 = Signature.getSimpleName(Signature.toString(params2[i])))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
        return this.getElementName().equals(node.getName());
    }

    protected IMethod[] findMethods(IMethod method, IMethod[] methods) {
        String elementName = method.getElementName();
        String[] parameters = method.getParameterTypes();
        int paramLength = parameters.length;
        String[] simpleNames = new String[paramLength];
        int i = 0;
        while (i < paramLength) {
            simpleNames[i] = Signature.getSimpleName(Signature.toString(parameters[i]));
            ++i;
        }
        ArrayList<IMethod> list = new ArrayList<IMethod>();
        int i2 = 0;
        int length = methods.length;
        while (i2 < length) {
            IMethod existingMethod = methods[i2];
            if (this.areSimilarMethods(elementName, parameters, existingMethod.getElementName(), existingMethod.getParameterTypes(), simpleNames)) {
                list.add(existingMethod);
            }
            ++i2;
        }
        int size = list.size();
        if (size == 0) {
            return null;
        }
        IMethod[] result = new IMethod[size];
        list.toArray(result);
        return result;
    }

    public IType getDeclaringType() {
        JavaElement parentElement = (JavaElement)this.getParent();
        if (parentElement.getElementType() == 7) {
            return (IType)((Object)parentElement);
        }
        return null;
    }

    public int getFlags() throws JavaModelException {
        MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
        return info.getModifiers();
    }

    protected char getHandleMementoDelimiter() {
        return '[';
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Member getOuterMostLocalContext() {
        Member member = this;
        Member lastLocalContext = null;
        while (true) {
            void var1_2;
            switch (var1_2.getElementType()) {
                case 5: 
                case 6: {
                    return lastLocalContext;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    lastLocalContext = (Member)var1_2;
                }
            }
            IJavaElement iJavaElement = var1_2.getParent();
        }
    }

    public ISourceRange getNameRange() throws JavaModelException {
        MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
        return new SourceRange(info.getNameSourceStart(), info.getNameSourceEnd() - info.getNameSourceStart() + 1);
    }

    public IType getType(String typeName, int count) {
        if (this.isBinary()) {
            throw new IllegalArgumentException("Not a source member " + this.toStringWithAncestors());
        }
        SourceType type = new SourceType(this, typeName);
        type.occurrenceCount = count;
        return type;
    }

    public boolean isBinary() {
        return false;
    }

    protected boolean isMainMethod(IMethod method) throws JavaModelException {
        String[] paramTypes;
        int flags;
        if ("main".equals(method.getElementName()) && "V".equals(method.getReturnType()) && Flags.isStatic(flags = method.getFlags()) && Flags.isPublic(flags) && (paramTypes = method.getParameterTypes()).length == 1) {
            String name = Signature.toString(paramTypes[0]);
            return "String[]".equals(Signature.getSimpleName(name));
        }
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public String readableName() {
        IType declaringType = this.getDeclaringType();
        if (declaringType != null) {
            String declaringName = ((JavaElement)((Object)this.getDeclaringType())).readableName();
            StringBuffer buffer = new StringBuffer(declaringName);
            buffer.append('.');
            buffer.append(this.getElementName());
            return buffer.toString();
        }
        return super.readableName();
    }

    protected void updateNameRange(int nameStart, int nameEnd) {
        try {
            MemberElementInfo info = (MemberElementInfo)this.getElementInfo();
            info.setNameSourceStart(nameStart);
            info.setNameSourceEnd(nameEnd);
        }
        catch (JavaModelException javaModelException) {
            return;
        }
    }
}

