/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.zip.ZipFile;
import net.sourceforge.phpdt.core.ElementChangedEvent;
import net.sourceforge.phpdt.core.IClasspathEntry;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.IElementChangedListener;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaElementDelta;
import net.sourceforge.phpdt.core.IJavaProject;
import net.sourceforge.phpdt.core.IPackageFragment;
import net.sourceforge.phpdt.core.IPackageFragmentRoot;
import net.sourceforge.phpdt.core.IParent;
import net.sourceforge.phpdt.core.IProblemRequestor;
import net.sourceforge.phpdt.core.IWorkingCopy;
import net.sourceforge.phpdt.core.JavaCore;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.WorkingCopyOwner;
import net.sourceforge.phpdt.core.compiler.IProblem;
import net.sourceforge.phpdt.internal.core.ClasspathEntry;
import net.sourceforge.phpdt.internal.core.CompilationUnit;
import net.sourceforge.phpdt.internal.core.DefaultWorkingCopyOwner;
import net.sourceforge.phpdt.internal.core.DeltaProcessingState;
import net.sourceforge.phpdt.internal.core.DeltaProcessor;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.JavaElementDelta;
import net.sourceforge.phpdt.internal.core.JavaElementDeltaBuilder;
import net.sourceforge.phpdt.internal.core.JavaElementInfo;
import net.sourceforge.phpdt.internal.core.JavaModel;
import net.sourceforge.phpdt.internal.core.JavaModelCache;
import net.sourceforge.phpdt.internal.core.JavaModelOperation;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.core.ModelUpdater;
import net.sourceforge.phpdt.internal.core.builder.PHPBuilder;
import net.sourceforge.phpdt.internal.core.builder.State;
import net.sourceforge.phpdt.internal.core.util.Util;
import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class JavaModelManager
implements ISaveParticipant {
    final JavaModel javaModel = new JavaModel();
    public static HashMap Variables = new HashMap(5);
    public static HashMap PreviousSessionVariables = new HashMap(5);
    public static HashSet OptionNames = new HashSet(20);
    public static final String CP_VARIABLE_PREFERENCES_PREFIX = "net.sourceforge.phpeclipse.classpathVariable.";
    public static final String CP_CONTAINER_PREFERENCES_PREFIX = "net.sourceforge.phpeclipse.classpathContainer.";
    public static final String CP_ENTRY_IGNORE = "##<cp entry ignore>##";
    public static HashMap containers = new HashMap(5);
    public static HashMap PreviousSessionContainers = new HashMap(5);
    public static final String FORMATTER_EXTPOINT_ID = "codeFormatter";
    public static final String JAVA_SOURCE_CONTENT_TYPE = "net.sourceforge.phpeclipse.phpSource";
    public static final IPath VariableInitializationInProgress = new Path("Variable Initialization In Progress");
    private static final String INDEX_MANAGER_DEBUG = "net.sourceforge.phpeclipse/debug/indexmanager";
    private static final String COMPILER_DEBUG = "net.sourceforge.phpeclipse/debug/compiler";
    private static final String JAVAMODEL_DEBUG = "net.sourceforge.phpeclipse/debug/javamodel";
    private static final String CP_RESOLVE_DEBUG = "net.sourceforge.phpeclipse/debug/cpresolution";
    private static final String ZIP_ACCESS_DEBUG = "net.sourceforge.phpeclipse/debug/zipaccess";
    private static final String DELTA_DEBUG = "net.sourceforge.phpeclipse/debug/javadelta";
    private static final String HIERARCHY_DEBUG = "net.sourceforge.phpeclipse/debug/hierarchy";
    private static final String POST_ACTION_DEBUG = "net.sourceforge.phpeclipse/debug/postaction";
    private static final String BUILDER_DEBUG = "net.sourceforge.phpeclipse/debug/builder";
    private static final String COMPLETION_DEBUG = "net.sourceforge.phpeclipse/debug/completion";
    private static final String SELECTION_DEBUG = "net.sourceforge.phpeclipse/debug/selection";
    private static final String SHARED_WC_DEBUG = "net.sourceforge.phpeclipse/debug/sharedworkingcopy";
    private static final String SEARCH_DEBUG = "net.sourceforge.phpeclipse/debug/search";
    public static final IWorkingCopy[] NoWorkingCopy = new IWorkingCopy[0];
    protected Map perWorkingCopyInfos = new HashMap(5);
    private static final JavaModelManager Manager = new JavaModelManager();
    protected JavaModelCache cache = new JavaModelCache();
    private ThreadLocal temporaryCache = new ThreadLocal();
    protected Map elementsOutOfSynchWithBuffers = new HashMap(11);
    public DeltaProcessingState deltaState = new DeltaProcessingState();
    private boolean isFiring = true;
    ArrayList javaModelDeltas = new ArrayList();
    HashMap reconcileDeltas = new HashMap();
    private IElementChangedListener[] elementChangedListeners = new IElementChangedListener[5];
    private int[] elementChangedListenerMasks = new int[5];
    private int elementChangedListenerCount = 0;
    public int currentChangeEventType = 2;
    public static final int DEFAULT_CHANGE_EVENT = 0;
    private final ModelUpdater modelUpdater = new ModelUpdater();
    public IJavaProject[] javaProjectsCache;
    protected Map perProjectInfo = new HashMap(5);
    public Map sharedWorkingCopies = new HashMap();
    protected WeakHashMap searchScopes = new WeakHashMap();
    public static boolean VERBOSE = false;
    public static boolean CP_RESOLVE_VERBOSE = false;
    public static boolean ZIP_ACCESS_VERBOSE = false;
    private HashMap zipFiles = new HashMap();
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    private ThreadLocal classpathsBeingResolved = new ThreadLocal();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean conflictsWithOutputLocation(IPath folderPath, JavaProject project) {
        try {
            IPath outputLocation = project.getOutputLocation();
            if (outputLocation == null) {
                return true;
            }
            if (!outputLocation.isPrefixOf(folderPath)) {
                return false;
            }
            IClasspathEntry[] classpath = project.getResolvedClasspath(true);
            boolean isOutputUsed = false;
            int i = 0;
            int length = classpath.length;
            while (true) {
                if (i >= length) {
                    return isOutputUsed;
                }
                IClasspathEntry entry = classpath[i];
                if (entry.getEntryKind() == 3) {
                    if (entry.getPath().equals((Object)outputLocation)) {
                        return false;
                    }
                    if (entry.getOutputLocation() == null) {
                        isOutputUsed = true;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return true;
        }
    }

    public static IJavaElement create(IResource resource, IJavaProject project) {
        if (resource == null) {
            return null;
        }
        int type = resource.getType();
        switch (type) {
            case 4: {
                return JavaCore.create((IProject)resource);
            }
            case 1: {
                return JavaModelManager.create((IFile)resource, project);
            }
            case 2: {
                return JavaModelManager.create((IFolder)resource, project);
            }
            case 8: {
                return JavaCore.create((IWorkspaceRoot)resource);
            }
        }
        return null;
    }

    public static IJavaElement create(IFile file, IJavaProject project) {
        String name;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if (file.getFileExtension() != null && PHPFileUtil.isValidPHPUnitName(name = file.getName())) {
            return JavaModelManager.createCompilationUnitFrom(file, project);
        }
        return null;
    }

    public static IJavaElement create(IFolder folder, IJavaProject project) {
        if (folder == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(folder.getProject());
        }
        IJavaElement element = JavaModelManager.determineIfOnClasspath((IResource)folder, project);
        if (JavaModelManager.conflictsWithOutputLocation(folder.getFullPath(), (JavaProject)project) || folder.getName().indexOf(46) >= 0 && !(element instanceof IPackageFragmentRoot)) {
            return null;
        }
        return element;
    }

    public static ICompilationUnit createCompilationUnitFrom(IFile file, IJavaProject project) {
        IPackageFragment pkg;
        if (file == null) {
            return null;
        }
        if (project == null) {
            project = JavaCore.create(file.getProject());
        }
        if ((pkg = (IPackageFragment)JavaModelManager.determineIfOnClasspath((IResource)file, project)) == null) {
            IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)file.getParent());
            pkg = root.getPackageFragment("");
            if (VERBOSE) {
                System.out.println("WARNING : creating unit element outside classpath (" + Thread.currentThread() + "): " + file.getFullPath());
            }
        }
        return pkg.getCompilationUnit(file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IJavaElement determineIfOnClasspath(IResource resource, IJavaProject project) {
        IPath resourcePath = resource.getFullPath();
        try {
            IClasspathEntry[] entries = net.sourceforge.phpdt.internal.compiler.util.Util.isJavaFileName(resourcePath.lastSegment()) ? project.getRawClasspath() : ((JavaProject)project).getResolvedClasspath(true);
            int i = 0;
            while (true) {
                if (i >= entries.length) {
                    return null;
                }
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() != 2) {
                    IPath rootPath = entry.getPath();
                    if (rootPath.equals((Object)resourcePath)) {
                        return project.getPackageFragmentRoot(resource);
                    }
                    if (rootPath.isPrefixOf(resourcePath) && !Util.isExcluded(resource, null, ((ClasspathEntry)entry).fullExclusionPatternChars())) {
                        IPackageFragmentRoot root = ((JavaProject)project).getFolderPackageFragmentRoot(rootPath);
                        if (root == null) {
                            return null;
                        }
                        IPath pkgPath = resourcePath.removeFirstSegments(rootPath.segmentCount());
                        if (resource.getType() == 1) {
                            pkgPath = pkgPath.removeLastSegments(1);
                            String pkgName = pkgPath.toString();
                            return root.getPackageFragment(pkgName);
                        }
                        String pkgName = Util.packageName(pkgPath);
                        if (pkgName != null) return root.getPackageFragment(pkgName);
                        return null;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private JavaModelManager() {
    }

    public void addElementChangedListener(IElementChangedListener listener) {
        this.addElementChangedListener(listener, 5);
    }

    public void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int cloneLength = this.elementChangedListenerMasks.length;
                this.elementChangedListenerMasks = new int[cloneLength];
                System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, cloneLength);
                this.elementChangedListenerMasks[i] = eventMask;
                return;
            }
            ++i;
        }
        int length = this.elementChangedListeners.length;
        if (length == this.elementChangedListenerCount) {
            this.elementChangedListeners = new IElementChangedListener[length * 2];
            System.arraycopy(this.elementChangedListeners, 0, this.elementChangedListeners, 0, length);
            this.elementChangedListenerMasks = new int[length * 2];
            System.arraycopy(this.elementChangedListenerMasks, 0, this.elementChangedListenerMasks, 0, length);
        }
        this.elementChangedListeners[this.elementChangedListenerCount] = listener;
        this.elementChangedListenerMasks[this.elementChangedListenerCount] = eventMask;
        ++this.elementChangedListenerCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheZipFiles() {
        HashMap hashMap = this.zipFiles;
        synchronized (hashMap) {
            Thread currentThread = Thread.currentThread();
            if (this.zipFiles.get(currentThread) != null) {
                return;
            }
            this.zipFiles.put(currentThread, new HashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeZipFile(ZipFile zipFile) {
        if (zipFile == null) {
            return;
        }
        HashMap hashMap = this.zipFiles;
        synchronized (hashMap) {
            if (this.zipFiles.get(Thread.currentThread()) != null) {
                return;
            }
            try {
                if (ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [JavaModelManager.closeZipFile(ZipFile)] Closing ZipFile on " + zipFile.getName());
                }
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void configurePluginDebugOptions() {
        if (JavaCore.getPlugin().isDebugging()) {
            String option = Platform.getDebugOption((String)BUILDER_DEBUG);
            option = Platform.getDebugOption((String)CP_RESOLVE_DEBUG);
            if (option != null) {
                CP_RESOLVE_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)DELTA_DEBUG)) != null) {
                DeltaProcessor.VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)JAVAMODEL_DEBUG)) != null) {
                VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)POST_ACTION_DEBUG)) != null) {
                JavaModelOperation.POST_ACTION_VERBOSE = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)ZIP_ACCESS_DEBUG)) != null) {
                ZIP_ACCESS_VERBOSE = option.equalsIgnoreCase("true");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int discardPerWorkingCopyInfo(CompilationUnit workingCopy) throws JavaModelException {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            PerWorkingCopyInfo info;
            Map workingCopyToInfos;
            WorkingCopyOwner owner;
            block11: {
                block10: {
                    owner = workingCopy.owner;
                    workingCopyToInfos = (Map)this.perWorkingCopyInfos.get(owner);
                    if (workingCopyToInfos != null) break block10;
                    return -1;
                }
                info = (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
                if (info != null) break block11;
                return -1;
            }
            if (--info.useCount == 0) {
                JavaElementDeltaBuilder deltaBuilder = null;
                if (workingCopy.isPrimary()) {
                    deltaBuilder = new JavaElementDeltaBuilder(workingCopy);
                }
                workingCopyToInfos.remove(workingCopy);
                if (workingCopyToInfos.isEmpty()) {
                    this.perWorkingCopyInfos.remove(owner);
                }
                this.removeInfoAndChildren(workingCopy);
                workingCopy.closeBuffer();
                if (deltaBuilder != null) {
                    deltaBuilder.buildDeltas();
                    if (deltaBuilder.delta != null && deltaBuilder.delta.getAffectedChildren().length > 0) {
                        this.getDeltaProcessor().registerJavaModelDelta(deltaBuilder.delta);
                    }
                }
            }
            return info.useCount;
        }
    }

    public void doneSaving(ISaveContext context) {
    }

    public void fire(IJavaElementDelta customDelta, int eventType) {
        if (!this.isFiring) {
            return;
        }
        if (DeltaProcessor.VERBOSE && (eventType == 0 || eventType == 2)) {
            System.out.println("-----------------------------------------------------------------------------------------------------------------------");
        }
        IJavaElementDelta deltaToNotify = customDelta == null ? this.mergeDeltas(this.javaModelDeltas) : customDelta;
        IElementChangedListener[] listeners = this.elementChangedListeners;
        int[] listenerMask = this.elementChangedListenerMasks;
        int listenerCount = this.elementChangedListenerCount;
        switch (eventType) {
            case 0: {
                this.firePreAutoBuildDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
                break;
            }
            case 2: {
                this.firePreAutoBuildDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                break;
            }
            case 1: {
                this.firePostChangeDelta(deltaToNotify, listeners, listenerMask, listenerCount);
                this.fireReconcileDelta(listeners, listenerMask, listenerCount);
            }
        }
    }

    private void firePreAutoBuildDelta(IJavaElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DeltaProcessor.VERBOSE) {
            System.out.println("FIRING PRE_AUTO_BUILD Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.notifyListeners(deltaToNotify, 2, listeners, listenerMask, listenerCount);
        }
    }

    private void firePostChangeDelta(IJavaElementDelta deltaToNotify, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        if (DeltaProcessor.VERBOSE) {
            System.out.println("FIRING POST_CHANGE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.flush();
            this.notifyListeners(deltaToNotify, 1, listeners, listenerMask, listenerCount);
        }
    }

    private void fireReconcileDelta(IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        IJavaElementDelta deltaToNotify = this.mergeDeltas(this.reconcileDeltas.values());
        if (DeltaProcessor.VERBOSE) {
            System.out.println("FIRING POST_RECONCILE Delta [" + Thread.currentThread() + "]:");
            System.out.println(deltaToNotify == null ? "<NONE>" : deltaToNotify.toString());
        }
        if (deltaToNotify != null) {
            this.reconcileDeltas = new HashMap();
            this.notifyListeners(deltaToNotify, 4, listeners, listenerMask, listenerCount);
        }
    }

    public void notifyListeners(IJavaElementDelta deltaToNotify, int eventType, IElementChangedListener[] listeners, int[] listenerMask, int listenerCount) {
        final ElementChangedEvent extraEvent = new ElementChangedEvent(deltaToNotify, eventType);
        int i = 0;
        while (i < listenerCount) {
            if ((listenerMask[i] & eventType) != 0) {
                final IElementChangedListener listener = listeners[i];
                long start = -1L;
                if (DeltaProcessor.VERBOSE) {
                    System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                    start = System.currentTimeMillis();
                }
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        Util.log(exception, "Exception occurred in listener of Java element change notification");
                    }

                    public void run() throws Exception {
                        listener.elementChanged(extraEvent);
                    }
                });
                if (DeltaProcessor.VERBOSE) {
                    System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            ++i;
        }
    }

    protected void flush() {
        this.javaModelDeltas = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushZipFiles() {
        HashMap hashMap = this.zipFiles;
        synchronized (hashMap) {
            Thread currentThread = Thread.currentThread();
            HashMap map = (HashMap)this.zipFiles.remove(currentThread);
            if (map == null) {
                return;
            }
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                try {
                    ZipFile zipFile = (ZipFile)iterator.next();
                    if (ZIP_ACCESS_VERBOSE) {
                        System.out.println("(" + currentThread + ") [JavaModelManager.flushZipFiles()] Closing ZipFile on " + zipFile.getName());
                    }
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public DeltaProcessor getDeltaProcessor() {
        return this.deltaState.getDeltaProcessor();
    }

    protected Map getElementsOutOfSynchWithBuffers() {
        return this.elementsOutOfSynchWithBuffers;
    }

    public IJavaElement getHandleFromMemento(String memento) throws JavaModelException {
        if (memento == null) {
            return null;
        }
        JavaModel model = this.getJavaModel();
        if (memento.equals("")) {
            return model;
        }
        int modelEnd = memento.indexOf(61);
        if (modelEnd == -1) {
            return null;
        }
        boolean returnProject = false;
        int projectEnd = memento.indexOf(47, modelEnd);
        if (projectEnd == -1) {
            projectEnd = memento.length();
            returnProject = true;
        }
        String projectName = memento.substring(modelEnd + 1, projectEnd);
        JavaProject proj = (JavaProject)model.getJavaProject(projectName);
        if (returnProject) {
            return proj;
        }
        memento.indexOf(60, projectEnd + 1);
        return null;
    }

    public Object getInfo(IJavaElement element) {
        return this.cache.getInfo(element);
    }

    public final JavaModel getJavaModel() {
        return this.javaModel;
    }

    public static final JavaModelManager getJavaModelManager() {
        return Manager;
    }

    public Object getLastBuiltState(IProject project, IProgressMonitor monitor) {
        if (!JavaProject.hasJavaNature(project)) {
            return null;
        }
        PerProjectInfo info = this.getPerProjectInfo(project, true);
        if (!info.triedRead) {
            info.triedRead = true;
            try {
                if (monitor != null) {
                    monitor.subTask(Util.bind("build.readStateProgress", project.getName()));
                }
                info.savedState = this.readState(project);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return info.savedState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerProjectInfo getPerProjectInfo(IProject project, boolean create) {
        Map map = this.perProjectInfo;
        synchronized (map) {
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfo.get(project);
            if (info == null && create) {
                info = new PerProjectInfo(project);
                this.perProjectInfo.put(project, info);
            }
            return info;
        }
    }

    public PerProjectInfo getPerProjectInfoCheckExistence(IProject project) throws JavaModelException {
        PerProjectInfo info = this.getPerProjectInfo(project, false);
        if (info == null) {
            if (!JavaProject.hasJavaNature(project)) {
                throw ((JavaProject)JavaCore.create(project)).newNotPresentException();
            }
            info = this.getPerProjectInfo(project, true);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PerWorkingCopyInfo getPerWorkingCopyInfo(CompilationUnit workingCopy, boolean create, boolean recordUsage, IProblemRequestor problemRequestor) {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            PerWorkingCopyInfo info;
            WorkingCopyOwner owner = workingCopy.owner;
            HashMap<CompilationUnit, PerWorkingCopyInfo> workingCopyToInfos = (HashMap<CompilationUnit, PerWorkingCopyInfo>)this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null && create) {
                workingCopyToInfos = new HashMap<CompilationUnit, PerWorkingCopyInfo>();
                this.perWorkingCopyInfos.put(owner, workingCopyToInfos);
            }
            PerWorkingCopyInfo perWorkingCopyInfo = info = workingCopyToInfos == null ? null : (PerWorkingCopyInfo)workingCopyToInfos.get(workingCopy);
            if (info == null && create) {
                info = new PerWorkingCopyInfo(workingCopy, problemRequestor);
                workingCopyToInfos.put(workingCopy, info);
            }
            if (info != null && recordUsage) {
                ++info.useCount;
            }
            return info;
        }
    }

    public static String[] getRegisteredVariableNames() {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        ArrayList variableList = new ArrayList(5);
        String[] variableNames = new String[variableList.size()];
        variableList.toArray(variableNames);
        return variableNames;
    }

    private File getSerializationFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("net.sourceforge.phpeclipse");
        return workingLocation.append("state.dat").toFile();
    }

    public HashMap getTemporaryCache() {
        HashMap result = (HashMap)this.temporaryCache.get();
        if (result == null) {
            result = new HashMap();
            this.temporaryCache.set(result);
        }
        return result;
    }

    public ZipFile getZipFile(IPath path) throws CoreException {
        HashMap hashMap = this.zipFiles;
        synchronized (hashMap) {
            IPath location;
            ZipFile zipFile;
            Thread currentThread = Thread.currentThread();
            HashMap map = null;
            map = (HashMap)this.zipFiles.get(currentThread);
            if (map != null && (zipFile = (ZipFile)map.get(path)) != null) {
                return zipFile;
            }
            String fileSystemPath = null;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IResource file = root.findMember(path);
            if (path.isAbsolute() && file != null) {
                if (file == null) {
                    fileSystemPath = path.toOSString();
                } else {
                    if (file.getType() != 1 || (location = file.getFullPath()) == null) {
                        throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", -1, Util.bind("file.notFound", path.toString()), null));
                    }
                    fileSystemPath = location.toOSString();
                }
            } else if (!path.isAbsolute()) {
                file = root.getFile(path);
                if (file == null || file.getType() != 1) {
                    throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", -1, Util.bind("file.notFound", path.toString()), null));
                }
                location = file.getFullPath();
                if (location == null) {
                    throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", -1, Util.bind("file.notFound", path.toString()), null));
                }
                fileSystemPath = location.toOSString();
            } else {
                fileSystemPath = path.toOSString();
            }
            try {
                if (ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + currentThread + ") [JavaModelManager.getZipFile(IPath)] Creating ZipFile on " + fileSystemPath);
                }
                zipFile = new ZipFile(fileSystemPath);
                if (map != null) {
                    map.put(path, zipFile);
                }
                return zipFile;
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", -1, Util.bind("status.IOException"), (Throwable)e));
            }
        }
    }

    public boolean hasTemporaryCache() {
        return this.temporaryCache.get() != null;
    }

    public IJavaElementDelta mergeDeltas(Collection deltas) {
        if (deltas.size() == 0) {
            return null;
        }
        if (deltas.size() == 1) {
            return (IJavaElementDelta)deltas.iterator().next();
        }
        if (DeltaProcessor.VERBOSE) {
            System.out.println("MERGING " + deltas.size() + " DELTAS [" + Thread.currentThread() + "]");
        }
        Iterator iterator = deltas.iterator();
        JavaModel javaModel = this.getJavaModel();
        JavaElementDelta rootDelta = new JavaElementDelta(javaModel);
        boolean insertedTree = false;
        while (iterator.hasNext()) {
            IJavaElement element;
            JavaElementDelta delta = (JavaElementDelta)iterator.next();
            if (DeltaProcessor.VERBOSE) {
                System.out.println(delta.toString());
            }
            if (((Object)javaModel).equals(element = delta.getElement())) {
                IJavaElementDelta[] children = delta.getAffectedChildren();
                int j = 0;
                while (j < children.length) {
                    JavaElementDelta projectDelta = (JavaElementDelta)children[j];
                    rootDelta.insertDeltaTree(projectDelta.getElement(), projectDelta);
                    insertedTree = true;
                    ++j;
                }
                IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
                if (resourceDeltas == null) continue;
                int i = 0;
                int length = resourceDeltas.length;
                while (i < length) {
                    rootDelta.addResourceDelta(resourceDeltas[i]);
                    insertedTree = true;
                    ++i;
                }
                continue;
            }
            rootDelta.insertDeltaTree(element, delta);
            insertedTree = true;
        }
        if (insertedTree) {
            return rootDelta;
        }
        return null;
    }

    protected Object peekAtInfo(IJavaElement element) {
        return this.cache.peekAtInfo(element);
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    protected void putInfo(IJavaElement element, Object info) {
        this.cache.putInfo(element, info);
    }

    protected synchronized void putInfos(IJavaElement openedElement, Map newElements) {
        Object existingInfo = this.cache.peekAtInfo(openedElement);
        if (openedElement instanceof IParent && existingInfo instanceof JavaElementInfo) {
            IJavaElement[] children = ((JavaElementInfo)existingInfo).getChildren();
            int i = 0;
            int size = children.length;
            while (i < size) {
                JavaElement child = (JavaElement)children[i];
                try {
                    child.close();
                }
                catch (JavaModelException javaModelException) {}
                ++i;
            }
        }
        Iterator iterator = newElements.keySet().iterator();
        while (iterator.hasNext()) {
            IJavaElement element = (IJavaElement)iterator.next();
            Object info = newElements.get(element);
            this.cache.putInfo(element, info);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object readState(IProject project) throws CoreException {
        File file = this.getSerializationFile(project);
        if (file == null) return null;
        if (!file.exists()) return null;
        try {
            DataInputStream in;
            block10: {
                State state;
                block9: {
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    try {
                        String pluginID = in.readUTF();
                        if (!pluginID.equals("net.sourceforge.phpeclipse")) {
                            throw new IOException(Util.bind("build.wrongFileFormat"));
                        }
                        String kind = in.readUTF();
                        if (!kind.equals("STATE")) {
                            throw new IOException(Util.bind("build.wrongFileFormat"));
                        }
                        if (in.readBoolean()) {
                            state = PHPBuilder.readState(project, in);
                            Object var6_8 = null;
                            break block9;
                        }
                        if (PHPBuilder.DEBUG) {
                            System.out.println("Saved state thinks last build failed for " + project.getName());
                        }
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        in.close();
                        throw throwable;
                    }
                }
                in.close();
                return state;
            }
            Object var6_10 = null;
            in.close();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", 2, "Error reading last build state for project " + project.getName(), (Throwable)e));
        }
    }

    protected void registerJavaModelDelta(IJavaElementDelta delta) {
        this.javaModelDeltas.add(delta);
    }

    public void removeElementChangedListener(IElementChangedListener listener) {
        int i = 0;
        while (i < this.elementChangedListenerCount) {
            if (this.elementChangedListeners[i].equals(listener)) {
                int length = this.elementChangedListeners.length;
                IElementChangedListener[] newListeners = new IElementChangedListener[length];
                System.arraycopy(this.elementChangedListeners, 0, newListeners, 0, i);
                int[] newMasks = new int[length];
                System.arraycopy(this.elementChangedListenerMasks, 0, newMasks, 0, i);
                int trailingLength = this.elementChangedListenerCount - i - 1;
                if (trailingLength > 0) {
                    System.arraycopy(this.elementChangedListeners, i + 1, newListeners, i, trailingLength);
                    System.arraycopy(this.elementChangedListenerMasks, i + 1, newMasks, i, trailingLength);
                }
                this.elementChangedListeners = newListeners;
                this.elementChangedListenerMasks = newMasks;
                --this.elementChangedListenerCount;
                return;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object removeInfoAndChildren(JavaElement element) throws JavaModelException {
        Object info = this.cache.peekAtInfo(element);
        if (info == null) {
            return null;
        }
        boolean wasVerbose = false;
        try {
            if (VERBOSE) {
                System.out.println("CLOSING Element (" + Thread.currentThread() + "): " + element.toStringWithAncestors());
                wasVerbose = true;
                VERBOSE = false;
            }
            element.closing(info);
            if (element instanceof IParent && info instanceof JavaElementInfo) {
                IJavaElement[] children = ((JavaElementInfo)info).getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    JavaElement child = (JavaElement)children[i];
                    child.close();
                    ++i;
                }
            }
            this.cache.removeInfo(element);
            if (wasVerbose) {
                System.out.println("-> Package cache size = " + this.cache.pkgSize());
                System.out.println("-> Openable cache filling ratio = " + NumberFormat.getInstance().format(this.cache.openableFillingRatio()) + "%");
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            VERBOSE = wasVerbose;
            throw throwable;
        }
        {
            Object var8_10 = null;
            VERBOSE = wasVerbose;
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerProjectInfo(JavaProject javaProject) {
        Map map = this.perProjectInfo;
        synchronized (map) {
            IProject project = javaProject.getProject();
            PerProjectInfo info = (PerProjectInfo)this.perProjectInfo.get(project);
            if (info != null) {
                this.perProjectInfo.remove(project);
            }
        }
    }

    public void resetTemporaryCache() {
        this.temporaryCache.set(null);
    }

    public void rollback(ISaveContext context) {
    }

    private void saveState(PerProjectInfo info, ISaveContext context) throws CoreException {
        if (context.getKind() == 2) {
            return;
        }
        if (info.triedRead) {
            this.saveBuiltState(info);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveBuiltState(PerProjectInfo info) throws CoreException {
        File file;
        if (PHPBuilder.DEBUG) {
            System.out.println(Util.bind("build.saveStateProgress", info.project.getName()));
        }
        if ((file = this.getSerializationFile(info.project)) == null) {
            return;
        }
        long t = System.currentTimeMillis();
        try {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                out.writeUTF("net.sourceforge.phpeclipse");
                out.writeUTF("STATE");
                if (info.savedState == null) {
                    out.writeBoolean(false);
                } else {
                    out.writeBoolean(true);
                    PHPBuilder.writeState(info.savedState, out);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                out.close();
                throw throwable;
            }
            {
                Object var6_9 = null;
                out.close();
            }
        }
        catch (RuntimeException e) {
            try {
                file.delete();
                throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", 2, Util.bind("build.cannotSaveState", info.project.getName()), (Throwable)e));
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", 2, Util.bind("build.cannotSaveState", info.project.getName()), (Throwable)e));
        }
        catch (IOException e) {
            try {
                file.delete();
                throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", 2, Util.bind("build.cannotSaveState", info.project.getName()), (Throwable)e));
            }
            catch (SecurityException securityException) {}
            throw new CoreException((IStatus)new Status(4, "net.sourceforge.phpeclipse", 2, Util.bind("build.cannotSaveState", info.project.getName()), (Throwable)e));
        }
        if (!PHPBuilder.DEBUG) return;
        t = System.currentTimeMillis() - t;
        System.out.println(Util.bind("build.saveStateComplete", String.valueOf(t)));
    }

    private synchronized Map containerClone(IJavaProject project) {
        Map originalProjectContainers = (Map)containers.get(project);
        if (originalProjectContainers == null) {
            return null;
        }
        HashMap projectContainers = new HashMap(originalProjectContainers.size());
        projectContainers.putAll(originalProjectContainers);
        return projectContainers;
    }

    public void saving(ISaveContext context) throws CoreException {
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        IJavaProject[] projects = this.getJavaModel().getJavaProjects();
        int i = 0;
        int length = projects.length;
        while (i < length) {
            IJavaProject project = projects[i];
            Map projectContainers = this.containerClone(project);
            if (projectContainers != null) {
                Iterator keys = projectContainers.keySet().iterator();
                while (keys.hasNext()) {
                    IPath containerPath = (IPath)keys.next();
                    String containerKey = CP_CONTAINER_PREFERENCES_PREFIX + project.getElementName() + "|" + containerPath;
                    String containerString = CP_ENTRY_IGNORE;
                    preferences.setDefault(containerKey, CP_ENTRY_IGNORE);
                    preferences.setValue(containerKey, containerString);
                }
            }
            ++i;
        }
        JavaCore.getPlugin().savePluginPreferences();
        IProject savedProject = context.getProject();
        if (savedProject != null) {
            if (!JavaProject.hasJavaNature(savedProject)) {
                return;
            }
            PerProjectInfo info = this.getPerProjectInfo(savedProject, true);
            this.saveState(info, context);
            return;
        }
        ArrayList<IStatus> vStats = null;
        Iterator iter = this.perProjectInfo.values().iterator();
        while (iter.hasNext()) {
            try {
                PerProjectInfo info = (PerProjectInfo)iter.next();
                this.saveState(info, context);
            }
            catch (CoreException e) {
                if (vStats == null) {
                    vStats = new ArrayList<IStatus>();
                }
                vStats.add(e.getStatus());
            }
        }
        if (vStats != null) {
            IStatus[] stats = new IStatus[vStats.size()];
            vStats.toArray(stats);
            throw new CoreException((IStatus)new MultiStatus("net.sourceforge.phpeclipse", 4, stats, Util.bind("build.cannotSaveStates"), null));
        }
    }

    protected void setBuildOrder(String[] javaBuildOrder) throws JavaModelException {
        String[] newOrder;
        if (!"compute".equals(JavaCore.getOption("net.sourceforge.phpeclipse.computeJavaBuildOrder"))) {
            return;
        }
        if (javaBuildOrder == null || javaBuildOrder.length <= 1) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription description = workspace.getDescription();
        String[] wksBuildOrder = description.getBuildOrder();
        if (wksBuildOrder == null) {
            newOrder = javaBuildOrder;
        } else {
            int javaCount = javaBuildOrder.length;
            HashMap<String, String> newSet = new HashMap<String, String>(javaCount);
            int i = 0;
            while (i < javaCount) {
                newSet.put(javaBuildOrder[i], javaBuildOrder[i]);
                ++i;
            }
            int removed = 0;
            int oldCount = wksBuildOrder.length;
            int i2 = 0;
            while (i2 < oldCount) {
                if (newSet.containsKey(wksBuildOrder[i2])) {
                    wksBuildOrder[i2] = null;
                    ++removed;
                }
                ++i2;
            }
            newOrder = new String[oldCount - removed + javaCount];
            System.arraycopy(javaBuildOrder, 0, newOrder, 0, javaCount);
            int index = javaCount;
            int i3 = 0;
            while (i3 < oldCount) {
                if (wksBuildOrder[i3] != null) {
                    newOrder[index++] = wksBuildOrder[i3];
                }
                ++i3;
            }
        }
        description.setBuildOrder(newOrder);
        try {
            workspace.setDescription(description);
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    public void setLastBuiltState(IProject project, Object state) {
        if (!JavaProject.hasJavaNature(project)) {
            return;
        }
        PerProjectInfo info = this.getPerProjectInfo(project, true);
        info.triedRead = true;
        info.savedState = state;
        if (state == null) {
            try {
                File file = this.getSerializationFile(project);
                if (file != null && file.exists()) {
                    file.delete();
                }
            }
            catch (SecurityException securityException) {}
        }
    }

    public void shutdown() {
        try {
            JavaModel model = this.getJavaModel();
            if (model != null) {
                model.close();
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public void startDeltas() {
        this.isFiring = true;
    }

    public void stopDeltas() {
        this.isFiring = false;
    }

    public void updateJavaModel(IJavaElementDelta customDelta) {
        if (customDelta == null) {
            int i = 0;
            int length = this.javaModelDeltas.size();
            while (i < length) {
                IJavaElementDelta delta = (IJavaElementDelta)this.javaModelDeltas.get(i);
                this.modelUpdater.processJavaDelta(delta);
                ++i;
            }
        } else {
            this.modelUpdater.processJavaDelta(customDelta);
        }
    }

    public static IPath variableGet(String variableName) {
        return (IPath)Variables.get(variableName);
    }

    public static String[] variableNames() {
        int length = Variables.size();
        String[] result = new String[length];
        Iterator vars = Variables.keySet().iterator();
        int index = 0;
        while (vars.hasNext()) {
            result[index++] = (String)vars.next();
        }
        return result;
    }

    public static void variablePut(String variableName, IPath variablePath) {
        if (variablePath == null) {
            Variables.remove(variableName);
            PreviousSessionVariables.remove(variableName);
        } else {
            Variables.put(variableName, variablePath);
        }
        if (variablePath == VariableInitializationInProgress) {
            return;
        }
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        String variableKey = CP_VARIABLE_PREFERENCES_PREFIX + variableName;
        String variableString = variablePath == null ? CP_ENTRY_IGNORE : variablePath.toString();
        preferences.setDefault(variableKey, CP_ENTRY_IGNORE);
        preferences.setValue(variableKey, variableString);
        JavaCore.getPlugin().savePluginPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompilationUnit[] getWorkingCopies(WorkingCopyOwner owner, boolean addPrimary) {
        Map map = this.perWorkingCopyInfos;
        synchronized (map) {
            ICompilationUnit[] primaryWCs = addPrimary && owner != DefaultWorkingCopyOwner.PRIMARY ? this.getWorkingCopies(DefaultWorkingCopyOwner.PRIMARY, false) : null;
            Map workingCopyToInfos = (Map)this.perWorkingCopyInfos.get(owner);
            if (workingCopyToInfos == null) {
                return primaryWCs;
            }
            int primaryLength = primaryWCs == null ? 0 : primaryWCs.length;
            int size = workingCopyToInfos.size();
            ICompilationUnit[] result = new ICompilationUnit[primaryLength + size];
            if (primaryWCs != null) {
                System.arraycopy(primaryWCs, 0, result, 0, primaryLength);
            }
            Iterator iterator = workingCopyToInfos.values().iterator();
            int index = primaryLength;
            while (iterator.hasNext()) {
                result[index++] = ((PerWorkingCopyInfo)iterator.next()).getWorkingCopy();
            }
            return result;
        }
    }

    private HashSet getClasspathBeingResolved() {
        HashSet result = (HashSet)this.classpathsBeingResolved.get();
        if (result == null) {
            result = new HashSet();
            this.classpathsBeingResolved.set(result);
        }
        return result;
    }

    public boolean isClasspathBeingResolved(IJavaProject project) {
        return this.getClasspathBeingResolved().contains(project);
    }

    public void setClasspathBeingResolved(IJavaProject project, boolean classpathIsResolved) {
        if (classpathIsResolved) {
            this.getClasspathBeingResolved().add(project);
        } else {
            this.getClasspathBeingResolved().remove(project);
        }
    }

    public static class PerProjectInfo {
        public IProject project;
        public Object savedState = null;
        public boolean triedRead = false;
        public IClasspathEntry[] rawClasspath;
        public IClasspathEntry[] resolvedClasspath;
        public Map resolvedPathToRawEntries;
        public IPath outputLocation;
        public Preferences preferences;

        public PerProjectInfo(IProject project) {
            this.project = project;
        }

        public synchronized void updateClasspathInformation(IClasspathEntry[] newRawClasspath) {
            this.rawClasspath = newRawClasspath;
            this.resolvedClasspath = null;
            this.resolvedPathToRawEntries = null;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(this.project.getFullPath());
            buffer.append("\nRaw classpath:\n");
            if (this.rawClasspath == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = this.rawClasspath.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(this.rawClasspath[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append("Resolved classpath:\n");
            IClasspathEntry[] resolvedCP = this.resolvedClasspath;
            if (resolvedCP == null) {
                buffer.append("  <null>\n");
            } else {
                int i = 0;
                int length = resolvedCP.length;
                while (i < length) {
                    buffer.append("  ");
                    buffer.append(resolvedCP[i]);
                    buffer.append('\n');
                    ++i;
                }
            }
            buffer.append("Output location:\n  ");
            if (this.outputLocation == null) {
                buffer.append("<null>");
            } else {
                buffer.append(this.outputLocation);
            }
            return buffer.toString();
        }
    }

    public static class PerWorkingCopyInfo
    implements IProblemRequestor {
        int useCount = 0;
        IProblemRequestor problemRequestor;
        ICompilationUnit workingCopy;

        public PerWorkingCopyInfo(ICompilationUnit workingCopy, IProblemRequestor problemRequestor) {
            this.workingCopy = workingCopy;
            this.problemRequestor = problemRequestor;
        }

        public void acceptProblem(IProblem problem) {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.acceptProblem(problem);
        }

        public void beginReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.beginReporting();
        }

        public void endReporting() {
            if (this.problemRequestor == null) {
                return;
            }
            this.problemRequestor.endReporting();
        }

        public ICompilationUnit getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isActive() {
            return this.problemRequestor != null && this.problemRequestor.isActive();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Info for ");
            buffer.append(((JavaElement)((Object)this.workingCopy)).toStringWithAncestors());
            buffer.append("\nUse count = ");
            buffer.append(this.useCount);
            buffer.append("\nProblem requestor:\n  ");
            buffer.append(this.problemRequestor);
            return buffer.toString();
        }
    }

    public static class PluginPreferencesListener
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
        }
    }
}

