/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.core.CompilationUnit;
import net.sourceforge.phpdt.internal.core.JavaElementDelta;
import net.sourceforge.phpdt.internal.core.JavaModelManager;
import net.sourceforge.phpdt.internal.core.JavaModelOperation;

public class DiscardWorkingCopyOperation
extends JavaModelOperation {
    public DiscardWorkingCopyOperation(IJavaElement workingCopy) {
        super(new IJavaElement[]{workingCopy});
    }

    protected void executeOperation() throws JavaModelException {
        CompilationUnit workingCopy = this.getWorkingCopy();
        int useCount = JavaModelManager.getJavaModelManager().discardPerWorkingCopyInfo(workingCopy);
        if (useCount == 0) {
            if (!workingCopy.isPrimary()) {
                JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                delta.removed(workingCopy);
                this.addDelta(delta);
                this.removeReconcileDelta(workingCopy);
            } else if (workingCopy.getResource().isAccessible()) {
                JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                delta.changed(workingCopy, 65536);
                this.addDelta(delta);
            } else {
                JavaElementDelta delta = new JavaElementDelta(this.getJavaModel());
                delta.removed(workingCopy, 65536);
                this.addDelta(delta);
            }
        }
    }

    protected CompilationUnit getWorkingCopy() {
        return (CompilationUnit)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

