/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.Compiler;
import net.sourceforge.phpdt.internal.compiler.env.IConstants;
import net.sourceforge.phpdt.internal.compiler.lookup.ProblemReasons;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemSeverities;

public class CompilerOptions
implements ProblemReasons,
ProblemSeverities,
IConstants {
    public static final String OPTION_PHPVarDeprecatedWarning = "net.sourceforge.phpeclipse.compiler.problem.phpVarDeprecatedWarning";
    public static final String OPTION_PHPBadStyleKeywordWarning = "net.sourceforge.phpeclipse.compiler.problem.phpBadStyleKeywordWarning";
    public static final String OPTION_PHPBadStyleUppercaseIdentifierWarning = "net.sourceforge.phpeclipse.compiler.problem.phpBadStyleUppercaseIdentifierWarning";
    public static final String OPTION_PHPIncludeNotExistWarning = "net.sourceforge.phpeclipse.compiler.problem.phpIncludeNotExistWarning";
    public static final String OPTION_UninitializedLocalVariableWarning = "net.sourceforge.phpeclipse.compiler.problem.uninitializedLocalVariableWarning";
    public static final String OPTION_CodeCannotBeReachedWarning = "net.sourceforge.phpeclipse.compiler.problem.codeCannotBeReachedWarning";
    public static final String OPTION_LocalVariableAttribute = "net.sourceforge.phpeclipse.compiler.debug.localVariable";
    public static final String OPTION_LineNumberAttribute = "net.sourceforge.phpeclipse.compiler.debug.lineNumber";
    public static final String OPTION_SourceFileAttribute = "net.sourceforge.phpeclipse.compiler.debug.sourceFile";
    public static final String OPTION_DocCommentSupport = "net.sourceforge.phpeclipse.compiler.doc.comment.support";
    public static final String OPTION_ReportMethodWithConstructorName = "net.sourceforge.phpeclipse.compiler.problem.methodWithConstructorName";
    public static final String OPTION_ReportOverridingPackageDefaultMethod = "net.sourceforge.phpeclipse.compiler.problem.overridingPackageDefaultMethod";
    public static final String OPTION_ReportDeprecation = "net.sourceforge.phpeclipse.compiler.problem.deprecation";
    public static final String OPTION_ReportDeprecationInDeprecatedCode = "net.sourceforge.phpeclipse.compiler.problem.deprecationInDeprecatedCode";
    public static final String OPTION_ReportDeprecationWhenOverridingDeprecatedMethod = "net.sourceforge.phpeclipse.compiler.problem.deprecationWhenOverridingDeprecatedMethod";
    public static final String OPTION_ReportHiddenCatchBlock = "net.sourceforge.phpeclipse.compiler.problem.hiddenCatchBlock";
    public static final String OPTION_ReportUnusedLocal = "net.sourceforge.phpeclipse.compiler.problem.unusedLocal";
    public static final String OPTION_ReportUnusedParameter = "net.sourceforge.phpeclipse.compiler.problem.unusedParameter";
    public static final String OPTION_ReportUnusedParameterWhenImplementingAbstract = "net.sourceforge.phpeclipse.compiler.problem.unusedParameterWhenImplementingAbstract";
    public static final String OPTION_ReportUnusedParameterWhenOverridingConcrete = "net.sourceforge.phpeclipse.compiler.problem.unusedParameterWhenOverridingConcrete";
    public static final String OPTION_ReportUnusedImport = "net.sourceforge.phpeclipse.compiler.problem.unusedImport";
    public static final String OPTION_ReportSyntheticAccessEmulation = "net.sourceforge.phpeclipse.compiler.problem.syntheticAccessEmulation";
    public static final String OPTION_ReportNoEffectAssignment = "net.sourceforge.phpeclipse.compiler.problem.noEffectAssignment";
    public static final String OPTION_ReportLocalVariableHiding = "net.sourceforge.phpeclipse.compiler.problem.localVariableHiding";
    public static final String OPTION_ReportSpecialParameterHidingField = "net.sourceforge.phpeclipse.compiler.problem.specialParameterHidingField";
    public static final String OPTION_ReportFieldHiding = "net.sourceforge.phpeclipse.compiler.problem.fieldHiding";
    public static final String OPTION_ReportPossibleAccidentalBooleanAssignment = "net.sourceforge.phpeclipse.compiler.problem.possibleAccidentalBooleanAssignment";
    public static final String OPTION_ReportNonExternalizedStringLiteral = "net.sourceforge.phpeclipse.compiler.problem.nonExternalizedStringLiteral";
    public static final String OPTION_ReportIncompatibleNonInheritedInterfaceMethod = "net.sourceforge.phpeclipse.compiler.problem.incompatibleNonInheritedInterfaceMethod";
    public static final String OPTION_ReportUnusedPrivateMember = "net.sourceforge.phpeclipse.compiler.problem.unusedPrivateMember";
    public static final String OPTION_ReportNoImplicitStringConversion = "net.sourceforge.phpeclipse.compiler.problem.noImplicitStringConversion";
    public static final String OPTION_ReportAssertIdentifier = "net.sourceforge.phpeclipse.compiler.problem.assertIdentifier";
    public static final String OPTION_ReportNonStaticAccessToStatic = "net.sourceforge.phpeclipse.compiler.problem.staticAccessReceiver";
    public static final String OPTION_ReportIndirectStaticAccess = "net.sourceforge.phpeclipse.compiler.problem.indirectStaticAccess";
    public static final String OPTION_ReportSuperfluousSemicolon = "net.sourceforge.phpeclipse.compiler.problem.superfluousSemicolon";
    public static final String OPTION_ReportUnnecessaryTypeCheck = "net.sourceforge.phpeclipse.compiler.problem.unnecessaryTypeCheck";
    public static final String OPTION_ReportUndocumentedEmptyBlock = "net.sourceforge.phpeclipse.compiler.problem.undocumentedEmptyBlock";
    public static final String OPTION_ReportInvalidJavadoc = "net.sourceforge.phpeclipse.compiler.problem.invalidJavadoc";
    public static final String OPTION_ReportInvalidJavadocTags = "net.sourceforge.phpeclipse.compiler.problem.invalidJavadocTags";
    public static final String OPTION_ReportInvalidJavadocTagsVisibility = "net.sourceforge.phpeclipse.compiler.problem.invalidJavadocTagsVisibility";
    public static final String OPTION_ReportMissingJavadocTags = "net.sourceforge.phpeclipse.compiler.problem.missingJavadocTags";
    public static final String OPTION_ReportMissingJavadocTagsVisibility = "net.sourceforge.phpeclipse.compiler.problem.missingJavadocTagsVisibility";
    public static final String OPTION_ReportMissingJavadocTagsOverriding = "net.sourceforge.phpeclipse.compiler.problem.missingJavadocTagsOverriding";
    public static final String OPTION_ReportMissingJavadocComments = "net.sourceforge.phpeclipse.compiler.problem.missingJavadocComments";
    public static final String OPTION_ReportMissingJavadocCommentsVisibility = "net.sourceforge.phpeclipse.compiler.problem.missingJavadocCommentsVisibility";
    public static final String OPTION_ReportMissingJavadocCommentsOverriding = "net.sourceforge.phpeclipse.compiler.problem.missingJavadocCommentsOverriding";
    public static final String OPTION_ReportFinallyBlockNotCompletingNormally = "net.sourceforge.phpeclipse.compiler.problem.finallyBlockNotCompletingNormally";
    public static final String OPTION_ReportUnusedDeclaredThrownException = "net.sourceforge.phpeclipse.compiler.problem.unusedDeclaredThrownException";
    public static final String OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding = "net.sourceforge.phpeclipse.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding";
    public static final String OPTION_ReportUnqualifiedFieldAccess = "net.sourceforge.phpeclipse.compiler.problem.unqualifiedFieldAccess";
    public static final String OPTION_Encoding = "net.sourceforge.phpeclipse.encoding";
    public static final String OPTION_MaxProblemPerUnit = "net.sourceforge.phpeclipse.compiler.maxProblemPerUnit";
    public static final String OPTION_TaskTags = "net.sourceforge.phpeclipse.compiler.taskTags";
    public static final String OPTION_TaskPriorities = "net.sourceforge.phpeclipse.compiler.taskPriorities";
    public static final String OPTION_ReportInvalidAnnotation = "net.sourceforge.phpeclipse.compiler.problem.invalidAnnotation";
    public static final String OPTION_ReportMissingAnnotation = "net.sourceforge.phpeclipse.compiler.problem.missingAnnotation";
    public static final String OPTION_ReportMissingJavadoc = "net.sourceforge.phpeclipse.compiler.problem.missingJavadoc";
    public static final String GENERATE = "generate";
    public static final String DO_NOT_GENERATE = "do not generate";
    public static final String PRESERVE = "preserve";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String PUBLIC = "public";
    public static final String PROTECTED = "protected";
    public static final String DEFAULT = "default";
    public static final String PRIVATE = "private";
    public static final long MethodWithConstructorName = 4096L;
    public static final long OverriddenPackageDefaultMethod = 8192L;
    public static final long UsingDeprecatedAPI = 16384L;
    public static final long MaskedCatchBlock = 32768L;
    public static final long UnusedLocalVariable = 65536L;
    public static final long UnusedArgument = 131072L;
    public static final long NoImplicitStringConversion = 262144L;
    public static final long AccessEmulation = 524288L;
    public static final long NonExternalizedString = 0x100000L;
    public static final long AssertUsedAsAnIdentifier = 0x200000L;
    public static final long UnusedImport = 0x400000L;
    public static final long NonStaticAccessToStatic = 0x800000L;
    public static final long Task = 0x1000000L;
    public static final long NoEffectAssignment = 0x2000000L;
    public static final long IncompatibleNonInheritedInterfaceMethod = 0x4000000L;
    public static final long UnusedPrivateMember = 0x8000000L;
    public static final long LocalVariableHiding = 0x10000000L;
    public static final long FieldHiding = 0x20000000L;
    public static final long AccidentalBooleanAssign = 0x40000000L;
    public static final long SuperfluousSemicolon = 0x80000000L;
    public static final long IndirectStaticAccess = 0x100000000L;
    public static final long UndocumentedEmptyBlock = 0x200000000L;
    public static final long UnnecessaryTypeCheck = 0x400000000L;
    public static final long InvalidJavadoc = 0x800000000L;
    public static final long FinallyBlockNotCompleting = 0x1000000000L;
    public static final long UnusedDeclaredThrownException = 0x2000000000L;
    public static final long UnqualifiedFieldAccess = 0x4000000000L;
    public static final long MissingJavadocTags = 0x8000000000L;
    public static final long MissingJavadocComments = 0x10000000000L;
    public static final long PHPVarDeprecatedWarning = 0x20000000000L;
    public static final long PHPBadStyleKeywordWarning = 0x40000000000L;
    public static final long PHPBadStyleUppercaseIdentifierWarning = 0x80000000000L;
    public static final long PHPIncludeNotExistWarning = 0x100000000000L;
    public static final long UninitializedLocalVariableWarning = 0x200000000000L;
    public static final long CodeCannotBeReachedWarning = 0x400000000000L;
    public long errorThreshold = 0L;
    public long warningThreshold = 138607300243456L;
    public static final int Source = 1;
    public static final int Lines = 2;
    public static final int Vars = 4;
    public int produceDebugAttributes = 3;
    public boolean isPrivateConstructorAccessChangingVisibility = false;
    public String defaultEncoding = null;
    public boolean verbose = Compiler.DEBUG;
    public boolean produceReferenceInfo = false;
    public boolean preserveAllLocalVariables = false;
    public boolean parseLiteralExpressionsAsConstants = true;
    public int maxProblemsPerUnit = 100;
    public char[][] taskTags = null;
    public char[][] taskPriorites = null;
    public boolean reportDeprecationInsideDeprecatedCode = false;
    public boolean reportDeprecationWhenOverridingDeprecatedMethod = false;
    public boolean reportUnusedParameterWhenImplementingAbstract = false;
    public boolean reportUnusedParameterWhenOverridingConcrete = false;
    public boolean reportUnusedDeclaredThrownExceptionWhenOverriding = false;
    public boolean reportSpecialParameterHidingField = false;
    public int reportInvalidJavadocTagsVisibility = 2;
    public boolean reportInvalidJavadocTags = true;
    public int reportMissingJavadocTagsVisibility = 2;
    public boolean reportMissingJavadocTagsOverriding = true;
    public int reportMissingJavadocCommentsVisibility = 1;
    public boolean reportMissingJavadocCommentsOverriding = true;
    public boolean docCommentSupport = false;

    public CompilerOptions() {
    }

    public CompilerOptions(Map settings) {
        if (settings == null) {
            return;
        }
        this.set(settings);
    }

    public Map getMap() {
        HashMap<String, String> optionsMap = new HashMap<String, String>(30);
        optionsMap.put(OPTION_PHPIncludeNotExistWarning, this.getSeverityString(0x100000000000L));
        optionsMap.put(OPTION_PHPVarDeprecatedWarning, this.getSeverityString(0x20000000000L));
        optionsMap.put(OPTION_PHPBadStyleKeywordWarning, this.getSeverityString(0x40000000000L));
        optionsMap.put(OPTION_PHPBadStyleUppercaseIdentifierWarning, this.getSeverityString(0x80000000000L));
        optionsMap.put(OPTION_UninitializedLocalVariableWarning, this.getSeverityString(0x200000000000L));
        optionsMap.put(OPTION_CodeCannotBeReachedWarning, this.getSeverityString(0x400000000000L));
        optionsMap.put(OPTION_LocalVariableAttribute, (this.produceDebugAttributes & 4) != 0 ? GENERATE : DO_NOT_GENERATE);
        optionsMap.put(OPTION_LineNumberAttribute, (this.produceDebugAttributes & 2) != 0 ? GENERATE : DO_NOT_GENERATE);
        optionsMap.put(OPTION_SourceFileAttribute, (this.produceDebugAttributes & 1) != 0 ? GENERATE : DO_NOT_GENERATE);
        optionsMap.put(OPTION_DocCommentSupport, this.docCommentSupport ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportMethodWithConstructorName, this.getSeverityString(4096L));
        optionsMap.put(OPTION_ReportOverridingPackageDefaultMethod, this.getSeverityString(8192L));
        optionsMap.put(OPTION_ReportDeprecation, this.getSeverityString(16384L));
        optionsMap.put(OPTION_ReportDeprecationInDeprecatedCode, this.reportDeprecationInsideDeprecatedCode ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportDeprecationWhenOverridingDeprecatedMethod, this.reportDeprecationWhenOverridingDeprecatedMethod ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportHiddenCatchBlock, this.getSeverityString(32768L));
        optionsMap.put(OPTION_ReportUnusedLocal, this.getSeverityString(65536L));
        optionsMap.put(OPTION_ReportUnusedParameter, this.getSeverityString(131072L));
        optionsMap.put(OPTION_ReportUnusedImport, this.getSeverityString(0x400000L));
        optionsMap.put(OPTION_ReportSyntheticAccessEmulation, this.getSeverityString(524288L));
        optionsMap.put(OPTION_ReportNoEffectAssignment, this.getSeverityString(0x2000000L));
        optionsMap.put(OPTION_ReportNonExternalizedStringLiteral, this.getSeverityString(0x100000L));
        optionsMap.put(OPTION_ReportNoImplicitStringConversion, this.getSeverityString(262144L));
        optionsMap.put(OPTION_ReportNonStaticAccessToStatic, this.getSeverityString(0x800000L));
        optionsMap.put(OPTION_ReportIndirectStaticAccess, this.getSeverityString(0x100000000L));
        optionsMap.put(OPTION_ReportIncompatibleNonInheritedInterfaceMethod, this.getSeverityString(0x4000000L));
        optionsMap.put(OPTION_ReportUnusedPrivateMember, this.getSeverityString(0x8000000L));
        optionsMap.put(OPTION_ReportLocalVariableHiding, this.getSeverityString(0x10000000L));
        optionsMap.put(OPTION_ReportFieldHiding, this.getSeverityString(0x20000000L));
        optionsMap.put(OPTION_ReportPossibleAccidentalBooleanAssignment, this.getSeverityString(0x40000000L));
        optionsMap.put(OPTION_ReportSuperfluousSemicolon, this.getSeverityString(0x80000000L));
        optionsMap.put(OPTION_ReportAssertIdentifier, this.getSeverityString(0x200000L));
        optionsMap.put(OPTION_ReportUndocumentedEmptyBlock, this.getSeverityString(0x200000000L));
        optionsMap.put(OPTION_ReportUnnecessaryTypeCheck, this.getSeverityString(0x400000000L));
        optionsMap.put(OPTION_ReportInvalidJavadoc, this.getSeverityString(0x800000000L));
        optionsMap.put(OPTION_ReportInvalidJavadocTagsVisibility, this.getVisibilityString(this.reportInvalidJavadocTagsVisibility));
        optionsMap.put(OPTION_ReportInvalidJavadocTags, this.reportInvalidJavadocTags ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportMissingJavadocTags, this.getSeverityString(0x8000000000L));
        optionsMap.put(OPTION_ReportMissingJavadocTagsVisibility, this.getVisibilityString(this.reportMissingJavadocTagsVisibility));
        optionsMap.put(OPTION_ReportMissingJavadocTagsOverriding, this.reportMissingJavadocTagsOverriding ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportMissingJavadocComments, this.getSeverityString(0x10000000000L));
        optionsMap.put(OPTION_ReportMissingJavadocCommentsVisibility, this.getVisibilityString(this.reportMissingJavadocCommentsVisibility));
        optionsMap.put(OPTION_ReportMissingJavadocCommentsOverriding, this.reportMissingJavadocCommentsOverriding ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportFinallyBlockNotCompletingNormally, this.getSeverityString(0x1000000000L));
        optionsMap.put(OPTION_ReportUnusedDeclaredThrownException, this.getSeverityString(0x2000000000L));
        optionsMap.put(OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding, this.reportUnusedDeclaredThrownExceptionWhenOverriding ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportUnqualifiedFieldAccess, this.getSeverityString(0x4000000000L));
        if (this.defaultEncoding != null) {
            optionsMap.put(OPTION_Encoding, this.defaultEncoding);
        }
        optionsMap.put(OPTION_TaskTags, this.taskTags == null ? "" : new String(CharOperation.concatWith(this.taskTags, ',')));
        optionsMap.put(OPTION_TaskPriorities, this.taskPriorites == null ? "" : new String(CharOperation.concatWith(this.taskPriorites, ',')));
        optionsMap.put(OPTION_ReportUnusedParameterWhenImplementingAbstract, this.reportUnusedParameterWhenImplementingAbstract ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportUnusedParameterWhenOverridingConcrete, this.reportUnusedParameterWhenOverridingConcrete ? ENABLED : DISABLED);
        optionsMap.put(OPTION_ReportSpecialParameterHidingField, this.reportSpecialParameterHidingField ? ENABLED : DISABLED);
        optionsMap.put(OPTION_MaxProblemPerUnit, String.valueOf(this.maxProblemsPerUnit));
        return optionsMap;
    }

    public int getSeverity(long irritant) {
        if ((this.warningThreshold & irritant) != 0L) {
            return 0;
        }
        if ((this.errorThreshold & irritant) != 0L) {
            return 1;
        }
        return -1;
    }

    public String getSeverityString(long irritant) {
        if ((this.warningThreshold & irritant) != 0L) {
            return WARNING;
        }
        if ((this.errorThreshold & irritant) != 0L) {
            return ERROR;
        }
        return IGNORE;
    }

    public String getVisibilityString(int level) {
        switch (level) {
            case 1: {
                return PUBLIC;
            }
            case 4: {
                return PROTECTED;
            }
            case 2: {
                return PRIVATE;
            }
        }
        return DEFAULT;
    }

    public void set(Map optionsMap) {
        String stringValue;
        Object optionValue = optionsMap.get(OPTION_LocalVariableAttribute);
        if (optionValue != null) {
            if (GENERATE.equals(optionValue)) {
                this.produceDebugAttributes |= 4;
            } else if (DO_NOT_GENERATE.equals(optionValue)) {
                this.produceDebugAttributes &= 0xFFFFFFFB;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_LineNumberAttribute)) != null) {
            if (GENERATE.equals(optionValue)) {
                this.produceDebugAttributes |= 2;
            } else if (DO_NOT_GENERATE.equals(optionValue)) {
                this.produceDebugAttributes &= 0xFFFFFFFD;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_SourceFileAttribute)) != null) {
            if (GENERATE.equals(optionValue)) {
                this.produceDebugAttributes |= 1;
            } else if (DO_NOT_GENERATE.equals(optionValue)) {
                this.produceDebugAttributes &= 0xFFFFFFFE;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportDeprecationInDeprecatedCode)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportDeprecationInsideDeprecatedCode = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportDeprecationInsideDeprecatedCode = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportDeprecationWhenOverridingDeprecatedMethod)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportDeprecationWhenOverridingDeprecatedMethod = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportDeprecationWhenOverridingDeprecatedMethod = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedDeclaredThrownExceptionWhenOverriding)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionWhenOverriding = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportUnusedDeclaredThrownExceptionWhenOverriding = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_Encoding)) != null && optionValue instanceof String) {
            this.defaultEncoding = null;
            stringValue = (String)optionValue;
            if (stringValue.length() > 0) {
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), stringValue);
                    this.defaultEncoding = stringValue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedParameterWhenImplementingAbstract)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportUnusedParameterWhenImplementingAbstract = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportUnusedParameterWhenImplementingAbstract = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedParameterWhenOverridingConcrete)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportUnusedParameterWhenOverridingConcrete = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportUnusedParameterWhenOverridingConcrete = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportSpecialParameterHidingField)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportSpecialParameterHidingField = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportSpecialParameterHidingField = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_MaxProblemPerUnit)) != null && optionValue instanceof String) {
            stringValue = (String)optionValue;
            try {
                int val = Integer.parseInt(stringValue);
                if (val >= 0) {
                    this.maxProblemsPerUnit = val;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((optionValue = optionsMap.get(OPTION_TaskTags)) != null && optionValue instanceof String) {
            stringValue = (String)optionValue;
            this.taskTags = (char[][])(stringValue.length() == 0 ? null : CharOperation.splitAndTrimOn(',', stringValue.toCharArray()));
        }
        if ((optionValue = optionsMap.get(OPTION_TaskPriorities)) != null && optionValue instanceof String) {
            stringValue = (String)optionValue;
            this.taskPriorites = (char[][])(stringValue.length() == 0 ? null : CharOperation.splitAndTrimOn(',', stringValue.toCharArray()));
        }
        if ((optionValue = optionsMap.get(OPTION_PHPVarDeprecatedWarning)) != null) {
            this.updateSeverity(0x20000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_PHPBadStyleKeywordWarning)) != null) {
            this.updateSeverity(0x40000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_PHPBadStyleUppercaseIdentifierWarning)) != null) {
            this.updateSeverity(0x80000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_PHPIncludeNotExistWarning)) != null) {
            this.updateSeverity(0x100000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_UninitializedLocalVariableWarning)) != null) {
            this.updateSeverity(0x200000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_CodeCannotBeReachedWarning)) != null) {
            this.updateSeverity(0x400000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMethodWithConstructorName)) != null) {
            this.updateSeverity(4096L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportOverridingPackageDefaultMethod)) != null) {
            this.updateSeverity(8192L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportDeprecation)) != null) {
            this.updateSeverity(16384L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportHiddenCatchBlock)) != null) {
            this.updateSeverity(32768L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedLocal)) != null) {
            this.updateSeverity(65536L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedParameter)) != null) {
            this.updateSeverity(131072L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedImport)) != null) {
            this.updateSeverity(0x400000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedPrivateMember)) != null) {
            this.updateSeverity(0x8000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnusedDeclaredThrownException)) != null) {
            this.updateSeverity(0x2000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNoImplicitStringConversion)) != null) {
            this.updateSeverity(262144L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportSyntheticAccessEmulation)) != null) {
            this.updateSeverity(524288L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportLocalVariableHiding)) != null) {
            this.updateSeverity(0x10000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportFieldHiding)) != null) {
            this.updateSeverity(0x20000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportPossibleAccidentalBooleanAssignment)) != null) {
            this.updateSeverity(0x40000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportSuperfluousSemicolon)) != null) {
            this.updateSeverity(0x80000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNonExternalizedStringLiteral)) != null) {
            this.updateSeverity(0x100000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportAssertIdentifier)) != null) {
            this.updateSeverity(0x200000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNonStaticAccessToStatic)) != null) {
            this.updateSeverity(0x800000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportIndirectStaticAccess)) != null) {
            this.updateSeverity(0x100000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportIncompatibleNonInheritedInterfaceMethod)) != null) {
            this.updateSeverity(0x4000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUndocumentedEmptyBlock)) != null) {
            this.updateSeverity(0x200000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnnecessaryTypeCheck)) != null) {
            this.updateSeverity(0x400000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportFinallyBlockNotCompletingNormally)) != null) {
            this.updateSeverity(0x1000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportUnqualifiedFieldAccess)) != null) {
            this.updateSeverity(0x4000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportNoEffectAssignment)) != null) {
            this.updateSeverity(0x2000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_DocCommentSupport)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.docCommentSupport = true;
            } else if (DISABLED.equals(optionValue)) {
                this.docCommentSupport = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportInvalidJavadoc)) != null) {
            this.updateSeverity(0x800000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportInvalidJavadocTagsVisibility)) != null) {
            if (PUBLIC.equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 1;
            } else if (PROTECTED.equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 4;
            } else if (PRIVATE.equals(optionValue)) {
                this.reportInvalidJavadocTagsVisibility = 2;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportInvalidJavadocTags)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportInvalidJavadocTags = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportInvalidJavadocTags = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocTags)) != null) {
            this.updateSeverity(0x8000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocTagsVisibility)) != null) {
            if (PUBLIC.equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 1;
            } else if (PROTECTED.equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 4;
            } else if (PRIVATE.equals(optionValue)) {
                this.reportMissingJavadocTagsVisibility = 2;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocTagsOverriding)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportMissingJavadocTagsOverriding = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportMissingJavadocTagsOverriding = false;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocComments)) != null) {
            this.updateSeverity(0x10000000000L, optionValue);
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocCommentsVisibility)) != null) {
            if (PUBLIC.equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 1;
            } else if (PROTECTED.equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 4;
            } else if (PRIVATE.equals(optionValue)) {
                this.reportMissingJavadocCommentsVisibility = 2;
            }
        }
        if ((optionValue = optionsMap.get(OPTION_ReportMissingJavadocCommentsOverriding)) != null) {
            if (ENABLED.equals(optionValue)) {
                this.reportMissingJavadocCommentsOverriding = true;
            } else if (DISABLED.equals(optionValue)) {
                this.reportMissingJavadocCommentsOverriding = false;
            }
        }
    }

    public void setVerboseMode(boolean flag) {
        this.verbose = flag;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("CompilerOptions:");
        buf.append("\n\t- var is deprecated keyword: ").append(this.getSeverityString(0x20000000000L));
        buf.append("\n\t- don't use keywords as identifiers: ").append(this.getSeverityString(0x40000000000L));
        buf.append("\n\t- non-variable idenifiers should contain only uppercase characters: ").append(this.getSeverityString(0x80000000000L));
        buf.append("\n\t- include filename doesn't exist in project: ").append(this.getSeverityString(0x100000000000L));
        buf.append("\n\t- local variable not initialized: ").append(this.getSeverityString(0x200000000000L));
        buf.append("\n\t- unreachable code: ").append(this.getSeverityString(0x400000000000L));
        buf.append("\n\t- local variables debug attributes: ").append((this.produceDebugAttributes & 4) != 0 ? "ON" : " OFF");
        buf.append("\n\t- line number debug attributes: ").append((this.produceDebugAttributes & 2) != 0 ? "ON" : " OFF");
        buf.append("\n\t- source debug attributes: ").append((this.produceDebugAttributes & 1) != 0 ? "ON" : " OFF");
        buf.append("\n\t- preserve all local variables: ").append(this.preserveAllLocalVariables ? "ON" : " OFF");
        buf.append("\n\t- method with constructor name: ").append(this.getSeverityString(4096L));
        buf.append("\n\t- overridden package default method: ").append(this.getSeverityString(8192L));
        buf.append("\n\t- deprecation: ").append(this.getSeverityString(16384L));
        buf.append("\n\t- masked catch block: ").append(this.getSeverityString(32768L));
        buf.append("\n\t- unused local variable: ").append(this.getSeverityString(65536L));
        buf.append("\n\t- unused parameter: ").append(this.getSeverityString(131072L));
        buf.append("\n\t- unused import: ").append(this.getSeverityString(0x400000L));
        buf.append("\n\t- synthetic access emulation: ").append(this.getSeverityString(524288L));
        buf.append("\n\t- assignment with no effect: ").append(this.getSeverityString(0x2000000L));
        buf.append("\n\t- non externalized string: ").append(this.getSeverityString(0x100000L));
        buf.append("\n\t- static access receiver: ").append(this.getSeverityString(0x800000L));
        buf.append("\n\t- indirect static access: ").append(this.getSeverityString(0x100000000L));
        buf.append("\n\t- incompatible non inherited interface method: ").append(this.getSeverityString(0x4000000L));
        buf.append("\n\t- unused private member: ").append(this.getSeverityString(0x8000000L));
        buf.append("\n\t- local variable hiding another variable: ").append(this.getSeverityString(0x10000000L));
        buf.append("\n\t- field hiding another variable: ").append(this.getSeverityString(0x20000000L));
        buf.append("\n\t- possible accidental boolean assignment: ").append(this.getSeverityString(0x40000000L));
        buf.append("\n\t- superfluous semicolon: ").append(this.getSeverityString(0x80000000L));
        buf.append("\n\t- uncommented empty block: ").append(this.getSeverityString(0x200000000L));
        buf.append("\n\t- unnecessary type check: ").append(this.getSeverityString(0x400000000L));
        buf.append("\n\t- invalid javadoc: ").append(this.getSeverityString(0x800000000L));
        buf.append("\n\t- report invalid javadoc tags: ").append(this.reportInvalidJavadocTags ? ENABLED : DISABLED);
        buf.append("\n\t- visibility level to report invalid javadoc tags: ").append(this.getVisibilityString(this.reportInvalidJavadocTagsVisibility));
        buf.append("\n\t- missing javadoc tags: ").append(this.getSeverityString(0x8000000000L));
        buf.append("\n\t- visibility level to report missing javadoc tags: ").append(this.getVisibilityString(this.reportMissingJavadocTagsVisibility));
        buf.append("\n\t- report missing javadoc tags in overriding methods: ").append(this.reportMissingJavadocTagsOverriding ? ENABLED : DISABLED);
        buf.append("\n\t- missing javadoc comments: ").append(this.getSeverityString(0x10000000000L));
        buf.append("\n\t- visibility level to report missing javadoc comments: ").append(this.getVisibilityString(this.reportMissingJavadocCommentsVisibility));
        buf.append("\n\t- report missing javadoc comments in overriding methods: ").append(this.reportMissingJavadocCommentsOverriding ? ENABLED : DISABLED);
        buf.append("\n\t- finally block not completing normally: ").append(this.getSeverityString(0x1000000000L));
        buf.append("\n\t- unused declared thrown exception: ").append(this.getSeverityString(0x2000000000L));
        buf.append("\n\t- unused declared thrown exception when overriding ").append(this.reportUnusedDeclaredThrownExceptionWhenOverriding ? ENABLED : DISABLED);
        buf.append("\n\t- private constructor access: ").append(this.isPrivateConstructorAccessChangingVisibility ? "extra argument" : "make default access");
        buf.append("\n\t- verbose : ").append(this.verbose ? "ON" : "OFF");
        buf.append("\n\t- produce reference info : ").append(this.produceReferenceInfo ? "ON" : "OFF");
        buf.append("\n\t- parse literal expressions as constants : ").append(this.parseLiteralExpressionsAsConstants ? "ON" : "OFF");
        buf.append("\n\t- encoding : ").append(this.defaultEncoding == null ? "<default>" : this.defaultEncoding);
        buf.append("\n\t- task tags: ").append(this.taskTags == null ? "" : new String(CharOperation.concatWith(this.taskTags, ',')));
        buf.append("\n\t- task priorities : ").append(this.taskPriorites == null ? "" : new String(CharOperation.concatWith(this.taskPriorites, ',')));
        buf.append("\n\t- report deprecation inside deprecated code : ").append(this.reportDeprecationInsideDeprecatedCode ? "ENABLED" : "DISABLED");
        buf.append("\n\t- report deprecation when overriding deprecated method : ").append(this.reportDeprecationWhenOverridingDeprecatedMethod ? "ENABLED" : "DISABLED");
        buf.append("\n\t- report unused parameter when implementing abstract method : ").append(this.reportUnusedParameterWhenImplementingAbstract ? "ENABLED" : "DISABLED");
        buf.append("\n\t- report unused parameter when overriding concrete method : ").append(this.reportUnusedParameterWhenOverridingConcrete ? "ENABLED" : "DISABLED");
        buf.append("\n\t- report constructor/setter parameter hiding existing field : ").append(this.reportSpecialParameterHidingField ? "ENABLED" : "DISABLED");
        return buf.toString();
    }

    void updateSeverity(long irritant, Object severityString) {
        if (ERROR.equals(severityString)) {
            this.errorThreshold |= irritant;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (WARNING.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold |= irritant;
        } else if (IGNORE.equals(severityString)) {
            this.errorThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
            this.warningThreshold &= irritant ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }
}

