/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.flow;

import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.codegen.Label;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.SwitchFlowContext;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;

public class LabelFlowContext
extends SwitchFlowContext {
    public char[] labelName;

    public LabelFlowContext(FlowContext parent, ASTNode associatedNode, char[] labelName, Label breakLabel, BlockScope scope) {
        super(parent, associatedNode, breakLabel);
        this.labelName = labelName;
        this.checkLabelValidity(scope);
    }

    void checkLabelValidity(BlockScope scope) {
        FlowContext current = this.parent;
        while (current != null) {
            char[] currentLabelName = current.labelName();
            if (currentLabelName != null && CharOperation.equals(currentLabelName, this.labelName)) {
                scope.problemReporter().alreadyDefinedLabel(this.labelName, this.associatedNode);
            }
            current = current.parent;
        }
    }

    public String individualToString() {
        return "Label flow context [label:" + String.valueOf(this.labelName) + "]";
    }

    public char[] labelName() {
        return this.labelName;
    }
}

