/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.ExtendedStringLiteral;
import net.sourceforge.phpdt.internal.compiler.ast.Literal;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class StringLiteral
extends Literal {
    char[] source;

    public StringLiteral(char[] token, int s, int e) {
        this(s, e);
        this.source = token;
    }

    public StringLiteral(int s, int e) {
        super(s, e);
    }

    public void computeConstant() {
        this.constant = Constant.fromValue(String.valueOf(this.source));
    }

    public ExtendedStringLiteral extendWith(StringLiteral lit) {
        return new ExtendedStringLiteral(this, lit);
    }

    public TypeBinding literalType(BlockScope scope) {
        return scope.getJavaLangString();
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('\"');
        int i = 0;
        while (i < this.source.length) {
            switch (this.source[i]) {
                case '\b': {
                    output.append("\\b");
                    break;
                }
                case '\t': {
                    output.append("\\t");
                    break;
                }
                case '\n': {
                    output.append("\\n");
                    break;
                }
                case '\f': {
                    output.append("\\f");
                    break;
                }
                case '\r': {
                    output.append("\\r");
                    break;
                }
                case '\"': {
                    output.append("\\\"");
                    break;
                }
                case '\'': {
                    output.append("\\'");
                    break;
                }
                case '\\': {
                    output.append("\\\\");
                    break;
                }
                default: {
                    output.append(this.source[i]);
                }
            }
            ++i;
        }
        output.append('\"');
        return output;
    }

    public char[] source() {
        return this.source;
    }

    public String toStringExpression() {
        StringBuffer result = new StringBuffer("\"");
        int i = 0;
        while (i < this.source.length) {
            switch (this.source[i]) {
                case '\b': {
                    result.append("\\b");
                    break;
                }
                case '\t': {
                    result.append("\\t");
                    break;
                }
                case '\n': {
                    result.append("\\n");
                    break;
                }
                case '\f': {
                    result.append("\\f");
                    break;
                }
                case '\r': {
                    result.append("\\r");
                    break;
                }
                case '\"': {
                    result.append("\\\"");
                    break;
                }
                case '\'': {
                    result.append("\\'");
                    break;
                }
                case '\\': {
                    result.append("\\\\");
                    break;
                }
                default: {
                    result.append(this.source[i]);
                }
            }
            ++i;
        }
        result.append("\"");
        return result.toString();
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

