/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.AllocationExpression;
import net.sourceforge.phpdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.SingleTypeReference;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class QualifiedAllocationExpression
extends AllocationExpression {
    public Expression enclosingInstance;
    public AnonymousLocalTypeDeclaration anonymousType;
    public ReferenceBinding superTypeBinding;

    public QualifiedAllocationExpression() {
    }

    public QualifiedAllocationExpression(AnonymousLocalTypeDeclaration anonymousType) {
        this.anonymousType = anonymousType;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.enclosingInstance != null) {
            flowInfo = this.enclosingInstance.analyseCode(currentScope, flowContext, flowInfo);
        }
        this.checkCapturedLocalInitializationIfNecessary(this.superTypeBinding == null ? this.binding.declaringClass : this.superTypeBinding, currentScope, flowInfo);
        if (this.arguments != null) {
            int i = 0;
            int count = this.arguments.length;
            while (i < count) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo);
                ++i;
            }
        }
        if (this.anonymousType != null) {
            flowInfo = this.anonymousType.analyseCode(currentScope, flowContext, flowInfo);
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(thrownExceptions, (ASTNode)this, flowInfo, currentScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope);
        this.manageSyntheticAccessIfNecessary(currentScope);
        return flowInfo;
    }

    public Expression enclosingInstance() {
        return this.enclosingInstance;
    }

    public boolean isSuperAccess() {
        return this.anonymousType != null;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope) {
        ReferenceBinding allocatedType = this.binding.declaringClass;
        if (allocatedType.isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (allocatedType.isLocalType()) {
                ((LocalTypeBinding)allocatedType).addInnerEmulationDependent(currentScope, this.enclosingInstance != null);
            } else {
                currentScope.propagateInnerEmulation(allocatedType, this.enclosingInstance != null);
            }
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        int i;
        if (this.anonymousType == null && this.enclosingInstance == null) {
            return super.resolveType(scope);
        }
        this.constant = NotAConstant;
        TypeBinding enclosingInstanceType = null;
        TypeBinding receiverType = null;
        boolean hasError = false;
        if (this.anonymousType == null) {
            enclosingInstanceType = this.enclosingInstance.resolveType(scope);
            if (enclosingInstanceType == null) {
                hasError = true;
            } else if (enclosingInstanceType.isBaseType() || enclosingInstanceType.isArrayType()) {
                scope.problemReporter().illegalPrimitiveOrArrayTypeForEnclosingInstance(enclosingInstanceType, this.enclosingInstance);
                hasError = true;
            } else {
                this.resolvedType = receiverType = ((SingleTypeReference)this.type).resolveTypeEnclosing(scope, (ReferenceBinding)enclosingInstanceType);
                if (receiverType == null) {
                    hasError = true;
                }
            }
            TypeBinding[] argumentTypes = NoParameters;
            if (this.arguments != null) {
                int length = this.arguments.length;
                argumentTypes = new TypeBinding[length];
                int i2 = 0;
                while (i2 < length) {
                    argumentTypes[i2] = this.arguments[i2].resolveType(scope);
                    if (argumentTypes[i2] == null) {
                        hasError = true;
                    }
                    ++i2;
                }
            }
            if (hasError) {
                return receiverType;
            }
            if (!receiverType.canBeInstantiated()) {
                scope.problemReporter().cannotInstantiate(this.type, receiverType);
                return receiverType;
            }
            this.binding = scope.getConstructor((ReferenceBinding)receiverType, argumentTypes, this);
            if (this.binding.isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, scope)) {
                    scope.problemReporter().deprecatedMethod(this.binding, this);
                }
                if (this.arguments != null) {
                    int i3 = 0;
                    while (i3 < this.arguments.length) {
                        this.arguments[i3].implicitWidening(this.binding.parameters[i3], argumentTypes[i3]);
                        ++i3;
                    }
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = (ReferenceBinding)receiverType;
                }
                scope.problemReporter().invalidConstructor(this, this.binding);
                return receiverType;
            }
            ReferenceBinding expectedType = this.binding.declaringClass.enclosingType();
            if (enclosingInstanceType.isCompatibleWith(expectedType)) {
                return receiverType;
            }
            scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.enclosingInstance, enclosingInstanceType, expectedType);
            return receiverType;
        }
        if (this.enclosingInstance != null) {
            enclosingInstanceType = this.enclosingInstance.resolveType(scope);
            if (enclosingInstanceType == null) {
                hasError = true;
            } else if (enclosingInstanceType.isBaseType() || enclosingInstanceType.isArrayType()) {
                scope.problemReporter().illegalPrimitiveOrArrayTypeForEnclosingInstance(enclosingInstanceType, this.enclosingInstance);
                hasError = true;
            } else {
                receiverType = ((SingleTypeReference)this.type).resolveTypeEnclosing(scope, (ReferenceBinding)enclosingInstanceType);
            }
        } else {
            receiverType = this.type.resolveType(scope);
        }
        if (receiverType == null) {
            hasError = true;
        } else if (((ReferenceBinding)receiverType).isFinal()) {
            scope.problemReporter().anonymousClassCannotExtendFinalClass(this.type, receiverType);
            hasError = true;
        }
        TypeBinding[] argumentTypes = NoParameters;
        if (this.arguments != null) {
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            i = 0;
            while (i < length) {
                argumentTypes[i] = this.arguments[i].resolveType(scope);
                if (argumentTypes[i] == null) {
                    hasError = true;
                }
                ++i;
            }
        }
        if (hasError) {
            return receiverType;
        }
        this.superTypeBinding = receiverType.isInterface() ? scope.getJavaLangObject() : (ReferenceBinding)receiverType;
        MethodBinding inheritedBinding = scope.getConstructor(this.superTypeBinding, argumentTypes, this);
        if (!inheritedBinding.isValidBinding()) {
            if (inheritedBinding.declaringClass == null) {
                inheritedBinding.declaringClass = this.superTypeBinding;
            }
            scope.problemReporter().invalidConstructor(this, inheritedBinding);
            return null;
        }
        if (this.enclosingInstance != null && !enclosingInstanceType.isCompatibleWith(inheritedBinding.declaringClass.enclosingType())) {
            scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.enclosingInstance, enclosingInstanceType, inheritedBinding.declaringClass.enclosingType());
            return null;
        }
        if (this.arguments != null) {
            i = 0;
            while (i < this.arguments.length) {
                this.arguments[i].implicitWidening(inheritedBinding.parameters[i], argumentTypes[i]);
                ++i;
            }
        }
        scope.addAnonymousType(this.anonymousType, (ReferenceBinding)receiverType);
        this.anonymousType.resolve(scope);
        this.binding = this.anonymousType.createsInternalConstructorWithBinding(inheritedBinding);
        return this.anonymousType.binding;
    }

    public String toStringExpression() {
        return this.toStringExpression(0);
    }

    public String toStringExpression(int tab) {
        String s = "";
        if (this.enclosingInstance != null) {
            s = String.valueOf(s) + this.enclosingInstance.toString() + ".";
        }
        s = String.valueOf(s) + super.toStringExpression();
        if (this.anonymousType != null) {
            s = String.valueOf(s) + this.anonymousType.toString(tab);
        }
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.enclosingInstance != null) {
                this.enclosingInstance.traverse(visitor, scope);
            }
            this.type.traverse(visitor, scope);
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.anonymousType != null) {
                this.anonymousType.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

