/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.BinaryExpression;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.MethodBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.Scope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class EqualExpression
extends BinaryExpression {
    public EqualExpression(Expression left, Expression right, int operator) {
        super(left, right, operator);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((this.bits & 0xFC0) >> 6 == 18) {
            if (this.left.constant != NotAConstant && this.left.constant.typeID() == 5) {
                if (this.left.constant.booleanValue()) {
                    return this.right.analyseCode(currentScope, flowContext, flowInfo);
                }
                return this.right.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
            }
            if (this.right.constant != NotAConstant && this.right.constant.typeID() == 5) {
                if (this.right.constant.booleanValue()) {
                    return this.left.analyseCode(currentScope, flowContext, flowInfo);
                }
                return this.left.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
            }
            return this.right.analyseCode(currentScope, flowContext, this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
        }
        if (this.left.constant != NotAConstant && this.left.constant.typeID() == 5) {
            if (!this.left.constant.booleanValue()) {
                return this.right.analyseCode(currentScope, flowContext, flowInfo);
            }
            return this.right.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
        }
        if (this.right.constant != NotAConstant && this.right.constant.typeID() == 5) {
            if (!this.right.constant.booleanValue()) {
                return this.left.analyseCode(currentScope, flowContext, flowInfo);
            }
            return this.left.analyseCode(currentScope, flowContext, flowInfo).asNegatedCondition();
        }
        return this.right.analyseCode(currentScope, flowContext, this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).asNegatedCondition().unconditionalInits();
    }

    public final boolean areTypesCastCompatible(BlockScope scope, TypeBinding castType, TypeBinding expressionType) {
        if (castType == expressionType) {
            return true;
        }
        if (expressionType.isArrayType()) {
            if (castType.isArrayType()) {
                TypeBinding expressionEltType = ((ArrayBinding)expressionType).elementsType(scope);
                if (expressionEltType.isBaseType()) {
                    return ((ArrayBinding)castType).elementsType(scope) == expressionEltType;
                }
                return this.areTypesCastCompatible(scope, ((ArrayBinding)castType).elementsType(scope), expressionEltType);
            }
            if (castType.isBaseType()) {
                return false;
            }
            if (castType.isClass()) {
                return scope.isJavaLangObject(castType);
            }
            if (castType.isInterface()) {
                return scope.isJavaLangCloneable(castType) || scope.isJavaIoSerializable(castType);
            }
            return false;
        }
        if (expressionType == NullBinding) {
            return !castType.isBaseType();
        }
        if (expressionType.isBaseType()) {
            return false;
        }
        if (expressionType.isClass()) {
            if (castType.isArrayType() && scope.isJavaLangObject(expressionType)) {
                return true;
            }
            if (castType.isBaseType()) {
                return false;
            }
            if (castType.isClass()) {
                if (expressionType.isCompatibleWith(castType)) {
                    return true;
                }
                return castType.isCompatibleWith(expressionType);
            }
            if (castType.isInterface()) {
                if (((ReferenceBinding)expressionType).isFinal()) {
                    return expressionType.isCompatibleWith(castType);
                }
                return true;
            }
            return false;
        }
        if (expressionType.isInterface()) {
            if (castType.isArrayType()) {
                return scope.isJavaLangCloneable(expressionType) || scope.isJavaIoSerializable(expressionType);
            }
            if (castType.isBaseType()) {
                return false;
            }
            if (castType.isClass()) {
                if (scope.isJavaLangObject(castType)) {
                    return true;
                }
                if (((ReferenceBinding)castType).isFinal()) {
                    return castType.isCompatibleWith(expressionType);
                }
                return true;
            }
            if (castType.isInterface()) {
                if (Scope.compareTypes(castType, expressionType) == 0) {
                    MethodBinding[] castTbMethods = ((ReferenceBinding)castType).methods();
                    int castTbMethodsLength = castTbMethods.length;
                    MethodBinding[] expressionTbMethods = ((ReferenceBinding)expressionType).methods();
                    int expressionTbMethodsLength = expressionTbMethods.length;
                    int i = 0;
                    while (i < castTbMethodsLength) {
                        int j = 0;
                        while (j < expressionTbMethodsLength) {
                            if (castTbMethods[i].selector == expressionTbMethods[j].selector && castTbMethods[i].returnType != expressionTbMethods[j].returnType && castTbMethods[i].areParametersEqual(expressionTbMethods[j])) {
                                return false;
                            }
                            ++j;
                        }
                        ++i;
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public final void computeConstant(TypeBinding leftType, TypeBinding rightType) {
        if (this.left.constant != NotAConstant && this.right.constant != NotAConstant) {
            this.constant = Constant.computeConstantOperationEQUAL_EQUAL(this.left.constant, leftType.id, 18, this.right.constant, rightType.id);
            if ((this.bits & 0xFC0) >> 6 == 29) {
                this.constant = Constant.fromValue(!this.constant.booleanValue());
            }
        } else {
            this.constant = NotAConstant;
        }
    }

    public boolean isCompactableOperation() {
        return false;
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding leftType = this.left.resolveType(scope);
        TypeBinding rightType = this.right.resolveType(scope);
        if (leftType == null || rightType == null) {
            this.constant = NotAConstant;
            return null;
        }
        if (leftType.isBaseType() && rightType.isBaseType()) {
            int result = ResolveTypeTables[18][(leftType.id << 4) + rightType.id];
            this.left.implicitConversion = result >>> 12;
            this.right.implicitConversion = result >>> 4 & 0xFF;
            this.bits |= result & 0xF;
            if ((result & 0xF) == 0) {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftType, rightType);
                return null;
            }
            this.computeConstant(leftType, rightType);
            this.resolvedType = BooleanBinding;
            return BooleanBinding;
        }
        if (this.areTypesCastCompatible(scope, rightType, leftType) || this.areTypesCastCompatible(scope, leftType, rightType)) {
            if (rightType.id == 11 && leftType.id == 11) {
                this.computeConstant(leftType, rightType);
            } else {
                this.constant = NotAConstant;
            }
            if (rightType.id == 11) {
                this.right.implicitConversion = 187;
            }
            if (leftType.id == 11) {
                this.left.implicitConversion = 187;
            }
            this.resolvedType = BooleanBinding;
            return BooleanBinding;
        }
        this.constant = NotAConstant;
        scope.problemReporter().notCompatibleTypesError(this, leftType, rightType);
        return null;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

