/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.OperatorExpression;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class BinaryExpression
extends OperatorExpression {
    public Expression left;
    public Expression right;
    public Constant optimizedBooleanConstant;

    public BinaryExpression(Expression left, Expression right, int operator) {
        this.left = left;
        this.right = right;
        this.bits |= operator << 6;
        this.sourceStart = left.sourceStart;
        this.sourceEnd = right.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.right.analyseCode(currentScope, flowContext, this.left.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
    }

    public void computeConstant(BlockScope scope, int leftId, int rightId) {
        if (this.left.constant != Constant.NotAConstant && this.right.constant != Constant.NotAConstant) {
            try {
                this.constant = Constant.computeConstantOperation(this.left.constant, leftId, (this.bits & 0xFC0) >> 6, this.right.constant, rightId);
            }
            catch (ArithmeticException arithmeticException) {
                this.constant = Constant.NotAConstant;
            }
        } else {
            this.constant = Constant.NotAConstant;
        }
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public StringBuffer printExpressionNoParenthesis(int indent, StringBuffer output) {
        this.left.printExpression(indent, output).append(' ').append(this.operatorToString()).append(' ');
        return this.right.printExpression(0, output);
    }

    public TypeBinding resolveType(BlockScope scope) {
        TypeBinding leftTb = this.left.resolveType(scope);
        TypeBinding rightTb = this.right.resolveType(scope);
        if (leftTb == null || rightTb == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        int leftId = leftTb.id;
        int rightId = rightTb.id;
        if (leftId > 15 || rightId > 15) {
            if (leftId == 11) {
                rightId = 1;
            } else if (rightId == 11) {
                leftId = 1;
            } else {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftTb, rightTb);
                return null;
            }
        }
        if ((this.bits & 0xFC0) >> 6 == 14) {
            if (leftId == 11 && rightTb.isArrayType() && ((ArrayBinding)rightTb).elementsType(scope) == CharBinding) {
                scope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.right);
            } else if (rightId == 11 && leftTb.isArrayType() && ((ArrayBinding)leftTb).elementsType(scope) == CharBinding) {
                scope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.left);
            }
        }
        int result = ResolveTypeTables[(this.bits & 0xFC0) >> 6][(leftId << 4) + rightId];
        this.left.implicitConversion = result >>> 12;
        this.right.implicitConversion = result >>> 4 & 0xFF;
        this.bits |= result & 0xF;
        switch (result & 0xF) {
            case 5: {
                this.resolvedType = BooleanBinding;
                break;
            }
            case 3: {
                this.resolvedType = ByteBinding;
                break;
            }
            case 2: {
                this.resolvedType = CharBinding;
                break;
            }
            case 8: {
                this.resolvedType = DoubleBinding;
                break;
            }
            case 9: {
                this.resolvedType = FloatBinding;
                break;
            }
            case 10: {
                this.resolvedType = IntBinding;
                break;
            }
            case 7: {
                this.resolvedType = LongBinding;
                break;
            }
            case 11: {
                this.resolvedType = scope.getJavaLangString();
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                scope.problemReporter().invalidOperator(this, leftTb, rightTb);
                return null;
            }
        }
        this.computeConstant(scope, leftId, rightId);
        return this.resolvedType;
    }

    public String toStringExpressionNoParenthesis() {
        return String.valueOf(this.left.toStringExpression()) + " " + this.operatorToString() + " " + this.right.toStringExpression();
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.left.traverse(visitor, scope);
            this.right.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

