/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.launching;

import java.util.Iterator;
import net.sourceforge.phpdt.internal.core.JavaProject;
import net.sourceforge.phpdt.internal.debug.core.PHPDBGProxy;
import net.sourceforge.phpdt.internal.debug.core.model.PHPDebugTarget;
import net.sourceforge.phpdt.internal.launching.InterpreterRunner;
import net.sourceforge.phpdt.internal.launching.InterpreterRunnerConfiguration;
import net.sourceforge.phpeclipse.ui.editor.BrowserUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Display;

public class DebuggerRunner
extends InterpreterRunner {
    public IProcess run(InterpreterRunnerConfiguration configuration, ILaunch launch) {
        PHPDBGProxy newPHPDBGProxy = new PHPDBGProxy(configuration.useRemoteDebugger(), configuration.getRemoteSourcePath(), configuration.usePathTranslation(), configuration.getPathMap());
        IProcess process = null;
        PHPDebugTarget debugTarget = new PHPDebugTarget(launch, process);
        newPHPDBGProxy.setDebugTarget(debugTarget);
        newPHPDBGProxy.start();
        if (configuration.useRemoteDebugger()) {
            if (configuration.useDBGSessionInBrowser()) {
                DebuggerRunner.activateDBGSESSIDPreview(configuration, newPHPDBGProxy.getPort());
            }
        } else {
            this.setEnvironmentVariables(configuration, newPHPDBGProxy.getPort());
            process = super.run(configuration, launch);
            debugTarget.setProcess(process);
        }
        launch.addDebugTarget((IDebugTarget)debugTarget);
        return process;
    }

    protected static void activateDBGSESSIDPreview(final InterpreterRunnerConfiguration configuration, final int port) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                String fileName = configuration.getFileName();
                JavaProject jproject = configuration.getProject();
                IProject project = jproject.getProject();
                IFile file = project.getFile(fileName);
                if (configuration.useDBGSessionInExternalBrowser()) {
                    BrowserUtil.showBrowserAsExternal((IFile)file, (String)("?DBGSESSID=1@clienthost:" + port));
                } else {
                    BrowserUtil.showPreview((IFile)file, (boolean)true, (String)("?DBGSESSID=1@clienthost:" + port));
                }
            }
        });
    }

    protected void setEnvironmentVariables(InterpreterRunnerConfiguration configuration, int listenPort) {
        String[] cfr_ignored_0 = new String[18];
        long id = Math.round(Math.random() * 100000.0);
        String DBGSessID = "DBGSESSID=" + id + "@clienthost:" + listenPort;
        configuration.addEnvironmentValue("HTTP_COOKIE", DBGSessID, false);
    }

    protected String getDebugCommandLineArgument() {
        return "";
    }

    protected String renderLoadPath(InterpreterRunnerConfiguration configuration) {
        StringBuffer loadPath = new StringBuffer();
        JavaProject project = configuration.getProject();
        this.addToLoadPath(loadPath, project.getProject());
        Iterator referencedProjects = project.getReferencedProjects().iterator();
        while (referencedProjects.hasNext()) {
            this.addToLoadPath(loadPath, (IProject)referencedProjects.next());
        }
        return loadPath.toString();
    }
}

