/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.htmlparser.Node;
import org.htmlparser.Tag;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexerapplications.thumbelina.Picture;
import org.htmlparser.lexerapplications.thumbelina.PicturePanel;
import org.htmlparser.lexerapplications.thumbelina.Sequencer;
import org.htmlparser.lexerapplications.thumbelina.ThumbelinaFrame;
import org.htmlparser.util.ParserException;

public class Thumbelina
extends JPanel
implements Runnable,
ItemListener,
ChangeListener,
ListSelectionListener {
    public static final String PROP_CURRENT_URL_PROPERTY = "currentURL";
    public static final String PROP_URL_QUEUE_PROPERTY = "queueSize";
    public static final String PROP_URL_VISITED_PROPERTY = "visitedSize";
    private ArrayList mUrls = new ArrayList();
    protected HashMap mVisited = new HashMap();
    protected HashMap mRequested = new HashMap();
    protected HashMap mTracked = new HashMap();
    protected Thread mThread = null;
    protected boolean mActive = true;
    protected Sequencer mSequencer;
    protected PicturePanel mPicturePanel = new PicturePanel(this);
    protected static final URL[][] NONE = new URL[][]{new URL[0], new URL[0]};
    protected PropertyChangeSupport mPropertySupport;
    protected String mCurrentURL = null;
    protected boolean mDiscardCGI = true;
    protected boolean mDiscardQueries = true;
    protected JCheckBox mBackgroundToggle;
    protected JList mHistory;
    protected JScrollPane mPicturePanelScroller;
    protected JScrollPane mHistoryScroller;
    protected JSplitPane mMainArea;
    protected JPanel mPowerBar;
    protected JProgressBar mQueueProgress;
    protected JProgressBar mReadyProgress;
    protected JCheckBox mRunToggle;
    protected JSlider mSpeedSlider;
    protected JTextField mUrlText;
    protected JLabel mQueueSize;
    protected JLabel mVisitedSize;
    static ArrayList mEnqueuers = new ArrayList();

    public Thumbelina() {
        this((URL)null);
    }

    public Thumbelina(String url) throws MalformedURLException {
        this(null == url ? null : new URL(url));
    }

    public Thumbelina(URL url) {
        this.mSequencer = new Sequencer(this);
        this.mPropertySupport = new PropertyChangeSupport(this);
        this.setDoubleBuffered(false);
        this.setLayout(new BorderLayout());
        this.mPicturePanel.setDoubleBuffered(false);
        this.mThread = new Thread(this);
        this.mThread.setName("BackgroundThread");
        this.mThread.start();
        this.initComponents();
        this.mRunToggle.addItemListener(this);
        this.mBackgroundToggle.addItemListener(this);
        this.mSpeedSlider.addChangeListener(this);
        this.mHistory.addListSelectionListener(this);
        this.memCheck();
        if (null != url) {
            this.append(url);
        }
    }

    protected void memCheck() {
        if (System.getProperty("java.version").startsWith("1.4")) {
            Runtime runtime = Runtime.getRuntime();
            runtime.gc();
            long maximum = runtime.maxMemory();
            if (maximum < 0x4000000L) {
                JOptionPane.showMessageDialog(null, "Maximum available memory is low (" + maximum + " bytes).\n" + "\n" + "It is strongly suggested to increase the maximum memory\n" + "available by using the JVM command line switch -Xmx with\n" + "a suitable value, such as -Xmx256M for example.", "Thumbelina - Low memory", 2, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        int oldsize;
        ArrayList arrayList = this.mUrls;
        synchronized (arrayList) {
            this.mSequencer.reset();
            this.mPicturePanel.reset();
            oldsize = this.mUrls.size();
            this.mUrls.clear();
        }
        this.updateQueueSize(oldsize, this.mUrls.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(URL url) {
        String href = url.toExternalForm();
        boolean found = false;
        int oldsize = -1;
        ArrayList arrayList = this.mUrls;
        synchronized (arrayList) {
            for (int i = 0; !found && i < this.mUrls.size(); ++i) {
                URL u = (URL)this.mUrls.get(i);
                if (!href.equals(u.toExternalForm())) continue;
                found = true;
            }
            if (!found) {
                oldsize = this.mUrls.size();
                this.mUrls.add(url);
                this.mUrls.notify();
            }
        }
        if (-1 != oldsize) {
            this.updateQueueSize(oldsize, this.mUrls.size());
        }
    }

    public void append(ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            this.append((URL)list.get(i));
        }
    }

    protected ArrayList filter(URL[] urls) {
        ArrayList<URL> list = new ArrayList<URL>();
        for (int i = 0; i < urls.length; ++i) {
            URL url = urls[i];
            String ref = url.toExternalForm();
            if (this.mDiscardCGI && -1 != ref.indexOf("/cgi-bin/") || this.mDiscardQueries && -1 != ref.indexOf("?") || this.mVisited.containsKey(ref)) continue;
            try {
                url.openConnection();
                list.add(url);
                continue;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return list;
    }

    private void initComponents() {
        this.mPowerBar = new JPanel();
        this.mUrlText = new JTextField();
        this.mRunToggle = new JCheckBox();
        this.mSpeedSlider = new JSlider();
        this.mReadyProgress = new JProgressBar();
        this.mQueueProgress = new JProgressBar();
        this.mBackgroundToggle = new JCheckBox();
        this.mMainArea = new JSplitPane();
        this.mPicturePanelScroller = new JScrollPane();
        this.mHistoryScroller = new JScrollPane();
        this.mHistory = new JList();
        this.mQueueSize = new JLabel();
        this.mVisitedSize = new JLabel();
        this.mPowerBar.setLayout(new BoxLayout(this.mPowerBar, 0));
        this.mPowerBar.setBorder(new BevelBorder(1));
        this.mPowerBar.add(this.mUrlText);
        this.mRunToggle.setSelected(true);
        this.mRunToggle.setText("On/Off");
        this.mRunToggle.setToolTipText("Starts/stops the image presentation.");
        this.mPowerBar.add(this.mRunToggle);
        this.mSpeedSlider.setMajorTickSpacing(1000);
        this.mSpeedSlider.setMaximum(5000);
        this.mSpeedSlider.setPaintTicks(true);
        this.mSpeedSlider.setToolTipText("Set inter-image delay.");
        this.mSpeedSlider.setValue(500);
        this.mSpeedSlider.setInverted(true);
        this.mPowerBar.add(this.mSpeedSlider);
        this.mReadyProgress.setToolTipText("Pending images..");
        this.mReadyProgress.setStringPainted(true);
        this.mPowerBar.add(this.mReadyProgress);
        this.mQueueProgress.setToolTipText("Outstanding image fetches..");
        this.mQueueProgress.setStringPainted(true);
        this.mPowerBar.add(this.mQueueProgress);
        this.mBackgroundToggle.setSelected(true);
        this.mBackgroundToggle.setText("On/Off");
        this.mBackgroundToggle.setToolTipText("Starts/stops background fetching.");
        this.mPowerBar.add(this.mBackgroundToggle);
        this.mVisitedSize.setBorder(new BevelBorder(1));
        this.mVisitedSize.setText("00000");
        this.mVisitedSize.setToolTipText("Number of URLs examined.");
        this.mPowerBar.add(this.mVisitedSize);
        this.mQueueSize.setBorder(new BevelBorder(1));
        this.mQueueSize.setText("00000");
        this.mQueueSize.setToolTipText("Number of URLs in queue.");
        this.mPowerBar.add(this.mQueueSize);
        this.mHistory.setModel(new DefaultListModel());
        this.mHistory.setToolTipText("History");
        this.mHistory.setDoubleBuffered(false);
        this.mHistory.setSelectionMode(2);
        this.mHistoryScroller.setViewportView(this.mHistory);
        this.mHistoryScroller.setDoubleBuffered(false);
        this.mPicturePanelScroller.setViewportView(this.mPicturePanel);
        this.mPicturePanelScroller.setDoubleBuffered(false);
        this.mPicturePanelScroller.setHorizontalScrollBarPolicy(32);
        this.mPicturePanelScroller.setVerticalScrollBarPolicy(22);
        this.add((Component)this.mMainArea, "Center");
        this.mMainArea.setLeftComponent(this.mHistoryScroller);
        this.mMainArea.setRightComponent(this.mPicturePanelScroller);
        this.add((Component)this.mPowerBar, "South");
    }

    public boolean getStatusBarVisible() {
        boolean ret = false;
        for (int i = 0; !ret && i < this.getComponentCount(); ++i) {
            if (this.mPowerBar != this.getComponent(i)) continue;
            ret = true;
        }
        return ret;
    }

    public void setStatusBarVisible(boolean visible) {
        int index = -1;
        for (int i = 0; -1 == index && i < this.getComponentCount(); ++i) {
            if (this.mPowerBar != this.getComponent(i)) continue;
            index = i;
        }
        if (visible) {
            if (-1 == index) {
                this.add((Component)this.mPowerBar, "South");
                this.invalidate();
                this.validate();
            }
        } else if (-1 != index) {
            this.remove(index);
            this.invalidate();
            this.validate();
        }
    }

    public boolean getHistoryListVisible() {
        boolean ret = false;
        for (int i = 0; !ret && i < this.getComponentCount(); ++i) {
            if (this.mMainArea != this.getComponent(i)) continue;
            ret = true;
        }
        return ret;
    }

    public void setHistoryListVisible(boolean visible) {
        int pictpanel = -1;
        int splitter = -1;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (this.mPicturePanelScroller == component) {
                pictpanel = i;
                continue;
            }
            if (this.mMainArea != component) continue;
            splitter = i;
        }
        if (visible) {
            if (-1 != pictpanel) {
                this.remove(pictpanel);
                this.add((Component)this.mMainArea, "Center");
                this.mMainArea.setLeftComponent(this.mHistoryScroller);
                this.mMainArea.setRightComponent(this.mPicturePanelScroller);
                this.invalidate();
                this.validate();
            }
        } else if (-1 != splitter) {
            this.remove(splitter);
            this.add((Component)this.mPicturePanelScroller, "Center");
            this.invalidate();
            this.validate();
        }
    }

    public boolean getSequencerActive() {
        return this.mSequencer.mActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSequencerActive(boolean active) {
        if (0 == this.getSpeed()) {
            this.setSpeed(500);
        }
        this.mSequencer.mActive = active;
        if (active) {
            ArrayList arrayList = this.mSequencer.mPending;
            synchronized (arrayList) {
                this.mSequencer.mPending.notify();
            }
        }
        if (active != this.mRunToggle.isSelected()) {
            this.mRunToggle.setSelected(active);
        }
    }

    public boolean getBackgroundThreadActive() {
        return this.mActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundThreadActive(boolean active) {
        this.mActive = active;
        if (active) {
            ArrayList arrayList = this.mUrls;
            synchronized (arrayList) {
                this.mUrls.notify();
            }
        }
        if (active != this.mBackgroundToggle.isSelected()) {
            this.mBackgroundToggle.setSelected(active);
        }
    }

    public int getSpeed() {
        return this.mSequencer.getDelay();
    }

    public void setSpeed(int speed) {
        if (0 == speed) {
            this.mRunToggle.setSelected(false);
        } else {
            this.mRunToggle.setSelected(true);
            this.mSequencer.setDelay(speed);
        }
        if (speed != this.mSpeedSlider.getValue()) {
            this.mSpeedSlider.setValue(speed);
        }
    }

    public boolean isDiscardCGI() {
        return this.mDiscardCGI;
    }

    public void setDiscardCGI(boolean discard) {
        this.mDiscardCGI = discard;
    }

    public boolean isDiscardQueries() {
        return this.mDiscardQueries;
    }

    public void setDiscardQueries(boolean discard) {
        this.mDiscardQueries = discard;
    }

    protected boolean isImage(String url) {
        String lower = url.toLowerCase();
        return lower.endsWith(".jpg") || lower.endsWith(".gif") || lower.endsWith(".png");
    }

    protected URL[][] extractImageLinks(Lexer lexer, URL docbase) throws IOException, ParserException {
        Node node;
        HashMap<String, URL> images = new HashMap<String, URL>();
        HashMap<String, URL> links = new HashMap<String, URL>();
        boolean ina = false;
        Tag startatag = null;
        Tag imgtag = null;
        while (null != (node = lexer.nextNode())) {
            if (!(node instanceof Tag)) continue;
            Tag tag = (Tag)node;
            String name = tag.getTagName();
            if ("A".equals(name)) {
                URL url;
                String href;
                if (tag.isEndTag()) {
                    String src;
                    ina = false;
                    if (null == imgtag || null == (href = startatag.getAttribute("HREF")) || !this.isImage(href) || null == (src = imgtag.getAttribute("SRC"))) continue;
                    try {
                        url = new URL(docbase, href);
                        if (images.containsKey(href = url.toExternalForm())) continue;
                        images.put(href, url);
                    }
                    catch (MalformedURLException murle) {}
                    continue;
                }
                startatag = tag;
                imgtag = null;
                ina = true;
                href = startatag.getAttribute("HREF");
                if (null == href || this.isImage(href)) continue;
                try {
                    url = new URL(docbase, href);
                    if (links.containsKey(href = url.toExternalForm())) continue;
                    links.put(href, url);
                }
                catch (MalformedURLException murle) {}
                continue;
            }
            if (!ina || !"IMG".equals(name)) continue;
            imgtag = tag;
        }
        URL[][] ret = new URL[2][];
        ret[0] = new URL[images.size()];
        images.values().toArray(ret[0]);
        ret[1] = new URL[links.size()];
        links.values().toArray(ret[1]);
        return ret;
    }

    protected URL[][] getImageLinks(URL url) {
        URL[][] ret;
        if (null != url) {
            try {
                Lexer lexer = new Lexer(url.openConnection());
                ret = this.extractImageLinks(lexer, url);
            }
            catch (Throwable t) {
                System.out.println(t.getMessage());
                ret = NONE;
            }
        } else {
            ret = NONE;
        }
        return ret;
    }

    public PicturePanel getPicturePanel() {
        return this.mPicturePanel;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mPropertySupport.removePropertyChangeListener(listener);
    }

    public String getCurrentURL() {
        return this.mCurrentURL;
    }

    protected void setCurrentURL(String url) {
        if (null != url && !url.equals(this.mCurrentURL) || null == url && null != this.mCurrentURL) {
            String oldValue = this.mCurrentURL;
            this.mCurrentURL = url;
            this.mPropertySupport.firePropertyChange(PROP_CURRENT_URL_PROPERTY, oldValue, url);
        }
    }

    protected void updateQueueSize(int original, int current) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(current);
        while (buffer.length() < 5) {
            buffer.insert(0, '0');
        }
        this.mQueueSize.setText(buffer.toString());
        this.mPropertySupport.firePropertyChange(PROP_URL_QUEUE_PROPERTY, original, current);
    }

    protected void updateVisitedSize(int original, int current) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(current);
        while (buffer.length() < 5) {
            buffer.insert(0, '0');
        }
        this.mVisitedSize.setText(buffer.toString());
        this.mPropertySupport.firePropertyChange(PROP_URL_VISITED_PROPERTY, original, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetch(URL[] images) {
        for (int j = 0; j < images.length; ++j) {
            if (this.mRequested.containsKey(images[j].toExternalForm())) continue;
            Image image = this.getToolkit().createImage(images[j]);
            Tracker tracker = new Tracker(images[j]);
            HashMap hashMap = this.mTracked;
            synchronized (hashMap) {
                int size = this.mTracked.size() + 1;
                if (this.mQueueProgress.getMaximum() < size) {
                    try {
                        this.mTracked.wait();
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                this.mRequested.put(images[j].toExternalForm(), images[j]);
                this.mTracked.put(images[j].toExternalForm(), images[j]);
                this.mQueueProgress.setValue(size);
                image.getWidth(tracker);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                ArrayList arrayList;
                do {
                    URL link = null;
                    int original = -1;
                    arrayList = this.mUrls;
                    synchronized (arrayList) {
                        if (0 != this.mUrls.size()) {
                            original = this.mUrls.size();
                            link = (URL)this.mUrls.remove(0);
                        } else {
                            Thread.sleep(100L);
                        }
                    }
                    if (null == link) continue;
                    this.updateQueueSize(original, this.mUrls.size());
                    String href = link.toExternalForm();
                    this.setCurrentURL(href);
                    this.mVisited.put(href, link);
                    this.updateVisitedSize(this.mVisited.size() - 1, this.mVisited.size());
                    URL[][] urls = this.getImageLinks(link);
                    this.fetch(urls[0]);
                    arrayList = mEnqueuers;
                    synchronized (arrayList) {
                        Enqueuer enqueuer = new Enqueuer(urls[1]);
                        enqueuer.setPriority(1);
                        mEnqueuers.add(enqueuer);
                        enqueuer.start();
                    }
                    this.setCurrentURL(null);
                } while (this.mActive);
                arrayList = this.mUrls;
                synchronized (arrayList) {
                    this.mUrls.wait();
                    continue;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void itemStateChanged(ItemEvent event) {
        boolean checked;
        ItemSelectable source = event.getItemSelectable();
        boolean bl = checked = 1 == event.getStateChange();
        if (source == this.mRunToggle) {
            this.setSequencerActive(checked);
        } else if (source == this.mBackgroundToggle) {
            this.setBackgroundThreadActive(checked);
        }
    }

    public void stateChanged(ChangeEvent event) {
        JSlider source = (JSlider)event.getSource();
        if (!source.getValueIsAdjusting()) {
            this.setSpeed(source.getValue());
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        JList source = (JList)event.getSource();
        if (source == this.mHistory && !event.getValueIsAdjusting()) {
            Object[] hrefs = source.getSelectedValues();
            for (int i = 0; i < hrefs.length; ++i) {
                Picture picture = this.mPicturePanel.find("http://" + (String)hrefs[i]);
                if (null != picture) {
                    this.mPicturePanel.bringToTop(picture);
                    continue;
                }
                try {
                    URL url = new URL("http://" + (String)hrefs[i]);
                    Image image = this.getToolkit().createImage(url);
                    Tracker tracker = new Tracker(url);
                    image.getWidth(tracker);
                    System.out.println("refetching " + hrefs[i]);
                    continue;
                }
                catch (MalformedURLException murle) {
                    murle.printStackTrace();
                }
            }
        }
    }

    public void addHistory(String url) {
        this.mUrlText.setText(url);
        int index = url.indexOf("http://");
        if (-1 != index) {
            url = url.substring(index + 7);
        } else {
            System.out.println("********* " + url + " ************");
        }
        DefaultListModel model = (DefaultListModel)this.mHistory.getModel();
        model.addElement(url);
    }

    public void open(String ref) {
        try {
            if (!ref.startsWith("http://")) {
                ref = "http://" + ref;
            }
            URL url = new URL(ref);
            this.reset();
            this.append(url);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    protected static void help() {
        System.out.println("Thumbelina - Scan and display the images behind thumbnails.");
        System.out.println("java -Xmx256M -jar thumbelina.jar [url]");
        System.out.println("It is highly recommended that the maximum heap size be increased with -Xmx switch.");
        System.exit(0);
    }

    public static void main(String[] args) {
        JFrame frame;
        String version;
        System.setProperty("sun.net.client.defaultReadTimeout", "7000");
        System.setProperty("sun.net.client.defaultConnectTimeout", "7000");
        URL url = null;
        if (0 != args.length) {
            try {
                if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("-h") || args[0].equalsIgnoreCase("?") || args[0].equalsIgnoreCase("-?")) {
                    Thumbelina.help();
                } else {
                    url = new URL(args[0]);
                }
            }
            catch (MalformedURLException murle) {
                System.err.println(murle.getMessage());
                Thumbelina.help();
            }
        }
        if ((version = System.getProperty("java.version")).startsWith("1.4") || version.startsWith("1.5")) {
            frame = new ThumbelinaFrame(url);
        } else {
            if (null == url) {
                Thumbelina.help();
            }
            System.out.println("Java version is only " + version + ", entering crippled mode");
            frame = new JFrame("Thumbelina");
            Thumbelina thumbelina = new Thumbelina(url);
            frame.getContentPane().add((Component)thumbelina, "Center");
            frame.setBounds(10, 10, 640, 480);
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent event) {
                    System.exit(0);
                }
            });
        }
        frame.setVisible(true);
    }

    public ArrayList getQueue() {
        return this.mUrls;
    }

    public int getQueueSize() {
        return this.mUrls.size();
    }

    class Tracker
    implements ImageObserver {
        protected URL mSource;

        public Tracker(URL source) {
            this.mSource = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
            boolean error;
            boolean done = 0 != (infoflags & 0x20);
            boolean abort = 0 != (infoflags & 0x80);
            boolean bl = error = 0 != (infoflags & 0x40);
            if (done || abort || error) {
                HashMap hashMap = Thumbelina.this.mTracked;
                synchronized (hashMap) {
                    URL url = (URL)Thumbelina.this.mTracked.remove(this.mSource.toExternalForm());
                    Thumbelina.this.mTracked.notify();
                    Thumbelina.this.mQueueProgress.setValue(Thumbelina.this.mTracked.size());
                    if (done) {
                        Thumbelina.this.mSequencer.add(image, this.mSource, null != url);
                    }
                }
            }
            return !done;
        }
    }

    class Enqueuer
    extends Thread {
        URL[] mList;

        public Enqueuer(URL[] list) {
            this.mList = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thumbelina.this.append(Thumbelina.this.filter(this.mList));
            ArrayList arrayList = mEnqueuers;
            synchronized (arrayList) {
                mEnqueuers.remove(this);
            }
        }
    }
}

