/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui.properties;

import net.sourceforge.phpdt.internal.debug.core.breakpoints.PHPLineBreakpoint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class PHPBreakpointPropertiesDialog
extends StatusDialog {
    private PHPLineBreakpoint fBreakpoint;
    private SourceViewer fSnippetViewer;
    private Button fCheckBox;
    private Spinner fSpinner;

    public PHPBreakpointPropertiesDialog(Shell parentShell, PHPLineBreakpoint bp) {
        super(parentShell);
        this.fBreakpoint = bp;
    }

    protected Control createDialogArea(Composite parent) {
        String condition = "";
        boolean enabled = false;
        int hitCount = 0;
        try {
            condition = this.fBreakpoint.getCondition();
            enabled = this.fBreakpoint.isConditionEnabled();
            hitCount = this.fBreakpoint.getHitCount();
        }
        catch (CoreException coreException) {}
        Font font = parent.getFont();
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText("Skip count");
        gd = new GridData(1);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fSpinner = new Spinner(container, 2048);
        this.fSpinner.setMinimum(0);
        this.fSpinner.setMaximum(100000);
        this.fSpinner.setIncrement(1);
        this.fSpinner.setPageIncrement(100);
        this.fSpinner.setSelection(hitCount);
        gd = new GridData(1);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        label = new Label(container, 0);
        label.setText("Break Condition");
        gd = new GridData(1);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fSnippetViewer = new SourceViewer(container, null, 2816);
        this.fSnippetViewer.setInput((Object)this);
        Document document = new Document();
        this.fSnippetViewer.configure(new SourceViewerConfiguration());
        this.fSnippetViewer.setEditable(true);
        this.fSnippetViewer.setDocument((IDocument)document);
        document.addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                PHPBreakpointPropertiesDialog.this.checkValues();
            }
        });
        this.fSnippetViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        Control control = this.fSnippetViewer.getControl();
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        control.setLayoutData((Object)gd);
        this.fSnippetViewer.getDocument().set(condition);
        this.fCheckBox = new Button(container, 16416);
        this.fCheckBox.setText("Enable Condition");
        this.fCheckBox.setSelection(enabled);
        this.fCheckBox.setFont(font);
        PHPBreakpointPropertiesDialog.applyDialogFont((Control)container);
        this.fSnippetViewer.getControl().setFocus();
        this.checkValues();
        return container;
    }

    protected void okPressed() {
        try {
            this.fBreakpoint.setCondition(this.fSnippetViewer.getDocument().get());
            this.fBreakpoint.setConditionEnabled(this.fCheckBox.getSelection());
            this.fBreakpoint.setHitCount(this.fSpinner.getSelection());
            int id = this.fBreakpoint.getChangeID();
            this.fBreakpoint.setChangeID(++id);
        }
        catch (CoreException coreException) {}
        super.okPressed();
    }

    private void checkValues() {
        StatusInfo status = new StatusInfo();
        this.updateStatus((IStatus)status);
    }
}

