/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui;

import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpdt.internal.debug.core.model.PHPValue;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiMessages;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiPlugin;
import net.sourceforge.phpdt.internal.ui.text.HTMLTextPresenter;
import net.sourceforge.phpdt.internal.ui.text.JavaWordFinder;
import net.sourceforge.phpdt.ui.PreferenceConstants;
import net.sourceforge.phpdt.ui.text.java.hover.IJavaEditorTextHover;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class PHPDebugHover
implements IJavaEditorTextHover,
ITextHoverExtension,
ISelectionListener,
IPartListener {
    protected IEditorPart fEditor;
    protected ISelection fSelection = null;
    static /* synthetic */ Class class$0;

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part.equals(this.fEditor)) {
            IWorkbenchPage page = this.fEditor.getSite().getPage();
            page.removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            page.removePartListener((IPartListener)this);
            this.fSelection = null;
            this.fEditor = null;
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.fSelection = selection;
    }

    public void setEditor(IEditorPart editor) {
        if (editor != null) {
            this.fEditor = editor;
            final IWorkbenchPage page = editor.getSite().getPage();
            page.addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
            page.addPartListener((IPartListener)this);
            Runnable r = new Runnable(){

                public void run() {
                    PHPDebugHover.this.fSelection = page.getSelection("org.eclipse.debug.ui.DebugView");
                }
            };
            PHPDebugUiPlugin.getStandardDisplay().asyncExec(r);
        }
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)offset);
    }

    protected PHPStackFrame getFrame() {
        Object el;
        IStructuredSelection selection;
        if (this.fSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)this.fSelection).size() == 1 && (el = selection.getFirstElement()) instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)el;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (PHPStackFrame)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        PHPStackFrame frame = this.getFrame();
        if (frame != null) {
            IDocument document;
            block8: {
                document = textViewer.getDocument();
                if (document != null) break block8;
                return null;
            }
            try {
                String variableName = document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                StringBuffer buffer = new StringBuffer();
                try {
                    IVariable variable = frame.findVariable(variableName);
                    if (variable != null) {
                        PHPDebugHover.appendVariable(buffer, variable);
                    }
                }
                catch (DebugException x) {
                    PHPDebugUiPlugin.log(x);
                }
                if (buffer.length() > 0) {
                    return buffer.toString();
                }
            }
            catch (BadLocationException x) {
                PHPDebugUiPlugin.log(x);
            }
        }
        return null;
    }

    private static void appendVariable(StringBuffer buffer, IVariable variable) throws DebugException {
        buffer.append("<p>");
        buffer.append("<pre>").append(variable.getName()).append("</pre>");
        buffer.append(" =");
        String type = PHPDebugHover.getTypeName(variable);
        String value = "<b><pre>" + variable.getValue().getValueString() + "</pre></b>";
        if (type == null) {
            buffer.append(" null");
        } else if (type.equals("java.lang.String")) {
            buffer.append(" \"");
            buffer.append(value);
            buffer.append('\"');
        } else if (type.equals("boolean")) {
            buffer.append(' ');
            buffer.append(value);
        } else {
            buffer.append(" (");
            buffer.append("<pre>").append(type).append("</pre>");
            buffer.append(") ");
            buffer.append(value);
        }
        buffer.append("</p>");
    }

    private static String getTypeName(IVariable variable) throws DebugException {
        IValue value = variable.getValue();
        if (value instanceof PHPValue) {
            return ((PHPValue)value).getReferenceTypeName();
        }
        return null;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), PHPDebugUiMessages.getString("JavaDebugHover.16"));
            }
        };
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (PreferenceConstants.getPreferenceStore().getBoolean("PreferenceConstants.EDITOR_SHOW_TEXT_HOVER_AFFORDANCE")) {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), PHPDebugUiMessages.getString("PHPDebugHover.16"));
                }
            };
        }
        return null;
    }
}

