/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.text;

import java.util.Map;
import net.sourceforge.phpeclipse.ui.text.AbstractTextTools;
import net.sourceforge.phpeclipse.xml.ui.internal.text.DeclScanner;
import net.sourceforge.phpeclipse.xml.ui.internal.text.SingleTokenScanner;
import net.sourceforge.phpeclipse.xml.ui.internal.text.TextScanner;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLPartitionScanner;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;

public class DTDTextTools
extends AbstractTextTools {
    private static final String[] TOKENS = new String[]{"xml_text", "xml_attribute", "xml_string", "xml_entity", "xml_processing_instruction", "xml_comment", "xml_declaration", "xml_conditional"};
    private static final String[] TYPES = new String[]{"__xml_processing_instruction", "__xml_comment", "__xml_declaration", "__dtd_conditional"};
    private XMLPartitionScanner dtdPartitionScanner = new XMLPartitionScanner(true);
    private TextScanner dtdTextScanner;
    private SingleTokenScanner dtdConditionalScanner;
    private SingleTokenScanner xmlPIScanner;
    private SingleTokenScanner xmlCommentScanner;
    private DeclScanner xmlDeclScanner;

    public DTDTextTools(IPreferenceStore store) {
        super(store, TOKENS);
        Map tokens = this.getTokens();
        this.dtdTextScanner = new TextScanner(tokens, '%', "xml_text");
        this.dtdConditionalScanner = new SingleTokenScanner(tokens, "xml_conditional");
        this.xmlPIScanner = new SingleTokenScanner(tokens, "xml_processing_instruction");
        this.xmlCommentScanner = new SingleTokenScanner(tokens, "xml_comment");
        this.xmlDeclScanner = new DeclScanner(tokens);
    }

    public IDocumentPartitioner createDTDPartitioner() {
        return new DefaultPartitioner((IPartitionTokenScanner)this.dtdPartitionScanner, TYPES);
    }

    public IPartitionTokenScanner getDTDPartitionScanner() {
        return this.dtdPartitionScanner;
    }

    public RuleBasedScanner getDTDTextScanner() {
        return this.dtdTextScanner;
    }

    public RuleBasedScanner getDTDConditionalScanner() {
        return this.dtdConditionalScanner;
    }

    public RuleBasedScanner getXMLPIScanner() {
        return this.xmlPIScanner;
    }

    public RuleBasedScanner getXMLCommentScanner() {
        return this.xmlCommentScanner;
    }

    public RuleBasedScanner getXMLDeclScanner() {
        return this.xmlDeclScanner;
    }
}

