/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLAnnotationIterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;

public class XMLAnnotationHover
implements IAnnotationHover {
    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List annotations = this.getAnnotationsForLine(sourceViewer, lineNumber);
        if (annotations != null) {
            ArrayList<String> messages = new ArrayList<String>();
            Iterator e = annotations.iterator();
            while (e.hasNext()) {
                Annotation annotation = (Annotation)e.next();
                String message = annotation.getText();
                if (message == null || (message = message.trim()).length() <= 0) continue;
                messages.add(message);
            }
            if (messages.size() == 1) {
                return (String)messages.get(0);
            }
            if (messages.size() > 1) {
                return this.formatMessages(messages);
            }
        }
        return null;
    }

    private String formatMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            buffer.append("- ");
            buffer.append(e.next());
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private List getAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<Annotation> retVal = new ArrayList<Annotation>();
        XMLAnnotationIterator e = new XMLAnnotationIterator(model, true);
        while (e.hasNext()) {
            Annotation a = (Annotation)e.next();
            Position position = model.getPosition(a);
            if (position == null) continue;
            try {
                int annotationLine = document.getLineOfOffset(position.getOffset());
                if (annotationLine != line) continue;
                retVal.add(a);
            }
            catch (BadLocationException badLocationException) {}
        }
        return retVal;
    }
}

